/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.htmlinfo;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.installer.util.PanelHelper;
import com.izforge.izpack.util.HyperlinkHandler;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

public class HTMLInfoPanel
extends IzPanel {
    private static final long serialVersionUID = 3257008769514025270L;
    private final String panelResourceName;
    private JEditorPane textArea;

    public HTMLInfoPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        this(panel, parent, installData, true, resources, log);
    }

    public HTMLInfoPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, boolean showInfoLabelFlag, Resources resources, Log log) {
        super(panel, parent, installData, new IzPanelLayout(log), resources);
        this.panelResourceName = PanelHelper.getPanelResourceName(panel, "info", resources);
        if (showInfoLabelFlag) {
            String titleMessageKey = PanelHelper.getPanelTitleMessageKey(panel, "info", installData);
            this.add((Component)LabelFactory.create(this.getString(titleMessageKey), (Icon)parent.getIcons().get("edit"), 10), "nextLine");
        }
        try {
            this.textArea = new JEditorPane(){
                private static final long serialVersionUID = 1L;

                @Override
                protected InputStream getStream(URL urlObj) throws IOException {
                    int b;
                    InputStream inStm = super.getStream(urlObj);
                    ByteArrayOutputStream btArrOutStm = new ByteArrayOutputStream();
                    byte[] buff = new byte[2048];
                    while ((b = inStm.read(buff, 0, buff.length)) > 0) {
                        btArrOutStm.write(buff, 0, b);
                    }
                    String parsedStr = HTMLInfoPanel.this.parseText(btArrOutStm.toString());
                    return new ByteArrayInputStream(parsedStr.getBytes());
                }
            };
            this.textArea.setName(GuiId.HTML_INFO_PANEL_TEXT.id);
            this.textArea.setContentType("text/html; charset=utf-8");
            this.textArea.setEditable(false);
            this.textArea.addHyperlinkListener(new HyperlinkHandler());
            JScrollPane scroller = new JScrollPane(this.textArea);
            this.textArea.setCaretPosition(0);
            this.add((Component)scroller, "nextLine");
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        this.getLayoutHelper().completeLayout();
    }

    private URL loadHTMLInfoContent() {
        try {
            return this.getResources().getURL(this.panelResourceName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isValidated() {
        return true;
    }

    @Override
    public void panelActivate() {
        this.textArea.getDocument().putProperty("stream", null);
        try {
            this.textArea.setPage(this.loadHTMLInfoContent());
            this.textArea.setCaretPosition(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

