/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.installer;

import com.izforge.izpack.api.data.InstallData;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

final class HandleHyperLinks
implements HyperlinkListener {
    private static final Logger LOG = Logger.getLogger(HandleHyperLinks.class.getName());
    private final InstallData installData;
    private final Consumer<URL> openBrowser;
    private final Consumer<Path> openPath;

    HandleHyperLinks(InstallData installData) {
        this(installData, HandleHyperLinks::desktopOpen, HandleHyperLinks::desktopOpen);
    }

    HandleHyperLinks(InstallData installData, Consumer<URL> openBrowser, Consumer<Path> openPath) {
        this.installData = installData;
        this.openBrowser = openBrowser;
        this.openPath = openPath;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL url = e.getURL();
            switch (url.getFile()) {
                case "install_dir": {
                    this.openPath.accept(Paths.get(this.installData.getInstallPath(), new String[0]));
                    break;
                }
                case "bin_dir": {
                    this.openPath.accept(Paths.get(this.installData.getInstallPath(), "bin"));
                    break;
                }
                case "logs_dir": {
                    this.openPath.accept(Paths.get(this.installData.getInstallPath(), "logs"));
                    break;
                }
                default: {
                    this.openBrowser.accept(url);
                }
            }
        }
    }

    private static void desktopOpen(Path path) {
        try {
            Desktop.getDesktop().open(path.toFile());
        }
        catch (IOException | IllegalArgumentException | UnsupportedOperationException e) {
            LOG.log(Level.WARNING, "Failed to open " + String.valueOf(path), e);
        }
    }

    private static void desktopOpen(URL argument) {
        try {
            Desktop.getDesktop().browse(argument.toURI());
        }
        catch (IOException | UnsupportedOperationException | URISyntaxException e) {
            LOG.log(Level.WARNING, "Failed to open " + String.valueOf(argument), e);
        }
    }
}

