/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.unpacker;

import com.izforge.izpack.api.data.ParsableFile;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Logger;

public class ScriptParser {
    private static final Logger logger = Logger.getLogger(ScriptParser.class.getName());
    private final VariableSubstitutor replacer;
    private final PlatformModelMatcher matcher;

    public ScriptParser(VariableSubstitutor replacer, PlatformModelMatcher matcher) {
        this.replacer = replacer;
        this.matcher = matcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(ParsableFile parsable) throws Exception {
        File parsedFile;
        if (!this.matcher.matchesCurrentPlatform(parsable.getOsConstraints())) {
            return;
        }
        File file = new File(parsable.getPath());
        logger.fine("Parsing and replacing variables in file " + file + "...");
        try {
            parsedFile = File.createTempFile("izpp", null, file.getParentFile());
        }
        catch (IOException exception) {
            throw new IOException("Failed to create temporary file for " + parsable.getPath() + " in directory " + file.getParentFile(), exception);
        }
        Reader reader = null;
        Writer writer = null;
        try {
            FileInputStream inFile = new FileInputStream(file);
            FileOutputStream outFile = new FileOutputStream(parsedFile);
            InputStreamReader inReader = parsable.getEncoding() != null ? new InputStreamReader((InputStream)inFile, parsable.getEncoding()) : new InputStreamReader(inFile);
            OutputStreamWriter outWriter = parsable.getEncoding() != null ? new OutputStreamWriter((OutputStream)outFile, parsable.getEncoding()) : new OutputStreamWriter(outFile);
            reader = new BufferedReader(inReader, 5120);
            writer = new BufferedWriter(outWriter, 5120);
            this.replacer.substitute(reader, writer, parsable.getType());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        if (!file.delete()) {
            throw new IOException("Failed to delete file: " + file);
        }
        if (!parsedFile.renameTo(file)) {
            throw new IOException("Could not rename file " + parsedFile + " to " + file);
        }
    }
}

