/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.handler;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.Configurable;
import com.izforge.izpack.api.data.ConfigurationOption;
import com.izforge.izpack.api.rules.RulesEngine;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public abstract class DefaultConfigurationHandler
implements Configurable,
Serializable {
    private static final long serialVersionUID = 2814753202801899378L;
    private static final Logger logger = Logger.getLogger(DefaultConfigurationHandler.class.getName());
    private Map<String, ConfigurationOption> configuration = null;

    @Override
    public void addConfigurationOption(String name, ConfigurationOption option) {
        if (this.configuration == null) {
            this.configuration = new HashMap<String, ConfigurationOption>();
        }
        this.configuration.put(name, option);
    }

    @Override
    public ConfigurationOption getConfigurationOption(String name) {
        ConfigurationOption option = null;
        if (this.configuration != null) {
            option = this.configuration.get(name);
        }
        return option;
    }

    @Override
    public String getConfigurationOptionValue(String name, RulesEngine rules, String defaultValue) {
        ConfigurationOption option = this.getConfigurationOption(name);
        String result = option != null ? option.getValue(rules) : defaultValue;
        return result;
    }

    @Override
    public String getConfigurationOptionValue(String name) {
        return this.getConfigurationOptionValue(name, null);
    }

    @Override
    public String getConfigurationOptionValue(String name, RulesEngine rules) {
        return this.getConfigurationOptionValue(name, rules, null);
    }

    @Override
    public Set<String> getNames() {
        return this.configuration != null ? this.configuration.keySet() : null;
    }

    public void readParameters(IXMLElement element) {
        List<IXMLElement> otherParams;
        IXMLElement configurationElement = element.getFirstChildNamed("configuration");
        if (configurationElement != null) {
            logger.fine("Found configuration section for '" + element.getName() + "' element");
            List<IXMLElement> params = configurationElement.getChildren();
            for (IXMLElement param : params) {
                String value;
                String name;
                String elementName = param.getName();
                if (elementName.equals("param")) {
                    name = param.getAttribute("name");
                    value = param.getAttribute("value");
                } else {
                    name = param.getName();
                    value = param.getContent();
                }
                ConfigurationOption option = new ConfigurationOption(value);
                logger.fine("-> Adding configuration option " + name + " (" + option + ")");
                this.addConfigurationOption(name, option);
            }
        }
        if (!(otherParams = element.getChildrenNamed("param")).isEmpty()) {
            logger.fine("Found deprecated nested <param> definition(s) for '" + element.getName() + "' element, please migrate them to the new <configuration> format");
            for (IXMLElement parameter : otherParams) {
                String name = parameter.getAttribute("name");
                String value = parameter.getAttribute("value");
                ConfigurationOption option = new ConfigurationOption(value);
                logger.fine("-> Adding configuration option " + name + " (" + option + ")");
                this.addConfigurationOption(name, option);
            }
        }
    }
}

