/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.data;

import com.izforge.izpack.api.data.Blockable;
import com.izforge.izpack.api.data.ExecutableFile;
import com.izforge.izpack.api.data.OverrideType;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackColor;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.data.ParsableFile;
import com.izforge.izpack.api.data.UpdateCheck;
import com.izforge.izpack.api.data.binding.OsModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PackInfo
implements Serializable {
    private static final long serialVersionUID = -3604642858885697783L;
    private final Pack pack;
    public transient PackColor colour;
    private final Map<PackFile, File> files = new LinkedHashMap<PackFile, File>();
    private final List<ParsableFile> parsables = new ArrayList<ParsableFile>();
    private final List<ExecutableFile> executables = new ArrayList<ExecutableFile>();
    private final List<UpdateCheck> updateChecks = new ArrayList<UpdateCheck>();

    public PackInfo(String name, String id, String description, boolean required, boolean loose, String excludegroup, boolean uninstall, long size) {
        boolean ispreselected = excludegroup == null;
        this.pack = new Pack(name, id, description, null, null, required, ispreselected, loose, excludegroup, uninstall, size);
        this.colour = PackColor.WHITE;
    }

    public void setOsConstraints(List<OsModel> osConstraints) {
        this.pack.setOsConstraints(osConstraints);
    }

    public void setPreselected(boolean preselected) {
        this.pack.setPreselected(preselected);
    }

    public void setGroup(String group) {
        this.pack.setGroup(group);
    }

    public void addInstallGroup(String group) {
        this.pack.getInstallGroups().add(group);
    }

    public Pack getPack() {
        return this.pack;
    }

    public void setHidden(boolean hidden) {
        this.pack.setHidden(hidden);
    }

    public void addFile(File baseDir, File file, String targetfile, List<OsModel> osList, OverrideType override, String overrideRenameTo, Blockable blockable, Map additionals, String condition, Map<String, String> pack200Properties) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        PackFile packFile = new PackFile(baseDir, file, targetfile, osList, override, overrideRenameTo, blockable, additionals, pack200Properties);
        packFile.setLoosePackInfo(this.pack.isLoose());
        packFile.setCondition(condition);
        this.files.put(packFile, file);
    }

    public Set<PackFile> getPackFiles() {
        return this.files.keySet();
    }

    public Map<PackFile, File> getPackFilesMap() {
        return this.files;
    }

    public File getFile(PackFile packFile) {
        return this.files.get(packFile);
    }

    public void addParsable(ParsableFile parsable) {
        this.parsables.add(parsable);
    }

    public List<ParsableFile> getParsables() {
        return this.parsables;
    }

    public void addExecutable(ExecutableFile executable) {
        this.executables.add(executable);
    }

    public List<ExecutableFile> getExecutables() {
        return this.executables;
    }

    public void addUpdateCheck(UpdateCheck updateCheck) {
        this.updateChecks.add(updateCheck);
    }

    public List<UpdateCheck> getUpdateChecks() {
        return this.updateChecks;
    }

    public void addDependency(String dependency) {
        this.pack.addDependency(dependency);
    }

    public List<String> getDependencies() {
        return this.pack.getDependencies();
    }

    public void setParent(String p) {
        this.pack.setParent(p);
    }

    public String toString() {
        return this.pack.getName();
    }

    public void setPackImgId(String packImgId) {
        this.pack.setImageId(packImgId);
    }

    public void setCondition(String condition) {
        this.pack.setCondition(condition);
    }

    public void addValidator(String validatorClassName) {
        this.pack.addValidator(validatorClassName);
    }

    public void addOnSelect(String name, String condition) {
        this.pack.setOnSelect(name, condition);
    }

    public void addOnDeselect(String name, String condition) {
        this.pack.setOnDeselect(name, condition);
    }
}

