(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.diffusion = f()}})(function(){var define,module,exports;
var createModuleFactory = function createModuleFactory(t){var e;return function(r){return e||t(e={exports:{},parent:r},e.exports),e.exports}};
var _$metricsServices_578 = createModuleFactory(function (module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.REMOVE_METRIC_ALERT = exports.LIST_METRIC_ALERTS = exports.SET_METRIC_ALERT = exports.GET_METRICS = exports.FETCH_JMX_VALUES = exports.LIST_TOPIC_METRIC_COLLECTORS = exports.REMOVE_TOPIC_METRIC_COLLECTOR = exports.PUT_TOPIC_METRIC_COLLECTOR = exports.GET_MEASURED_ENTITY_CLASS_METRICS = exports.GET_SERVER_METRICS = exports.LIST_SESSION_METRIC_COLLECTORS = exports.REMOVE_SESSION_METRIC_COLLECTOR = exports.PUT_SESSION_METRIC_COLLECTOR = void 0;
;
;
;
;
var metrics_request_serialiser_1 = _$metricsRequestSerialiser_567({});
;
;
;
;
;
;
;
;
;
;
;
exports.PUT_SESSION_METRIC_COLLECTOR = {
    id: 135,
    request: _$sessionMetricCollectorSerialiser_572.SessionMetricCollectorSerialiser,
    response: _$errorReportListSerialiser_506.ErrorReportListSerialiser
};
exports.REMOVE_SESSION_METRIC_COLLECTOR = {
    id: 136,
    request: _$stringSerialiser_431.StringSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
exports.LIST_SESSION_METRIC_COLLECTORS = {
    id: 137,
    request: _$serviceDefinition_623.NullSerialiser,
    response: _$sessionMetricCollectorListSerialiser_570.SessionMetricCollectorListSerialiser
};
exports.GET_SERVER_METRICS = {
    id: 142,
    request: _$serviceDefinition_623.NullSerialiser,
    response: _$serverMetricsSerialiser_585.ServerMetricsSerialiser
};
exports.GET_MEASURED_ENTITY_CLASS_METRICS = {
    id: 145,
    request: _$measuredEntityClassRequestSerialiser_583.MeasuredEntityClassRequestSerialiser,
    response: _$measuredEntityClassMetricsSerialiser_581.MeasuredEntityClassMetricsSerialiser
};
exports.PUT_TOPIC_METRIC_COLLECTOR = {
    id: 146,
    request: _$topicMetricCollectorSerialiser_576.TopicMetricCollectorSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
exports.REMOVE_TOPIC_METRIC_COLLECTOR = {
    id: 147,
    request: _$stringSerialiser_431.StringSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
exports.LIST_TOPIC_METRIC_COLLECTORS = {
    id: 148,
    request: _$serviceDefinition_623.NullSerialiser,
    response: _$topicMetricCollectorListSerialiser_574.TopicMetricCollectorListSerialiser
};
exports.FETCH_JMX_VALUES = {
    id: 149,
    request: _$jmxFetchRequestSerialiser_510.JMXFetchRequestSerialiser,
    response: _$jmxFetchResponseSerialiser_512.JMXFetchResponseSerialiser
};
exports.GET_METRICS = {
    id: 186,
    request: metrics_request_serialiser_1.MetricsRequestSerialiser,
    response: _$metricsResultSerialiser_568.MetricsResultSerialiser
};
exports.SET_METRIC_ALERT = {
    id: 187,
    request: _$setMetricAlertRequestSerialiser_586.SetMetricAlertRequestSerialiser,
    response: _$errorReportListSerialiser_506.ErrorReportListSerialiser
};
exports.LIST_METRIC_ALERTS = {
    id: 188,
    request: _$serviceDefinition_623.NullSerialiser,
    response: _$listMetricAlertsResultSerialiser_579.ListMetricAlertsResultSerialiser
};
exports.REMOVE_METRIC_ALERT = {
    id: 191,
    request: _$stringSerialiser_431.StringSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};

});
var _$metricsRequestSerialiser_567 = createModuleFactory(function (module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricsRequestSerialiser =  void 0;
var metrics_request_1 = _$metricsRequest_364({});
;
;
;
var MetricsRequestSerialiserClass =  (function (_super) {
    __extends(MetricsRequestSerialiserClass, _super);
    function MetricsRequestSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MetricsRequestSerialiserClass.prototype.write = function (bos, value) {
        _$codec_411.writeCollection(bos, __spreadArray([], __read(value.filters.values())), _$codec_411.writeString);
        _$codec_411.writeString(bos, value.pattern);
        _$byteEncodedEnumSerialiser_426.write(bos, value.requestType);
        if (value.requestType === metrics_request_1.RequestType.NAMED_SERVER) {
            _$codec_411.writeString(bos, value.server);
        }
    };
    return MetricsRequestSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void MetricsRequestSerialiserClass;
exports.MetricsRequestSerialiser = new MetricsRequestSerialiserClass();

});
var _$metricsRequest_364 = createModuleFactory(function (module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricsRequestImpl = exports.RequestType = void 0;
;
var Services = _$metricsServices_578({});
;
var RequestType;
(function (RequestType) {
    RequestType[RequestType["CURRENT_SERVER"] = 0] = "CURRENT_SERVER";
    RequestType[RequestType["ALL_SERVERS"] = 1] = "ALL_SERVERS";
    RequestType[RequestType["NAMED_SERVER"] = 2] = "NAMED_SERVER";
})(RequestType = exports.RequestType || (exports.RequestType = {}));
var MetricsRequestImpl =  (function () {
    function MetricsRequestImpl(filters, pattern, server, requestType, internal) {
        this.theFilters = filters;
        this.pattern = pattern;
        this.theServer = server;
        this.theRequestType = requestType;
        this.internal = internal;
    }
    MetricsRequestImpl.create = function (internal) {
        return new MetricsRequestImpl(new Set(), undefined, undefined, RequestType.ALL_SERVERS, internal);
    };
    MetricsRequestImpl.prototype.filter = function (newFilters) {
        _$requireNonNull_759.requireNonNull(newFilters, 'filters');
        if (typeof newFilters === 'string' || newFilters instanceof RegExp) {
            return new MetricsRequestImpl(new Set(), newFilters instanceof RegExp ? newFilters.source : newFilters, this.theServer, this.theRequestType, this.internal);
        }
        else {
            return new MetricsRequestImpl(new Set(newFilters), undefined, this.theServer, this.theRequestType, this.internal);
        }
    };
    MetricsRequestImpl.prototype.server = function (newServer) {
        _$requireNonNull_759.requireNonNull(newServer, 'server');
        if (newServer === '') {
            throw new _$errors_280.IllegalArgumentError('server must not be empty');
        }
        return new MetricsRequestImpl(this.theFilters, this.pattern, newServer, RequestType.NAMED_SERVER, this.internal);
    };
    MetricsRequestImpl.prototype.currentServer = function () {
        return new MetricsRequestImpl(this.theFilters, this.pattern, undefined, RequestType.CURRENT_SERVER, this.internal);
    };
    MetricsRequestImpl.prototype.fetch = function () {
        var _this = this;
        var _a;
        var request = {
            filters: this.theFilters,
            pattern: (_a = this.pattern) !== null && _a !== void 0 ? _a : '',
            server: this.theServer,
            requestType: this.theRequestType
        };
        return new Promise(function (resolve, reject) {
            if (_this.internal.checkConnected(reject)) {
                var GET_METRICS = _this.internal.getServiceLocator().obtain(Services.GET_METRICS);
                GET_METRICS.send(request, function (err, response) {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve(response);
                    }
                });
            }
        });
    };
    return MetricsRequestImpl;
}());
exports.MetricsRequestImpl = MetricsRequestImpl;

});
var _$gatewayControl_360 = createModuleFactory(function (module, exports) {
"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GatewayControlImpl = exports.ConfigurationMode = exports.StatusLevel = void 0;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
var GatewayServices = _$gatewayServices_559({});
;
var StatusLevel;
(function (StatusLevel) {
    StatusLevel[StatusLevel["GREEN"] = 0] = "GREEN";
    StatusLevel[StatusLevel["AMBER"] = 1] = "AMBER";
    StatusLevel[StatusLevel["RED"] = 2] = "RED";
})(StatusLevel = exports.StatusLevel || (exports.StatusLevel = {}));
var ConfigurationMode;
(function (ConfigurationMode) {
    ConfigurationMode[ConfigurationMode["STATIC"] = 0] = "STATIC";
    ConfigurationMode[ConfigurationMode["DYNAMIC"] = 1] = "DYNAMIC";
})(ConfigurationMode = exports.ConfigurationMode || (exports.ConfigurationMode = {}));
var GatewayControlImpl =  (function () {
    function GatewayControlImpl(internal) {
        this.internal = internal;
        this.clientRequestsService = internal.getServiceLocator().obtain(GatewayServices.GATEWAY_CLIENT_REQUEST);
        this.getClientsService = internal.getServiceLocator().obtain(GatewayServices.GET_GATEWAY_CLIENTS);
        this.getClientDetailsService = internal.getServiceLocator().obtain(GatewayServices.GET_GATEWAY_CLIENT_DETAILS);
        this.registerClientService = internal.getServiceLocator().obtain(GatewayServices.REGISTER_GATEWAY_CLIENT);
        this.removeClientService = internal.getServiceLocator().obtain(GatewayServices.REMOVE_GATEWAY_CLIENT);
    }
    GatewayControlImpl.prototype.checkSessionId = function (sessionId) {
        if (sessionId instanceof _$sessionId_709.SessionId) {
            return sessionId;
        }
        else if (typeof sessionId === 'string') {
            return _$sessionId_709.SessionId.fromString(sessionId);
        }
        else if (sessionId === null) {
            throw new _$errors_280.IllegalArgumentError("Session ID must be a string or instance of SessionId, but was null");
        }
        throw new _$errors_280.IllegalArgumentError("Session ID must be a string or instance of SessionId, but was of type: " + typeof sessionId);
    };
    GatewayControlImpl.prototype.checkClientKey = function (clientKey) {
        if (clientKey === null || clientKey === undefined || typeof clientKey !== 'object') {
            throw new _$errors_280.IllegalArgumentError("clientKey must be a non-null object");
        }
        else if (clientKey.type === null || clientKey.type === undefined) {
            throw new _$errors_280.IllegalArgumentError("clientKey type must not be null or undefined");
        }
        else if (clientKey.id === null || clientKey.id === undefined) {
            throw new _$errors_280.IllegalArgumentError("clientKey id must not be null or undefined");
        }
        return clientKey;
    };
    GatewayControlImpl.prototype.checkOperationName = function (operationName) {
        return this.checkStringArgument(operationName, 'Operation name');
    };
    GatewayControlImpl.prototype.checkStringArgument = function (argument, argName) {
        if (typeof argument === 'string') {
            return argument;
        }
        else if (argument === null) {
            throw new _$errors_280.IllegalArgumentError(argName + " must be a string, but was null");
        }
        throw new _$errors_280.IllegalArgumentError(argName + " must be a string, but was of type: " + typeof argument);
    };
    GatewayControlImpl.prototype.checkServiceId = function (serviceId) {
        return {
            name: this.checkStringArgument(serviceId.name, 'Service ID name'),
            type: this.checkStringArgument(serviceId.type, 'Service ID type')
        };
    };
    GatewayControlImpl.prototype.checkServiceHandle = function (serviceHandle) {
        return __assign(__assign({}, this.checkServiceId(serviceHandle)), { sessionId: this.checkSessionId(serviceHandle.sessionId) });
    };
    GatewayControlImpl.prototype.sessionContextTransformer = function (sessionId) {
        return function (gsi) {
            return (__assign(__assign({}, gsi), { id: __assign(__assign({}, gsi.id), { sessionId: sessionId }) }));
        };
    };
    GatewayControlImpl.prototype.getConfiguration = function (sessionId) {
        var _this = this;
        var sid = this.checkSessionId(sessionId);
        return new Promise(function (resolve, reject) {
            if (_this.internal.checkConnected(reject)) {
                _this.clientRequestsService.send(new _$gatewayClientGetConfigurationRequest_527.GatewayClientGetConfigurationRequest(sid), function (err, response) {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve(response);
                    }
                });
            }
        });
    };
    GatewayControlImpl.prototype.getStatus = function (sessionId) {
        var _this = this;
        var sid = this.checkSessionId(sessionId);
        return new Promise(function (resolve, reject) {
            if (_this.internal.checkConnected(reject)) {
                _this.clientRequestsService.send(new _$gatewayClientGetStatusRequest_530.GatewayClientGetStatusRequest(sid), function (err, response) {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve(response);
                    }
                });
            }
        });
    };
    GatewayControlImpl.prototype.getClients = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            if (_this.internal.checkConnected(reject)) {
                _this.getClientsService.send(null, function (err, response) {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve(response);
                    }
                });
            }
        });
    };
    GatewayControlImpl.prototype.getClientDetailList = function (request) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            if (_this.internal.checkConnected(reject)) {
                _this.getClientDetailsService.send(request, function (err, response) {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve(response);
                    }
                });
            }
        });
    };
    GatewayControlImpl.prototype.registerClient = function (clientKey) {
        var _this = this;
        var key = this.checkClientKey(clientKey);
        return new Promise(function (resolve, reject) {
            if (_this.internal.checkConnected(reject)) {
                _this.registerClientService.send(key, function (err) {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve();
                    }
                });
            }
        });
    };
    GatewayControlImpl.prototype.removeClient = function (clientKey) {
        var _this = this;
        var key = this.checkClientKey(clientKey);
        return new Promise(function (resolve, reject) {
            if (_this.internal.checkConnected(reject)) {
                _this.removeClientService.send(key, function (err) {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve();
                    }
                });
            }
        });
    };
    GatewayControlImpl.prototype.getOperations = function (sessionId) {
        var _this = this;
        var sid = this.checkSessionId(sessionId);
        return new Promise(function (resolve, reject) {
            if (_this.internal.checkConnected(reject)) {
                _this.clientRequestsService.send(new _$gatewayClientGetOperationsRequest_542.GatewayClientGetOperationsRequest(sid), function (err, response) {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve(response);
                    }
                });
            }
        });
    };
    GatewayControlImpl.prototype.getOperationDetail = function (sessionId, operationName) {
        var _this = this;
        var sid = this.checkSessionId(sessionId);
        var opName = this.checkOperationName(operationName);
        return new Promise(function (resolve, reject) {
            if (_this.internal.checkConnected(reject)) {
                _this.clientRequestsService.send(new _$gatewayClientGetOperationDetailRequest_541.GatewayClientGetOperationDetailRequest(sid, opName), function (err, response) {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve(response);
                    }
                });
            }
        });
    };
    GatewayControlImpl.prototype.invokeOperation = function (sessionId, operationName, input) {
        var _this = this;
        var sid = this.checkSessionId(sessionId);
        var opName = this.checkOperationName(operationName);
        var opInput = input === null ? undefined : input;
        return new Promise(function (resolve, reject) {
            if (_this.internal.checkConnected(reject)) {
                _this.clientRequestsService.send(new _$gatewayClientInvokeOperationRequest_543.GatewayClientInvokeOperationRequest(sid, opName, opInput), function (err, response) {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve(response);
                    }
                });
            }
        });
    };
    GatewayControlImpl.prototype.getServiceTypes = function (sessionId) {
        var _this = this;
        var sid = this.checkSessionId(sessionId);
        return new Promise(function (resolve, reject) {
            if (_this.internal.checkConnected(reject)) {
                _this.clientRequestsService.send(new _$gatewayClientGetServiceTypesRequest_528.GatewayClientGetServiceTypesRequest(sid), function (err, response) {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve(response.serviceTypes);
                    }
                });
            }
        });
    };
    GatewayControlImpl.prototype.getServices = function (sessionId) {
        var _this = this;
        var sid = this.checkSessionId(sessionId);
        return new Promise(function (resolve, reject) {
            if (_this.internal.checkConnected(reject)) {
                _this.clientRequestsService.send(new _$gatewayClientGetServicesRequest_529.GatewayClientGetServicesRequest(sid), function (err, response) {
                    if (err) {
                        reject(err);
                    }
                    else {
                        var addSessionId = _this.sessionContextTransformer(sid);
                        resolve(response.services.map(addSessionId));
                    }
                });
            }
        });
    };
    GatewayControlImpl.prototype.addService = function (sessionId, newServiceId, description, configuration) {
        var _this = this;
        var sid = this.checkSessionId(sessionId);
        var serviceId = this.checkServiceId(newServiceId);
        var desc = this.checkStringArgument(description, 'Service description');
        var conf = this.checkStringArgument(configuration, 'Service configuration');
        var newService = {
            id: serviceId,
            description: desc,
            configuration: conf
        };
        return new Promise(function (resolve, reject) {
            if (_this.internal.checkConnected(reject)) {
                _this.clientRequestsService.send(new _$gatewayClientAddServiceRequest_522.GatewayClientAddServiceRequest(sid, newService), function (err, response) {
                    if (err) {
                        reject(err);
                    }
                    else {
                        var addSessionId = _this.sessionContextTransformer(sid);
                        resolve(addSessionId(response.service));
                    }
                });
            }
        });
    };
    GatewayControlImpl.prototype.updateService = function (serviceId, description, configuration) {
        var _this = this;
        var _a = this.checkServiceHandle(serviceId), sessionId = _a.sessionId, svcId = __rest(_a, ["sessionId"]);
        if ((description === null || description === undefined)
            && (configuration === null || configuration === undefined)) {
            return Promise.reject(new Error('Missing parameter: you must provide configuration or description (or both) when calling updateService'));
        }
        var newService = {
            id: svcId,
            description: description,
            configuration: configuration
        };
        return new Promise(function (resolve, reject) {
            if (_this.internal.checkConnected(reject)) {
                _this.clientRequestsService.send(new _$gatewayClientUpdateServiceRequest_534.GatewayClientUpdateServiceRequest(sessionId, newService), function (err, response) {
                    if (err) {
                        reject(err);
                    }
                    else {
                        var addSessionId = _this.sessionContextTransformer(sessionId);
                        resolve(addSessionId(response.service));
                    }
                });
            }
        });
    };
    GatewayControlImpl.prototype.removeService = function (serviceId) {
        var _this = this;
        var _a = this.checkServiceHandle(serviceId), sessionId = _a.sessionId, svcId = __rest(_a, ["sessionId"]);
        return new Promise(function (resolve, reject) {
            if (_this.internal.checkConnected(reject)) {
                _this.clientRequestsService.send(new _$removeServiceRequest_549.GatewayClientRemoveServiceRequest(sessionId, svcId), function (err, response) {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve();
                    }
                });
            }
        });
    };
    GatewayControlImpl.prototype.getServiceStatus = function (serviceId) {
        var _this = this;
        var _a = this.checkServiceHandle(serviceId), sessionId = _a.sessionId, svcId = __rest(_a, ["sessionId"]);
        return new Promise(function (resolve, reject) {
            if (_this.internal.checkConnected(reject)) {
                _this.clientRequestsService.send(new _$serviceGetStatusRequest_554.GatewayServiceGetStatusRequest(sessionId, svcId), function (err, response) {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve(response);
                    }
                });
            }
        });
    };
    GatewayControlImpl.prototype.getServiceConfiguration = function (serviceId) {
        var _this = this;
        var _a = this.checkServiceHandle(serviceId), sessionId = _a.sessionId, svcId = __rest(_a, ["sessionId"]);
        return new Promise(function (resolve, reject) {
            if (_this.internal.checkConnected(reject)) {
                _this.clientRequestsService.send(new _$serviceGetConfigurationRequest_551.GatewayServiceGetConfigurationRequest(sessionId, svcId), function (err, response) {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve(response);
                    }
                });
            }
        });
    };
    GatewayControlImpl.prototype.getServiceOperations = function (serviceId) {
        var _this = this;
        var _a = this.checkServiceHandle(serviceId), sessionId = _a.sessionId, svcId = __rest(_a, ["sessionId"]);
        return new Promise(function (resolve, reject) {
            if (_this.internal.checkConnected(reject)) {
                _this.clientRequestsService.send(new _$serviceGetOperationsRequest_553.GatewayServiceGetOperationsRequest(sessionId, svcId), function (err, response) {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve(response);
                    }
                });
            }
        });
    };
    GatewayControlImpl.prototype.getServiceOperationDetail = function (serviceId, operationName) {
        var _this = this;
        var _a = this.checkServiceHandle(serviceId), sessionId = _a.sessionId, svcId = __rest(_a, ["sessionId"]);
        var opName = this.checkOperationName(operationName);
        return new Promise(function (resolve, reject) {
            if (_this.internal.checkConnected(reject)) {
                _this.clientRequestsService.send(new _$serviceGetOperationDetailRequest_552.GatewayServiceGetOperationDetailRequest(sessionId, svcId, opName), function (err, response) {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve(response);
                    }
                });
            }
        });
    };
    GatewayControlImpl.prototype.invokeServiceOperation = function (serviceId, operationName, input) {
        var _this = this;
        var _a = this.checkServiceHandle(serviceId), sessionId = _a.sessionId, svcId = __rest(_a, ["sessionId"]);
        var opName = this.checkOperationName(operationName);
        var opInput = input === null ? undefined : input;
        return new Promise(function (resolve, reject) {
            if (_this.internal.checkConnected(reject)) {
                _this.clientRequestsService.send(new _$serviceInvokeOperationRequest_556.GatewayServiceInvokeOperationRequest(sessionId, svcId, opName, opInput), function (err, response) {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve(response);
                    }
                });
            }
        });
    };
    return GatewayControlImpl;
}());
exports.GatewayControlImpl = GatewayControlImpl;

});
var _$gatewayServices_559 = createModuleFactory(function (module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GET_GATEWAY_CLIENT_DETAILS = exports.GET_GATEWAY_CLIENTS = exports.REMOVE_GATEWAY_CLIENT = exports.REGISTER_GATEWAY_CLIENT = exports.GATEWAY_CLIENT_REQUEST = void 0;
;
var gateway_client_detail_list_serialiser_1 = _$gatewayClientDetailListSerialiser_525({});
;
;
;
var gateway_response_serialiser_1 = _$gatewayResponseSerialiser_536({});
;
exports.GATEWAY_CLIENT_REQUEST = {
    id: 170,
    request: _$gatewayClientRequestSerialiser_533.GatewayClientRequestSerialiser,
    response: gateway_response_serialiser_1.GatewayResponseSerialiser
};
exports.REGISTER_GATEWAY_CLIENT = {
    id: 173,
    request: _$gatewayClientKeySerialiser_531.GatewayClientKeySerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
exports.REMOVE_GATEWAY_CLIENT = {
    id: 174,
    request: _$gatewayClientKeySerialiser_531.GatewayClientKeySerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
exports.GET_GATEWAY_CLIENTS = {
    id: 175,
    request: _$serviceDefinition_623.NullSerialiser,
    response: _$gatewayClientListSerialiser_532.GatewayClientListSerialiser
};
exports.GET_GATEWAY_CLIENT_DETAILS = {
    id: 185,
    request: _$gatewayClientDetailListRequestSerialiser_524.GatewayClientDetailListRequestSerialiser,
    response: gateway_client_detail_list_serialiser_1.GatewayClientDetailListSerialiser
};

});
var _$gatewayResponseSerialiser_536 = createModuleFactory(function (module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.GatewayResponseSerialiser =  void 0;
;
;
;
;
;
;
;
;
;
;
var status_item_serialiser_1 = _$statusItemSerialiser_558({});
;
;
;
;
;
;
var GatewayResponseSerialiserClass =  (function (_super) {
    __extends(GatewayResponseSerialiserClass, _super);
    function GatewayResponseSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    GatewayResponseSerialiserClass.prototype.read = function (bis) {
        var type = _$byteEncodedEnumSerialiser_426.read(bis, _$gatewayRequestType_535.GatewayRequestType);
        switch (type) {
            case _$gatewayRequestType_535.GatewayRequestType.GET_CONFIGURATION:
            case _$gatewayRequestType_535.GatewayRequestType.GET_SERVICE_CONFIGURATION:
                return new _$getConfigurationResponse_537.GetConfigurationResponse(type, _$codec_411.readByte(bis), _$codec_411.readString(bis), _$codec_411.readString(bis));
            case _$gatewayRequestType_535.GatewayRequestType.GET_STATUS:
            case _$gatewayRequestType_535.GatewayRequestType.GET_SERVICE_STATUS:
                return new _$getStatusResponse_540.GetStatusResponse(type, _$codec_411.readCollection(bis, status_item_serialiser_1.StatusItemSerialiser.read));
            case _$gatewayRequestType_535.GatewayRequestType.GET_OPERATIONS:
            case _$gatewayRequestType_535.GatewayRequestType.GET_SERVICE_OPERATIONS:
                return new _$getOperationsResponse_545.GetOperationsResponse(type, _$codec_411.readCollection(bis, _$operationSerialiser_547.GatewayOperationSerialiser.read));
            case _$gatewayRequestType_535.GatewayRequestType.GET_OPERATION_DETAIL:
            case _$gatewayRequestType_535.GatewayRequestType.GET_SERVICE_OPERATION_DETAIL:
                return new _$getOperationDetailResponse_544.GetOperationDetailResponse(type, _$codec_411.readString(bis), _$codec_411.readOptional(bis, _$codec_411.readString), _$codec_411.readOptional(bis, _$codec_411.readString));
            case _$gatewayRequestType_535.GatewayRequestType.INVOKE_OPERATION:
            case _$gatewayRequestType_535.GatewayRequestType.INVOKE_SERVICE_OPERATION:
                return new _$invokeOperationResponse_546.InvokeOperationResponse(type, _$codec_411.readOptional(bis, _$codec_411.readString));
            case _$gatewayRequestType_535.GatewayRequestType.ADD_SERVICE:
            case _$gatewayRequestType_535.GatewayRequestType.UPDATE_SERVICE:
                return new _$addUpdateServiceResponse_520.AddUpdateServiceResponse(type, _$serviceDetailSerialiser_550.GatewayServiceSerialiser.read(bis));
            case _$gatewayRequestType_535.GatewayRequestType.GET_SERVICES:
                return new _$getServicesResponse_539.GetServicesResponse(_$codec_411.readCollection(bis, _$serviceDetailSerialiser_550.GatewayServiceSerialiser.read));
            case _$gatewayRequestType_535.GatewayRequestType.GET_SERVICE_TYPES:
                return new _$getServiceTypesResponse_538.GetServiceTypesResponse(_$codec_411.readCollection(bis, _$serviceTypeSerialiser_557.GatewayServiceTypeSerialiser.read));
            case _$gatewayRequestType_535.GatewayRequestType.REMOVE_SERVICE:
                return { type: type };
            default:
                throw new _$gatewayClientRequestSerialiser_533.UnknownGatewayRequestTypeError(type);
        }
    };
    return GatewayResponseSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void GatewayResponseSerialiserClass;
exports.GatewayResponseSerialiser = new GatewayResponseSerialiserClass();

});
var _$statusItemSerialiser_558 = createModuleFactory(function (module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.StatusItemSerialiser =  void 0;
var gateway_control_1 = _$gatewayControl_360({});
;
;
;
var StatusItemSerialiserClass =  (function (_super) {
    __extends(StatusItemSerialiserClass, _super);
    function StatusItemSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    StatusItemSerialiserClass.prototype.read = function (bis) {
        var level = _$byteEncodedEnumSerialiser_426.read(bis, gateway_control_1.StatusLevel);
        var timestamp = _$codec_411.readInt64(bis);
        var title = _$codec_411.readString(bis);
        var description = _$codec_411.readString(bis);
        return {
            level: level,
            timestamp: timestamp,
            title: title,
            description: description
        };
    };
    return StatusItemSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void StatusItemSerialiserClass;
exports.StatusItemSerialiser = new StatusItemSerialiserClass();

});
var _$gatewayClientDetailListSerialiser_525 = createModuleFactory(function (module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.GatewayClientDetailListSerialiser =  void 0;
;
;
var gateway_client_detail_serialiser_1 = _$gatewayClientDetailSerialiser_526({});
var GatewayClientDetailListSerialiserClass =  (function (_super) {
    __extends(GatewayClientDetailListSerialiserClass, _super);
    function GatewayClientDetailListSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    GatewayClientDetailListSerialiserClass.prototype.read = function (bis) {
        return {
            gatewayClientDetails: _$codec_411.readCollection(bis, gateway_client_detail_serialiser_1.GatewayClientDetailSerialiser.read)
        };
    };
    return GatewayClientDetailListSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void GatewayClientDetailListSerialiserClass;
exports.GatewayClientDetailListSerialiser = new GatewayClientDetailListSerialiserClass();

});
var _$gatewayClientDetailSerialiser_526 = createModuleFactory(function (module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.GatewayClientDetailSerialiser =  void 0;
;
;
var gateway_client_connected_client_details_serialiser_1 = _$gatewayClientConnectedClientDetailsSerialiser_523({});
;
var GatewayClientDetailSerialiserClass =  (function (_super) {
    __extends(GatewayClientDetailSerialiserClass, _super);
    function GatewayClientDetailSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    GatewayClientDetailSerialiserClass.prototype.read = function (bis) {
        var key = _$gatewayClientKeySerialiser_531.GatewayClientKeySerialiser.read(bis);
        var connectedClientDetails = _$codec_411.readOptional(bis, gateway_client_connected_client_details_serialiser_1.GatewayClientConnectedClientDetailsSerialiser.read);
        return {
            key: key,
            connectedClientDetails: connectedClientDetails
        };
    };
    return GatewayClientDetailSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void GatewayClientDetailSerialiserClass;
exports.GatewayClientDetailSerialiser = new GatewayClientDetailSerialiserClass();

});
var _$gatewayClientConnectedClientDetailsSerialiser_523 = createModuleFactory(function (module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.GatewayClientConnectedClientDetailsSerialiser =  void 0;
var gateway_control_1 = _$gatewayControl_360({});
;
;
;
var GatewayClientConnectedClientDetailsSerialiserClass =  (function (_super) {
    __extends(GatewayClientConnectedClientDetailsSerialiserClass, _super);
    function GatewayClientConnectedClientDetailsSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    GatewayClientConnectedClientDetailsSerialiserClass.prototype.read = function (bis) {
        var activeSessionId = _$codec_411.readOptional(bis, _$codec_411.readString);
        var passiveSessionIds = _$codec_411.readCollection(bis, _$codec_411.readString);
        var configurationMode = _$codec_411.readOptional(bis, function (istream) { return _$byteEncodedEnumSerialiser_426.read(istream, gateway_control_1.ConfigurationMode); });
        return {
            activeSessionId: activeSessionId,
            passiveSessionIds: passiveSessionIds,
            configurationMode: configurationMode
        };
    };
    return GatewayClientConnectedClientDetailsSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void GatewayClientConnectedClientDetailsSerialiserClass;
exports.GatewayClientConnectedClientDetailsSerialiser = new GatewayClientConnectedClientDetailsSerialiserClass();

});
var _$datatypes_324 = createModuleFactory(function (module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataTypes =  void 0;
;
;
;
;
;
;
;
;
;
;
;
;
var time_series_event_datatype_1 = _$timeSeriesEventDatatype_713({});
;
;
var DataTypesImpl =  (function () {
    function DataTypesImpl() {
        this.recordv2Impl = new _$recordv2DatatypeImpl_341.RecordV2DataTypeImpl();
        this.binaryImpl = new _$binaryDatatypeImpl_318.BinaryDataTypeImpl();
        this.stringImpl = new _$stringDatatypeImpl_336.StringDataTypeImpl();
        this.doubleImpl = new _$doubleDatatypeImpl_332.DoubleDataTypeImpl();
        this.int64Impl = new _$int64DatatypeImpl_333.Int64DataTypeImpl();
        this.jsonImpl = new _$jsonDatatypeImpl_326.JSONDataTypeImpl();
        this.anyImpl = new _$anyDatatype_317.AnyDataTypeImpl();
    }
    DataTypesImpl.prototype.binary = function () {
        return this.binaryImpl;
    };
    DataTypesImpl.prototype.string = function () {
        return this.stringImpl;
    };
    DataTypesImpl.prototype.double = function () {
        return this.doubleImpl;
    };
    DataTypesImpl.prototype.int64 = function () {
        return this.int64Impl;
    };
    DataTypesImpl.prototype.json = function () {
        return this.jsonImpl;
    };
    DataTypesImpl.prototype.recordv2 = function () {
        return this.recordv2Impl;
    };
    DataTypesImpl.prototype.any = function () {
        return this.anyImpl;
    };
    DataTypesImpl.prototype.timeseries = function (valueType) {
        return time_series_event_datatype_1.TimeSeriesEventDataType.create(valueType);
    };
    DataTypesImpl.prototype.getByName = function (name) {
        switch (name.toLowerCase()) {
            case 'json':
                return this.json();
            case 'int64':
                return this.int64();
            case 'binary':
                return this.binary();
            case 'string':
                return this.string();
            case 'double':
                return this.double();
            case 'record_v2':
                return this.recordv2();
            default:
                return undefined;
        }
    };
    DataTypesImpl.prototype.getByValue = function (value) {
        if (value === _$topicType_784.TopicType.BINARY || value instanceof _$binaryImpl_321.BinaryImpl || _$uint8array_762.isUint8Array(value)) {
            return this.binary();
        }
        if (value === _$topicType_784.TopicType.JSON
            || value instanceof _$jsonImpl_328.JSONImpl
            || value.constructor === Object
            || typeof value === 'boolean') {
            return this.json();
        }
        if (value === _$topicType_784.TopicType.STRING || typeof value === 'string') {
            return this.string();
        }
        if (value === _$topicType_784.TopicType.INT64 || value instanceof _$int64Impl_334.Int64Impl) {
            return this.int64();
        }
        if (value === _$topicType_784.TopicType.RECORD_V2 || value instanceof _$recordv2Impl_343.RecordV2Impl) {
            return this.recordv2();
        }
        if (value === _$topicType_784.TopicType.DOUBLE || typeof value === 'number') {
            return this.double();
        }
        return undefined;
    };
    DataTypesImpl.prototype.get = function (type) {
        var datatype;
        if (typeof type === 'string') {
            datatype = this.getByName(type);
        }
        if (!datatype) {
            datatype = this.getByValue(type);
        }
        if (!datatype) {
            datatype = this.getByClassSafely(type);
        }
        return datatype ? datatype : null;
    };
    DataTypesImpl.prototype.getChecked = function (type) {
        if (type === null || type === undefined) {
            throw new _$errors_280.IllegalArgumentError("No data type for " + type);
        }
        if (type instanceof _$recordv2DatatypeImpl_341.RecordV2DataTypeImpl ||
            type instanceof _$binaryDatatypeImpl_318.BinaryDataTypeImpl ||
            type instanceof _$stringDatatypeImpl_336.StringDataTypeImpl ||
            type instanceof _$doubleDatatypeImpl_332.DoubleDataTypeImpl ||
            type instanceof _$int64DatatypeImpl_333.Int64DataTypeImpl ||
            type instanceof _$jsonDatatypeImpl_326.JSONDataTypeImpl) {
            return type;
        }
        var datatype = this.get(type);
        if (datatype === null) {
            throw new _$errors_280.IllegalArgumentError("No data type for " + type);
        }
        return datatype;
    };
    DataTypesImpl.prototype.getValueClassChecked = function (type) {
        var datatype = this.getChecked(type);
        switch (datatype) {
            case this.jsonImpl:
                return _$jsonImpl_328.JSONImpl;
            case this.binaryImpl:
                return _$binaryImpl_321.BinaryImpl;
            case this.stringImpl:
                return String;
            case this.doubleImpl:
                return Number;
            case this.int64Impl:
                return _$int64Impl_334.Int64Impl;
            case this.recordv2Impl:
                return _$recordv2Impl_343.RecordV2Impl;
            default:
                return undefined;
        }
    };
    DataTypesImpl.prototype.getByClassSafely = function (valueClass) {
        switch (valueClass) {
            case _$jsonImpl_328.JSONImpl:
                return this.jsonImpl;
            case _$binaryImpl_321.BinaryImpl:
                return this.binaryImpl;
            case String:
                return this.stringImpl;
            case Number:
                return this.doubleImpl;
            case _$int64Impl_334.Int64Impl:
                return this.int64Impl;
            case _$recordv2Impl_343.RecordV2Impl:
                return this.recordv2Impl;
            default:
                return undefined;
        }
    };
    DataTypesImpl.prototype.getByClass = function (valueClass) {
        var datatype = this.getByClassSafely(valueClass);
        if (!datatype) {
            throw new _$errors_280.IllegalArgumentError("No data type for " + valueClass);
        }
        else {
            return datatype;
        }
    };
    return DataTypesImpl;
}());
 void DataTypesImpl;
var DataTypesSingleton = new DataTypesImpl();
exports.DataTypes = DataTypesSingleton;

});
var _$timeSeriesEventDatatype_713 = createModuleFactory(function (module, exports) {
(function (Buffer){(function (){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeSeriesEventDataType = void 0;
;
;
;
;
var datatypes_1 = _$datatypes_324({});
;
;
;
;
;
var EventType;
(function (EventType) {
    EventType[EventType["ORIGINAL_EVENT"] = 0] = "ORIGINAL_EVENT";
    EventType[EventType["EDIT_EVENT"] = 1] = "EDIT_EVENT";
})(EventType || (EventType = {}));
function eventToBytes(valueToBytes, event) {
    if (!event) {
        throw new _$errors_280.IllegalArgumentError('Cannot convert null event to Bytes');
    }
    return new _$bytesImpl_323.BytesImpl(writeValue(valueToBytes, event));
}
function writeValue(valueToBytes, event) {
    var output = new _$bufferOutputStream_410.BufferOutputStream();
    if (event.isEditEvent) {
        _$codec_411.writeByte(output, EventType.EDIT_EVENT);
        _$timeSeriesEventMetadataSerialiser_652.EventMetadataImplSerialiser.write(output, event.originalEvent);
    }
    else {
        _$codec_411.writeByte(output, EventType.ORIGINAL_EVENT);
    }
    _$timeSeriesEventMetadataSerialiser_652.EventMetadataImplSerialiser.write(output, event);
    var serialised = valueToBytes(event.value);
    _$codec_411.writeBytes(output, serialised.$buffer);
    return output.getBuffer();
}
function bytesToEvent(bytesToValue, bytes) {
    var input = new _$bufferInputStream_409.BufferInputStream(bytes.$buffer);
    var eventType = _$codec_411.readByte(input);
    switch (eventType) {
        case EventType.ORIGINAL_EVENT:
            return readOriginalEvent(bytesToValue, input);
        case EventType.EDIT_EVENT:
            return readEditEvent(bytesToValue, input);
        default:
            throw new _$errors_280.InvalidDataError('Unrecognised event type: ' + eventType);
    }
}
function readOriginalEvent(bytesToValue, input) {
    var metadata = _$timeSeriesEventMetadataSerialiser_652.EventMetadataImplSerialiser.read(input);
    var value = bytesToValue(_$codec_411.readBytes(input));
    return _$timeSeriesEvent_654.EventImpl.create(metadata, metadata, value);
}
function readEditEvent(bytesToValue, input) {
    var originalEvent = _$timeSeriesEventMetadataSerialiser_652.EventMetadataImplSerialiser.read(input);
    var metadata = _$timeSeriesEventMetadataSerialiser_652.EventMetadataImplSerialiser.read(input);
    var value = bytesToValue(_$codec_411.readBytes(input));
    return _$timeSeriesEvent_654.EventImpl.create(metadata, originalEvent, value);
}
var TimeSeriesEventDataType =  (function (_super) {
    __extends(TimeSeriesEventDataType, _super);
    function TimeSeriesEventDataType(name, valueTypeName, bytesToValue, valueToBytes) {
        var _this = this;
        var eventValueType = datatypes_1.DataTypes.getByName(valueTypeName);
        var converters = eventValueType !== undefined
            ? [{
                    name: eventValueType.valueClass.toString(),
                    convert: function (buffer, offset, length) {
                        var bytes = new _$bytesImpl_323.BytesImpl(buffer, offset, length);
                        var event = bytesToEvent(bytesToValue, bytes);
                        return event.value;
                    }
                }]
            : [];
        _this = _super.call(this, name, _$timeSeriesEvent_654.EventImpl, _$bytesImpl_323.BytesImpl, function (e) {
            return eventToBytes(valueToBytes, e);
        }, function (b) {
            return bytesToEvent(bytesToValue, b);
        }, converters, true) || this;
        _this.valueToBytes = valueToBytes;
        _this.valueTypeName = valueTypeName;
        return _this;
    }
    TimeSeriesEventDataType.create = function (delegate) {
        return new TimeSeriesEventDataType("timeseriesevent-" + delegate.name(), delegate.name(), delegate.readValue.bind(delegate), delegate.toBytes.bind(delegate));
    };
    TimeSeriesEventDataType.prototype.writeValue = function (event) {
        return Buffer.from(writeValue(this.valueToBytes, event));
    };
    TimeSeriesEventDataType.prototype.writeValueToArray = function (event) {
        return writeValue(this.valueToBytes, event);
    };
    TimeSeriesEventDataType.prototype.validate = function () {
    };
    TimeSeriesEventDataType.prototype.from = function (value) {
        return (value instanceof _$bufferSlice_322.BufferSlice)
            ? value
            : this.valueToBytes(value.value);
    };
    return TimeSeriesEventDataType;
}(_$abstractDatatype_316.AbstractDataType));
exports.TimeSeriesEventDataType = TimeSeriesEventDataType;

}).call(this)}).call(this,_$buffer_3({}).Buffer)
});
var _$zlibDecompression_764 = createModuleFactory(function (module, exports) {
(function (Buffer){(function (){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decompressSync = void 0;
var zlib_1 = require("zlib");
function decompressSync(input) {
    var inputBuffer = input instanceof Uint8Array
        ? (typeof Buffer === 'undefined' ? input : Buffer.from(input))
        : input;
    return zlib_1.inflateSync(inputBuffer);
}
exports.decompressSync = decompressSync;

}).call(this)}).call(this,_$buffer_3({}).Buffer)
});
var _$buffer_3 = createModuleFactory(function (module, exports) {
(function (Buffer){(function (){
'use strict';
;
;
exports.Buffer = Buffer;
 void SlowBuffer;
exports.INSPECT_MAX_BYTES = 50;
var K_MAX_LENGTH = 2147483647;
 void K_MAX_LENGTH;
Buffer.TYPED_ARRAY_SUPPORT = typedArraySupport();
if (!Buffer.TYPED_ARRAY_SUPPORT && typeof console !== 'undefined' && typeof console.error === 'function') {
    console.error('This browser lacks typed array (Uint8Array) support which is required by ' + '`buffer` v5.x. Use `buffer` v4.x if you require old browser support.');
}
function typedArraySupport() {
    try {
        var arr = new Uint8Array(1);
        arr.__proto__ = {
            __proto__: Uint8Array.prototype,
            foo: function () {
                return 42;
            }
        };
        return arr.foo() === 42;
    } catch (e) {
        return false;
    }
}
Object.defineProperty(Buffer.prototype, 'parent', {
    enumerable: true,
    get: function () {
        if (!Buffer.isBuffer(this))
            return undefined;
        return this.buffer;
    }
});
Object.defineProperty(Buffer.prototype, 'offset', {
    enumerable: true,
    get: function () {
        if (!Buffer.isBuffer(this))
            return undefined;
        return this.byteOffset;
    }
});
function createBuffer(length) {
    if (length > K_MAX_LENGTH) {
        throw new RangeError('The value "' + length + '" is invalid for option "size"');
    }
    var buf = new Uint8Array(length);
    buf.__proto__ = Buffer.prototype;
    return buf;
}
function Buffer(arg, encodingOrOffset, length) {
    if (typeof arg === 'number') {
        if (typeof encodingOrOffset === 'string') {
            throw new TypeError('The "string" argument must be of type string. Received type number');
        }
        return allocUnsafe(arg);
    }
    return from(arg, encodingOrOffset, length);
}
if (typeof Symbol !== 'undefined' && Symbol.species != null && Buffer[Symbol.species] === Buffer) {
    Object.defineProperty(Buffer, Symbol.species, {
        value: null,
        configurable: true,
        enumerable: false,
        writable: false
    });
}
Buffer.poolSize = 8192;
function from(value, encodingOrOffset, length) {
    if (typeof value === 'string') {
        return fromString(value, encodingOrOffset);
    }
    if (ArrayBuffer.isView(value)) {
        return fromArrayLike(value);
    }
    if (value == null) {
        throw TypeError('The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' + 'or Array-like Object. Received type ' + typeof value);
    }
    if (isInstance(value, ArrayBuffer) || value && isInstance(value.buffer, ArrayBuffer)) {
        return fromArrayBuffer(value, encodingOrOffset, length);
    }
    if (typeof value === 'number') {
        throw new TypeError('The "value" argument must not be of type number. Received type number');
    }
    var valueOf = value.valueOf && value.valueOf();
    if (valueOf != null && valueOf !== value) {
        return Buffer.from(valueOf, encodingOrOffset, length);
    }
    var b = fromObject(value);
    if (b)
        return b;
    if (typeof Symbol !== 'undefined' && Symbol.toPrimitive != null && typeof value[Symbol.toPrimitive] === 'function') {
        return Buffer.from(value[Symbol.toPrimitive]('string'), encodingOrOffset, length);
    }
    throw new TypeError('The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' + 'or Array-like Object. Received type ' + typeof value);
}
Buffer.from = function (value, encodingOrOffset, length) {
    return from(value, encodingOrOffset, length);
};
Buffer.prototype.__proto__ = Uint8Array.prototype;
Buffer.__proto__ = Uint8Array;
function assertSize(size) {
    if (typeof size !== 'number') {
        throw new TypeError('"size" argument must be of type number');
    } else if (size < 0) {
        throw new RangeError('The value "' + size + '" is invalid for option "size"');
    }
}
function alloc(size, fill, encoding) {
    assertSize(size);
    if (size <= 0) {
        return createBuffer(size);
    }
    if (fill !== undefined) {
        return typeof encoding === 'string' ? createBuffer(size).fill(fill, encoding) : createBuffer(size).fill(fill);
    }
    return createBuffer(size);
}
Buffer.alloc = function (size, fill, encoding) {
    return alloc(size, fill, encoding);
};
function allocUnsafe(size) {
    assertSize(size);
    return createBuffer(size < 0 ? 0 : checked(size) | 0);
}
Buffer.allocUnsafe = function (size) {
    return allocUnsafe(size);
};
Buffer.allocUnsafeSlow = function (size) {
    return allocUnsafe(size);
};
function fromString(string, encoding) {
    if (typeof encoding !== 'string' || encoding === '') {
        encoding = 'utf8';
    }
    if (!Buffer.isEncoding(encoding)) {
        throw new TypeError('Unknown encoding: ' + encoding);
    }
    var length = byteLength(string, encoding) | 0;
    var buf = createBuffer(length);
    var actual = buf.write(string, encoding);
    if (actual !== length) {
        buf = buf.slice(0, actual);
    }
    return buf;
}
function fromArrayLike(array) {
    var length = array.length < 0 ? 0 : checked(array.length) | 0;
    var buf = createBuffer(length);
    for (var i = 0; i < length; i += 1) {
        buf[i] = array[i] & 255;
    }
    return buf;
}
function fromArrayBuffer(array, byteOffset, length) {
    if (byteOffset < 0 || array.byteLength < byteOffset) {
        throw new RangeError('"offset" is outside of buffer bounds');
    }
    if (array.byteLength < byteOffset + (length || 0)) {
        throw new RangeError('"length" is outside of buffer bounds');
    }
    var buf;
    if (byteOffset === undefined && length === undefined) {
        buf = new Uint8Array(array);
    } else if (length === undefined) {
        buf = new Uint8Array(array, byteOffset);
    } else {
        buf = new Uint8Array(array, byteOffset, length);
    }
    buf.__proto__ = Buffer.prototype;
    return buf;
}
function fromObject(obj) {
    if (Buffer.isBuffer(obj)) {
        var len = checked(obj.length) | 0;
        var buf = createBuffer(len);
        if (buf.length === 0) {
            return buf;
        }
        obj.copy(buf, 0, 0, len);
        return buf;
    }
    if (obj.length !== undefined) {
        if (typeof obj.length !== 'number' || numberIsNaN(obj.length)) {
            return createBuffer(0);
        }
        return fromArrayLike(obj);
    }
    if (obj.type === 'Buffer' && Array.isArray(obj.data)) {
        return fromArrayLike(obj.data);
    }
}
function checked(length) {
    if (length >= K_MAX_LENGTH) {
        throw new RangeError('Attempt to allocate Buffer larger than maximum ' + 'size: 0x' + K_MAX_LENGTH.toString(16) + ' bytes');
    }
    return length | 0;
}
function SlowBuffer(length) {
    if (+length != length) {
        length = 0;
    }
    return Buffer.alloc(+length);
}
Buffer.isBuffer = function isBuffer(b) {
    return b != null && b._isBuffer === true && b !== Buffer.prototype;
};
Buffer.compare = function compare(a, b) {
    if (isInstance(a, Uint8Array))
        a = Buffer.from(a, a.offset, a.byteLength);
    if (isInstance(b, Uint8Array))
        b = Buffer.from(b, b.offset, b.byteLength);
    if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
        throw new TypeError('The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array');
    }
    if (a === b)
        return 0;
    var x = a.length;
    var y = b.length;
    for (var i = 0, len = Math.min(x, y); i < len; ++i) {
        if (a[i] !== b[i]) {
            x = a[i];
            y = b[i];
            break;
        }
    }
    if (x < y)
        return -1;
    if (y < x)
        return 1;
    return 0;
};
Buffer.isEncoding = function isEncoding(encoding) {
    switch (String(encoding).toLowerCase()) {
    case 'hex':
    case 'utf8':
    case 'utf-8':
    case 'ascii':
    case 'latin1':
    case 'binary':
    case 'base64':
    case 'ucs2':
    case 'ucs-2':
    case 'utf16le':
    case 'utf-16le':
        return true;
    default:
        return false;
    }
};
Buffer.concat = function concat(list, length) {
    if (!Array.isArray(list)) {
        throw new TypeError('"list" argument must be an Array of Buffers');
    }
    if (list.length === 0) {
        return Buffer.alloc(0);
    }
    var i;
    if (length === undefined) {
        length = 0;
        for (i = 0; i < list.length; ++i) {
            length += list[i].length;
        }
    }
    var buffer = Buffer.allocUnsafe(length);
    var pos = 0;
    for (i = 0; i < list.length; ++i) {
        var buf = list[i];
        if (isInstance(buf, Uint8Array)) {
            buf = Buffer.from(buf);
        }
        if (!Buffer.isBuffer(buf)) {
            throw new TypeError('"list" argument must be an Array of Buffers');
        }
        buf.copy(buffer, pos);
        pos += buf.length;
    }
    return buffer;
};
function byteLength(string, encoding) {
    if (Buffer.isBuffer(string)) {
        return string.length;
    }
    if (ArrayBuffer.isView(string) || isInstance(string, ArrayBuffer)) {
        return string.byteLength;
    }
    if (typeof string !== 'string') {
        throw new TypeError('The "string" argument must be one of type string, Buffer, or ArrayBuffer. ' + 'Received type ' + typeof string);
    }
    var len = string.length;
    var mustMatch = arguments.length > 2 && arguments[2] === true;
    if (!mustMatch && len === 0)
        return 0;
    var loweredCase = false;
    for (;;) {
        switch (encoding) {
        case 'ascii':
        case 'latin1':
        case 'binary':
            return len;
        case 'utf8':
        case 'utf-8':
            return utf8ToBytes(string).length;
        case 'ucs2':
        case 'ucs-2':
        case 'utf16le':
        case 'utf-16le':
            return len * 2;
        case 'hex':
            return len >>> 1;
        case 'base64':
            return base64ToBytes(string).length;
        default:
            if (loweredCase) {
                return mustMatch ? -1 : utf8ToBytes(string).length;
            }
            encoding = ('' + encoding).toLowerCase();
            loweredCase = true;
        }
    }
}
Buffer.byteLength = byteLength;
function slowToString(encoding, start, end) {
    var loweredCase = false;
    if (start === undefined || start < 0) {
        start = 0;
    }
    if (start > this.length) {
        return '';
    }
    if (end === undefined || end > this.length) {
        end = this.length;
    }
    if (end <= 0) {
        return '';
    }
    end >>>= 0;
    start >>>= 0;
    if (end <= start) {
        return '';
    }
    if (!encoding)
        encoding = 'utf8';
    while (true) {
        switch (encoding) {
        case 'hex':
            return hexSlice(this, start, end);
        case 'utf8':
        case 'utf-8':
            return utf8Slice(this, start, end);
        case 'ascii':
            return asciiSlice(this, start, end);
        case 'latin1':
        case 'binary':
            return latin1Slice(this, start, end);
        case 'base64':
            return base64Slice(this, start, end);
        case 'ucs2':
        case 'ucs-2':
        case 'utf16le':
        case 'utf-16le':
            return utf16leSlice(this, start, end);
        default:
            if (loweredCase)
                throw new TypeError('Unknown encoding: ' + encoding);
            encoding = (encoding + '').toLowerCase();
            loweredCase = true;
        }
    }
}
Buffer.prototype._isBuffer = true;
function swap(b, n, m) {
    var i = b[n];
    b[n] = b[m];
    b[m] = i;
}
Buffer.prototype.swap16 = function swap16() {
    var len = this.length;
    if (len % 2 !== 0) {
        throw new RangeError('Buffer size must be a multiple of 16-bits');
    }
    for (var i = 0; i < len; i += 2) {
        swap(this, i, i + 1);
    }
    return this;
};
Buffer.prototype.swap32 = function swap32() {
    var len = this.length;
    if (len % 4 !== 0) {
        throw new RangeError('Buffer size must be a multiple of 32-bits');
    }
    for (var i = 0; i < len; i += 4) {
        swap(this, i, i + 3);
        swap(this, i + 1, i + 2);
    }
    return this;
};
Buffer.prototype.swap64 = function swap64() {
    var len = this.length;
    if (len % 8 !== 0) {
        throw new RangeError('Buffer size must be a multiple of 64-bits');
    }
    for (var i = 0; i < len; i += 8) {
        swap(this, i, i + 7);
        swap(this, i + 1, i + 6);
        swap(this, i + 2, i + 5);
        swap(this, i + 3, i + 4);
    }
    return this;
};
Buffer.prototype.toString = function toString() {
    var length = this.length;
    if (length === 0)
        return '';
    if (arguments.length === 0)
        return utf8Slice(this, 0, length);
    return slowToString.apply(this, arguments);
};
Buffer.prototype.toLocaleString = Buffer.prototype.toString;
Buffer.prototype.equals = function equals(b) {
    if (!Buffer.isBuffer(b))
        throw new TypeError('Argument must be a Buffer');
    if (this === b)
        return true;
    return Buffer.compare(this, b) === 0;
};
Buffer.prototype.inspect = function inspect() {
    var str = '';
    var max = exports.INSPECT_MAX_BYTES;
    str = this.toString('hex', 0, max).replace(/(.{2})/g, '$1 ').trim();
    if (this.length > max)
        str += ' ... ';
    return '<Buffer ' + str + '>';
};
Buffer.prototype.compare = function compare(target, start, end, thisStart, thisEnd) {
    if (isInstance(target, Uint8Array)) {
        target = Buffer.from(target, target.offset, target.byteLength);
    }
    if (!Buffer.isBuffer(target)) {
        throw new TypeError('The "target" argument must be one of type Buffer or Uint8Array. ' + 'Received type ' + typeof target);
    }
    if (start === undefined) {
        start = 0;
    }
    if (end === undefined) {
        end = target ? target.length : 0;
    }
    if (thisStart === undefined) {
        thisStart = 0;
    }
    if (thisEnd === undefined) {
        thisEnd = this.length;
    }
    if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
        throw new RangeError('out of range index');
    }
    if (thisStart >= thisEnd && start >= end) {
        return 0;
    }
    if (thisStart >= thisEnd) {
        return -1;
    }
    if (start >= end) {
        return 1;
    }
    start >>>= 0;
    end >>>= 0;
    thisStart >>>= 0;
    thisEnd >>>= 0;
    if (this === target)
        return 0;
    var x = thisEnd - thisStart;
    var y = end - start;
    var len = Math.min(x, y);
    var thisCopy = this.slice(thisStart, thisEnd);
    var targetCopy = target.slice(start, end);
    for (var i = 0; i < len; ++i) {
        if (thisCopy[i] !== targetCopy[i]) {
            x = thisCopy[i];
            y = targetCopy[i];
            break;
        }
    }
    if (x < y)
        return -1;
    if (y < x)
        return 1;
    return 0;
};
function bidirectionalIndexOf(buffer, val, byteOffset, encoding, dir) {
    if (buffer.length === 0)
        return -1;
    if (typeof byteOffset === 'string') {
        encoding = byteOffset;
        byteOffset = 0;
    } else if (byteOffset > 2147483647) {
        byteOffset = 2147483647;
    } else if (byteOffset < -2147483648) {
        byteOffset = -2147483648;
    }
    byteOffset = +byteOffset;
    if (numberIsNaN(byteOffset)) {
        byteOffset = dir ? 0 : buffer.length - 1;
    }
    if (byteOffset < 0)
        byteOffset = buffer.length + byteOffset;
    if (byteOffset >= buffer.length) {
        if (dir)
            return -1;
        else
            byteOffset = buffer.length - 1;
    } else if (byteOffset < 0) {
        if (dir)
            byteOffset = 0;
        else
            return -1;
    }
    if (typeof val === 'string') {
        val = Buffer.from(val, encoding);
    }
    if (Buffer.isBuffer(val)) {
        if (val.length === 0) {
            return -1;
        }
        return arrayIndexOf(buffer, val, byteOffset, encoding, dir);
    } else if (typeof val === 'number') {
        val = val & 255;
        if (typeof Uint8Array.prototype.indexOf === 'function') {
            if (dir) {
                return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset);
            } else {
                return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset);
            }
        }
        return arrayIndexOf(buffer, [val], byteOffset, encoding, dir);
    }
    throw new TypeError('val must be string, number or Buffer');
}
function arrayIndexOf(arr, val, byteOffset, encoding, dir) {
    var indexSize = 1;
    var arrLength = arr.length;
    var valLength = val.length;
    if (encoding !== undefined) {
        encoding = String(encoding).toLowerCase();
        if (encoding === 'ucs2' || encoding === 'ucs-2' || encoding === 'utf16le' || encoding === 'utf-16le') {
            if (arr.length < 2 || val.length < 2) {
                return -1;
            }
            indexSize = 2;
            arrLength /= 2;
            valLength /= 2;
            byteOffset /= 2;
        }
    }
    function read(buf, i) {
        if (indexSize === 1) {
            return buf[i];
        } else {
            return buf.readUInt16BE(i * indexSize);
        }
    }
    var i;
    if (dir) {
        var foundIndex = -1;
        for (i = byteOffset; i < arrLength; i++) {
            if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
                if (foundIndex === -1)
                    foundIndex = i;
                if (i - foundIndex + 1 === valLength)
                    return foundIndex * indexSize;
            } else {
                if (foundIndex !== -1)
                    i -= i - foundIndex;
                foundIndex = -1;
            }
        }
    } else {
        if (byteOffset + valLength > arrLength)
            byteOffset = arrLength - valLength;
        for (i = byteOffset; i >= 0; i--) {
            var found = true;
            for (var j = 0; j < valLength; j++) {
                if (read(arr, i + j) !== read(val, j)) {
                    found = false;
                    break;
                }
            }
            if (found)
                return i;
        }
    }
    return -1;
}
Buffer.prototype.includes = function includes(val, byteOffset, encoding) {
    return this.indexOf(val, byteOffset, encoding) !== -1;
};
Buffer.prototype.indexOf = function indexOf(val, byteOffset, encoding) {
    return bidirectionalIndexOf(this, val, byteOffset, encoding, true);
};
Buffer.prototype.lastIndexOf = function lastIndexOf(val, byteOffset, encoding) {
    return bidirectionalIndexOf(this, val, byteOffset, encoding, false);
};
function hexWrite(buf, string, offset, length) {
    offset = Number(offset) || 0;
    var remaining = buf.length - offset;
    if (!length) {
        length = remaining;
    } else {
        length = Number(length);
        if (length > remaining) {
            length = remaining;
        }
    }
    var strLen = string.length;
    if (length > strLen / 2) {
        length = strLen / 2;
    }
    for (var i = 0; i < length; ++i) {
        var parsed = parseInt(string.substr(i * 2, 2), 16);
        if (numberIsNaN(parsed))
            return i;
        buf[offset + i] = parsed;
    }
    return i;
}
function utf8Write(buf, string, offset, length) {
    return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length);
}
function asciiWrite(buf, string, offset, length) {
    return blitBuffer(asciiToBytes(string), buf, offset, length);
}
function latin1Write(buf, string, offset, length) {
    return asciiWrite(buf, string, offset, length);
}
function base64Write(buf, string, offset, length) {
    return blitBuffer(base64ToBytes(string), buf, offset, length);
}
function ucs2Write(buf, string, offset, length) {
    return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length);
}
Buffer.prototype.write = function write(string, offset, length, encoding) {
    if (offset === undefined) {
        encoding = 'utf8';
        length = this.length;
        offset = 0;
    } else if (length === undefined && typeof offset === 'string') {
        encoding = offset;
        length = this.length;
        offset = 0;
    } else if (isFinite(offset)) {
        offset = offset >>> 0;
        if (isFinite(length)) {
            length = length >>> 0;
            if (encoding === undefined)
                encoding = 'utf8';
        } else {
            encoding = length;
            length = undefined;
        }
    } else {
        throw new Error('Buffer.write(string, encoding, offset[, length]) is no longer supported');
    }
    var remaining = this.length - offset;
    if (length === undefined || length > remaining)
        length = remaining;
    if (string.length > 0 && (length < 0 || offset < 0) || offset > this.length) {
        throw new RangeError('Attempt to write outside buffer bounds');
    }
    if (!encoding)
        encoding = 'utf8';
    var loweredCase = false;
    for (;;) {
        switch (encoding) {
        case 'hex':
            return hexWrite(this, string, offset, length);
        case 'utf8':
        case 'utf-8':
            return utf8Write(this, string, offset, length);
        case 'ascii':
            return asciiWrite(this, string, offset, length);
        case 'latin1':
        case 'binary':
            return latin1Write(this, string, offset, length);
        case 'base64':
            return base64Write(this, string, offset, length);
        case 'ucs2':
        case 'ucs-2':
        case 'utf16le':
        case 'utf-16le':
            return ucs2Write(this, string, offset, length);
        default:
            if (loweredCase)
                throw new TypeError('Unknown encoding: ' + encoding);
            encoding = ('' + encoding).toLowerCase();
            loweredCase = true;
        }
    }
};
Buffer.prototype.toJSON = function toJSON() {
    return {
        type: 'Buffer',
        data: Array.prototype.slice.call(this._arr || this, 0)
    };
};
function base64Slice(buf, start, end) {
    if (start === 0 && end === buf.length) {
        return _$base64Js_1.fromByteArray(buf);
    } else {
        return _$base64Js_1.fromByteArray(buf.slice(start, end));
    }
}
function utf8Slice(buf, start, end) {
    end = Math.min(buf.length, end);
    var res = [];
    var i = start;
    while (i < end) {
        var firstByte = buf[i];
        var codePoint = null;
        var bytesPerSequence = firstByte > 239 ? 4 : firstByte > 223 ? 3 : firstByte > 191 ? 2 : 1;
        if (i + bytesPerSequence <= end) {
            var secondByte, thirdByte, fourthByte, tempCodePoint;
            switch (bytesPerSequence) {
            case 1:
                if (firstByte < 128) {
                    codePoint = firstByte;
                }
                break;
            case 2:
                secondByte = buf[i + 1];
                if ((secondByte & 192) === 128) {
                    tempCodePoint = (firstByte & 31) << 6 | secondByte & 63;
                    if (tempCodePoint > 127) {
                        codePoint = tempCodePoint;
                    }
                }
                break;
            case 3:
                secondByte = buf[i + 1];
                thirdByte = buf[i + 2];
                if ((secondByte & 192) === 128 && (thirdByte & 192) === 128) {
                    tempCodePoint = (firstByte & 15) << 12 | (secondByte & 63) << 6 | thirdByte & 63;
                    if (tempCodePoint > 2047 && (tempCodePoint < 55296 || tempCodePoint > 57343)) {
                        codePoint = tempCodePoint;
                    }
                }
                break;
            case 4:
                secondByte = buf[i + 1];
                thirdByte = buf[i + 2];
                fourthByte = buf[i + 3];
                if ((secondByte & 192) === 128 && (thirdByte & 192) === 128 && (fourthByte & 192) === 128) {
                    tempCodePoint = (firstByte & 15) << 18 | (secondByte & 63) << 12 | (thirdByte & 63) << 6 | fourthByte & 63;
                    if (tempCodePoint > 65535 && tempCodePoint < 1114112) {
                        codePoint = tempCodePoint;
                    }
                }
            }
        }
        if (codePoint === null) {
            codePoint = 65533;
            bytesPerSequence = 1;
        } else if (codePoint > 65535) {
            codePoint -= 65536;
            res.push(codePoint >>> 10 & 1023 | 55296);
            codePoint = 56320 | codePoint & 1023;
        }
        res.push(codePoint);
        i += bytesPerSequence;
    }
    return decodeCodePointsArray(res);
}
var MAX_ARGUMENTS_LENGTH = 4096;
function decodeCodePointsArray(codePoints) {
    var len = codePoints.length;
    if (len <= MAX_ARGUMENTS_LENGTH) {
        return String.fromCharCode.apply(String, codePoints);
    }
    var res = '';
    var i = 0;
    while (i < len) {
        res += String.fromCharCode.apply(String, codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH));
    }
    return res;
}
function asciiSlice(buf, start, end) {
    var ret = '';
    end = Math.min(buf.length, end);
    for (var i = start; i < end; ++i) {
        ret += String.fromCharCode(buf[i] & 127);
    }
    return ret;
}
function latin1Slice(buf, start, end) {
    var ret = '';
    end = Math.min(buf.length, end);
    for (var i = start; i < end; ++i) {
        ret += String.fromCharCode(buf[i]);
    }
    return ret;
}
function hexSlice(buf, start, end) {
    var len = buf.length;
    if (!start || start < 0)
        start = 0;
    if (!end || end < 0 || end > len)
        end = len;
    var out = '';
    for (var i = start; i < end; ++i) {
        out += toHex(buf[i]);
    }
    return out;
}
function utf16leSlice(buf, start, end) {
    var bytes = buf.slice(start, end);
    var res = '';
    for (var i = 0; i < bytes.length; i += 2) {
        res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256);
    }
    return res;
}
Buffer.prototype.slice = function slice(start, end) {
    var len = this.length;
    start = ~~start;
    end = end === undefined ? len : ~~end;
    if (start < 0) {
        start += len;
        if (start < 0)
            start = 0;
    } else if (start > len) {
        start = len;
    }
    if (end < 0) {
        end += len;
        if (end < 0)
            end = 0;
    } else if (end > len) {
        end = len;
    }
    if (end < start)
        end = start;
    var newBuf = this.subarray(start, end);
    newBuf.__proto__ = Buffer.prototype;
    return newBuf;
};
function checkOffset(offset, ext, length) {
    if (offset % 1 !== 0 || offset < 0)
        throw new RangeError('offset is not uint');
    if (offset + ext > length)
        throw new RangeError('Trying to access beyond buffer length');
}
Buffer.prototype.readUIntLE = function readUIntLE(offset, byteLength, noAssert) {
    offset = offset >>> 0;
    byteLength = byteLength >>> 0;
    if (!noAssert)
        checkOffset(offset, byteLength, this.length);
    var val = this[offset];
    var mul = 1;
    var i = 0;
    while (++i < byteLength && (mul *= 256)) {
        val += this[offset + i] * mul;
    }
    return val;
};
Buffer.prototype.readUIntBE = function readUIntBE(offset, byteLength, noAssert) {
    offset = offset >>> 0;
    byteLength = byteLength >>> 0;
    if (!noAssert) {
        checkOffset(offset, byteLength, this.length);
    }
    var val = this[offset + --byteLength];
    var mul = 1;
    while (byteLength > 0 && (mul *= 256)) {
        val += this[offset + --byteLength] * mul;
    }
    return val;
};
Buffer.prototype.readUInt8 = function readUInt8(offset, noAssert) {
    offset = offset >>> 0;
    if (!noAssert)
        checkOffset(offset, 1, this.length);
    return this[offset];
};
Buffer.prototype.readUInt16LE = function readUInt16LE(offset, noAssert) {
    offset = offset >>> 0;
    if (!noAssert)
        checkOffset(offset, 2, this.length);
    return this[offset] | this[offset + 1] << 8;
};
Buffer.prototype.readUInt16BE = function readUInt16BE(offset, noAssert) {
    offset = offset >>> 0;
    if (!noAssert)
        checkOffset(offset, 2, this.length);
    return this[offset] << 8 | this[offset + 1];
};
Buffer.prototype.readUInt32LE = function readUInt32LE(offset, noAssert) {
    offset = offset >>> 0;
    if (!noAssert)
        checkOffset(offset, 4, this.length);
    return (this[offset] | this[offset + 1] << 8 | this[offset + 2] << 16) + this[offset + 3] * 16777216;
};
Buffer.prototype.readUInt32BE = function readUInt32BE(offset, noAssert) {
    offset = offset >>> 0;
    if (!noAssert)
        checkOffset(offset, 4, this.length);
    return this[offset] * 16777216 + (this[offset + 1] << 16 | this[offset + 2] << 8 | this[offset + 3]);
};
Buffer.prototype.readIntLE = function readIntLE(offset, byteLength, noAssert) {
    offset = offset >>> 0;
    byteLength = byteLength >>> 0;
    if (!noAssert)
        checkOffset(offset, byteLength, this.length);
    var val = this[offset];
    var mul = 1;
    var i = 0;
    while (++i < byteLength && (mul *= 256)) {
        val += this[offset + i] * mul;
    }
    mul *= 128;
    if (val >= mul)
        val -= Math.pow(2, 8 * byteLength);
    return val;
};
Buffer.prototype.readIntBE = function readIntBE(offset, byteLength, noAssert) {
    offset = offset >>> 0;
    byteLength = byteLength >>> 0;
    if (!noAssert)
        checkOffset(offset, byteLength, this.length);
    var i = byteLength;
    var mul = 1;
    var val = this[offset + --i];
    while (i > 0 && (mul *= 256)) {
        val += this[offset + --i] * mul;
    }
    mul *= 128;
    if (val >= mul)
        val -= Math.pow(2, 8 * byteLength);
    return val;
};
Buffer.prototype.readInt8 = function readInt8(offset, noAssert) {
    offset = offset >>> 0;
    if (!noAssert)
        checkOffset(offset, 1, this.length);
    if (!(this[offset] & 128))
        return this[offset];
    return (255 - this[offset] + 1) * -1;
};
Buffer.prototype.readInt16LE = function readInt16LE(offset, noAssert) {
    offset = offset >>> 0;
    if (!noAssert)
        checkOffset(offset, 2, this.length);
    var val = this[offset] | this[offset + 1] << 8;
    return val & 32768 ? val | 4294901760 : val;
};
Buffer.prototype.readInt16BE = function readInt16BE(offset, noAssert) {
    offset = offset >>> 0;
    if (!noAssert)
        checkOffset(offset, 2, this.length);
    var val = this[offset + 1] | this[offset] << 8;
    return val & 32768 ? val | 4294901760 : val;
};
Buffer.prototype.readInt32LE = function readInt32LE(offset, noAssert) {
    offset = offset >>> 0;
    if (!noAssert)
        checkOffset(offset, 4, this.length);
    return this[offset] | this[offset + 1] << 8 | this[offset + 2] << 16 | this[offset + 3] << 24;
};
Buffer.prototype.readInt32BE = function readInt32BE(offset, noAssert) {
    offset = offset >>> 0;
    if (!noAssert)
        checkOffset(offset, 4, this.length);
    return this[offset] << 24 | this[offset + 1] << 16 | this[offset + 2] << 8 | this[offset + 3];
};
Buffer.prototype.readFloatLE = function readFloatLE(offset, noAssert) {
    offset = offset >>> 0;
    if (!noAssert)
        checkOffset(offset, 4, this.length);
    return _$ieee754_272.read(this, offset, true, 23, 4);
};
Buffer.prototype.readFloatBE = function readFloatBE(offset, noAssert) {
    offset = offset >>> 0;
    if (!noAssert)
        checkOffset(offset, 4, this.length);
    return _$ieee754_272.read(this, offset, false, 23, 4);
};
Buffer.prototype.readDoubleLE = function readDoubleLE(offset, noAssert) {
    offset = offset >>> 0;
    if (!noAssert)
        checkOffset(offset, 8, this.length);
    return _$ieee754_272.read(this, offset, true, 52, 8);
};
Buffer.prototype.readDoubleBE = function readDoubleBE(offset, noAssert) {
    offset = offset >>> 0;
    if (!noAssert)
        checkOffset(offset, 8, this.length);
    return _$ieee754_272.read(this, offset, false, 52, 8);
};
function checkInt(buf, value, offset, ext, max, min) {
    if (!Buffer.isBuffer(buf))
        throw new TypeError('"buffer" argument must be a Buffer instance');
    if (value > max || value < min)
        throw new RangeError('"value" argument is out of bounds');
    if (offset + ext > buf.length)
        throw new RangeError('Index out of range');
}
Buffer.prototype.writeUIntLE = function writeUIntLE(value, offset, byteLength, noAssert) {
    value = +value;
    offset = offset >>> 0;
    byteLength = byteLength >>> 0;
    if (!noAssert) {
        var maxBytes = Math.pow(2, 8 * byteLength) - 1;
        checkInt(this, value, offset, byteLength, maxBytes, 0);
    }
    var mul = 1;
    var i = 0;
    this[offset] = value & 255;
    while (++i < byteLength && (mul *= 256)) {
        this[offset + i] = value / mul & 255;
    }
    return offset + byteLength;
};
Buffer.prototype.writeUIntBE = function writeUIntBE(value, offset, byteLength, noAssert) {
    value = +value;
    offset = offset >>> 0;
    byteLength = byteLength >>> 0;
    if (!noAssert) {
        var maxBytes = Math.pow(2, 8 * byteLength) - 1;
        checkInt(this, value, offset, byteLength, maxBytes, 0);
    }
    var i = byteLength - 1;
    var mul = 1;
    this[offset + i] = value & 255;
    while (--i >= 0 && (mul *= 256)) {
        this[offset + i] = value / mul & 255;
    }
    return offset + byteLength;
};
Buffer.prototype.writeUInt8 = function writeUInt8(value, offset, noAssert) {
    value = +value;
    offset = offset >>> 0;
    if (!noAssert)
        checkInt(this, value, offset, 1, 255, 0);
    this[offset] = value & 255;
    return offset + 1;
};
Buffer.prototype.writeUInt16LE = function writeUInt16LE(value, offset, noAssert) {
    value = +value;
    offset = offset >>> 0;
    if (!noAssert)
        checkInt(this, value, offset, 2, 65535, 0);
    this[offset] = value & 255;
    this[offset + 1] = value >>> 8;
    return offset + 2;
};
Buffer.prototype.writeUInt16BE = function writeUInt16BE(value, offset, noAssert) {
    value = +value;
    offset = offset >>> 0;
    if (!noAssert)
        checkInt(this, value, offset, 2, 65535, 0);
    this[offset] = value >>> 8;
    this[offset + 1] = value & 255;
    return offset + 2;
};
Buffer.prototype.writeUInt32LE = function writeUInt32LE(value, offset, noAssert) {
    value = +value;
    offset = offset >>> 0;
    if (!noAssert)
        checkInt(this, value, offset, 4, 4294967295, 0);
    this[offset + 3] = value >>> 24;
    this[offset + 2] = value >>> 16;
    this[offset + 1] = value >>> 8;
    this[offset] = value & 255;
    return offset + 4;
};
Buffer.prototype.writeUInt32BE = function writeUInt32BE(value, offset, noAssert) {
    value = +value;
    offset = offset >>> 0;
    if (!noAssert)
        checkInt(this, value, offset, 4, 4294967295, 0);
    this[offset] = value >>> 24;
    this[offset + 1] = value >>> 16;
    this[offset + 2] = value >>> 8;
    this[offset + 3] = value & 255;
    return offset + 4;
};
Buffer.prototype.writeIntLE = function writeIntLE(value, offset, byteLength, noAssert) {
    value = +value;
    offset = offset >>> 0;
    if (!noAssert) {
        var limit = Math.pow(2, 8 * byteLength - 1);
        checkInt(this, value, offset, byteLength, limit - 1, -limit);
    }
    var i = 0;
    var mul = 1;
    var sub = 0;
    this[offset] = value & 255;
    while (++i < byteLength && (mul *= 256)) {
        if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
            sub = 1;
        }
        this[offset + i] = (value / mul >> 0) - sub & 255;
    }
    return offset + byteLength;
};
Buffer.prototype.writeIntBE = function writeIntBE(value, offset, byteLength, noAssert) {
    value = +value;
    offset = offset >>> 0;
    if (!noAssert) {
        var limit = Math.pow(2, 8 * byteLength - 1);
        checkInt(this, value, offset, byteLength, limit - 1, -limit);
    }
    var i = byteLength - 1;
    var mul = 1;
    var sub = 0;
    this[offset + i] = value & 255;
    while (--i >= 0 && (mul *= 256)) {
        if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
            sub = 1;
        }
        this[offset + i] = (value / mul >> 0) - sub & 255;
    }
    return offset + byteLength;
};
Buffer.prototype.writeInt8 = function writeInt8(value, offset, noAssert) {
    value = +value;
    offset = offset >>> 0;
    if (!noAssert)
        checkInt(this, value, offset, 1, 127, -128);
    if (value < 0)
        value = 255 + value + 1;
    this[offset] = value & 255;
    return offset + 1;
};
Buffer.prototype.writeInt16LE = function writeInt16LE(value, offset, noAssert) {
    value = +value;
    offset = offset >>> 0;
    if (!noAssert)
        checkInt(this, value, offset, 2, 32767, -32768);
    this[offset] = value & 255;
    this[offset + 1] = value >>> 8;
    return offset + 2;
};
Buffer.prototype.writeInt16BE = function writeInt16BE(value, offset, noAssert) {
    value = +value;
    offset = offset >>> 0;
    if (!noAssert)
        checkInt(this, value, offset, 2, 32767, -32768);
    this[offset] = value >>> 8;
    this[offset + 1] = value & 255;
    return offset + 2;
};
Buffer.prototype.writeInt32LE = function writeInt32LE(value, offset, noAssert) {
    value = +value;
    offset = offset >>> 0;
    if (!noAssert)
        checkInt(this, value, offset, 4, 2147483647, -2147483648);
    this[offset] = value & 255;
    this[offset + 1] = value >>> 8;
    this[offset + 2] = value >>> 16;
    this[offset + 3] = value >>> 24;
    return offset + 4;
};
Buffer.prototype.writeInt32BE = function writeInt32BE(value, offset, noAssert) {
    value = +value;
    offset = offset >>> 0;
    if (!noAssert)
        checkInt(this, value, offset, 4, 2147483647, -2147483648);
    if (value < 0)
        value = 4294967295 + value + 1;
    this[offset] = value >>> 24;
    this[offset + 1] = value >>> 16;
    this[offset + 2] = value >>> 8;
    this[offset + 3] = value & 255;
    return offset + 4;
};
function checkIEEE754(buf, value, offset, ext, max, min) {
    if (offset + ext > buf.length)
        throw new RangeError('Index out of range');
    if (offset < 0)
        throw new RangeError('Index out of range');
}
function writeFloat(buf, value, offset, littleEndian, noAssert) {
    value = +value;
    offset = offset >>> 0;
    if (!noAssert) {
        checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38);
    }
    _$ieee754_272.write(buf, value, offset, littleEndian, 23, 4);
    return offset + 4;
}
Buffer.prototype.writeFloatLE = function writeFloatLE(value, offset, noAssert) {
    return writeFloat(this, value, offset, true, noAssert);
};
Buffer.prototype.writeFloatBE = function writeFloatBE(value, offset, noAssert) {
    return writeFloat(this, value, offset, false, noAssert);
};
function writeDouble(buf, value, offset, littleEndian, noAssert) {
    value = +value;
    offset = offset >>> 0;
    if (!noAssert) {
        checkIEEE754(buf, value, offset, 8, 1.7976931348623157e+308, -1.7976931348623157e+308);
    }
    _$ieee754_272.write(buf, value, offset, littleEndian, 52, 8);
    return offset + 8;
}
Buffer.prototype.writeDoubleLE = function writeDoubleLE(value, offset, noAssert) {
    return writeDouble(this, value, offset, true, noAssert);
};
Buffer.prototype.writeDoubleBE = function writeDoubleBE(value, offset, noAssert) {
    return writeDouble(this, value, offset, false, noAssert);
};
Buffer.prototype.copy = function copy(target, targetStart, start, end) {
    if (!Buffer.isBuffer(target))
        throw new TypeError('argument should be a Buffer');
    if (!start)
        start = 0;
    if (!end && end !== 0)
        end = this.length;
    if (targetStart >= target.length)
        targetStart = target.length;
    if (!targetStart)
        targetStart = 0;
    if (end > 0 && end < start)
        end = start;
    if (end === start)
        return 0;
    if (target.length === 0 || this.length === 0)
        return 0;
    if (targetStart < 0) {
        throw new RangeError('targetStart out of bounds');
    }
    if (start < 0 || start >= this.length)
        throw new RangeError('Index out of range');
    if (end < 0)
        throw new RangeError('sourceEnd out of bounds');
    if (end > this.length)
        end = this.length;
    if (target.length - targetStart < end - start) {
        end = target.length - targetStart + start;
    }
    var len = end - start;
    if (this === target && typeof Uint8Array.prototype.copyWithin === 'function') {
        this.copyWithin(targetStart, start, end);
    } else if (this === target && start < targetStart && targetStart < end) {
        for (var i = len - 1; i >= 0; --i) {
            target[i + targetStart] = this[i + start];
        }
    } else {
        Uint8Array.prototype.set.call(target, this.subarray(start, end), targetStart);
    }
    return len;
};
Buffer.prototype.fill = function fill(val, start, end, encoding) {
    if (typeof val === 'string') {
        if (typeof start === 'string') {
            encoding = start;
            start = 0;
            end = this.length;
        } else if (typeof end === 'string') {
            encoding = end;
            end = this.length;
        }
        if (encoding !== undefined && typeof encoding !== 'string') {
            throw new TypeError('encoding must be a string');
        }
        if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
            throw new TypeError('Unknown encoding: ' + encoding);
        }
        if (val.length === 1) {
            var code = val.charCodeAt(0);
            if (encoding === 'utf8' && code < 128 || encoding === 'latin1') {
                val = code;
            }
        }
    } else if (typeof val === 'number') {
        val = val & 255;
    }
    if (start < 0 || this.length < start || this.length < end) {
        throw new RangeError('Out of range index');
    }
    if (end <= start) {
        return this;
    }
    start = start >>> 0;
    end = end === undefined ? this.length : end >>> 0;
    if (!val)
        val = 0;
    var i;
    if (typeof val === 'number') {
        for (i = start; i < end; ++i) {
            this[i] = val;
        }
    } else {
        var bytes = Buffer.isBuffer(val) ? val : Buffer.from(val, encoding);
        var len = bytes.length;
        if (len === 0) {
            throw new TypeError('The value "' + val + '" is invalid for argument "value"');
        }
        for (i = 0; i < end - start; ++i) {
            this[i + start] = bytes[i % len];
        }
    }
    return this;
};
var INVALID_BASE64_RE = /[^+/0-9A-Za-z-_]/g;
function base64clean(str) {
    str = str.split('=')[0];
    str = str.trim().replace(INVALID_BASE64_RE, '');
    if (str.length < 2)
        return '';
    while (str.length % 4 !== 0) {
        str = str + '=';
    }
    return str;
}
function toHex(n) {
    if (n < 16)
        return '0' + n.toString(16);
    return n.toString(16);
}
function utf8ToBytes(string, units) {
    units = units || Infinity;
    var codePoint;
    var length = string.length;
    var leadSurrogate = null;
    var bytes = [];
    for (var i = 0; i < length; ++i) {
        codePoint = string.charCodeAt(i);
        if (codePoint > 55295 && codePoint < 57344) {
            if (!leadSurrogate) {
                if (codePoint > 56319) {
                    if ((units -= 3) > -1)
                        bytes.push(239, 191, 189);
                    continue;
                } else if (i + 1 === length) {
                    if ((units -= 3) > -1)
                        bytes.push(239, 191, 189);
                    continue;
                }
                leadSurrogate = codePoint;
                continue;
            }
            if (codePoint < 56320) {
                if ((units -= 3) > -1)
                    bytes.push(239, 191, 189);
                leadSurrogate = codePoint;
                continue;
            }
            codePoint = (leadSurrogate - 55296 << 10 | codePoint - 56320) + 65536;
        } else if (leadSurrogate) {
            if ((units -= 3) > -1)
                bytes.push(239, 191, 189);
        }
        leadSurrogate = null;
        if (codePoint < 128) {
            if ((units -= 1) < 0)
                break;
            bytes.push(codePoint);
        } else if (codePoint < 2048) {
            if ((units -= 2) < 0)
                break;
            bytes.push(codePoint >> 6 | 192, codePoint & 63 | 128);
        } else if (codePoint < 65536) {
            if ((units -= 3) < 0)
                break;
            bytes.push(codePoint >> 12 | 224, codePoint >> 6 & 63 | 128, codePoint & 63 | 128);
        } else if (codePoint < 1114112) {
            if ((units -= 4) < 0)
                break;
            bytes.push(codePoint >> 18 | 240, codePoint >> 12 & 63 | 128, codePoint >> 6 & 63 | 128, codePoint & 63 | 128);
        } else {
            throw new Error('Invalid code point');
        }
    }
    return bytes;
}
function asciiToBytes(str) {
    var byteArray = [];
    for (var i = 0; i < str.length; ++i) {
        byteArray.push(str.charCodeAt(i) & 255);
    }
    return byteArray;
}
function utf16leToBytes(str, units) {
    var c, hi, lo;
    var byteArray = [];
    for (var i = 0; i < str.length; ++i) {
        if ((units -= 2) < 0)
            break;
        c = str.charCodeAt(i);
        hi = c >> 8;
        lo = c % 256;
        byteArray.push(lo);
        byteArray.push(hi);
    }
    return byteArray;
}
function base64ToBytes(str) {
    return _$base64Js_1.toByteArray(base64clean(str));
}
function blitBuffer(src, dst, offset, length) {
    for (var i = 0; i < length; ++i) {
        if (i + offset >= dst.length || i >= src.length)
            break;
        dst[i + offset] = src[i];
    }
    return i;
}
function isInstance(obj, type) {
    return obj instanceof type || obj != null && obj.constructor != null && obj.constructor.name != null && obj.constructor.name === type.name;
}
function numberIsNaN(obj) {
    return obj !== obj;
}
}).call(this)}).call(this,_$buffer_3({}).Buffer)
});
var _$global_79 = {};
(function (global){(function (){
var check = function (it) {
  return it && it.Math == Math && it;
};

_$global_79 =
  check(typeof globalThis == 'object' && globalThis) ||
  check(typeof window == 'object' && window) ||
  check(typeof self == 'object' && self) ||
  check(typeof global == 'object' && global) ||
  (function () { return this; })() || Function('return this')();

}).call(this)}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
var _$fails_70 = function (exec) {
  try {
    return !!exec();
  } catch (error) {
    return true;
  }
};

;

var _$descriptors_55 = !_$fails_70(function () {
  return Object.defineProperty({}, 1, { get: function () { return 7; } })[1] != 7;
});

var _$objectPropertyIsEnumerable_122 = {};
'use strict';
var $propertyIsEnumerable = {}.propertyIsEnumerable;
var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

var NASHORN_BUG = getOwnPropertyDescriptor && !$propertyIsEnumerable.call({ 1: 2 }, 1);

_$objectPropertyIsEnumerable_122.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
  var descriptor = getOwnPropertyDescriptor(this, V);
  return !!descriptor && descriptor.enumerable;
} : $propertyIsEnumerable;

var _$createPropertyDescriptor_52 = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};

var toString = {}.toString;

var _$classofRaw_40 = function (it) {
  return toString.call(it).slice(8, -1);
};

;
;

var split = ''.split;

var _$indexedObject_85 = _$fails_70(function () {
  return !Object('z').propertyIsEnumerable(0);
}) ? function (it) {
  return _$classofRaw_40(it) == 'String' ? split.call(it, '') : Object(it);
} : Object;

var _$requireObjectCoercible_133 = function (it) {
  if (it == undefined) throw TypeError("Can't call method on " + it);
  return it;
};

;
;

var _$toIndexedObject_148 = function (it) {
  return _$indexedObject_85(_$requireObjectCoercible_133(it));
};

var _$isObject_94 = function (it) {
  return typeof it === 'object' ? it !== null : typeof it === 'function';
};

;

var aFunction = function (variable) {
  return typeof variable == 'function' ? variable : undefined;
};

var _$getBuiltIn_74 = function (namespace, method) {
  return arguments.length < 2 ? aFunction(_$global_79[namespace]) : _$global_79[namespace] && _$global_79[namespace][method];
};

;

var _$engineUserAgent_65 = _$getBuiltIn_74('navigator', 'userAgent') || '';

;
;

var process = _$global_79.process;
var Deno = _$global_79.Deno;
var versions = process && process.versions || Deno && Deno.version;
var v8 = versions && versions.v8;
var match, version;

if (v8) {
  match = v8.split('.');
  version = match[0] < 4 ? 1 : match[0] + match[1];
} else if (_$engineUserAgent_65) {
  match = _$engineUserAgent_65.match(/Edge\/(\d+)/);
  if (!match || match[1] >= 74) {
    match = _$engineUserAgent_65.match(/Chrome\/(\d+)/);
    if (match) version = match[1];
  }
}

var _$engineV8Version_66 = version && +version;

;
;

var _$nativeSymbol_105 = !!Object.getOwnPropertySymbols && !_$fails_70(function () {
  var symbol = Symbol();
  return !String(symbol) || !(Object(symbol) instanceof Symbol) ||
    !Symbol.sham && _$engineV8Version_66 && _$engineV8Version_66 < 41;
});

;

var _$useSymbolAsUid_157 = _$nativeSymbol_105
  && !Symbol.sham
  && typeof Symbol.iterator == 'symbol';

;
;

var _$isSymbol_96 = _$useSymbolAsUid_157 ? function (it) {
  return typeof it == 'symbol';
} : function (it) {
  var $Symbol = _$getBuiltIn_74('Symbol');
  return typeof $Symbol == 'function' && Object(it) instanceof $Symbol;
};

;

var _$ordinaryToPrimitive_126 = function (input, pref) {
  var fn, val;
  if (pref === 'string' && typeof (fn = input.toString) == 'function' && !_$isObject_94(val = fn.call(input))) return val;
  if (typeof (fn = input.valueOf) == 'function' && !_$isObject_94(val = fn.call(input))) return val;
  if (pref !== 'string' && typeof (fn = input.toString) == 'function' && !_$isObject_94(val = fn.call(input))) return val;
  throw TypeError("Can't convert object to primitive value");
};

var _$isPure_95 = false;

;

var _$setGlobal_135 = function (key, value) {
  try {
    Object.defineProperty(_$global_79, key, { value: value, configurable: true, writable: true });
  } catch (error) {
    _$global_79[key] = value;
  } return value;
};

;
;

var SHARED = '__core-js_shared__';
var store = _$global_79[SHARED] || _$setGlobal_135(SHARED, {});

var _$store_139 = store;

var _$shared_140 = {};
;
;

(_$shared_140 = function (key, value) {
  return _$store_139[key] || (_$store_139[key] = value !== undefined ? value : {});
})('versions', []).push({
  version: '3.16.2',
  mode: _$isPure_95 ? 'pure' : 'global',
  copyright: '© 2021 Denis Pushkarev (zloirock.ru)'
});

;

var _$toObject_151 = function (argument) {
  return Object(_$requireObjectCoercible_133(argument));
};

;

var hasOwnProperty = {}.hasOwnProperty;

var _$has_80 = Object.hasOwn || function hasOwn(it, key) {
  return hasOwnProperty.call(_$toObject_151(it), key);
};

var id = 0;
var postfix = Math.random();

var _$uid_156 = function (key) {
  return 'Symbol(' + String(key === undefined ? '' : key) + ')_' + (++id + postfix).toString(36);
};

;
;
;
;
;
;

var WellKnownSymbolsStore = _$shared_140('wks');
var __Symbol_158 = _$global_79.Symbol;
var createWellKnownSymbol = _$useSymbolAsUid_157 ? __Symbol_158 : __Symbol_158 && __Symbol_158.withoutSetter || _$uid_156;

var _$wellKnownSymbol_158 = function (name) {
  if (!_$has_80(WellKnownSymbolsStore, name) || !(_$nativeSymbol_105 || typeof WellKnownSymbolsStore[name] == 'string')) {
    if (_$nativeSymbol_105 && _$has_80(__Symbol_158, name)) {
      WellKnownSymbolsStore[name] = __Symbol_158[name];
    } else {
      WellKnownSymbolsStore[name] = createWellKnownSymbol('Symbol.' + name);
    }
  } return WellKnownSymbolsStore[name];
};

;
;
;
;

var TO_PRIMITIVE = _$wellKnownSymbol_158('toPrimitive');

var _$toPrimitive_152 = function (input, pref) {
  if (!_$isObject_94(input) || _$isSymbol_96(input)) return input;
  var exoticToPrim = input[TO_PRIMITIVE];
  var result;
  if (exoticToPrim !== undefined) {
    if (pref === undefined) pref = 'default';
    result = exoticToPrim.call(input, pref);
    if (!_$isObject_94(result) || _$isSymbol_96(result)) return result;
    throw TypeError("Can't convert object to primitive value");
  }
  if (pref === undefined) pref = 'number';
  return _$ordinaryToPrimitive_126(input, pref);
};

;
;

var _$toPropertyKey_153 = function (argument) {
  var key = _$toPrimitive_152(argument, 'string');
  return _$isSymbol_96(key) ? key : String(key);
};

;
;

var __document_56 = _$global_79.document;
var EXISTS = _$isObject_94(__document_56) && _$isObject_94(__document_56.createElement);

var _$documentCreateElement_56 = function (it) {
  return EXISTS ? __document_56.createElement(it) : {};
};

;
;
;

var _$ie8DomDefine_84 = !_$descriptors_55 && !_$fails_70(function () {
  return Object.defineProperty(_$documentCreateElement_56('div'), 'a', {
    get: function () { return 7; }
  }).a != 7;
});

var _$objectGetOwnPropertyDescriptor_115 = {};
;
;
;
;
;
;
;

var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

_$objectGetOwnPropertyDescriptor_115.f = _$descriptors_55 ? $getOwnPropertyDescriptor : function getOwnPropertyDescriptor(O, P) {
  O = _$toIndexedObject_148(O);
  P = _$toPropertyKey_153(P);
  if (_$ie8DomDefine_84) try {
    return $getOwnPropertyDescriptor(O, P);
  } catch (error) {  }
  if (_$has_80(O, P)) return _$createPropertyDescriptor_52(!_$objectPropertyIsEnumerable_122.f.call(O, P), O[P]);
};

;

var _$anObject_20 = function (it) {
  if (!_$isObject_94(it)) {
    throw TypeError(String(it) + ' is not an object');
  } return it;
};

var _$objectDefineProperty_114 = {};
;
;
;
;

var $defineProperty = Object.defineProperty;

_$objectDefineProperty_114.f = _$descriptors_55 ? $defineProperty : function defineProperty(O, P, Attributes) {
  _$anObject_20(O);
  P = _$toPropertyKey_153(P);
  _$anObject_20(Attributes);
  if (_$ie8DomDefine_84) try {
    return $defineProperty(O, P, Attributes);
  } catch (error) {  }
  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};

;
;
;

var _$createNonEnumerableProperty_51 = _$descriptors_55 ? function (object, key, value) {
  return _$objectDefineProperty_114.f(object, key, _$createPropertyDescriptor_52(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};

;

var functionToString = Function.toString;

if (typeof _$store_139.inspectSource != 'function') {
  _$store_139.inspectSource = function (it) {
    return functionToString.call(it);
  };
}

var _$inspectSource_87 = _$store_139.inspectSource;

;
;

var WeakMap = _$global_79.WeakMap;

var _$nativeWeakMap_106 = typeof WeakMap === 'function' && /native code/.test(_$inspectSource_87(WeakMap));

;
;

var keys = _$shared_140('keys');

var _$sharedKey_138 = function (key) {
  return keys[key] || (keys[key] = _$uid_156(key));
};

var _$hiddenKeys_81 = {};

;
;
;
;
;
;
;
;

var OBJECT_ALREADY_INITIALIZED = 'Object already initialized';
var __WeakMap_89 = _$global_79.WeakMap;
var set, get, __has_89;

var enforce = function (it) {
  return __has_89(it) ? get(it) : set(it, {});
};

var getterFor = function (TYPE) {
  return function (it) {
    var state;
    if (!_$isObject_94(it) || (state = get(it)).type !== TYPE) {
      throw TypeError('Incompatible receiver, ' + TYPE + ' required');
    } return state;
  };
};

if (_$nativeWeakMap_106 || _$store_139.state) {
  var __store_89 = _$store_139.state || (_$store_139.state = new __WeakMap_89());
  var wmget = __store_89.get;
  var wmhas = __store_89.has;
  var wmset = __store_89.set;
  set = function (it, metadata) {
    if (wmhas.call(__store_89, it)) throw new TypeError(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    wmset.call(__store_89, it, metadata);
    return metadata;
  };
  get = function (it) {
    return wmget.call(__store_89, it) || {};
  };
  __has_89 = function (it) {
    return wmhas.call(__store_89, it);
  };
} else {
  var STATE = _$sharedKey_138('state');
  _$hiddenKeys_81[STATE] = true;
  set = function (it, metadata) {
    if (_$has_80(it, STATE)) throw new TypeError(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    _$createNonEnumerableProperty_51(it, STATE, metadata);
    return metadata;
  };
  get = function (it) {
    return _$has_80(it, STATE) ? it[STATE] : {};
  };
  __has_89 = function (it) {
    return _$has_80(it, STATE);
  };
}

var _$internalState_89 = {
  set: set,
  get: get,
  enforce: enforce,
  getterFor: getterFor
};

var _$redefine_132 = {};
;
;
;
;
;
;

var getInternalState = _$internalState_89.get;
var enforceInternalState = _$internalState_89.enforce;
var TEMPLATE = String(String).split('String');

(_$redefine_132 = function (O, key, value, options) {
  var unsafe = options ? !!options.unsafe : false;
  var simple = options ? !!options.enumerable : false;
  var noTargetGet = options ? !!options.noTargetGet : false;
  var state;
  if (typeof value == 'function') {
    if (typeof key == 'string' && !_$has_80(value, 'name')) {
      _$createNonEnumerableProperty_51(value, 'name', key);
    }
    state = enforceInternalState(value);
    if (!state.source) {
      state.source = TEMPLATE.join(typeof key == 'string' ? key : '');
    }
  }
  if (O === _$global_79) {
    if (simple) O[key] = value;
    else _$setGlobal_135(key, value);
    return;
  } else if (!unsafe) {
    delete O[key];
  } else if (!noTargetGet && O[key]) {
    simple = true;
  }
  if (simple) O[key] = value;
  else _$createNonEnumerableProperty_51(O, key, value);
})(Function.prototype, 'toString', function toString() {
  return typeof this == 'function' && getInternalState(this).source || _$inspectSource_87(this);
});

var ceil = Math.ceil;
var floor = Math.floor;

var _$toInteger_149 = function (argument) {
  return isNaN(argument = +argument) ? 0 : (argument > 0 ? floor : ceil)(argument);
};

;

var min = Math.min;

var _$toLength_150 = function (argument) {
  return argument > 0 ? min(_$toInteger_149(argument), 0x1FFFFFFFFFFFFF) : 0; 
};

;

var max = Math.max;
var __min_147 = Math.min;

var _$toAbsoluteIndex_147 = function (index, length) {
  var integer = _$toInteger_149(index);
  return integer < 0 ? max(integer + length, 0) : __min_147(integer, length);
};

;
;
;

var createMethod = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = _$toIndexedObject_148($this);
    var length = _$toLength_150(O.length);
    var index = _$toAbsoluteIndex_147(fromIndex, length);
    var value;
    if (IS_INCLUDES && el != el) while (length > index) {
      value = O[index++];
      if (value != value) return true;
    } else for (;length > index; index++) {
      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
    } return !IS_INCLUDES && -1;
  };
};

var _$arrayIncludes_27 = {
  includes: createMethod(true),
  indexOf: createMethod(false)
};

;
;
var indexOf = _$arrayIncludes_27.indexOf;
;

var _$objectKeysInternal_120 = function (object, names) {
  var O = _$toIndexedObject_148(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) !_$has_80(_$hiddenKeys_81, key) && _$has_80(O, key) && result.push(key);
  while (names.length > i) if (_$has_80(O, key = names[i++])) {
    ~indexOf(result, key) || result.push(key);
  }
  return result;
};

var _$enumBugKeys_68 = [
  'constructor',
  'hasOwnProperty',
  'isPrototypeOf',
  'propertyIsEnumerable',
  'toLocaleString',
  'toString',
  'valueOf'
];

var _$objectGetOwnPropertyNames_117 = {};
;
;

var __hiddenKeys_117 = _$enumBugKeys_68.concat('length', 'prototype');

_$objectGetOwnPropertyNames_117.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return _$objectKeysInternal_120(O, __hiddenKeys_117);
};

var _$objectGetOwnPropertySymbols_118 = {};
_$objectGetOwnPropertySymbols_118.f = Object.getOwnPropertySymbols;

;
;
;
;

var _$ownKeys_127 = _$getBuiltIn_74('Reflect', 'ownKeys') || function ownKeys(it) {
  var keys = _$objectGetOwnPropertyNames_117.f(_$anObject_20(it));
  var getOwnPropertySymbols = _$objectGetOwnPropertySymbols_118.f;
  return getOwnPropertySymbols ? keys.concat(getOwnPropertySymbols(it)) : keys;
};

;
;
;
;

var _$copyConstructorProperties_48 = function (target, source) {
  var keys = _$ownKeys_127(source);
  var defineProperty = _$objectDefineProperty_114.f;
  var getOwnPropertyDescriptor = _$objectGetOwnPropertyDescriptor_115.f;
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    if (!_$has_80(target, key)) defineProperty(target, key, getOwnPropertyDescriptor(source, key));
  }
};

;

var replacement = /#|\.prototype\./;

var isForced = function (feature, detection) {
  var value = data[normalize(feature)];
  return value == POLYFILL ? true
    : value == NATIVE ? false
    : typeof detection == 'function' ? _$fails_70(detection)
    : !!detection;
};

var normalize = isForced.normalize = function (string) {
  return String(string).replace(replacement, '.').toLowerCase();
};

var data = isForced.data = {};
var NATIVE = isForced.NATIVE = 'N';
var POLYFILL = isForced.POLYFILL = 'P';

var _$isForced_92 = isForced;

;
var __getOwnPropertyDescriptor_69 = _$objectGetOwnPropertyDescriptor_115.f;
;
;
;
;
;

var _$export_69 = function (options, source) {
  var TARGET = options.target;
  var GLOBAL = options.global;
  var STATIC = options.stat;
  var FORCED, target, key, targetProperty, sourceProperty, descriptor;
  if (GLOBAL) {
    target = _$global_79;
  } else if (STATIC) {
    target = _$global_79[TARGET] || _$setGlobal_135(TARGET, {});
  } else {
    target = (_$global_79[TARGET] || {}).prototype;
  }
  if (target) for (key in source) {
    sourceProperty = source[key];
    if (options.noTargetGet) {
      descriptor = __getOwnPropertyDescriptor_69(target, key);
      targetProperty = descriptor && descriptor.value;
    } else targetProperty = target[key];
    FORCED = _$isForced_92(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
    if (!FORCED && targetProperty !== undefined) {
      if (typeof sourceProperty === typeof targetProperty) continue;
      _$copyConstructorProperties_48(sourceProperty, targetProperty);
    }
    if (options.sham || (targetProperty && targetProperty.sham)) {
      _$createNonEnumerableProperty_51(sourceProperty, 'sham', true);
    }
    _$redefine_132(target, key, sourceProperty, options);
  }
};

var _$aFunction_16 = function (it) {
  if (typeof it != 'function') {
    throw TypeError(String(it) + ' is not a function');
  } return it;
};

;

var _$functionBindContext_73 = function (fn, that, length) {
  _$aFunction_16(fn);
  if (that === undefined) return fn;
  switch (length) {
    case 0: return function () {
      return fn.call(that);
    };
    case 1: return function (a) {
      return fn.call(that, a);
    };
    case 2: return function (a, b) {
      return fn.call(that, a, b);
    };
    case 3: return function (a, b, c) {
      return fn.call(that, a, b, c);
    };
  }
  return function () {
    return fn.apply(that, arguments);
  };
};

;

var _$iteratorClose_98 = function (iterator) {
  var returnMethod = iterator['return'];
  if (returnMethod !== undefined) {
    return _$anObject_20(returnMethod.call(iterator)).value;
  }
};

;
;

var _$callWithSafeIterationClosing_38 = function (iterator, fn, value, ENTRIES) {
  try {
    return ENTRIES ? fn(_$anObject_20(value)[0], value[1]) : fn(value);
  } catch (error) {
    _$iteratorClose_98(iterator);
    throw error;
  }
};

var _$iterators_100 = {};

;
;

var ITERATOR = _$wellKnownSymbol_158('iterator');
var ArrayPrototype = Array.prototype;

var _$isArrayIteratorMethod_90 = function (it) {
  return it !== undefined && (_$iterators_100.Array === it || ArrayPrototype[ITERATOR] === it);
};

'use strict';
;
;
;

var _$createProperty_53 = function (object, key, value) {
  var propertyKey = _$toPropertyKey_153(key);
  if (propertyKey in object) _$objectDefineProperty_114.f(object, propertyKey, _$createPropertyDescriptor_52(0, value));
  else object[propertyKey] = value;
};

;

var TO_STRING_TAG = _$wellKnownSymbol_158('toStringTag');
var test = {};

test[TO_STRING_TAG] = 'z';

var _$toStringTagSupport_154 = String(test) === '[object z]';

;
;
;

var __TO_STRING_TAG_41 = _$wellKnownSymbol_158('toStringTag');
var CORRECT_ARGUMENTS = _$classofRaw_40(function () { return arguments; }()) == 'Arguments';

var tryGet = function (it, key) {
  try {
    return it[key];
  } catch (error) {  }
};

var _$classof_41 = _$toStringTagSupport_154 ? _$classofRaw_40 : function (it) {
  var O, tag, result;
  return it === undefined ? 'Undefined' : it === null ? 'Null'
    : typeof (tag = tryGet(O = Object(it), __TO_STRING_TAG_41)) == 'string' ? tag
    : CORRECT_ARGUMENTS ? _$classofRaw_40(O)
    : (result = _$classofRaw_40(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : result;
};

;
;
;

var __ITERATOR_75 = _$wellKnownSymbol_158('iterator');

var _$getIteratorMethod_75 = function (it) {
  if (it != undefined) return it[__ITERATOR_75]
    || it['@@iterator']
    || _$iterators_100[_$classof_41(it)];
};

'use strict';
;
;
;
;
;
;
;

var _$from_25 = function from(arrayLike ) {
  var O = _$toObject_151(arrayLike);
  var C = typeof this == 'function' ? this : Array;
  var argumentsLength = arguments.length;
  var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
  var mapping = mapfn !== undefined;
  var iteratorMethod = _$getIteratorMethod_75(O);
  var index = 0;
  var length, result, step, iterator, next, value;
  if (mapping) mapfn = _$functionBindContext_73(mapfn, argumentsLength > 2 ? arguments[2] : undefined, 2);
  if (iteratorMethod != undefined && !(C == Array && _$isArrayIteratorMethod_90(iteratorMethod))) {
    iterator = iteratorMethod.call(O);
    next = iterator.next;
    result = new C();
    for (;!(step = next.call(iterator)).done; index++) {
      value = mapping ? _$callWithSafeIterationClosing_38(iterator, mapfn, [step.value, index], true) : step.value;
      _$createProperty_53(result, index, value);
    }
  } else {
    length = _$toLength_150(O.length);
    result = new C(length);
    for (;length > index; index++) {
      value = mapping ? mapfn(O[index], index) : O[index];
      _$createProperty_53(result, index, value);
    }
  }
  result.length = index;
  return result;
};

;

var __ITERATOR_39 = _$wellKnownSymbol_158('iterator');
var SAFE_CLOSING = false;

try {
  var called = 0;
  var iteratorWithReturn = {
    next: function () {
      return { done: !!called++ };
    },
    'return': function () {
      SAFE_CLOSING = true;
    }
  };
  iteratorWithReturn[__ITERATOR_39] = function () {
    return this;
  };
  Array.from(iteratorWithReturn, function () { throw 2; });
} catch (error) {  }

var _$checkCorrectnessOfIteration_39 = function (exec, SKIP_CLOSING) {
  if (!SKIP_CLOSING && !SAFE_CLOSING) return false;
  var ITERATION_SUPPORT = false;
  try {
    var object = {};
    object[__ITERATOR_39] = function () {
      return {
        next: function () {
          return { done: ITERATION_SUPPORT = true };
        }
      };
    };
    exec(object);
  } catch (error) {  }
  return ITERATION_SUPPORT;
};

var _$esArrayFrom_171 = {};
;
;
;

var INCORRECT_ITERATION = !_$checkCorrectnessOfIteration_39(function (iterable) {
  Array.from(iterable);
});

_$export_69({ target: 'Array', stat: true, forced: INCORRECT_ITERATION }, {
  from: _$from_25
});

;

var _$isArray_91 = Array.isArray || function isArray(arg) {
  return _$classofRaw_40(arg) == 'Array';
};

var _$esArrayIsArray_174 = {};
;
;

_$export_69({ target: 'Array', stat: true }, {
  isArray: _$isArray_91
});

var _$esArrayOf_179 = {};
'use strict';
;
;
;

var ISNT_GENERIC = _$fails_70(function () {
  function F() {  }
  return !(Array.of.call(F) instanceof F);
});

_$export_69({ target: 'Array', stat: true, forced: ISNT_GENERIC }, {
  of: function of() {
    var index = 0;
    var argumentsLength = arguments.length;
    var result = new (typeof this == 'function' ? this : Array)(argumentsLength);
    while (argumentsLength > index) _$createProperty_53(result, index, arguments[index++]);
    result.length = argumentsLength;
    return result;
  }
});

;
;
;

var SPECIES = _$wellKnownSymbol_158('species');

var _$arraySpeciesConstructor_35 = function (originalArray) {
  var C;
  if (_$isArray_91(originalArray)) {
    C = originalArray.constructor;
    if (typeof C == 'function' && (C === Array || _$isArray_91(C.prototype))) C = undefined;
    else if (_$isObject_94(C)) {
      C = C[SPECIES];
      if (C === null) C = undefined;
    }
  } return C === undefined ? Array : C;
};

;

var _$arraySpeciesCreate_36 = function (originalArray, length) {
  return new (_$arraySpeciesConstructor_35(originalArray))(length === 0 ? 0 : length);
};

;
;
;

var __SPECIES_31 = _$wellKnownSymbol_158('species');

var _$arrayMethodHasSpeciesSupport_31 = function (METHOD_NAME) {
  return _$engineV8Version_66 >= 51 || !_$fails_70(function () {
    var array = [];
    var constructor = array.constructor = {};
    constructor[__SPECIES_31] = function () {
      return { foo: 1 };
    };
    return array[METHOD_NAME](Boolean).foo !== 1;
  });
};

var _$esArrayConcat_161 = {};
'use strict';
;
;
;
;
;
;
;
;
;
;
;

var IS_CONCAT_SPREADABLE = _$wellKnownSymbol_158('isConcatSpreadable');
var MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFF;
var MAXIMUM_ALLOWED_INDEX_EXCEEDED = 'Maximum allowed index exceeded';

var IS_CONCAT_SPREADABLE_SUPPORT = _$engineV8Version_66 >= 51 || !_$fails_70(function () {
  var array = [];
  array[IS_CONCAT_SPREADABLE] = false;
  return array.concat()[0] !== array;
});

var SPECIES_SUPPORT = _$arrayMethodHasSpeciesSupport_31('concat');

var isConcatSpreadable = function (O) {
  if (!_$isObject_94(O)) return false;
  var spreadable = O[IS_CONCAT_SPREADABLE];
  return spreadable !== undefined ? !!spreadable : _$isArray_91(O);
};

var FORCED = !IS_CONCAT_SPREADABLE_SUPPORT || !SPECIES_SUPPORT;

_$export_69({ target: 'Array', proto: true, forced: FORCED }, {
  concat: function concat(arg) {
    var O = _$toObject_151(this);
    var A = _$arraySpeciesCreate_36(O, 0);
    var n = 0;
    var i, k, length, len, E;
    for (i = -1, length = arguments.length; i < length; i++) {
      E = i === -1 ? O : arguments[i];
      if (isConcatSpreadable(E)) {
        len = _$toLength_150(E.length);
        if (n + len > MAX_SAFE_INTEGER) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);
        for (k = 0; k < len; k++, n++) if (k in E) _$createProperty_53(A, n, E[k]);
      } else {
        if (n >= MAX_SAFE_INTEGER) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);
        _$createProperty_53(A, n++, E);
      }
    }
    A.length = n;
    return A;
  }
});

'use strict';
;
;
;

var __min_21 = Math.min;

var _$arrayCopyWithin_21 = [].copyWithin || function copyWithin(target , start ) {
  var O = _$toObject_151(this);
  var len = _$toLength_150(O.length);
  var to = _$toAbsoluteIndex_147(target, len);
  var from = _$toAbsoluteIndex_147(start, len);
  var end = arguments.length > 2 ? arguments[2] : undefined;
  var count = __min_21((end === undefined ? len : _$toAbsoluteIndex_147(end, len)) - from, len - to);
  var inc = 1;
  if (from < to && to < from + count) {
    inc = -1;
    from += count - 1;
    to += count - 1;
  }
  while (count-- > 0) {
    if (from in O) O[to] = O[from];
    else delete O[to];
    to += inc;
    from += inc;
  } return O;
};

;
;

var _$objectKeys_121 = Object.keys || function keys(O) {
  return _$objectKeysInternal_120(O, _$enumBugKeys_68);
};

;
;
;
;

var _$objectDefineProperties_113 = _$descriptors_55 ? Object.defineProperties : function defineProperties(O, Properties) {
  _$anObject_20(O);
  var keys = _$objectKeys_121(Properties);
  var length = keys.length;
  var index = 0;
  var key;
  while (length > index) _$objectDefineProperty_114.f(O, key = keys[index++], Properties[key]);
  return O;
};

;

var _$html_83 = _$getBuiltIn_74('document', 'documentElement');

;
;
;
;
;
;
;

var GT = '>';
var LT = '<';
var PROTOTYPE = 'prototype';
var SCRIPT = 'script';
var IE_PROTO = _$sharedKey_138('IE_PROTO');

var EmptyConstructor = function () {  };

var scriptTag = function (content) {
  return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
};

var NullProtoObjectViaActiveX = function (activeXDocument) {
  activeXDocument.write(scriptTag(''));
  activeXDocument.close();
  var temp = activeXDocument.parentWindow.Object;
  activeXDocument = null; 
  return temp;
};

var NullProtoObjectViaIFrame = function () {
  var iframe = _$documentCreateElement_56('iframe');
  var JS = 'java' + SCRIPT + ':';
  var iframeDocument;
  iframe.style.display = 'none';
  _$html_83.appendChild(iframe);
  iframe.src = String(JS);
  iframeDocument = iframe.contentWindow.document;
  iframeDocument.open();
  iframeDocument.write(scriptTag('document.F=Object'));
  iframeDocument.close();
  return iframeDocument.F;
};

var activeXDocument;
var NullProtoObject = function () {
  try {
    activeXDocument = new ActiveXObject('htmlfile');
  } catch (error) {  }
  NullProtoObject = typeof document != 'undefined'
    ? document.domain && activeXDocument
      ? NullProtoObjectViaActiveX(activeXDocument) 
      : NullProtoObjectViaIFrame()
    : NullProtoObjectViaActiveX(activeXDocument); 
  var length = _$enumBugKeys_68.length;
  while (length--) delete NullProtoObject[PROTOTYPE][_$enumBugKeys_68[length]];
  return NullProtoObject();
};

_$hiddenKeys_81[IE_PROTO] = true;

var _$objectCreate_112 = Object.create || function create(O, Properties) {
  var result;
  if (O !== null) {
    EmptyConstructor[PROTOTYPE] = _$anObject_20(O);
    result = new EmptyConstructor();
    EmptyConstructor[PROTOTYPE] = null;
    result[IE_PROTO] = O;
  } else result = NullProtoObject();
  return Properties === undefined ? result : _$objectDefineProperties_113(result, Properties);
};

;
;
;

var UNSCOPABLES = _$wellKnownSymbol_158('unscopables');
var __ArrayPrototype_18 = Array.prototype;

if (__ArrayPrototype_18[UNSCOPABLES] == undefined) {
  _$objectDefineProperty_114.f(__ArrayPrototype_18, UNSCOPABLES, {
    configurable: true,
    value: _$objectCreate_112(null)
  });
}

var _$addToUnscopables_18 = function (key) {
  __ArrayPrototype_18[UNSCOPABLES][key] = true;
};

var _$esArrayCopyWithin_162 = {};
;
;
;

_$export_69({ target: 'Array', proto: true }, {
  copyWithin: _$arrayCopyWithin_21
});

_$addToUnscopables_18('copyWithin');

;
;
;
;
;

var push = [].push;

var __createMethod_29 = function (TYPE) {
  var IS_MAP = TYPE == 1;
  var IS_FILTER = TYPE == 2;
  var IS_SOME = TYPE == 3;
  var IS_EVERY = TYPE == 4;
  var IS_FIND_INDEX = TYPE == 6;
  var IS_FILTER_REJECT = TYPE == 7;
  var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
  return function ($this, callbackfn, that, specificCreate) {
    var O = _$toObject_151($this);
    var self = _$indexedObject_85(O);
    var boundFunction = _$functionBindContext_73(callbackfn, that, 3);
    var length = _$toLength_150(self.length);
    var index = 0;
    var create = specificCreate || _$arraySpeciesCreate_36;
    var target = IS_MAP ? create($this, length) : IS_FILTER || IS_FILTER_REJECT ? create($this, 0) : undefined;
    var value, result;
    for (;length > index; index++) if (NO_HOLES || index in self) {
      value = self[index];
      result = boundFunction(value, index, O);
      if (TYPE) {
        if (IS_MAP) target[index] = result; 
        else if (result) switch (TYPE) {
          case 3: return true;              
          case 5: return value;             
          case 6: return index;             
          case 2: push.call(target, value); 
        } else switch (TYPE) {
          case 4: return false;             
          case 7: push.call(target, value); 
        }
      }
    }
    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
  };
};

var _$arrayIteration_29 = {
  forEach: __createMethod_29(0),
  map: __createMethod_29(1),
  filter: __createMethod_29(2),
  some: __createMethod_29(3),
  every: __createMethod_29(4),
  find: __createMethod_29(5),
  findIndex: __createMethod_29(6),
  filterReject: __createMethod_29(7)
};

'use strict';
;

var _$arrayMethodIsStrict_32 = function (METHOD_NAME, argument) {
  var method = [][METHOD_NAME];
  return !!method && _$fails_70(function () {
    method.call(null, argument || function () { throw 1; }, 1);
  });
};

var _$esArrayEvery_163 = {};
'use strict';
;
var $every = _$arrayIteration_29.every;
;

var STRICT_METHOD = _$arrayMethodIsStrict_32('every');

_$export_69({ target: 'Array', proto: true, forced: !STRICT_METHOD }, {
  every: function every(callbackfn ) {
    return $every(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});

'use strict';
;
;
;

var _$fill_22 = function fill(value ) {
  var O = _$toObject_151(this);
  var length = _$toLength_150(O.length);
  var argumentsLength = arguments.length;
  var index = _$toAbsoluteIndex_147(argumentsLength > 1 ? arguments[1] : undefined, length);
  var end = argumentsLength > 2 ? arguments[2] : undefined;
  var endPos = end === undefined ? length : _$toAbsoluteIndex_147(end, length);
  while (endPos > index) O[index++] = value;
  return O;
};

var _$esArrayFill_164 = {};
;
;
;

_$export_69({ target: 'Array', proto: true }, {
  fill: _$fill_22
});

_$addToUnscopables_18('fill');

var _$esArrayFilter_165 = {};
'use strict';
;
var $filter = _$arrayIteration_29.filter;
;

var HAS_SPECIES_SUPPORT = _$arrayMethodHasSpeciesSupport_31('filter');

_$export_69({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT }, {
  filter: function filter(callbackfn ) {
    return $filter(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});

var _$esArrayFind_167 = {};
'use strict';
;
var $find = _$arrayIteration_29.find;
;

var FIND = 'find';
var SKIPS_HOLES = true;

if (FIND in []) Array(1)[FIND](function () { SKIPS_HOLES = false; });

_$export_69({ target: 'Array', proto: true, forced: SKIPS_HOLES }, {
  find: function find(callbackfn ) {
    return $find(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});

_$addToUnscopables_18(FIND);

var _$esArrayFindIndex_166 = {};
'use strict';
;
var $findIndex = _$arrayIteration_29.findIndex;
;

var FIND_INDEX = 'findIndex';
var __SKIPS_HOLES_166 = true;

if (FIND_INDEX in []) Array(1)[FIND_INDEX](function () { __SKIPS_HOLES_166 = false; });

_$export_69({ target: 'Array', proto: true, forced: __SKIPS_HOLES_166 }, {
  findIndex: function findIndex(callbackfn ) {
    return $findIndex(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});

_$addToUnscopables_18(FIND_INDEX);

'use strict';
;
;
;

var flattenIntoArray = function (target, original, source, sourceLen, start, depth, mapper, thisArg) {
  var targetIndex = start;
  var sourceIndex = 0;
  var mapFn = mapper ? _$functionBindContext_73(mapper, thisArg, 3) : false;
  var element;

  while (sourceIndex < sourceLen) {
    if (sourceIndex in source) {
      element = mapFn ? mapFn(source[sourceIndex], sourceIndex, original) : source[sourceIndex];

      if (depth > 0 && _$isArray_91(element)) {
        targetIndex = flattenIntoArray(target, original, element, _$toLength_150(element.length), targetIndex, depth - 1) - 1;
      } else {
        if (targetIndex >= 0x1FFFFFFFFFFFFF) throw TypeError('Exceed the acceptable array length');
        target[targetIndex] = element;
      }

      targetIndex++;
    }
    sourceIndex++;
  }
  return targetIndex;
};

var _$flattenIntoArray_71 = flattenIntoArray;

var _$esArrayFlat_169 = {};
'use strict';
;
;
;
;
;
;

_$export_69({ target: 'Array', proto: true }, {
  flat: function flat() {
    var depthArg = arguments.length ? arguments[0] : undefined;
    var O = _$toObject_151(this);
    var sourceLen = _$toLength_150(O.length);
    var A = _$arraySpeciesCreate_36(O, 0);
    A.length = _$flattenIntoArray_71(A, O, O, sourceLen, 0, depthArg === undefined ? 1 : _$toInteger_149(depthArg));
    return A;
  }
});

var _$esArrayFlatMap_168 = {};
'use strict';
;
;
;
;
;
;

_$export_69({ target: 'Array', proto: true }, {
  flatMap: function flatMap(callbackfn ) {
    var O = _$toObject_151(this);
    var sourceLen = _$toLength_150(O.length);
    var A;
    _$aFunction_16(callbackfn);
    A = _$arraySpeciesCreate_36(O, 0);
    A.length = _$flattenIntoArray_71(A, O, O, sourceLen, 0, 1, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
    return A;
  }
});

'use strict';
var $forEach = _$arrayIteration_29.forEach;
;

var __STRICT_METHOD_23 = _$arrayMethodIsStrict_32('forEach');

var _$arrayForEach_23 = !__STRICT_METHOD_23 ? function forEach(callbackfn ) {
  return $forEach(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
} : [].forEach;

var _$esArrayForEach_170 = {};
'use strict';
;
;

_$export_69({ target: 'Array', proto: true, forced: [].forEach != _$arrayForEach_23 }, {
  forEach: _$arrayForEach_23
});

var _$esArrayIncludes_172 = {};
'use strict';
;
var $includes = _$arrayIncludes_27.includes;
;

_$export_69({ target: 'Array', proto: true }, {
  includes: function includes(el ) {
    return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);
  }
});

_$addToUnscopables_18('includes');

var _$esArrayIndexOf_173 = {};
'use strict';
;
var $indexOf = _$arrayIncludes_27.indexOf;
;

var nativeIndexOf = [].indexOf;

var NEGATIVE_ZERO = !!nativeIndexOf && 1 / [1].indexOf(1, -0) < 0;
var __STRICT_METHOD_173 = _$arrayMethodIsStrict_32('indexOf');

_$export_69({ target: 'Array', proto: true, forced: NEGATIVE_ZERO || !__STRICT_METHOD_173 }, {
  indexOf: function indexOf(searchElement ) {
    return NEGATIVE_ZERO
      ? nativeIndexOf.apply(this, arguments) || 0
      : $indexOf(this, searchElement, arguments.length > 1 ? arguments[1] : undefined);
  }
});

;

var _$correctPrototypeGetter_49 = !_$fails_70(function () {
  function F() {  }
  F.prototype.constructor = null;
  return Object.getPrototypeOf(new F()) !== F.prototype;
});

;
;
;
;

var __IE_PROTO_119 = _$sharedKey_138('IE_PROTO');
var ObjectPrototype = Object.prototype;

var _$objectGetPrototypeOf_119 = _$correctPrototypeGetter_49 ? Object.getPrototypeOf : function (O) {
  O = _$toObject_151(O);
  if (_$has_80(O, __IE_PROTO_119)) return O[__IE_PROTO_119];
  if (typeof O.constructor == 'function' && O instanceof O.constructor) {
    return O.constructor.prototype;
  } return O instanceof Object ? ObjectPrototype : null;
};

'use strict';
;
;
;
;
;
;

var __ITERATOR_99 = _$wellKnownSymbol_158('iterator');
var BUGGY_SAFARI_ITERATORS = false;

var returnThis = function () { return this; };

var IteratorPrototype, PrototypeOfArrayIteratorPrototype, arrayIterator;

if ([].keys) {
  arrayIterator = [].keys();
  if (!('next' in arrayIterator)) BUGGY_SAFARI_ITERATORS = true;
  else {
    PrototypeOfArrayIteratorPrototype = _$objectGetPrototypeOf_119(_$objectGetPrototypeOf_119(arrayIterator));
    if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype = PrototypeOfArrayIteratorPrototype;
  }
}

var NEW_ITERATOR_PROTOTYPE = IteratorPrototype == undefined || _$fails_70(function () {
  var test = {};
  return IteratorPrototype[__ITERATOR_99].call(test) !== test;
});

if (NEW_ITERATOR_PROTOTYPE) IteratorPrototype = {};

if ((!_$isPure_95 || NEW_ITERATOR_PROTOTYPE) && !_$has_80(IteratorPrototype, __ITERATOR_99)) {
  _$createNonEnumerableProperty_51(IteratorPrototype, __ITERATOR_99, returnThis);
}

var _$iteratorsCore_99 = {
  IteratorPrototype: IteratorPrototype,
  BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS
};

var defineProperty = _$objectDefineProperty_114.f;
;
;

var __TO_STRING_TAG_137 = _$wellKnownSymbol_158('toStringTag');

var _$setToStringTag_137 = function (it, TAG, STATIC) {
  if (it && !_$has_80(it = STATIC ? it : it.prototype, __TO_STRING_TAG_137)) {
    defineProperty(it, __TO_STRING_TAG_137, { configurable: true, value: TAG });
  }
};

'use strict';
var __IteratorPrototype_50 = _$iteratorsCore_99.IteratorPrototype;
;
;
;
;

var __returnThis_50 = function () { return this; };

var _$createIteratorConstructor_50 = function (IteratorConstructor, NAME, next) {
  var TO_STRING_TAG = NAME + ' Iterator';
  IteratorConstructor.prototype = _$objectCreate_112(__IteratorPrototype_50, { next: _$createPropertyDescriptor_52(1, next) });
  _$setToStringTag_137(IteratorConstructor, TO_STRING_TAG, false, true);
  _$iterators_100[TO_STRING_TAG] = __returnThis_50;
  return IteratorConstructor;
};

;

var _$aPossiblePrototype_17 = function (it) {
  if (!_$isObject_94(it) && it !== null) {
    throw TypeError("Can't set " + String(it) + ' as a prototype');
  } return it;
};

;
;

var _$objectSetPrototypeOf_123 = Object.setPrototypeOf || ('__proto__' in {} ? function () {
  var CORRECT_SETTER = false;
  var test = {};
  var setter;
  try {
    setter = Object.getOwnPropertyDescriptor(Object.prototype, '__proto__').set;
    setter.call(test, []);
    CORRECT_SETTER = test instanceof Array;
  } catch (error) {  }
  return function setPrototypeOf(O, proto) {
    _$anObject_20(O);
    _$aPossiblePrototype_17(proto);
    if (CORRECT_SETTER) setter.call(O, proto);
    else O.__proto__ = proto;
    return O;
  };
}() : undefined);

'use strict';
;
;
;
;
;
;
;
;
;
;
;

var __IteratorPrototype_54 = _$iteratorsCore_99.IteratorPrototype;
var __BUGGY_SAFARI_ITERATORS_54 = _$iteratorsCore_99.BUGGY_SAFARI_ITERATORS;
var __ITERATOR_54 = _$wellKnownSymbol_158('iterator');
var KEYS = 'keys';
var VALUES = 'values';
var ENTRIES = 'entries';

var __returnThis_54 = function () { return this; };

var _$defineIterator_54 = function (Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
  _$createIteratorConstructor_50(IteratorConstructor, NAME, next);

  var getIterationMethod = function (KIND) {
    if (KIND === DEFAULT && defaultIterator) return defaultIterator;
    if (!__BUGGY_SAFARI_ITERATORS_54 && KIND in IterablePrototype) return IterablePrototype[KIND];
    switch (KIND) {
      case KEYS: return function keys() { return new IteratorConstructor(this, KIND); };
      case VALUES: return function values() { return new IteratorConstructor(this, KIND); };
      case ENTRIES: return function entries() { return new IteratorConstructor(this, KIND); };
    } return function () { return new IteratorConstructor(this); };
  };

  var TO_STRING_TAG = NAME + ' Iterator';
  var INCORRECT_VALUES_NAME = false;
  var IterablePrototype = Iterable.prototype;
  var nativeIterator = IterablePrototype[__ITERATOR_54]
    || IterablePrototype['@@iterator']
    || DEFAULT && IterablePrototype[DEFAULT];
  var defaultIterator = !__BUGGY_SAFARI_ITERATORS_54 && nativeIterator || getIterationMethod(DEFAULT);
  var anyNativeIterator = NAME == 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
  var CurrentIteratorPrototype, methods, KEY;

  if (anyNativeIterator) {
    CurrentIteratorPrototype = _$objectGetPrototypeOf_119(anyNativeIterator.call(new Iterable()));
    if (__IteratorPrototype_54 !== Object.prototype && CurrentIteratorPrototype.next) {
      if (!_$isPure_95 && _$objectGetPrototypeOf_119(CurrentIteratorPrototype) !== __IteratorPrototype_54) {
        if (_$objectSetPrototypeOf_123) {
          _$objectSetPrototypeOf_123(CurrentIteratorPrototype, __IteratorPrototype_54);
        } else if (typeof CurrentIteratorPrototype[__ITERATOR_54] != 'function') {
          _$createNonEnumerableProperty_51(CurrentIteratorPrototype, __ITERATOR_54, __returnThis_54);
        }
      }
      _$setToStringTag_137(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
      if (_$isPure_95) _$iterators_100[TO_STRING_TAG] = __returnThis_54;
    }
  }

  if (DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
    INCORRECT_VALUES_NAME = true;
    defaultIterator = function values() { return nativeIterator.call(this); };
  }

  if ((!_$isPure_95 || FORCED) && IterablePrototype[__ITERATOR_54] !== defaultIterator) {
    _$createNonEnumerableProperty_51(IterablePrototype, __ITERATOR_54, defaultIterator);
  }
  _$iterators_100[NAME] = defaultIterator;

  if (DEFAULT) {
    methods = {
      values: getIterationMethod(VALUES),
      keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
      entries: getIterationMethod(ENTRIES)
    };
    if (FORCED) for (KEY in methods) {
      if (__BUGGY_SAFARI_ITERATORS_54 || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
        _$redefine_132(IterablePrototype, KEY, methods[KEY]);
      }
    } else _$export_69({ target: NAME, proto: true, forced: __BUGGY_SAFARI_ITERATORS_54 || INCORRECT_VALUES_NAME }, methods);
  }

  return methods;
};

'use strict';
;
;
;
;
;

var ARRAY_ITERATOR = 'Array Iterator';
var setInternalState = _$internalState_89.set;
var __getInternalState_175 = _$internalState_89.getterFor(ARRAY_ITERATOR);

var _$esArrayIterator_175 = _$defineIterator_54(Array, 'Array', function (iterated, kind) {
  setInternalState(this, {
    type: ARRAY_ITERATOR,
    target: _$toIndexedObject_148(iterated), 
    index: 0,                          
    kind: kind                         
  });
}, function () {
  var state = __getInternalState_175(this);
  var target = state.target;
  var kind = state.kind;
  var index = state.index++;
  if (!target || index >= target.length) {
    state.target = undefined;
    return { value: undefined, done: true };
  }
  if (kind == 'keys') return { value: index, done: false };
  if (kind == 'values') return { value: target[index], done: false };
  return { value: [index, target[index]], done: false };
}, 'values');

_$iterators_100.Arguments = _$iterators_100.Array;

_$addToUnscopables_18('keys');
_$addToUnscopables_18('values');
_$addToUnscopables_18('entries');

var _$esArrayJoin_176 = {};
'use strict';
;
;
;
;

var nativeJoin = [].join;

var ES3_STRINGS = _$indexedObject_85 != Object;
var __STRICT_METHOD_176 = _$arrayMethodIsStrict_32('join', ',');

_$export_69({ target: 'Array', proto: true, forced: ES3_STRINGS || !__STRICT_METHOD_176 }, {
  join: function join(separator) {
    return nativeJoin.call(_$toIndexedObject_148(this), separator === undefined ? ',' : separator);
  }
});

'use strict';
;
;
;
;

var __min_30 = Math.min;
var $lastIndexOf = [].lastIndexOf;
var __NEGATIVE_ZERO_30 = !!$lastIndexOf && 1 / [1].lastIndexOf(1, -0) < 0;
var __STRICT_METHOD_30 = _$arrayMethodIsStrict_32('lastIndexOf');
var __FORCED_30 = __NEGATIVE_ZERO_30 || !__STRICT_METHOD_30;

var _$arrayLastIndexOf_30 = __FORCED_30 ? function lastIndexOf(searchElement ) {
  if (__NEGATIVE_ZERO_30) return $lastIndexOf.apply(this, arguments) || 0;
  var O = _$toIndexedObject_148(this);
  var length = _$toLength_150(O.length);
  var index = length - 1;
  if (arguments.length > 1) index = __min_30(index, _$toInteger_149(arguments[1]));
  if (index < 0) index = length + index;
  for (;index >= 0; index--) if (index in O && O[index] === searchElement) return index || 0;
  return -1;
} : $lastIndexOf;

var _$esArrayLastIndexOf_177 = {};
;
;

_$export_69({ target: 'Array', proto: true, forced: _$arrayLastIndexOf_30 !== [].lastIndexOf }, {
  lastIndexOf: _$arrayLastIndexOf_30
});

var _$esArrayMap_178 = {};
'use strict';
;
var $map = _$arrayIteration_29.map;
;

var __HAS_SPECIES_SUPPORT_178 = _$arrayMethodHasSpeciesSupport_31('map');

_$export_69({ target: 'Array', proto: true, forced: !__HAS_SPECIES_SUPPORT_178 }, {
  map: function map(callbackfn ) {
    return $map(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});

;
;
;
;

var __createMethod_33 = function (IS_RIGHT) {
  return function (that, callbackfn, argumentsLength, memo) {
    _$aFunction_16(callbackfn);
    var O = _$toObject_151(that);
    var self = _$indexedObject_85(O);
    var length = _$toLength_150(O.length);
    var index = IS_RIGHT ? length - 1 : 0;
    var i = IS_RIGHT ? -1 : 1;
    if (argumentsLength < 2) while (true) {
      if (index in self) {
        memo = self[index];
        index += i;
        break;
      }
      index += i;
      if (IS_RIGHT ? index < 0 : length <= index) {
        throw TypeError('Reduce of empty array with no initial value');
      }
    }
    for (;IS_RIGHT ? index >= 0 : length > index; index += i) if (index in self) {
      memo = callbackfn(memo, self[index], index, O);
    }
    return memo;
  };
};

var _$arrayReduce_33 = {
  left: __createMethod_33(false),
  right: __createMethod_33(true)
};

;
;

var _$engineIsNode_63 = _$classofRaw_40(_$global_79.process) == 'process';

var _$esArrayReduce_181 = {};
'use strict';
;
var $reduce = _$arrayReduce_33.left;
;
;
;

var __STRICT_METHOD_181 = _$arrayMethodIsStrict_32('reduce');
var CHROME_BUG = !_$engineIsNode_63 && _$engineV8Version_66 > 79 && _$engineV8Version_66 < 83;

_$export_69({ target: 'Array', proto: true, forced: !__STRICT_METHOD_181 || CHROME_BUG }, {
  reduce: function reduce(callbackfn ) {
    return $reduce(this, callbackfn, arguments.length, arguments.length > 1 ? arguments[1] : undefined);
  }
});

var _$esArrayReduceRight_180 = {};
'use strict';
;
var $reduceRight = _$arrayReduce_33.right;
;
;
;

var __STRICT_METHOD_180 = _$arrayMethodIsStrict_32('reduceRight');
var __CHROME_BUG_180 = !_$engineIsNode_63 && _$engineV8Version_66 > 79 && _$engineV8Version_66 < 83;

_$export_69({ target: 'Array', proto: true, forced: !__STRICT_METHOD_180 || __CHROME_BUG_180 }, {
  reduceRight: function reduceRight(callbackfn ) {
    return $reduceRight(this, callbackfn, arguments.length, arguments.length > 1 ? arguments[1] : undefined);
  }
});

var _$esArrayReverse_182 = {};
'use strict';
;
;

var nativeReverse = [].reverse;
var __test_182 = [1, 2];

_$export_69({ target: 'Array', proto: true, forced: String(__test_182) === String(__test_182.reverse()) }, {
  reverse: function reverse() {
    if (_$isArray_91(this)) this.length = this.length;
    return nativeReverse.call(this);
  }
});

var _$esArraySlice_183 = {};
'use strict';
;
;
;
;
;
;
;
;
;

var __HAS_SPECIES_SUPPORT_183 = _$arrayMethodHasSpeciesSupport_31('slice');

var __SPECIES_183 = _$wellKnownSymbol_158('species');
var nativeSlice = [].slice;
var __max_183 = Math.max;

_$export_69({ target: 'Array', proto: true, forced: !__HAS_SPECIES_SUPPORT_183 }, {
  slice: function slice(start, end) {
    var O = _$toIndexedObject_148(this);
    var length = _$toLength_150(O.length);
    var k = _$toAbsoluteIndex_147(start, length);
    var fin = _$toAbsoluteIndex_147(end === undefined ? length : end, length);
    var Constructor, result, n;
    if (_$isArray_91(O)) {
      Constructor = O.constructor;
      if (typeof Constructor == 'function' && (Constructor === Array || _$isArray_91(Constructor.prototype))) {
        Constructor = undefined;
      } else if (_$isObject_94(Constructor)) {
        Constructor = Constructor[__SPECIES_183];
        if (Constructor === null) Constructor = undefined;
      }
      if (Constructor === Array || Constructor === undefined) {
        return nativeSlice.call(O, k, fin);
      }
    }
    result = new (Constructor === undefined ? Array : Constructor)(__max_183(fin - k, 0));
    for (n = 0; k < fin; k++, n++) if (k in O) _$createProperty_53(result, n, O[k]);
    result.length = n;
    return result;
  }
});

var _$esArraySome_184 = {};
'use strict';
;
var $some = _$arrayIteration_29.some;
;

var __STRICT_METHOD_184 = _$arrayMethodIsStrict_32('some');

_$export_69({ target: 'Array', proto: true, forced: !__STRICT_METHOD_184 }, {
  some: function some(callbackfn ) {
    return $some(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});

;

var _$toString_155 = function (argument) {
  if (_$isSymbol_96(argument)) throw TypeError('Cannot convert a Symbol value to a string');
  return String(argument);
};

var __floor_34 = Math.floor;

var mergeSort = function (array, comparefn) {
  var length = array.length;
  var middle = __floor_34(length / 2);
  return length < 8 ? insertionSort(array, comparefn) : merge(
    mergeSort(array.slice(0, middle), comparefn),
    mergeSort(array.slice(middle), comparefn),
    comparefn
  );
};

var insertionSort = function (array, comparefn) {
  var length = array.length;
  var i = 1;
  var element, j;

  while (i < length) {
    j = i;
    element = array[i];
    while (j && comparefn(array[j - 1], element) > 0) {
      array[j] = array[--j];
    }
    if (j !== i++) array[j] = element;
  } return array;
};

var merge = function (left, right, comparefn) {
  var llength = left.length;
  var rlength = right.length;
  var lindex = 0;
  var rindex = 0;
  var result = [];

  while (lindex < llength || rindex < rlength) {
    if (lindex < llength && rindex < rlength) {
      result.push(comparefn(left[lindex], right[rindex]) <= 0 ? left[lindex++] : right[rindex++]);
    } else {
      result.push(lindex < llength ? left[lindex++] : right[rindex++]);
    }
  } return result;
};

var _$mergeSort_34 = mergeSort;

;

var firefox = _$engineUserAgent_65.match(/firefox\/(\d+)/i);

var _$engineFfVersion_58 = !!firefox && +firefox[1];

;

var _$engineIsIeOrEdge_60 = /MSIE|Trident/.test(_$engineUserAgent_65);

;

var webkit = _$engineUserAgent_65.match(/AppleWebKit\/(\d+)\./);

var _$engineWebkitVersion_67 = !!webkit && +webkit[1];

var _$esArraySort_185 = {};
'use strict';
;
;
;
;
;
;
;
;
;
;
;
;

var __test_185 = [];
var nativeSort = __test_185.sort;

var FAILS_ON_UNDEFINED = _$fails_70(function () {
  __test_185.sort(undefined);
});
var FAILS_ON_NULL = _$fails_70(function () {
  __test_185.sort(null);
});
var __STRICT_METHOD_185 = _$arrayMethodIsStrict_32('sort');

var STABLE_SORT = !_$fails_70(function () {
  if (_$engineV8Version_66) return _$engineV8Version_66 < 70;
  if (_$engineFfVersion_58 && _$engineFfVersion_58 > 3) return;
  if (_$engineIsIeOrEdge_60) return true;
  if (_$engineWebkitVersion_67) return _$engineWebkitVersion_67 < 603;

  var result = '';
  var code, chr, value, index;

  for (code = 65; code < 76; code++) {
    chr = String.fromCharCode(code);

    switch (code) {
      case 66: case 69: case 70: case 72: value = 3; break;
      case 68: case 71: value = 4; break;
      default: value = 2;
    }

    for (index = 0; index < 47; index++) {
      __test_185.push({ k: chr + index, v: value });
    }
  }

  __test_185.sort(function (a, b) { return b.v - a.v; });

  for (index = 0; index < __test_185.length; index++) {
    chr = __test_185[index].k.charAt(0);
    if (result.charAt(result.length - 1) !== chr) result += chr;
  }

  return result !== 'DGBEFHACIJK';
});

var __FORCED_185 = FAILS_ON_UNDEFINED || !FAILS_ON_NULL || !__STRICT_METHOD_185 || !STABLE_SORT;

var getSortCompare = function (comparefn) {
  return function (x, y) {
    if (y === undefined) return -1;
    if (x === undefined) return 1;
    if (comparefn !== undefined) return +comparefn(x, y) || 0;
    return _$toString_155(x) > _$toString_155(y) ? 1 : -1;
  };
};

_$export_69({ target: 'Array', proto: true, forced: __FORCED_185 }, {
  sort: function sort(comparefn) {
    if (comparefn !== undefined) _$aFunction_16(comparefn);

    var array = _$toObject_151(this);

    if (STABLE_SORT) return comparefn === undefined ? nativeSort.call(array) : nativeSort.call(array, comparefn);

    var items = [];
    var arrayLength = _$toLength_150(array.length);
    var itemsLength, index;

    for (index = 0; index < arrayLength; index++) {
      if (index in array) items.push(array[index]);
    }

    items = _$mergeSort_34(items, getSortCompare(comparefn));
    itemsLength = items.length;
    index = 0;

    while (index < itemsLength) array[index] = items[index++];
    while (index < arrayLength) delete array[index++];

    return array;
  }
});

'use strict';
;
;
;
;

var __SPECIES_136 = _$wellKnownSymbol_158('species');

var _$setSpecies_136 = function (CONSTRUCTOR_NAME) {
  var Constructor = _$getBuiltIn_74(CONSTRUCTOR_NAME);
  var defineProperty = _$objectDefineProperty_114.f;

  if (_$descriptors_55 && Constructor && !Constructor[__SPECIES_136]) {
    defineProperty(Constructor, __SPECIES_136, {
      configurable: true,
      get: function () { return this; }
    });
  }
};

var _$esArraySpecies_186 = {};
;

_$setSpecies_136('Array');

var _$esArraySplice_187 = {};
'use strict';
;
;
;
;
;
;
;
;

var __HAS_SPECIES_SUPPORT_187 = _$arrayMethodHasSpeciesSupport_31('splice');

var __max_187 = Math.max;
var __min_187 = Math.min;
var __MAX_SAFE_INTEGER_187 = 0x1FFFFFFFFFFFFF;
var MAXIMUM_ALLOWED_LENGTH_EXCEEDED = 'Maximum allowed length exceeded';

_$export_69({ target: 'Array', proto: true, forced: !__HAS_SPECIES_SUPPORT_187 }, {
  splice: function splice(start, deleteCount ) {
    var O = _$toObject_151(this);
    var len = _$toLength_150(O.length);
    var actualStart = _$toAbsoluteIndex_147(start, len);
    var argumentsLength = arguments.length;
    var insertCount, actualDeleteCount, A, k, from, to;
    if (argumentsLength === 0) {
      insertCount = actualDeleteCount = 0;
    } else if (argumentsLength === 1) {
      insertCount = 0;
      actualDeleteCount = len - actualStart;
    } else {
      insertCount = argumentsLength - 2;
      actualDeleteCount = __min_187(__max_187(_$toInteger_149(deleteCount), 0), len - actualStart);
    }
    if (len + insertCount - actualDeleteCount > __MAX_SAFE_INTEGER_187) {
      throw TypeError(MAXIMUM_ALLOWED_LENGTH_EXCEEDED);
    }
    A = _$arraySpeciesCreate_36(O, actualDeleteCount);
    for (k = 0; k < actualDeleteCount; k++) {
      from = actualStart + k;
      if (from in O) _$createProperty_53(A, k, O[from]);
    }
    A.length = actualDeleteCount;
    if (insertCount < actualDeleteCount) {
      for (k = actualStart; k < len - actualDeleteCount; k++) {
        from = k + actualDeleteCount;
        to = k + insertCount;
        if (from in O) O[to] = O[from];
        else delete O[to];
      }
      for (k = len; k > len - actualDeleteCount + insertCount; k--) delete O[k - 1];
    } else if (insertCount > actualDeleteCount) {
      for (k = len - actualDeleteCount; k > actualStart; k--) {
        from = k + actualDeleteCount - 1;
        to = k + insertCount - 1;
        if (from in O) O[to] = O[from];
        else delete O[to];
      }
    }
    for (k = 0; k < insertCount; k++) {
      O[k + actualStart] = arguments[k + 2];
    }
    O.length = len - actualDeleteCount + insertCount;
    return A;
  }
});

var _$esArrayUnscopablesFlat_189 = {};
;

_$addToUnscopables_18('flat');

var _$esArrayUnscopablesFlatMap_188 = {};
;

_$addToUnscopables_18('flatMap');

'use strict';
;
;

var _$objectToString_125 = _$toStringTagSupport_154 ? {}.toString : function toString() {
  return '[object ' + _$classof_41(this) + ']';
};

var _$esObjectToString_203 = {};
;
;
;

if (!_$toStringTagSupport_154) {
  _$redefine_132(Object.prototype, 'toString', _$objectToString_125, { unsafe: true });
}

;
;
;

var __createMethod_142 = function (CONVERT_TO_STRING) {
  return function ($this, pos) {
    var S = _$toString_155(_$requireObjectCoercible_133($this));
    var position = _$toInteger_149(pos);
    var size = S.length;
    var first, second;
    if (position < 0 || position >= size) return CONVERT_TO_STRING ? '' : undefined;
    first = S.charCodeAt(position);
    return first < 0xD800 || first > 0xDBFF || position + 1 === size
      || (second = S.charCodeAt(position + 1)) < 0xDC00 || second > 0xDFFF
        ? CONVERT_TO_STRING ? S.charAt(position) : first
        : CONVERT_TO_STRING ? S.slice(position, position + 2) : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
  };
};

var _$stringMultibyte_142 = {
  charAt: __createMethod_142(true)
};

var _$esStringIterator_210 = {};
'use strict';
var charAt = _$stringMultibyte_142.charAt;
;
;
;

var STRING_ITERATOR = 'String Iterator';
var __setInternalState_210 = _$internalState_89.set;
var __getInternalState_210 = _$internalState_89.getterFor(STRING_ITERATOR);

_$defineIterator_54(String, 'String', function (iterated) {
  __setInternalState_210(this, {
    type: STRING_ITERATOR,
    string: _$toString_155(iterated),
    index: 0
  });
}, function next() {
  var state = __getInternalState_210(this);
  var string = state.string;
  var index = state.index;
  var point;
  if (index >= string.length) return { value: undefined, done: true };
  point = charAt(string, index);
  state.index += point.length;
  return { value: point, done: false };
});

;

var _$global_128 = _$global_79;

_$esArrayFrom_171;
_$esArrayIsArray_174;
_$esArrayOf_179;
_$esArrayConcat_161;
_$esArrayCopyWithin_162;
_$esArrayEvery_163;
_$esArrayFill_164;
_$esArrayFilter_165;
_$esArrayFind_167;
_$esArrayFindIndex_166;
_$esArrayFlat_169;
_$esArrayFlatMap_168;
_$esArrayForEach_170;
_$esArrayIncludes_172;
_$esArrayIndexOf_173;
_$esArrayIterator_175;
_$esArrayJoin_176;
_$esArrayLastIndexOf_177;
_$esArrayMap_178;
_$esArrayReduce_181;
_$esArrayReduceRight_180;
_$esArrayReverse_182;
_$esArraySlice_183;
_$esArraySome_184;
_$esArraySort_185;
_$esArraySpecies_186;
_$esArraySplice_187;
_$esArrayUnscopablesFlat_189;
_$esArrayUnscopablesFlatMap_188;
_$esObjectToString_203;
_$esStringIterator_210;
;

var _$array_4 = _$global_128.Array;

;

var _$parent_266 = _$array_4;

var _$objectGetOwnPropertyNamesExternal_116 = {};
;
var $getOwnPropertyNames = _$objectGetOwnPropertyNames_117.f;

var __toString_116 = {}.toString;

var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames
  ? Object.getOwnPropertyNames(window) : [];

var getWindowNames = function (it) {
  try {
    return $getOwnPropertyNames(it);
  } catch (error) {
    return windowNames.slice();
  }
};

_$objectGetOwnPropertyNamesExternal_116.f = function getOwnPropertyNames(it) {
  return windowNames && __toString_116.call(it) == '[object Window]'
    ? getWindowNames(it)
    : $getOwnPropertyNames(_$toIndexedObject_148(it));
};

;

var _$freezing_72 = !_$fails_70(function () {
  return Object.isExtensible(Object.preventExtensions({}));
});

var _$internalMetadata_88 = {};
;
;
;
;
var __defineProperty_88 = _$objectDefineProperty_114.f;
;
;
;
;

var REQUIRED = false;
var METADATA = _$uid_156('meta');
var __id_88 = 0;

var isExtensible = Object.isExtensible || function () {
  return true;
};

var setMetadata = function (it) {
  __defineProperty_88(it, METADATA, { value: {
    objectID: 'O' + __id_88++, 
    weakData: {}          
  } });
};

var fastKey = function (it, create) {
  if (!_$isObject_94(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
  if (!_$has_80(it, METADATA)) {
    if (!isExtensible(it)) return 'F';
    if (!create) return 'E';
    setMetadata(it);
  } return it[METADATA].objectID;
};

var getWeakData = function (it, create) {
  if (!_$has_80(it, METADATA)) {
    if (!isExtensible(it)) return true;
    if (!create) return false;
    setMetadata(it);
  } return it[METADATA].weakData;
};

var onFreeze = function (it) {
  if (_$freezing_72 && REQUIRED && isExtensible(it) && !_$has_80(it, METADATA)) setMetadata(it);
  return it;
};

var enable = function () {
  meta.enable = function () {  };
  REQUIRED = true;
  var getOwnPropertyNames = _$objectGetOwnPropertyNames_117.f;
  var splice = [].splice;
  var test = {};
  test[METADATA] = 1;

  if (getOwnPropertyNames(test).length) {
    _$objectGetOwnPropertyNames_117.f = function (it) {
      var result = getOwnPropertyNames(it);
      for (var i = 0, length = result.length; i < length; i++) {
        if (result[i] === METADATA) {
          splice.call(result, i, 1);
          break;
        }
      } return result;
    };

    _$export_69({ target: 'Object', stat: true, forced: true }, {
      getOwnPropertyNames: _$objectGetOwnPropertyNamesExternal_116.f
    });
  }
};

var meta = _$internalMetadata_88 = {
  enable: enable,
  fastKey: fastKey,
};

_$hiddenKeys_81[METADATA] = true;

;
;
;
;
;
;

var Result = function (stopped, result) {
  this.stopped = stopped;
  this.result = result;
};

var _$iterate_97 = function (iterable, unboundFunction, options) {
  var that = options && options.that;
  var AS_ENTRIES = !!(options && options.AS_ENTRIES);
  var IS_ITERATOR = !!(options && options.IS_ITERATOR);
  var INTERRUPTED = !!(options && options.INTERRUPTED);
  var fn = _$functionBindContext_73(unboundFunction, that, 1 + AS_ENTRIES + INTERRUPTED);
  var iterator, iterFn, index, length, result, next, step;

  var stop = function (condition) {
    if (iterator) _$iteratorClose_98(iterator);
    return new Result(true, condition);
  };

  var callFn = function (value) {
    if (AS_ENTRIES) {
      _$anObject_20(value);
      return INTERRUPTED ? fn(value[0], value[1], stop) : fn(value[0], value[1]);
    } return INTERRUPTED ? fn(value, stop) : fn(value);
  };

  if (IS_ITERATOR) {
    iterator = iterable;
  } else {
    iterFn = _$getIteratorMethod_75(iterable);
    if (typeof iterFn != 'function') throw TypeError('Target is not iterable');
    if (_$isArrayIteratorMethod_90(iterFn)) {
      for (index = 0, length = _$toLength_150(iterable.length); length > index; index++) {
        result = callFn(iterable[index]);
        if (result && result instanceof Result) return result;
      } return new Result(false);
    }
    iterator = iterFn.call(iterable);
  }

  next = iterator.next;
  while (!(step = next.call(iterator)).done) {
    try {
      result = callFn(step.value);
    } catch (error) {
      _$iteratorClose_98(iterator);
      throw error;
    }
    if (typeof result == 'object' && result && result instanceof Result) return result;
  } return new Result(false);
};

var _$anInstance_19 = function (it, Constructor, name) {
  if (!(it instanceof Constructor)) {
    throw TypeError('Incorrect ' + (name ? name + ' ' : '') + 'invocation');
  } return it;
};

;
;

var _$inheritIfRequired_86 = function ($this, dummy, Wrapper) {
  var NewTarget, NewTargetPrototype;
  if (
    _$objectSetPrototypeOf_123 &&
    typeof (NewTarget = dummy.constructor) == 'function' &&
    NewTarget !== Wrapper &&
    _$isObject_94(NewTargetPrototype = NewTarget.prototype) &&
    NewTargetPrototype !== Wrapper.prototype
  ) _$objectSetPrototypeOf_123($this, NewTargetPrototype);
  return $this;
};

'use strict';
;
;
;
;
;
;
;
;
;
;
;
;

var _$collection_47 = function (CONSTRUCTOR_NAME, wrapper, common) {
  var IS_MAP = CONSTRUCTOR_NAME.indexOf('Map') !== -1;
  var IS_WEAK = CONSTRUCTOR_NAME.indexOf('Weak') !== -1;
  var ADDER = IS_MAP ? 'set' : 'add';
  var NativeConstructor = _$global_79[CONSTRUCTOR_NAME];
  var NativePrototype = NativeConstructor && NativeConstructor.prototype;
  var Constructor = NativeConstructor;
  var exported = {};

  var fixMethod = function (KEY) {
    var nativeMethod = NativePrototype[KEY];
    _$redefine_132(NativePrototype, KEY,
      KEY == 'add' ? function add(value) {
        nativeMethod.call(this, value === 0 ? 0 : value);
        return this;
      } : KEY == 'delete' ? function (key) {
        return IS_WEAK && !_$isObject_94(key) ? false : nativeMethod.call(this, key === 0 ? 0 : key);
      } : KEY == 'get' ? function get(key) {
        return IS_WEAK && !_$isObject_94(key) ? undefined : nativeMethod.call(this, key === 0 ? 0 : key);
      } : KEY == 'has' ? function has(key) {
        return IS_WEAK && !_$isObject_94(key) ? false : nativeMethod.call(this, key === 0 ? 0 : key);
      } : function set(key, value) {
        nativeMethod.call(this, key === 0 ? 0 : key, value);
        return this;
      }
    );
  };

  var REPLACE = _$isForced_92(
    CONSTRUCTOR_NAME,
    typeof NativeConstructor != 'function' || !(IS_WEAK || NativePrototype.forEach && !_$fails_70(function () {
      new NativeConstructor().entries().next();
    }))
  );

  if (REPLACE) {
    Constructor = common.getConstructor(wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER);
    _$internalMetadata_88.enable();
  } else if (_$isForced_92(CONSTRUCTOR_NAME, true)) {
    var instance = new Constructor();
    var HASNT_CHAINING = instance[ADDER](IS_WEAK ? {} : -0, 1) != instance;
    var THROWS_ON_PRIMITIVES = _$fails_70(function () { instance.has(1); });
    var ACCEPT_ITERABLES = _$checkCorrectnessOfIteration_39(function (iterable) { new NativeConstructor(iterable); });
    var BUGGY_ZERO = !IS_WEAK && _$fails_70(function () {
      var $instance = new NativeConstructor();
      var index = 5;
      while (index--) $instance[ADDER](index, index);
      return !$instance.has(-0);
    });

    if (!ACCEPT_ITERABLES) {
      Constructor = wrapper(function (dummy, iterable) {
        _$anInstance_19(dummy, Constructor, CONSTRUCTOR_NAME);
        var that = _$inheritIfRequired_86(new NativeConstructor(), dummy, Constructor);
        if (iterable != undefined) _$iterate_97(iterable, that[ADDER], { that: that, AS_ENTRIES: IS_MAP });
        return that;
      });
      Constructor.prototype = NativePrototype;
      NativePrototype.constructor = Constructor;
    }

    if (THROWS_ON_PRIMITIVES || BUGGY_ZERO) {
      fixMethod('delete');
      fixMethod('has');
      IS_MAP && fixMethod('get');
    }

    if (BUGGY_ZERO || HASNT_CHAINING) fixMethod(ADDER);

    if (IS_WEAK && NativePrototype.clear) delete NativePrototype.clear;
  }

  exported[CONSTRUCTOR_NAME] = Constructor;
  _$export_69({ global: true, forced: Constructor != NativeConstructor }, exported);

  _$setToStringTag_137(Constructor, CONSTRUCTOR_NAME);

  if (!IS_WEAK) common.setStrong(Constructor, CONSTRUCTOR_NAME, IS_MAP);

  return Constructor;
};

;

var _$redefineAll_131 = function (target, src, options) {
  for (var key in src) _$redefine_132(target, key, src[key], options);
  return target;
};

'use strict';
var __defineProperty_46 = _$objectDefineProperty_114.f;
;
;
;
;
;
;
;
;
var __fastKey_46 = _$internalMetadata_88.fastKey;
;

var __setInternalState_46 = _$internalState_89.set;
var internalStateGetterFor = _$internalState_89.getterFor;

var _$collectionStrong_46 = {
  getConstructor: function (wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
    var C = wrapper(function (that, iterable) {
      _$anInstance_19(that, C, CONSTRUCTOR_NAME);
      __setInternalState_46(that, {
        type: CONSTRUCTOR_NAME,
        index: _$objectCreate_112(null),
        first: undefined,
        last: undefined,
        size: 0
      });
      if (!_$descriptors_55) that.size = 0;
      if (iterable != undefined) _$iterate_97(iterable, that[ADDER], { that: that, AS_ENTRIES: IS_MAP });
    });

    var getInternalState = internalStateGetterFor(CONSTRUCTOR_NAME);

    var define = function (that, key, value) {
      var state = getInternalState(that);
      var entry = getEntry(that, key);
      var previous, index;
      if (entry) {
        entry.value = value;
      } else {
        state.last = entry = {
          index: index = __fastKey_46(key, true),
          key: key,
          value: value,
          previous: previous = state.last,
          next: undefined,
          removed: false
        };
        if (!state.first) state.first = entry;
        if (previous) previous.next = entry;
        if (_$descriptors_55) state.size++;
        else that.size++;
        if (index !== 'F') state.index[index] = entry;
      } return that;
    };

    var getEntry = function (that, key) {
      var state = getInternalState(that);
      var index = __fastKey_46(key);
      var entry;
      if (index !== 'F') return state.index[index];
      for (entry = state.first; entry; entry = entry.next) {
        if (entry.key == key) return entry;
      }
    };

    _$redefineAll_131(C.prototype, {
      clear: function clear() {
        var that = this;
        var state = getInternalState(that);
        var data = state.index;
        var entry = state.first;
        while (entry) {
          entry.removed = true;
          if (entry.previous) entry.previous = entry.previous.next = undefined;
          delete data[entry.index];
          entry = entry.next;
        }
        state.first = state.last = undefined;
        if (_$descriptors_55) state.size = 0;
        else that.size = 0;
      },
      'delete': function (key) {
        var that = this;
        var state = getInternalState(that);
        var entry = getEntry(that, key);
        if (entry) {
          var next = entry.next;
          var prev = entry.previous;
          delete state.index[entry.index];
          entry.removed = true;
          if (prev) prev.next = next;
          if (next) next.previous = prev;
          if (state.first == entry) state.first = next;
          if (state.last == entry) state.last = prev;
          if (_$descriptors_55) state.size--;
          else that.size--;
        } return !!entry;
      },
      forEach: function forEach(callbackfn ) {
        var state = getInternalState(this);
        var boundFunction = _$functionBindContext_73(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
        var entry;
        while (entry = entry ? entry.next : state.first) {
          boundFunction(entry.value, entry.key, this);
          while (entry && entry.removed) entry = entry.previous;
        }
      },
      has: function has(key) {
        return !!getEntry(this, key);
      }
    });

    _$redefineAll_131(C.prototype, IS_MAP ? {
      get: function get(key) {
        var entry = getEntry(this, key);
        return entry && entry.value;
      },
      set: function set(key, value) {
        return define(this, key === 0 ? 0 : key, value);
      }
    } : {
      add: function add(value) {
        return define(this, value = value === 0 ? 0 : value, value);
      }
    });
    if (_$descriptors_55) __defineProperty_46(C.prototype, 'size', {
      get: function () {
        return getInternalState(this).size;
      }
    });
    return C;
  },
  setStrong: function (C, CONSTRUCTOR_NAME, IS_MAP) {
    var ITERATOR_NAME = CONSTRUCTOR_NAME + ' Iterator';
    var getInternalCollectionState = internalStateGetterFor(CONSTRUCTOR_NAME);
    var getInternalIteratorState = internalStateGetterFor(ITERATOR_NAME);
    _$defineIterator_54(C, CONSTRUCTOR_NAME, function (iterated, kind) {
      __setInternalState_46(this, {
        type: ITERATOR_NAME,
        target: iterated,
        state: getInternalCollectionState(iterated),
        kind: kind,
        last: undefined
      });
    }, function () {
      var state = getInternalIteratorState(this);
      var kind = state.kind;
      var entry = state.last;
      while (entry && entry.removed) entry = entry.previous;
      if (!state.target || !(state.last = entry = entry ? entry.next : state.state.first)) {
        state.target = undefined;
        return { value: undefined, done: true };
      }
      if (kind == 'keys') return { value: entry.key, done: false };
      if (kind == 'values') return { value: entry.value, done: false };
      return { value: [entry.key, entry.value], done: false };
    }, IS_MAP ? 'entries' : 'values', !IS_MAP, true);

    _$setSpecies_136(CONSTRUCTOR_NAME);
  }
};

'use strict';
;
;

var _$esMap_190 = _$collection_47('Map', function (init) {
  return function Map() { return init(this, arguments.length ? arguments[0] : undefined); };
}, _$collectionStrong_46);

var _$esnextArrayAt_212 = {};
'use strict';
;
;
;
;
;

_$export_69({ target: 'Array', proto: true }, {
  at: function at(index) {
    var O = _$toObject_151(this);
    var len = _$toLength_150(O.length);
    var relativeIndex = _$toInteger_149(index);
    var k = relativeIndex >= 0 ? relativeIndex : len + relativeIndex;
    return (k < 0 || k >= len) ? undefined : O[k];
  }
});

_$addToUnscopables_18('at');

var _$esnextArrayFilterOut_213 = {};
'use strict';
;
var $filterReject = _$arrayIteration_29.filterReject;
;

_$export_69({ target: 'Array', proto: true }, {
  filterOut: function filterOut(callbackfn ) {
    return $filterReject(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});

_$addToUnscopables_18('filterOut');

var _$esnextArrayFilterReject_214 = {};
'use strict';
;
var __$filterReject_214 = _$arrayIteration_29.filterReject;
;

_$export_69({ target: 'Array', proto: true }, {
  filterReject: function filterReject(callbackfn ) {
    return __$filterReject_214(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});

_$addToUnscopables_18('filterReject');

;
;
;
;

var __createMethod_28 = function (TYPE) {
  var IS_FIND_LAST_INDEX = TYPE == 1;
  return function ($this, callbackfn, that) {
    var O = _$toObject_151($this);
    var self = _$indexedObject_85(O);
    var boundFunction = _$functionBindContext_73(callbackfn, that, 3);
    var index = _$toLength_150(self.length);
    var value, result;
    while (index-- > 0) {
      value = self[index];
      result = boundFunction(value, index, O);
      if (result) switch (TYPE) {
        case 0: return value; 
        case 1: return index; 
      }
    }
    return IS_FIND_LAST_INDEX ? -1 : undefined;
  };
};

var _$arrayIterationFromLast_28 = {
  findLast: __createMethod_28(0),
  findLastIndex: __createMethod_28(1)
};

var _$esnextArrayFindLast_216 = {};
'use strict';
;
var $findLast = _$arrayIterationFromLast_28.findLast;
;

_$export_69({ target: 'Array', proto: true }, {
  findLast: function findLast(callbackfn ) {
    return $findLast(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});

_$addToUnscopables_18('findLast');

var _$esnextArrayFindLastIndex_215 = {};
'use strict';
;
var $findLastIndex = _$arrayIterationFromLast_28.findLastIndex;
;

_$export_69({ target: 'Array', proto: true }, {
  findLastIndex: function findLastIndex(callbackfn ) {
    return $findLastIndex(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});

_$addToUnscopables_18('findLastIndex');

var _$arrayFromConstructorAndList_24 = function (Constructor, list) {
  var index = 0;
  var length = list.length;
  var result = new Constructor(length);
  while (length > index) result[index] = list[index++];
  return result;
};

;
;
;
;
;
;
;

var __push_26 = [].push;

var _$arrayGroupBy_26 = function ($this, callbackfn, that, specificConstructor) {
  var O = _$toObject_151($this);
  var self = _$indexedObject_85(O);
  var boundFunction = _$functionBindContext_73(callbackfn, that, 3);
  var target = _$objectCreate_112(null);
  var length = _$toLength_150(self.length);
  var index = 0;
  var Constructor, key, value;
  for (;length > index; index++) {
    value = self[index];
    key = _$toPropertyKey_153(boundFunction(value, index, O));
    if (key in target) __push_26.call(target[key], value);
    else target[key] = [value];
  }
  if (specificConstructor) {
    Constructor = specificConstructor(O);
    if (Constructor !== Array) {
      for (key in target) target[key] = _$arrayFromConstructorAndList_24(Constructor, target[key]);
    }
  } return target;
};

var _$esnextArrayGroupBy_217 = {};
'use strict';
;
;
;
;

_$export_69({ target: 'Array', proto: true }, {
  groupBy: function groupBy(callbackfn ) {
    var thisArg = arguments.length > 1 ? arguments[1] : undefined;
    return _$arrayGroupBy_26(this, callbackfn, thisArg, _$arraySpeciesConstructor_35);
  }
});

_$addToUnscopables_18('groupBy');

var _$esnextArrayIsTemplateObject_218 = {};
;
;

var isFrozen = Object.isFrozen;

var isFrozenStringArray = function (array, allowUndefined) {
  if (!isFrozen || !_$isArray_91(array) || !isFrozen(array)) return false;
  var index = 0;
  var length = array.length;
  var element;
  while (index < length) {
    element = array[index++];
    if (!(typeof element === 'string' || (allowUndefined && typeof element === 'undefined'))) {
      return false;
    }
  } return length !== 0;
};

_$export_69({ target: 'Array', stat: true }, {
  isTemplateObject: function isTemplateObject(value) {
    if (!isFrozenStringArray(value, true)) return false;
    var raw = value.raw;
    if (raw.length !== value.length || !isFrozenStringArray(raw, false)) return false;
    return true;
  }
});

var _$esnextArrayLastItem_220 = {};
'use strict';
;
;
;
;
var __defineProperty_220 = _$objectDefineProperty_114.f;

if (_$descriptors_55 && !('lastItem' in [])) {
  __defineProperty_220(Array.prototype, 'lastItem', {
    configurable: true,
    get: function lastItem() {
      var O = _$toObject_151(this);
      var len = _$toLength_150(O.length);
      return len == 0 ? undefined : O[len - 1];
    },
    set: function lastItem(value) {
      var O = _$toObject_151(this);
      var len = _$toLength_150(O.length);
      return O[len == 0 ? 0 : len - 1] = value;
    }
  });

  _$addToUnscopables_18('lastItem');
}

var _$esnextArrayLastIndex_219 = {};
'use strict';
;
;
;
;
var __defineProperty_219 = _$objectDefineProperty_114.f;

if (_$descriptors_55 && !('lastIndex' in [])) {
  __defineProperty_219(Array.prototype, 'lastIndex', {
    configurable: true,
    get: function lastIndex() {
      var O = _$toObject_151(this);
      var len = _$toLength_150(O.length);
      return len == 0 ? 0 : len - 1;
    }
  });

  _$addToUnscopables_18('lastIndex');
}

'use strict';
;
;
;
;

var __push_37 = [].push;

var _$uniqueBy_37 = function uniqueBy(resolver) {
  var that = _$toObject_151(this);
  var length = _$toLength_150(that.length);
  var result = _$arraySpeciesCreate_36(that, 0);
  var Map = _$getBuiltIn_74('Map');
  var map = new Map();
  var resolverFunction, index, item, key;
  if (typeof resolver == 'function') resolverFunction = resolver;
  else if (resolver == null) resolverFunction = function (value) {
    return value;
  };
  else throw new TypeError('Incorrect resolver!');
  for (index = 0; index < length; index++) {
    item = that[index];
    key = resolverFunction(item);
    if (!map.has(key)) map.set(key, item);
  }
  map.forEach(function (value) {
    __push_37.call(result, value);
  });
  return result;
};

var _$esnextArrayUniqueBy_221 = {};
'use strict';
;
;
;

_$export_69({ target: 'Array', proto: true }, {
  uniqueBy: _$uniqueBy_37
});

_$addToUnscopables_18('uniqueBy');

;
_$esMap_190;
_$esnextArrayAt_212;
_$esnextArrayFilterOut_213;
_$esnextArrayFilterReject_214;
_$esnextArrayFindLast_216;
_$esnextArrayFindLastIndex_215;
_$esnextArrayGroupBy_217;
_$esnextArrayIsTemplateObject_218;
_$esnextArrayLastItem_220;
_$esnextArrayLastIndex_219;
_$esnextArrayUniqueBy_221;

var _$parent_10 = _$parent_266;

_$esArrayIterator_175;
_$esMap_190;
_$esObjectToString_203;
_$esStringIterator_210;
;

var _$map_5 = _$global_128.Map;

var _$domIterables_57 = {
  CSSRuleList: 0,
  CSSStyleDeclaration: 0,
  CSSValueList: 0,
  ClientRectList: 0,
  DOMRectList: 0,
  DOMStringList: 0,
  DOMTokenList: 1,
  DataTransferItemList: 0,
  FileList: 0,
  HTMLAllCollection: 0,
  HTMLCollection: 0,
  HTMLFormElement: 0,
  HTMLSelectElement: 0,
  MediaList: 0,
  MimeTypeArray: 0,
  NamedNodeMap: 0,
  NodeList: 1,
  PaintRequestList: 0,
  Plugin: 0,
  PluginArray: 0,
  SVGLengthList: 0,
  SVGNumberList: 0,
  SVGPathSegList: 0,
  SVGPointList: 0,
  SVGStringList: 0,
  SVGTransformList: 0,
  SourceBufferList: 0,
  StyleSheetList: 0,
  TextTrackCueList: 0,
  TextTrackList: 0,
  TouchList: 0
};

var _$webDomCollectionsIterator_265 = {};
;
;
;
;
;

var __ITERATOR_265 = _$wellKnownSymbol_158('iterator');
var __TO_STRING_TAG_265 = _$wellKnownSymbol_158('toStringTag');
var ArrayValues = _$esArrayIterator_175.values;

for (var COLLECTION_NAME in _$domIterables_57) {
  var Collection = _$global_79[COLLECTION_NAME];
  var CollectionPrototype = Collection && Collection.prototype;
  if (CollectionPrototype) {
    if (CollectionPrototype[__ITERATOR_265] !== ArrayValues) try {
      _$createNonEnumerableProperty_51(CollectionPrototype, __ITERATOR_265, ArrayValues);
    } catch (error) {
      CollectionPrototype[__ITERATOR_265] = ArrayValues;
    }
    if (!CollectionPrototype[__TO_STRING_TAG_265]) {
      _$createNonEnumerableProperty_51(CollectionPrototype, __TO_STRING_TAG_265, COLLECTION_NAME);
    }
    if (_$domIterables_57[COLLECTION_NAME]) for (var METHOD_NAME in _$esArrayIterator_175) {
      if (CollectionPrototype[METHOD_NAME] !== _$esArrayIterator_175[METHOD_NAME]) try {
        _$createNonEnumerableProperty_51(CollectionPrototype, METHOD_NAME, _$esArrayIterator_175[METHOD_NAME]);
      } catch (error) {
        CollectionPrototype[METHOD_NAME] = _$esArrayIterator_175[METHOD_NAME];
      }
    }
  }
}

;
_$webDomCollectionsIterator_265;

var _$parent_267 = _$map_5;

'use strict';
;
;
;

var _$from_44 = function from(source ) {
  var length = arguments.length;
  var mapFn = length > 1 ? arguments[1] : undefined;
  var mapping, array, n, boundFunction;
  _$aFunction_16(this);
  mapping = mapFn !== undefined;
  if (mapping) _$aFunction_16(mapFn);
  if (source == undefined) return new this();
  array = [];
  if (mapping) {
    n = 0;
    boundFunction = _$functionBindContext_73(mapFn, length > 2 ? arguments[2] : undefined, 2);
    _$iterate_97(source, function (nextItem) {
      array.push(boundFunction(nextItem, n++));
    });
  } else {
    _$iterate_97(source, array.push, { that: array });
  }
  return new this(array);
};

var _$esnextMapFrom_228 = {};
;
;

_$export_69({ target: 'Map', stat: true }, {
  from: _$from_44
});

'use strict';
var _$of_45 = function of() {
  var length = arguments.length;
  var A = new Array(length);
  while (length--) A[length] = arguments[length];
  return new this(A);
};

var _$esnextMapOf_236 = {};
;
;

_$export_69({ target: 'Map', stat: true }, {
  of: _$of_45
});

'use strict';
;
;

var _$collectionDeleteAll_43 = function () {
  var collection = _$anObject_20(this);
  var remover = _$aFunction_16(collection['delete']);
  var allDeleted = true;
  var wasDeleted;
  for (var k = 0, len = arguments.length; k < len; k++) {
    wasDeleted = remover.call(collection, arguments[k]);
    allDeleted = allDeleted && wasDeleted;
  }
  return !!allDeleted;
};

var _$esnextMapDeleteAll_222 = {};
'use strict';
;
;
;

_$export_69({ target: 'Map', proto: true, real: true, forced: _$isPure_95 }, {
  deleteAll: function deleteAll() {
    return _$collectionDeleteAll_43.apply(this, arguments);
  }
});

'use strict';
;

var _$emplace_101 = function emplace(key, handler) {
  var map = _$anObject_20(this);
  var value = (map.has(key) && 'update' in handler)
    ? handler.update(map.get(key), key, map)
    : handler.insert(key, map);
  map.set(key, value);
  return value;
};

var _$esnextMapEmplace_223 = {};
'use strict';
;
;
;

_$export_69({ target: 'Map', proto: true, real: true, forced: _$isPure_95 }, {
  emplace: _$emplace_101
});

var _$getMapIterator_77 = function (it) {
  return Map.prototype.entries.call(it);
};

var _$esnextMapEvery_224 = {};
'use strict';
;
;
;
;
;
;

_$export_69({ target: 'Map', proto: true, real: true, forced: _$isPure_95 }, {
  every: function every(callbackfn ) {
    var map = _$anObject_20(this);
    var iterator = _$getMapIterator_77(map);
    var boundFunction = _$functionBindContext_73(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
    return !_$iterate_97(iterator, function (key, value, stop) {
      if (!boundFunction(value, key, map)) return stop();
    }, { AS_ENTRIES: true, IS_ITERATOR: true, INTERRUPTED: true }).stopped;
  }
});

;
;
;

var __SPECIES_141 = _$wellKnownSymbol_158('species');

var _$speciesConstructor_141 = function (O, defaultConstructor) {
  var C = _$anObject_20(O).constructor;
  var S;
  return C === undefined || (S = _$anObject_20(C)[__SPECIES_141]) == undefined ? defaultConstructor : _$aFunction_16(S);
};

var _$esnextMapFilter_225 = {};
'use strict';
;
;
;
;
;
;
;
;
;

_$export_69({ target: 'Map', proto: true, real: true, forced: _$isPure_95 }, {
  filter: function filter(callbackfn ) {
    var map = _$anObject_20(this);
    var iterator = _$getMapIterator_77(map);
    var boundFunction = _$functionBindContext_73(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
    var newMap = new (_$speciesConstructor_141(map, _$getBuiltIn_74('Map')))();
    var setter = _$aFunction_16(newMap.set);
    _$iterate_97(iterator, function (key, value) {
      if (boundFunction(value, key, map)) setter.call(newMap, key, value);
    }, { AS_ENTRIES: true, IS_ITERATOR: true });
    return newMap;
  }
});

var _$esnextMapFind_227 = {};
'use strict';
;
;
;
;
;
;

_$export_69({ target: 'Map', proto: true, real: true, forced: _$isPure_95 }, {
  find: function find(callbackfn ) {
    var map = _$anObject_20(this);
    var iterator = _$getMapIterator_77(map);
    var boundFunction = _$functionBindContext_73(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
    return _$iterate_97(iterator, function (key, value, stop) {
      if (boundFunction(value, key, map)) return stop(value);
    }, { AS_ENTRIES: true, IS_ITERATOR: true, INTERRUPTED: true }).result;
  }
});

var _$esnextMapFindKey_226 = {};
'use strict';
;
;
;
;
;
;

_$export_69({ target: 'Map', proto: true, real: true, forced: _$isPure_95 }, {
  findKey: function findKey(callbackfn ) {
    var map = _$anObject_20(this);
    var iterator = _$getMapIterator_77(map);
    var boundFunction = _$functionBindContext_73(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
    return _$iterate_97(iterator, function (key, value, stop) {
      if (boundFunction(value, key, map)) return stop(key);
    }, { AS_ENTRIES: true, IS_ITERATOR: true, INTERRUPTED: true }).result;
  }
});

var _$esnextMapGroupBy_229 = {};
'use strict';
;
;
;

_$export_69({ target: 'Map', stat: true }, {
  groupBy: function groupBy(iterable, keyDerivative) {
    var newMap = new this();
    _$aFunction_16(keyDerivative);
    var has = _$aFunction_16(newMap.has);
    var get = _$aFunction_16(newMap.get);
    var set = _$aFunction_16(newMap.set);
    _$iterate_97(iterable, function (element) {
      var derivedKey = keyDerivative(element);
      if (!has.call(newMap, derivedKey)) set.call(newMap, derivedKey, [element]);
      else get.call(newMap, derivedKey).push(element);
    });
    return newMap;
  }
});

var _$sameValueZero_134 = function (x, y) {
  return x === y || x != x && y != y;
};

var _$esnextMapIncludes_230 = {};
'use strict';
;
;
;
;
;
;

_$export_69({ target: 'Map', proto: true, real: true, forced: _$isPure_95 }, {
  includes: function includes(searchElement) {
    return _$iterate_97(_$getMapIterator_77(_$anObject_20(this)), function (key, value, stop) {
      if (_$sameValueZero_134(value, searchElement)) return stop();
    }, { AS_ENTRIES: true, IS_ITERATOR: true, INTERRUPTED: true }).stopped;
  }
});

var _$esnextMapKeyBy_231 = {};
'use strict';
;
;
;

_$export_69({ target: 'Map', stat: true }, {
  keyBy: function keyBy(iterable, keyDerivative) {
    var newMap = new this();
    _$aFunction_16(keyDerivative);
    var setter = _$aFunction_16(newMap.set);
    _$iterate_97(iterable, function (element) {
      setter.call(newMap, keyDerivative(element), element);
    });
    return newMap;
  }
});

var _$esnextMapKeyOf_232 = {};
'use strict';
;
;
;
;
;

_$export_69({ target: 'Map', proto: true, real: true, forced: _$isPure_95 }, {
  keyOf: function keyOf(searchElement) {
    return _$iterate_97(_$getMapIterator_77(_$anObject_20(this)), function (key, value, stop) {
      if (value === searchElement) return stop(key);
    }, { AS_ENTRIES: true, IS_ITERATOR: true, INTERRUPTED: true }).result;
  }
});

var _$esnextMapMapKeys_233 = {};
'use strict';
;
;
;
;
;
;
;
;
;

_$export_69({ target: 'Map', proto: true, real: true, forced: _$isPure_95 }, {
  mapKeys: function mapKeys(callbackfn ) {
    var map = _$anObject_20(this);
    var iterator = _$getMapIterator_77(map);
    var boundFunction = _$functionBindContext_73(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
    var newMap = new (_$speciesConstructor_141(map, _$getBuiltIn_74('Map')))();
    var setter = _$aFunction_16(newMap.set);
    _$iterate_97(iterator, function (key, value) {
      setter.call(newMap, boundFunction(value, key, map), value);
    }, { AS_ENTRIES: true, IS_ITERATOR: true });
    return newMap;
  }
});

var _$esnextMapMapValues_234 = {};
'use strict';
;
;
;
;
;
;
;
;
;

_$export_69({ target: 'Map', proto: true, real: true, forced: _$isPure_95 }, {
  mapValues: function mapValues(callbackfn ) {
    var map = _$anObject_20(this);
    var iterator = _$getMapIterator_77(map);
    var boundFunction = _$functionBindContext_73(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
    var newMap = new (_$speciesConstructor_141(map, _$getBuiltIn_74('Map')))();
    var setter = _$aFunction_16(newMap.set);
    _$iterate_97(iterator, function (key, value) {
      setter.call(newMap, key, boundFunction(value, key, map));
    }, { AS_ENTRIES: true, IS_ITERATOR: true });
    return newMap;
  }
});

var _$esnextMapMerge_235 = {};
'use strict';
;
;
;
;
;

_$export_69({ target: 'Map', proto: true, real: true, forced: _$isPure_95 }, {
  merge: function merge(iterable ) {
    var map = _$anObject_20(this);
    var setter = _$aFunction_16(map.set);
    var argumentsLength = arguments.length;
    var i = 0;
    while (i < argumentsLength) {
      _$iterate_97(arguments[i++], setter, { that: map, AS_ENTRIES: true });
    }
    return map;
  }
});

var _$esnextMapReduce_237 = {};
'use strict';
;
;
;
;
;
;

_$export_69({ target: 'Map', proto: true, real: true, forced: _$isPure_95 }, {
  reduce: function reduce(callbackfn ) {
    var map = _$anObject_20(this);
    var iterator = _$getMapIterator_77(map);
    var noInitial = arguments.length < 2;
    var accumulator = noInitial ? undefined : arguments[1];
    _$aFunction_16(callbackfn);
    _$iterate_97(iterator, function (key, value) {
      if (noInitial) {
        noInitial = false;
        accumulator = value;
      } else {
        accumulator = callbackfn(accumulator, value, key, map);
      }
    }, { AS_ENTRIES: true, IS_ITERATOR: true });
    if (noInitial) throw TypeError('Reduce of empty map with no initial value');
    return accumulator;
  }
});

var _$esnextMapSome_238 = {};
'use strict';
;
;
;
;
;
;

_$export_69({ target: 'Map', proto: true, real: true, forced: _$isPure_95 }, {
  some: function some(callbackfn ) {
    var map = _$anObject_20(this);
    var iterator = _$getMapIterator_77(map);
    var boundFunction = _$functionBindContext_73(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
    return _$iterate_97(iterator, function (key, value, stop) {
      if (boundFunction(value, key, map)) return stop();
    }, { AS_ENTRIES: true, IS_ITERATOR: true, INTERRUPTED: true }).stopped;
  }
});

var _$esnextMapUpdate_240 = {};
'use strict';
;
;
;
;

_$export_69({ target: 'Map', proto: true, real: true, forced: _$isPure_95 }, {
  update: function update(key, callback ) {
    var map = _$anObject_20(this);
    var length = arguments.length;
    _$aFunction_16(callback);
    var isPresentInMap = map.has(key);
    if (!isPresentInMap && length < 3) {
      throw TypeError('Updating absent value');
    }
    var value = isPresentInMap ? map.get(key) : _$aFunction_16(length > 2 ? arguments[2] : undefined)(key, map);
    map.set(key, callback(value, key, map));
    return map;
  }
});

'use strict';
;

var _$upsert_102 = function upsert(key, updateFn ) {
  var map = _$anObject_20(this);
  var insertFn = arguments.length > 2 ? arguments[2] : undefined;
  var value;
  if (typeof updateFn != 'function' && typeof insertFn != 'function') {
    throw TypeError('At least one callback required');
  }
  if (map.has(key)) {
    value = map.get(key);
    if (typeof updateFn == 'function') {
      value = updateFn(value);
      map.set(key, value);
    }
  } else if (typeof insertFn == 'function') {
    value = insertFn();
    map.set(key, value);
  } return value;
};

var _$esnextMapUpsert_241 = {};
'use strict';
;
;
;

_$export_69({ target: 'Map', proto: true, real: true, forced: _$isPure_95 }, {
  upsert: _$upsert_102
});

var _$esnextMapUpdateOrInsert_239 = {};
'use strict';
;
;
;

_$export_69({ target: 'Map', proto: true, real: true, forced: _$isPure_95 }, {
  updateOrInsert: _$upsert_102
});

;
_$esnextMapFrom_228;
_$esnextMapOf_236;
_$esnextMapDeleteAll_222;
_$esnextMapEmplace_223;
_$esnextMapEvery_224;
_$esnextMapFilter_225;
_$esnextMapFind_227;
_$esnextMapFindKey_226;
_$esnextMapGroupBy_229;
_$esnextMapIncludes_230;
_$esnextMapKeyBy_231;
_$esnextMapKeyOf_232;
_$esnextMapMapKeys_233;
_$esnextMapMapValues_234;
_$esnextMapMerge_235;
_$esnextMapReduce_237;
_$esnextMapSome_238;
_$esnextMapUpdate_240;
_$esnextMapUpsert_241;
_$esnextMapUpdateOrInsert_239;

var _$parent_11 = _$parent_267;

var _$whitespaces_159 = '\u0009\u000A\u000B\u000C\u000D\u0020\u00A0\u1680\u2000\u2001\u2002' +
  '\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';

;
;
;

var whitespace = '[' + _$whitespaces_159 + ']';
var ltrim = RegExp('^' + whitespace + whitespace + '*');
var rtrim = RegExp(whitespace + whitespace + '*$');

var __createMethod_144 = function (TYPE) {
  return function ($this) {
    var string = _$toString_155(_$requireObjectCoercible_133($this));
    if (TYPE & 1) string = string.replace(ltrim, '');
    if (TYPE & 2) string = string.replace(rtrim, '');
    return string;
  };
};

var _$stringTrim_144 = {
  trim: __createMethod_144(3)
};

var _$esNumberConstructor_191 = {};
'use strict';
;
;
;
;
;
;
;
;
;
;
;
var getOwnPropertyNames = _$objectGetOwnPropertyNames_117.f;
var __getOwnPropertyDescriptor_191 = _$objectGetOwnPropertyDescriptor_115.f;
var __defineProperty_191 = _$objectDefineProperty_114.f;
var trim = _$stringTrim_144.trim;

var NUMBER = 'Number';
var NativeNumber = _$global_79[NUMBER];
var NumberPrototype = NativeNumber.prototype;

var BROKEN_CLASSOF = _$classofRaw_40(_$objectCreate_112(NumberPrototype)) == NUMBER;

var toNumber = function (argument) {
  if (_$isSymbol_96(argument)) throw TypeError('Cannot convert a Symbol value to a number');
  var it = _$toPrimitive_152(argument, 'number');
  var first, third, radix, maxCode, digits, length, index, code;
  if (typeof it == 'string' && it.length > 2) {
    it = trim(it);
    first = it.charCodeAt(0);
    if (first === 43 || first === 45) {
      third = it.charCodeAt(2);
      if (third === 88 || third === 120) return NaN; 
    } else if (first === 48) {
      switch (it.charCodeAt(1)) {
        case 66: case 98: radix = 2; maxCode = 49; break; 
        case 79: case 111: radix = 8; maxCode = 55; break; 
        default: return +it;
      }
      digits = it.slice(2);
      length = digits.length;
      for (index = 0; index < length; index++) {
        code = digits.charCodeAt(index);
        if (code < 48 || code > maxCode) return NaN;
      } return parseInt(digits, radix);
    }
  } return +it;
};

if (_$isForced_92(NUMBER, !NativeNumber(' 0o1') || !NativeNumber('0b1') || NativeNumber('+0x1'))) {
  var NumberWrapper = function Number(value) {
    var it = arguments.length < 1 ? 0 : value;
    var dummy = this;
    return dummy instanceof NumberWrapper
      && (BROKEN_CLASSOF ? _$fails_70(function () { NumberPrototype.valueOf.call(dummy); }) : _$classofRaw_40(dummy) != NUMBER)
        ? _$inheritIfRequired_86(new NativeNumber(toNumber(it)), dummy, NumberWrapper) : toNumber(it);
  };
  for (var __keys_191 = _$descriptors_55 ? getOwnPropertyNames(NativeNumber) : (
    'MAX_VALUE,MIN_VALUE,NaN,NEGATIVE_INFINITY,POSITIVE_INFINITY,' +
    'EPSILON,isFinite,isInteger,isNaN,isSafeInteger,MAX_SAFE_INTEGER,' +
    'MIN_SAFE_INTEGER,parseFloat,parseInt,isInteger,' +
    'fromString,range'
  ).split(','), j = 0, key; __keys_191.length > j; j++) {
    if (_$has_80(NativeNumber, key = __keys_191[j]) && !_$has_80(NumberWrapper, key)) {
      __defineProperty_191(NumberWrapper, key, __getOwnPropertyDescriptor_191(NativeNumber, key));
    }
  }
  NumberWrapper.prototype = NumberPrototype;
  NumberPrototype.constructor = NumberWrapper;
  _$redefine_132(_$global_79, NUMBER, NumberWrapper);
}

var _$esNumberEpsilon_192 = {};
;

_$export_69({ target: 'Number', stat: true }, {
  EPSILON: Math.pow(2, -52)
});

;

var globalIsFinite = _$global_79.isFinite;

var _$numberIsFinite_108 = Number.isFinite || function isFinite(it) {
  return typeof it == 'number' && globalIsFinite(it);
};

var _$esNumberIsFinite_193 = {};
;
;

_$export_69({ target: 'Number', stat: true }, { isFinite: _$numberIsFinite_108 });

;

var __floor_93 = Math.floor;

var _$isInteger_93 = function isInteger(it) {
  return !_$isObject_94(it) && isFinite(it) && __floor_93(it) === it;
};

var _$esNumberIsInteger_194 = {};
;
;

_$export_69({ target: 'Number', stat: true }, {
  isInteger: _$isInteger_93
});

var _$esNumberIsNan_195 = {};
;

_$export_69({ target: 'Number', stat: true }, {
  isNaN: function isNaN(number) {
    return number != number;
  }
});

var _$esNumberIsSafeInteger_196 = {};
;
;

var abs = Math.abs;

_$export_69({ target: 'Number', stat: true }, {
  isSafeInteger: function isSafeInteger(number) {
    return _$isInteger_93(number) && abs(number) <= 0x1FFFFFFFFFFFFF;
  }
});

var _$esNumberMaxSafeInteger_197 = {};
;

_$export_69({ target: 'Number', stat: true }, {
  MAX_SAFE_INTEGER: 0x1FFFFFFFFFFFFF
});

var _$esNumberMinSafeInteger_198 = {};
;

_$export_69({ target: 'Number', stat: true }, {
  MIN_SAFE_INTEGER: -0x1FFFFFFFFFFFFF
});

;
;
var __trim_109 = _$stringTrim_144.trim;
;

var $parseFloat = _$global_79.parseFloat;
var __FORCED_109 = 1 / $parseFloat(_$whitespaces_159 + '-0') !== -Infinity;

var _$numberParseFloat_109 = __FORCED_109 ? function parseFloat(string) {
  var trimmedString = __trim_109(_$toString_155(string));
  var result = $parseFloat(trimmedString);
  return result === 0 && trimmedString.charAt(0) == '-' ? -0 : result;
} : $parseFloat;

var _$esNumberParseFloat_199 = {};
;
;

_$export_69({ target: 'Number', stat: true, forced: Number.parseFloat != _$numberParseFloat_109 }, {
  parseFloat: _$numberParseFloat_109
});

;
;
var __trim_110 = _$stringTrim_144.trim;
;

var $parseInt = _$global_79.parseInt;
var hex = /^[+-]?0[Xx]/;
var __FORCED_110 = $parseInt(_$whitespaces_159 + '08') !== 8 || $parseInt(_$whitespaces_159 + '0x16') !== 22;

var _$numberParseInt_110 = __FORCED_110 ? function parseInt(string, radix) {
  var S = __trim_110(_$toString_155(string));
  return $parseInt(S, (radix >>> 0) || (hex.test(S) ? 16 : 10));
} : $parseInt;

var _$esNumberParseInt_200 = {};
;
;

_$export_69({ target: 'Number', stat: true, forced: Number.parseInt != _$numberParseInt_110 }, {
  parseInt: _$numberParseInt_110
});

;

var _$thisNumberValue_146 = function (value) {
  if (typeof value != 'number' && _$classofRaw_40(value) != 'Number') {
    throw TypeError('Incorrect invocation');
  }
  return +value;
};

'use strict';
;
;
;

var _$repeat_143 = function repeat(count) {
  var str = _$toString_155(_$requireObjectCoercible_133(this));
  var result = '';
  var n = _$toInteger_149(count);
  if (n < 0 || n == Infinity) throw RangeError('Wrong number of repetitions');
  for (;n > 0; (n >>>= 1) && (str += str)) if (n & 1) result += str;
  return result;
};

var _$esNumberToFixed_201 = {};
'use strict';
;
;
;
;
;

var nativeToFixed = 1.0.toFixed;
var __floor_201 = Math.floor;

var pow = function (x, n, acc) {
  return n === 0 ? acc : n % 2 === 1 ? pow(x, n - 1, acc * x) : pow(x * x, n / 2, acc);
};

var log = function (x) {
  var n = 0;
  var x2 = x;
  while (x2 >= 4096) {
    n += 12;
    x2 /= 4096;
  }
  while (x2 >= 2) {
    n += 1;
    x2 /= 2;
  } return n;
};

var multiply = function (data, n, c) {
  var index = -1;
  var c2 = c;
  while (++index < 6) {
    c2 += n * data[index];
    data[index] = c2 % 1e7;
    c2 = __floor_201(c2 / 1e7);
  }
};

var divide = function (data, n) {
  var index = 6;
  var c = 0;
  while (--index >= 0) {
    c += data[index];
    data[index] = __floor_201(c / n);
    c = (c % n) * 1e7;
  }
};

var dataToString = function (data) {
  var index = 6;
  var s = '';
  while (--index >= 0) {
    if (s !== '' || index === 0 || data[index] !== 0) {
      var t = String(data[index]);
      s = s === '' ? t : s + _$repeat_143.call('0', 7 - t.length) + t;
    }
  } return s;
};

var __FORCED_201 = nativeToFixed && (
  0.00008.toFixed(3) !== '0.000' ||
  0.9.toFixed(0) !== '1' ||
  1.255.toFixed(2) !== '1.25' ||
  1000000000000000128.0.toFixed(0) !== '1000000000000000128'
) || !_$fails_70(function () {
  nativeToFixed.call({});
});

_$export_69({ target: 'Number', proto: true, forced: __FORCED_201 }, {
  toFixed: function toFixed(fractionDigits) {
    var number = _$thisNumberValue_146(this);
    var fractDigits = _$toInteger_149(fractionDigits);
    var data = [0, 0, 0, 0, 0, 0];
    var sign = '';
    var result = '0';
    var e, z, j, k;

    if (fractDigits < 0 || fractDigits > 20) throw RangeError('Incorrect fraction digits');
    if (number != number) return 'NaN';
    if (number <= -1e21 || number >= 1e21) return String(number);
    if (number < 0) {
      sign = '-';
      number = -number;
    }
    if (number > 1e-21) {
      e = log(number * pow(2, 69, 1)) - 69;
      z = e < 0 ? number * pow(2, -e, 1) : number / pow(2, e, 1);
      z *= 0x10000000000000;
      e = 52 - e;
      if (e > 0) {
        multiply(data, 0, z);
        j = fractDigits;
        while (j >= 7) {
          multiply(data, 1e7, 0);
          j -= 7;
        }
        multiply(data, pow(10, j, 1), 0);
        j = e - 1;
        while (j >= 23) {
          divide(data, 1 << 23);
          j -= 23;
        }
        divide(data, 1 << j);
        multiply(data, 1, 1);
        divide(data, 2);
        result = dataToString(data);
      } else {
        multiply(data, 0, z);
        multiply(data, 1 << -e, 0);
        result = dataToString(data) + _$repeat_143.call('0', fractDigits);
      }
    }
    if (fractDigits > 0) {
      k = result.length;
      result = sign + (k <= fractDigits
        ? '0.' + _$repeat_143.call('0', fractDigits - k) + result
        : result.slice(0, k - fractDigits) + '.' + result.slice(k - fractDigits));
    } else {
      result = sign + result;
    } return result;
  }
});

var _$esNumberToPrecision_202 = {};
'use strict';
;
;
;

var nativeToPrecision = 1.0.toPrecision;

var __FORCED_202 = _$fails_70(function () {
  return nativeToPrecision.call(1, undefined) !== '1';
}) || !_$fails_70(function () {
  nativeToPrecision.call({});
});

_$export_69({ target: 'Number', proto: true, forced: __FORCED_202 }, {
  toPrecision: function toPrecision(precision) {
    return precision === undefined
      ? nativeToPrecision.call(_$thisNumberValue_146(this))
      : nativeToPrecision.call(_$thisNumberValue_146(this), precision);
  }
});

_$esNumberConstructor_191;
_$esNumberEpsilon_192;
_$esNumberIsFinite_193;
_$esNumberIsInteger_194;
_$esNumberIsNan_195;
_$esNumberIsSafeInteger_196;
_$esNumberMaxSafeInteger_197;
_$esNumberMinSafeInteger_198;
_$esNumberParseFloat_199;
_$esNumberParseInt_200;
_$esNumberToFixed_201;
_$esNumberToPrecision_202;
;

var _$number_6 = _$global_128.Number;

;

var _$parent_268 = _$number_6;

var _$esnextNumberFromString_242 = {};
'use strict';
;
;
;

var INVALID_NUMBER_REPRESENTATION = 'Invalid number representation';
var INVALID_RADIX = 'Invalid radix';
var valid = /^[\da-z]+$/;

_$export_69({ target: 'Number', stat: true }, {
  fromString: function fromString(string, radix) {
    var sign = 1;
    var R, mathNum;
    if (typeof string != 'string') throw TypeError(INVALID_NUMBER_REPRESENTATION);
    if (!string.length) throw SyntaxError(INVALID_NUMBER_REPRESENTATION);
    if (string.charAt(0) == '-') {
      sign = -1;
      string = string.slice(1);
      if (!string.length) throw SyntaxError(INVALID_NUMBER_REPRESENTATION);
    }
    R = radix === undefined ? 10 : _$toInteger_149(radix);
    if (R < 2 || R > 36) throw RangeError(INVALID_RADIX);
    if (!valid.test(string) || (mathNum = _$numberParseInt_110(string, R)).toString(R) !== string) {
      throw SyntaxError(INVALID_NUMBER_REPRESENTATION);
    }
    return sign * mathNum;
  }
});

'use strict';
;
;
;
;
;

var INCORRECT_RANGE = 'Incorrect Number.range arguments';
var NUMERIC_RANGE_ITERATOR = 'NumericRangeIterator';

var __setInternalState_111 = _$internalState_89.set;
var __getInternalState_111 = _$internalState_89.getterFor(NUMERIC_RANGE_ITERATOR);

var $RangeIterator = _$createIteratorConstructor_50(function NumericRangeIterator(start, end, option, type, zero, one) {
  if (typeof start != type || (end !== Infinity && end !== -Infinity && typeof end != type)) {
    throw new TypeError(INCORRECT_RANGE);
  }
  if (start === Infinity || start === -Infinity) {
    throw new RangeError(INCORRECT_RANGE);
  }
  var ifIncrease = end > start;
  var inclusiveEnd = false;
  var step;
  if (option === undefined) {
    step = undefined;
  } else if (_$isObject_94(option)) {
    step = option.step;
    inclusiveEnd = !!option.inclusive;
  } else if (typeof option == type) {
    step = option;
  } else {
    throw new TypeError(INCORRECT_RANGE);
  }
  if (step == null) {
    step = ifIncrease ? one : -one;
  }
  if (typeof step != type) {
    throw new TypeError(INCORRECT_RANGE);
  }
  if (step === Infinity || step === -Infinity || (step === zero && start !== end)) {
    throw new RangeError(INCORRECT_RANGE);
  }
  var hitsEnd = start != start || end != end || step != step || (end > start) !== (step > zero);
  __setInternalState_111(this, {
    type: NUMERIC_RANGE_ITERATOR,
    start: start,
    end: end,
    step: step,
    inclusiveEnd: inclusiveEnd,
    hitsEnd: hitsEnd,
    currentCount: zero,
    zero: zero
  });
  if (!_$descriptors_55) {
    this.start = start;
    this.end = end;
    this.step = step;
    this.inclusive = inclusiveEnd;
  }
}, NUMERIC_RANGE_ITERATOR, function next() {
  var state = __getInternalState_111(this);
  if (state.hitsEnd) return { value: undefined, done: true };
  var start = state.start;
  var end = state.end;
  var step = state.step;
  var currentYieldingValue = start + (step * state.currentCount++);
  if (currentYieldingValue === end) state.hitsEnd = true;
  var inclusiveEnd = state.inclusiveEnd;
  var endCondition;
  if (end > start) {
    endCondition = inclusiveEnd ? currentYieldingValue > end : currentYieldingValue >= end;
  } else {
    endCondition = inclusiveEnd ? end > currentYieldingValue : end >= currentYieldingValue;
  }
  if (endCondition) {
    return { value: undefined, done: state.hitsEnd = true };
  } return { value: currentYieldingValue, done: false };
});

var getter = function (fn) {
  return { get: fn, set: function () {  }, configurable: true, enumerable: false };
};

if (_$descriptors_55) {
  _$objectDefineProperties_113($RangeIterator.prototype, {
    start: getter(function () {
      return __getInternalState_111(this).start;
    }),
    end: getter(function () {
      return __getInternalState_111(this).end;
    }),
    inclusive: getter(function () {
      return __getInternalState_111(this).inclusiveEnd;
    }),
    step: getter(function () {
      return __getInternalState_111(this).step;
    })
  });
}

var _$$RangeIterator_111 = $RangeIterator;

var _$esnextNumberRange_243 = {};
'use strict';
;
;

_$export_69({ target: 'Number', stat: true }, {
  range: function range(start, end, option) {
    return new _$$RangeIterator_111(start, end, option, 'number', 0, 1);
  }
});

;

var _$parent_12 = _$parent_268;

_$esnextNumberFromString_242;
_$esnextNumberRange_243;

;
;
;
var propertyIsEnumerable = _$objectPropertyIsEnumerable_122.f;

var __createMethod_124 = function (TO_ENTRIES) {
  return function (it) {
    var O = _$toIndexedObject_148(it);
    var keys = _$objectKeys_121(O);
    var length = keys.length;
    var i = 0;
    var result = [];
    var key;
    while (length > i) {
      key = keys[i++];
      if (!_$descriptors_55 || propertyIsEnumerable.call(O, key)) {
        result.push(TO_ENTRIES ? [key, O[key]] : O[key]);
      }
    }
    return result;
  };
};

var _$objectToArray_124 = {
  values: __createMethod_124(false)
};

var _$esObjectValues_204 = {};
;
var $values = _$objectToArray_124.values;

_$export_69({ target: 'Object', stat: true }, {
  values: function values(O) {
    return $values(O);
  }
});

_$esObjectValues_204;
;

var _$values_7 = _$global_128.Object.values;

;

var _$parent_269 = _$values_7;

;

var _$parent_13 = _$parent_269;

var _$esAggregateError_160 = {};
'use strict';
;
;
;
;
;
;
;
;

var $AggregateError = function AggregateError(errors, message) {
  var that = this;
  if (!(that instanceof $AggregateError)) return new $AggregateError(errors, message);
  if (_$objectSetPrototypeOf_123) {
    that = _$objectSetPrototypeOf_123(new Error(undefined), _$objectGetPrototypeOf_119(that));
  }
  if (message !== undefined) _$createNonEnumerableProperty_51(that, 'message', _$toString_155(message));
  var errorsArray = [];
  _$iterate_97(errors, errorsArray.push, { that: errorsArray });
  _$createNonEnumerableProperty_51(that, 'errors', errorsArray);
  return that;
};

$AggregateError.prototype = _$objectCreate_112(Error.prototype, {
  constructor: _$createPropertyDescriptor_52(5, $AggregateError),
  message: _$createPropertyDescriptor_52(5, ''),
  name: _$createPropertyDescriptor_52(5, 'AggregateError')
});

_$export_69({ global: true }, {
  AggregateError: $AggregateError
});

;

var _$nativePromiseConstructor_104 = _$global_79.Promise;

;

var _$engineIsIos_62 = /(?:ipad|iphone|ipod).*applewebkit/i.test(_$engineUserAgent_65);

;
;
;
;
;
;
;

var __set_145 = _$global_79.setImmediate;
var clear = _$global_79.clearImmediate;
var __process_145 = _$global_79.process;
var MessageChannel = _$global_79.MessageChannel;
var Dispatch = _$global_79.Dispatch;
var counter = 0;
var queue = {};
var ONREADYSTATECHANGE = 'onreadystatechange';
var location, defer, channel, port;

try {
  location = _$global_79.location;
} catch (error) {  }

var run = function (id) {
  if (queue.hasOwnProperty(id)) {
    var fn = queue[id];
    delete queue[id];
    fn();
  }
};

var runner = function (id) {
  return function () {
    run(id);
  };
};

var listener = function (event) {
  run(event.data);
};

var post = function (id) {
  _$global_79.postMessage(String(id), location.protocol + '//' + location.host);
};

if (!__set_145 || !clear) {
  __set_145 = function setImmediate(fn) {
    var args = [];
    var argumentsLength = arguments.length;
    var i = 1;
    while (argumentsLength > i) args.push(arguments[i++]);
    queue[++counter] = function () {
      (typeof fn == 'function' ? fn : Function(fn)).apply(undefined, args);
    };
    defer(counter);
    return counter;
  };
  clear = function clearImmediate(id) {
    delete queue[id];
  };
  if (_$engineIsNode_63) {
    defer = function (id) {
      __process_145.nextTick(runner(id));
    };
  } else if (Dispatch && Dispatch.now) {
    defer = function (id) {
      Dispatch.now(runner(id));
    };
  } else if (MessageChannel && !_$engineIsIos_62) {
    channel = new MessageChannel();
    port = channel.port2;
    channel.port1.onmessage = listener;
    defer = _$functionBindContext_73(port.postMessage, port, 1);
  } else if (
    _$global_79.addEventListener &&
    typeof postMessage == 'function' &&
    !_$global_79.importScripts &&
    location && location.protocol !== 'file:' &&
    !_$fails_70(post)
  ) {
    defer = post;
    _$global_79.addEventListener('message', listener, false);
  } else if (ONREADYSTATECHANGE in _$documentCreateElement_56('script')) {
    defer = function (id) {
      _$html_83.appendChild(_$documentCreateElement_56('script'))[ONREADYSTATECHANGE] = function () {
        _$html_83.removeChild(this);
        run(id);
      };
    };
  } else {
    defer = function (id) {
      setTimeout(runner(id), 0);
    };
  }
}

var _$task_145 = {
  set: __set_145,
};

;
;

var _$engineIsIosPebble_61 = /ipad|iphone|ipod/i.test(_$engineUserAgent_65) && _$global_79.Pebble !== undefined;

;

var _$engineIsWebosWebkit_64 = /web0s(?!.*chrome)/i.test(_$engineUserAgent_65);

;
var __getOwnPropertyDescriptor_103 = _$objectGetOwnPropertyDescriptor_115.f;
var macrotask = _$task_145.set;
;
;
;
;

var MutationObserver = _$global_79.MutationObserver || _$global_79.WebKitMutationObserver;
var __document_103 = _$global_79.document;
var __process_103 = _$global_79.process;
var __Promise_103 = _$global_79.Promise;
var queueMicrotaskDescriptor = __getOwnPropertyDescriptor_103(_$global_79, 'queueMicrotask');
var queueMicrotask = queueMicrotaskDescriptor && queueMicrotaskDescriptor.value;

var flush, head, last, notify, toggle, node, promise, then;

if (!queueMicrotask) {
  flush = function () {
    var parent, fn;
    if (_$engineIsNode_63 && (parent = __process_103.domain)) parent.exit();
    while (head) {
      fn = head.fn;
      head = head.next;
      try {
        fn();
      } catch (error) {
        if (head) notify();
        else last = undefined;
        throw error;
      }
    } last = undefined;
    if (parent) parent.enter();
  };

  if (!_$engineIsIos_62 && !_$engineIsNode_63 && !_$engineIsWebosWebkit_64 && MutationObserver && __document_103) {
    toggle = true;
    node = __document_103.createTextNode('');
    new MutationObserver(flush).observe(node, { characterData: true });
    notify = function () {
      node.data = toggle = !toggle;
    };
  } else if (!_$engineIsIosPebble_61 && __Promise_103 && __Promise_103.resolve) {
    promise = __Promise_103.resolve(undefined);
    promise.constructor = __Promise_103;
    then = promise.then;
    notify = function () {
      then.call(promise, flush);
    };
  } else if (_$engineIsNode_63) {
    notify = function () {
      __process_103.nextTick(flush);
    };
  } else {
    notify = function () {
      macrotask.call(_$global_79, flush);
    };
  }
}

var _$microtask_103 = queueMicrotask || function (fn) {
  var task = { fn: fn, next: undefined };
  if (last) last.next = task;
  if (!head) {
    head = task;
    notify();
  } last = task;
};

var _$newPromiseCapability_107 = {};
'use strict';
;

var PromiseCapability = function (C) {
  var resolve, reject;
  this.promise = new C(function ($$resolve, $$reject) {
    if (resolve !== undefined || reject !== undefined) throw TypeError('Bad Promise constructor');
    resolve = $$resolve;
    reject = $$reject;
  });
  this.resolve = _$aFunction_16(resolve);
  this.reject = _$aFunction_16(reject);
};

_$newPromiseCapability_107.f = function (C) {
  return new PromiseCapability(C);
};

;
;
;

var _$promiseResolve_130 = function (C, x) {
  _$anObject_20(C);
  if (_$isObject_94(x) && x.constructor === C) return x;
  var promiseCapability = _$newPromiseCapability_107.f(C);
  var resolve = promiseCapability.resolve;
  resolve(x);
  return promiseCapability.promise;
};

;

var _$hostReportErrors_82 = function (a, b) {
  var console = _$global_79.console;
  if (console && console.error) {
    arguments.length === 1 ? console.error(a) : console.error(a, b);
  }
};

var _$perform_129 = function (exec) {
  try {
    return { error: false, value: exec() };
  } catch (error) {
    return { error: true, value: error };
  }
};

var _$engineIsBrowser_59 = typeof window == 'object';

var _$esPromise_208 = {};
'use strict';
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
var task = _$task_145.set;
;
;
;
;
;
;
;
;
;
;
;

var __SPECIES_208 = _$wellKnownSymbol_158('species');
var PROMISE = 'Promise';
var __getInternalState_208 = _$internalState_89.get;
var __setInternalState_208 = _$internalState_89.set;
var getInternalPromiseState = _$internalState_89.getterFor(PROMISE);
var NativePromisePrototype = _$nativePromiseConstructor_104 && _$nativePromiseConstructor_104.prototype;
var PromiseConstructor = _$nativePromiseConstructor_104;
var PromiseConstructorPrototype = NativePromisePrototype;
var __TypeError_208 = _$global_79.TypeError;
var __document_208 = _$global_79.document;
var __process_208 = _$global_79.process;
var __newPromiseCapability_208 = _$newPromiseCapability_107.f;
var newGenericPromiseCapability = __newPromiseCapability_208;
var DISPATCH_EVENT = !!(__document_208 && __document_208.createEvent && _$global_79.dispatchEvent);
var NATIVE_REJECTION_EVENT = typeof PromiseRejectionEvent == 'function';
var UNHANDLED_REJECTION = 'unhandledrejection';
var REJECTION_HANDLED = 'rejectionhandled';
var PENDING = 0;
var FULFILLED = 1;
var REJECTED = 2;
var HANDLED = 1;
var UNHANDLED = 2;
var SUBCLASSING = false;
var Internal, OwnPromiseCapability, PromiseWrapper, nativeThen;

var __FORCED_208 = _$isForced_92(PROMISE, function () {
  var PROMISE_CONSTRUCTOR_SOURCE = _$inspectSource_87(PromiseConstructor);
  var GLOBAL_CORE_JS_PROMISE = PROMISE_CONSTRUCTOR_SOURCE !== String(PromiseConstructor);
  if (!GLOBAL_CORE_JS_PROMISE && _$engineV8Version_66 === 66) return true;
  if (_$isPure_95 && !PromiseConstructorPrototype['finally']) return true;
  if (_$engineV8Version_66 >= 51 && /native code/.test(PROMISE_CONSTRUCTOR_SOURCE)) return false;
  var promise = new PromiseConstructor(function (resolve) { resolve(1); });
  var FakePromise = function (exec) {
    exec(function () {  }, function () {  });
  };
  var constructor = promise.constructor = {};
  constructor[__SPECIES_208] = FakePromise;
  SUBCLASSING = promise.then(function () {  }) instanceof FakePromise;
  if (!SUBCLASSING) return true;
  return !GLOBAL_CORE_JS_PROMISE && _$engineIsBrowser_59 && !NATIVE_REJECTION_EVENT;
});

var __INCORRECT_ITERATION_208 = __FORCED_208 || !_$checkCorrectnessOfIteration_39(function (iterable) {
  PromiseConstructor.all(iterable)['catch'](function () {  });
});

var isThenable = function (it) {
  var then;
  return _$isObject_94(it) && typeof (then = it.then) == 'function' ? then : false;
};

var __notify_208 = function (state, isReject) {
  if (state.notified) return;
  state.notified = true;
  var chain = state.reactions;
  _$microtask_103(function () {
    var value = state.value;
    var ok = state.state == FULFILLED;
    var index = 0;
    while (chain.length > index) {
      var reaction = chain[index++];
      var handler = ok ? reaction.ok : reaction.fail;
      var resolve = reaction.resolve;
      var reject = reaction.reject;
      var domain = reaction.domain;
      var result, then, exited;
      try {
        if (handler) {
          if (!ok) {
            if (state.rejection === UNHANDLED) onHandleUnhandled(state);
            state.rejection = HANDLED;
          }
          if (handler === true) result = value;
          else {
            if (domain) domain.enter();
            result = handler(value); 
            if (domain) {
              domain.exit();
              exited = true;
            }
          }
          if (result === reaction.promise) {
            reject(__TypeError_208('Promise-chain cycle'));
          } else if (then = isThenable(result)) {
            then.call(result, resolve, reject);
          } else resolve(result);
        } else reject(value);
      } catch (error) {
        if (domain && !exited) domain.exit();
        reject(error);
      }
    }
    state.reactions = [];
    state.notified = false;
    if (isReject && !state.rejection) onUnhandled(state);
  });
};

var dispatchEvent = function (name, promise, reason) {
  var event, handler;
  if (DISPATCH_EVENT) {
    event = __document_208.createEvent('Event');
    event.promise = promise;
    event.reason = reason;
    event.initEvent(name, false, true);
    _$global_79.dispatchEvent(event);
  } else event = { promise: promise, reason: reason };
  if (!NATIVE_REJECTION_EVENT && (handler = _$global_79['on' + name])) handler(event);
  else if (name === UNHANDLED_REJECTION) _$hostReportErrors_82('Unhandled promise rejection', reason);
};

var onUnhandled = function (state) {
  task.call(_$global_79, function () {
    var promise = state.facade;
    var value = state.value;
    var IS_UNHANDLED = isUnhandled(state);
    var result;
    if (IS_UNHANDLED) {
      result = _$perform_129(function () {
        if (_$engineIsNode_63) {
          __process_208.emit('unhandledRejection', value, promise);
        } else dispatchEvent(UNHANDLED_REJECTION, promise, value);
      });
      state.rejection = _$engineIsNode_63 || isUnhandled(state) ? UNHANDLED : HANDLED;
      if (result.error) throw result.value;
    }
  });
};

var isUnhandled = function (state) {
  return state.rejection !== HANDLED && !state.parent;
};

var onHandleUnhandled = function (state) {
  task.call(_$global_79, function () {
    var promise = state.facade;
    if (_$engineIsNode_63) {
      __process_208.emit('rejectionHandled', promise);
    } else dispatchEvent(REJECTION_HANDLED, promise, state.value);
  });
};

var __bind_208 = function (fn, state, unwrap) {
  return function (value) {
    fn(state, value, unwrap);
  };
};

var internalReject = function (state, value, unwrap) {
  if (state.done) return;
  state.done = true;
  if (unwrap) state = unwrap;
  state.value = value;
  state.state = REJECTED;
  __notify_208(state, true);
};

var internalResolve = function (state, value, unwrap) {
  if (state.done) return;
  state.done = true;
  if (unwrap) state = unwrap;
  try {
    if (state.facade === value) throw __TypeError_208("Promise can't be resolved itself");
    var then = isThenable(value);
    if (then) {
      _$microtask_103(function () {
        var wrapper = { done: false };
        try {
          then.call(value,
            __bind_208(internalResolve, wrapper, state),
            __bind_208(internalReject, wrapper, state)
          );
        } catch (error) {
          internalReject(wrapper, error, state);
        }
      });
    } else {
      state.value = value;
      state.state = FULFILLED;
      __notify_208(state, false);
    }
  } catch (error) {
    internalReject({ done: false }, error, state);
  }
};

if (__FORCED_208) {
  PromiseConstructor = function Promise(executor) {
    _$anInstance_19(this, PromiseConstructor, PROMISE);
    _$aFunction_16(executor);
    Internal.call(this);
    var state = __getInternalState_208(this);
    try {
      executor(__bind_208(internalResolve, state), __bind_208(internalReject, state));
    } catch (error) {
      internalReject(state, error);
    }
  };
  PromiseConstructorPrototype = PromiseConstructor.prototype;
  Internal = function Promise(executor) {
    __setInternalState_208(this, {
      type: PROMISE,
      done: false,
      notified: false,
      parent: false,
      reactions: [],
      rejection: false,
      state: PENDING,
      value: undefined
    });
  };
  Internal.prototype = _$redefineAll_131(PromiseConstructorPrototype, {
    then: function then(onFulfilled, onRejected) {
      var state = getInternalPromiseState(this);
      var reaction = __newPromiseCapability_208(_$speciesConstructor_141(this, PromiseConstructor));
      reaction.ok = typeof onFulfilled == 'function' ? onFulfilled : true;
      reaction.fail = typeof onRejected == 'function' && onRejected;
      reaction.domain = _$engineIsNode_63 ? __process_208.domain : undefined;
      state.parent = true;
      state.reactions.push(reaction);
      if (state.state != PENDING) __notify_208(state, false);
      return reaction.promise;
    },
    'catch': function (onRejected) {
      return this.then(undefined, onRejected);
    }
  });
  OwnPromiseCapability = function () {
    var promise = new Internal();
    var state = __getInternalState_208(promise);
    this.promise = promise;
    this.resolve = __bind_208(internalResolve, state);
    this.reject = __bind_208(internalReject, state);
  };
  _$newPromiseCapability_107.f = __newPromiseCapability_208 = function (C) {
    return C === PromiseConstructor || C === PromiseWrapper
      ? new OwnPromiseCapability(C)
      : newGenericPromiseCapability(C);
  };

  if (!_$isPure_95 && typeof _$nativePromiseConstructor_104 == 'function' && NativePromisePrototype !== Object.prototype) {
    nativeThen = NativePromisePrototype.then;

    if (!SUBCLASSING) {
      _$redefine_132(NativePromisePrototype, 'then', function then(onFulfilled, onRejected) {
        var that = this;
        return new PromiseConstructor(function (resolve, reject) {
          nativeThen.call(that, resolve, reject);
        }).then(onFulfilled, onRejected);
      }, { unsafe: true });

      _$redefine_132(NativePromisePrototype, 'catch', PromiseConstructorPrototype['catch'], { unsafe: true });
    }

    try {
      delete NativePromisePrototype.constructor;
    } catch (error) {  }

    if (_$objectSetPrototypeOf_123) {
      _$objectSetPrototypeOf_123(NativePromisePrototype, PromiseConstructorPrototype);
    }
  }
}

_$export_69({ global: true, wrap: true, forced: __FORCED_208 }, {
  Promise: PromiseConstructor
});

_$setToStringTag_137(PromiseConstructor, PROMISE, false, true);
_$setSpecies_136(PROMISE);

PromiseWrapper = _$getBuiltIn_74(PROMISE);

_$export_69({ target: PROMISE, stat: true, forced: __FORCED_208 }, {
  reject: function reject(r) {
    var capability = __newPromiseCapability_208(this);
    capability.reject.call(undefined, r);
    return capability.promise;
  }
});

_$export_69({ target: PROMISE, stat: true, forced: _$isPure_95 || __FORCED_208 }, {
  resolve: function resolve(x) {
    return _$promiseResolve_130(_$isPure_95 && this === PromiseWrapper ? PromiseConstructor : this, x);
  }
});

_$export_69({ target: PROMISE, stat: true, forced: __INCORRECT_ITERATION_208 }, {
  all: function all(iterable) {
    var C = this;
    var capability = __newPromiseCapability_208(C);
    var resolve = capability.resolve;
    var reject = capability.reject;
    var result = _$perform_129(function () {
      var $promiseResolve = _$aFunction_16(C.resolve);
      var values = [];
      var counter = 0;
      var remaining = 1;
      _$iterate_97(iterable, function (promise) {
        var index = counter++;
        var alreadyCalled = false;
        values.push(undefined);
        remaining++;
        $promiseResolve.call(C, promise).then(function (value) {
          if (alreadyCalled) return;
          alreadyCalled = true;
          values[index] = value;
          --remaining || resolve(values);
        }, reject);
      });
      --remaining || resolve(values);
    });
    if (result.error) reject(result.value);
    return capability.promise;
  },
  race: function race(iterable) {
    var C = this;
    var capability = __newPromiseCapability_208(C);
    var reject = capability.reject;
    var result = _$perform_129(function () {
      var $promiseResolve = _$aFunction_16(C.resolve);
      _$iterate_97(iterable, function (promise) {
        $promiseResolve.call(C, promise).then(capability.resolve, reject);
      });
    });
    if (result.error) reject(result.value);
    return capability.promise;
  }
});

var _$esPromiseAllSettled_205 = {};
'use strict';
;
;
;
;
;

_$export_69({ target: 'Promise', stat: true }, {
  allSettled: function allSettled(iterable) {
    var C = this;
    var capability = _$newPromiseCapability_107.f(C);
    var resolve = capability.resolve;
    var reject = capability.reject;
    var result = _$perform_129(function () {
      var promiseResolve = _$aFunction_16(C.resolve);
      var values = [];
      var counter = 0;
      var remaining = 1;
      _$iterate_97(iterable, function (promise) {
        var index = counter++;
        var alreadyCalled = false;
        values.push(undefined);
        remaining++;
        promiseResolve.call(C, promise).then(function (value) {
          if (alreadyCalled) return;
          alreadyCalled = true;
          values[index] = { status: 'fulfilled', value: value };
          --remaining || resolve(values);
        }, function (error) {
          if (alreadyCalled) return;
          alreadyCalled = true;
          values[index] = { status: 'rejected', reason: error };
          --remaining || resolve(values);
        });
      });
      --remaining || resolve(values);
    });
    if (result.error) reject(result.value);
    return capability.promise;
  }
});

var _$esPromiseAny_206 = {};
'use strict';
;
;
;
;
;
;

var PROMISE_ANY_ERROR = 'No one promise resolved';

_$export_69({ target: 'Promise', stat: true }, {
  any: function any(iterable) {
    var C = this;
    var capability = _$newPromiseCapability_107.f(C);
    var resolve = capability.resolve;
    var reject = capability.reject;
    var result = _$perform_129(function () {
      var promiseResolve = _$aFunction_16(C.resolve);
      var errors = [];
      var counter = 0;
      var remaining = 1;
      var alreadyResolved = false;
      _$iterate_97(iterable, function (promise) {
        var index = counter++;
        var alreadyRejected = false;
        errors.push(undefined);
        remaining++;
        promiseResolve.call(C, promise).then(function (value) {
          if (alreadyRejected || alreadyResolved) return;
          alreadyResolved = true;
          resolve(value);
        }, function (error) {
          if (alreadyRejected || alreadyResolved) return;
          alreadyRejected = true;
          errors[index] = error;
          --remaining || reject(new (_$getBuiltIn_74('AggregateError'))(errors, PROMISE_ANY_ERROR));
        });
      });
      --remaining || reject(new (_$getBuiltIn_74('AggregateError'))(errors, PROMISE_ANY_ERROR));
    });
    if (result.error) reject(result.value);
    return capability.promise;
  }
});

var _$esPromiseFinally_207 = {};
'use strict';
;
;
;
;
;
;
;
;

var NON_GENERIC = !!_$nativePromiseConstructor_104 && _$fails_70(function () {
  _$nativePromiseConstructor_104.prototype['finally'].call({ then: function () {  } }, function () {  });
});

_$export_69({ target: 'Promise', proto: true, real: true, forced: NON_GENERIC }, {
  'finally': function (onFinally) {
    var C = _$speciesConstructor_141(this, _$getBuiltIn_74('Promise'));
    var isFunction = typeof onFinally == 'function';
    return this.then(
      isFunction ? function (x) {
        return _$promiseResolve_130(C, onFinally()).then(function () { return x; });
      } : onFinally,
      isFunction ? function (e) {
        return _$promiseResolve_130(C, onFinally()).then(function () { throw e; });
      } : onFinally
    );
  }
});

if (!_$isPure_95 && typeof _$nativePromiseConstructor_104 == 'function') {
  var method = _$getBuiltIn_74('Promise').prototype['finally'];
  if (_$nativePromiseConstructor_104.prototype['finally'] !== method) {
    _$redefine_132(_$nativePromiseConstructor_104.prototype, 'finally', method, { unsafe: true });
  }
}

_$esAggregateError_160;
_$esArrayIterator_175;
_$esObjectToString_203;
_$esPromise_208;
_$esPromiseAllSettled_205;
_$esPromiseAny_206;
_$esPromiseFinally_207;
_$esStringIterator_210;
;

var _$promise_8 = _$global_128.Promise;

;
_$webDomCollectionsIterator_265;

var _$parent_270 = _$promise_8;

var _$esnextAggregateError_211 = {};
_$esAggregateError_160;

var _$esnextPromiseAllSettled_244 = {};
_$esPromiseAllSettled_205;

var _$esnextPromiseTry_246 = {};
'use strict';
;
;
;

_$export_69({ target: 'Promise', stat: true }, {
  'try': function (callbackfn) {
    var promiseCapability = _$newPromiseCapability_107.f(this);
    var result = _$perform_129(callbackfn);
    (result.error ? promiseCapability.reject : promiseCapability.resolve)(result.value);
    return promiseCapability.promise;
  }
});

var _$esnextPromiseAny_245 = {};
_$esPromiseAny_206;

;
_$esnextAggregateError_211;
_$esnextPromiseAllSettled_244;
_$esnextPromiseTry_246;
_$esnextPromiseAny_245;

var _$parent_14 = _$parent_270;

'use strict';
;
;

var _$esSet_209 = _$collection_47('Set', function (init) {
  return function Set() { return init(this, arguments.length ? arguments[0] : undefined); };
}, _$collectionStrong_46);

_$esArrayIterator_175;
_$esObjectToString_203;
_$esSet_209;
_$esStringIterator_210;
;

var _$set_9 = _$global_128.Set;

;
_$webDomCollectionsIterator_265;

var _$parent_271 = _$set_9;

var _$esnextSetFrom_253 = {};
;
;

_$export_69({ target: 'Set', stat: true }, {
  from: _$from_44
});

var _$esnextSetOf_260 = {};
;
;

_$export_69({ target: 'Set', stat: true }, {
  of: _$of_45
});

'use strict';
;
;

var _$collectionAddAll_42 = function () {
  var set = _$anObject_20(this);
  var adder = _$aFunction_16(set.add);
  for (var k = 0, len = arguments.length; k < len; k++) {
    adder.call(set, arguments[k]);
  }
  return set;
};

var _$esnextSetAddAll_247 = {};
'use strict';
;
;
;

_$export_69({ target: 'Set', proto: true, real: true, forced: _$isPure_95 }, {
  addAll: function addAll() {
    return _$collectionAddAll_42.apply(this, arguments);
  }
});

var _$esnextSetDeleteAll_248 = {};
'use strict';
;
;
;

_$export_69({ target: 'Set', proto: true, real: true, forced: _$isPure_95 }, {
  deleteAll: function deleteAll() {
    return _$collectionDeleteAll_43.apply(this, arguments);
  }
});

var _$getSetIterator_78 = function (it) {
  return Set.prototype.values.call(it);
};

var _$esnextSetEvery_250 = {};
'use strict';
;
;
;
;
;
;

_$export_69({ target: 'Set', proto: true, real: true, forced: _$isPure_95 }, {
  every: function every(callbackfn ) {
    var set = _$anObject_20(this);
    var iterator = _$getSetIterator_78(set);
    var boundFunction = _$functionBindContext_73(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
    return !_$iterate_97(iterator, function (value, stop) {
      if (!boundFunction(value, value, set)) return stop();
    }, { IS_ITERATOR: true, INTERRUPTED: true }).stopped;
  }
});

var _$esnextSetDifference_249 = {};
'use strict';
;
;
;
;
;
;
;

_$export_69({ target: 'Set', proto: true, real: true, forced: _$isPure_95 }, {
  difference: function difference(iterable) {
    var set = _$anObject_20(this);
    var newSet = new (_$speciesConstructor_141(set, _$getBuiltIn_74('Set')))(set);
    var remover = _$aFunction_16(newSet['delete']);
    _$iterate_97(iterable, function (value) {
      remover.call(newSet, value);
    });
    return newSet;
  }
});

var _$esnextSetFilter_251 = {};
'use strict';
;
;
;
;
;
;
;
;
;

_$export_69({ target: 'Set', proto: true, real: true, forced: _$isPure_95 }, {
  filter: function filter(callbackfn ) {
    var set = _$anObject_20(this);
    var iterator = _$getSetIterator_78(set);
    var boundFunction = _$functionBindContext_73(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
    var newSet = new (_$speciesConstructor_141(set, _$getBuiltIn_74('Set')))();
    var adder = _$aFunction_16(newSet.add);
    _$iterate_97(iterator, function (value) {
      if (boundFunction(value, value, set)) adder.call(newSet, value);
    }, { IS_ITERATOR: true });
    return newSet;
  }
});

var _$esnextSetFind_252 = {};
'use strict';
;
;
;
;
;
;

_$export_69({ target: 'Set', proto: true, real: true, forced: _$isPure_95 }, {
  find: function find(callbackfn ) {
    var set = _$anObject_20(this);
    var iterator = _$getSetIterator_78(set);
    var boundFunction = _$functionBindContext_73(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
    return _$iterate_97(iterator, function (value, stop) {
      if (boundFunction(value, value, set)) return stop(value);
    }, { IS_ITERATOR: true, INTERRUPTED: true }).result;
  }
});

var _$esnextSetIntersection_254 = {};
'use strict';
;
;
;
;
;
;
;

_$export_69({ target: 'Set', proto: true, real: true, forced: _$isPure_95 }, {
  intersection: function intersection(iterable) {
    var set = _$anObject_20(this);
    var newSet = new (_$speciesConstructor_141(set, _$getBuiltIn_74('Set')))();
    var hasCheck = _$aFunction_16(set.has);
    var adder = _$aFunction_16(newSet.add);
    _$iterate_97(iterable, function (value) {
      if (hasCheck.call(set, value)) adder.call(newSet, value);
    });
    return newSet;
  }
});

var _$esnextSetIsDisjointFrom_255 = {};
'use strict';
;
;
;
;
;

_$export_69({ target: 'Set', proto: true, real: true, forced: _$isPure_95 }, {
  isDisjointFrom: function isDisjointFrom(iterable) {
    var set = _$anObject_20(this);
    var hasCheck = _$aFunction_16(set.has);
    return !_$iterate_97(iterable, function (value, stop) {
      if (hasCheck.call(set, value) === true) return stop();
    }, { INTERRUPTED: true }).stopped;
  }
});

;
;

var _$getIterator_76 = function (it) {
  var iteratorMethod = _$getIteratorMethod_75(it);
  if (typeof iteratorMethod != 'function') {
    throw TypeError(String(it) + ' is not iterable');
  } return _$anObject_20(iteratorMethod.call(it));
};

var _$esnextSetIsSubsetOf_256 = {};
'use strict';
;
;
;
;
;
;
;

_$export_69({ target: 'Set', proto: true, real: true, forced: _$isPure_95 }, {
  isSubsetOf: function isSubsetOf(iterable) {
    var iterator = _$getIterator_76(this);
    var otherSet = _$anObject_20(iterable);
    var hasCheck = otherSet.has;
    if (typeof hasCheck != 'function') {
      otherSet = new (_$getBuiltIn_74('Set'))(iterable);
      hasCheck = _$aFunction_16(otherSet.has);
    }
    return !_$iterate_97(iterator, function (value, stop) {
      if (hasCheck.call(otherSet, value) === false) return stop();
    }, { IS_ITERATOR: true, INTERRUPTED: true }).stopped;
  }
});

var _$esnextSetIsSupersetOf_257 = {};
'use strict';
;
;
;
;
;

_$export_69({ target: 'Set', proto: true, real: true, forced: _$isPure_95 }, {
  isSupersetOf: function isSupersetOf(iterable) {
    var set = _$anObject_20(this);
    var hasCheck = _$aFunction_16(set.has);
    return !_$iterate_97(iterable, function (value, stop) {
      if (hasCheck.call(set, value) === false) return stop();
    }, { INTERRUPTED: true }).stopped;
  }
});

var _$esnextSetJoin_258 = {};
'use strict';
;
;
;
;
;

_$export_69({ target: 'Set', proto: true, real: true, forced: _$isPure_95 }, {
  join: function join(separator) {
    var set = _$anObject_20(this);
    var iterator = _$getSetIterator_78(set);
    var sep = separator === undefined ? ',' : String(separator);
    var result = [];
    _$iterate_97(iterator, result.push, { that: result, IS_ITERATOR: true });
    return result.join(sep);
  }
});

var _$esnextSetMap_259 = {};
'use strict';
;
;
;
;
;
;
;
;
;

_$export_69({ target: 'Set', proto: true, real: true, forced: _$isPure_95 }, {
  map: function map(callbackfn ) {
    var set = _$anObject_20(this);
    var iterator = _$getSetIterator_78(set);
    var boundFunction = _$functionBindContext_73(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
    var newSet = new (_$speciesConstructor_141(set, _$getBuiltIn_74('Set')))();
    var adder = _$aFunction_16(newSet.add);
    _$iterate_97(iterator, function (value) {
      adder.call(newSet, boundFunction(value, value, set));
    }, { IS_ITERATOR: true });
    return newSet;
  }
});

var _$esnextSetReduce_261 = {};
'use strict';
;
;
;
;
;
;

_$export_69({ target: 'Set', proto: true, real: true, forced: _$isPure_95 }, {
  reduce: function reduce(callbackfn ) {
    var set = _$anObject_20(this);
    var iterator = _$getSetIterator_78(set);
    var noInitial = arguments.length < 2;
    var accumulator = noInitial ? undefined : arguments[1];
    _$aFunction_16(callbackfn);
    _$iterate_97(iterator, function (value) {
      if (noInitial) {
        noInitial = false;
        accumulator = value;
      } else {
        accumulator = callbackfn(accumulator, value, value, set);
      }
    }, { IS_ITERATOR: true });
    if (noInitial) throw TypeError('Reduce of empty set with no initial value');
    return accumulator;
  }
});

var _$esnextSetSome_262 = {};
'use strict';
;
;
;
;
;
;

_$export_69({ target: 'Set', proto: true, real: true, forced: _$isPure_95 }, {
  some: function some(callbackfn ) {
    var set = _$anObject_20(this);
    var iterator = _$getSetIterator_78(set);
    var boundFunction = _$functionBindContext_73(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
    return _$iterate_97(iterator, function (value, stop) {
      if (boundFunction(value, value, set)) return stop();
    }, { IS_ITERATOR: true, INTERRUPTED: true }).stopped;
  }
});

var _$esnextSetSymmetricDifference_263 = {};
'use strict';
;
;
;
;
;
;
;

_$export_69({ target: 'Set', proto: true, real: true, forced: _$isPure_95 }, {
  symmetricDifference: function symmetricDifference(iterable) {
    var set = _$anObject_20(this);
    var newSet = new (_$speciesConstructor_141(set, _$getBuiltIn_74('Set')))(set);
    var remover = _$aFunction_16(newSet['delete']);
    var adder = _$aFunction_16(newSet.add);
    _$iterate_97(iterable, function (value) {
      remover.call(newSet, value) || adder.call(newSet, value);
    });
    return newSet;
  }
});

var _$esnextSetUnion_264 = {};
'use strict';
;
;
;
;
;
;
;

_$export_69({ target: 'Set', proto: true, real: true, forced: _$isPure_95 }, {
  union: function union(iterable) {
    var set = _$anObject_20(this);
    var newSet = new (_$speciesConstructor_141(set, _$getBuiltIn_74('Set')))(set);
    _$iterate_97(iterable, _$aFunction_16(newSet.add), { that: newSet });
    return newSet;
  }
});

;
_$esnextSetFrom_253;
_$esnextSetOf_260;
_$esnextSetAddAll_247;
_$esnextSetDeleteAll_248;
_$esnextSetEvery_250;
_$esnextSetDifference_249;
_$esnextSetFilter_251;
_$esnextSetFind_252;
_$esnextSetIntersection_254;
_$esnextSetIsDisjointFrom_255;
_$esnextSetIsSubsetOf_256;
_$esnextSetIsSupersetOf_257;
_$esnextSetJoin_258;
_$esnextSetMap_259;
_$esnextSetReduce_261;
_$esnextSetSome_262;
_$esnextSetSymmetricDifference_263;
_$esnextSetUnion_264;

var _$parent_15 = _$parent_271;

var _$errors_280 = {};
'use strict';
var __extends = this && this.__extends || function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
            d.__proto__ = b;
        } || function (d, b) {
            for (var p in b)
                if (Object.prototype.hasOwnProperty.call(b, p))
                    d[p] = b[p];
        };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== 'function' && b !== null)
            throw new TypeError('Class extends value ' + String(b) + ' is not a constructor or null');
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
Object.defineProperty(_$errors_280, '__esModule', { value: true });
_$errors_280.InternalError = _$errors_280.IllegalStateError = _$errors_280.RetryLimitError = _$errors_280.SchemaParseError = _$errors_280.SchemaViolationError = _$errors_280.InvalidScriptError = _$errors_280.InvalidFilterError = _$errors_280.OutOfBoundsError = _$errors_280.IllegalArgumentError = _$errors_280.SessionError = _$errors_280.IOError = _$errors_280.InvalidDataError = _$errors_280.AssertionError = _$errors_280.RuntimeError = _$errors_280.NullValueError = void 0;
var NullValueError = function (_super) {
    __extends(NullValueError, _super);
    function NullValueError(message) {
        return _super.call(this, message) || this;
    }
    NullValueError.prototype.getType = function () {
        return NullValueError.type;
    };
    NullValueError.type = 'null_value_error';
    return NullValueError;
}(Error);
_$errors_280.NullValueError = NullValueError;
var RuntimeError = function (_super) {
    __extends(RuntimeError, _super);
    function RuntimeError(message, cause) {
        var _this = _super.call(this, message) || this;
        _this.cause = cause;
        return _this;
    }
    RuntimeError.prototype.getType = function () {
        return RuntimeError.type;
    };
    RuntimeError.type = 'runtime_error';
    return RuntimeError;
}(Error);
_$errors_280.RuntimeError = RuntimeError;
var AssertionError = function (_super) {
    __extends(AssertionError, _super);
    function AssertionError(message) {
        return _super.call(this, message) || this;
    }
    AssertionError.prototype.getType = function () {
        return AssertionError.type;
    };
    AssertionError.type = 'assertion_error';
    return AssertionError;
}(Error);
_$errors_280.AssertionError = AssertionError;
var InvalidDataError = function (_super) {
    __extends(InvalidDataError, _super);
    function InvalidDataError(message) {
        return _super.call(this, message) || this;
    }
    InvalidDataError.prototype.getType = function () {
        return InvalidDataError.type;
    };
    InvalidDataError.type = 'invalid_data_error';
    return InvalidDataError;
}(Error);
_$errors_280.InvalidDataError = InvalidDataError;
var IOError = function (_super) {
    __extends(IOError, _super);
    function IOError(message) {
        return _super.call(this, message) || this;
    }
    IOError.prototype.getType = function () {
        return IOError.type;
    };
    IOError.type = 'io_error';
    return IOError;
}(Error);
_$errors_280.IOError = IOError;
var SessionError = function (_super) {
    __extends(SessionError, _super);
    function SessionError(message, cause) {
        var _this = _super.call(this, message) || this;
        _this.cause = cause;
        return _this;
    }
    SessionError.prototype.getType = function () {
        return SessionError.type;
    };
    SessionError.type = 'session_error';
    return SessionError;
}(Error);
_$errors_280.SessionError = SessionError;
var IllegalArgumentError = function (_super) {
    __extends(IllegalArgumentError, _super);
    function IllegalArgumentError(message) {
        return _super.call(this, message) || this;
    }
    IllegalArgumentError.prototype.getType = function () {
        return IllegalArgumentError.type;
    };
    IllegalArgumentError.type = 'illegal_argument_error';
    return IllegalArgumentError;
}(Error);
_$errors_280.IllegalArgumentError = IllegalArgumentError;
var OutOfBoundsError = function (_super) {
    __extends(OutOfBoundsError, _super);
    function OutOfBoundsError(message) {
        return _super.call(this, message) || this;
    }
    OutOfBoundsError.prototype.getType = function () {
        return OutOfBoundsError.type;
    };
    OutOfBoundsError.type = 'out_of_bounds_error';
    return OutOfBoundsError;
}(Error);
_$errors_280.OutOfBoundsError = OutOfBoundsError;
var InvalidFilterError = function (_super) {
    __extends(InvalidFilterError, _super);
    function InvalidFilterError(message, errors) {
        var _this = _super.call(this, message) || this;
        _this.errors = errors;
        return _this;
    }
    InvalidFilterError.prototype.getType = function () {
        return InvalidFilterError.type;
    };
    InvalidFilterError.type = 'invalid_filter_error';
    return InvalidFilterError;
}(Error);
_$errors_280.InvalidFilterError = InvalidFilterError;
var InvalidScriptError = function (_super) {
    __extends(InvalidScriptError, _super);
    function InvalidScriptError(message, errors) {
        var _this = _super.call(this, message) || this;
        _this.errors = errors;
        return _this;
    }
    InvalidScriptError.prototype.getType = function () {
        return InvalidScriptError.type;
    };
    InvalidScriptError.type = 'invalid_script_error';
    return InvalidScriptError;
}(Error);
_$errors_280.InvalidScriptError = InvalidScriptError;
var SchemaViolationError = function (_super) {
    __extends(SchemaViolationError, _super);
    function SchemaViolationError(message) {
        return _super.call(this, message) || this;
    }
    SchemaViolationError.prototype.getType = function () {
        return SchemaViolationError.type;
    };
    SchemaViolationError.type = 'schema_violation_error';
    return SchemaViolationError;
}(Error);
_$errors_280.SchemaViolationError = SchemaViolationError;
var SchemaParseError = function (_super) {
    __extends(SchemaParseError, _super);
    function SchemaParseError(message) {
        return _super.call(this, message) || this;
    }
    SchemaParseError.prototype.getType = function () {
        return SchemaParseError.type;
    };
    SchemaParseError.type = 'schema_parse_error';
    return SchemaParseError;
}(Error);
_$errors_280.SchemaParseError = SchemaParseError;
var RetryLimitError = function (_super) {
    __extends(RetryLimitError, _super);
    function RetryLimitError(message) {
        return _super.call(this, message) || this;
    }
    RetryLimitError.prototype.getType = function () {
        return RetryLimitError.type;
    };
    RetryLimitError.type = 'retry_limit_error';
    return RetryLimitError;
}(Error);
_$errors_280.RetryLimitError = RetryLimitError;
var IllegalStateError = function (_super) {
    __extends(IllegalStateError, _super);
    function IllegalStateError(message) {
        return _super.call(this, message) || this;
    }
    IllegalStateError.prototype.getType = function () {
        return IllegalStateError.type;
    };
    IllegalStateError.type = 'illegal_state_error';
    return IllegalStateError;
}(Error);
_$errors_280.IllegalStateError = IllegalStateError;
var InternalError = function (_super) {
    __extends(InternalError, _super);
    function InternalError(message) {
        return _super.call(this, message) || this;
    }
    InternalError.prototype.getType = function () {
        return InternalError.type;
    };
    InternalError.type = 'internal_error';
    return InternalError;
}(Error);
_$errors_280.InternalError = InternalError;
var _$connectionActivityMonitor_289 = {};
"use strict";
Object.defineProperty(_$connectionActivityMonitor_289, "__esModule", { value: true });
_$connectionActivityMonitor_289.ConnectionActivityMonitorImpl = void 0;
var ConnectionActivityMonitorImpl =  (function () {
    function ConnectionActivityMonitorImpl(pingTimeout, connection) {
        this.currentTimeout = null;
        this.pingTimeout = pingTimeout;
        this.connection = connection;
        this.currentTimeout = setTimeout(connection.closeIdleConnection.bind(connection), pingTimeout);
    }
    ConnectionActivityMonitorImpl.prototype.onSystemPing = function () {
        var _this = this;
        if (this.currentTimeout !== null) {
            clearTimeout(this.currentTimeout);
            this.currentTimeout = setTimeout(function () {
                _this.connection.closeIdleConnection();
            }, this.pingTimeout);
        }
    };
    ConnectionActivityMonitorImpl.prototype.shutdown = function () {
        if (this.currentTimeout !== null) {
            clearTimeout(this.currentTimeout);
            this.currentTimeout = null;
        }
    };
    return ConnectionActivityMonitorImpl;
}());
_$connectionActivityMonitor_289.ConnectionActivityMonitorImpl = ConnectionActivityMonitorImpl;

var _$connectionActivityMonitorFactory_288 = {};
"use strict";
Object.defineProperty(_$connectionActivityMonitorFactory_288, "__esModule", { value: true });
_$connectionActivityMonitorFactory_288.connectionActivityMonitorFactory = void 0;
;
var pingTimeoutFactor = 2;
var noop = {
    onSystemPing: function () { },
    shutdown: function () { }
};
function connectionActivityMonitorFactory(connection, response) {
    if (!response.systemPingPeriod || response.systemPingPeriod.isNegative() || response.systemPingPeriod.isZero()) {
        return noop;
    }
    var systemPingPeriod = response.systemPingPeriod.toNumber();
    var pingTimeout = systemPingPeriod * pingTimeoutFactor;
    return new _$connectionActivityMonitor_289.ConnectionActivityMonitorImpl(pingTimeout, connection);
}
_$connectionActivityMonitorFactory_288.connectionActivityMonitorFactory = connectionActivityMonitorFactory;

var _$sessionActivityMonitor_290 = {};
"use strict";
Object.defineProperty(_$sessionActivityMonitor_290, "__esModule", { value: true });
_$sessionActivityMonitor_290.sessionActivityMonitorFactory = void 0;
var SessionActivityMonitorImpl =  (function () {
    function SessionActivityMonitorImpl(factory) {
        this.factory = factory;
    }
    SessionActivityMonitorImpl.prototype.onNewConnection = function (connection, response) {
        this.currentConnectionMonitor = this.factory(connection, response);
    };
    SessionActivityMonitorImpl.prototype.onConnectionClosed = function () {
        if (this.currentConnectionMonitor !== undefined) {
            this.currentConnectionMonitor.shutdown();
            this.currentConnectionMonitor = undefined;
        }
    };
    SessionActivityMonitorImpl.prototype.onSystemPing = function () {
        if (this.currentConnectionMonitor !== undefined) {
            this.currentConnectionMonitor.onSystemPing();
        }
    };
    return SessionActivityMonitorImpl;
}());
_$sessionActivityMonitor_290.sessionActivityMonitorFactory = {
    NOOP: {
        onNewConnection: function () { },
        onConnectionClosed: function () { },
        onSystemPing: function () { }
    },
    create: function (factory) {
        return new SessionActivityMonitorImpl(factory);
    }
};

var _$internalSession_301 = {};
"use strict";
Object.defineProperty(_$internalSession_301, "__esModule", { value: true });
_$internalSession_301.InternalSessionState = void 0;
var InternalSessionState;
(function (InternalSessionState) {
    InternalSessionState["INITIALISING"] = "initialising";
    InternalSessionState["CONNECTING"] = "connecting";
    InternalSessionState["CONNECTED"] = "connected";
    InternalSessionState["DISCONNECTED"] = "disconnected";
    InternalSessionState["RECONNECTING"] = "reconnecting";
    InternalSessionState["CLOSING"] = "closing";
    InternalSessionState["CLOSED"] = "closed";
})(InternalSessionState = _$internalSession_301.InternalSessionState || (_$internalSession_301.InternalSessionState = {}));

var _$errorReason_298 = {};
"use strict";
Object.defineProperty(_$errorReason_298, "__esModule", { value: true });
_$errorReason_298.ErrorReason = void 0;
var ErrorReason =  (function () {
    function ErrorReason(id, reason) {
        this.id = id;
        this.reason = reason;
    }
    ErrorReason.prototype.toString = function () {
        return this.id + ': ' + this.reason;
    };
    return ErrorReason;
}());
_$errorReason_298.ErrorReason = ErrorReason;

var _$Long_274 = Long;


var wasm = null;

try {
  wasm = new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([
    0, 97, 115, 109, 1, 0, 0, 0, 1, 13, 2, 96, 0, 1, 127, 96, 4, 127, 127, 127, 127, 1, 127, 3, 7, 6, 0, 1, 1, 1, 1, 1, 6, 6, 1, 127, 1, 65, 0, 11, 7, 50, 6, 3, 109, 117, 108, 0, 1, 5, 100, 105, 118, 95, 115, 0, 2, 5, 100, 105, 118, 95, 117, 0, 3, 5, 114, 101, 109, 95, 115, 0, 4, 5, 114, 101, 109, 95, 117, 0, 5, 8, 103, 101, 116, 95, 104, 105, 103, 104, 0, 0, 10, 191, 1, 6, 4, 0, 35, 0, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 126, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 127, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 128, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 129, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 130, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11
  ])), {}).exports;
} catch (e) {
}


function Long(low, high, unsigned) {


    this.low = low | 0;


    this.high = high | 0;


    this.unsigned = !!unsigned;
}



Long.prototype.__isLong__;

Object.defineProperty(Long.prototype, "__isLong__", { value: true });


function isLong(obj) {
    return (obj && obj["__isLong__"]) === true;
}


Long.isLong = isLong;


var INT_CACHE = {};


var UINT_CACHE = {};


function fromInt(value, unsigned) {
    var obj, cachedObj, cache;
    if (unsigned) {
        value >>>= 0;
        if (cache = (0 <= value && value < 256)) {
            cachedObj = UINT_CACHE[value];
            if (cachedObj)
                return cachedObj;
        }
        obj = fromBits(value, (value | 0) < 0 ? -1 : 0, true);
        if (cache)
            UINT_CACHE[value] = obj;
        return obj;
    } else {
        value |= 0;
        if (cache = (-128 <= value && value < 128)) {
            cachedObj = INT_CACHE[value];
            if (cachedObj)
                return cachedObj;
        }
        obj = fromBits(value, value < 0 ? -1 : 0, false);
        if (cache)
            INT_CACHE[value] = obj;
        return obj;
    }
}


Long.fromInt = fromInt;


function fromNumber(value, unsigned) {
    if (isNaN(value))
        return unsigned ? UZERO : ZERO;
    if (unsigned) {
        if (value < 0)
            return UZERO;
        if (value >= TWO_PWR_64_DBL)
            return MAX_UNSIGNED_VALUE;
    } else {
        if (value <= -TWO_PWR_63_DBL)
            return MIN_VALUE;
        if (value + 1 >= TWO_PWR_63_DBL)
            return MAX_VALUE;
    }
    if (value < 0)
        return fromNumber(-value, unsigned).neg();
    return fromBits((value % TWO_PWR_32_DBL) | 0, (value / TWO_PWR_32_DBL) | 0, unsigned);
}


Long.fromNumber = fromNumber;


function fromBits(lowBits, highBits, unsigned) {
    return new Long(lowBits, highBits, unsigned);
}


Long.fromBits = fromBits;


var pow_dbl = Math.pow; 


function fromString(str, unsigned, radix) {
    if (str.length === 0)
        throw Error('empty string');
    if (str === "NaN" || str === "Infinity" || str === "+Infinity" || str === "-Infinity")
        return ZERO;
    if (typeof unsigned === 'number') {
        radix = unsigned,
        unsigned = false;
    } else {
        unsigned = !! unsigned;
    }
    radix = radix || 10;
    if (radix < 2 || 36 < radix)
        throw RangeError('radix');

    var p;
    if ((p = str.indexOf('-')) > 0)
        throw Error('interior hyphen');
    else if (p === 0) {
        return fromString(str.substring(1), unsigned, radix).neg();
    }

    var radixToPower = fromNumber(pow_dbl(radix, 8));

    var result = ZERO;
    for (var i = 0; i < str.length; i += 8) {
        var size = Math.min(8, str.length - i),
            value = parseInt(str.substring(i, i + size), radix);
        if (size < 8) {
            var power = fromNumber(pow_dbl(radix, size));
            result = result.mul(power).add(fromNumber(value));
        } else {
            result = result.mul(radixToPower);
            result = result.add(fromNumber(value));
        }
    }
    result.unsigned = unsigned;
    return result;
}


Long.fromString = fromString;


function fromValue(val, unsigned) {
    if (typeof val === 'number')
        return fromNumber(val, unsigned);
    if (typeof val === 'string')
        return fromString(val, unsigned);
    return fromBits(val.low, val.high, typeof unsigned === 'boolean' ? unsigned : val.unsigned);
}


Long.fromValue = fromValue;



var TWO_PWR_16_DBL = 1 << 16;


var TWO_PWR_24_DBL = 1 << 24;


var TWO_PWR_32_DBL = TWO_PWR_16_DBL * TWO_PWR_16_DBL;


var TWO_PWR_64_DBL = TWO_PWR_32_DBL * TWO_PWR_32_DBL;


var TWO_PWR_63_DBL = TWO_PWR_64_DBL / 2;


var TWO_PWR_24 = fromInt(TWO_PWR_24_DBL);


var ZERO = fromInt(0);


Long.ZERO = ZERO;


var UZERO = fromInt(0, true);


Long.UZERO = UZERO;


var ONE = fromInt(1);


Long.ONE = ONE;


var UONE = fromInt(1, true);


Long.UONE = UONE;


var NEG_ONE = fromInt(-1);


Long.NEG_ONE = NEG_ONE;


var MAX_VALUE = fromBits(0xFFFFFFFF|0, 0x7FFFFFFF|0, false);


Long.MAX_VALUE = MAX_VALUE;


var MAX_UNSIGNED_VALUE = fromBits(0xFFFFFFFF|0, 0xFFFFFFFF|0, true);


Long.MAX_UNSIGNED_VALUE = MAX_UNSIGNED_VALUE;


var MIN_VALUE = fromBits(0, 0x80000000|0, false);


Long.MIN_VALUE = MIN_VALUE;


var LongPrototype = Long.prototype;


LongPrototype.toInt = function toInt() {
    return this.unsigned ? this.low >>> 0 : this.low;
};


LongPrototype.toNumber = function toNumber() {
    if (this.unsigned)
        return ((this.high >>> 0) * TWO_PWR_32_DBL) + (this.low >>> 0);
    return this.high * TWO_PWR_32_DBL + (this.low >>> 0);
};


LongPrototype.toString = function toString(radix) {
    radix = radix || 10;
    if (radix < 2 || 36 < radix)
        throw RangeError('radix');
    if (this.isZero())
        return '0';
    if (this.isNegative()) { 
        if (this.eq(MIN_VALUE)) {
            var radixLong = fromNumber(radix),
                div = this.div(radixLong),
                rem1 = div.mul(radixLong).sub(this);
            return div.toString(radix) + rem1.toInt().toString(radix);
        } else
            return '-' + this.neg().toString(radix);
    }

    var radixToPower = fromNumber(pow_dbl(radix, 6), this.unsigned),
        rem = this;
    var result = '';
    while (true) {
        var remDiv = rem.div(radixToPower),
            intval = rem.sub(remDiv.mul(radixToPower)).toInt() >>> 0,
            digits = intval.toString(radix);
        rem = remDiv;
        if (rem.isZero())
            return digits + result;
        else {
            while (digits.length < 6)
                digits = '0' + digits;
            result = '' + digits + result;
        }
    }
};


LongPrototype.getHighBits = function getHighBits() {
    return this.high;
};


LongPrototype.getHighBitsUnsigned = function getHighBitsUnsigned() {
    return this.high >>> 0;
};


LongPrototype.getLowBits = function getLowBits() {
    return this.low;
};


LongPrototype.getLowBitsUnsigned = function getLowBitsUnsigned() {
    return this.low >>> 0;
};


LongPrototype.getNumBitsAbs = function getNumBitsAbs() {
    if (this.isNegative()) 
        return this.eq(MIN_VALUE) ? 64 : this.neg().getNumBitsAbs();
    var val = this.high != 0 ? this.high : this.low;
    for (var bit = 31; bit > 0; bit--)
        if ((val & (1 << bit)) != 0)
            break;
    return this.high != 0 ? bit + 33 : bit + 1;
};


LongPrototype.isZero = function isZero() {
    return this.high === 0 && this.low === 0;
};


LongPrototype.eqz = LongPrototype.isZero;


LongPrototype.isNegative = function isNegative() {
    return !this.unsigned && this.high < 0;
};


LongPrototype.isPositive = function isPositive() {
    return this.unsigned || this.high >= 0;
};


LongPrototype.isOdd = function isOdd() {
    return (this.low & 1) === 1;
};


LongPrototype.isEven = function isEven() {
    return (this.low & 1) === 0;
};


LongPrototype.equals = function equals(other) {
    if (!isLong(other))
        other = fromValue(other);
    if (this.unsigned !== other.unsigned && (this.high >>> 31) === 1 && (other.high >>> 31) === 1)
        return false;
    return this.high === other.high && this.low === other.low;
};


LongPrototype.eq = LongPrototype.equals;


LongPrototype.notEquals = function notEquals(other) {
    return !this.eq( other);
};


LongPrototype.neq = LongPrototype.notEquals;


LongPrototype.ne = LongPrototype.notEquals;


LongPrototype.lessThan = function lessThan(other) {
    return this.comp( other) < 0;
};


LongPrototype.lt = LongPrototype.lessThan;


LongPrototype.lessThanOrEqual = function lessThanOrEqual(other) {
    return this.comp( other) <= 0;
};


LongPrototype.lte = LongPrototype.lessThanOrEqual;


LongPrototype.le = LongPrototype.lessThanOrEqual;


LongPrototype.greaterThan = function greaterThan(other) {
    return this.comp( other) > 0;
};


LongPrototype.gt = LongPrototype.greaterThan;


LongPrototype.greaterThanOrEqual = function greaterThanOrEqual(other) {
    return this.comp( other) >= 0;
};


LongPrototype.gte = LongPrototype.greaterThanOrEqual;


LongPrototype.ge = LongPrototype.greaterThanOrEqual;


LongPrototype.compare = function compare(other) {
    if (!isLong(other))
        other = fromValue(other);
    if (this.eq(other))
        return 0;
    var thisNeg = this.isNegative(),
        otherNeg = other.isNegative();
    if (thisNeg && !otherNeg)
        return -1;
    if (!thisNeg && otherNeg)
        return 1;
    if (!this.unsigned)
        return this.sub(other).isNegative() ? -1 : 1;
    return (other.high >>> 0) > (this.high >>> 0) || (other.high === this.high && (other.low >>> 0) > (this.low >>> 0)) ? -1 : 1;
};


LongPrototype.comp = LongPrototype.compare;


LongPrototype.negate = function negate() {
    if (!this.unsigned && this.eq(MIN_VALUE))
        return MIN_VALUE;
    return this.not().add(ONE);
};


LongPrototype.neg = LongPrototype.negate;


LongPrototype.add = function add(addend) {
    if (!isLong(addend))
        addend = fromValue(addend);


    var a48 = this.high >>> 16;
    var a32 = this.high & 0xFFFF;
    var a16 = this.low >>> 16;
    var a00 = this.low & 0xFFFF;

    var b48 = addend.high >>> 16;
    var b32 = addend.high & 0xFFFF;
    var b16 = addend.low >>> 16;
    var b00 = addend.low & 0xFFFF;

    var c48 = 0, c32 = 0, c16 = 0, c00 = 0;
    c00 += a00 + b00;
    c16 += c00 >>> 16;
    c00 &= 0xFFFF;
    c16 += a16 + b16;
    c32 += c16 >>> 16;
    c16 &= 0xFFFF;
    c32 += a32 + b32;
    c48 += c32 >>> 16;
    c32 &= 0xFFFF;
    c48 += a48 + b48;
    c48 &= 0xFFFF;
    return fromBits((c16 << 16) | c00, (c48 << 16) | c32, this.unsigned);
};


LongPrototype.subtract = function subtract(subtrahend) {
    if (!isLong(subtrahend))
        subtrahend = fromValue(subtrahend);
    return this.add(subtrahend.neg());
};


LongPrototype.sub = LongPrototype.subtract;


LongPrototype.multiply = function multiply(multiplier) {
    if (this.isZero())
        return ZERO;
    if (!isLong(multiplier))
        multiplier = fromValue(multiplier);

    if (wasm) {
        var low = wasm.mul(this.low,
                           this.high,
                           multiplier.low,
                           multiplier.high);
        return fromBits(low, wasm.get_high(), this.unsigned);
    }

    if (multiplier.isZero())
        return ZERO;
    if (this.eq(MIN_VALUE))
        return multiplier.isOdd() ? MIN_VALUE : ZERO;
    if (multiplier.eq(MIN_VALUE))
        return this.isOdd() ? MIN_VALUE : ZERO;

    if (this.isNegative()) {
        if (multiplier.isNegative())
            return this.neg().mul(multiplier.neg());
        else
            return this.neg().mul(multiplier).neg();
    } else if (multiplier.isNegative())
        return this.mul(multiplier.neg()).neg();

    if (this.lt(TWO_PWR_24) && multiplier.lt(TWO_PWR_24))
        return fromNumber(this.toNumber() * multiplier.toNumber(), this.unsigned);


    var a48 = this.high >>> 16;
    var a32 = this.high & 0xFFFF;
    var a16 = this.low >>> 16;
    var a00 = this.low & 0xFFFF;

    var b48 = multiplier.high >>> 16;
    var b32 = multiplier.high & 0xFFFF;
    var b16 = multiplier.low >>> 16;
    var b00 = multiplier.low & 0xFFFF;

    var c48 = 0, c32 = 0, c16 = 0, c00 = 0;
    c00 += a00 * b00;
    c16 += c00 >>> 16;
    c00 &= 0xFFFF;
    c16 += a16 * b00;
    c32 += c16 >>> 16;
    c16 &= 0xFFFF;
    c16 += a00 * b16;
    c32 += c16 >>> 16;
    c16 &= 0xFFFF;
    c32 += a32 * b00;
    c48 += c32 >>> 16;
    c32 &= 0xFFFF;
    c32 += a16 * b16;
    c48 += c32 >>> 16;
    c32 &= 0xFFFF;
    c32 += a00 * b32;
    c48 += c32 >>> 16;
    c32 &= 0xFFFF;
    c48 += a48 * b00 + a32 * b16 + a16 * b32 + a00 * b48;
    c48 &= 0xFFFF;
    return fromBits((c16 << 16) | c00, (c48 << 16) | c32, this.unsigned);
};


LongPrototype.mul = LongPrototype.multiply;


LongPrototype.divide = function divide(divisor) {
    if (!isLong(divisor))
        divisor = fromValue(divisor);
    if (divisor.isZero())
        throw Error('division by zero');

    if (wasm) {
        if (!this.unsigned &&
            this.high === -0x80000000 &&
            divisor.low === -1 && divisor.high === -1) {
            return this;
        }
        var low = (this.unsigned ? wasm.div_u : wasm.div_s)(
            this.low,
            this.high,
            divisor.low,
            divisor.high
        );
        return fromBits(low, wasm.get_high(), this.unsigned);
    }

    if (this.isZero())
        return this.unsigned ? UZERO : ZERO;
    var approx, rem, res;
    if (!this.unsigned) {
        if (this.eq(MIN_VALUE)) {
            if (divisor.eq(ONE) || divisor.eq(NEG_ONE))
                return MIN_VALUE;  
            else if (divisor.eq(MIN_VALUE))
                return ONE;
            else {
                var halfThis = this.shr(1);
                approx = halfThis.div(divisor).shl(1);
                if (approx.eq(ZERO)) {
                    return divisor.isNegative() ? ONE : NEG_ONE;
                } else {
                    rem = this.sub(divisor.mul(approx));
                    res = approx.add(rem.div(divisor));
                    return res;
                }
            }
        } else if (divisor.eq(MIN_VALUE))
            return this.unsigned ? UZERO : ZERO;
        if (this.isNegative()) {
            if (divisor.isNegative())
                return this.neg().div(divisor.neg());
            return this.neg().div(divisor).neg();
        } else if (divisor.isNegative())
            return this.div(divisor.neg()).neg();
        res = ZERO;
    } else {
        if (!divisor.unsigned)
            divisor = divisor.toUnsigned();
        if (divisor.gt(this))
            return UZERO;
        if (divisor.gt(this.shru(1))) 
            return UONE;
        res = UZERO;
    }

    rem = this;
    while (rem.gte(divisor)) {
        approx = Math.max(1, Math.floor(rem.toNumber() / divisor.toNumber()));

        var log2 = Math.ceil(Math.log(approx) / Math.LN2),
            delta = (log2 <= 48) ? 1 : pow_dbl(2, log2 - 48),

            approxRes = fromNumber(approx),
            approxRem = approxRes.mul(divisor);
        while (approxRem.isNegative() || approxRem.gt(rem)) {
            approx -= delta;
            approxRes = fromNumber(approx, this.unsigned);
            approxRem = approxRes.mul(divisor);
        }

        if (approxRes.isZero())
            approxRes = ONE;

        res = res.add(approxRes);
        rem = rem.sub(approxRem);
    }
    return res;
};


LongPrototype.div = LongPrototype.divide;


LongPrototype.modulo = function modulo(divisor) {
    if (!isLong(divisor))
        divisor = fromValue(divisor);

    if (wasm) {
        var low = (this.unsigned ? wasm.rem_u : wasm.rem_s)(
            this.low,
            this.high,
            divisor.low,
            divisor.high
        );
        return fromBits(low, wasm.get_high(), this.unsigned);
    }

    return this.sub(this.div(divisor).mul(divisor));
};


LongPrototype.mod = LongPrototype.modulo;


LongPrototype.rem = LongPrototype.modulo;


LongPrototype.not = function not() {
    return fromBits(~this.low, ~this.high, this.unsigned);
};


LongPrototype.and = function and(other) {
    if (!isLong(other))
        other = fromValue(other);
    return fromBits(this.low & other.low, this.high & other.high, this.unsigned);
};


LongPrototype.or = function or(other) {
    if (!isLong(other))
        other = fromValue(other);
    return fromBits(this.low | other.low, this.high | other.high, this.unsigned);
};


LongPrototype.xor = function xor(other) {
    if (!isLong(other))
        other = fromValue(other);
    return fromBits(this.low ^ other.low, this.high ^ other.high, this.unsigned);
};


LongPrototype.shiftLeft = function shiftLeft(numBits) {
    if (isLong(numBits))
        numBits = numBits.toInt();
    if ((numBits &= 63) === 0)
        return this;
    else if (numBits < 32)
        return fromBits(this.low << numBits, (this.high << numBits) | (this.low >>> (32 - numBits)), this.unsigned);
    else
        return fromBits(0, this.low << (numBits - 32), this.unsigned);
};


LongPrototype.shl = LongPrototype.shiftLeft;


LongPrototype.shiftRight = function shiftRight(numBits) {
    if (isLong(numBits))
        numBits = numBits.toInt();
    if ((numBits &= 63) === 0)
        return this;
    else if (numBits < 32)
        return fromBits((this.low >>> numBits) | (this.high << (32 - numBits)), this.high >> numBits, this.unsigned);
    else
        return fromBits(this.high >> (numBits - 32), this.high >= 0 ? 0 : -1, this.unsigned);
};


LongPrototype.shr = LongPrototype.shiftRight;


LongPrototype.shiftRightUnsigned = function shiftRightUnsigned(numBits) {
    if (isLong(numBits))
        numBits = numBits.toInt();
    numBits &= 63;
    if (numBits === 0)
        return this;
    else {
        var high = this.high;
        if (numBits < 32) {
            var low = this.low;
            return fromBits((low >>> numBits) | (high << (32 - numBits)), high >>> numBits, this.unsigned);
        } else if (numBits === 32)
            return fromBits(high, 0, this.unsigned);
        else
            return fromBits(high >>> (numBits - 32), 0, this.unsigned);
    }
};


LongPrototype.shru = LongPrototype.shiftRightUnsigned;


LongPrototype.shr_u = LongPrototype.shiftRightUnsigned;


LongPrototype.toSigned = function toSigned() {
    if (!this.unsigned)
        return this;
    return fromBits(this.low, this.high, false);
};


LongPrototype.toUnsigned = function toUnsigned() {
    if (this.unsigned)
        return this;
    return fromBits(this.low, this.high, true);
};


LongPrototype.toBytes = function toBytes(le) {
    return le ? this.toBytesLE() : this.toBytesBE();
};


LongPrototype.toBytesLE = function toBytesLE() {
    var hi = this.high,
        lo = this.low;
    return [
        lo        & 0xff,
        lo >>>  8 & 0xff,
        lo >>> 16 & 0xff,
        lo >>> 24       ,
        hi        & 0xff,
        hi >>>  8 & 0xff,
        hi >>> 16 & 0xff,
        hi >>> 24
    ];
};


LongPrototype.toBytesBE = function toBytesBE() {
    var hi = this.high,
        lo = this.low;
    return [
        hi >>> 24       ,
        hi >>> 16 & 0xff,
        hi >>>  8 & 0xff,
        hi        & 0xff,
        lo >>> 24       ,
        lo >>> 16 & 0xff,
        lo >>>  8 & 0xff,
        lo        & 0xff
    ];
};


Long.fromBytes = function fromBytes(bytes, unsigned, le) {
    return le ? Long.fromBytesLE(bytes, unsigned) : Long.fromBytesBE(bytes, unsigned);
};


Long.fromBytesLE = function fromBytesLE(bytes, unsigned) {
    return new Long(
        bytes[0]       |
        bytes[1] <<  8 |
        bytes[2] << 16 |
        bytes[3] << 24,
        bytes[4]       |
        bytes[5] <<  8 |
        bytes[6] << 16 |
        bytes[7] << 24,
        unsigned
    );
};


Long.fromBytesBE = function fromBytesBE(bytes, unsigned) {
    return new Long(
        bytes[4] << 24 |
        bytes[5] << 16 |
        bytes[6] <<  8 |
        bytes[7],
        bytes[0] << 24 |
        bytes[1] << 16 |
        bytes[2] <<  8 |
        bytes[3],
        unsigned
    );
};

var _$conversationId_314 = {};
"use strict";
Object.defineProperty(_$conversationId_314, "__esModule", { value: true });
_$conversationId_314.ONEWAY_CID = _$conversationId_314.ConversationId = void 0;
;
var ConversationId =  (function () {
    function ConversationId(val) {
        this.val = val;
    }
    ConversationId.fromString = function (val) {
        return new ConversationId(_$Long_274.fromString(val, false));
    };
    ConversationId.prototype.toString = function () {
        return this.val.toString(10);
    };
    ConversationId.prototype.equals = function (other) {
        return other.val && this.val.equals(other.val);
    };
    return ConversationId;
}());
_$conversationId_314.ConversationId = ConversationId;
_$conversationId_314.ONEWAY_CID = new ConversationId(_$Long_274.fromNumber(0));

var _$base64Js_1 = {};
'use strict'

 void byteLength
_$base64Js_1.toByteArray = toByteArray
_$base64Js_1.fromByteArray = fromByteArray

var lookup = []
var revLookup = []
var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array

var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
for (var i = 0, len = code.length; i < len; ++i) {
  lookup[i] = code[i]
  revLookup[code.charCodeAt(i)] = i
}

revLookup['-'.charCodeAt(0)] = 62
revLookup['_'.charCodeAt(0)] = 63

function getLens (b64) {
  var len = b64.length

  if (len % 4 > 0) {
    throw new Error('Invalid string. Length must be a multiple of 4')
  }

  var validLen = b64.indexOf('=')
  if (validLen === -1) validLen = len

  var placeHoldersLen = validLen === len
    ? 0
    : 4 - (validLen % 4)

  return [validLen, placeHoldersLen]
}

function byteLength (b64) {
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function _byteLength (b64, validLen, placeHoldersLen) {
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function toByteArray (b64) {
  var tmp
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]

  var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen))

  var curByte = 0

  var len = placeHoldersLen > 0
    ? validLen - 4
    : validLen

  var i
  for (i = 0; i < len; i += 4) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 18) |
      (revLookup[b64.charCodeAt(i + 1)] << 12) |
      (revLookup[b64.charCodeAt(i + 2)] << 6) |
      revLookup[b64.charCodeAt(i + 3)]
    arr[curByte++] = (tmp >> 16) & 0xFF
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 2) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 2) |
      (revLookup[b64.charCodeAt(i + 1)] >> 4)
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 1) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 10) |
      (revLookup[b64.charCodeAt(i + 1)] << 4) |
      (revLookup[b64.charCodeAt(i + 2)] >> 2)
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  return arr
}

function tripletToBase64 (num) {
  return lookup[num >> 18 & 0x3F] +
    lookup[num >> 12 & 0x3F] +
    lookup[num >> 6 & 0x3F] +
    lookup[num & 0x3F]
}

function encodeChunk (uint8, start, end) {
  var tmp
  var output = []
  for (var i = start; i < end; i += 3) {
    tmp =
      ((uint8[i] << 16) & 0xFF0000) +
      ((uint8[i + 1] << 8) & 0xFF00) +
      (uint8[i + 2] & 0xFF)
    output.push(tripletToBase64(tmp))
  }
  return output.join('')
}

function fromByteArray (uint8) {
  var tmp
  var len = uint8.length
  var extraBytes = len % 3 
  var parts = []
  var maxChunkLength = 16383 

  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
    parts.push(encodeChunk(uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)))
  }

  if (extraBytes === 1) {
    tmp = uint8[len - 1]
    parts.push(
      lookup[tmp >> 2] +
      lookup[(tmp << 4) & 0x3F] +
      '=='
    )
  } else if (extraBytes === 2) {
    tmp = (uint8[len - 2] << 8) + uint8[len - 1]
    parts.push(
      lookup[tmp >> 10] +
      lookup[(tmp >> 4) & 0x3F] +
      lookup[(tmp << 2) & 0x3F] +
      '='
    )
  }

  return parts.join('')
}

var _$ieee754_272 = {};
_$ieee754_272.read = function (buffer, offset, isLE, mLen, nBytes) {
  var e, m
  var eLen = (nBytes * 8) - mLen - 1
  var eMax = (1 << eLen) - 1
  var eBias = eMax >> 1
  var nBits = -7
  var i = isLE ? (nBytes - 1) : 0
  var d = isLE ? -1 : 1
  var s = buffer[offset + i]

  i += d

  e = s & ((1 << (-nBits)) - 1)
  s >>= (-nBits)
  nBits += eLen
  for (; nBits > 0; e = (e * 256) + buffer[offset + i], i += d, nBits -= 8) {}

  m = e & ((1 << (-nBits)) - 1)
  e >>= (-nBits)
  nBits += mLen
  for (; nBits > 0; m = (m * 256) + buffer[offset + i], i += d, nBits -= 8) {}

  if (e === 0) {
    e = 1 - eBias
  } else if (e === eMax) {
    return m ? NaN : ((s ? -1 : 1) * Infinity)
  } else {
    m = m + Math.pow(2, mLen)
    e = e - eBias
  }
  return (s ? -1 : 1) * m * Math.pow(2, e - mLen)
}

_$ieee754_272.write = function (buffer, value, offset, isLE, mLen, nBytes) {
  var e, m, c
  var eLen = (nBytes * 8) - mLen - 1
  var eMax = (1 << eLen) - 1
  var eBias = eMax >> 1
  var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0)
  var i = isLE ? 0 : (nBytes - 1)
  var d = isLE ? 1 : -1
  var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0

  value = Math.abs(value)

  if (isNaN(value) || value === Infinity) {
    m = isNaN(value) ? 1 : 0
    e = eMax
  } else {
    e = Math.floor(Math.log(value) / Math.LN2)
    if (value * (c = Math.pow(2, -e)) < 1) {
      e--
      c *= 2
    }
    if (e + eBias >= 1) {
      value += rt / c
    } else {
      value += rt * Math.pow(2, 1 - eBias)
    }
    if (value * c >= 2) {
      e++
      c /= 2
    }

    if (e + eBias >= eMax) {
      m = 0
      e = eMax
    } else if (e + eBias >= 1) {
      m = ((value * c) - 1) * Math.pow(2, mLen)
      e = e + eBias
    } else {
      m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen)
      e = 0
    }
  }

  for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}

  e = (e << mLen) | m
  eLen += mLen
  for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}

  buffer[offset + i - d] |= s * 128
}

var _$uint8array_762 = {};
(function (Buffer){(function (){
"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(_$uint8array_762, "__esModule", { value: true });
_$uint8array_762.isUint8Array = _$uint8array_762.isEqualUint8Arrays = _$uint8array_762.uint8toUtf8 = _$uint8array_762.uint8ToBase64 = _$uint8array_762.uint8ToAscii = _$uint8array_762.uint8FromDoubleBE = _$uint8array_762.uint8FromBase64 = _$uint8array_762.uint8FromUtf8 = _$uint8array_762.uint8FromBinary = _$uint8array_762.writeInt32BE = _$uint8array_762.writeInt8 = _$uint8array_762.readDoubleBE = _$uint8array_762.readFloatBE = _$uint8array_762.readInt32BE = _$uint8array_762.readUInt32BE = _$uint8array_762.readUInt16BE = _$uint8array_762.readInt8 = _$uint8array_762.concatUint8Arrays = void 0;
function concatUint8Arrays(arrays) {
    var e_1, _a;
    var totalLength = arrays.reduce(function (acc, a) { return acc + a.length; }, 0);
    var result = new Uint8Array(totalLength);
    var offset = 0;
    try {
        for (var arrays_1 = __values(arrays), arrays_1_1 = arrays_1.next(); !arrays_1_1.done; arrays_1_1 = arrays_1.next()) {
            var a = arrays_1_1.value;
            result.set(a, offset);
            offset += a.length;
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (arrays_1_1 && !arrays_1_1.done && (_a = arrays_1.return)) _a.call(arrays_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return result;
}
_$uint8array_762.concatUint8Arrays = concatUint8Arrays;
function readInt8(buffer, offset) {
    var view = new DataView(buffer.buffer, buffer.byteOffset, buffer.byteLength);
    return view.getInt8(offset);
}
_$uint8array_762.readInt8 = readInt8;
function readUInt16BE(buffer, offset) {
    var view = new DataView(buffer.buffer, buffer.byteOffset, buffer.byteLength);
    return view.getUint16(offset, false);
}
_$uint8array_762.readUInt16BE = readUInt16BE;
function readUInt32BE(buffer, offset) {
    var view = new DataView(buffer.buffer, buffer.byteOffset, buffer.byteLength);
    return view.getUint32(offset, false);
}
_$uint8array_762.readUInt32BE = readUInt32BE;
function readInt32BE(buffer, offset) {
    var view = new DataView(buffer.buffer, buffer.byteOffset, buffer.byteLength);
    return view.getInt32(offset, false);
}
_$uint8array_762.readInt32BE = readInt32BE;
function readFloatBE(buffer, offset) {
    var view = new DataView(buffer.buffer, buffer.byteOffset, buffer.byteLength);
    return view.getFloat32(offset, false);
}
_$uint8array_762.readFloatBE = readFloatBE;
function readDoubleBE(buffer, offset) {
    var view = new DataView(buffer.buffer, buffer.byteOffset, buffer.byteLength);
    return view.getFloat64(offset, false);
}
_$uint8array_762.readDoubleBE = readDoubleBE;
function writeInt8(buffer, offset, value) {
    buffer[offset] = value;
}
_$uint8array_762.writeInt8 = writeInt8;
function writeInt32BE(buffer, offset, value) {
    var view = new DataView(buffer.buffer, buffer.byteOffset, buffer.byteLength);
    view.setInt32(offset, value, false);
}
_$uint8array_762.writeInt32BE = writeInt32BE;
function uint8FromBinary(str) {
    var buffer = new Uint8Array(str.length);
    for (var i = 0; i < str.length; i++) {
        buffer[i] = str.charCodeAt(i);
    }
    return buffer;
}
_$uint8array_762.uint8FromBinary = uint8FromBinary;
function uint8FromUtf8(str) {
    return new TextEncoder().encode(str);
}
_$uint8array_762.uint8FromUtf8 = uint8FromUtf8;
_$uint8array_762.uint8FromBase64 = (typeof window === 'undefined' || window.atob === undefined) ?
    function (str) { return new Uint8Array(Buffer.from(str, 'base64')); } :
    function (str) { return new Uint8Array(window.atob(str).split('').map(function (c) { return c.charCodeAt(0); })); };
function uint8FromDoubleBE(val) {
    var buffer = new ArrayBuffer(8);
    new DataView(buffer).setFloat64(0, val, false);
    return new Uint8Array(buffer);
}
_$uint8array_762.uint8FromDoubleBE = uint8FromDoubleBE;
function uint8ToAscii(val) {
    var chunks = [];
    for (var i = 0; i < val.length; i += 128) {
        chunks.push(val.subarray(i, Math.min(i + 128, val.length)));
    }
    return chunks.map(function (chunk) { return String.fromCharCode.apply(String, __spreadArray([], __read(chunk))); }).join('');
}
_$uint8array_762.uint8ToAscii = uint8ToAscii;
_$uint8array_762.uint8ToBase64 = (typeof window === 'undefined' || window.btoa === undefined) ?
    function (val) { return Buffer.from(val).toString('base64'); } :
    function (val) { return window.btoa(uint8ToAscii(val)); };
function uint8toUtf8(val, startPos, endPos) {
    if (startPos === void 0) { startPos = 0; }
    if (endPos === void 0) { endPos = val.length; }
    return new TextDecoder().decode(val.subarray(startPos, endPos));
}
_$uint8array_762.uint8toUtf8 = uint8toUtf8;
function isEqualUint8Arrays(a, b) {
    if (a.length !== b.length) {
        return false;
    }
    for (var i = 0; i < a.length; ++i) {
        if (a[i] !== b[i]) {
            return false;
        }
    }
    return true;
}
_$uint8array_762.isEqualUint8Arrays = isEqualUint8Arrays;
function isUint8Array(value) {
    return (typeof Uint8Array === 'function' && value instanceof Uint8Array) ||
        Object.prototype.toString.call(value) === '[object Uint8Array]';
}
_$uint8array_762.isUint8Array = isUint8Array;

}).call(this)}).call(this,_$buffer_3({}).Buffer)
var _$codec_411 = {};
"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(_$codec_411, "__esModule", { value: true });
_$codec_411.readOptional = _$codec_411.writeOptional = _$codec_411.writeBoolean = _$codec_411.readBoolean = _$codec_411.writeMap = _$codec_411.readMap = _$codec_411.readObject = _$codec_411.writeObject = _$codec_411.writeDictionary = _$codec_411.readDictionary = _$codec_411.readCollection = _$codec_411.writeCollection = _$codec_411.writeString = _$codec_411.readString = _$codec_411.writeBytes = _$codec_411.readBytes = _$codec_411.writeByte = _$codec_411.writeInt32 = _$codec_411.readInt32 = _$codec_411.writeInt64 = _$codec_411.readInt64 = _$codec_411.readByte = void 0;
;
;
;
var x80 = _$Long_274.fromNumber(0x80);
var x7F = _$Long_274.fromNumber(0x7F);
var x7FInv = x7F.not(); 
function readByte(input) {
    var i = input.read();
    if (i === -1) {
        throw new _$errors_280.IOError('End of stream');
    }
    return i;
}
_$codec_411.readByte = readByte;
function readInt64(input) {
    var result = _$Long_274.fromNumber(0);
    var shift = 0;
    while (shift < 64) {
        var i = readByte(input);
        var l = _$Long_274.fromNumber(i);
        result = result.or(l.and(x7F).shiftLeft(shift));
        if (l.and(x80).equals(0)) {
            return result;
        }
        shift += 7;
    }
    throw new _$errors_280.IOError('Malformed int64');
}
_$codec_411.readInt64 = readInt64;
function writeInt64(bos, value) {
    var int64 = _$Long_274.isLong(value) ? value : _$Long_274.fromNumber(value, false);
    while (!int64.and(x7FInv).equals(0)) {
        bos.write(int64.and(x7F).or(x80).toInt());
        int64 = int64.shiftRightUnsigned(7);
    }
    bos.write(int64.toInt());
}
_$codec_411.writeInt64 = writeInt64;
function readInt32(bis) {
    var shift = 0;
    var result = 0;
    while (shift < 32) {
        var i = readByte(bis);
        result |= (i & 0x7F) << shift;
        if ((i & 0x80) === 0) {
            return result;
        }
        shift += 7;
    }
    throw new _$errors_280.IOError('Malformed int32');
}
_$codec_411.readInt32 = readInt32;
function writeInt32(bos, value) {
    while ((value & ~0x7F) !== 0) {
        bos.write((value & 0x7F) | 0x80);
        value = value >>> 7;
    }
    bos.write(value);
}
_$codec_411.writeInt32 = writeInt32;
function writeByte(bos, value) {
    bos.write(value);
}
_$codec_411.writeByte = writeByte;
function readBytes(bis) {
    var length = readInt32(bis);
    return bis.readMany(length);
}
_$codec_411.readBytes = readBytes;
function writeBytes(bos, value) {
    writeInt32(bos, value.length);
    bos.writeMany(value);
}
_$codec_411.writeBytes = writeBytes;
function readString(bis) {
    var buffer = readBytes(bis);
    return buffer ? _$uint8array_762.uint8toUtf8(buffer) : '';
}
_$codec_411.readString = readString;
function writeString(bos, value) {
    writeBytes(bos, _$uint8array_762.uint8FromUtf8(value));
}
_$codec_411.writeString = writeString;
function writeCollection(bos, arr, write) {
    var e_1, _a;
    writeInt32(bos, arr.length);
    try {
        for (var arr_1 = __values(arr), arr_1_1 = arr_1.next(); !arr_1_1.done; arr_1_1 = arr_1.next()) {
            var val = arr_1_1.value;
            write(bos, val);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (arr_1_1 && !arr_1_1.done && (_a = arr_1.return)) _a.call(arr_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
}
_$codec_411.writeCollection = writeCollection;
function readCollection(bis, read) {
    var length = readInt32(bis);
    var arr = [];
    for (var i = 0; i < length; ++i) {
        arr.push(read(bis));
    }
    return arr;
}
_$codec_411.readCollection = readCollection;
function readDictionary(bis, read) {
    return readObject(bis, readString, read);
}
_$codec_411.readDictionary = readDictionary;
function writeDictionary(bos, dict, write) {
    writeObject(bos, dict, writeString, write);
}
_$codec_411.writeDictionary = writeDictionary;
function writeObject(bos, dict, keyWriter, valueWriter) {
    var e_2, _a;
    writeInt32(bos, Object.keys(dict).length);
    try {
        for (var _b = __values(Object.getOwnPropertyNames(dict)), _c = _b.next(); !_c.done; _c = _b.next()) {
            var k = _c.value;
            keyWriter(bos, k);
            valueWriter(bos, dict[k]);
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_2) throw e_2.error; }
    }
}
_$codec_411.writeObject = writeObject;
function readObject(bis, keyReader, valueReader) {
    var length = readInt32(bis);
    var dict = {};
    for (var i = 0; i < length; ++i) {
        var k = keyReader(bis);
        dict[k] = valueReader(bis);
    }
    return dict;
}
_$codec_411.readObject = readObject;
function readMap(bis, keyReader, valueReader) {
    var length = readInt32(bis);
    var map = new Map();
    for (var i = 0; i < length; ++i) {
        var k = keyReader(bis);
        map.set(k, valueReader(bis));
    }
    return map;
}
_$codec_411.readMap = readMap;
function writeMap(bos, map, keyWriter, valueWriter) {
    writeInt32(bos, map.size);
    map.forEach(function (v, k) {
        keyWriter(bos, k);
        valueWriter(bos, v);
    });
}
_$codec_411.writeMap = writeMap;
function readBoolean(bis) {
    var b = bis.readInt8();
    return (b !== 0);
}
_$codec_411.readBoolean = readBoolean;
function writeBoolean(bos, value) {
    bos.writeInt8(value ? 1 : 0);
}
_$codec_411.writeBoolean = writeBoolean;
function writeOptional(bos, value, writer, predicate) {
    if (predicate === void 0) { predicate = function (value) { return value !== null && value !== undefined; }; }
    if (!predicate(value)) {
        writeByte(bos, 0);
    }
    else {
        writeByte(bos, 1);
        writer(bos, value);
    }
}
_$codec_411.writeOptional = writeOptional;
function readOptional(bis, reader, defaultValue) {
    if (defaultValue === void 0) { defaultValue = undefined; }
    var present = readByte(bis);
    return present ? reader(bis) : defaultValue;
}
_$codec_411.readOptional = readOptional;

var _$conversationIdSerialiser_313 = {};
"use strict";
Object.defineProperty(_$conversationIdSerialiser_313, "__esModule", { value: true });
_$conversationIdSerialiser_313.CIDSerialiser =  void 0;
;
;
var CIDSerialiserClass =  (function () {
    function CIDSerialiserClass() {
    }
    CIDSerialiserClass.prototype.read = function (bis) {
        return new _$conversationId_314.ConversationId(_$codec_411.readInt64(bis));
    };
    CIDSerialiserClass.prototype.write = function (bos, cid) {
        _$codec_411.writeInt64(bos, cid.val);
    };
    return CIDSerialiserClass;
}());
 void CIDSerialiserClass;
_$conversationIdSerialiser_313.CIDSerialiser = new CIDSerialiserClass();

var _$serialiser_430 = {};
"use strict";
Object.defineProperty(_$serialiser_430, "__esModule", { value: true });
_$serialiser_430.AbstractSerialiser = void 0;
;
var AbstractSerialiser =  (function () {
    function AbstractSerialiser() {
    }
    AbstractSerialiser.prototype.read = function (bis) {
        throw new _$errors_280.InternalError('AbstractSerialiser#read is not implemented');
    };
    AbstractSerialiser.prototype.write = function (bos, val) {
        throw new _$errors_280.InternalError('AbstractSerialiser#write is not implemented');
    };
    return AbstractSerialiser;
}());
_$serialiser_430.AbstractSerialiser = AbstractSerialiser;

var _$commandHeader_443 = {};
"use strict";
Object.defineProperty(_$commandHeader_443, "__esModule", { value: true });
_$commandHeader_443.CommandHeader = void 0;
var CommandHeader =  (function () {
    function CommandHeader(service, cid) {
        this.service = service;
        this.cid = cid;
    }
    CommandHeader.createRequestHeader = function (service, cid) {
        return new CommandHeader(service, cid);
    };
    CommandHeader.prototype.createResponseHeader = function () {
        return new CommandHeader(this.service, this.cid);
    };
    CommandHeader.prototype.createErrorHeader = function () {
        return new CommandHeader(this.service, this.cid);
    };
    CommandHeader.prototype.toString = function () {
        return '<' + this.service + ', ' + this.cid.toString() + '>';
    };
    return CommandHeader;
}());
_$commandHeader_443.CommandHeader = CommandHeader;

var _$commandHeaderSerialiser_442 = {};
"use strict";
var ____extends_442 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$commandHeaderSerialiser_442, "__esModule", { value: true });
_$commandHeaderSerialiser_442.ResponseCommandHeaderSerialiser = _$commandHeaderSerialiser_442.CommandHeaderSerialiser =   void 0;
;
;
;
;
var CommandHeaderSerialiserClass =  (function (_super) {
    ____extends_442(CommandHeaderSerialiserClass, _super);
    function CommandHeaderSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CommandHeaderSerialiserClass.prototype.read = function (bis) {
        var service = _$codec_411.readInt32(bis);
        var cid = _$conversationIdSerialiser_313.CIDSerialiser.read(bis);
        return new _$commandHeader_443.CommandHeader(service, cid);
    };
    CommandHeaderSerialiserClass.prototype.write = function (bos, value) {
        _$codec_411.writeInt32(bos, value.service);
        _$conversationIdSerialiser_313.CIDSerialiser.write(bos, value.cid);
    };
    return CommandHeaderSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void CommandHeaderSerialiserClass;
var ResponseCommandHeaderSerialiserClass =  (function (_super) {
    ____extends_442(ResponseCommandHeaderSerialiserClass, _super);
    function ResponseCommandHeaderSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ResponseCommandHeaderSerialiserClass.prototype.write = function (bos, value) {
        _$conversationIdSerialiser_313.CIDSerialiser.write(bos, value.cid);
    };
    ResponseCommandHeaderSerialiserClass.prototype.read = function (bis) {
        var cid = _$conversationIdSerialiser_313.CIDSerialiser.read(bis);
        return new _$commandHeader_443.CommandHeader(0, cid);
    };
    return ResponseCommandHeaderSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void ResponseCommandHeaderSerialiserClass;
_$commandHeaderSerialiser_442.CommandHeaderSerialiser = new CommandHeaderSerialiserClass();
_$commandHeaderSerialiser_442.ResponseCommandHeaderSerialiser = new ResponseCommandHeaderSerialiserClass();

var _$loglevel_273 = { exports: {} };
(function (root, definition) {
    "use strict";
    if (typeof define === 'function' && define.amd) {
        define(definition);
    } else if ("object" === 'object' && _$loglevel_273.exports) {
        _$loglevel_273.exports = definition();
    } else {
        root.log = definition();
    }
}(this, function () {
    "use strict";

    var noop = function() {};
    var undefinedType = "undefined";
    var isIE = (typeof window !== undefinedType) && (typeof window.navigator !== undefinedType) && (
        /Trident\/|MSIE /.test(window.navigator.userAgent)
    );

    var logMethods = [
        "trace",
        "debug",
        "info",
        "warn",
        "error"
    ];

    function bindMethod(obj, methodName) {
        var method = obj[methodName];
        if (typeof method.bind === 'function') {
            return method.bind(obj);
        } else {
            try {
                return Function.prototype.bind.call(method, obj);
            } catch (e) {
                return function() {
                    return Function.prototype.apply.apply(method, [obj, arguments]);
                };
            }
        }
    }

    function traceForIE() {
        if (console.log) {
            if (console.log.apply) {
                console.log.apply(console, arguments);
            } else {
                Function.prototype.apply.apply(console.log, [console, arguments]);
            }
        }
        if (console.trace) console.trace();
    }

    function realMethod(methodName) {
        if (methodName === 'debug') {
            methodName = 'log';
        }

        if (typeof console === undefinedType) {
            return false; 
        } else if (methodName === 'trace' && isIE) {
            return traceForIE;
        } else if (console[methodName] !== undefined) {
            return bindMethod(console, methodName);
        } else if (console.log !== undefined) {
            return bindMethod(console, 'log');
        } else {
            return noop;
        }
    }


    function replaceLoggingMethods(level, loggerName) {
        for (var i = 0; i < logMethods.length; i++) {
            var methodName = logMethods[i];
            this[methodName] = (i < level) ?
                noop :
                this.methodFactory(methodName, level, loggerName);
        }

        this.log = this.debug;
    }

    function enableLoggingWhenConsoleArrives(methodName, level, loggerName) {
        return function () {
            if (typeof console !== undefinedType) {
                replaceLoggingMethods.call(this, level, loggerName);
                this[methodName].apply(this, arguments);
            }
        };
    }

    function defaultMethodFactory(methodName, level, loggerName) {
        return realMethod(methodName) ||
               enableLoggingWhenConsoleArrives.apply(this, arguments);
    }

    function Logger(name, defaultLevel, factory) {
      var self = this;
      var currentLevel;

      var storageKey = "loglevel";
      if (typeof name === "string") {
        storageKey += ":" + name;
      } else if (typeof name === "symbol") {
        storageKey = undefined;
      }

      function persistLevelIfPossible(levelNum) {
          var levelName = (logMethods[levelNum] || 'silent').toUpperCase();

          if (typeof window === undefinedType || !storageKey) return;

          try {
              window.localStorage[storageKey] = levelName;
              return;
          } catch (ignore) {}

          try {
              window.document.cookie =
                encodeURIComponent(storageKey) + "=" + levelName + ";";
          } catch (ignore) {}
      }

      function getPersistedLevel() {
          var storedLevel;

          if (typeof window === undefinedType || !storageKey) return;

          try {
              storedLevel = window.localStorage[storageKey];
          } catch (ignore) {}

          if (typeof storedLevel === undefinedType) {
              try {
                  var cookie = window.document.cookie;
                  var location = cookie.indexOf(
                      encodeURIComponent(storageKey) + "=");
                  if (location !== -1) {
                      storedLevel = /^([^;]+)/.exec(cookie.slice(location))[1];
                  }
              } catch (ignore) {}
          }

          if (self.levels[storedLevel] === undefined) {
              storedLevel = undefined;
          }

          return storedLevel;
      }


      self.name = name;

      self.levels = { "TRACE": 0, "DEBUG": 1, "INFO": 2, "WARN": 3,
          "ERROR": 4, "SILENT": 5};

      self.methodFactory = factory || defaultMethodFactory;

      self.getLevel = function () {
          return currentLevel;
      };

      self.setLevel = function (level, persist) {
          if (typeof level === "string" && self.levels[level.toUpperCase()] !== undefined) {
              level = self.levels[level.toUpperCase()];
          }
          if (typeof level === "number" && level >= 0 && level <= self.levels.SILENT) {
              currentLevel = level;
              if (persist !== false) {  
                  persistLevelIfPossible(level);
              }
              replaceLoggingMethods.call(self, level, name);
              if (typeof console === undefinedType && level < self.levels.SILENT) {
                  return "No console available for logging";
              }
          } else {
              throw "log.setLevel() called with invalid level: " + level;
          }
      };

      self.setDefaultLevel = function (level) {
          if (!getPersistedLevel()) {
              self.setLevel(level, false);
          }
      };

      self.enableAll = function(persist) {
          self.setLevel(self.levels.TRACE, persist);
      };

      self.disableAll = function(persist) {
          self.setLevel(self.levels.SILENT, persist);
      };

      var initialLevel = getPersistedLevel();
      if (initialLevel == null) {
          initialLevel = defaultLevel == null ? "WARN" : defaultLevel;
      }
      self.setLevel(initialLevel, false);
    }


    var defaultLogger = new Logger();

    var _loggersByName = {};
    defaultLogger.getLogger = function getLogger(name) {
        if ((typeof name !== "symbol" && typeof name !== "string") || name === "") {
          throw new TypeError("You must supply a name when creating a logger.");
        }

        var logger = _loggersByName[name];
        if (!logger) {
          logger = _loggersByName[name] = new Logger(
            name, defaultLogger.getLevel(), defaultLogger.methodFactory);
        }
        return logger;
    };

    var _log = (typeof window !== undefinedType) ? window.log : undefined;
    defaultLogger.noConflict = function() {
        if (typeof window !== undefinedType &&
               window.log === defaultLogger) {
            window.log = _log;
        }

        return defaultLogger;
    };

    defaultLogger.getLoggers = function getLoggers() {
        return _loggersByName;
    };

    defaultLogger['default'] = defaultLogger;

    return defaultLogger;
}));

_$loglevel_273 = _$loglevel_273.exports
var _$logger_752 = {};
"use strict";
var ____values_752 = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(_$logger_752, "__esModule", { value: true });
_$logger_752.setLevel = _$logger_752.create = _$logger_752.LoggingLevel = void 0;
;
var LoggingLevel;
(function (LoggingLevel) {
    LoggingLevel["trace"] = "trace";
    LoggingLevel["debug"] = "debug";
    LoggingLevel["info"] = "info";
    LoggingLevel["warn"] = "warn";
    LoggingLevel["error"] = "error";
})(LoggingLevel = _$logger_752.LoggingLevel || (_$logger_752.LoggingLevel = {}));
function __log_752(level, prefix) {
    var c = '|' + level.toUpperCase() + '|' + prefix + '|';
    var now = function () { return (new Date()); };
    return function (msg, arg) {
        if (arg) {
            _$loglevel_273[level](now() + c + msg, arg);
        }
        else {
            _$loglevel_273[level](now() + c + msg);
        }
    };
}
function __create_752(prefix) {
    var e_1, _a;
    var l = {};
    try {
        for (var _b = ____values_752(Object.keys(LoggingLevel)), _c = _b.next(); !_c.done; _c = _b.next()) {
            var level = _c.value;
            l[level] = __log_752(level, prefix);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return l;
}
_$logger_752.create = __create_752;
_$logger_752.setLevel = _$loglevel_273.setLevel;

var _$bufferInputStream_409 = {};
"use strict";
Object.defineProperty(_$bufferInputStream_409, "__esModule", { value: true });
_$bufferInputStream_409.BufferInputStream = void 0;
;
;
;
var BufferInputStream =  (function () {
    function BufferInputStream(buffer) {
        this.buffer = buffer;
        this.count = buffer.length;
        this.pos = 0;
    }
    BufferInputStream.prototype.read = function () {
        return (this.pos < this.count) ? (this.buffer[this.pos++] & 0xFF) : -1;
    };
    BufferInputStream.prototype.peek = function () {
        return (this.pos < this.count) ? (this.buffer[this.pos] & 0xFF) : -1;
    };
    BufferInputStream.prototype.readMany = function (length) {
        var lengthAdjusted = Math.min(length, this.count - this.pos);
        if (lengthAdjusted < 0) {
            throw new _$errors_280.IOError('Length out of bounds');
        }
        var result = this.buffer.subarray(this.pos, this.pos + lengthAdjusted);
        this.pos += lengthAdjusted;
        return result;
    };
    BufferInputStream.prototype.readUntil = function (delim) {
        var found = this.count;
        for (var i = this.pos; i < this.count; i++) {
            if (this.buffer[i] === delim) {
                found = i;
                break;
            }
        }
        var buffer = this.buffer.subarray(this.pos, found);
        this.pos = (found === this.count) ? found : found + 1;
        return buffer;
    };
    BufferInputStream.prototype.readInt8 = function () {
        return _$uint8array_762.readInt8(this.buffer, this.pos++);
    };
    BufferInputStream.prototype.readInt32 = function () {
        var i = _$uint8array_762.readInt32BE(this.buffer, this.pos);
        this.pos += 4;
        return i;
    };
    BufferInputStream.prototype.readInt64 = function () {
        var hi = _$uint8array_762.readInt32BE(this.buffer, this.pos);
        this.pos += 4;
        var lo = _$uint8array_762.readInt32BE(this.buffer, this.pos);
        this.pos += 4;
        return _$Long_274.fromBits(lo, hi, false);
    };
    BufferInputStream.prototype.readUInt64 = function () {
        var hi = _$uint8array_762.readInt32BE(this.buffer, this.pos);
        this.pos += 4;
        var lo = _$uint8array_762.readInt32BE(this.buffer, this.pos);
        this.pos += 4;
        return _$Long_274.fromBits(lo, hi, true);
    };
    BufferInputStream.prototype.hasRemaining = function () {
        return this.pos < this.buffer.length;
    };
    return BufferInputStream;
}());
_$bufferInputStream_409.BufferInputStream = BufferInputStream;

var _$bufferOutputStream_410 = {};
"use strict";
Object.defineProperty(_$bufferOutputStream_410, "__esModule", { value: true });
_$bufferOutputStream_410.BufferOutputStream = void 0;
;
;
var BufferOutputStream =  (function () {
    function BufferOutputStream(initial) {
        if (initial === void 0) { initial = 32; }
        if (typeof (initial) === 'number') {
            this.buffer = new Uint8Array(initial);
            this.count = 0;
        }
        else {
            this.buffer = initial;
            this.count = initial.length;
        }
    }
    BufferOutputStream.prototype.write = function (val) {
        this.ensureCapacity(this.count + 1);
        this.buffer[this.count++] = val;
    };
    BufferOutputStream.prototype.writeMany = function (buffer, offset, length) {
        if (offset === void 0) { offset = 0; }
        if (length === void 0) { length = buffer.length; }
        if (length === 0) {
            return;
        }
        this.ensureCapacity(this.count + length);
        this.buffer.set(buffer.subarray(offset, offset + length), this.count);
        this.count += length;
    };
    BufferOutputStream.prototype.writeString = function (val) {
        var strArr = _$uint8array_762.uint8FromUtf8(val);
        var length = strArr.length;
        this.ensureCapacity(this.count + length);
        this.buffer.set(strArr, this.count);
        this.count += length;
    };
    BufferOutputStream.prototype.writeInt8 = function (val) {
        this.ensureCapacity(this.count + 1);
        _$uint8array_762.writeInt8(this.buffer, this.count++, val);
    };
    BufferOutputStream.prototype.writeInt32 = function (val) {
        this.ensureCapacity(this.count + 4);
        _$uint8array_762.writeInt32BE(this.buffer, this.count, val);
        this.count += 4;
    };
    BufferOutputStream.prototype.writeInt64 = function (val) {
        this.ensureCapacity(this.count + 8);
        _$uint8array_762.writeInt32BE(this.buffer, this.count, val.getHighBits());
        _$uint8array_762.writeInt32BE(this.buffer, this.count + 4, val.getLowBits());
        this.count += 8;
    };
    BufferOutputStream.prototype.getBuffer = function () {
        return this.buffer.subarray(0, this.count);
    };
    BufferOutputStream.prototype.getBase64 = function () {
        return _$uint8array_762.uint8ToBase64(this.getBuffer());
    };
    BufferOutputStream.prototype.ensureCapacity = function (min) {
        if (min - this.buffer.length > 0) {
            this.grow(min);
        }
    };
    BufferOutputStream.prototype.grow = function (minCapacity) {
        var oldCapacity = this.buffer.length;
        var newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        try {
            var replacement = new Uint8Array(newCapacity);
            replacement.set(this.buffer);
            this.buffer = replacement;
        }
        catch (e) {
            throw new _$errors_280.IOError('Unable to resize BufferOutputStream to ' + newCapacity);
        }
    };
    return BufferOutputStream;
}());
_$bufferOutputStream_410.BufferOutputStream = BufferOutputStream;

var _$consts_415 = {};
"use strict";
Object.defineProperty(_$consts_415, "__esModule", { value: true });
_$consts_415.PROTOCOL = void 0;
_$consts_415.PROTOCOL = {
    TYPE: 'WB',
    CAPABILITIES: isZlibBundleLoaded() ? 10 : 8,
    PROTOCOL_BYTE: 35,
    CURRENT_VERSION: 29
};
function isZlibBundleLoaded() {
    try {
        if (require("zlib")) {
            return true;
        }
    }
    catch (err) {
        return false;
    }
    return false;
}

var _$messageEncoding_755 = {};
"use strict";
Object.defineProperty(_$messageEncoding_755, "__esModule", { value: true });
_$messageEncoding_755.EncodingType = _$messageEncoding_755.MessageEncoding = void 0;
var MESSAGE_TYPE_MASK = 0xA7D8C0;
var ZLIB_TYPE_FLAGS = 0x80;
var MessageEncoding =  (function () {
    function MessageEncoding(encodingByte, messageTypeFlags) {
        this.encodingByte = encodingByte;
        this.messageTypeFlags = messageTypeFlags;
    }
    MessageEncoding.extractMessageType = function (typeAndEncoding) {
        return typeAndEncoding & ~MESSAGE_TYPE_MASK;
    };
    MessageEncoding.extractMessageEncoding = function (typeAndEncoding) {
        var encoding = typeAndEncoding & MESSAGE_TYPE_MASK;
        return (encoding === ZLIB_TYPE_FLAGS) ? _$messageEncoding_755.EncodingType.ZLIB : _$messageEncoding_755.EncodingType.NO_ENCODING;
    };
    return MessageEncoding;
}());
_$messageEncoding_755.MessageEncoding = MessageEncoding;
_$messageEncoding_755.EncodingType = {
    NO_ENCODING: new MessageEncoding(0x00, 0x00),
    ZLIB: new MessageEncoding(0x12, 0x01)
};

var _$object_756 = {};
"use strict";
Object.defineProperty(_$object_756, "__esModule", { value: true });
_$object_756.isObjectAs = void 0;
function isObjectAs(o) {
    return (o instanceof Object);
}
_$object_756.isObjectAs = isObjectAs;

var _$message_769 = {};
"use strict";
var ____extends_769 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$message_769, "__esModule", { value: true });
_$message_769.writeToBuffer = _$message_769.create = _$message_769.parse =   _$message_769.encoding = _$message_769.types = void 0;
;
;
;
;
;
;
;
var __logger_769 = _$logger_752.create('Message');
var zlib;
if (_$consts_415.PROTOCOL.CAPABILITIES === 10) {
    zlib = _$zlibDecompression_764({});
}
else {
    __logger_769.warn('Per message compression is disabled because \'zlib\' bundle is not included');
    zlib = null;
}
var types;
(function (types) {
    types[types["SERVICE_REQUEST"] = 0] = "SERVICE_REQUEST";
    types[types["SERVICE_RESPONSE"] = 6] = "SERVICE_RESPONSE";
    types[types["SERVICE_ERROR"] = 7] = "SERVICE_ERROR";
    types[types["TOPIC_VALUE"] = 4] = "TOPIC_VALUE";
    types[types["TOPIC_DELTA"] = 5] = "TOPIC_DELTA";
    types[types["ABORT_NOTIFICATION"] = 28] = "ABORT_NOTIFICATION";
    types[types["CLOSE_REQUEST"] = 29] = "CLOSE_REQUEST";
    types[types["FETCH_REPLY"] = 34] = "FETCH_REPLY";
})(types = _$message_769.types || (_$message_769.types = {}));
var encoding;
(function (encoding) {
    encoding[encoding["NONE"] = 0] = "NONE";
    encoding[encoding["ENCRYPTION_REQUESTED"] = 1] = "ENCRYPTION_REQUESTED";
    encoding[encoding["COMPRESSION_REQUESTED"] = 2] = "COMPRESSION_REQUESTED";
    encoding[encoding["BASE64_REQUESTED"] = 3] = "BASE64_REQUESTED";
    encoding[encoding["ENCRYPTED"] = 17] = "ENCRYPTED";
    encoding[encoding["COMPRESSED"] = 18] = "COMPRESSED";
    encoding[encoding["BASE64"] = 19] = "BASE64";
})(encoding = _$message_769.encoding || (_$message_769.encoding = {}));
var Message =  (function () {
    function Message(type, msgEncoding, fields, data, headers) {
        this.type = type;
        this.encoding = msgEncoding;
        this.id = fields.id;
        this.topic = fields.topic;
        this.data = data;
        this.headers = headers;
    }
    Message.prototype.getInputStream = function () {
        return new _$bufferInputStream_409.BufferInputStream(this.data);
    };
    return Message;
}());
 void Message;
var WriteableMessage =  (function (_super) {
    ____extends_769(WriteableMessage, _super);
    function WriteableMessage(fields) {
        var _this = _super.call(this, fields.type, fields.encoding, fields, fields.buffer, fields.headers) || this;
        _this.stream = new _$bufferOutputStream_410.BufferOutputStream(fields.buffer);
        return _this;
    }
    WriteableMessage.prototype.getStream = function () {
        return this.stream;
    };
    WriteableMessage.prototype.getBuffer = function () {
        return this.stream.getBuffer();
    };
    return WriteableMessage;
}(Message));
 void WriteableMessage;
function parse(buffer, callback) {
    var bis = new _$bufferInputStream_409.BufferInputStream(buffer);
    var typeAndEncoding = bis.read();
    var type = _$messageEncoding_755.MessageEncoding.extractMessageType(typeAndEncoding);
    var encodingType = _$messageEncoding_755.MessageEncoding.extractMessageEncoding(typeAndEncoding);
    if (types[type] === undefined) {
        callback(new Error("Invalid message type: " + type), null);
    }
    if (type === types.SERVICE_REQUEST || type === types.SERVICE_RESPONSE || type === types.SERVICE_ERROR) {
        callback(null, parseServiceMessage(type, bis));
    }
    else if (type === types.TOPIC_VALUE || type === types.TOPIC_DELTA) {
        parseClientTopicMessage(type, encodingType, bis, callback);
    }
    else {
        var headers = bis.readUntil(0x01).toString().split('\u0002');
        var body = bis.readMany(bis.count);
        var topic = (type === types.FETCH_REPLY) ? headers.shift() : undefined;
        callback(null, new Message(type, encoding.NONE, { topic: topic }, body, headers));
    }
}
_$message_769.parse = parse;
function parseServiceMessage(type, bis) {
    var body = bis.readMany(bis.count);
    return new Message(type, encoding.NONE, {}, body, []);
}
function parseClientTopicMessage(type, encodingType, bis, callback) {
    var headers = [];
    var fields = { id: bis.readInt32() };
    if (encodingType === _$messageEncoding_755.EncodingType.ZLIB && zlib !== null) {
        try {
            var bytes = zlib.decompressSync(bis.readMany(bis.count));
            callback(null, new Message(type, encoding.COMPRESSED, fields, bytes, headers));
        }
        catch (error) {
            callback(error, null);
        }
    }
    else {
        callback(null, new Message(type, encoding.NONE, fields, bis.readMany(bis.count), headers));
    }
}
function __create_769(type) {
    var fields;
    if (type === undefined || (typeof type === 'number' && types[type] === undefined)) {
        throw new _$errors_280.InternalError("Invalid message type: " + type);
    }
    else if (_$object_756.isObjectAs(type)) {
        fields = type;
    }
    else {
        fields = { type: type };
    }
    fields.encoding = fields.encoding || 0;
    fields.headers = fields.headers || [];
    fields.buffer = fields.buffer || new Uint8Array(0);
    return new WriteableMessage(fields);
}
_$message_769.create = __create_769;
function getHeaderString(message) {
    if (message.type !== types.FETCH_REPLY) {
        return '';
    }
    var sh = [message.topic].concat(message.headers);
    return sh.join('\u0002') + '\u0001';
}
function writeToBuffer(message, bos) {
    bos.write(message.type);
    bos.writeString(getHeaderString(message));
    bos.writeMany(message.getBuffer());
}
_$message_769.writeToBuffer = writeToBuffer;

var _$enumerize_747 = {};
"use strict";
Object.defineProperty(_$enumerize_747, "__esModule", { value: true });
_$enumerize_747.enumerize = void 0;
function enumerize(obj) {
    Object.keys(obj).forEach(function (key) {
        var id = obj[key].id;
        if (id !== undefined) {
            obj[id] = key;
        }
    });
}
_$enumerize_747.enumerize = enumerize;

var _$errorReason_279 = {};
"use strict";
Object.defineProperty(_$errorReason_279, "__esModule", { value: true });
_$errorReason_279.ErrorReason = void 0;
;
;
_$errorReason_279.ErrorReason = {
    COMMUNICATION_FAILURE: new _$errorReason_298.ErrorReason(100, 'Communication with server failed'),
    SESSION_CLOSED: new _$errorReason_298.ErrorReason(101, 'Session is closed'),
    REQUEST_TIME_OUT: new _$errorReason_298.ErrorReason(102, 'Request time out'),
    ACCESS_DENIED: new _$errorReason_298.ErrorReason(103, 'Access denied'),
    UNSUPPORTED: new _$errorReason_298.ErrorReason(104, 'Unsupported service'),
    CALLBACK_EXCEPTION: new _$errorReason_298.ErrorReason(105, 'An application callback threw an exception. Check logs for more information'),
    INVALID_DATA: new _$errorReason_298.ErrorReason(106, 'Invalid data'),
    NO_SUCH_SESSION: new _$errorReason_298.ErrorReason(107, 'A requested session could not be found'),
    INCOMPATIBLE_DATATYPE: new _$errorReason_298.ErrorReason(108, 'Data type is incompatible'),
    UNHANDLED_MESSAGE: new _$errorReason_298.ErrorReason(109, 'A message was not handled'),
    CLUSTER_REPARTITION: new _$errorReason_298.ErrorReason(110, 'The cluster was repartitioning and the request could not be routed.'),
    INCOMPATIBLE_STATE: new _$errorReason_298.ErrorReason(111, 'Topic operation not performed because it is managed by a component that prohibits external updates'),
    CLUSTER_ROUTING: new _$errorReason_298.ErrorReason(112, 'The cluster operation could not be routed.'),
    TOPIC_TREE_REGISTRATION_CONFLICT: new _$errorReason_298.ErrorReason(200, 'A conflicting registration exists on the same branch of the topic tree'),
    HANDLER_CONFLICT: new _$errorReason_298.ErrorReason(201, 'Conflict with an existing handler'),
    INVALID_PATH: new _$errorReason_298.ErrorReason(202, 'Invalid path'),
    REJECTED_REQUEST: new _$errorReason_298.ErrorReason(9003, 'A request has been rejected by the recipient session')
};
_$enumerize_747.enumerize(_$errorReason_279.ErrorReason);

var _$serviceAdapter_302 = {};
"use strict";
Object.defineProperty(_$serviceAdapter_302, "__esModule", { value: true });
_$serviceAdapter_302.ServiceAdapter = void 0;
;
;
;
;
;
;
;
;
;
var __log_302 = _$logger_752.create('ServiceAdapter');
var NULL_CALLBACK = {
    respond: function () {
    },
    fail: function () {
    }
};
var ServiceAdapter =  (function () {
    function ServiceAdapter(internalSession, sender) {
        this.listeners = {};
        this.internalSession = internalSession;
        this.sender = sender;
    }
    ServiceAdapter.prototype.sendRequest = function (header, command, serialiser) {
        var msg = _$message_769.create({
            type: _$message_769.types.SERVICE_REQUEST
        });
        var bos = msg.getStream();
        _$commandHeaderSerialiser_442.CommandHeaderSerialiser.write(bos, header);
        serialiser.write(bos, command);
        __log_302.debug('Sending command request: ' + header, command);
        this.sender(msg);
    };
    ServiceAdapter.prototype.sendResponse = function (header, command, serialiser) {
        var msg = _$message_769.create({
            type: _$message_769.types.SERVICE_RESPONSE
        });
        var bos = msg.getStream();
        _$commandHeaderSerialiser_442.ResponseCommandHeaderSerialiser.write(bos, header);
        serialiser.write(bos, command);
        __log_302.debug('Sending command response: ' + header, command);
        this.sender(msg);
    };
    ServiceAdapter.prototype.sendError = function (header, error, message) {
        var msg = _$message_769.create({
            type: _$message_769.types.SERVICE_ERROR
        });
        var bos = msg.getStream();
        _$commandHeaderSerialiser_442.ResponseCommandHeaderSerialiser.write(bos, header);
        _$codec_411.writeString(bos, message);
        _$codec_411.writeInt32(bos, error.id);
        __log_302.debug('Sending command error: ' + error.id, message);
        this.sender(msg);
    };
    ServiceAdapter.prototype.addService = function (definition, service) {
        var _this = this;
        if (this.listeners[definition.id] === undefined) {
            var requestSerialiser_1 = definition.request;
            var responseSerialiser_1 = definition.response;
            this.listeners[definition.id] = function (header, input) {
                var request = requestSerialiser_1.read(input);
                var callback = header.cid.equals(_$conversationId_314.ONEWAY_CID) ? NULL_CALLBACK : {
                    respond: function (response) {
                        var rHeader = header.createResponseHeader();
                        _this.sendResponse(rHeader, response, responseSerialiser_1);
                    },
                    fail: function (error, message, rethrowError) {
                        if (rethrowError === void 0) { rethrowError = true; }
                        var eHeader = header.createErrorHeader();
                        _this.sendError(eHeader, error, message);
                        if (rethrowError) {
                            throw new _$errors_280.RuntimeError('Callback received an error', error);
                        }
                    }
                };
                try {
                    service.onRequest(_this.internalSession, request, callback);
                }
                catch (e) {
                    __log_302.error(e);
                    throw new _$errors_280.RuntimeError("Unable to handle request for service " + definition.id);
                }
            };
        }
        else {
            throw new _$errors_280.RuntimeError("Service already exists for service " + definition.id);
        }
    };
    ServiceAdapter.prototype.isServiceRegistered = function (serviceId) {
        return (this.listeners[serviceId] !== undefined);
    };
    ServiceAdapter.prototype.onMessage = function (modes, data) {
        switch (modes) {
            case _$message_769.types.SERVICE_REQUEST:
                this.handleRequest(_$commandHeaderSerialiser_442.CommandHeaderSerialiser.read(data), data);
                break;
            case _$message_769.types.SERVICE_RESPONSE:
                this.handleResponse(_$conversationIdSerialiser_313.CIDSerialiser.read(data), data);
                break;
            case _$message_769.types.SERVICE_ERROR:
                this.handleError(_$conversationIdSerialiser_313.CIDSerialiser.read(data), data);
                break;
            default:
                throw new _$errors_280.AssertionError("Unknown Command Service message " + modes);
        }
    };
    ServiceAdapter.prototype.handleRequest = function (header, input) {
        var listener = this.listeners[header.service];
        if (listener) {
            __log_302.debug('Received command request for service: ' + header);
            listener(header, input);
        }
        else {
            __log_302.error('Received command request for unknown service: ' + header);
            this.sendError(header.createErrorHeader(), _$errorReason_279.ErrorReason.COMMUNICATION_FAILURE, "Unknown client service: " + header.service);
        }
    };
    ServiceAdapter.prototype.handleResponse = function (cid, input) {
        __log_302.debug('Received command response: ' + cid);
        this.internalSession.getConversationSet().respondIfPresent(cid, input);
    };
    ServiceAdapter.prototype.handleError = function (cid, input) {
        var description = _$codec_411.readString(input);
        var code = _$codec_411.readInt32(input);
        var error = new _$errorReason_298.ErrorReason(code, description);
        __log_302.warn('Received command error', error);
        this.internalSession.getConversationSet().discard(cid, error);
    };
    return ServiceAdapter;
}());
_$serviceAdapter_302.ServiceAdapter = ServiceAdapter;

var _$serviceLocator_303 = {};
"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(_$serviceLocator_303, "__esModule", { value: true });
_$serviceLocator_303.ServiceLocatorImpl = void 0;
;
;
var __log_303 = _$logger_752.create('ServiceLocator');
var ServiceLocatorImpl =  (function () {
    function ServiceLocatorImpl(context, serviceAdapter) {
        this.context = context;
        this.serviceAdapter = serviceAdapter;
    }
    ServiceLocatorImpl.prototype.obtain = function (service) {
        var _this = this;
        var requestSerialiser = service.request;
        var responseSerialiser = service.response;
        var reference = {
            send: function (req, callback) {
                if (callback === void 0) { callback = function () { }; }
                return __awaiter(_this, void 0, void 0, function () {
                    var handler, conversations, conversationId;
                    var _this = this;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                handler = {
                                    onOpen: function (cid) {
                                        var header = new _$commandHeader_443.CommandHeader(service.id, cid);
                                        try {
                                            _this.serviceAdapter.sendRequest(header, req, requestSerialiser);
                                        }
                                        catch (e) {
                                            callback(e);
                                            throw e;
                                        }
                                    },
                                    onResponse: function (cid, input) {
                                        var response;
                                        try {
                                            response = responseSerialiser.read(input);
                                        }
                                        catch (e) {
                                            __log_303.debug("Failed to deserialise response from service " + service.id, e.stack);
                                            callback(e);
                                            return true;
                                        }
                                        try {
                                            callback(null, response);
                                        }
                                        catch (e) {
                                            __log_303.debug("Request callback for service '" + service.id + "' threw an error", e.stack);
                                            try {
                                                callback(e);
                                            }
                                            catch (e) {
                                                __log_303.debug("Failed to notify callback error for service '" + service.id + "'", e);
                                            }
                                        }
                                        return true;
                                    },
                                    onDiscard: function (cid, err) {
                                        callback(err);
                                    }
                                };
                                conversations = this.context.getConversationSet();
                                return [4 , conversations.newConversation(handler)];
                            case 1:
                                conversationId = _a.sent();
                                return [2 , function () {
                                        conversations.discard(conversationId, new Error('Cancelled'));
                                    }];
                        }
                    });
                });
            }
        };
        return reference;
    };
    return ServiceLocatorImpl;
}());
_$serviceLocator_303.ServiceLocatorImpl = ServiceLocatorImpl;

var _$topicSpecification_783 = {};
"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var ____values_783 = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(_$topicSpecification_783, "__esModule", { value: true });
_$topicSpecification_783.TopicSpecification = void 0;
;
var __keys_783 = [
    'PUBLISH_VALUES_ONLY',
    'SCHEMA',
    'VALIDATE_VALUES',
    'TIDY_ON_UNSUBSCRIBE',
    'TIME_SERIES_EVENT_VALUE_TYPE',
    'TIME_SERIES_RETAINED_RANGE',
    'TIME_SERIES_SUBSCRIPTION_RANGE',
    'DONT_RETAIN_VALUE',
    'PERSISTENT',
    'REMOVAL',
    'OWNER',
    'COMPRESSION',
    'CONFLATION',
    'PRIORITY'
];
var TopicSpecification =  (function () {
    function TopicSpecification(type, properties) {
        if (properties === void 0) { properties = {}; }
        this.type = type;
        this.properties = properties;
    }
    TopicSpecification.prototype.withProperty = function (key, value) {
        var _a;
        if (typeof key !== 'string' || __keys_783.indexOf(key.toUpperCase()) < 0) {
            throw new _$errors_280.IllegalArgumentError("Invalid key: " + key);
        }
        if (typeof value !== 'string') {
            throw new _$errors_280.IllegalArgumentError("Invalid value, must be string: " + value);
        }
        var newProperties = __assign(__assign({}, this.properties), (_a = {}, _a[key] = value, _a));
        return new TopicSpecification(this.type, newProperties);
    };
    TopicSpecification.prototype.withProperties = function (properties) {
        var e_1, _a;
        try {
            for (var _b = ____values_783(Object.getOwnPropertyNames(properties)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var key = _c.value;
                if (typeof key !== 'string' || __keys_783.indexOf(key.toUpperCase()) < 0) {
                    throw new _$errors_280.IllegalArgumentError("Invalid key: " + key);
                }
                var value = properties[key];
                if (typeof value !== 'string') {
                    throw new _$errors_280.IllegalArgumentError("Invalid value, must be string: " + value);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        var newProperties = __assign(__assign({}, this.properties), properties);
        return new TopicSpecification(this.type, newProperties);
    };
    TopicSpecification.PUBLISH_VALUES_ONLY = 'PUBLISH_VALUES_ONLY';
    TopicSpecification.VALIDATE_VALUES = 'VALIDATE_VALUES';
    TopicSpecification.TIDY_ON_UNSUBSCRIBE = 'TIDY_ON_UNSUBSCRIBE';
    TopicSpecification.TIME_SERIES_EVENT_VALUE_TYPE = 'TIME_SERIES_EVENT_VALUE_TYPE';
    TopicSpecification.TIME_SERIES_RETAINED_RANGE = 'TIME_SERIES_RETAINED_RANGE';
    TopicSpecification.TIME_SERIES_SUBSCRIPTION_RANGE = 'TIME_SERIES_SUBSCRIPTION_RANGE';
    TopicSpecification.SCHEMA = 'SCHEMA';
    TopicSpecification.DONT_RETAIN_VALUE = 'DONT_RETAIN_VALUE';
    TopicSpecification.PERSISTENT = 'PERSISTENT';
    TopicSpecification.REMOVAL = 'REMOVAL';
    TopicSpecification.CONFLATION = 'CONFLATION';
    TopicSpecification.OWNER = 'OWNER';
    TopicSpecification.COMPRESSION = 'COMPRESSION';
    TopicSpecification.PRIORITY = 'PRIORITY';
    return TopicSpecification;
}());
_$topicSpecification_783.TopicSpecification = TopicSpecification;

var _$topicType_784 = {};
"use strict";
Object.defineProperty(_$topicType_784, "__esModule", { value: true });
_$topicType_784.TopicType = void 0;
var TopicType;
(function (TopicType) {
    TopicType[TopicType["BINARY"] = 14] = "BINARY";
    TopicType[TopicType["JSON"] = 15] = "JSON";
    TopicType[TopicType["STRING"] = 17] = "STRING";
    TopicType[TopicType["INT64"] = 18] = "INT64";
    TopicType[TopicType["DOUBLE"] = 19] = "DOUBLE";
    TopicType[TopicType["TIME_SERIES"] = 16] = "TIME_SERIES";
    TopicType[TopicType["RECORD_V2"] = 20] = "RECORD_V2";
    TopicType[TopicType["UNKNOWN_TOPIC_TYPE"] = 21] = "UNKNOWN_TOPIC_TYPE";
})(TopicType = _$topicType_784.TopicType || (_$topicType_784.TopicType = {}));

var _$fetchRequest_781 = {};
"use strict";
Object.defineProperty(_$fetchRequest_781, "__esModule", { value: true });
_$fetchRequest_781.FetchRequest = void 0;
;
var FetchRequest =  (function () {
    function FetchRequest() {
    }
    FetchRequest.getAllTypes = function () {
        return new Set([
            _$topicType_784.TopicType.JSON,
            _$topicType_784.TopicType.BINARY,
            _$topicType_784.TopicType.RECORD_V2,
            _$topicType_784.TopicType.DOUBLE,
            _$topicType_784.TopicType.INT64,
            _$topicType_784.TopicType.STRING,
            _$topicType_784.TopicType.TIME_SERIES
        ]);
    };
    return FetchRequest;
}());
_$fetchRequest_781.FetchRequest = FetchRequest;

var _$topics_785 = {};
"use strict";
Object.defineProperty(_$topics_785, "__esModule", { value: true });
_$topics_785.topicsNamespace = _$topics_785.TopicAddFailReasonEnum =  _$topics_785.UpdateFailReasonEnum =  _$topics_785.UnsubscribeReasonEnum =  void 0;
;
;
;
;
var UnsubscribeReason =  (function () {
    function UnsubscribeReason(id, reason) {
        this.id = id;
        this.reason = reason;
    }
    return UnsubscribeReason;
}());
 void UnsubscribeReason;
_$topics_785.UnsubscribeReasonEnum = {
    SUBSCRIPTION_REFRESH: new UnsubscribeReason(undefined, 'The server has re-subscribed this session'),
    STREAM_CHANGE: new UnsubscribeReason(undefined, 'A more specific stream has been registered to the same path'),
    REQUESTED: new UnsubscribeReason(0, 'The unsubscription was requested by this client'),
    CONTROL: new UnsubscribeReason(1, 'The server or another client unsubscribed this client'),
    REMOVED: new UnsubscribeReason(2, 'The topic was removed'),
    AUTHORIZATION: new UnsubscribeReason(3, 'Not authorized to subscribe to this topic'),
    UNKNOWN_UNSUBSCRIBE_REASON: new UnsubscribeReason(4, 'Unknown unsubscribe reason'),
    BACK_PRESSURE: new UnsubscribeReason(5, 'The server has unsubscribed due to a backlog of messages'),
    BRANCH_MAPPINGS: new UnsubscribeReason(6, 'Branch mapping rules have changed')
};
_$enumerize_747.enumerize(_$topics_785.UnsubscribeReasonEnum);
Object.freeze(_$topics_785.UnsubscribeReasonEnum);
var UpdateFailReason =  (function () {
    function UpdateFailReason(id, reason) {
        this.id = id;
        this.reason = reason;
    }
    return UpdateFailReason;
}());
 void UpdateFailReason;
_$topics_785.UpdateFailReasonEnum = {
    INCOMPATIBLE_UPDATE: new UpdateFailReason(1, 'Update type is incompatible with topic type'),
    UPDATE_FAILED: new UpdateFailReason(2, 'Update failed - possible content incompatibility'),
    MISSING_TOPIC: new UpdateFailReason(4, 'Topic does not exist'),
    DELTA_WITHOUT_VALUE: new UpdateFailReason(8, 'An attempt has been made to apply a delta to a topic that does not yet have a value'),
    CLUSTER_REPARTITION: new UpdateFailReason(9, 'When trying to update the topic the cluster was migrating the partition that owns the topic'),
    INCOMPATIBLE_STATE: new UpdateFailReason(10, 'An update could not be performed because the topic is managed by' +
        'a component (e.g fan-out) that prohibits updates from the caller'),
    UNSATISFIED_CONSTRAINT: new UpdateFailReason(-1, 'The topic update failed because the constraint was not satisfied'),
    INVALID_UPDATE_STREAM: new UpdateFailReason(-2, 'The topic update failed because the update stream is no longer valid')
};
_$enumerize_747.enumerize(_$topics_785.UpdateFailReasonEnum);
Object.freeze(_$topics_785.UpdateFailReasonEnum);
var TopicAddFailReason =  (function () {
    function TopicAddFailReason(id, reason) {
        this.id = id;
        this.reason = reason;
    }
    return TopicAddFailReason;
}());
 void TopicAddFailReason;
_$topics_785.TopicAddFailReasonEnum = {
    EXISTS: new TopicAddFailReason(1, 'The topic already exists with the same details'),
    EXISTS_MISMATCH: new TopicAddFailReason(2, 'The topic already exists, with different details'),
    INVALID_NAME: new TopicAddFailReason(15, 'The supplied topic path is invalid.'),
    INVALID_DETAILS: new TopicAddFailReason(4, 'The topic details are invalid'),
    PERMISSIONS_FAILURE: new TopicAddFailReason(7, 'Invalid permissions to add a topic at the specified path'),
    UNEXPECTED_ERROR: new TopicAddFailReason(9, 'An unexpected error occured while creating the topic'),
    CLUSTER_REPARTITION: new TopicAddFailReason(10, 'When trying to create the topic the cluster was migrating the partition that owns the topic'),
    EXCEEDED_LICENSE_LIMIT: new TopicAddFailReason(11, 'Adding the topic failed because of a license limit'),
    EXISTS_INCOMPATIBLE: new TopicAddFailReason(14, 'Adding the topic failed because a topic is already bound to the specified' +
        'path but the caller does not have the rights to manage it')
};
_$enumerize_747.enumerize(_$topics_785.TopicAddFailReasonEnum);
Object.freeze(_$topics_785.TopicAddFailReasonEnum);
_$topics_785.topicsNamespace = {
    FetchRequest: _$fetchRequest_781.FetchRequest,
    TopicType: _$topicType_784.TopicType,
    TopicSpecification: _$topicSpecification_783.TopicSpecification,
    UnsubscribeReason: _$topics_785.UnsubscribeReasonEnum,
    UpdateFailReason: _$topics_785.UpdateFailReasonEnum,
    TopicAddFailReason: _$topics_785.TopicAddFailReasonEnum 
};

var _$closeReason_296 = {};
"use strict";
Object.defineProperty(_$closeReason_296, "__esModule", { value: true });
_$closeReason_296.CloseReasonImpl = void 0;
var CloseReasonImpl =  (function () {
    function CloseReasonImpl(id, message, canReconnect) {
        this.id = id;
        this.message = message;
        this.canReconnect = canReconnect;
    }
    CloseReasonImpl.prototype.toString = function () {
        return 'id: ' + this.message;
    };
    return CloseReasonImpl;
}());
_$closeReason_296.CloseReasonImpl = CloseReasonImpl;

var _$anyDatatype_317 = {};
"use strict";
Object.defineProperty(_$anyDatatype_317, "__esModule", { value: true });
_$anyDatatype_317.AnyDataTypeImpl = void 0;
var AnyDataTypeImpl =  (function () {
    function AnyDataTypeImpl() {
        this.valueClass = AnyDataTypeImpl;
    }
    AnyDataTypeImpl.prototype.name = function () {
        return 'any';
    };
    return AnyDataTypeImpl;
}());
_$anyDatatype_317.AnyDataTypeImpl = AnyDataTypeImpl;

var _$int64Impl_334 = {};
"use strict";
var ____values_334 = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(_$int64Impl_334, "__esModule", { value: true });
_$int64Impl_334.Int64Impl = void 0;
;
var P16 = 1 << 16;
var P24 = 1 << 24;
var P32 = P16 * P16;
function putInt32(value, buffer, high) {
    var offset = high ? 0 : 4;
    for (var i = 3; i >= 0; --i) {
        buffer[offset + i] = value & 255;
        value = value >> 8;
    }
}
function getInt32(buffer, high) {
    var offset = high ? 0 : 4;
    return (buffer[offset] * P24) +
        (buffer[offset + 1] << 16) +
        (buffer[offset + 2] << 8) +
        buffer[offset + 3];
}
function putPositiveNumber(value, buffer) {
    for (var i = 7; i >= 0; --i) {
        buffer[i] = value & 255;
        value /= 256;
    }
}
function putNegativeNumber(value, buffer) {
    value++;
    for (var i = 7; i >= 0; --i) {
        buffer[i] = ((-value) & 255) ^ 255;
        value /= 256;
    }
}
function putString(value, radix, buffer) {
    var e_1, _a;
    var negative = value[0] === '-';
    if (negative) {
        value = value.substring(1);
    }
    else if (value.substring(0, 2) === '0x') {
        value = value.substring(2);
        radix = 16;
    }
    var high = 0;
    var low = 0;
    try {
        for (var value_1 = ____values_334(value), value_1_1 = value_1.next(); !value_1_1.done; value_1_1 = value_1.next()) {
            var char = value_1_1.value;
            low = low * radix + parseInt(char, radix);
            high = high * radix + Math.floor(low / P32);
            low %= P32;
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (value_1_1 && !value_1_1.done && (_a = value_1.return)) _a.call(value_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    if (negative) {
        high = ~high;
        if (low) {
            low = P32 - low;
        }
        else {
            high++;
        }
    }
    putInt32(high, buffer, true);
    putInt32(low, buffer, false);
}
var Int64Impl =  (function () {
    function Int64Impl(value, radix) {
        this.buffer = Uint8Array.from([0, 0, 0, 0, 0, 0, 0, 0]);
        if (_$uint8array_762.isUint8Array(value)) {
            this.buffer = value;
        }
        if (typeof value === 'string') {
            radix = radix || 10;
            putString(value, radix, this.buffer);
        }
        if (typeof value === 'number') {
            if (typeof radix === 'number') {
                putInt32(value, this.buffer, true);
                putInt32(radix, this.buffer, false);
            }
            else if (value >= 0) {
                putPositiveNumber(value, this.buffer);
            }
            else {
                putNegativeNumber(value, this.buffer);
            }
        }
        if (value instanceof Int64Impl) {
            putInt32(value.getHighBits(), this.buffer, true);
            putInt32(value.getLowBits(), this.buffer, false);
        }
    }
    Int64Impl.toString = function () {
        return 'Int64Impl';
    };
    Int64Impl.prototype.getHighBits = function () {
        return getInt32(this.buffer, true);
    };
    Int64Impl.prototype.getLowBits = function () {
        return getInt32(this.buffer, false);
    };
    Int64Impl.prototype.toBuffer = function () {
        return this.buffer;
    };
    Int64Impl.prototype.toNumber = function () {
        var high = this.getHighBits() | 0;
        var low = this.getLowBits();
        return high ? high * P32 + low : low;
    };
    Int64Impl.prototype.isNegative = function () {
        return !!(this.getHighBits() & 0x80000000);
    };
    Int64Impl.prototype.toString = function (radix) {
        if (radix === void 0) { radix = 10; }
        var high = this.getHighBits();
        var low = this.getLowBits();
        var sign = this.isNegative();
        if (sign) {
            high = ~high;
            low = P32 - low;
        }
        if (high === 0 && low === 0) {
            return '0';
        }
        var result = '';
        while (high || low) {
            var rem = (high % radix) * P32 + low;
            high = Math.floor(high / radix);
            low = Math.floor(rem / radix);
            result = (rem % radix).toString(radix) + result;
        }
        if (sign) {
            result = '-' + result;
        }
        return result;
    };
    Int64Impl.prototype.equals = function (other) {
        if (other && other instanceof Int64Impl) {
            return this.getHighBits() === other.getHighBits() && this.getLowBits() === other.getLowBits();
        }
        return false;
    };
    return Int64Impl;
}());
_$int64Impl_334.Int64Impl = Int64Impl;

var _$consts_291 = {};
"use strict";
Object.defineProperty(_$consts_291, "__esModule", { value: true });
_$consts_291.isStructEnd = _$consts_291.isStructStart = _$consts_291.tokens = _$consts_291.BYTE_BREAK = _$consts_291.additional = _$consts_291.types = void 0;
var __types_291;
(function (types) {
    types[types["UINT"] = 0] = "UINT";
    types[types["INT"] = 1] = "INT";
    types[types["BYTES"] = 2] = "BYTES";
    types[types["STRING"] = 3] = "STRING";
    types[types["ARRAY"] = 4] = "ARRAY";
    types[types["MAP"] = 5] = "MAP";
    types[types["SEMANTIC"] = 6] = "SEMANTIC";
    types[types["SIMPLE"] = 7] = "SIMPLE";
    types[types["FLOAT"] = 7] = "FLOAT";
})(__types_291 = _$consts_291.types || (_$consts_291.types = {}));
var additional;
(function (additional) {
    additional[additional["FALSE"] = 20] = "FALSE";
    additional[additional["TRUE"] = 21] = "TRUE";
    additional[additional["NULL"] = 22] = "NULL";
    additional[additional["UNDEFINED"] = 23] = "UNDEFINED";
    additional[additional["SIMPLE"] = 24] = "SIMPLE";
    additional[additional["HALF_PRECISION"] = 25] = "HALF_PRECISION";
    additional[additional["SINGLE_PRECISION"] = 26] = "SINGLE_PRECISION";
    additional[additional["DOUBLE_PRECISION"] = 27] = "DOUBLE_PRECISION";
    additional[additional["BREAK"] = 31] = "BREAK";
})(additional = _$consts_291.additional || (_$consts_291.additional = {}));
_$consts_291.BYTE_BREAK = 255;
var tokens;
(function (tokens) {
    tokens[tokens["ARRAY_START"] = 0] = "ARRAY_START";
    tokens[tokens["ARRAY_END"] = 1] = "ARRAY_END";
    tokens[tokens["MAP_START"] = 2] = "MAP_START";
    tokens[tokens["MAP_END"] = 3] = "MAP_END";
    tokens[tokens["STRING_START"] = 4] = "STRING_START";
    tokens[tokens["STRING_END"] = 5] = "STRING_END";
    tokens[tokens["VALUE"] = 6] = "VALUE";
})(tokens = _$consts_291.tokens || (_$consts_291.tokens = {}));
function isStructStart(token) {
    switch (token) {
        case tokens.ARRAY_START:
        case tokens.MAP_START:
        case tokens.STRING_START:
            return true;
        default:
            return false;
    }
}
_$consts_291.isStructStart = isStructStart;
function isStructEnd(token) {
    switch (token) {
        case tokens.ARRAY_END:
        case tokens.MAP_END:
        case tokens.STRING_END:
            return true;
        default:
            return false;
    }
}
_$consts_291.isStructEnd = isStructEnd;

var _$context_292 = {};
"use strict";
Object.defineProperty(_$context_292, "__esModule", { value: true });
_$context_292.Context = _$context_292.TokenContextType = void 0;
;
var TokenContextType;
(function (TokenContextType) {
    TokenContextType[TokenContextType["root"] = 0] = "root";
    TokenContextType[TokenContextType["string"] = 1] = "string";
    TokenContextType[TokenContextType["array"] = 2] = "array";
    TokenContextType[TokenContextType["object"] = 3] = "object";
})(TokenContextType = _$context_292.TokenContextType || (_$context_292.TokenContextType = {}));
var Context =  (function () {
    function Context() {
        this.ROOT = { length: -1, type: TokenContextType.root, read: 0 };
        this.stack = [];
        this.tail = this.ROOT;
    }
    Context.prototype.type = function () {
        return this.tail.type;
    };
    Context.prototype.read = function () {
        return this.tail.read;
    };
    Context.prototype.expected = function () {
        return this.tail.length;
    };
    Context.prototype.push = function (type, length) {
        if (length === void 0) { length = -1; }
        this.tail = {
            length: length,
            type: type,
            read: 0
        };
        this.stack.push(this.tail);
    };
    Context.prototype.pop = function () {
        var prev = this.stack.pop();
        if (this.stack.length) {
            this.tail = this.stack[this.stack.length - 1];
        }
        else {
            this.tail = this.ROOT;
        }
        return prev;
    };
    Context.prototype.next = function () {
        if (this.hasRemaining()) {
            this.tail.read++;
        }
        else {
            throw new _$errors_280.InvalidDataError('Exceeded expected collection limit');
        }
    };
    Context.prototype.break = function () {
        if (this.acceptsBreakMarker()) {
            this.tail.length = 0;
            this.tail.read = 0;
        }
    };
    Context.prototype.hasRemaining = function () {
        return (this.tail.length === -1) || (this.tail.length > this.tail.read);
    };
    Context.prototype.acceptsBreakMarker = function () {
        return this.tail !== this.ROOT && this.tail.length === -1;
    };
    return Context;
}());
_$context_292.Context = Context;

var _$tokeniser_295 = {};
"use strict";
Object.defineProperty(_$tokeniser_295, "__esModule", { value: true });
_$tokeniser_295.Tokeniser = void 0;
;
;
;
;
;
var BREAK_FLAG = new Error();
var EMPTY_BUFFER = new Uint8Array(0);
var __MAX_SAFE_INTEGER_295 = 9007199254740991;
var MIN_SAFE_INTEGER = -9007199254740991;
var Tokeniser =  (function () {
    function Tokeniser(data, offset, length) {
        if (offset === void 0) { offset = 0; }
        if (length === void 0) { length = data.length; }
        this.bufferOffset = offset;
        this.length = length;
        this.data = data;
        this.context = new _$context_292.Context();
        this.pos = this.bufferOffset;
    }
    Tokeniser.prototype.reset = function () {
        this.context = new _$context_292.Context();
        this.token = undefined;
        this.type = undefined;
        this.pos = this.bufferOffset;
    };
    Tokeniser.prototype.hasRemaining = function () {
        var ctx = this.context.type();
        var len = ctx === _$context_292.TokenContextType.root ? this.length : this.length + 1;
        return this.pos < this.bufferOffset + len;
    };
    Tokeniser.prototype.offset = function () {
        return this.pos;
    };
    Tokeniser.prototype.getContext = function () {
        return this.context;
    };
    Tokeniser.prototype.getToken = function () {
        return this.token;
    };
    Tokeniser.prototype.nextToken = function () {
        if (!this.hasRemaining()) {
            return null;
        }
        var ctx = this.context.type();
        var previousPos = this.pos;
        if (ctx !== _$context_292.TokenContextType.root && !this.context.hasRemaining()) {
            switch (ctx) {
                case _$context_292.TokenContextType.object:
                    this.type = _$consts_291.tokens.MAP_END;
                    break;
                case _$context_292.TokenContextType.array:
                    this.type = _$consts_291.tokens.ARRAY_END;
                    break;
                case _$context_292.TokenContextType.string:
                    this.type = _$consts_291.tokens.STRING_END;
                    break;
            }
            this.context.pop();
            return {
                pos: this.pos,
                type: this.type,
                getBuffer: function () {
                    return EMPTY_BUFFER;
                }
            };
        }
        else {
            this.context.next();
        }
        var header = this.readHeader();
        var value;
        switch (header.type) {
            case _$consts_291.types.INT:
            case _$consts_291.types.UINT:
            case _$consts_291.types.FLOAT:
            case _$consts_291.types.SIMPLE:
                this.type = _$consts_291.tokens.VALUE;
                value = this.readValue(header);
                break;
            case _$consts_291.types.BYTES:
            case _$consts_291.types.STRING:
                if (header.raw === _$consts_291.additional.BREAK) {
                    this.context.push(_$context_292.TokenContextType.string, -1);
                    this.type = _$consts_291.tokens.STRING_START;
                }
                else {
                    this.type = _$consts_291.tokens.VALUE;
                    value = this.readValue(header);
                }
                break;
            case _$consts_291.types.ARRAY:
                this.context.push(_$context_292.TokenContextType.array, this.readCollectionLength(header));
                this.type = _$consts_291.tokens.ARRAY_START;
                break;
            case _$consts_291.types.MAP:
                var len = this.readCollectionLength(header);
                if (len >= 0) {
                    len = len * 2;
                }
                this.context.push(_$context_292.TokenContextType.object, len);
                this.type = _$consts_291.tokens.MAP_START;
                break;
            case _$consts_291.types.SEMANTIC:
                return this.nextToken();
            default:
                throw new _$errors_280.InvalidDataError('Unknown CBOR header type: ' + header.type);
        }
        if (value instanceof Error) {
            if (this.context.acceptsBreakMarker()) {
                this.context.break();
                return this.nextToken();
            }
            else {
                throw new _$errors_280.InvalidDataError('Unexpected break flag outside of indefinite-length context');
            }
        }
        var data = this.data;
        this.token = {
            pos: previousPos,
            type: this.type,
            value: value,
            header: header,
            length: this.pos,
            getBuffer: function () {
                return data.subarray(this.pos, this.length);
            }
        };
        return this.token;
    };
    Tokeniser.prototype.readValue = function (header) {
        switch (header.type) {
            case _$consts_291.types.UINT:
                return this.readHeaderValue(header);
            case _$consts_291.types.INT:
                return this.readHeaderValue(header, true);
            case _$consts_291.types.BYTES:
                return this.readBuffer(this.readHeaderValue(header));
            case _$consts_291.types.STRING:
                return _$uint8array_762.uint8toUtf8(this.readBuffer(this.readHeaderValue(header)));
            case _$consts_291.types.SIMPLE:
                return this.readSimpleValue(header.raw);
        }
        throw new _$errors_280.InvalidDataError('Unrecognised value type (' + header.type + ')');
    };
    Tokeniser.prototype.readSimpleValue = function (type) {
        switch (type) {
            case _$consts_291.additional.TRUE:
                return true;
            case _$consts_291.additional.FALSE:
                return false;
            case _$consts_291.additional.NULL:
                return null;
            case _$consts_291.additional.BREAK:
                return BREAK_FLAG;
            case _$consts_291.additional.HALF_PRECISION:
                return this.readFloat16();
            case _$consts_291.additional.SINGLE_PRECISION:
                return this.readFloat32();
            case _$consts_291.additional.DOUBLE_PRECISION:
                return this.readFloat64();
            default:
                return undefined;
        }
    };
    Tokeniser.prototype.readByte = function () {
        if (this.pos < this.data.length) {
            return this.data[this.pos++];
        }
        else {
            throw new _$errors_280.InvalidDataError('Exhausted token stream');
        }
    };
    Tokeniser.prototype.readBuffer = function (len) {
        return this.data.subarray(this.pos, this.pos += len);
    };
    Tokeniser.prototype.readUint16 = function () {
        var res = _$uint8array_762.readUInt16BE(this.data, this.pos);
        this.pos += 2;
        return res;
    };
    Tokeniser.prototype.readUint32 = function () {
        var res = _$uint8array_762.readUInt32BE(this.data, this.pos);
        this.pos += 4;
        return res;
    };
    Tokeniser.prototype.readUint64 = function (signed) {
        var buf = Uint8Array.from(this.readBuffer(8));
        if (signed) {
            for (var j = 0; j < 8; ++j) {
                buf[j] = ~buf[j];
            }
        }
        var i = new _$int64Impl_334.Int64Impl(buf);
        var n = i.toNumber();
        if (n <= __MAX_SAFE_INTEGER_295 && n >= MIN_SAFE_INTEGER) {
            return n;
        }
        return i;
    };
    Tokeniser.prototype.readFloat16 = function () {
        var h = this.readUint16();
        var f = (h & 0x03ff);
        var s = (h & 0x8000) >> 15;
        var e = (h & 0x7c00) >> 10;
        var sign = s ? -1 : 1;
        if (e === 0) {
            return sign * Math.pow(2, -14) * (f / Math.pow(2, 10));
        }
        else if (e === 0x1f) {
            return f ? NaN : sign * Infinity;
        }
        return sign * Math.pow(2, e - 15) * (1 + (f / Math.pow(2, 10)));
    };
    Tokeniser.prototype.readFloat32 = function () {
        var res = _$uint8array_762.readFloatBE(this.data, this.pos);
        this.pos += 4;
        return res;
    };
    Tokeniser.prototype.readFloat64 = function () {
        var res = _$uint8array_762.readDoubleBE(this.data, this.pos);
        this.pos += 8;
        return res;
    };
    Tokeniser.prototype.readHeader = function () {
        var header = this.readByte();
        return {
            type: header >> 5,
            raw: header & 0x1F
        };
    };
    Tokeniser.prototype.readHeaderValue = function (header, signed) {
        if (signed === void 0) { signed = false; }
        var low = header.raw;
        var sign = function (value) { return signed ? -1 - value : value; };
        if (low < 24) {
            return sign(low);
        }
        switch (low) {
            case _$consts_291.additional.SIMPLE:
                return sign(this.readByte());
            case _$consts_291.additional.HALF_PRECISION:
                return sign(this.readUint16());
            case _$consts_291.additional.SINGLE_PRECISION:
                return sign(this.readUint32());
            case _$consts_291.additional.DOUBLE_PRECISION:
                return this.readUint64(signed);
            case _$consts_291.additional.BREAK:
                return BREAK_FLAG;
            default:
                throw new _$errors_280.InvalidDataError('Unexpected value ' + low);
        }
    };
    Tokeniser.prototype.readCollectionLength = function (header) {
        var result = this.readHeaderValue(header);
        return (result === BREAK_FLAG) ? -1 : result;
    };
    return Tokeniser;
}());
_$tokeniser_295.Tokeniser = Tokeniser;

var _$bufferSlice_322 = {};
"use strict";
Object.defineProperty(_$bufferSlice_322, "__esModule", { value: true });
_$bufferSlice_322.BufferSlice = void 0;
var BufferSlice =  (function () {
    function BufferSlice(buffer, offset, length) {
        if (offset === void 0) { offset = 0; }
        if (length === void 0) { length = buffer.length; }
        this.$buffer = buffer;
        this.$offset = offset;
        this.$length = length;
    }
    return BufferSlice;
}());
_$bufferSlice_322.BufferSlice = BufferSlice;

var _$binaryDeltaImpl_319 = {};
"use strict";
var ____extends_319 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$binaryDeltaImpl_319, "__esModule", { value: true });
_$binaryDeltaImpl_319.BinaryDeltaImpl = void 0;
;
;
;
var BinaryDeltaImpl =  (function (_super) {
    ____extends_319(BinaryDeltaImpl, _super);
    function BinaryDeltaImpl(buffer, offset, length) {
        if (offset === void 0) { offset = 0; }
        if (length === void 0) { length = buffer.length; }
        return _super.call(this, buffer, offset, length) || this;
    }
    BinaryDeltaImpl.prototype.visit = function (visitor) {
        if (this.hasChanges()) {
            var tokeniser = new _$tokeniser_295.Tokeniser(this.$buffer, this.$offset, this.$length);
            while (tokeniser.hasRemaining()) {
                var token = tokeniser.nextToken();
                var isEnd = false;
                if (_$uint8array_762.isUint8Array(token.value)) {
                    isEnd = !visitor.insert(token.value);
                }
                else {
                    var start = token.value;
                    var end = tokeniser.nextToken().value;
                    isEnd = !visitor.match(start, end);
                }
                if (isEnd) {
                    visitor.end();
                    return;
                }
            }
            visitor.end();
        }
        else {
            visitor.noChange();
        }
    };
    BinaryDeltaImpl.prototype.hasChanges = function () {
        return this.$length !== 1;
    };
    return BinaryDeltaImpl;
}(_$bufferSlice_322.BufferSlice));
_$binaryDeltaImpl_319.BinaryDeltaImpl = BinaryDeltaImpl;

var _$decoder_293 = {};
"use strict";
Object.defineProperty(_$decoder_293, "__esModule", { value: true });
 _$decoder_293.isString = _$decoder_293.isInt64 = _$decoder_293.isDouble = _$decoder_293.Decoder = void 0;
;
;
;
;
function decode(token, tokeniser) {
    switch (token.type) {
        case _$consts_291.tokens.VALUE:
            return token.value;
        case _$consts_291.tokens.MAP_START:
            var obj = {};
            for (;;) {
                var field = tokeniser.nextToken();
                if (field === null) {
                    throw new _$errors_280.InvalidDataError('Unexpected EOF (reading: map key)');
                }
                if (field.type === _$consts_291.tokens.MAP_END) {
                    break;
                }
                var value = tokeniser.nextToken();
                if (value === null || value.type === _$consts_291.tokens.MAP_END) {
                    throw new _$errors_280.InvalidDataError('Unexpected EOF (reading: map value)');
                }
                var key = decode(field, tokeniser);
                if (key === undefined || key === null) {
                    throw new _$errors_280.InvalidDataError('Cannot have undefined key (reading: map key)');
                }
                obj[key.toString()] = decode(value, tokeniser);
            }
            return obj;
        case _$consts_291.tokens.ARRAY_START:
            var arr = [];
            for (;;) {
                var element = tokeniser.nextToken();
                if (element === null) {
                    throw new _$errors_280.InvalidDataError('Unexpected EOF (reading: array value)');
                }
                if (element.type === _$consts_291.tokens.ARRAY_END) {
                    break;
                }
                arr.push(decode(element, tokeniser));
            }
            return arr;
        case _$consts_291.tokens.STRING_START:
            var chunks = [];
            for (;;) {
                var chunk = tokeniser.nextToken();
                if (chunk === null) {
                    throw new _$errors_280.InvalidDataError('Unexpected EOF (reading: indefinite-length string');
                }
                if (chunk.type === _$consts_291.tokens.STRING_END) {
                    break;
                }
                if (chunk.header.type !== token.header.type) {
                    throw new _$errors_280.InvalidDataError('Unexpected chunk type (' + chunk.header.type + ') within string');
                }
                chunks.push(chunk.value);
            }
            switch (token.header.type) {
                case _$consts_291.types.BYTES:
                    return _$uint8array_762.concatUint8Arrays(chunks);
                case _$consts_291.types.STRING:
                    return chunks.join('');
                default:
                    throw new _$errors_280.InvalidDataError('Unexpected chunk type ('
                        + token.header.type + ') (reading: string)');
            }
        default:
            throw new _$errors_280.InvalidDataError('Unexpected token: ' + JSON.stringify(token));
    }
}
var Decoder =  (function () {
    function Decoder(initial, offset, length) {
        this.tokeniser = (_$uint8array_762.isUint8Array(initial)) ? new _$tokeniser_295.Tokeniser(initial, offset, length) : initial;
    }
    Decoder.prototype.hasRemaining = function () {
        return this.tokeniser.hasRemaining();
    };
    Decoder.prototype.nextValue = function () {
        return this.nextValueExpecting(isAny);
    };
    Decoder.prototype.nextValueExpecting = function (cborTypePredicate) {
        if (!this.tokeniser.hasRemaining()) {
            throw new _$errors_280.InvalidDataError('Token stream exhausted');
        }
        var token = this.tokeniser.nextToken();
        if (cborTypePredicate(token.header.type)) {
            return decode(token, this.tokeniser);
        }
        else {
            throw new _$errors_280.InvalidDataError('Unexpected CBOR type');
        }
    };
    return Decoder;
}());
_$decoder_293.Decoder = Decoder;
function isDouble(cborType) {
    return cborType === _$consts_291.types.FLOAT;
}
_$decoder_293.isDouble = isDouble;
function isInt64(cborType) {
    return cborType === _$consts_291.types.UINT ||
        cborType === _$consts_291.types.INT;
}
_$decoder_293.isInt64 = isInt64;
function isString(cborType) {
    return cborType === _$consts_291.types.STRING;
}
_$decoder_293.isString = isString;
function isAny() {
    return true;
}
 void isAny;

var _$encoder_294 = {};
"use strict";
var ____values_294 = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(_$encoder_294, "__esModule", { value: true });
_$encoder_294.Encoder = void 0;
;
;
;
;
var TWO_POW_32 = 4294967296;
var Encoder =  (function () {
    function Encoder() {
        this.bos = new _$bufferOutputStream_410.BufferOutputStream();
    }
    Encoder.prototype.writeByte = function (byte) {
        this.bos.write(byte);
    };
    Encoder.prototype.writeBuffer = function (buf, offset, length) {
        if (offset === void 0) { offset = 0; }
        if (length === void 0) { length = buf.length; }
        this.bos.writeMany(buf, offset, length);
    };
    Encoder.prototype.writeUint16 = function (val) {
        this.writeByte((val >> 8) & 0xff);
        this.writeByte(val & 0xff);
    };
    Encoder.prototype.writeUint32 = function (val) {
        this.writeUint16((val >> 16) & 0xffff);
        this.writeUint16(val & 0xffff);
    };
    Encoder.prototype.writeUint64 = function (val) {
        this.writeUint32(Math.floor(val / TWO_POW_32));
        this.writeUint32(val % TWO_POW_32);
    };
    Encoder.prototype.writeBreakHeader = function (type) {
        this.writeByte(type << 5 | _$consts_291.additional.BREAK);
    };
    Encoder.prototype.writeToken = function (type, val) {
        var first = type << 5;
        if (val < 24) {
            this.writeByte(first | val);
        }
        else if (val < 256) {
            this.writeByte(first | 24);
            this.writeByte(val);
        }
        else if (val < 65536) {
            this.writeByte(first | 25);
            this.writeUint16(val);
        }
        else if (val < TWO_POW_32) {
            this.writeByte(first | 26);
            this.writeUint32(val);
        }
        else {
            this.writeByte(first | 27);
            this.writeUint64(val);
        }
    };
    Encoder.prototype.writeNumber = function (val) {
        if (val.toString().indexOf('.') > -1) {
            var buf = _$uint8array_762.uint8FromDoubleBE(val);
            this.writeByte((_$consts_291.types.SIMPLE << 5) | _$consts_291.additional.DOUBLE_PRECISION);
            this.writeBuffer(buf);
        }
        else {
            if (val < 0) {
                this.writeToken(_$consts_291.types.INT, -1 - val);
            }
            else {
                this.writeToken(_$consts_291.types.UINT, val);
            }
        }
    };
    Encoder.prototype.writeString = function (val) {
        var buf = _$uint8array_762.uint8FromUtf8(val);
        this.writeToken(_$consts_291.types.STRING, buf.length);
        this.writeBuffer(buf);
    };
    Encoder.prototype.writeBinary = function (val, offset, length) {
        if (length === void 0) { length = val.length; }
        this.writeToken(_$consts_291.types.BYTES, length);
        this.writeBuffer(val, offset, length);
    };
    Encoder.prototype.writeBoolean = function (val) {
        this.writeToken(_$consts_291.types.SIMPLE, val ? _$consts_291.additional.TRUE : _$consts_291.additional.FALSE);
    };
    Encoder.prototype.writeUndefined = function () {
        this.writeToken(_$consts_291.types.SIMPLE, _$consts_291.additional.UNDEFINED);
    };
    Encoder.prototype.writeNull = function () {
        this.writeToken(_$consts_291.types.SIMPLE, _$consts_291.additional.NULL);
    };
    Encoder.prototype.writeObject = function (val) {
        var e_1, _a;
        var keys = Object.getOwnPropertyNames(val);
        this.startObject();
        try {
            for (var keys_1 = ____values_294(keys), keys_1_1 = keys_1.next(); !keys_1_1.done; keys_1_1 = keys_1.next()) {
                var key = keys_1_1.value;
                this.encode(key);
                this.encode(val[key]);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (keys_1_1 && !keys_1_1.done && (_a = keys_1.return)) _a.call(keys_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        this.break();
    };
    Encoder.prototype.writeArray = function (val) {
        var e_2, _a;
        this.startArray();
        try {
            for (var val_1 = ____values_294(val), val_1_1 = val_1.next(); !val_1_1.done; val_1_1 = val_1.next()) {
                var entry = val_1_1.value;
                this.encode(entry);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (val_1_1 && !val_1_1.done && (_a = val_1.return)) _a.call(val_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
        this.break();
    };
    Encoder.prototype.break = function () {
        this.writeBreakHeader(_$consts_291.types.SIMPLE);
        return this;
    };
    Encoder.prototype.startArray = function (length) {
        if (length === undefined) {
            this.writeBreakHeader(_$consts_291.types.ARRAY);
        }
        else {
            this.writeToken(_$consts_291.types.ARRAY, length);
        }
        return this;
    };
    Encoder.prototype.startObject = function (length) {
        if (length === undefined) {
            this.writeBreakHeader(_$consts_291.types.MAP);
        }
        else {
            this.writeToken(_$consts_291.types.MAP, length);
        }
        return this;
    };
    Encoder.prototype.writeInt64 = function (val) {
        var high = val.getHighBits() | 0;
        if (high === 0 || high === -1) {
            this.writeNumber(val.toNumber());
        }
        else {
            if (val.isNegative()) {
                this.writeByte((_$consts_291.types.INT << 5) | 27);
                var buf = Uint8Array.from(val.toBuffer());
                for (var i = 0; i < 8; ++i) {
                    buf[i] = ~buf[i];
                }
                this.writeBuffer(buf);
            }
            else {
                this.writeByte((_$consts_291.types.UINT << 5) | 27);
                this.writeBuffer(val.toBuffer());
            }
        }
        return this;
    };
    Encoder.prototype.writeDouble = function (val) {
        var buf = _$uint8array_762.uint8FromDoubleBE(val);
        this.writeByte((_$consts_291.types.SIMPLE << 5) | _$consts_291.additional.DOUBLE_PRECISION);
        this.writeBuffer(buf);
        return this;
    };
    Encoder.prototype.encode = function (value, offset, length) {
        if (value instanceof Date) {
            this.writeString(value.toJSON());
        }
        else if (value === null) {
            this.writeNull();
        }
        else if (value === undefined) {
            this.writeUndefined();
        }
        else if (value instanceof _$int64Impl_334.Int64Impl) {
            this.writeInt64(value);
        }
        else {
            switch (typeof value) {
                case 'boolean':
                    this.writeBoolean(value);
                    break;
                case 'string':
                    this.writeString(value);
                    break;
                case 'number':
                    this.writeNumber(value);
                    break;
                case 'object':
                    if (_$uint8array_762.isUint8Array(value)) {
                        this.writeBinary(value, offset, length);
                    }
                    else if (Array.isArray(value)) {
                        this.writeArray(value);
                    }
                    else {
                        this.writeObject(value);
                    }
            }
        }
        return this;
    };
    Encoder.prototype.flush = function () {
        var res = this.bos.getBuffer();
        this.bos = new _$bufferOutputStream_410.BufferOutputStream();
        return res;
    };
    return Encoder;
}());
_$encoder_294.Encoder = Encoder;

var _$math_753 = {};
"use strict";
Object.defineProperty(_$math_753, "__esModule", { value: true });
_$math_753.MIN_SAFE_INTEGER = _$math_753.MAX_SAFE_INTEGER = _$math_753.MAX_INT32 = _$math_753.findNextPowerOfTwo = _$math_753.approximateSquareRoot = void 0;
;
function leadingZeros(i) {
    if (i === 0) {
        return 32;
    }
    var n = 1;
    if (i >>> 16 === 0) {
        n += 16;
        i <<= 16;
    }
    if (i >>> 24 === 0) {
        n += 8;
        i <<= 8;
    }
    if (i >>> 28 === 0) {
        n += 4;
        i <<= 4;
    }
    if (i >>> 30 === 0) {
        n += 2;
        i <<= 2;
    }
    n -= i >>> 31;
    return n;
}
function approximateSquareRoot(value) {
    if (value < 0) {
        throw new _$errors_280.IllegalArgumentError('Value must be great or equal to 0');
    }
    if (value === 0) {
        return 0;
    }
    var h = 32 - leadingZeros(value);
    return 1 << Math.round(h / 2);
}
_$math_753.approximateSquareRoot = approximateSquareRoot;
function findNextPowerOfTwo(value) {
    if (value < 0 || value > 1 << 30) {
        throw new _$errors_280.IllegalArgumentError('Illegal argument: ' + value);
    }
    value--;
    value |= value >> 1;
    value |= value >> 2;
    value |= value >> 4;
    value |= value >> 8;
    value |= value >> 16;
    value++;
    return value;
}
_$math_753.findNextPowerOfTwo = findNextPowerOfTwo;
_$math_753.MAX_INT32 = 2147483647;
_$math_753.MAX_SAFE_INTEGER = 9007199254740991;
_$math_753.MIN_SAFE_INTEGER = -9007199254740991;

var _$myersBinaryDiff_325 = {};
"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(_$myersBinaryDiff_325, "__esModule", { value: true });
_$myersBinaryDiff_325.MyersBinaryDiff =                 _$myersBinaryDiff_325.NO_CHANGE = _$myersBinaryDiff_325.REPLACE = _$myersBinaryDiff_325.SUCCESS = void 0;
;
;
var BAIL_OUT_FACTOR = 10000;
var MAXIMUM_STORAGE = 0x7fffffff;
_$myersBinaryDiff_325.SUCCESS = 0;
_$myersBinaryDiff_325.REPLACE = 1;
_$myersBinaryDiff_325.NO_CHANGE = 2;
var Storage =  (function () {
    function Storage(max) {
        this.maximumD = (max - 3) / 4;
        this.vectorLength = 0;
        this.vector = [];
    }
    Storage.prototype.fill = function (start) {
        for (var i = start; i < this.vectorLength + 4; i += 4) {
            this.vector[i + 0] = -1;
            this.vector[i + 1] = -1;
            this.vector[i + 2] = 0x7fffffff;
            this.vector[i + 3] = 0x7fffffff;
        }
    };
    Storage.prototype.ensure = function (d) {
        this.vectorLength = 4 * (d + 1) + 3;
    };
    Storage.prototype.initialise = function (d) {
        this.ensure(d);
        this.fill(3);
        return this.vector;
    };
    Storage.prototype.extend = function (d) {
        if (d > this.maximumD) {
            return null;
        }
        var originalLength = this.vectorLength;
        this.ensure(d);
        this.fill(originalLength);
        return this.vector;
    };
    return Storage;
}());
 void Storage;
function keyF(k) {
    return k < 0 ? -4 * k - 1 : 4 * k;
}
 void keyF;
function keyR(k) {
    return keyF(k) + 2;
}
 void keyR;
function getF(v, k) {
    var i = v[keyF(k)];
    return i === undefined ? 0 : i;
}
 void getF;
function getR(v, k) {
    var i = v[keyR(k)];
    return i === undefined ? 0 : i;
}
 void getR;
function setF(v, k, i) {
    v[keyF(k)] = i;
}
 void setF;
function setR(v, k, i) {
    var key = keyR(k);
    v[key] = i;
}
 void setR;
function nextF(v, k) {
    var left = getF(v, k + 1);
    var right = getF(v, k - 1);
    return left < right ? right : left + 1;
}
 void nextF;
function nextR(v, k) {
    var left = getR(v, k + 1);
    var right = getR(v, k - 1);
    return left < right ? left : right - 1;
}
 void nextR;
function corner(d, length) {
    if (d <= length) {
        return d;
    }
    else {
        return 2 * length - d;
    }
}
 void corner;
function checkBounds(buffer, offset, length) {
    if (offset < 0) {
        throw new _$errors_280.InternalError("offset " + offset + " < 0");
    }
    if (length < 0) {
        throw new _$errors_280.InternalError("length " + length + " < 0");
    }
    if (offset + length > buffer.length || offset + length < 0) {
        throw new _$errors_280.InternalError("offset " + offset + " + " + length + " > " + buffer.length);
    }
}
 void checkBounds;
var Execution =  (function () {
    function Execution(storage, a, b, script, bailOutFactor) {
        this.storage = storage;
        this.a = a;
        this.b = b;
        this.script = script;
        this.bailOutFactor = bailOutFactor;
    }
    Execution.prototype.diff = function (aOffset, aLength, bOffset, bLength, limit) {
        if (limit === void 0) { limit = this.bailOutFactor; }
        checkBounds(this.a, aOffset, aLength);
        checkBounds(this.b, bOffset, bLength);
        var p = this.afterCommonPrefix(aOffset, aLength, bOffset, bLength);
        var u = this.beforeCommonSuffix(aOffset, aLength, bOffset, bLength, p);
        var v = u + bLength - aLength;
        if (!this.script.match(aOffset, p) ) {
            return false;
        }
        var result;
        if (p === u) {
            result = this.script.insert(bOffset + p, v - p);
        }
        else if (p === v) {
            result = this.script.delete();
        }
        else {
            result = this.middleSnake(aOffset + p, u - p, bOffset + p, v - p, limit);
        }
        return result && this.script.match(aOffset + u, aLength - u); 
    };
    Execution.prototype.afterCommonPrefix = function (aoff, n, boff, m) {
        var end = Math.min(n, m);
        for (var p = 0; p < end; ++p) {
            if (this.a[aoff + p] !== this.b[boff + p]) {
                return p;
            }
        }
        return Math.max(0, end);
    };
    Execution.prototype.beforeCommonSuffix = function (aoff, aLength, boff, bLength, limit) {
        var end = Math.max(0, aLength - bLength) + limit;
        for (var u = aLength; u > end; --u) {
            if (this.a[aoff + u - 1] !== this.b[boff + u + bLength - aLength - 1]) {
                return u;
            }
        }
        return Math.min(aLength, end);
    };
    Execution.prototype.diffNoPrefix = function (aoff, aLength, boff, bLength, limit) {
        if (limit === void 0) { limit = this.bailOutFactor; }
        var u = this.beforeCommonSuffix(aoff, aLength, boff, bLength, 0);
        var v = u + bLength - aLength;
        var r;
        if (0 === u) {
            r = this.script.insert(boff, v);
        }
        else if (0 === v) {
            r = this.script.delete();
        }
        else {
            r = this.middleSnake(aoff, u, boff, v, limit);
        }
        return r && this.script.match(aoff + u, aLength - u); 
    };
    Execution.prototype.diffNoSuffix = function (aoff, aLength, boff, bLength, limit) {
        if (limit === void 0) { limit = this.bailOutFactor; }
        var p = this.afterCommonPrefix(aoff, aLength, boff, bLength);
        if (!this.script.match(aoff, p) ) {
            return false;
        }
        if (p === aLength) {
            return this.script.insert(boff + p, bLength - p);
        }
        else if (p === bLength) {
            return this.script.delete();
        }
        else {
            return this.middleSnake(aoff + p, aLength - p, boff + p, bLength - p, limit);
        }
    };
    Execution.prototype.middleSnake = function (aOffset, aLength, bOffset, bLength, initialLimit) {
        var delta = aLength - bLength;
        var odd = delta & 1;
        var vec = this.storage.initialise(1);
        setF(vec, 0, 0);
        setR(vec, 0, aLength);
        var d = 1;
        var limit = initialLimit;
        do {
            var cornerA = corner(d, aLength);
            var cornerB = corner(d, bLength);
            for (var k1 = -cornerA; k1 <= cornerB; k1 += 2) {
                var x1 = nextF(vec, k1);
                var u1 = x1 + this.afterCommonPrefix(aOffset + x1, aLength - x1, bOffset + x1 + k1, bLength - k1 - x1);
                if (odd && Math.abs(k1 + delta) <= d - 1 && u1 >= getR(vec, k1 + delta)) {
                    return this.recurse(aOffset, aLength, bOffset, bLength, x1, u1, k1);
                }
                setF(vec, k1, u1);
            }
            for (var k2 = -cornerB; k2 <= cornerA; k2 += 2) {
                var u2 = nextR(vec, k2);
                var kd = k2 - delta;
                var x2 = this.beforeCommonSuffix(aOffset, u2, bOffset, kd + u2, 0);
                if (!odd && Math.abs(kd) <= d && x2 <= getF(vec, kd)) {
                    return this.recurse(aOffset, aLength, bOffset, bLength, x2, u2, kd);
                }
                setR(vec, k2, x2);
            }
            if ((d & 0x3f) === 0 && this.slowProgress(vec, aLength, bLength, cornerA, cornerB, d)) {
                limit -= 0x30;
            }
            else if (d > Math.max(4, limit)) {
                return this.bail(vec, aOffset, aLength, bOffset, bLength, cornerA, cornerB, Math.trunc(limit / 2));
            }
            ++d;
            vec = this.storage.extend(d);
        } while (vec !== null);
        return false;
    };
    Execution.prototype.slowProgress = function (vec, aLength, bLength, cornerA, cornerB, d) {
        var _a = __read(this.bestForward(vec, aLength, bLength, cornerA, cornerB), 2), xforward = _a[0], yforward = _a[1];
        var _b = __read(this.bestReverse(vec, aLength, bLength, cornerA, cornerB), 2), xreverse = _b[0], yreverse = _b[1];
        var fbest = xforward + yforward;
        var rbest = aLength + bLength - xreverse - yreverse;
        var progress = fbest + rbest;
        return progress < _$math_753.approximateSquareRoot(d) * d;
    };
    Execution.prototype.bestForward = function (vec, aLength, bLength, cornerA, cornerB) {
        var xforward = 0;
        var yforward = 0;
        for (var k = -cornerA; k <= cornerB; k += 2) {
            var x = Math.min(getF(vec, k), aLength, bLength - k);
            var y = x + k;
            if (x + y > xforward + yforward) {
                xforward = x;
                yforward = y;
            }
        }
        return [xforward, yforward];
    };
    Execution.prototype.bestReverse = function (vec, aLength, bLength, cornerA, cornerB) {
        var xreverse = aLength;
        var yreverse = bLength;
        for (var k = -cornerB; k <= cornerA; k += 2) {
            var kd = k - (aLength - bLength);
            var x = Math.max(getR(vec, k), 0, -kd);
            var y = x + kd;
            if (x + y < xreverse + yreverse) {
                xreverse = x;
                yreverse = y;
            }
        }
        return [xreverse, yreverse];
    };
    Execution.prototype.recurse = function (aOffset, aLength, bOffset, bLength, x, u, k) {
        return this.diffNoPrefix(aOffset, x, bOffset, x + k)
            && this.script.match(aOffset + x, u - x)
            && this.diffNoSuffix(aOffset + u, aLength - u, bOffset + u + k, bLength - u - k);
    };
    Execution.prototype.bail = function (vec, aOffset, aLength, bOffset, bLength, cornerA, cornerB, limit) {
        var _a = __read(this.bestForward(vec, aLength, bLength, cornerA, cornerB), 2), xforward = _a[0], yforward = _a[1];
        var _b = __read(this.bestReverse(vec, aLength, bLength, cornerA, cornerB), 2), xreverse = _b[0], yreverse = _b[1];
        if (xforward >= xreverse || yforward >= yreverse) {
            if (aLength + bLength - xreverse - yreverse > xforward + yforward) {
                return this.splitDiff(aOffset, xreverse, aLength, bOffset, yreverse, bLength);
            }
            else {
                return this.splitDiff(aOffset, xforward, aLength, bOffset, yforward, bLength);
            }
        }
        else {
            return this.diffNoPrefix(aOffset, xforward, bOffset, yforward)
                && this.boundedDiff(aOffset + xforward, xreverse - xforward, bOffset + yforward, yreverse - yforward, aLength, bLength, limit)
                && this.diffNoSuffix(aOffset + xreverse, aLength - xreverse, bOffset + yreverse, bLength - yreverse);
        }
    };
    Execution.prototype.boundedDiff = function (aOffset, aLength, bOffset, bLength, totalN, totalM, limit) {
        var totalSpace = totalN * totalM;
        var nm = aLength * bLength;
        var threshold = Math.floor((1 << 24) + totalSpace / 2);
        if (nm >= threshold) {
            if (limit <= 0) {
                var n0 = Math.trunc(aLength / 4);
                var n1 = n0 + Math.trunc(aLength / 2);
                var m0 = Math.trunc(bLength / 4);
                var m1 = m0 + Math.trunc(bLength / 2);
                return this.noDiff(bOffset, m0) &&
                    this.diff(aOffset + n0, n1 - n0, bOffset + m0, m1 - m0, limit) &&
                    this.noDiff(bOffset + m1, bLength - m1);
            }
            var x = Math.trunc(aLength / 2);
            var y = Math.trunc(bLength / 2);
            return this.splitDiff(aOffset, x, aLength, bOffset, y, bLength, limit);
        }
        else {
            return this.middleSnake(aOffset, aLength, bOffset, bLength, limit);
        }
    };
    Execution.prototype.splitDiff = function (aOffset, n1, n2, bOffset, m1, m2, limit) {
        return this.diffNoPrefix(aOffset, n1, bOffset, m1, limit)
            && this.diffNoSuffix(aOffset + n1, n2 - n1, bOffset + m1, m2 - m1, limit);
    };
    Execution.prototype.noDiff = function (bOffset, bLength) {
        return this.script.insert(bOffset, bLength) && this.script.delete();
    };
    return Execution;
}());
 void Execution;
function INSERT(script, start, length) {
    return script.insert(start, length);
}
 void INSERT;
function MATCH(script, start, length) {
    return script.match(start, length);
}
 void MATCH;
function NOOP() {
    return true;
}
 void NOOP;
function coalesce(delegate, aOffset, bOffset) {
    var neverFlushed = true;
    var pendingLength = 0;
    var pendingStart = 0;
    var pending = NOOP;
    function flushPending() {
        neverFlushed = neverFlushed && (pending === NOOP);
        return pending(delegate, pendingStart, pendingLength);
    }
    function process(op, start, length) {
        if (length > 0) {
            if (pending !== op) {
                if (!flushPending()) {
                    return false;
                }
                pending = op;
                pendingStart = start;
                pendingLength = length;
            }
            else {
                pendingLength += length;
            }
        }
        return true;
    }
    return {
        insert: function (bStart, length) {
            return process(INSERT, bStart - bOffset, length);
        },
        match: function (aStart, length) {
            return process(MATCH, aStart - aOffset, length);
        },
        delete: function (aStart, length) {
            if (pending === INSERT) {
                return true;
            }
            var r = flushPending();
            pending = NOOP;
            return r;
        },
        close: function (aLength, bLength) {
            if (neverFlushed) {
                if (pending === INSERT) {
                    return _$myersBinaryDiff_325.REPLACE;
                }
                else if (pendingStart === 0 && pendingLength === aLength) {
                    return _$myersBinaryDiff_325.NO_CHANGE;
                }
            }
            return flushPending() && delegate.close() ? _$myersBinaryDiff_325.SUCCESS : _$myersBinaryDiff_325.REPLACE;
        }
    };
}
 void coalesce;
var MyersBinaryDiff =  (function () {
    function MyersBinaryDiff(maximumStorage, bailOutFactor) {
        if (maximumStorage === void 0) { maximumStorage = MAXIMUM_STORAGE; }
        if (bailOutFactor === void 0) { bailOutFactor = BAIL_OUT_FACTOR; }
        this.bailOutFactor = bailOutFactor;
        this.storage = new Storage(maximumStorage);
    }
    MyersBinaryDiff.prototype.diff = function (a, aOffset, aLength, b, bOffset, bLength, editScript) {
        var script = coalesce(editScript, aOffset, bOffset);
        var execution = new Execution(this.storage, a, b, script, this.bailOutFactor);
        if (!execution.diff(aOffset, aLength, bOffset, bLength)) {
            return _$myersBinaryDiff_325.REPLACE;
        }
        return script.close(aLength, bLength);
    };
    return MyersBinaryDiff;
}());
_$myersBinaryDiff_325.MyersBinaryDiff = MyersBinaryDiff;

var _$binaryDeltaTypeImpl_320 = {};
(function (Buffer){(function (){
"use strict";
Object.defineProperty(_$binaryDeltaTypeImpl_320, "__esModule", { value: true });
_$binaryDeltaTypeImpl_320.BinaryDeltaTypeImpl = _$binaryDeltaTypeImpl_320.NO_CHANGE = void 0;
;
;
;
;
;
;
var encoder = new _$encoder_294.Encoder();
_$binaryDeltaTypeImpl_320.NO_CHANGE = new _$binaryDeltaImpl_319.BinaryDeltaImpl(Uint8Array.from([-10]), 0, 1);
function replace(value) {
    encoder.encode(value.$buffer, value.$offset, value.$length);
    return new _$binaryDeltaImpl_319.BinaryDeltaImpl(encoder.flush());
}
function cborCost(i) {
    if (i < 24) {
        return 1;
    }
    else if (i < 0xFF) {
        return 2;
    }
    else if (i <= 0xFFFF) {
        return 3;
    }
    return 5;
}
function conflatableMatch(matchStart, matchLength, insertLength) {
    var matchCost = cborCost(matchStart) + 1;
    var insertCost = cborCost(matchLength + insertLength) - cborCost(insertLength) + matchLength;
    return insertCost <= matchCost;
}
var BinaryDeltaScript =  (function () {
    function BinaryDeltaScript(cborEncoder, buffer, offset, blowsBudget) {
        this.insertStart = -1;
        this.matchStart = -1;
        this.cborEncoder = cborEncoder;
        this.buffer = buffer;
        this.offset = offset;
        this.blowsBudget = blowsBudget;
    }
    BinaryDeltaScript.prototype.insert = function (bStart, length) {
        if (this.matchStart !== -1) {
            if (conflatableMatch(this.matchStart, this.matchLength, length)) {
                this.matchStart = -1;
                if (this.insertStart === -1) {
                    this.insertStart = bStart - this.matchLength;
                    this.insertLength = this.matchLength + length;
                }
                else {
                    this.insertLength += this.matchLength + length;
                }
                return true;
            }
            if (!this.flush()) {
                return false;
            }
        }
        if (this.insertStart === -1) {
            this.insertStart = bStart;
            this.insertLength = length;
        }
        else {
            this.insertLength += length;
        }
        return true;
    };
    BinaryDeltaScript.prototype.match = function (aStart, length) {
        if (this.matchStart !== -1) {
            if (!this.flush()) {
                return false;
            }
        }
        else if (this.insertStart !== -1 &&
            conflatableMatch(aStart, length, this.insertLength)) {
            this.insertLength += length;
            return true;
        }
        this.matchStart = aStart;
        this.matchLength = length;
        return true;
    };
    BinaryDeltaScript.prototype.delete = function (aStart, length) {
        return true;
    };
    BinaryDeltaScript.prototype.close = function () {
        return this.flush();
    };
    BinaryDeltaScript.prototype.flush = function () {
        return (this.insertStart === -1 || this.writeInsert())
            && (this.matchStart === -1 || this.writeMatch());
    };
    BinaryDeltaScript.prototype.writeInsert = function () {
        if (this.blowsBudget(this.insertLength + cborCost(this.insertLength))) {
            return false;
        }
        encoder.encode(this.buffer, this.offset + this.insertStart, this.insertLength);
        this.insertStart = -1;
        return true;
    };
    BinaryDeltaScript.prototype.writeMatch = function () {
        if (this.blowsBudget(cborCost(this.matchStart) + cborCost(this.matchLength))) {
            return false;
        }
        this.cborEncoder.encode(this.matchStart);
        this.cborEncoder.encode(this.matchLength);
        this.matchStart = -1;
        return true;
    };
    return BinaryDeltaScript;
}());
var BinaryDeltaTypeImpl =  (function () {
    function BinaryDeltaTypeImpl(implementation, vToC, cToV) {
        this.binaryDiff = new _$myersBinaryDiff_325.MyersBinaryDiff();
        this.implementation = implementation;
        this.cToV = cToV;
        this.vToC = vToC;
    }
    BinaryDeltaTypeImpl.prototype.name = function () {
        return 'binary';
    };
    BinaryDeltaTypeImpl.prototype.diff = function (oldValueObj, newValueObj) {
        var oldValue = this.vToC(oldValueObj);
        var newValue = this.vToC(newValueObj);
        var buffer = newValue.$buffer;
        var offset = newValue.$offset;
        var length = newValue.$length;
        var budget = length;
        var script = new BinaryDeltaScript(encoder, buffer, offset, function (cost) { return ((budget -= cost) <= 0); });
        var result = this.binaryDiff.diff(oldValue.$buffer, oldValue.$offset, oldValue.$length, buffer, offset, length, script);
        var delta = encoder.flush();
        switch (result) {
            case _$myersBinaryDiff_325.REPLACE:
                return replace(newValue);
            case _$myersBinaryDiff_325.NO_CHANGE:
                return _$binaryDeltaTypeImpl_320.NO_CHANGE;
            default:
                return this.readDelta(delta);
        }
    };
    BinaryDeltaTypeImpl.prototype.apply = function (oldValueObj, delta) {
        return this.applyImpl(oldValueObj, delta).value;
    };
    BinaryDeltaTypeImpl.prototype.applyImpl = function (oldValueObj, delta, oldBuffer) {
        var deltaImpl = delta;
        var oldValue = oldBuffer || this.vToC(oldValueObj);
        if (!delta || !delta.hasChanges()) {
            return {
                value: this.cToV(oldValue),
                cbor: oldValue
            };
        }
        var decoder = new _$decoder_293.Decoder(deltaImpl.$buffer);
        var bos = new _$bufferOutputStream_410.BufferOutputStream();
        while (decoder.hasRemaining()) {
            var start = decoder.nextValue();
            if (_$uint8array_762.isUint8Array(start)) {
                bos.writeMany(start);
            }
            else if (typeof start === 'number') {
                bos.writeMany(oldValue.$buffer, oldValue.$offset + start, decoder.nextValue());
            }
        }
        var impl = new this.implementation(bos.getBuffer());
        return {
            value: this.cToV(impl),
            cbor: impl
        };
    };
    BinaryDeltaTypeImpl.prototype.readDelta = function (buffer, offset, length) {
        var delta = new _$binaryDeltaImpl_319.BinaryDeltaImpl(buffer, offset, length);
        if (delta.$length === 1 && buffer[delta.$offset] === _$binaryDeltaTypeImpl_320.NO_CHANGE.$buffer[0]) {
            return _$binaryDeltaTypeImpl_320.NO_CHANGE;
        }
        return delta;
    };
    BinaryDeltaTypeImpl.prototype.writeDelta = function (delta) {
        return Buffer.from(this.writeDeltaToArray(delta).buffer);
    };
    BinaryDeltaTypeImpl.prototype.writeDeltaToArray = function (delta) {
        var deltaImpl = delta;
        return deltaImpl.$buffer.subarray(deltaImpl.$offset, deltaImpl.$offset + deltaImpl.$length);
    };
    BinaryDeltaTypeImpl.prototype.noChange = function () {
        return _$binaryDeltaTypeImpl_320.NO_CHANGE;
    };
    BinaryDeltaTypeImpl.prototype.isValueCheaper = function (value, delta) {
        return value.$length <= delta.$length;
    };
    return BinaryDeltaTypeImpl;
}());
_$binaryDeltaTypeImpl_320.BinaryDeltaTypeImpl = BinaryDeltaTypeImpl;

}).call(this)}).call(this,_$buffer_3({}).Buffer)
var _$bytesImpl_323 = {};
(function (Buffer){(function (){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$bytesImpl_323, "__esModule", { value: true });
_$bytesImpl_323.BytesImpl = void 0;
;
var BytesImpl =  (function (_super) {
    __extends(BytesImpl, _super);
    function BytesImpl(buffer, offset, length) {
        if (offset === void 0) { offset = 0; }
        if (length === void 0) { length = buffer.length; }
        return _super.call(this, buffer, offset, length) || this;
    }
    BytesImpl.toString = function () {
        return 'BytesImpl';
    };
    BytesImpl.prototype.length = function () {
        return this.$length;
    };
    BytesImpl.prototype.asBuffer = function () {
        return Buffer.from(this.asArray());
    };
    BytesImpl.prototype.asArray = function () {
        return this.$buffer.subarray(this.$offset, this.$offset + this.$length);
    };
    BytesImpl.prototype.copyTo = function (target, offset) {
        if (offset === void 0) { offset = 0; }
        target.set(this.$buffer.subarray(this.$offset, this.$offset + this.$length), offset);
    };
    BytesImpl.prototype.equals = function (bytes) {
        return this.equalBytes(bytes.$buffer, bytes.$offset, bytes.$length);
    };
    BytesImpl.prototype.equalBytes = function (buffer, offset, length) {
        if (offset === void 0) { offset = 0; }
        if (length === void 0) { length = buffer.length; }
        if (this.$length !== length) {
            return false;
        }
        if (this.$buffer === buffer && this.$offset === offset) {
            return true;
        }
        for (var i = 0; i < length; ++i) {
            if (this.$buffer[this.$offset + i] !== buffer[offset + i]) {
                return false;
            }
        }
        return true;
    };
    return BytesImpl;
}(_$bufferSlice_322.BufferSlice));
_$bytesImpl_323.BytesImpl = BytesImpl;

}).call(this)}).call(this,_$buffer_3({}).Buffer)
var _$abstractDatatype_316 = {};
(function (Buffer){(function (){
"use strict";
Object.defineProperty(_$abstractDatatype_316, "__esModule", { value: true });
_$abstractDatatype_316.AbstractDataType = void 0;
;
;
;
;
;
var AbstractDataType =  (function () {
    function AbstractDataType(typeName, valueClass, implementation, vToC, cToV, converters, withBinaryDelta) {
        var _this = this;
        this.valueConverters = {};
        this.typeName = typeName;
        this.cToV = cToV;
        this.vToC = vToC;
        this.implementation = implementation;
        converters.forEach(function (converter) {
            _this.valueConverters[converter.name] = converter.convert;
        });
        this.valueConverters[_$bytesImpl_323.BytesImpl.toString()] = function (buffer, offset, length) {
            return new _$bytesImpl_323.BytesImpl(buffer, offset, length);
        };
        this.valueConverters[valueClass.toString()] = this.readValue.bind(this);
        this.valueConverters[_$anyDatatype_317.AnyDataTypeImpl.toString()] = this.readValue.bind(this);
        this.valueClass = valueClass;
        if (withBinaryDelta) {
            this.binaryDeltaTypeImpl
                = new _$binaryDeltaTypeImpl_320.BinaryDeltaTypeImpl(implementation, vToC, cToV);
        }
    }
    AbstractDataType.prototype.name = function () {
        return this.typeName;
    };
    AbstractDataType.prototype.toString = function () {
        return this.typeName + " data type";
    };
    AbstractDataType.prototype.writeValue = function (value) {
        return Buffer.from(this.writeValueToArray(value));
    };
    AbstractDataType.prototype.writeValueToArray = function (value) {
        var internal = this.vToC(value);
        if (internal === null) {
            throw new _$errors_280.IllegalArgumentError(this + " cannot write " + value);
        }
        return internal.asArray();
    };
    AbstractDataType.prototype.toBytes = function (value) {
        var bytes = this.vToC(value);
        if (bytes) {
            return bytes;
        }
        throw new _$errors_280.IllegalArgumentError(this + " cannot convert value to Bytes: " + value);
    };
    AbstractDataType.prototype.readValue = function (buffer, offset, length) {
        if (buffer instanceof _$bytesImpl_323.BytesImpl) {
            if (buffer instanceof this.implementation) {
                return this.cToV(buffer);
            }
            return this.readValue(buffer.$buffer, buffer.$offset, buffer.$length);
        }
        return this.cToV(new this.implementation(buffer, offset, length));
    };
    AbstractDataType.prototype.canReadAs = function (valueClass) {
        return this.valueConverters[valueClass.toString()] !== undefined;
    };
    AbstractDataType.prototype.readAs = function (valueClass, buffer, offset, length) {
        if (buffer instanceof _$bytesImpl_323.BytesImpl) {
            return this.readAs(valueClass, buffer.$buffer, buffer.$offset, buffer.$length);
        }
        if (this.valueConverters[valueClass.toString()]) {
            return this.valueConverters[valueClass.toString()](buffer, offset, length);
        }
        throw new _$errors_280.IllegalArgumentError(this + " is incompatible with values of " + valueClass);
    };
    AbstractDataType.prototype.deltaType = function (name) {
        if (!name || name === 'binary' || name instanceof _$binaryDeltaImpl_319.BinaryDeltaImpl) {
            return this.binaryDeltaType();
        }
        throw new _$errors_280.IllegalArgumentError(this + " has no '" + name + "' delta type");
    };
    AbstractDataType.prototype.binaryDeltaType = function () {
        if (this.binaryDeltaTypeImpl === undefined) {
            throw new _$errors_280.IllegalArgumentError(this + " has no binary delta type");
        }
        return this.binaryDeltaTypeImpl;
    };
    return AbstractDataType;
}());
_$abstractDatatype_316.AbstractDataType = AbstractDataType;

}).call(this)}).call(this,_$buffer_3({}).Buffer)
var _$function_750 = {};
"use strict";
Object.defineProperty(_$function_750, "__esModule", { value: true });
_$function_750.identity = _$function_750.callWithArguments = _$function_750.curryR = void 0;
function curryR(fn) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    return function () {
        var leftArgs = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            leftArgs[_i] = arguments[_i];
        }
        return callWithArguments(fn, leftArgs.concat(args));
    };
}
_$function_750.curryR = curryR;
function callWithArguments(fn, args) {
    switch (args.length) {
        case 0:
            return fn();
        case 1:
            return fn(args[0]);
        case 2:
            return fn(args[0], args[1]);
        case 3:
            return fn(args[0], args[1], args[2]);
        case 4:
            return fn(args[0], args[1], args[2], args[3]);
        case 5:
            return fn(args[0], args[1], args[2], args[3], args[4]);
        case 6:
            return fn(args[0], args[1], args[2], args[3], args[4], args[5]);
        case 7:
            return fn(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
        case 8:
            return fn(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);
    }
    return fn.apply(fn, args);
}
_$function_750.callWithArguments = callWithArguments;
function identity(val) {
    return val;
}
_$function_750.identity = identity;

var _$binaryImpl_321 = {};
(function (Buffer){(function (){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$binaryImpl_321, "__esModule", { value: true });
_$binaryImpl_321.BinaryImpl = void 0;
;
;
;
;
;
function fromValue(value) {
    if (value instanceof BinaryImpl) {
        return value;
    }
    else if (_$uint8array_762.isUint8Array(value)) {
        return new BinaryImpl(value);
    }
    else {
        throw new _$errors_280.IllegalArgumentError("Unable to read Binary value from: " + value);
    }
}
var BinaryImpl =  (function (_super) {
    __extends(BinaryImpl, _super);
    function BinaryImpl(buffer, offset, length) {
        if (offset === void 0) { offset = 0; }
        if (length === void 0) { length = buffer.length; }
        return _super.call(this, buffer, offset, length) || this;
    }
    BinaryImpl.toString = function () {
        return 'BinaryImpl';
    };
    BinaryImpl.from = function (value) {
        return fromValue(value);
    };
    BinaryImpl.prototype.get = function () {
        return Buffer.from(this.getArray());
    };
    BinaryImpl.prototype.getArray = function () {
        return this.asArray();
    };
    BinaryImpl.prototype.diff = function (original, type) {
        return BINARY_DELTA_TYPE.diff(original, this);
    };
    BinaryImpl.prototype.apply = function (delta) {
        return BINARY_DELTA_TYPE.apply(this, delta);
    };
    BinaryImpl.prototype.toString = function () {
        return "Binary <" + this.$length + " bytes> " + _$uint8array_762.uint8toUtf8(this.getArray());
    };
    return BinaryImpl;
}(_$bytesImpl_323.BytesImpl));
_$binaryImpl_321.BinaryImpl = BinaryImpl;
var BINARY_DELTA_TYPE = new _$binaryDeltaTypeImpl_320.BinaryDeltaTypeImpl(BinaryImpl, fromValue, _$function_750.identity);

}).call(this)}).call(this,_$buffer_3({}).Buffer)
var _$binaryDatatypeImpl_318 = {};
"use strict";
var ____extends_318 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$binaryDatatypeImpl_318, "__esModule", { value: true });
_$binaryDatatypeImpl_318.BinaryDataTypeImpl = void 0;
;
;
;
var BinaryDataTypeImpl =  (function (_super) {
    ____extends_318(BinaryDataTypeImpl, _super);
    function BinaryDataTypeImpl() {
        var _this = _super.call(this, 'binary', _$binaryImpl_321.BinaryImpl, _$binaryImpl_321.BinaryImpl, _$binaryImpl_321.BinaryImpl.from, _$function_750.identity, [], true) || this;
        _this.Binary = _$binaryImpl_321.BinaryImpl;
        return _this;
    }
    BinaryDataTypeImpl.prototype.from = function (buffer) {
        return _$binaryImpl_321.BinaryImpl.from(buffer);
    };
    BinaryDataTypeImpl.prototype.validate = function () {
    };
    return BinaryDataTypeImpl;
}(_$abstractDatatype_316.AbstractDataType));
_$binaryDatatypeImpl_318.BinaryDataTypeImpl = BinaryDataTypeImpl;

var _$jsonPointer_330 = {};
"use strict";
var ____values_330 = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(_$jsonPointer_330, "__esModule", { value: true });
_$jsonPointer_330.ROOT = _$jsonPointer_330.JSONPointer =   void 0;
;
;
var IndexSegment =  (function () {
    function IndexSegment(index) {
        this.index = index;
    }
    IndexSegment.prototype.equals = function (other) {
        if (other === this) {
            return true;
        }
        if (!other || !(other instanceof IndexSegment)) {
            return false;
        }
        return other.index === this.index;
    };
    IndexSegment.prototype.toString = function () {
        return '/' + this.index;
    };
    return IndexSegment;
}());
 void IndexSegment;
var INDEX0 = new IndexSegment(0);
var KeySegment =  (function () {
    function KeySegment(key) {
        this.expression = '/' + escapeKey(key);
    }
    KeySegment.prototype.equals = function (other) {
        if (other === this) {
            return true;
        }
        if (!other || !(other instanceof KeySegment)) {
            return false;
        }
        return other.expression === this.expression;
    };
    KeySegment.prototype.toString = function () {
        return this.expression;
    };
    return KeySegment;
}());
 void KeySegment;
var Parser =  (function () {
    function Parser(expression) {
        this.pos = 0;
        if (expression !== '' && expression.charAt(0) !== '/') {
            throw new _$errors_280.IllegalArgumentError('JSON Pointer expression must be empty or start with \'/\' : ' + expression);
        }
        this.expression = expression;
    }
    Parser.prototype.nextSegmentString = function () {
        var start = this.pos;
        for (; this.pos < this.expression.length; ++this.pos) {
            var c = this.expression[this.pos];
            if (c === '/') {
                break;
            }
            else if (c === '~') {
                var parts = [this.expression.substring(start, this.pos)];
                var length_1 = this.expression.length;
                for (; this.pos < length_1; ++this.pos) {
                    var c1 = this.expression.charAt(this.pos);
                    if (c1 === '/') {
                        break;
                    }
                    else if (c1 === '~' && this.pos !== length_1 - 1) {
                        ++this.pos;
                        var c2 = this.expression.charAt(this.pos);
                        if (c2 === '0') {
                            parts.push('~');
                        }
                        else if (c2 === '1') {
                            parts.push('/');
                        }
                        else {
                            parts.push('~');
                            parts.push(c2);
                        }
                    }
                    else {
                        parts.push(c1);
                    }
                }
                return parts.join('');
            }
        }
        return this.expression.substring(start, this.pos);
    };
    Parser.prototype.maybeIndex = function (s) {
        var digits = s.length;
        if (digits === 0 || digits > 10) {
            return null;
        }
        for (var i = 0; i < digits; ++i) {
            var c = s.charAt(i);
            if (c < '0' || c > '9') {
                return null;
            }
            if (c === '0' && i === 0) {
                return digits === 1 ? INDEX0 : null;
            }
        }
        var index = parseInt(s, 10);
        if (index > _$math_753.MAX_INT32) {
            return null;
        }
        return new IndexSegment(index);
    };
    Parser.prototype.next = function () {
        if (this.pos === this.expression.length) {
            return null;
        }
        ++this.pos;
        var s = this.nextSegmentString();
        var is = this.maybeIndex(s);
        if (is !== null) {
            return is;
        }
        return new KeySegment(s);
    };
    return Parser;
}());
var JSONPointer =  (function () {
    function JSONPointer(segments) {
        this.segments = segments;
    }
    JSONPointer.parse = function (expression) {
        if (expression instanceof JSONPointer) {
            return expression;
        }
        var result = _$jsonPointer_330.ROOT;
        var segmentParser = new Parser(expression);
        while (true) {
            var s = segmentParser.next();
            if (s === null) {
                return result;
            }
            result = result.withSegment(s);
        }
    };
    JSONPointer.prototype.withKey = function (key) {
        return this.withSegment(new KeySegment(key));
    };
    JSONPointer.prototype.withIndex = function (index) {
        return this.withSegment(new IndexSegment(index));
    };
    JSONPointer.prototype.withSegment = function (newNode) {
        var newNodes = this.segments.concat(newNode);
        return new JSONPointer(newNodes);
    };
    JSONPointer.prototype.equalIgnoringIndexes = function (other) {
        if (other === this) {
            return true;
        }
        var length = this.segments.length;
        if (length !== other.segments.length) {
            return false;
        }
        for (var i = 0; i < length; ++i) {
            var s = this.segments[i];
            var o = other.segments[i];
            if (s instanceof IndexSegment) {
                if (o instanceof KeySegment) {
                    return false;
                }
            }
            else if (!s.equals(o)) {
                return false;
            }
        }
        return true;
    };
    JSONPointer.prototype.toString = function () {
        var e_1, _a;
        var parts = [];
        try {
            for (var _b = ____values_330(this.segments), _c = _b.next(); !_c.done; _c = _b.next()) {
                var segment = _c.value;
                parts.push(segment.toString());
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return parts.join('');
    };
    JSONPointer.prototype.equals = function (other) {
        if (other === this) {
            return true;
        }
        if (!other || !(other instanceof JSONPointer)) {
            return false;
        }
        if (this.segments.length !== other.segments.length) {
            return false;
        }
        var length = this.segments.length;
        for (var i = 0; i < length; ++i) {
            var s1 = this.segments[i];
            var s2 = other.segments[i];
            if (!s1.equals(s2)) {
                return false;
            }
        }
        return true;
    };
    return JSONPointer;
}());
_$jsonPointer_330.JSONPointer = JSONPointer;
_$jsonPointer_330.ROOT = new JSONPointer([]);
function escapeKey(key) {
    for (var i = 0; i < key.length; ++i) {
        var c = key.charAt(i);
        if (c === '/' || c === '~') {
            var length_2 = key.length;
            var parts = [];
            parts.push(key.substring(0, i));
            for (var j = i; j < length_2; ++j) {
                var c1 = key.charAt(j);
                if (c1 === '/') {
                    parts.push('~1');
                }
                else if (c1 === '~') {
                    parts.push('~0');
                }
                else {
                    parts.push(c1);
                }
            }
            return parts.join('');
        }
    }
    return key;
}

var _$requireNonNull_759 = {};
"use strict";
Object.defineProperty(_$requireNonNull_759, "__esModule", { value: true });
_$requireNonNull_759.requireNonNegativeInt = _$requireNonNull_759.requireNonNegative = _$requireNonNull_759.requireNonNull = void 0;
;
function requireNonNull(value, what) {
    if (value === undefined || value === null) {
        throw new _$errors_280.NullValueError(what + ' is null');
    }
    return value;
}
_$requireNonNull_759.requireNonNull = requireNonNull;
function requireNonNegative(i, what) {
    var iChecked = requireNonNull(i, what);
    if (iChecked < 0) {
        throw new _$errors_280.IllegalArgumentError(what + " is negative: " + i);
    }
    return iChecked;
}
_$requireNonNull_759.requireNonNegative = requireNonNegative;
function requireNonNegativeInt(i, what) {
    var iChecked = requireNonNull(i, what);
    if (!Number.isInteger(iChecked) || iChecked < 0) {
        throw new _$errors_280.IllegalArgumentError("Invalid argument '" + what + "': " + i);
    }
    return iChecked;
}
_$requireNonNull_759.requireNonNegativeInt = requireNonNegativeInt;

var _$jsonPointerMap_329 = {};
"use strict";
var ____values_329 = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(_$jsonPointerMap_329, "__esModule", { value: true });
_$jsonPointerMap_329.JSONPointerMap =   void 0;
;
;
;
var Entry =  (function () {
    function Entry(segment, pointer, context) {
        this.segment = segment;
        this.pointer = pointer;
        this.children = [];
        this.value = null;
        this.context = context;
    }
    Entry.prototype.count = function () {
        var e_1, _a;
        var result = this.value ? 1 : 0;
        try {
            for (var _b = ____values_329(this.children), _c = _b.next(); !_c.done; _c = _b.next()) {
                var child = _c.value;
                result += child.count();
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return result;
    };
    Entry.prototype.addChild = function (s) {
        var c = new Entry(s, this.pointer.withSegment(s), this.context);
        this.children.push(c);
        return c;
    };
    Entry.prototype.findChild = function (s) {
        var e_2, _a;
        try {
            for (var _b = ____values_329(this.children), _c = _b.next(); !_c.done; _c = _b.next()) {
                var child = _c.value;
                if (s.equals(child.segment)) {
                    return child;
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return null;
    };
    Entry.prototype.setValue = function (newValue) {
        var previous = this.value;
        if (previous === null) {
            this.context.size++;
        }
        this.value = newValue;
        return previous;
    };
    Entry.prototype.removeDescendants = function () {
        var e_3, _a;
        var removed = 0;
        try {
            for (var _b = ____values_329(this.children), _c = _b.next(); !_c.done; _c = _b.next()) {
                var child = _c.value;
                removed += child.count();
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_3) throw e_3.error; }
        }
        this.children = [];
        this.context.size -= removed;
        return removed;
    };
    Entry.prototype.numberOfChildren = function () {
        var e_4, _a;
        var result = 0;
        try {
            for (var _b = ____values_329(this.children), _c = _b.next(); !_c.done; _c = _b.next()) {
                var child = _c.value;
                result += (child.value ? 1 : 0);
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_4) throw e_4.error; }
        }
        return result;
    };
    Entry.prototype.toString = function () {
        return this.pointer + '=' + this.value;
    };
    return Entry;
}());
 void Entry;
var PostOrderState =  (function () {
    function PostOrderState(node) {
        this.nextChildIndex = 0;
        this.node = node;
    }
    PostOrderState.prototype.nextChild = function () {
        var children = this.node.children;
        if (this.nextChildIndex >= children.length) {
            return null;
        }
        return children[this.nextChildIndex++];
    };
    return PostOrderState;
}());
var EntryIterator =  (function () {
    function EntryIterator(nextWithValue) {
        this.nextEntry = nextWithValue();
        this.nextWithValue = nextWithValue;
    }
    EntryIterator.prototype.hasNext = function () {
        return this.nextEntry !== null;
    };
    EntryIterator.prototype.next = function () {
        if (this.nextEntry === null) {
            throw new _$errors_280.InternalError('No such element');
        }
        var result = this.nextEntry;
        this.nextEntry = this.nextWithValue();
        return result;
    };
    return EntryIterator;
}());
 void EntryIterator;
var JSONPointerMap =  (function () {
    function JSONPointerMap() {
        this.root = new Entry(null, _$jsonPointer_330.ROOT, this);
        this.size = 0;
    }
    JSONPointerMap.prototype.put = function (pointer, value) {
        _$requireNonNull_759.requireNonNull(value, 'value');
        var node = this.root;
        var i = 0;
        for (; i < pointer.segments.length;) {
            var s = pointer.segments[i++];
            var c = node.findChild(s);
            if (c === null) {
                node = node.addChild(s);
                break;
            }
            node = c;
        }
        for (; i < pointer.segments.length; i++) {
            node = node.addChild(pointer.segments[i]);
        }
        return node.setValue(value);
    };
    JSONPointerMap.prototype.contains = function (pointer) {
        return this.get(pointer) !== null;
    };
    JSONPointerMap.prototype.get = function (pointer) {
        var entry = this.getEntry(pointer);
        if (entry) {
            return entry.value;
        }
        return null;
    };
    JSONPointerMap.prototype.getEntry = function (pointer) {
        var e_5, _a;
        var result = this.root;
        try {
            for (var _b = ____values_329(pointer.segments), _c = _b.next(); !_c.done; _c = _b.next()) {
                var segment = _c.value;
                result = result.findChild(segment);
                if (result === null) {
                    return null;
                }
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_5) throw e_5.error; }
        }
        return result;
    };
    JSONPointerMap.prototype.descendants = function (pointer) {
        var result = new JSONPointerMap();
        var thisNode = this.root;
        var resultNode = result.root;
        var segments = pointer.segments;
        var length = segments.length;
        if (length === 0) {
            return this;
        }
        for (var i = 0; i < length - 1; ++i) {
            var s = segments[i];
            thisNode = thisNode.findChild(s);
            if (thisNode === null) {
                return EMPTY;
            }
            resultNode = resultNode.addChild(s);
        }
        var last = thisNode.findChild(segments[length - 1]);
        if (last === null) {
            return EMPTY;
        }
        resultNode.children.push(last);
        result.size = last.count();
        return result;
    };
    JSONPointerMap.prototype.intersection = function (pointer) {
        var result = new JSONPointerMap();
        var thisNode = this.root;
        var resultNode = result.root;
        var segments = pointer.segments;
        var length = segments.length;
        if (length === 0) {
            return this;
        }
        if (thisNode.value !== null) {
            resultNode.setValue(thisNode.value);
        }
        for (var i = 0; i < length - 1; ++i) {
            var s = segments[i];
            thisNode = thisNode.findChild(s);
            if (thisNode === null) {
                return result;
            }
            resultNode = resultNode.addChild(s);
            if (thisNode.value !== null) {
                resultNode.setValue(thisNode.value);
            }
        }
        var last = thisNode.findChild(segments[length - 1]);
        if (last === null) {
            return result;
        }
        resultNode.children.push(last);
        result.size += last.count();
        return result;
    };
    JSONPointerMap.prototype.iterator = function () {
        var stack = [this.root];
        return new EntryIterator(function () {
            for (;;) {
                var r = stack.shift();
                if (r === undefined) {
                    return null;
                }
                var n = r.children.length;
                for (; n > 0; --n) {
                    stack.unshift(r.children[n - 1]);
                }
                if (r.value !== null) {
                    return r;
                }
            }
        });
    };
    JSONPointerMap.prototype.postOrder = function () {
        var stack = [new PostOrderState(this.root)];
        return new EntryIterator(function () {
            for (;;) {
                var r = stack[0];
                if (r === undefined) {
                    return null;
                }
                var c = r.nextChild();
                if (c === null) {
                    stack.shift();
                    if (r.node.value !== null) {
                        return r.node;
                    }
                }
                else if (c.children.length === 0) {
                    return c;
                }
                else {
                    stack.unshift(new PostOrderState(c));
                }
            }
        });
    };
    JSONPointerMap.prototype.toString = function () {
        var parts = ['{'];
        var iter = this.iterator();
        while (iter.hasNext()) {
            if (parts.length > 1) {
                parts.push(', ');
            }
            parts.push(iter.next());
        }
        parts.push('}');
        return parts.join('');
    };
    return JSONPointerMap;
}());
_$jsonPointerMap_329.JSONPointerMap = JSONPointerMap;
var EMPTY = new JSONPointerMap();

var _$spanParser_331 = {};
"use strict";
var ____extends_331 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ____values_331 = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(_$spanParser_331, "__esModule", { value: true });
_$spanParser_331.SpanParser = void 0;
;
;
;
;
var AbstractAccumulator =  (function () {
    function AbstractAccumulator(tokeniser, base, start, next) {
        this.tokenRange = [];
        this.accumulatedTokens = 0;
        this.totalTokens = 0;
        this.tokeniser = tokeniser;
        this.base = base;
        this.startOffset = start;
        this.nextOffset = next;
    }
    AbstractAccumulator.prototype.total = function () {
        return this.totalTokens;
    };
    AbstractAccumulator.prototype.accumulated = function () {
        return this.accumulatedTokens;
    };
    AbstractAccumulator.prototype.newArray = function (start, next) {
        return new ArrayAccumulator(this.tokeniser, this.currentPointer(this.base, this.totalTokens), start, next);
    };
    AbstractAccumulator.prototype.newObject = function (start, next) {
        return new ObjectAccumulator(this.tokeniser, this.currentPointer(this.base, this.totalTokens), start, next);
    };
    AbstractAccumulator.prototype.notEmptyAndSplitBy = function (offset) {
        return this.startOffset < offset && this.totalTokens !== 0;
    };
    AbstractAccumulator.prototype.add = function (next) {
        this.tokenRange[this.accumulatedTokens] = [this.nextOffset, next];
        this.nextOffset = next;
        ++this.accumulatedTokens;
        ++this.totalTokens;
        return false;
    };
    AbstractAccumulator.prototype.setNextStart = function (offset) {
        this.nextOffset = offset;
    };
    AbstractAccumulator.prototype.skip = function () {
        ++this.totalTokens;
        this.accumulatedTokens = 0;
    };
    AbstractAccumulator.prototype.takeAll = function (consumer) {
        var next = this.totalTokens;
        var begin = next - this.accumulatedTokens;
        for (var i = 0; i < this.accumulatedTokens; ++i) {
            var range = this.tokenRange[i];
            var start = range[0];
            var end = range[1];
            this.take(consumer, this.base, begin, begin + i, start, end - start);
        }
        this.accumulatedTokens = 0;
    };
    AbstractAccumulator.prototype.splitStructureEnd = function (consumer) {
        consumer.splitStructureEnd(this.base, this.totalTokens, this.startOffset, this.nextOffset + 1 - this.startOffset);
    };
    AbstractAccumulator.prototype.toString = function () {
        return this.base.toString();
    };
    return AbstractAccumulator;
}());
var ArrayAccumulator =  (function (_super) {
    ____extends_331(ArrayAccumulator, _super);
    function ArrayAccumulator(tokeniser, base, start, next) {
        return _super.call(this, tokeniser, base, start, next) || this;
    }
    ArrayAccumulator.prototype.take = function (consumer, base, firstAccumulatedIndex, index, start, length) {
        consumer.accept(base.withIndex(index), start, length);
    };
    ArrayAccumulator.prototype.currentPointer = function (base, total) {
        return base.withIndex(total);
    };
    return ArrayAccumulator;
}(AbstractAccumulator));
var ObjectAccumulator =  (function (_super) {
    ____extends_331(ObjectAccumulator, _super);
    function ObjectAccumulator(tokeniser, base, start, next) {
        var _this = _super.call(this, tokeniser, base, start, next) || this;
        _this.pendingKeyName = '';
        _this.pendingKey = true;
        _this.keys = [];
        return _this;
    }
    ObjectAccumulator.prototype.add = function (tokenEnd) {
        if (this.pendingKey) {
            this.setNextStart(tokenEnd);
            this.pendingKeyName = this.tokeniser.getToken().value;
            this.pendingKey = false;
        }
        else {
            this.keys[this.accumulated()] = this.pendingKeyName;
            this.pendingKey = true;
            _super.prototype.add.call(this, tokenEnd);
        }
        return !this.pendingKey;
    };
    ObjectAccumulator.prototype.take = function (consumer, base, firstAccumulatedIndex, index, start, length) {
        consumer.accept(base.withKey(this.keys[index - firstAccumulatedIndex]), start, length);
    };
    ObjectAccumulator.prototype.currentPointer = function (base) {
        return base.withKey(this.pendingKeyName);
    };
    return ObjectAccumulator;
}(AbstractAccumulator));
var RootAccumulator =  (function (_super) {
    ____extends_331(RootAccumulator, _super);
    function RootAccumulator(tokeniser) {
        return _super.call(this, tokeniser, _$jsonPointer_330.ROOT, -1, 0) || this;
    }
    RootAccumulator.prototype.take = function (consumer, base, firstAccumulatedIndex, index, start, length) {
        if (this.total() > 1) {
            throw new _$errors_280.InvalidDataError('Invalid JSON: multiple values found');
        }
        consumer.accept(base, start, length);
    };
    RootAccumulator.prototype.currentPointer = function (base) {
        return base;
    };
    return RootAccumulator;
}(AbstractAccumulator));
var SpanParser =  (function () {
    function SpanParser(json) {
        this.parentStack = [];
        this.tokeniser = new _$tokeniser_295.Tokeniser(json.$buffer, json.$offset, json.$length);
        this.structure = new RootAccumulator(this.tokeniser);
        this.startOffset = this.tokeniser.offset();
        this.json = json;
    }
    SpanParser.prototype.spanToNext = function (offset, result) {
        return this.spanTo(offset, result, true);
    };
    SpanParser.prototype.spanTo = function (offset, result, atLeastOne) {
        var e_1, _a;
        if (atLeastOne === void 0) { atLeastOne = false; }
        var start = this.nextByte();
        if (start >= offset) {
            return 0;
        }
        var lastHeight = this.parentStack.length;
        var consumeFirstValue = atLeastOne;
        var next = start;
        var t;
        do {
            t = this.tokeniser.nextToken();
            var tokenStart = next;
            next = this.nextByte();
            if (t === null) {
                if (this.parentStack.length !== 0) {
                    throw new _$errors_280.InvalidDataError('Invalid structure');
                }
                break;
            }
            else if (t.type === _$consts_291.tokens.VALUE) {
                consumeFirstValue = this.structure.add(next);
            }
            else if (t.type === _$consts_291.tokens.ARRAY_START) {
                this.parentStack.push(this.structure);
                this.structure = this.structure.newArray(tokenStart, next);
            }
            else if (t.type === _$consts_291.tokens.MAP_START) {
                this.parentStack.push(this.structure);
                this.structure = this.structure.newObject(tokenStart, next);
            }
            else if (_$consts_291.isStructEnd(t.type)) {
                var parent_1 = this.parentStack.pop();
                if (this.structure.notEmptyAndSplitBy(start)) {
                    this.structure.takeAll(result);
                    this.structure.splitStructureEnd(result);
                    parent_1.skip();
                    parent_1.setNextStart(next);
                }
                else {
                    parent_1.add(next);
                }
                this.structure = parent_1;
                consumeFirstValue = false;
            }
        } while (consumeFirstValue || next < offset || this.nextTokenIsStructEnd(t, next));
        try {
            for (var _b = ____values_331(this.parentStack), _c = _b.next(); !_c.done; _c = _b.next()) {
                var accumulator = _c.value;
                accumulator.takeAll(result);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        this.structure.takeAll(result);
        return this.parentStack.length - lastHeight;
    };
    SpanParser.prototype.nextTokenIsStructEnd = function (t, next) {
        var context = this.tokeniser.getContext();
        if (_$consts_291.isStructStart(t.type)) {
            return context.expected() === 0;
        }
        return context.acceptsBreakMarker() &&
            next < this.json.$length &&
            this.json.$buffer[this.json.$offset + next] === _$consts_291.BYTE_BREAK ||
            !context.hasRemaining();
    };
    SpanParser.prototype.nextByte = function () {
        return this.tokeniser.offset() - this.startOffset;
    };
    SpanParser.prototype.toString = function () {
        var parts = ['SpanParser', ' next=', this.nextByte().toString(), ' ['];
        this.parentStack.forEach(function (x) {
            parts.push(x.toString());
            parts.push(', ');
        });
        parts.push(this.structure.toString());
        parts.push(']');
        return parts.join('');
    };
    return SpanParser;
}());
_$spanParser_331.SpanParser = SpanParser;

var _$jsonDeltaImpl_327 = {};
"use strict";
Object.defineProperty(_$jsonDeltaImpl_327, "__esModule", { value: true });
_$jsonDeltaImpl_327.JSONDeltaImpl = void 0;
;
;
;
;
var LastResult =  (function () {
    function LastResult(splitStructures) {
        this.splitStructures = splitStructures;
    }
    LastResult.prototype.accept = function (pointer, start, length) {
        this.last = pointer;
        this.lastStart = start;
        this.lastLength = length;
    };
    LastResult.prototype.foundLast = function () {
        return this.last !== undefined;
    };
    LastResult.prototype.consumeLast = function (delegate) {
        delegate.accept(this.last, this.lastStart, this.lastLength);
    };
    LastResult.prototype.splitStructureEnd = function (pointer, count, start, length) {
        this.splitStructures.put(pointer, {
            start: start,
            length: length,
            elements: count
        });
    };
    return LastResult;
}());
function isPartOf(original, other, start, length) {
    return original.equalBytes(other.$buffer, other.$offset + start, length);
}
var DeltaVisitor =  (function () {
    function DeltaVisitor(oldValue, newValue, inserted, removed, partOf, copyPartOf) {
        var _this = this;
        this.removedSplitStructures = new _$jsonPointerMap_329.JSONPointerMap();
        this.insertedSplitStructures = new _$jsonPointerMap_329.JSONPointerMap();
        this.oldOffset = 0;
        this.newOffset = 0;
        this.pendingRemove = null;
        this.pendingInsert = null;
        this.inserter = {
            accept: function (pointer, start, length) {
                if (_this.pendingRemove !== null &&
                    _this.pendingRemove.equalIgnoringIndexes(pointer) &&
                    isPartOf(_this.pendingRemoveValue, _this.newValue, start, length)) {
                    _this.pendingRemove = null;
                    _this.pendingRemoveValue = null;
                }
                else {
                    _this.addInsert(pointer, _this.partOf(_this.newValue, start, length));
                    _this.addRemove(null, null);
                }
            },
            splitStructureEnd: function (pointer, count, start, length) {
                _this.insertedSplitStructures.put(pointer, {
                    start: start,
                    length: length,
                    elements: count
                });
            }
        };
        this.remover = {
            accept: function (pointer, start, length) {
                if (_this.pendingInsert !== null &&
                    _this.pendingInsert.equalIgnoringIndexes(pointer) &&
                    isPartOf(_this.pendingInsertValue, _this.oldValue, start, length)) {
                    _this.pendingInsert = null;
                    _this.pendingInsertValue = null;
                }
                else {
                    _this.addRemove(pointer, _this.copyPartOf(_this.oldValue, start, length));
                    _this.addInsert(null, null);
                }
            },
            splitStructureEnd: function (pointer, count, start, length) {
                _this.removedSplitStructures.put(pointer, {
                    start: start,
                    length: length,
                    elements: count
                });
            }
        };
        this.oldParser = new _$spanParser_331.SpanParser(oldValue);
        this.newParser = new _$spanParser_331.SpanParser(newValue);
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.inserted = inserted;
        this.removed = removed;
        this.partOf = partOf;
        this.copyPartOf = copyPartOf;
    }
    DeltaVisitor.prototype.match = function (start, length) {
        this.handleDelete(this.oldOffset, start - this.oldOffset);
        this.handleMatch(start, length);
        return true;
    };
    DeltaVisitor.prototype.handleDelete = function (start, length) {
        this.checkInvariants();
        var end = start + length;
        if (this.oldParser.nextByte() < end &&
            (this.oldParser.spanTo(end, this.remover) !== 0 || this.oldParser.nextByte() > end)) {
            this.newParser.spanToNext(this.newOffset + 1, this.inserter);
        }
    };
    DeltaVisitor.prototype.handleMatch = function (start, length) {
        this.checkInvariants();
        var newStart = this.newOffset;
        var end = start + length;
        this.newOffset += length;
        this.oldOffset = end;
        var oldNextByte = this.oldParser.nextByte();
        var newNextByte = this.newParser.nextByte();
        if (newNextByte > newStart && oldNextByte === start) {
            this.oldParser.spanToNext(start + 1, this.remover);
        }
        else if (oldNextByte > start && newNextByte === newStart) {
            this.newParser.spanToNext(newStart + 1, this.inserter);
        }
        var lastOld = new LastResult(this.removedSplitStructures);
        var lastNew = new LastResult(this.insertedSplitStructures);
        this.oldParser.spanTo(end, lastOld);
        this.newParser.spanTo(this.newOffset, lastNew);
        var oldSplit = lastOld.foundLast() && this.oldParser.nextByte() > end;
        var newSplit = lastNew.foundLast() && this.newParser.nextByte() > this.newOffset;
        if (oldSplit && newSplit) {
            lastOld.consumeLast(this.remover);
            lastNew.consumeLast(this.inserter);
        }
    };
    DeltaVisitor.prototype.insert = function (bytes) {
        this.checkInvariants();
        this.newOffset += bytes.length;
        if (this.newParser.nextByte() < this.newOffset &&
            (this.newParser.spanTo(this.newOffset, this.inserter) !== 0
                || this.newParser.nextByte() > this.newOffset)) {
            this.oldParser.spanToNext(this.oldOffset + 1, this.remover);
        }
        return true;
    };
    DeltaVisitor.prototype.end = function () {
        this.handleDelete(this.oldOffset, this.oldValue.$length - this.oldOffset);
        this.addInsert(null, null);
        this.addRemove(null, null);
        this.replaceFullRemovedStructures();
        this.replaceFullInsertedStructures();
    };
    DeltaVisitor.prototype.addInsert = function (nextPointer, nextValue) {
        if (this.pendingInsert !== null) {
            this.inserted.put(this.pendingInsert, this.pendingInsertValue);
        }
        this.pendingInsert = nextPointer;
        this.pendingInsertValue = nextValue;
    };
    DeltaVisitor.prototype.addRemove = function (nextPointer, nextValue) {
        if (this.pendingRemove !== null) {
            this.removed.put(this.pendingRemove, this.pendingRemoveValue);
        }
        this.pendingRemove = nextPointer;
        this.pendingRemoveValue = nextValue;
    };
    DeltaVisitor.prototype.noChange = function () {
    };
    DeltaVisitor.prototype.checkInvariants = function () {
        if (this.oldParser.nextByte() < this.oldOffset ||
            this.newParser.nextByte() < this.newOffset) {
            throw new _$errors_280.InvalidDataError('Invalid binary delta');
        }
    };
    DeltaVisitor.prototype.replaceFullRemovedStructures = function () {
        var i = this.removedSplitStructures.postOrder();
        while (i.hasNext()) {
            var s = i.next();
            var split = s.value;
            var entry = this.removed.getEntry(s.pointer);
            if (entry !== null && entry.numberOfChildren() === split.elements) {
                entry.setValue(this.copyPartOf(this.oldValue, split.start, split.length));
                entry.removeDescendants();
            }
        }
    };
    DeltaVisitor.prototype.replaceFullInsertedStructures = function () {
        var i = this.insertedSplitStructures.postOrder();
        while (i.hasNext()) {
            var s = i.next();
            var split = s.value;
            var entry = this.inserted.getEntry(s.pointer);
            if (entry !== null && entry.numberOfChildren() === split.elements) {
                entry.setValue(this.partOf(this.newValue, split.start, split.length));
                entry.removeDescendants();
            }
        }
    };
    return DeltaVisitor;
}());
var ChangeMapImpl =  (function () {
    function ChangeMapImpl(parts) {
        this.entries = [];
        this.parts = parts;
        var i = parts.iterator();
        while (i.hasNext()) {
            var n = i.next();
            this.entries.push({
                key: n.pointer.toString(),
                value: n.value.get()
            });
        }
        this.length = this.entries.length;
    }
    ChangeMapImpl.prototype.get = function (key) {
        return this.parts.get(_$jsonPointer_330.JSONPointer.parse(key)).get();
    };
    ChangeMapImpl.prototype.entrySet = function () {
        return this.entries;
    };
    ChangeMapImpl.prototype.containsKey = function (key) {
        return this.parts.contains(_$jsonPointer_330.JSONPointer.parse(key));
    };
    ChangeMapImpl.prototype.descendants = function (pointer) {
        return new ChangeMapImpl(this.parts.descendants(_$jsonPointer_330.JSONPointer.parse(pointer)));
    };
    ChangeMapImpl.prototype.intersection = function (pointer) {
        return new ChangeMapImpl(this.parts.intersection(_$jsonPointer_330.JSONPointer.parse(pointer)));
    };
    return ChangeMapImpl;
}());
var JSONDeltaImpl =  (function () {
    function JSONDeltaImpl(factory, original, newValue, binaryDelta) {
        this.insertedMap = new _$jsonPointerMap_329.JSONPointerMap();
        this.removedMap = new _$jsonPointerMap_329.JSONPointerMap();
        this.factory = factory;
        if (binaryDelta !== undefined) {
            binaryDelta.visit(new DeltaVisitor(original, newValue, this.insertedMap, this.removedMap, this.partOf.bind(this), this.copyPartOf.bind(this)));
        }
        else {
            this.insertedMap.put(_$jsonPointer_330.ROOT, original);
            this.removedMap.put(_$jsonPointer_330.ROOT, newValue);
        }
    }
    JSONDeltaImpl.prototype.partOf = function (value, start, length) {
        return new this.factory(value.$buffer, value.$offset + start, length);
    };
    JSONDeltaImpl.prototype.copyPartOf = function (value, start, length) {
        var offsetStart = value.$offset + start;
        var buffer = new Uint8Array(length);
        buffer.set(value.$buffer.subarray(offsetStart, offsetStart + length));
        return new this.factory(buffer, 0, length);
    };
    JSONDeltaImpl.prototype.removed = function () {
        return new ChangeMapImpl(this.removedMap);
    };
    JSONDeltaImpl.prototype.inserted = function () {
        return new ChangeMapImpl(this.insertedMap);
    };
    JSONDeltaImpl.prototype.hasChanges = function () {
        return this.removedMap.size !== 0 || this.insertedMap.size !== 0;
    };
    JSONDeltaImpl.prototype.toString = function () {
        return ['REMOVE ', this.removedMap, ' INSERT ', this.insertedMap].join('');
    };
    return JSONDeltaImpl;
}());
_$jsonDeltaImpl_327.JSONDeltaImpl = JSONDeltaImpl;

var _$jsonImpl_328 = {};
"use strict";
var ____extends_328 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$jsonImpl_328, "__esModule", { value: true });
_$jsonImpl_328.JSONImpl = void 0;
;
;
;
;
;
;
;
var encoder = new _$encoder_294.Encoder();
function __fromValue_328(value) {
    if (value instanceof JSONImpl) {
        return value;
    }
    else {
        return new JSONImpl(encoder.encode(value).flush());
    }
}
function int64Replacer(key, value) {
    if (value instanceof _$int64Impl_334.Int64Impl) {
        return value.toString();
    }
    return value;
}
var JSONImpl =  (function (_super) {
    ____extends_328(JSONImpl, _super);
    function JSONImpl(buffer, offset, length) {
        if (offset === void 0) { offset = 0; }
        if (length === void 0) { length = buffer.length; }
        return _super.call(this, buffer, offset, length) || this;
    }
    JSONImpl.toString = function () {
        return 'JSONImpl';
    };
    JSONImpl.from = function (value) {
        return __fromValue_328(value);
    };
    JSONImpl.prototype.get = function () {
        var decoder = new _$decoder_293.Decoder(this.$buffer, this.$offset, this.$length);
        return decoder.nextValue();
    };
    JSONImpl.prototype.diff = function (original, type) {
        var originalJson = __fromValue_328(original);
        var binaryDiff = this.binaryDiff(originalJson);
        if (type === 'json') {
            return new _$jsonDeltaImpl_327.JSONDeltaImpl(JSONImpl, originalJson, this, binaryDiff);
        }
        else {
            return binaryDiff;
        }
    };
    JSONImpl.prototype.binaryDiff = function (original) {
        return BINARY_DELTA_TYPE.diff(original, this);
    };
    JSONImpl.prototype.jsonDiff = function (original) {
        return this.diff(original, 'json');
    };
    JSONImpl.prototype.apply = function (delta) {
        return BINARY_DELTA_TYPE.apply(this, delta);
    };
    JSONImpl.prototype.toString = function () {
        return JSON.stringify(this.get());
    };
    JSONImpl.prototype.toJsonString = function () {
        return JSON.stringify(this.get(), int64Replacer);
    };
    return JSONImpl;
}(_$bytesImpl_323.BytesImpl));
_$jsonImpl_328.JSONImpl = JSONImpl;
var BINARY_DELTA_TYPE = new _$binaryDeltaTypeImpl_320.BinaryDeltaTypeImpl(JSONImpl, __fromValue_328, _$function_750.identity);

var _$jsonDatatypeImpl_326 = {};
"use strict";
var ____extends_326 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$jsonDatatypeImpl_326, "__esModule", { value: true });
_$jsonDatatypeImpl_326.JSONDataTypeImpl = void 0;
;
;
;
var JSONDataTypeImpl =  (function (_super) {
    ____extends_326(JSONDataTypeImpl, _super);
    function JSONDataTypeImpl() {
        var _this = _super.call(this, 'json', _$jsonImpl_328.JSONImpl, _$jsonImpl_328.JSONImpl, _$jsonImpl_328.JSONImpl.from, _$function_750.identity, [], true) || this;
        _this.JSON = _$jsonImpl_328.JSONImpl;
        return _this;
    }
    JSONDataTypeImpl.prototype.fromJsonString = function (value) {
        return _$jsonImpl_328.JSONImpl.from(JSON.parse(value));
    };
    JSONDataTypeImpl.prototype.from = function (object) {
        return _$jsonImpl_328.JSONImpl.from(object);
    };
    JSONDataTypeImpl.prototype.validate = function () {
    };
    return JSONDataTypeImpl;
}(_$abstractDatatype_316.AbstractDataType));
_$jsonDatatypeImpl_326.JSONDataTypeImpl = JSONDataTypeImpl;

var _$primitiveDatatype_335 = {};
(function (Buffer){(function (){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$primitiveDatatype_335, "__esModule", { value: true });
_$primitiveDatatype_335.PrimitiveDataType = void 0;
;
;
;
;
;
var encoder = new _$encoder_294.Encoder();
var NULL_CBOR = new _$bytesImpl_323.BytesImpl(Uint8Array.from([0xf6]));
var PrimitiveDataType =  (function (_super) {
    __extends(PrimitiveDataType, _super);
    function PrimitiveDataType(typeName, valueClass, serialise, cborTypePredicate, withBinaryDelta) {
        var _this = this;
        var vToC = function (value) {
            serialise(value, encoder);
            return new _$bytesImpl_323.BytesImpl(encoder.flush());
        };
        var cToV = function (bytes) {
            if (NULL_CBOR.equals(bytes)) {
                return null;
            }
            var decoder = new _$decoder_293.Decoder(bytes.$buffer, bytes.$offset, bytes.$length);
            return decoder.nextValueExpecting(cborTypePredicate);
        };
        var jsonConverter = {
            name: _$jsonImpl_328.JSONImpl.toString(),
            convert: function (buffer, offset, length) {
                return new _$jsonImpl_328.JSONImpl(buffer, offset, length);
            }
        };
        _this = _super.call(this, typeName, valueClass, _$bytesImpl_323.BytesImpl, vToC, cToV, [jsonConverter], withBinaryDelta) || this;
        _this.serialise = serialise;
        _this.fromValue = vToC;
        return _this;
    }
    PrimitiveDataType.prototype.writeValue = function (value) {
        return Buffer.from(this.writeValueToArray(value));
    };
    PrimitiveDataType.prototype.writeValueToArray = function (value) {
        if (value === null || value === undefined) {
            return NULL_CBOR.asArray();
        }
        else {
            this.serialise(value, encoder);
            return encoder.flush();
        }
    };
    PrimitiveDataType.prototype.validate = function () {
    };
    PrimitiveDataType.prototype.from = function (value) {
        if (value.$buffer) {
            return value;
        }
        else {
            return this.fromValue(value);
        }
    };
    return PrimitiveDataType;
}(_$abstractDatatype_316.AbstractDataType));
_$primitiveDatatype_335.PrimitiveDataType = PrimitiveDataType;

}).call(this)}).call(this,_$buffer_3({}).Buffer)
var _$doubleDatatypeImpl_332 = {};
"use strict";
var ____extends_332 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$doubleDatatypeImpl_332, "__esModule", { value: true });
_$doubleDatatypeImpl_332.DoubleDataTypeImpl = void 0;
;
;
function serialise(value, encoder) {
    if (value === null || value === undefined) {
        encoder.encode(null);
    }
    else {
        encoder.writeDouble(value);
    }
}
var DoubleDataTypeImpl =  (function (_super) {
    ____extends_332(DoubleDataTypeImpl
    , _super);
    function DoubleDataTypeImpl() {
        return _super.call(this, 'double', Number, serialise, _$decoder_293.isDouble, false) || this;
    }
    return DoubleDataTypeImpl;
}(_$primitiveDatatype_335.PrimitiveDataType));
_$doubleDatatypeImpl_332.DoubleDataTypeImpl = DoubleDataTypeImpl;

var _$int64DatatypeImpl_333 = {};
"use strict";
var ____extends_333 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$int64DatatypeImpl_333, "__esModule", { value: true });
_$int64DatatypeImpl_333.Int64DataTypeImpl = void 0;
;
;
;
function __serialise_333(value, encoder) {
    if (value === null || value === undefined) {
        encoder.encode(null);
    }
    else {
        encoder.writeInt64(new _$int64Impl_334.Int64Impl(value));
    }
}
var Int64DataTypeImpl =  (function (_super) {
    ____extends_333(Int64DataTypeImpl, _super);
    function Int64DataTypeImpl() {
        var _this = _super.call(this, 'int64', _$int64Impl_334.Int64Impl, __serialise_333, _$decoder_293.isInt64, false) || this;
        _this.Int64 = _$int64Impl_334.Int64Impl;
        return _this;
    }
    return Int64DataTypeImpl;
}(_$primitiveDatatype_335.PrimitiveDataType));
_$int64DatatypeImpl_333.Int64DataTypeImpl = Int64DataTypeImpl;

var _$stringDatatypeImpl_336 = {};
"use strict";
var ____extends_336 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$stringDatatypeImpl_336, "__esModule", { value: true });
_$stringDatatypeImpl_336.StringDataTypeImpl = void 0;
;
;
function __serialise_336(v, encoder) {
    if (v === null || v === undefined) {
        encoder.encode(null);
    }
    else {
        encoder.encode(v.toString());
    }
}
var StringDataTypeImpl =  (function (_super) {
    ____extends_336(StringDataTypeImpl, _super);
    function StringDataTypeImpl() {
        return _super.call(this, 'string', String, __serialise_336, _$decoder_293.isString, true) || this;
    }
    return StringDataTypeImpl;
}(_$primitiveDatatype_335.PrimitiveDataType));
_$stringDatatypeImpl_336.StringDataTypeImpl = StringDataTypeImpl;

var _$recordv2Utils_345 = {};
"use strict";
Object.defineProperty(_$recordv2Utils_345, "__esModule", { value: true });
_$recordv2Utils_345.recordIsSingleEmptyField = _$recordv2Utils_345.isSingleEmptyRecord = _$recordv2Utils_345.findDelimiter = _$recordv2Utils_345.fieldCount = _$recordv2Utils_345.recordCount = _$recordv2Utils_345.bytesToString =      _$recordv2Utils_345.FIELD_MU = _$recordv2Utils_345.RECORD_MU = _$recordv2Utils_345.EMPTY_FIELD = _$recordv2Utils_345.FIELD_DELIMITER = _$recordv2Utils_345.RECORD_DELIMITER = void 0;
_$recordv2Utils_345.RECORD_DELIMITER = 0x1;
_$recordv2Utils_345.FIELD_DELIMITER = 0x2;
_$recordv2Utils_345.EMPTY_FIELD = 0x3;
_$recordv2Utils_345.RECORD_MU = 0x4;
_$recordv2Utils_345.FIELD_MU = 0x5;
 void String.fromCharCode(_$recordv2Utils_345.RECORD_DELIMITER);
 void String.fromCharCode(_$recordv2Utils_345.FIELD_DELIMITER);
 void String.fromCharCode(_$recordv2Utils_345.EMPTY_FIELD);
 void String.fromCharCode(_$recordv2Utils_345.RECORD_MU);
 void String.fromCharCode(_$recordv2Utils_345.FIELD_MU);
function bytesToString(bytes, offset, length) {
    var ret = '';
    for (var i = offset; i < offset + length; ++i) {
        switch (bytes[i]) {
            case _$recordv2Utils_345.FIELD_DELIMITER:
                ret += '<FD>';
                break;
            case _$recordv2Utils_345.RECORD_DELIMITER:
                ret += '<RD>';
                break;
            case _$recordv2Utils_345.EMPTY_FIELD:
                ret += '<EF>';
                break;
            case _$recordv2Utils_345.FIELD_MU:
                ret += '<FM>';
                break;
            case _$recordv2Utils_345.RECORD_MU:
                ret += '<RM>';
                break;
            default:
                ret += String.fromCharCode(bytes[i]);
        }
    }
    return ret;
}
_$recordv2Utils_345.bytesToString = bytesToString;
function entityCount(bytes, offset, length, mu, delimiter) {
    if (length === 0) {
        return 0;
    }
    if (bytes[0] === mu) {
        return 1;
    }
    var count = 1;
    for (var i = offset; i < offset + length; i++) {
        if (bytes[i] === delimiter) {
            count++;
        }
    }
    return count;
}
function recordCount(bytes, offset, length) {
    return entityCount(bytes, offset, length, _$recordv2Utils_345.RECORD_MU, _$recordv2Utils_345.RECORD_DELIMITER);
}
_$recordv2Utils_345.recordCount = recordCount;
function fieldCount(bytes, offset, length) {
    return entityCount(bytes, offset, length, _$recordv2Utils_345.FIELD_MU, _$recordv2Utils_345.FIELD_DELIMITER);
}
_$recordv2Utils_345.fieldCount = fieldCount;
function findDelimiter(bytes, startIndex, endIndex, delimiter) {
    for (var pos = startIndex; pos < endIndex; pos++) {
        if (bytes[pos] === delimiter) {
            return pos;
        }
    }
    return endIndex;
}
_$recordv2Utils_345.findDelimiter = findDelimiter;
function isSingleEmptyRecord(bytes, offset, length) {
    return length === 1 && bytes[offset] === _$recordv2Utils_345.RECORD_MU;
}
_$recordv2Utils_345.isSingleEmptyRecord = isSingleEmptyRecord;
function recordIsSingleEmptyField(bytes, offset, length) {
    return length === 1 && (bytes[offset] === _$recordv2Utils_345.FIELD_MU || bytes[offset] === _$recordv2Utils_345.EMPTY_FIELD);
}
_$recordv2Utils_345.recordIsSingleEmptyField = recordIsSingleEmptyField;

var _$recordv2Writer_346 = {};
"use strict";
Object.defineProperty(_$recordv2Writer_346, "__esModule", { value: true });
_$recordv2Writer_346.toBuffer =  void 0;
;
;
;
function write(records, out) {
    if (records.length === 0) {
        return;
    }
    if (records.length === 1 && records[0].length === 0) {
        out.write(_$recordv2Utils_345.RECORD_MU);
        return;
    }
    var mustWriteRecordDelimiter = false;
    records.forEach(function (record) {
        if (mustWriteRecordDelimiter) {
            out.write(_$recordv2Utils_345.RECORD_DELIMITER);
        }
        else {
            mustWriteRecordDelimiter = true;
        }
        if (record.length === 1 && record[0] === '') {
            out.write(_$recordv2Utils_345.FIELD_MU);
        }
        else {
            var mustWriteFieldDelimiter_1 = false;
            record.forEach(function (field) {
                if (mustWriteFieldDelimiter_1) {
                    out.write(_$recordv2Utils_345.FIELD_DELIMITER);
                }
                else {
                    mustWriteFieldDelimiter_1 = true;
                }
                if (field !== undefined && field !== null) {
                    out.writeMany(_$uint8array_762.uint8FromUtf8(field));
                }
            });
        }
    });
}
 void write;
function toBuffer(records) {
    var bos = new _$bufferOutputStream_410.BufferOutputStream();
    write(records, bos);
    return bos.getBuffer();
}
_$recordv2Writer_346.toBuffer = toBuffer;

var _$abstractRecordModel_337 = {};
"use strict";
Object.defineProperty(_$abstractRecordModel_337, "__esModule", { value: true });
_$abstractRecordModel_337.AbstractRecordModel = _$abstractRecordModel_337.resolveFieldIndex = _$abstractRecordModel_337.resolveRecordIndex = void 0;
;
;
function resolveRecordIndex(record, records, index) {
    var actualIndex = record.getAbsoluteIndex(index);
    if (actualIndex > records.length - 1) {
        throw new _$errors_280.OutOfBoundsError("Index '" + index + "' does not have a matching entry for variable occurrence record: '" + record.name + "'");
    }
    return actualIndex;
}
_$abstractRecordModel_337.resolveRecordIndex = resolveRecordIndex;
function resolveFieldIndex(field, fields, index) {
    var actualIndex = field.getAbsoluteIndex(index);
    if (actualIndex > fields.length - 1) {
        throw new _$errors_280.OutOfBoundsError("Index '" + index + "' does not have a matching entry for variable occurrence field: '" + field.name + "'");
    }
    return actualIndex;
}
_$abstractRecordModel_337.resolveFieldIndex = resolveFieldIndex;
var AbstractRecordModel =  (function () {
    function AbstractRecordModel(recordV2Constructor, schema) {
        this.recordV2Constructor = recordV2Constructor;
        this.modelSchema = schema;
    }
    AbstractRecordModel.prototype.schema = function () {
        return this.modelSchema;
    };
    AbstractRecordModel.prototype.asValue = function () {
        return new this.recordV2Constructor(_$recordv2Writer_346.toBuffer(this.model()));
    };
    AbstractRecordModel.prototype.get = function (recordName, recordIndexOrFieldName, fieldNameOrFieldIndex, fieldIndex) {
        if (recordIndexOrFieldName === void 0) { recordIndexOrFieldName = 0; }
        if (fieldIndex === void 0) { fieldIndex = 0; }
        var fieldName;
        var recordIndex;
        switch (arguments.length) {
            case 1:
                var key = this.parseKey(recordName);
                recordName = key.recordName;
                recordIndex = key.recordIndex;
                fieldName = key.fieldName;
                fieldIndex = key.fieldIndex;
                break;
            case 2:
                fieldName = recordIndexOrFieldName;
                recordIndex = 0;
                break;
            default:
                fieldName = fieldNameOrFieldIndex;
                recordIndex = recordIndexOrFieldName;
        }
        var schemaRecord = this.modelSchema.getRecord(recordName);
        var schemaField = schemaRecord.getField(fieldName);
        var record = this.getRecord(schemaRecord, recordIndex);
        return record[resolveFieldIndex(schemaField, record, fieldIndex)];
    };
    AbstractRecordModel.prototype.recordCount = function (recordName) {
        var schemaRecord = this.modelSchema.getRecord(recordName);
        if (schemaRecord.isVariable) {
            return this.model().length - schemaRecord.index;
        }
        else {
            return schemaRecord.min;
        }
    };
    AbstractRecordModel.prototype.fieldCount = function (recordName, recordIndex, fieldName) {
        var schemaRecord = this.modelSchema.getRecord(recordName);
        var schemaField = schemaRecord.getField(fieldName);
        if (schemaField.isVariable) {
            var record = this.getRecord(schemaRecord, recordIndex);
            return record.length - schemaField.index;
        }
        else {
            return schemaField.min;
        }
    };
    AbstractRecordModel.prototype.getRecord = function (schemaRecord, index) {
        var model = this.model();
        return model[resolveRecordIndex(schemaRecord, model, index)];
    };
    AbstractRecordModel.prototype.parseKey = function (key) {
        var parts = key.split('.', 2);
        var recordName;
        var recordIndex;
        var fieldKey;
        if (parts.length === 1) {
            recordName = this.modelSchema.firstRecord().name;
            recordIndex = 0;
            fieldKey = parts[0];
        }
        else {
            var recordKeyParts = this.parseKeyPart(parts[0].trim());
            recordName = recordKeyParts[0];
            recordIndex = recordKeyParts[1];
            fieldKey = parts[1];
        }
        var keyParts = this.parseKeyPart(fieldKey);
        return {
            recordName: recordName,
            recordIndex: recordIndex,
            fieldName: keyParts[0],
            fieldIndex: keyParts[1]
        };
    };
    AbstractRecordModel.prototype.parseKeyPart = function (keyPart) {
        if (keyPart.length === 0) {
            throw new _$errors_280.IllegalArgumentError('No name specified');
        }
        var openIndex = keyPart.indexOf('(');
        if (openIndex === -1) {
            return [keyPart, 0];
        }
        if (openIndex === 0) {
            throw new _$errors_280.IllegalArgumentError('No name specified');
        }
        var closeIndex = keyPart.indexOf(')');
        if (closeIndex === -1 || closeIndex < openIndex) {
            throw new _$errors_280.IllegalArgumentError('\'(\' found without closing \')\'');
        }
        if (closeIndex < keyPart.length - 1) {
            throw new _$errors_280.IllegalArgumentError('Characters found after closing \')\'');
        }
        return [keyPart.substring(0, openIndex), parseInt(keyPart.substring(openIndex + 1, closeIndex), 10)];
    };
    return AbstractRecordModel;
}());
_$abstractRecordModel_337.AbstractRecordModel = AbstractRecordModel;

var _$fieldImpl_347 = {};
"use strict";
Object.defineProperty(_$fieldImpl_347, "__esModule", { value: true });
_$fieldImpl_347.normalise = _$fieldImpl_347.FieldImpl = _$fieldImpl_347.Type = void 0;
;
var Type;
(function (Type) {
    Type["DECIMAL"] = "DECIMAL";
    Type["INTEGER"] = "INTEGER";
    Type["STRING"] = "STRING";
})(Type = _$fieldImpl_347.Type || (_$fieldImpl_347.Type = {}));
var FieldImpl =  (function () {
    function FieldImpl(name, type, min, max, index, scale) {
        this.name = name;
        this.type = type;
        this.min = min;
        this.max = max;
        this.scale = scale;
        this.index = index;
        this.isVariable = min !== max;
    }
    FieldImpl.prototype.getAbsoluteIndex = function (index) {
        if (index < 0 || this.max !== -1 && index > this.max - 1) {
            throw new _$errors_280.OutOfBoundsError("Invalid index '" + index + "' for field '" + this.name + "'");
        }
        return this.index + index;
    };
    FieldImpl.prototype.toString = function () {
        var ret = "Name=" + this.name + ", Type=" + this.type;
        if (this.min === this.max) {
            ret += ", Occurs=" + this.min;
        }
        else {
            ret += ", Min=" + this.min + ", Max=";
            if (this.max === -1) {
                ret += 'Unlimited';
            }
            else {
                ret += this.max;
            }
        }
        if (this.type === Type.DECIMAL) {
            ret += ", Scale=" + this.scale;
        }
        return "Field [" + ret + "]";
    };
    FieldImpl.prototype.modelValue = function () {
        switch (this.type) {
            case Type.DECIMAL:
                return decimalModelValue(this);
            case Type.INTEGER:
                return '0';
            case Type.STRING:
            default:
                return '';
        }
    };
    FieldImpl.prototype.toJSON = function () {
        var o = {
            name: this.name,
            type: this.type,
            min: this.min,
            max: this.max
        };
        if (this.type === Type.DECIMAL) {
            o.scale = this.scale;
        }
        return o;
    };
    return FieldImpl;
}());
_$fieldImpl_347.FieldImpl = FieldImpl;
function normalise(field, value) {
    switch (field.type) {
        case Type.DECIMAL:
            var f = parseFloat(value);
            if (Number.isNaN(f)) {
                throw new _$errors_280.SchemaViolationError("Invalid decimal value: '" + value + "'");
            }
            return f.toFixed(field.scale);
        case Type.INTEGER:
            var i = parseInt(value, 10);
            var s = i.toString();
            if (Number.isNaN(i) || value.indexOf('.') > -1) {
                throw new _$errors_280.SchemaViolationError("Invalid integer value: '" + value + "'");
            }
            return s;
        case Type.STRING:
            return value;
        default:
            return '';
    }
}
_$fieldImpl_347.normalise = normalise;
function decimalModelValue(field) {
    switch (field.scale) {
        case undefined:
        case 1:
            return '0.0';
        case 2:
            return '0.00';
        case 3:
            return '0.000';
        default:
            var ret = '0.';
            for (var i = 0; i < field.scale; ++i) {
                ret += '0';
            }
            return ret;
    }
}

var _$recordModelImpl_339 = {};
"use strict";
var ____extends_339 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ____values_339 = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(_$recordModelImpl_339, "__esModule", { value: true });
_$recordModelImpl_339.RecordModelImpl = void 0;
;
;
;
;
function validateModel(schema, model) {
    var e_1, _a;
    var modelSize = model.length;
    var lastRecord = schema.lastRecord();
    var lastIndex = lastRecord.index;
    var lastMax = lastRecord.max;
    if (lastMax !== -1 && modelSize > lastIndex + lastMax) {
        throw new _$errors_280.InvalidDataError("Too many occurrences of record '" + lastRecord.name + "'");
    }
    if (modelSize < lastIndex + lastRecord.min) {
        throw new _$errors_280.InvalidDataError('Too few record occurrences');
    }
    var schemaRecords = schema.records();
    try {
        for (var schemaRecords_1 = ____values_339(schemaRecords), schemaRecords_1_1 = schemaRecords_1.next(); !schemaRecords_1_1.done; schemaRecords_1_1 = schemaRecords_1.next()) {
            var schemaRecord = schemaRecords_1_1.value;
            var startIndex = schemaRecord.index;
            var min = schemaRecord.min;
            for (var i = startIndex; i < startIndex + min; ++i) {
                validateRecord(schemaRecord, i - startIndex, model[i]);
            }
            if (schemaRecord.isVariable) {
                for (var i = startIndex + min; i < modelSize; ++i) {
                    var index = i - startIndex;
                    validateRecord(schemaRecord, index, model[i]);
                }
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (schemaRecords_1_1 && !schemaRecords_1_1.done && (_a = schemaRecords_1.return)) _a.call(schemaRecords_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
}
function validateRecord(schemaRecord, recordIndex, record) {
    var e_2, _a;
    var recordSize = record.length;
    var lastField = schemaRecord.lastField();
    var lastMax = lastField.max;
    var lastIndex = lastField.index;
    if (lastMax !== -1 && recordSize > lastIndex + lastMax) {
        throw new _$errors_280.InvalidDataError("Too many occurrences of field '" + schemaRecord.name + "(" + recordIndex + ")." + lastField.name + "'");
    }
    if (recordSize < lastIndex + lastField.min) {
        throw new _$errors_280.InvalidDataError("Too few field occurrences in record '" + schemaRecord.name + "(" + recordIndex + ")'");
    }
    try {
        for (var _b = ____values_339(schemaRecord.fields), _c = _b.next(); !_c.done; _c = _b.next()) {
            var schemaField = _c.value;
            var startIndex = schemaField.index;
            var min = schemaField.min;
            for (var i = startIndex; i < startIndex + min; ++i) {
                validateField(schemaRecord, recordIndex, schemaField, i - startIndex, record[i]);
            }
            if (schemaField.isVariable) {
                for (var i = startIndex + min; i < recordSize; i++) {
                    var index = i - startIndex;
                    validateField(schemaRecord, recordIndex, schemaField, index, record[i]);
                }
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_2) throw e_2.error; }
    }
}
function validateField(schemaRecord, recordIndex, schemaField, index, value) {
    try {
        _$fieldImpl_347.normalise(schemaField, _$requireNonNull_759.requireNonNull(value, 'FieldData'));
    }
    catch (e) {
        throw new _$errors_280.InvalidDataError("Invalid value for field '" + schemaRecord.name + "(" + recordIndex + ")." + schemaField.name + "(" + index + ")");
    }
}
var RecordModelImpl =  (function (_super) {
    ____extends_339(RecordModelImpl, _super);
    function RecordModelImpl(recordV2Constructor, schema, recordData, validate) {
        var _this = _super.call(this, recordV2Constructor, schema) || this;
        if (validate) {
            validateModel(schema, recordData);
        }
        _this.recordData = recordData;
        return _this;
    }
    RecordModelImpl.prototype.model = function () {
        return Array.from(this.recordData);
    };
    return RecordModelImpl;
}(_$abstractRecordModel_337.AbstractRecordModel));
_$recordModelImpl_339.RecordModelImpl = RecordModelImpl;

var _$recordv2Parser_344 = {};
"use strict";
Object.defineProperty(_$recordv2Parser_344, "__esModule", { value: true });
_$recordv2Parser_344.parse = void 0;
;
;
function __parse_344(bytes, offset, length) {
    if (offset === void 0) { offset = 0; }
    if (length === void 0) { length = bytes.length; }
    if (length === 0) {
        return [];
    }
    if (length === 1 && bytes[offset] === _$recordv2Utils_345.RECORD_MU) {
        return [[]];
    }
    var records = [];
    var fields = [];
    var pos = offset;
    for (var i = offset; i < length; ++i) {
        if (bytes[i] === _$recordv2Utils_345.RECORD_DELIMITER) {
            processRecordDelimiter(bytes, records, pos, i, fields);
            pos = i + 1;
        }
        else if (bytes[i] === _$recordv2Utils_345.FIELD_DELIMITER) {
            addField(bytes, records, pos, i, fields);
            pos = i + 1;
        }
    }
    processEnd(bytes, records, pos, length, fields);
    return records;
}
_$recordv2Parser_344.parse = __parse_344;
function processRecordDelimiter(bytes, records, startPos, endPos, fields) {
    var written = false;
    if (startPos < endPos) {
        written = addField(bytes, records, startPos, endPos, fields);
    }
    else {
        if (startPos > 0 && bytes[startPos - 1] === _$recordv2Utils_345.FIELD_DELIMITER) {
            fields.push('');
        }
    }
    if (!written) {
        records.push(Array.from(fields));
    }
    fields.length = 0;
}
function processEnd(bytes, records, startPos, endPos, fields) {
    if (endPos > startPos) {
        addField(bytes, records, startPos, endPos, fields);
    }
    else {
        var endByte = bytes[endPos - 1];
        if (endByte === _$recordv2Utils_345.RECORD_DELIMITER) {
            records.push([]);
        }
        else if (endByte === _$recordv2Utils_345.FIELD_DELIMITER) {
            fields.push('');
        }
    }
    if (fields.length) {
        records.push(Array.from(fields));
    }
}
function addField(bytes, records, startPos, endPos, fields) {
    var len = endPos - startPos;
    if (fields.length === 0 && len === 1 && bytes[startPos] === _$recordv2Utils_345.FIELD_MU) {
        records.push(['']);
        return true;
    }
    else {
        fields.push(_$uint8array_762.uint8toUtf8(bytes, startPos, endPos));
    }
    return false;
}

var _$recordv2DeltaImpl_342 = {};
"use strict";
var ____extends_342 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$recordv2DeltaImpl_342, "__esModule", { value: true });
_$recordv2DeltaImpl_342.RecordV2DeltaImpl =  _$recordv2DeltaImpl_342.Type = _$recordv2DeltaImpl_342.NO_CHANGE =  void 0;
;
;
;
;
var NoChange =  (function (_super) {
    ____extends_342(NoChange, _super);
    function NoChange() {
        return _super.call(this, Uint8Array.from([])) || this;
    }
    NoChange.prototype.changes = function () {
        return [];
    };
    return NoChange;
}(_$bytesImpl_323.BytesImpl));
 void NoChange;
_$recordv2DeltaImpl_342.NO_CHANGE = new NoChange();
var __Type_342;
(function (Type) {
    Type["FIELD_CHANGED"] = "FIELD_CHANGED";
    Type["FIELDS_ADDED"] = "FIELDS_ADDED";
    Type["FIELDS_REMOVED"] = "FIELDS_REMOVED";
    Type["RECORDS_ADDED"] = "RECORDS_ADDED";
    Type["RECORDS_REMOVED"] = "RECORDS_REMOVED";
})(__Type_342 = _$recordv2DeltaImpl_342.Type || (_$recordv2DeltaImpl_342.Type = {}));
var ChangeImpl =  (function () {
    function ChangeImpl(type, recordName, recordIndex, fieldName, fieldIndex) {
        this.type = type;
        this.recordName = recordName;
        this.recordIndex = recordIndex;
        this.fieldName = fieldName;
        this.fieldIndex = fieldIndex;
        var key = recordName + "(" + recordIndex + ")";
        if (type !== __Type_342.RECORDS_REMOVED && type !== __Type_342.RECORDS_ADDED) {
            key += "." + fieldName + "(" + fieldIndex + ")";
        }
        this.key = key;
    }
    ChangeImpl.prototype.toString = function () {
        return this.type + " " + this.key;
    };
    return ChangeImpl;
}());
 void ChangeImpl;
var RecordV2DeltaImpl =  (function (_super) {
    ____extends_342(RecordV2DeltaImpl, _super);
    function RecordV2DeltaImpl(buffer, offset, length, recordChanges, fieldChanges) {
        if (offset === void 0) { offset = 0; }
        if (length === void 0) { length = buffer.length; }
        var _this = _super.call(this, buffer, offset, length) || this;
        _this.recordChanges = recordChanges;
        _this.fieldChanges = fieldChanges;
        return _this;
    }
    RecordV2DeltaImpl.prototype.changes = function (schema) {
        var _this = this;
        var data = _$recordv2Parser_344.parse(this.$buffer, this.$offset, this.$length);
        var recordIndex = 0;
        var changes = [];
        schema.records().forEach(function (schemaRecord) {
            if (data.length < recordIndex + schemaRecord.min) {
                throw new _$errors_280.SchemaViolationError("Insufficient records of type " + schemaRecord.name + " in delta for schema");
            }
            if (schemaRecord.isVariable) {
                recordIndex = _this.processVariableRecordChanges(schemaRecord, recordIndex, data, changes);
            }
            else {
                recordIndex = _this.processFixedRecordChanges(schemaRecord, recordIndex, data, changes);
            }
        });
        return changes;
    };
    RecordV2DeltaImpl.prototype.processFixedRecordChanges = function (schemaRecord, startIndex, data, changes) {
        var recordIndex = startIndex;
        for (var i = 0; i < schemaRecord.min; ++i) {
            this.processRecordChanges(recordIndex, schemaRecord, i, data[recordIndex], changes);
            recordIndex++;
        }
        return recordIndex;
    };
    RecordV2DeltaImpl.prototype.processVariableRecordChanges = function (schemaRecord, startIndex, data, changes) {
        var numberOfNewRecords = data.length;
        var maxAllowed = schemaRecord.max;
        if (maxAllowed !== -1 && numberOfNewRecords > startIndex + maxAllowed) {
            throw new _$errors_280.SchemaViolationError("Too many records of type " + schemaRecord.name + " in delta for schema");
        }
        var recordIndex = startIndex;
        var matchRecordCount = (this.recordChanges && this.recordChanges[0])
            ? this.recordChanges[1]
            : numberOfNewRecords;
        for (var varIndex = 0; recordIndex < matchRecordCount; recordIndex++, varIndex++) {
            this.processRecordChanges(recordIndex, schemaRecord, varIndex, data[recordIndex], changes);
        }
        if (this.recordChanges) {
            changes.push(new ChangeImpl(this.recordChanges[0] ? __Type_342.RECORDS_ADDED : __Type_342.RECORDS_REMOVED, schemaRecord.name, this.recordChanges[1] - startIndex, '', 0));
        }
        return recordIndex;
    };
    RecordV2DeltaImpl.prototype.processRecordChanges = function (dataRecordIndex, record, recordIndex, data, changes) {
        var _this = this;
        var fieldIndex = 0;
        record.fields.forEach(function (field) {
            if (field.isVariable) {
                fieldIndex = _this.processVariableFieldChanges(record, recordIndex, dataRecordIndex, field, fieldIndex, data, changes);
            }
            else {
                fieldIndex = _this.processFixedFieldChanges(record, recordIndex, field, fieldIndex, data, changes);
            }
        });
    };
    RecordV2DeltaImpl.prototype.processFixedFieldChanges = function (record, recordIndex, field, startIndex, data, changes) {
        var numberOfFields = data.length;
        var fieldIndex = startIndex;
        for (var i = 0; i < field.min; ++i) {
            if (fieldIndex >= numberOfFields) {
                throw new _$errors_280.SchemaViolationError("Insufficient fields of type " + field.name + " in delta for schema record " + record.name);
            }
            if (data[fieldIndex] !== '') {
                changes.push(new ChangeImpl(__Type_342.FIELD_CHANGED, record.name, recordIndex, field.name, i));
            }
            fieldIndex++;
        }
        return fieldIndex;
    };
    RecordV2DeltaImpl.prototype.processVariableFieldChanges = function (record, recordIndex, dataRecordIndex, field, startIndex, data, changes) {
        var numberOfFields = data.length;
        var fieldIndex = startIndex;
        if (numberOfFields < fieldIndex + field.min) {
            throw new _$errors_280.SchemaViolationError("Insufficient fields of type " + field.name + " in delta for schema record " + record.name);
        }
        var fChanges = this.fieldChanges[dataRecordIndex];
        var matchingFieldCount = fChanges ? fChanges[1] : numberOfFields;
        for (var varIndex = 0; fieldIndex < matchingFieldCount; fieldIndex++, varIndex++) {
            if (data[fieldIndex] !== '') {
                changes.push(new ChangeImpl(__Type_342.FIELD_CHANGED, record.name, recordIndex, field.name, varIndex));
            }
        }
        if (fChanges) {
            changes.push(new ChangeImpl(fChanges[0] ? __Type_342.FIELDS_ADDED : __Type_342.FIELDS_REMOVED, record.name, recordIndex, field.name, fChanges[1]));
        }
        return fieldIndex;
    };
    RecordV2DeltaImpl.prototype.toString = function () {
        return _$recordv2Utils_345.bytesToString(this.$buffer, this.$offset, this.$length);
    };
    return RecordV2DeltaImpl;
}(_$bytesImpl_323.BytesImpl));
_$recordv2DeltaImpl_342.RecordV2DeltaImpl = RecordV2DeltaImpl;

var _$recordv2Impl_343 = {};
"use strict";
var ____extends_343 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$recordv2Impl_343, "__esModule", { value: true });
_$recordv2Impl_343.RecordV2Impl = void 0;
;
;
;
;
;
;
;
;
;
;
var DiffResult =  (function () {
    function DiffResult() {
        this.delta = new _$bufferOutputStream_410.BufferOutputStream();
        this.changed = false;
        this.recordChanges = null;
        this.fieldChanges = {};
    }
    DiffResult.prototype.write = function (buffer, offset, length) {
        if (offset !== undefined && length !== undefined) {
            this.delta.writeMany(buffer, offset, length);
        }
        else {
            this.delta.write(buffer);
        }
    };
    DiffResult.prototype.getDelta = function () {
        return this.delta.getBuffer();
    };
    DiffResult.prototype.size = function () {
        return this.delta.count;
    };
    DiffResult.prototype.hasChanges = function () {
        return this.changed;
    };
    DiffResult.prototype.setChanged = function () {
        this.changed = true;
    };
    DiffResult.prototype.setRecordsChanged = function (added, index) {
        this.recordChanges = [added, index];
        this.changed = true;
    };
    DiffResult.prototype.getRecordChanges = function () {
        return this.recordChanges;
    };
    DiffResult.prototype.setFieldsAdded = function (recordIndex, fieldIndex) {
        this.fieldChanges[recordIndex] = [true, fieldIndex];
        this.changed = true;
    };
    DiffResult.prototype.setFieldsRemoved = function (recordIndex, fieldIndex) {
        this.fieldChanges[recordIndex] = [false, fieldIndex];
        this.changed = true;
    };
    DiffResult.prototype.getFieldChanges = function () {
        return this.fieldChanges;
    };
    return DiffResult;
}());
function diffRecords(oldBytes, oldOffset, oldLength, newBytes, newOffset, newLength) {
    var result = new DiffResult();
    var oldCount = _$recordv2Utils_345.recordCount(oldBytes, oldOffset, oldLength);
    var newCount = _$recordv2Utils_345.recordCount(newBytes, newOffset, newLength);
    var minCount = Math.min(oldCount, newCount);
    var oldStart = oldOffset;
    var oldEnd = oldOffset;
    var newStart = newOffset;
    var newEnd = newOffset;
    for (var i = 0; i < minCount; ++i) {
        oldEnd = _$recordv2Utils_345.findDelimiter(oldBytes, oldEnd, oldOffset + oldLength, _$recordv2Utils_345.RECORD_DELIMITER);
        newEnd = _$recordv2Utils_345.findDelimiter(newBytes, newEnd, newOffset + newLength, _$recordv2Utils_345.RECORD_DELIMITER);
        if (i > 0) {
            result.write(_$recordv2Utils_345.RECORD_DELIMITER);
        }
        diffRecord(i, oldBytes, oldStart, oldEnd - oldStart, newBytes, newStart, newEnd - newStart, result);
        oldStart = ++oldEnd;
        newStart = ++newEnd;
    }
    if (newCount !== oldCount) {
        if (newCount > oldCount) {
            result.write(newBytes, newStart - 1, newOffset + newLength - newStart + 1);
        }
        result.setRecordsChanged(newCount > oldCount, minCount);
    }
    return result;
}
function diffRecord(recordIndex, oldBytes, oldOffset, oldLength, newBytes, newOffset, newLength, result) {
    if (newLength === 0) {
        if (oldLength !== 0) {
            result.setFieldsRemoved(recordIndex, 0);
        }
        return;
    }
    if (_$recordv2Utils_345.recordIsSingleEmptyField(newBytes, newOffset, newLength)) {
        diffWhenNewIsSingleEmptyField(recordIndex, oldBytes, oldOffset, oldLength, result);
        return;
    }
    if (oldLength === 0) {
        result.write(newBytes, newOffset, newLength);
        result.setFieldsAdded(recordIndex, 0);
        return;
    }
    if (_$recordv2Utils_345.recordIsSingleEmptyField(oldBytes, oldOffset, oldLength)) {
        diffWhenOldIsSingleEmptyField(recordIndex, newBytes, newOffset, newLength, result);
        return;
    }
    diffRecordFields(recordIndex, oldBytes, oldOffset, oldLength, newBytes, newOffset, newLength, result);
}
function diffWhenNewIsSingleEmptyField(recordIndex, oldBytes, oldOffset, oldLength, result) {
    if (_$recordv2Utils_345.recordIsSingleEmptyField(oldBytes, oldOffset, oldLength)) {
        result.write(_$recordv2Utils_345.FIELD_MU);
    }
    else {
        var oldCount = _$recordv2Utils_345.fieldCount(oldBytes, oldOffset, oldLength);
        if (oldCount > 1) {
            result.setFieldsRemoved(recordIndex, 1);
        }
        result.write(_$recordv2Utils_345.EMPTY_FIELD);
        result.setChanged();
    }
}
function diffWhenOldIsSingleEmptyField(recordIndex, newBytes, newOffset, newLength, result) {
    var b = newBytes[newOffset];
    if (b === _$recordv2Utils_345.EMPTY_FIELD) {
        result.write(newBytes, newOffset + 1, newLength - 1);
    }
    else {
        result.write(newBytes, newOffset, newLength);
        if (b !== _$recordv2Utils_345.FIELD_DELIMITER) {
            result.setChanged();
        }
    }
    if (_$recordv2Utils_345.fieldCount(newBytes, newOffset, newLength) > 1) {
        result.setFieldsAdded(recordIndex, 1);
    }
}
function diffRecordFields(recordIndex, oldBytes, oldOffset, oldLength, newBytes, newOffset, newLength, result) {
    var oldCount = _$recordv2Utils_345.fieldCount(oldBytes, oldOffset, oldLength);
    var newCount = _$recordv2Utils_345.fieldCount(newBytes, newOffset, newLength);
    var same = Math.min(oldCount, newCount);
    var oldStart = oldOffset;
    var oldEnd = oldOffset;
    var newStart = newOffset;
    var newEnd = newOffset;
    var startSize = result.size();
    for (var i = 0; i < same; ++i) {
        oldEnd = _$recordv2Utils_345.findDelimiter(oldBytes, oldEnd, oldOffset + oldLength, _$recordv2Utils_345.FIELD_DELIMITER);
        newEnd = _$recordv2Utils_345.findDelimiter(newBytes, newEnd, newOffset + newLength, _$recordv2Utils_345.FIELD_DELIMITER);
        if (i > 0) {
            result.write(_$recordv2Utils_345.FIELD_DELIMITER);
        }
        diffField(oldBytes, oldStart, oldEnd - oldStart, newBytes, newStart, newEnd - newStart, result);
        oldStart = ++oldEnd;
        newStart = ++newEnd;
    }
    if (newCount !== oldCount) {
        if (newCount > oldCount) {
            result.write(newBytes, newStart - 1, newOffset + newLength - newStart + 1);
            result.setFieldsAdded(recordIndex, same);
        }
        else {
            result.setFieldsRemoved(recordIndex, same);
        }
    }
    if (newCount === 1 && startSize === result.size()) {
        result.write(_$recordv2Utils_345.FIELD_MU);
    }
}
function diffField(oldBytes, oldOffset, oldLength, newBytes, newOffset, newLength, result) {
    if (fieldsAreEqual(oldBytes, oldOffset, oldLength, newBytes, newOffset, newLength)) {
        return;
    }
    if (newLength === 0) {
        result.write(_$recordv2Utils_345.EMPTY_FIELD);
    }
    else {
        result.write(newBytes, newOffset, newLength);
    }
    result.setChanged();
}
function fieldsAreEqual(oldBytes, oldOffset, oldLength, newBytes, newOffset, newLength) {
    if (oldLength === newLength) {
        if (oldLength === 0 || fieldEquals(oldBytes, oldOffset, newBytes, newOffset, oldLength)) {
            return true;
        }
    }
    else if (oldLength === 1 && oldBytes[oldOffset] === _$recordv2Utils_345.EMPTY_FIELD && newLength === 0) {
        return true;
    }
    else if (newLength === 1 && newBytes[newOffset] === _$recordv2Utils_345.EMPTY_FIELD && oldLength === 0) {
        return true;
    }
    return false;
}
function fieldEquals(oldBytes, oldOffset, newBytes, newOffset, length) {
    for (var i = 0; i < length; ++i) {
        if (oldBytes[oldOffset + i] !== newBytes[newOffset + i]) {
            return false;
        }
    }
    return true;
}
function deltaForEmptyNewValue() {
    return new _$recordv2DeltaImpl_342.RecordV2DeltaImpl(Uint8Array.from([]), 0, 0, [false, 0], {});
}
function deltaForSingleEmptyRecordNewValue(oldRecordCount) {
    switch (oldRecordCount) {
        case 0:
            return new _$recordv2DeltaImpl_342.RecordV2DeltaImpl(Uint8Array.from([_$recordv2Utils_345.RECORD_MU]), 0, 1, [true, 0], {});
        case 1:
            return new _$recordv2DeltaImpl_342.RecordV2DeltaImpl(Uint8Array.from([_$recordv2Utils_345.RECORD_MU]), 0, 1, null, { 0: [false, 0] });
        default:
            return new _$recordv2DeltaImpl_342.RecordV2DeltaImpl(Uint8Array.from([_$recordv2Utils_345.RECORD_MU]), 0, 1, [false, 1], { 0: [false, 0] });
    }
}
function deltaForAllNewRecords(newBytes, newOffset, newLength) {
    return new _$recordv2DeltaImpl_342.RecordV2DeltaImpl(newBytes, newOffset, newLength, [true, 0], {});
}
function deltaForOldSingleEmptyRecord(newBytes, newOffset, newLength) {
    var newRecordCount = _$recordv2Utils_345.recordCount(newBytes, newOffset, newLength);
    if (newRecordCount === 1) {
        return new _$recordv2DeltaImpl_342.RecordV2DeltaImpl(newBytes, newOffset, newLength, null, { 0: [true, 0] });
    }
    else {
        return new _$recordv2DeltaImpl_342.RecordV2DeltaImpl(newBytes, newOffset, newLength, [true, 1], newBytes[0] === _$recordv2Utils_345.RECORD_DELIMITER ? {} : { 0: [true, 0] });
    }
}
function __fromValue_343(value) {
    if (value instanceof RecordV2Impl) {
        return value;
    }
    else if (_$uint8array_762.isUint8Array(value)) {
        return new RecordV2Impl(value);
    }
    else {
        throw new _$errors_280.SchemaViolationError("Unable to read RecordV2 value from: " + value);
    }
}
var RecordV2Impl =  (function (_super) {
    ____extends_343(RecordV2Impl, _super);
    function RecordV2Impl(buffer, offset, length) {
        if (offset === void 0) { offset = 0; }
        if (length === void 0) { length = buffer.length; }
        return _super.call(this, buffer, offset, length) || this;
    }
    RecordV2Impl.toString = function () {
        return 'RecordV2Impl';
    };
    RecordV2Impl.from = function (value) {
        return __fromValue_343(value);
    };
    RecordV2Impl.prototype.apply = function (delta) {
        return __BINARY_DELTA_TYPE_343.apply(this, delta);
    };
    RecordV2Impl.prototype.toString = function () {
        return JSON.stringify(this.asRecords());
    };
    RecordV2Impl.prototype.asRecords = function () {
        return _$recordv2Parser_344.parse(this.$buffer, this.$offset, this.$length);
    };
    RecordV2Impl.prototype.asFields = function () {
        return this.asRecords().reduce(function (fields, record) {
            return fields.concat(record);
        }, []);
    };
    RecordV2Impl.prototype.asModel = function (schema) {
        return new _$recordModelImpl_339.RecordModelImpl(RecordV2Impl, schema, this.asRecords(), false);
    };
    RecordV2Impl.prototype.asValidatedModel = function (schema) {
        return new _$recordModelImpl_339.RecordModelImpl(RecordV2Impl, schema, this.asRecords(), true);
    };
    RecordV2Impl.prototype.binaryDiff = function (original) {
        return __BINARY_DELTA_TYPE_343.diff(original, this);
    };
    RecordV2Impl.prototype.diff = function (original) {
        var oldBytes = original.$buffer;
        var oldOffset = original.$offset;
        var oldLength = original.$length;
        var newBytes = this.$buffer;
        var newOffset = this.$offset;
        var newLength = this.$length;
        if (newLength === 0) {
            if (oldLength === 0) {
                return _$recordv2DeltaImpl_342.NO_CHANGE;
            }
            return deltaForEmptyNewValue();
        }
        else if (_$recordv2Utils_345.isSingleEmptyRecord(newBytes, newOffset, newLength)) {
            if (_$recordv2Utils_345.isSingleEmptyRecord(oldBytes, oldOffset, oldLength)) {
                return _$recordv2DeltaImpl_342.NO_CHANGE;
            }
            return deltaForSingleEmptyRecordNewValue(_$recordv2Utils_345.recordCount(oldBytes, oldOffset, oldLength));
        }
        if (oldLength === 0) {
            return deltaForAllNewRecords(newBytes, newOffset, newLength);
        }
        else if (_$recordv2Utils_345.isSingleEmptyRecord(oldBytes, oldOffset, oldLength)) {
            return deltaForOldSingleEmptyRecord(newBytes, newOffset, newLength);
        }
        var result = diffRecords(oldBytes, oldOffset, oldLength, newBytes, newOffset, newLength);
        if (result.hasChanges()) {
            var delta = result.getDelta();
            return new _$recordv2DeltaImpl_342.RecordV2DeltaImpl(delta, 0, delta.length, result.getRecordChanges(), result.getFieldChanges());
        }
        else {
            return _$recordv2DeltaImpl_342.NO_CHANGE;
        }
    };
    return RecordV2Impl;
}(_$bytesImpl_323.BytesImpl));
_$recordv2Impl_343.RecordV2Impl = RecordV2Impl;
var __BINARY_DELTA_TYPE_343 = new _$binaryDeltaTypeImpl_320.BinaryDeltaTypeImpl(RecordV2Impl, __fromValue_343, _$function_750.identity);

var _$recordv2BuilderImpl_340 = {};
"use strict";
Object.defineProperty(_$recordv2BuilderImpl_340, "__esModule", { value: true });
_$recordv2BuilderImpl_340.RecordV2BuilderImpl = void 0;
;
;
var RecordV2BuilderImpl =  (function () {
    function RecordV2BuilderImpl() {
        this.records = [];
    }
    RecordV2BuilderImpl.prototype.addFields = function (field) {
        var fields = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            fields[_i - 1] = arguments[_i];
        }
        if (arguments.length > 1) {
            fields.unshift(field);
        }
        else {
            fields = field;
        }
        if (fields) {
            var current = this.records.length ? this.records[this.records.length - 1] : [];
            this.records[Math.max(this.records.length - 1, 0)] = current.concat(fields);
        }
        return this;
    };
    RecordV2BuilderImpl.prototype.addRecord = function (field) {
        var fields = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            fields[_i - 1] = arguments[_i];
        }
        if (arguments.length > 1) {
            fields.unshift(field);
        }
        else {
            fields = field;
        }
        if (fields) {
            this.records.push([].concat(fields));
        }
        else {
            this.records.push([]);
        }
        return this;
    };
    RecordV2BuilderImpl.prototype.clear = function () {
        this.records = [];
        return this;
    };
    RecordV2BuilderImpl.prototype.build = function () {
        return new _$recordv2Impl_343.RecordV2Impl(_$recordv2Writer_346.toBuffer(this.records));
    };
    return RecordV2BuilderImpl;
}());
_$recordv2BuilderImpl_340.RecordV2BuilderImpl = RecordV2BuilderImpl;

var _$recordImpl_348 = {};
"use strict";
Object.defineProperty(_$recordImpl_348, "__esModule", { value: true });
_$recordImpl_348.toJSON = _$recordImpl_348.RecordImpl = void 0;
;
var RecordImpl =  (function () {
    function RecordImpl(name, min, max, index, fields) {
        var _this = this;
        this.name = name;
        this.min = min;
        this.max = max;
        this.index = index;
        this.isVariable = min !== max;
        this.fields = fields;
        this.fieldsMap = {};
        fields.forEach(function (field) {
            _this.fieldsMap[field.name] = field;
        });
    }
    RecordImpl.prototype.getFields = function () {
        return [].concat(this.fields);
    };
    RecordImpl.prototype.getField = function (fieldName) {
        var field = this.fieldsMap[fieldName];
        if (field) {
            return field;
        }
        throw new _$errors_280.SchemaViolationError("Record '" + this.name + "' has no field named '" + fieldName + "'");
    };
    RecordImpl.prototype.lastField = function () {
        return this.fields[this.fields.length - 1];
    };
    RecordImpl.prototype.createModel = function () {
        var fields = [];
        this.fields.forEach(function (field) {
            for (var i = 0; i < field.min; ++i) {
                fields.push(field.modelValue());
            }
        });
        return fields;
    };
    RecordImpl.prototype.getAbsoluteIndex = function (index) {
        if (index < 0 || this.max !== -1 && index > this.max - 1) {
            throw new _$errors_280.IllegalArgumentError("Invalid index '" + index + "' for record '" + this.name + "'");
        }
        return this.index + index;
    };
    RecordImpl.prototype.toString = function () {
        var ret = "Name=" + this.name;
        if (this.min === this.max) {
            ret += ", Occurs=" + this.min;
        }
        else {
            ret += ", Min=" + this.min + ", Max=";
            if (this.max === -1) {
                ret += 'Unlimited';
            }
            else {
                ret += this.max;
            }
        }
        ret += ", Fields=" + this.fields;
        return "Record [" + ret + "]";
    };
    return RecordImpl;
}());
_$recordImpl_348.RecordImpl = RecordImpl;
function toJSON(record) {
    return {
        fields: record.fields.map(function (f) { return f.toJSON(); }),
        name: record.name,
        min: record.min,
        max: record.max
    };
}
_$recordImpl_348.toJSON = toJSON;

var _$mutableRecordModelImpl_338 = {};
"use strict";
var ____extends_338 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$mutableRecordModelImpl_338, "__esModule", { value: true });
_$mutableRecordModelImpl_338.MutableRecordModelImpl = void 0;
;
;
;
var MutableRecordModelImpl =  (function (_super) {
    ____extends_338(MutableRecordModelImpl, _super);
    function MutableRecordModelImpl(recordV2Constructor, schema) {
        var _this = _super.call(this, recordV2Constructor, schema) || this;
        _this.recordData = schema.createModel();
        return _this;
    }
    MutableRecordModelImpl.prototype.model = function () {
        return this.recordData;
    };
    MutableRecordModelImpl.prototype.set = function (recordName, recordIndexOrFieldNameOrValue, fieldNameOrValue, fieldIndex, value) {
        if (fieldIndex === void 0) { fieldIndex = 0; }
        var recordIndex;
        var fieldName;
        switch (arguments.length) {
            case 2:
                value = recordIndexOrFieldNameOrValue;
                var key = this.parseKey(recordName);
                recordName = key.recordName;
                recordIndex = key.recordIndex;
                fieldName = key.fieldName;
                fieldIndex = key.fieldIndex;
                break;
            case 3:
                value = fieldNameOrValue;
                fieldName = recordIndexOrFieldNameOrValue;
                recordIndex = 0;
                break;
            case 5:
                recordIndex = recordIndexOrFieldNameOrValue;
                fieldName = fieldNameOrValue;
                break;
            default:
                recordIndex = 0;
                fieldName = '';
        }
        var schemaRecord = this.schema().getRecord(recordName);
        var record = this.getRecord(schemaRecord, recordIndex);
        var schemaField = schemaRecord.getField(fieldName);
        record[_$abstractRecordModel_337.resolveFieldIndex(schemaField, record, fieldIndex)] = _$fieldImpl_347.normalise(schemaField, value);
        return this;
    };
    MutableRecordModelImpl.prototype.add = function (recordName, recordIndexOrValue) {
        var values = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            values[_i - 2] = arguments[_i];
        }
        var schemaRecord = this.schema().getRecord(recordName);
        var record;
        if (typeof recordIndexOrValue === 'number') {
            record = this.getRecord(schemaRecord, recordIndexOrValue);
        }
        else {
            values.unshift(recordIndexOrValue);
            if (!schemaRecord.isVariable) {
                record = this.getRecord(schemaRecord, Math.max(schemaRecord.max - 1, 0));
            }
            else if (this.recordData.length > schemaRecord.index) {
                record = this.recordData[this.recordData.length - 1];
            }
            else {
                throw new _$errors_280.SchemaViolationError("Variable record '" + schemaRecord.name + "' has no occurrences to add a field to");
            }
        }
        this.addValuesToRecord(schemaRecord, record, values);
        return this;
    };
    MutableRecordModelImpl.prototype.addRecord = function () {
        var schemaRecord = this.schema().lastRecord();
        if (!schemaRecord.isVariable) {
            throw new _$errors_280.SchemaViolationError("Record '" + schemaRecord.name + "' is not variable");
        }
        var max = schemaRecord.max;
        if (max !== -1 && this.recordData.length - schemaRecord.index >= max) {
            throw new _$errors_280.SchemaViolationError("Record '" + schemaRecord.name + "' already has maximum number of occurrences");
        }
        this.recordData.push(schemaRecord.createModel());
        return this;
    };
    MutableRecordModelImpl.prototype.removeRecord = function (index) {
        var schemaRecord = this.schema().lastRecord();
        if (!schemaRecord.isVariable) {
            throw new _$errors_280.SchemaViolationError("Record '" + schemaRecord.name + "' is not variable");
        }
        var actualIndex = _$abstractRecordModel_337.resolveRecordIndex(schemaRecord, this.recordData, index);
        if (this.recordData.length - schemaRecord.index - 1 < schemaRecord.min) {
            throw new _$errors_280.SchemaViolationError("Removing an occurrence of record '" + schemaRecord.name + "' would "
                + "violate the minimum number of occurrences");
        }
        this.recordData.splice(actualIndex, 1);
        return this;
    };
    MutableRecordModelImpl.prototype.removeField = function (recordName, recordIndex, fieldIndex) {
        var schemaRecord = this.schema().getRecord(recordName);
        var record = this.getRecord(schemaRecord, recordIndex);
        var schemaField = schemaRecord.lastField();
        if (!schemaField.isVariable) {
            throw new _$errors_280.SchemaViolationError("Field '" + schemaField.name + "' is not a variable field");
        }
        var actualFieldIndex = _$abstractRecordModel_337.resolveFieldIndex(schemaField, record, fieldIndex);
        if (record.length - schemaField.index - 1 < schemaField.min) {
            throw new _$errors_280.SchemaViolationError("Removing an occurrence of field '" + schemaField.name + "' would "
                + "violate the minimum number of occurrences");
        }
        record.splice(actualFieldIndex, 1);
        return this;
    };
    MutableRecordModelImpl.prototype.addValuesToRecord = function (schemaRecord, record, values) {
        var schemaField = schemaRecord.lastField();
        if (!schemaField.isVariable) {
            throw new _$errors_280.SchemaViolationError("Final field of record '" + schemaRecord.name + "' is not variable");
        }
        var max = schemaField.max;
        if (max !== -1) {
            var current = record.length - schemaField.index;
            if (current + values.length > max) {
                throw new _$errors_280.SchemaViolationError('Adding values would exceed maximum number of field occurrences');
            }
        }
        values.forEach(function (value) {
            record.push(_$fieldImpl_347.normalise(schemaField, value));
        });
    };
    return MutableRecordModelImpl;
}(_$abstractRecordModel_337.AbstractRecordModel));
_$mutableRecordModelImpl_338.MutableRecordModelImpl = MutableRecordModelImpl;

var _$schemaImpl_350 = {};
"use strict";
Object.defineProperty(_$schemaImpl_350, "__esModule", { value: true });
_$schemaImpl_350.SchemaImpl = void 0;
;
;
;
var SchemaImpl =  (function () {
    function SchemaImpl(recordV2Constructor, records) {
        var _this = this;
        this.recordsMap = {};
        this.recordV2Constructor = recordV2Constructor;
        this.recordsArray = records;
        records.forEach(function (record) {
            _this.recordsMap[record.name] = record;
        });
    }
    SchemaImpl.prototype.getRecord = function (name) {
        var record = this.recordsMap[name];
        if (record) {
            return record;
        }
        throw new _$errors_280.SchemaViolationError("Record '" + name + "' is not known");
    };
    SchemaImpl.prototype.getRecords = function () {
        return [].concat(this.recordsArray);
    };
    SchemaImpl.prototype.records = function () {
        return this.recordsArray;
    };
    SchemaImpl.prototype.firstRecord = function () {
        return this.recordsArray[0];
    };
    SchemaImpl.prototype.lastRecord = function () {
        return this.recordsArray[this.recordsArray.length - 1];
    };
    SchemaImpl.prototype.createMutableModel = function () {
        return new _$mutableRecordModelImpl_338.MutableRecordModelImpl(this.recordV2Constructor, this);
    };
    SchemaImpl.prototype.createModel = function () {
        var model = [];
        this.recordsArray.forEach(function (record) {
            var recordValue = record.createModel();
            if (record.min > 0) {
                for (var i = 0; i < record.min; ++i) {
                    model.push([].concat(recordValue));
                }
            }
        });
        return model;
    };
    SchemaImpl.prototype.asJSON = function () {
        return JSON.stringify({ records: this.recordsArray.map(_$recordImpl_348.toJSON) });
    };
    SchemaImpl.prototype.toString = function () {
        return "Schema [Records=" + this.recordsArray + "]";
    };
    return SchemaImpl;
}());
_$schemaImpl_350.SchemaImpl = SchemaImpl;

var _$schemaBuilderImpl_349 = {};
"use strict";
var ____values_349 = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(_$schemaBuilderImpl_349, "__esModule", { value: true });
_$schemaBuilderImpl_349.SchemaBuilderImpl = void 0;
;
;
;
;
;
function checkMultiplicity(name, min, max) {
    if (min < 0) {
        throw new _$errors_280.SchemaViolationError("'" + name + "' has invalid 'min' value '" + min + "'");
    }
    if (max !== -1 && (max < 1 || max < min)) {
        throw new _$errors_280.SchemaViolationError("'" + name + "' has invalid 'max' value '" + max + "'");
    }
}
function checkScale(name, scale) {
    if (scale < 1) {
        throw new _$errors_280.SchemaViolationError("'" + name + "' has invalid 'scale' value '" + scale + "'");
    }
}
var SchemaBuilderImpl =  (function () {
    function SchemaBuilderImpl(recordV2Constructor) {
        this.records = [];
        this.recordV2Constructor = recordV2Constructor;
    }
    SchemaBuilderImpl.prototype.record = function (name, min, max) {
        if (min === void 0) { min = 1; }
        if (max === void 0) { max = min; }
        checkMultiplicity(name, min, max);
        this.checkRecord(name);
        if (this.currentFields !== undefined) {
            this.addRecord();
        }
        this.currentName = name;
        this.currentMin = min;
        this.currentMax = max;
        this.currentFields = [];
        return this;
    };
    SchemaBuilderImpl.prototype.string = function (name, min, max) {
        if (min === void 0) { min = 1; }
        if (max === void 0) { max = min; }
        checkMultiplicity(name, min, max);
        this.checkField(name);
        this.currentFields.push(new _$fieldImpl_347.FieldImpl(name, _$fieldImpl_347.Type.STRING, min, max, this.fieldIndex()));
        return this;
    };
    SchemaBuilderImpl.prototype.integer = function (name, min, max) {
        if (min === void 0) { min = 1; }
        if (max === void 0) { max = min; }
        checkMultiplicity(name, min, max);
        this.checkField(name);
        this.currentFields.push(new _$fieldImpl_347.FieldImpl(name, _$fieldImpl_347.Type.INTEGER, min, max, this.fieldIndex()));
        return this;
    };
    SchemaBuilderImpl.prototype.decimal = function (name, scale, min, max) {
        if (min === void 0) { min = 1; }
        if (max === void 0) { max = min; }
        checkMultiplicity(name, min, max);
        checkScale(name, scale);
        this.checkField(name);
        this.currentFields.push(new _$fieldImpl_347.FieldImpl(name, _$fieldImpl_347.Type.DECIMAL, min, max, this.fieldIndex(), scale));
        return this;
    };
    SchemaBuilderImpl.prototype.build = function () {
        if (this.currentFields !== undefined) {
            this.addRecord();
        }
        if (this.records.length === 0) {
            throw new _$errors_280.SchemaViolationError('Schema has no records');
        }
        return new _$schemaImpl_350.SchemaImpl(this.recordV2Constructor, this.records);
    };
    SchemaBuilderImpl.prototype.fieldIndex = function () {
        var currentFields = this.currentFields;
        if (currentFields.length === 0) {
            return 0;
        }
        var lastField = currentFields[currentFields.length - 1];
        return lastField.index + lastField.max;
    };
    SchemaBuilderImpl.prototype.addRecord = function () {
        var currentFields = this.currentFields;
        if (currentFields.length === 0) {
            throw new _$errors_280.SchemaViolationError("No fields specified for record: '" + this.currentName + "'");
        }
        var index;
        if (this.records.length === 0) {
            index = 0;
        }
        else {
            var lastRecord = this.records[this.records.length - 1];
            index = lastRecord.index + lastRecord.max;
        }
        this.records.push(new _$recordImpl_348.RecordImpl(this.currentName, this.currentMin, this.currentMax, index, currentFields));
    };
    SchemaBuilderImpl.prototype.checkRecord = function (name) {
        var e_1, _a;
        _$requireNonNull_759.requireNonNull(name, 'name');
        if (name === this.currentName) {
            throw new _$errors_280.SchemaViolationError("Duplicate record name: '" + name + "'");
        }
        if (this.records.length) {
            try {
                for (var _b = ____values_349(this.records), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var record = _c.value;
                    if (name === record.name) {
                        throw new _$errors_280.SchemaViolationError("Duplicate record name: '" + name + "'");
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
        if (this.currentFields !== undefined && this.currentMin !== this.currentMax) {
            throw new _$errors_280.SchemaViolationError("Record '" + name + "' not allowed after variable multiplicity record: '" + this.currentName + "'");
        }
    };
    SchemaBuilderImpl.prototype.checkField = function (name) {
        var e_2, _a;
        _$requireNonNull_759.requireNonNull(name, 'name');
        if (this.currentFields === undefined) {
            throw new _$errors_280.SchemaViolationError("Cannot add field '" + name + "' as there is no current record");
        }
        if (this.currentFields.length) {
            try {
                for (var _b = ____values_349(this.currentFields), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var field = _c.value;
                    if (name === field.name) {
                        throw new _$errors_280.SchemaViolationError("Duplicate field name: '" + name + "'");
                    }
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_2) throw e_2.error; }
            }
            var lastField = this.currentFields[this.currentFields.length - 1];
            if (lastField.isVariable) {
                throw new _$errors_280.SchemaViolationError("Field '" + name + "' is not allowed after variable multiplicity field '" + lastField.name + "'");
            }
        }
    };
    return SchemaBuilderImpl;
}());
_$schemaBuilderImpl_349.SchemaBuilderImpl = SchemaBuilderImpl;

var _$schemaParser_351 = {};
"use strict";
Object.defineProperty(_$schemaParser_351, "__esModule", { value: true });
_$schemaParser_351.SchemaParser = void 0;
;
;
var SchemaParser =  (function () {
    function SchemaParser(recordV2Constructor) {
        this.recordV2Constructor = recordV2Constructor;
    }
    SchemaParser.prototype.parse = function (jsonString) {
        var builder = new _$schemaBuilderImpl_349.SchemaBuilderImpl(this.recordV2Constructor);
        var json;
        try {
            json = JSON.parse(jsonString);
        }
        catch (e) {
            throw new _$errors_280.SchemaParseError('Invalid Schema JSON string');
        }
        if (json.records === undefined) {
            throw new _$errors_280.SchemaParseError('Schema has no records');
        }
        try {
            json.records.forEach(function (record) {
                if (record.occurs !== undefined) {
                    builder.record(record.name, record.occurs);
                }
                else {
                    builder.record(record.name, record.min, record.max);
                }
                if (record.fields) {
                    record.fields.forEach(function (field) {
                        var min;
                        var max;
                        if (field.occurs !== undefined) {
                            min = field.occurs;
                            max = field.occurs;
                        }
                        else {
                            min = field.min;
                            max = field.max;
                        }
                        var type = field.type || 'STRING';
                        switch (type.toUpperCase()) {
                            case 'STRING':
                                builder.string(field.name, min, max);
                                break;
                            case 'INTEGER':
                                builder.integer(field.name, min, max);
                                break;
                            case 'DECIMAL':
                                var scale = field.scale || 2;
                                builder.decimal(field.name, scale, min, max);
                                break;
                            default:
                                throw new _$errors_280.SchemaParseError("Invalid field type value '" + type + "'");
                        }
                    });
                }
            });
            return builder.build();
        }
        catch (e) {
            if (e instanceof _$errors_280.SchemaParseError) {
                throw e;
            }
            else  if (e instanceof Error) {
                throw new _$errors_280.SchemaParseError(e.message);
            }
            else {
                throw new _$errors_280.SchemaParseError('Could not parse schema JSON string');
            }
        }
    };
    return SchemaParser;
}());
_$schemaParser_351.SchemaParser = SchemaParser;

var _$recordv2DatatypeImpl_341 = {};
"use strict";
var ____extends_341 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$recordv2DatatypeImpl_341, "__esModule", { value: true });
_$recordv2DatatypeImpl_341.RecordV2DataTypeImpl = void 0;
;
;
;
;
;
;
;
function defaultValidator() {
}
var RecordV2DataTypeImpl =  (function (_super) {
    ____extends_341(RecordV2DataTypeImpl, _super);
    function RecordV2DataTypeImpl(validator) {
        if (validator === void 0) { validator = defaultValidator; }
        var _this = _super.call(this, 'record_v2', _$recordv2Impl_343.RecordV2Impl, _$recordv2Impl_343.RecordV2Impl, _$recordv2Impl_343.RecordV2Impl.from, _$function_750.identity, [], true) || this;
        _this.RecordV2 = _$recordv2Impl_343.RecordV2Impl;
        _this.validator = validator;
        return _this;
    }
    RecordV2DataTypeImpl.prototype.from = function (value) {
        return _$recordv2Impl_343.RecordV2Impl.from(value);
    };
    RecordV2DataTypeImpl.prototype.validate = function (value) {
        this.validator(_$requireNonNull_759.requireNonNull(value, 'RecordV2 instance'));
    };
    RecordV2DataTypeImpl.prototype.parseSchema = function (json) {
        return new _$schemaParser_351.SchemaParser(_$recordv2Impl_343.RecordV2Impl).parse(json);
    };
    RecordV2DataTypeImpl.prototype.schemaBuilder = function () {
        return new _$schemaBuilderImpl_349.SchemaBuilderImpl(_$recordv2Impl_343.RecordV2Impl);
    };
    RecordV2DataTypeImpl.prototype.valueBuilder = function () {
        return new _$recordv2BuilderImpl_340.RecordV2BuilderImpl();
    };
    RecordV2DataTypeImpl.prototype.withSchema = function (schema) {
        return new RecordV2DataTypeImpl(function (value) {
            return value.asValidatedModel(schema);
        });
    };
    return RecordV2DataTypeImpl;
}(_$abstractDatatype_316.AbstractDataType));
_$recordv2DatatypeImpl_341.RecordV2DataTypeImpl = RecordV2DataTypeImpl;

var _$timeSeriesEvent_654 = {};
"use strict";
Object.defineProperty(_$timeSeriesEvent_654, "__esModule", { value: true });
_$timeSeriesEvent_654.EventImpl = void 0;
var EventImpl =  (function () {
    function EventImpl(metadata, originalEvent, value) {
        this.metadata = metadata;
        this.originalEvent = originalEvent;
        this.value = value;
        this.sequence = metadata.sequence;
        this.timestamp = metadata.timestamp;
        this.author = metadata.author;
        this.isEditEvent = !metadata.equals(originalEvent);
        this.isOriginalEvent = !this.isEditEvent;
    }
    EventImpl.create = function (metadata, originalEvent, value) {
        return new EventImpl(metadata, originalEvent, value);
    };
    EventImpl.prototype.withValue = function (newValue) {
        return new EventImpl(this.metadata, this.originalEvent, newValue);
    };
    EventImpl.prototype.equals = function (other) {
        if (other && other instanceof EventImpl) {
            return this.metadata.equals(other.metadata) &&
                this.originalEvent.equals(other.originalEvent) &&
                this.value === other.value;
        }
        return false;
    };
    EventImpl.prototype.toString = function () {
        var s = this.isEditEvent ? "Edit of [" + this.originalEvent + "]" : '';
        return s + "[" + this.metadata + "] " + this.value;
    };
    return EventImpl;
}());
_$timeSeriesEvent_654.EventImpl = EventImpl;

var _$timeSeriesEventMetadata_653 = {};
"use strict";
Object.defineProperty(_$timeSeriesEventMetadata_653, "__esModule", { value: true });
_$timeSeriesEventMetadata_653.EventMetadataImpl = void 0;
var EventMetadataImpl =  (function () {
    function EventMetadataImpl(sequence, timestamp, author) {
        this.sequence = sequence;
        this.timestamp = timestamp;
        this.author = author;
    }
    EventMetadataImpl.prototype.equals = function (other) {
        if (other && other instanceof EventMetadataImpl) {
            return this.sequence === other.sequence &&
                this.timestamp === other.timestamp &&
                this.author === other.author;
        }
        return false;
    };
    return EventMetadataImpl;
}());
_$timeSeriesEventMetadata_653.EventMetadataImpl = EventMetadataImpl;

var _$timeSeriesEventMetadataSerialiser_652 = {};
"use strict";
var ____extends_652 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$timeSeriesEventMetadataSerialiser_652, "__esModule", { value: true });
_$timeSeriesEventMetadataSerialiser_652.EventMetadataImplSerialiser =  void 0;
;
;
;
var EventMetadataImplSerialiserClass =  (function (_super) {
    ____extends_652(EventMetadataImplSerialiserClass, _super);
    function EventMetadataImplSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    EventMetadataImplSerialiserClass.prototype.read = function (input) {
        var sequence = _$codec_411.readInt64(input);
        var timestamp = _$codec_411.readInt64(input);
        var author = _$codec_411.readString(input);
        return new _$timeSeriesEventMetadata_653.EventMetadataImpl(sequence.toNumber(), timestamp.toNumber(), author);
    };
    EventMetadataImplSerialiserClass.prototype.write = function (output, metadata) {
        _$codec_411.writeInt64(output, metadata.sequence);
        _$codec_411.writeInt64(output, metadata.timestamp);
        _$codec_411.writeString(output, metadata.author);
    };
    return EventMetadataImplSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void EventMetadataImplSerialiserClass;
_$timeSeriesEventMetadataSerialiser_652.EventMetadataImplSerialiser = new EventMetadataImplSerialiserClass();

var _$topicPathUtils_739 = {};
"use strict";
Object.defineProperty(_$topicPathUtils_739, "__esModule", { value: true });
_$topicPathUtils_739.DescendantQualifier =  _$topicPathUtils_739.canonicalise = _$topicPathUtils_739.split = _$topicPathUtils_739.PATH_SEPARATOR = void 0;
_$topicPathUtils_739.PATH_SEPARATOR = '/';
function __split_739(path) {
    return path.split(_$topicPathUtils_739.PATH_SEPARATOR);
}
_$topicPathUtils_739.split = __split_739;
function canonicalise(path) {
    if (!path) {
        return '';
    }
    var l = path.length;
    var s = l > 0 && path.charAt(0) === _$topicPathUtils_739.PATH_SEPARATOR ? 1 : 0;
    var e = l > 1 && path.charAt(l - 1) === _$topicPathUtils_739.PATH_SEPARATOR ? 1 : 0;
    return path.substring(s, l - e);
}
_$topicPathUtils_739.canonicalise = canonicalise;
var DQ =  (function () {
    function DQ(descendants) {
        this.includesDescendants = descendants;
    }
    return DQ;
}());
 void DQ;
_$topicPathUtils_739.DescendantQualifier = Object.freeze({
    MATCH: new DQ(false),
    DESCENDANTS_OF_MATCH: new DQ(true),
    MATCH_AND_DESCENDANTS: new DQ(true)
});

var _$abstractTopicSelector_730 = {};
"use strict";
Object.defineProperty(_$abstractTopicSelector_730, "__esModule", { value: true });
_$abstractTopicSelector_730.AbstractTopicSelector = void 0;
;
var AbstractTopicSelector =  (function () {
    function AbstractTopicSelector(type, prefix, expression) {
        this.type = type;
        this.prefix = prefix;
        this.expression = expression;
    }
    AbstractTopicSelector.prototype.selects = function (topicPath) {
        var canonical = _$topicPathUtils_739.canonicalise(topicPath);
        return canonical.indexOf(this.prefix) === 0 && this.doSelects(canonical);
    };
    AbstractTopicSelector.prototype.toString = function () {
        return this.expression;
    };
    return AbstractTopicSelector;
}());
_$abstractTopicSelector_730.AbstractTopicSelector = AbstractTopicSelector;

var _$regex_758 = {};
"use strict";
Object.defineProperty(_$regex_758, "__esModule", { value: true });
_$regex_758.regex = void 0;
;
function regex(s, context) {
    if (context === void 0) { context = ''; }
    if (s === '') {
        throw new _$errors_280.IllegalArgumentError('Empty regular expression [' + context + ']');
    }
    try {
        var r_1 = new RegExp(s);
        return function (test) {
            var m = r_1.exec(test);
            return m && m[0] === test;
        };
    }
    catch (e) {
        throw new _$errors_280.IllegalArgumentError('Bad regular expression [' + e.message + ', ' + context + ']');
    }
}
_$regex_758.regex = regex;

var _$fullPathSelector_735 = {};
"use strict";
var ____extends_735 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$fullPathSelector_735, "__esModule", { value: true });
_$fullPathSelector_735.FullPathSelector = void 0;
;
;
;
;
var FullPathSelector =  (function (_super) {
    ____extends_735(FullPathSelector, _super);
    function FullPathSelector(components) {
        var _this = _super.call(this, components.type, components.prefix, components.expression) || this;
        _this.pattern = undefined;
        _this.qualifier = components.qualifier;
        if (!components.base) {
            throw new _$errors_280.IllegalArgumentError('Invalid full-path selector');
        }
        _this.base = components.base;
        return _this;
    }
    FullPathSelector.prototype.doSelects = function (topicPath) {
        if (!this.pattern) {
            switch (this.qualifier) {
                case _$topicPathUtils_739.DescendantQualifier.DESCENDANTS_OF_MATCH:
                    this.pattern = _$regex_758.regex(this.base + "/.+");
                    break;
                case _$topicPathUtils_739.DescendantQualifier.MATCH_AND_DESCENDANTS:
                    this.pattern = _$regex_758.regex(this.base + "(?:$|/.+)");
                    break;
                default:
                case _$topicPathUtils_739.DescendantQualifier.MATCH:
                    this.pattern = _$regex_758.regex(this.base);
                    break;
            }
        }
        return this.pattern(topicPath) === true;
    };
    return FullPathSelector;
}(_$abstractTopicSelector_730.AbstractTopicSelector));
_$fullPathSelector_735.FullPathSelector = FullPathSelector;

var _$topicSelector_777 = {};
"use strict";
Object.defineProperty(_$topicSelector_777, "__esModule", { value: true });
_$topicSelector_777.Type = _$topicSelector_777.Prefix = void 0;
var Prefix;
(function (Prefix) {
    Prefix["PATH"] = ">";
    Prefix["SPLIT_PATH_PATTERN"] = "?";
    Prefix["FULL_PATH_PATTERN"] = "*";
    Prefix["SELECTOR_SET"] = "#";
})(Prefix = _$topicSelector_777.Prefix || (_$topicSelector_777.Prefix = {}));
var __Type_777;
(function (Type) {
    Type["PATH"] = ">";
    Type["SPLIT_PATH_PATTERN"] = "?";
    Type["FULL_PATH_PATTERN"] = "*";
    Type["SELECTOR_SET"] = "#";
})(__Type_777 = _$topicSelector_777.Type || (_$topicSelector_777.Type = {}));

var _$pathSelector_736 = {};
"use strict";
var ____extends_736 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$pathSelector_736, "__esModule", { value: true });
_$pathSelector_736.PathSelector = void 0;
;
;
;
;
var PathSelector =  (function (_super) {
    ____extends_736(PathSelector, _super);
    function PathSelector(components) {
        var _this = this;
        var remainder = components.remainder;
        if (components.type === _$topicSelector_777.Type.PATH) {
            if (components.prefix === '') {
                throw new _$errors_280.IllegalArgumentError("Topic path must have at least one part: " + remainder);
            }
            if (components.prefix.indexOf('//') > -1) {
                throw new _$errors_280.IllegalArgumentError("Topic path contains empty part: " + remainder);
            }
        }
        _this = _super.call(this, components.type, components.prefix, components.expression) || this;
        _this.qualifier = components.qualifier;
        _this.path = components.prefix;
        return _this;
    }
    PathSelector.prototype.doSelects = function (topicPath) {
        var match = this.path === topicPath;
        var descendants = topicPath.indexOf(this.path + '/') === 0;
        switch (this.qualifier) {
            case _$topicPathUtils_739.DescendantQualifier.MATCH:
                return match;
            case _$topicPathUtils_739.DescendantQualifier.DESCENDANTS_OF_MATCH:
                return descendants;
            case _$topicPathUtils_739.DescendantQualifier.MATCH_AND_DESCENDANTS:
                return match || descendants;
            default:
                return false;
        }
    };
    return PathSelector;
}(_$abstractTopicSelector_730.AbstractTopicSelector));
_$pathSelector_736.PathSelector = PathSelector;

var _$selectorSet_737 = {};
"use strict";
var ____extends_737 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ____values_737 = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(_$selectorSet_737, "__esModule", { value: true });
_$selectorSet_737.SelectorSet = _$selectorSet_737.DELIMITER = void 0;
;
;
;
;
_$selectorSet_737.DELIMITER = '////';
function extractCommonPrefix(selectors) {
    var e_1, _a;
    if (selectors.length === 0) {
        return '';
    }
    var minimum = _$math_753.MAX_INT32;
    var prefixes = [];
    selectors.forEach(function (selector, i) {
        var part = _$topicPathUtils_739.split(selector.prefix);
        minimum = Math.min(minimum, part.length);
        prefixes[i] = part;
    });
    var composite = [];
    assembly: for (var j = 0; j < minimum; ++j) {
        var part = prefixes[0][j];
        try {
            for (var prefixes_1 = (e_1 = void 0, ____values_737(prefixes)), prefixes_1_1 = prefixes_1.next(); !prefixes_1_1.done; prefixes_1_1 = prefixes_1.next()) {
                var prefix = prefixes_1_1.value;
                if (part !== prefix[j]) {
                    break assembly;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (prefixes_1_1 && !prefixes_1_1.done && (_a = prefixes_1.return)) _a.call(prefixes_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        composite.push(part);
        composite.push(_$topicPathUtils_739.PATH_SEPARATOR);
    }
    return _$topicPathUtils_739.canonicalise(composite.join(''));
}
var SelectorSet =  (function (_super) {
    ____extends_737(SelectorSet, _super);
    function SelectorSet(selectors) {
        var _this = this;
        var expanded = [];
        selectors.forEach(function (selector) {
            if (selector instanceof SelectorSet) {
                selector.selectors.forEach(function (nested) {
                    expanded.push(nested);
                });
            }
            else {
                expanded.push(selector);
            }
        });
        var remainder = expanded.join(_$selectorSet_737.DELIMITER);
        var prefix = extractCommonPrefix(expanded);
        _this = _super.call(this, _$topicSelector_777.Type.SELECTOR_SET, prefix, _$topicSelector_777.Prefix.SELECTOR_SET + remainder) || this;
        _this.selectors = expanded;
        return _this;
    }
    SelectorSet.prototype.selects = function (topicPath) {
        var e_2, _a;
        try {
            for (var _b = ____values_737(this.selectors), _c = _b.next(); !_c.done; _c = _b.next()) {
                var selector = _c.value;
                if (selector.selects(topicPath)) {
                    return true;
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return false;
    };
    SelectorSet.prototype.doSelects = function (canonical) {
        return this.selects(canonical);
    };
    return SelectorSet;
}(_$abstractTopicSelector_730.AbstractTopicSelector));
_$selectorSet_737.SelectorSet = SelectorSet;

var _$splitPathSelector_738 = {};
"use strict";
var ____extends_738 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$splitPathSelector_738, "__esModule", { value: true });
_$splitPathSelector_738.SplitPathSelector = void 0;
;
;
;
;
var SplitPathSelector =  (function (_super) {
    ____extends_738(SplitPathSelector, _super);
    function SplitPathSelector(components) {
        var _this = _super.call(this, components.type, components.prefix, components.expression) || this;
        _this.patterns = undefined;
        _this.qualifier = components.qualifier;
        _this.parts = _$topicPathUtils_739.split(components.base);
        _this.parts.forEach(function (part) {
            if (!part) {
                throw new _$errors_280.IllegalArgumentError('Invalid split-path selector');
            }
        });
        return _this;
    }
    SplitPathSelector.prototype.doSelects = function (topicPath) {
        if (!this.patterns) {
            this.patterns = this.parts.map(function (p) { return _$regex_758.regex(p); });
        }
        var length = this.patterns.length;
        var parts = topicPath.split(_$topicPathUtils_739.PATH_SEPARATOR);
        switch (this.qualifier) {
            case _$topicPathUtils_739.DescendantQualifier.MATCH:
                if (parts.length !== length) {
                    return false;
                }
                break;
            case _$topicPathUtils_739.DescendantQualifier.DESCENDANTS_OF_MATCH:
                if (parts.length <= length) {
                    return false;
                }
                break;
            case _$topicPathUtils_739.DescendantQualifier.MATCH_AND_DESCENDANTS:
                if (parts.length < length) {
                    return false;
                }
                break;
        }
        for (var i = 0; i < length; ++i) {
            if (!this.patterns[i](parts[i])) {
                return false;
            }
        }
        return true;
    };
    return SplitPathSelector;
}(_$abstractTopicSelector_730.AbstractTopicSelector));
_$splitPathSelector_738.SplitPathSelector = SplitPathSelector;

var _$memoize_754 = {};
"use strict";
Object.defineProperty(_$memoize_754, "__esModule", { value: true });
_$memoize_754.memoize = void 0;
;
function memoize(f, cache, matcher) {
    if (cache === void 0) { cache = {}; }
    if (matcher === void 0) { matcher = _$function_750.identity; }
    var c = function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var a = matcher(args);
        var r = cache[a];
        if (r) {
            return r;
        }
        else {
            r = f.apply(f, args);
        }
        cache[a] = r;
        return r;
    };
    c._uncached = f;
    return c;
}
_$memoize_754.memoize = memoize;

var _$string_761 = {};
"use strict";
Object.defineProperty(_$string_761, "__esModule", { value: true });
_$string_761.collectionToString = _$string_761.stringToSet = _$string_761.escape =  _$string_761.split = void 0;
;
function __split_761(str, delim) {
    if (str === '') {
        return [];
    }
    var parts = [];
    var l = delim.length;
    var i = str.lastIndexOf(delim);
    while (i > -1) {
        parts.push(str.substring(i + l, str.length));
        str = str.substring(0, i);
        i = str.lastIndexOf(delim);
    }
    parts.push(str);
    return parts.reverse();
}
_$string_761.split = __split_761;
function isQuote(c) {
    return c === '\'' || c === '"';
}
function stringToArray(stringValue) {
    var arr = [];
    var part = '';
    var pos = 0;
    var escaped = false;
    OUTER_LOOP: for (; pos < stringValue.length; pos++) {
        var c = stringValue[pos];
        if (isQuote(c)) {
            pos++;
            part = '';
            escaped = false;
            for (; pos < stringValue.length; pos++) {
                var vc = stringValue[pos];
                if (escaped) {
                    part += vc;
                    escaped = false;
                }
                else if (vc === '\\') {
                    escaped = true;
                }
                else if (vc === c) {
                    arr.push(part);
                    continue OUTER_LOOP;
                }
                else {
                    part += vc;
                }
            }
            throw new _$errors_280.IllegalArgumentError('Mis-quoted input');
        }
    }
    return arr;
}
 void stringToArray;
function escape(s) {
    for (var i = 0; i < s.length; i++) {
        var ci = s.charAt(i);
        if (ci === '"' || ci === '\\' || ci === '\'') {
            var sb = '';
            for (var j = 0; j < s.length; j++) {
                var cj = s.charAt(j);
                switch (cj) {
                    case '\\':
                        sb += '\\\\';
                        break;
                    case '"':
                        sb += '\\"';
                        break;
                    case '\'':
                        sb += '\\\'';
                        break;
                    default:
                        sb += cj;
                        break;
                }
            }
            return sb;
        }
    }
    return s;
}
_$string_761.escape = escape;
function stringToSet(stringValue) {
    return new Set(stringToArray(stringValue));
}
_$string_761.stringToSet = stringToSet;
function collectionToString(values) {
    var arr = [];
    values.forEach(function (s) {
        arr.push('"' + escape(s) + '"');
    });
    return arr.join(',');
}
_$string_761.collectionToString = collectionToString;

var _$browser_275 = {};
var __process_275 = _$browser_275 = {};


var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
} ())
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        return setTimeout(fun, 0);
    }
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        return clearTimeout(marker);
    }
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var __queue_275 = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        __queue_275 = currentQueue.concat(__queue_275);
    } else {
        queueIndex = -1;
    }
    if (__queue_275.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = __queue_275.length;
    while(len) {
        currentQueue = __queue_275;
        __queue_275 = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = __queue_275.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

__process_275.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    __queue_275.push(new Item(fun, args));
    if (__queue_275.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
__process_275.title = 'browser';
__process_275.browser = true;
__process_275.env = {};
__process_275.argv = [];
__process_275.version = ''; 
__process_275.versions = {};

function __noop_275() {}

__process_275.on = __noop_275;
__process_275.addListener = __noop_275;
__process_275.once = __noop_275;
__process_275.off = __noop_275;
__process_275.removeListener = __noop_275;
__process_275.removeAllListeners = __noop_275;
__process_275.emit = __noop_275;
__process_275.prependListener = __noop_275;
__process_275.prependOnceListener = __noop_275;

__process_275.listeners = function (name) { return [] }

__process_275.binding = function (name) {
    throw new Error('process.binding is not supported');
};

__process_275.cwd = function () { return '/' };
__process_275.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
__process_275.umask = function() { return 0; };

var _$topicSelectorParser_740 = {};
(function (process){(function (){
"use strict";
Object.defineProperty(_$topicSelectorParser_740, "__esModule", { value: true });
_$topicSelectorParser_740.parseSelector = void 0;
;
;
;
;
;
;
;
;
;
;
var DQ = _$topicPathUtils_739.DescendantQualifier;
function parseSelector(expression) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    if (!expression) {
        throw new _$errors_280.IllegalArgumentError('Empty topic selector expression');
    }
    if (args.length > 0) {
        expression = [expression].concat(args);
    }
    if (expression instanceof Array) {
        var actual = expression.map(function (s) { return (s instanceof _$abstractTopicSelector_730.AbstractTopicSelector ? s : parseSelector(s)); });
        return new _$selectorSet_737.SelectorSet(actual);
    }
    if (typeof expression === 'string') {
        var components = getComponents(expression);
        if (isTopicPath(components)) {
            return new _$pathSelector_736.PathSelector(components);
        }
        switch (components.type) {
            case _$topicSelector_777.Type.SPLIT_PATH_PATTERN:
                return new _$splitPathSelector_738.SplitPathSelector(components);
            case _$topicSelector_777.Type.FULL_PATH_PATTERN:
                return new _$fullPathSelector_735.FullPathSelector(components);
            case _$topicSelector_777.Type.SELECTOR_SET:
                var parts = _$string_761.split(components.remainder, _$selectorSet_737.DELIMITER);
                var selectors = parts.map(function (e) { return parseSelector(e); });
                return new _$selectorSet_737.SelectorSet(selectors);
        }
    }
    if (expression instanceof _$abstractTopicSelector_730.AbstractTopicSelector) {
        return expression;
    }
    throw new _$errors_280.IllegalArgumentError('Topic selector expression must be a string or array');
}
function getComponents(expression) {
    var type = getType(expression);
    if (type === null) {
        expression = _$topicSelector_777.Prefix.PATH + expression;
        type = _$topicSelector_777.Type.PATH;
    }
    var remainder = expression.substring(1);
    var qualifier;
    var base;
    if (type === _$topicSelector_777.Type.PATH) {
        base = remainder;
        qualifier = DQ.MATCH;
    }
    else if (remainder[remainder.length - 1] === '/') {
        if (remainder[remainder.length - 2] === '/') {
            qualifier = DQ.MATCH_AND_DESCENDANTS;
            base = _$topicPathUtils_739.canonicalise(remainder.substring(0, remainder.length - 2));
        }
        else {
            qualifier = DQ.DESCENDANTS_OF_MATCH;
            base = _$topicPathUtils_739.canonicalise(remainder.substring(0, remainder.length - 1));
        }
    }
    else {
        base = _$topicPathUtils_739.canonicalise(remainder);
        qualifier = DQ.MATCH;
    }
    var prefix = (type === _$topicSelector_777.Type.PATH) ? _$topicPathUtils_739.canonicalise(remainder) : extractPrefixFromRegex(base);
    return {
        type: type,
        base: base,
        prefix: prefix,
        remainder: remainder,
        qualifier: qualifier,
        expression: type + remainder
    };
}
function isTopicPath(c) {
    if (c.type === _$topicSelector_777.Type.PATH) {
        return true;
    }
    if (c.type === _$topicSelector_777.Type.SELECTOR_SET || c.prefix === '') {
        return false;
    }
    return c.prefix === c.base;
}
function getType(expression) {
    switch (expression[0]) {
        case _$topicSelector_777.Prefix.PATH:
            return _$topicSelector_777.Type.PATH;
        case _$topicSelector_777.Prefix.SPLIT_PATH_PATTERN:
            return _$topicSelector_777.Type.SPLIT_PATH_PATTERN;
        case _$topicSelector_777.Prefix.FULL_PATH_PATTERN:
            return _$topicSelector_777.Type.FULL_PATH_PATTERN;
        case _$topicSelector_777.Prefix.SELECTOR_SET:
            return _$topicSelector_777.Type.SELECTOR_SET;
        case '$':
        case '%':
        case '&':
        case '<':
            throw new _$errors_280.IllegalArgumentError('Invalid expression type: ' + expression);
        default:
            return null;
    }
}
var metaChars = ['*', '.', '+', '?', '^', '$', '{', '}', '(', ')', '[', ']', '\\', '|'];
function normal(c) {
    return metaChars.indexOf(c) === -1;
}
function quoted() {
    return true;
}
function extractPrefixFromRegex(remainder) {
    var buffer = [];
    var composite = [];
    var validator = normal;
    for (var i = 0, l = remainder.length; i < l; ++i) {
        var char = remainder[i];
        if (char === '\\' && i < l - 1) {
            var next = remainder[i + 1];
            if (validator === normal) {
                i++;
                if (next === 'Q') {
                    validator = quoted;
                }
                else if ((next < 'a' || next > 'z') && (next < 'A' || next > 'Z')) {
                    buffer.push(next);
                }
                else {
                    buffer.length = 0;
                    break;
                }
            }
            else if (next === 'E') {
                i++;
                validator = normal;
            }
            else {
                buffer.push(char);
            }
        }
        else if (char === _$topicPathUtils_739.PATH_SEPARATOR) {
            composite.push(buffer.join(''));
            buffer.length = 0;
            buffer.push(char);
        }
        else if (validator(char)) {
            buffer.push(char);
        }
        else {
            buffer.length = 0;
            break;
        }
    }
    composite.push(buffer.join(''));
    return _$topicPathUtils_739.canonicalise(composite.join(''));
}
function memoizeMatcher(args) {
    return JSON.stringify(args);
}
var disableTopicCache = process && process.env && (process.env.DISABLE_TOPIC_CACHE === 'true');
var cachedParse = disableTopicCache ? parseSelector : _$memoize_754.memoize(parseSelector, {}, memoizeMatcher);
_$topicSelectorParser_740.parseSelector = cachedParse;

}).call(this)}).call(this,_$browser_275)
var _$sessionContextImpl_309 = {};
"use strict";
Object.defineProperty(_$sessionContextImpl_309, "__esModule", { value: true });
_$sessionContextImpl_309.sessionContext = void 0;
;
;
;
;
;
;
var datatypes_1 = _$datatypes_324({});
var __time_series_event_datatype_1_309 = _$timeSeriesEventDatatype_713({});
;
_$sessionContextImpl_309.sessionContext = {
    ErrorReason: _$errorReason_279.ErrorReason,
    TopicType: _$topicType_784.TopicType,
    TopicAddFailReasonEnum: _$topics_785.TopicAddFailReasonEnum,
    TopicSpecification: _$topicSpecification_783.TopicSpecification,
    TimeSeriesEventDataType: __time_series_event_datatype_1_309.TimeSeriesEventDataType,
    DataTypes: datatypes_1.DataTypes,
    AbstractDataType: _$abstractDatatype_316.AbstractDataType,
    parseSelector: _$topicSelectorParser_740.parseSelector,
    CloseReason: _$closeReason_296.CloseReasonImpl
};

var _$stream_354 = {};
"use strict";
var ____values_354 = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(_$stream_354, "__esModule", { value: true });
_$stream_354.StreamImpl = void 0;
var StreamImpl =  (function () {
    function StreamImpl(helper) {
        this.listeners = helper.getListeners();
        this.errorCallback = helper.getErrorCallback();
        this.closeCallback = helper.getCloseCallback();
    }
    StreamImpl.prototype.on = function (events, listener) {
        this.attach(events, listener);
        return this;
    };
    StreamImpl.prototype.off = function (events, listener) {
        this.remove(events, listener);
        return this;
    };
    StreamImpl.prototype.close = function (reason) {
        this.closeCallback(reason);
        return this;
    };
    StreamImpl.prototype.error = function (reason) {
        this.errorCallback(reason);
        return this;
    };
    StreamImpl.prototype.attach = function (key, value) {
        var e_1, _a;
        if (typeof key === 'object') {
            try {
                for (var _b = ____values_354(Object.keys(key)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var k = _c.value;
                    this.attach(k, key[k]);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
        else if (value) {
            if (!this.listeners.hasOwnProperty(key)) { 
                this.listeners[key] = [];
            }
            this.listeners[key].push(value);
        }
    };
    StreamImpl.prototype.remove = function (key, value) {
        var e_2, _a;
        if (typeof key === 'object') {
            try {
                for (var _b = ____values_354(Object.keys(key)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var k = _c.value;
                    this.remove(k, key[k]);
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
        else if (this.listeners.hasOwnProperty(key)) { 
            if (value) {
                this.listeners[key] = this.listeners[key].filter(function (e) {
                    return e !== value;
                });
            }
            else {
                this.listeners[key] = [];
            }
        }
    };
    return StreamImpl;
}());
_$stream_354.StreamImpl = StreamImpl;

var _$emitter_353 = {};
(function (process){(function (){
"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(_$emitter_353, "__esModule", { value: true });
_$emitter_353.Emitter = void 0;
;
;
;
var EmitterEventQueue =  (function () {
    function EmitterEventQueue() {
        this.pendingEvents = [];
        this.events = [];
        this.busy = false;
    }
    EmitterEventQueue.prototype.addEmitterEvent = function (event) {
        var _this = this;
        this.pendingEvents.push(event);
        if (!this.busy) {
            this.busy = true;
            process.nextTick(function () {
                _this.drainEmitterQueue();
            });
        }
    };
    EmitterEventQueue.prototype.drainEmitterQueue = function () {
        var e_1, _a;
        var _this = this;
        this.events = this.pendingEvents;
        this.pendingEvents = [];
        try {
            for (var _b = __values(this.events), _c = _b.next(); !_c.done; _c = _b.next()) {
                var event_1 = _c.value;
                try {
                    event_1();
                }
                catch (err) {  }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        if (this.pendingEvents.length > 0) {
            process.nextTick(function () {
                _this.drainEmitterQueue();
            });
        }
        else {
            this.busy = false;
        }
    };
    return EmitterEventQueue;
}());
var emitterEventQueue = new EmitterEventQueue();
var Emitter =  (function () {
    function Emitter(options) {
        var _this = this;
        this.listeners = {};
        this.closed = false;
        this.listener = function () { };
        if (options === undefined || options.stream === undefined) {
            var helper = {
                getListeners: function () {
                    return _this.listeners;
                },
                getErrorCallback: function () {
                    return _this.error.bind(_this);
                },
                getCloseCallback: function () {
                    return _this.close.bind(_this);
                }
            };
            this.stream = new _$stream_354.StreamImpl(helper);
        }
        else {
            this.stream = options.stream;
            if (options.listeners === undefined) {
                throw new _$errors_280.InternalError('Listeners must be defined when supplying a stream');
            }
            this.listeners = options.listeners;
        }
        if (options !== undefined && options.event !== undefined) {
            this.stream.on(options.event, options.callback);
        }
    }
    Emitter.create = function () {
        var listeners = {};
        var errorCallback = function () { };
        var closeCallback = function () { };
        return {
            getListeners: function () {
                return listeners;
            },
            getErrorCallback: function () {
                return function (err) {
                    errorCallback(err);
                };
            },
            getCloseCallback: function () {
                return function (reason) {
                    closeCallback(reason);
                };
            },
            emitter: function (stream) {
                var emitter = new Emitter({
                    stream: stream,
                    listeners: listeners
                });
                errorCallback = emitter.error.bind(emitter);
                closeCallback = emitter.close.bind(emitter);
                return emitter;
            }
        };
    };
    Emitter.prototype.emitUnsafe = function (event, args) {
        var _this = this;
        var dispatch = function (listener) {
            _$function_750.callWithArguments(listener, args || []);
        };
        emitterEventQueue.addEmitterEvent(function () {
            if (_this.listeners.hasOwnProperty(event)) {
                _this.listeners[event].forEach(dispatch);
            }
        });
        this.listener(event, args);
    };
    Emitter.prototype.emit = function (event) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.closed || !event) {
            return;
        }
        this.emitUnsafe(event, args);
    };
    Emitter.prototype.immediate = function (event) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (this.closed || !event) {
            return;
        }
        var dispatch = function (listener) {
            try {
                _$function_750.callWithArguments(listener, args || []);
            }
            catch (err) {  }
        };
        if (this.listeners.hasOwnProperty(event)) {
            this.listeners[event].forEach(dispatch);
        }
    };
    Emitter.prototype.error = function (reason) {
        if (this.closed) {
            return;
        }
        this.emitUnsafe('error', [reason]);
        this.close((reason) ? reason.message : undefined);
    };
    Emitter.prototype.close = function (reason) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.emitUnsafe('close', [reason]);
    };
    Emitter.prototype.listen = function (fn) {
        this.listener = fn;
    };
    Emitter.prototype.get = function () {
        return this.stream;
    };
    return Emitter;
}());
_$emitter_353.Emitter = Emitter;

}).call(this)}).call(this,_$browser_275)
var _$booleanSerialiser_424 = {};
"use strict";
Object.defineProperty(_$booleanSerialiser_424, "__esModule", { value: true });
_$booleanSerialiser_424.BooleanSerialiser =  void 0;
;
var BooleanSerialiserClass =  (function () {
    function BooleanSerialiserClass() {
    }
    BooleanSerialiserClass.prototype.read = function (bis) {
        return _$codec_411.readBoolean(bis);
    };
    BooleanSerialiserClass.prototype.write = function (bos, val) {
        _$codec_411.writeBoolean(bos, val);
    };
    return BooleanSerialiserClass;
}());
 void BooleanSerialiserClass;
_$booleanSerialiser_424.BooleanSerialiser = new BooleanSerialiserClass();

var _$byteEncodedEnumSerialiser_426 = {};
"use strict";
Object.defineProperty(_$byteEncodedEnumSerialiser_426, "__esModule", { value: true });
_$byteEncodedEnumSerialiser_426.write = _$byteEncodedEnumSerialiser_426.read = void 0;
;
;
function read(input, enumType) {
    var e = _$codec_411.readByte(input);
    if (enumType[e] === undefined) {
        throw new _$errors_280.IllegalArgumentError('Unable to decode enum value ' + e);
    }
    return enumType[enumType[e]];
}
_$byteEncodedEnumSerialiser_426.read = read;
function __write_426(output, val) {
    if (typeof val === 'number') {
        _$codec_411.writeByte(output, val);
    }
    else {
        _$codec_411.writeByte(output, val.id);
    }
}
_$byteEncodedEnumSerialiser_426.write = __write_426;

var _$sessionLockOptions_286 = {};
"use strict";
Object.defineProperty(_$sessionLockOptions_286, "__esModule", { value: true });
_$sessionLockOptions_286.SessionLockOptions = _$sessionLockOptions_286.SessionLockScope = void 0;
var SessionLockScope;
(function (SessionLockScope) {
    SessionLockScope[SessionLockScope["UNLOCK_ON_SESSION_LOSS"] = 0] = "UNLOCK_ON_SESSION_LOSS";
    SessionLockScope[SessionLockScope["UNLOCK_ON_CONNECTION_LOSS"] = 1] = "UNLOCK_ON_CONNECTION_LOSS";
})(SessionLockScope = _$sessionLockOptions_286.SessionLockScope || (_$sessionLockOptions_286.SessionLockScope = {}));
_$sessionLockOptions_286.SessionLockOptions = {
    SessionLockScope: SessionLockScope
};

var _$sessionLockAcquisition_635 = {};
"use strict";
Object.defineProperty(_$sessionLockAcquisition_635, "__esModule", { value: true });
_$sessionLockAcquisition_635.SessionLockAcquisition = void 0;
var SessionLockAcquisition =  (function () {
    function SessionLockAcquisition(lockName, sequence, scope) {
        this.lockName = lockName;
        this.sequence = sequence;
        this.scope = scope;
    }
    return SessionLockAcquisition;
}());
_$sessionLockAcquisition_635.SessionLockAcquisition = SessionLockAcquisition;

var _$sessionLockAcquisitionSerialiser_634 = {};
"use strict";
var ____extends_634 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$sessionLockAcquisitionSerialiser_634, "__esModule", { value: true });
_$sessionLockAcquisitionSerialiser_634.SessionLockAcquisitionSerialiser =  void 0;
;
;
;
;
;
var SessionLockAcquisitionSerialiserClass =  (function (_super) {
    ____extends_634(SessionLockAcquisitionSerialiserClass, _super);
    function SessionLockAcquisitionSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SessionLockAcquisitionSerialiserClass.prototype.read = function (bis) {
        var lockName = _$codec_411.readString(bis);
        var sequence = _$codec_411.readInt64(bis);
        var scope = _$byteEncodedEnumSerialiser_426.read(bis, _$sessionLockOptions_286.SessionLockScope);
        return new _$sessionLockAcquisition_635.SessionLockAcquisition(lockName, sequence, scope);
    };
    SessionLockAcquisitionSerialiserClass.prototype.write = function (bos, value) {
        _$codec_411.writeString(bos, value.lockName);
        _$codec_411.writeInt64(bos, value.sequence);
        _$byteEncodedEnumSerialiser_426.write(bos, value.scope);
    };
    return SessionLockAcquisitionSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void SessionLockAcquisitionSerialiserClass;
_$sessionLockAcquisitionSerialiser_634.SessionLockAcquisitionSerialiser = new SessionLockAcquisitionSerialiserClass();

var _$sessionLockRequestSerialiser_637 = {};
"use strict";
var ____extends_637 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$sessionLockRequestSerialiser_637, "__esModule", { value: true });
_$sessionLockRequestSerialiser_637.SessionLockRequestSerialiser =  void 0;
;
;
;
var SessionLockRequestSerialiserClass =  (function (_super) {
    ____extends_637(SessionLockRequestSerialiserClass, _super);
    function SessionLockRequestSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SessionLockRequestSerialiserClass.prototype.write = function (bos, value) {
        _$codec_411.writeString(bos, value.lockName);
        _$codec_411.writeInt64(bos, value.requestId);
        _$byteEncodedEnumSerialiser_426.write(bos, value.scope);
    };
    return SessionLockRequestSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void SessionLockRequestSerialiserClass;
_$sessionLockRequestSerialiser_637.SessionLockRequestSerialiser = new SessionLockRequestSerialiserClass();

var _$sessionLockServices_629 = {};
"use strict";
Object.defineProperty(_$sessionLockServices_629, "__esModule", { value: true });
_$sessionLockServices_629.RELEASE_SESSION_LOCK = _$sessionLockServices_629.ACQUIRE_SESSION_LOCK = void 0;
;
;
;
_$sessionLockServices_629.ACQUIRE_SESSION_LOCK = {
    id: 114,
    request: _$sessionLockRequestSerialiser_637.SessionLockRequestSerialiser,
    response: _$sessionLockAcquisitionSerialiser_634.SessionLockAcquisitionSerialiser
};
_$sessionLockServices_629.RELEASE_SESSION_LOCK = {
    id: 116,
    request: _$sessionLockAcquisitionSerialiser_634.SessionLockAcquisitionSerialiser,
    response: _$booleanSerialiser_424.BooleanSerialiser
};

var _$responseSuccess_760 = {};
"use strict";
Object.defineProperty(_$responseSuccess_760, "__esModule", { value: true });
_$responseSuccess_760.responseSuccess = void 0;
function responseSuccess(err, response) {
    return !err;
}
_$responseSuccess_760.responseSuccess = responseSuccess;

var _$sessionLock_388 = {};
"use strict";
var ____awaiter_388 = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var ____generator_388 = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(_$sessionLock_388, "__esModule", { value: true });
_$sessionLock_388.InternalSessionLocks =  void 0;
;
;
;
;
;
var __log_388 = _$logger_752.create('diffusion.locks.SessionLocks');
var SessionLockImpl =  (function () {
    function SessionLockImpl(acquisition, ownedSetter, unlockSessionLock) {
        var _this = this;
        this.owned = true;
        this.acquisition = acquisition;
        this.unlockSessionLock = unlockSessionLock;
        ownedSetter.setOwned = function (newOwned) {
            _this.owned = newOwned;
        };
    }
    SessionLockImpl.prototype.toString = function () {
        return "SessionLock [name=" + this.acquisition.lockName + ", sequence=" + this.acquisition.sequence + ", "
            + ("scope=" + this.acquisition.scope + ", owned=" + this.owned + "]");
    };
    SessionLockImpl.prototype.getName = function () {
        return this.acquisition.lockName;
    };
    SessionLockImpl.prototype.getSequence = function () {
        return this.acquisition.sequence;
    };
    SessionLockImpl.prototype.isOwned = function () {
        return this.owned;
    };
    SessionLockImpl.prototype.getScope = function () {
        return this.acquisition.scope;
    };
    SessionLockImpl.prototype.unlock = function () {
        if (this.owned) {
            this.owned = false;
            return this.unlockSessionLock(this.acquisition);
        }
        else {
            return Promise.resolve(false);
        }
    };
    return SessionLockImpl;
}());
 void SessionLockImpl;
var InternalSessionLocks =  (function () {
    function InternalSessionLocks(internal, internalFsm) {
        var _this = this;
        this.locks = {};
        this.nextRequestId = 0;
        this.serviceLocator = internal.getServiceLocator();
        this.ACQUIRE_SESSION_LOCK = this.serviceLocator.obtain(_$sessionLockServices_629.ACQUIRE_SESSION_LOCK);
        this.RELEASE_SESSION_LOCK = this.serviceLocator.obtain(_$sessionLockServices_629.RELEASE_SESSION_LOCK);
        var failoverDetectionCid = null;
        internalFsm.on('change', function (previous, current) { return ____awaiter_388(_this, void 0, void 0, function () {
            var releaseLock;
            var _this = this;
            return ____generator_388(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        releaseLock = function (v) {
                            v.ownedSetter.setOwned(false);
                            v.onRemoveLock();
                        };
                        if (!(current === _$internalSession_301.InternalSessionState.DISCONNECTED)) return [3 , 2];
                        Object.values(this.locks)
                            .filter(function (v) { return (v.lock.getScope() === _$sessionLockOptions_286.SessionLockScope.UNLOCK_ON_CONNECTION_LOSS); })
                            .forEach(releaseLock);
                        return [4 , internal.getConversationSet().newConversation({
                                onOpen: function () {
                                },
                                onResponse: function () {
                                    return true;
                                },
                                onDiscard: function () {
                                    Object.values(_this.locks).forEach(releaseLock);
                                    _this.locks = {};
                                }
                            })];
                    case 1:
                        failoverDetectionCid = _a.sent();
                        return [3 , 3];
                    case 2:
                        if (current === _$internalSession_301.InternalSessionState.CONNECTED) {
                            if (failoverDetectionCid !== null) {
                                internal.getConversationSet().respondIfPresent(failoverDetectionCid, null);
                                failoverDetectionCid = null;
                            }
                        }
                        else if (current === _$internalSession_301.InternalSessionState.CLOSED) {
                            Object.values(this.locks).forEach(releaseLock);
                            this.locks = {};
                        }
                        _a.label = 3;
                    case 3: return [2 ];
                }
            });
        }); });
    }
    InternalSessionLocks.prototype.handleAcquisistion = function (lockName, acquisition, handler) {
        var oldLock = this.locks[lockName];
        var sessionLock;
        if (oldLock !== undefined) {
            if (!oldLock.lock.getSequence().equals(acquisition.sequence)) {
                oldLock.ownedSetter.setOwned(false);
                sessionLock = this.createLock(lockName, acquisition, handler);
            }
            else {
                sessionLock = oldLock.lock;
            }
        }
        else {
            sessionLock = this.createLock(lockName, acquisition, handler);
        }
        return sessionLock;
    };
    InternalSessionLocks.prototype.createLock = function (lockName, acquisition, handler) {
        var sessionLockOwnedSetter = {
            setOwned:  function () {
                throw Error('Session lock ownedSetter must be implemented');
            }
        };
        var sessionLock = new SessionLockImpl(acquisition, sessionLockOwnedSetter, this.unlock.bind(this));
        var lockInfo = handler
            ? {
                lock: sessionLock,
                ownedSetter: {
                    setOwned: function (newOwned) {
                        sessionLockOwnedSetter.setOwned(newOwned);
                        handler.onOwned(newOwned);
                    }
                },
                onRemoveLock: function () {
                    handler.onRemoveLock();
                }
            }
            : {
                lock: sessionLock,
                ownedSetter: sessionLockOwnedSetter,
                onRemoveLock: function () { }
            };
        this.locks[lockName] = lockInfo;
        return sessionLock;
    };
    InternalSessionLocks.prototype.unlock = function (acquisition) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            _this.RELEASE_SESSION_LOCK.send(acquisition, function (err, response) {
                if (err) {
                    __log_388.debug('Release session lock failed');
                    reject(err);
                }
                else {
                    if (_this.locks[acquisition.lockName] !== undefined
                        && _this.locks[acquisition.lockName].lock.getSequence().toString(10)
                            === acquisition.sequence.toString(10)) {
                        delete _this.locks[acquisition.lockName];
                    }
                    resolve(response);
                }
            });
        });
    };
    InternalSessionLocks.prototype.lock = function (lockName, scope, handler) {
        var _this = this;
        if (scope === void 0) { scope = _$sessionLockOptions_286.SessionLockScope.UNLOCK_ON_SESSION_LOSS; }
        return new Promise(function (resolve, reject) {
            if (_this.locks[lockName] !== undefined && _this.locks[lockName].lock.isOwned()) {
                if (handler) {
                    reject(new Error('Cannot register the same lock in different shared sessions'));
                }
                else {
                    resolve(_this.locks[lockName].lock);
                }
            }
            else {
                var requestId = _this.nextRequestId++;
                _this.ACQUIRE_SESSION_LOCK.send({
                    lockName: lockName, requestId: requestId, scope: scope
                }, function (err, acquisition) {
                    if (!_$responseSuccess_760.responseSuccess(err, acquisition)) {
                        __log_388.debug('Acquire session lock failed');
                        reject(err);
                    }
                    else {
                        var newLock = _this.handleAcquisistion(lockName, acquisition, handler);
                        resolve(newLock);
                    }
                });
            }
        });
    };
    return InternalSessionLocks;
}());
_$sessionLock_388.InternalSessionLocks = InternalSessionLocks;

var _$connectionRequest_413 = {};
"use strict";
Object.defineProperty(_$connectionRequest_413, "__esModule", { value: true });
_$connectionRequest_413.reconnect = _$connectionRequest_413.connect = void 0;
;
function connect() {
    return {
        type: _$consts_415.PROTOCOL.TYPE,
        version: _$consts_415.PROTOCOL.CURRENT_VERSION,
        capabilities: _$consts_415.PROTOCOL.CAPABILITIES
    };
}
_$connectionRequest_413.connect = connect;
function reconnect(token, availableClientSequence, lastServerSequence) {
    return Object.assign(connect(), {
        token: token,
        availableClientSequence: availableClientSequence,
        lastServerSequence: lastServerSequence
    });
}
_$connectionRequest_413.reconnect = reconnect;

var _$responseCode_416 = {};
"use strict";
Object.defineProperty(_$responseCode_416, "__esModule", { value: true });
_$responseCode_416.isSuccess = _$responseCode_416.responseCodes = void 0;
;
function __code_416(id, message) {
    return {
        id: id,
        message: message
    };
}
_$responseCode_416.responseCodes = {
    OK: __code_416(100, 'Connected successfully'),
    DOWNGRADE: __code_416(102, 'Server does not support the requested protocol level'),
    RECONNECTED: __code_416(105, 'Reconnected successfully'),
    RECONNECTED_WITH_MESSAGE_LOSS: __code_416(106, 'Reconnected with message loss'),
    LICENSE_EXCEEDED: __code_416(113, 'Connection rejected due to license limit'),
    RECONNECTION_UNSUPPORTED: __code_416(114, 'Reconnection not supported by connector'),
    CONNECTION_PROTOCOL_ERROR: __code_416(115, 'Connection failed - protocol error'),
    AUTHENTICATION_FAILED: __code_416(116, 'Connection failed - authentication failed'),
    UNKNOWN_SESSION: __code_416(117, 'Reconnection failed - the session is unknown'),
    RECONNECTION_FAILED_MESSAGE_LOSS: __code_416(118, 'Reconnection failed due to message loss'),
    REJECTED_SERVER_INITIALISING: __code_416(119, 'Connection rejected because the server is not ready')
};
_$enumerize_747.enumerize(_$responseCode_416.responseCodes);
function isSuccess(responseCode) {
    switch (responseCode) {
        case _$responseCode_416.responseCodes.OK:
        case _$responseCode_416.responseCodes.RECONNECTED:
        case _$responseCode_416.responseCodes.RECONNECTED_WITH_MESSAGE_LOSS:
            return true;
        default:
            return false;
    }
}
_$responseCode_416.isSuccess = isSuccess;

var _$array_746 = {};
"use strict";
Object.defineProperty(_$array_746, "__esModule", { value: true });
_$array_746.ofSize = _$array_746.fill = _$array_746.remove = void 0;
function remove(array, element) {
    var i = array.indexOf(element);
    if (i > -1) {
        array.splice(i, 1);
        return true;
    }
    return false;
}
_$array_746.remove = remove;
function __fill_746(array, value, start, end) {
    if (start === void 0) { start = 0; }
    if (end === void 0) { end = array.length; }
    for (var i = start; i < end; ++i) {
        array[i] = value;
    }
}
_$array_746.fill = __fill_746;
function ofSize(size, initialValue) {
    var a = [];
    a.length = size;
    if (initialValue !== undefined) {
        __fill_746(a, initialValue);
    }
    return a;
}
_$array_746.ofSize = ofSize;

var _$streamRegistry_417 = {};
"use strict";
Object.defineProperty(_$streamRegistry_417, "__esModule", { value: true });
_$streamRegistry_417.StreamRegistryImpl = void 0;
;
;
var StreamRegistryImpl =  (function () {
    function StreamRegistryImpl(topicCache) {
        this.streams = new Map();
        this.fallbacks = [];
        this.topicCache = topicCache;
    }
    StreamRegistryImpl.prototype.add = function (selector, stream) {
        var existing = this.streams.get(selector);
        if (existing) {
            existing.push(stream);
        }
        else {
            this.streams.set(selector, [stream]);
        }
        this.topicCache.newStream(selector, stream, this);
        stream.onOpen();
    };
    StreamRegistryImpl.prototype.addFallback = function (stream) {
        this.fallbacks.push(stream);
    };
    StreamRegistryImpl.prototype.getFallbacks = function (specification) {
        return this.fallbacks.filter(function (fallback) {
            return fallback.selects(specification);
        });
    };
    StreamRegistryImpl.prototype.remove = function (stream) {
        var _this = this;
        _$array_746.remove(this.fallbacks, stream);
        this.streams.forEach(function (existing, selector) {
            if (_$array_746.remove(existing, stream)) {
                _this.topicCache.removeStream(stream, _this);
            }
            if (existing.length === 0) {
                _this.streams.delete(selector);
            }
        });
    };
    StreamRegistryImpl.prototype.streamsFor = function (topic, specification) {
        var combined = [];
        this.streams.forEach(function (existing, selector) {
            if (selector.selects(topic)) {
                combined = combined.concat(existing
                    .filter(function (stream) {
                    return stream.selects(specification);
                }).map(function (stream) {
                    return stream.adapter ? stream.adapter(specification) : stream;
                }));
            }
        });
        return combined;
    };
    StreamRegistryImpl.prototype.close = function () {
        this.topicCache.clear();
        this.streams.forEach(function (streamArray) {
            streamArray.forEach(function (stream) {
                stream.onSubscriptionError(_$errorReason_279.ErrorReason.SESSION_CLOSED);
            });
        });
        this.fallbacks.forEach(function (stream) {
            stream.onSubscriptionError(_$errorReason_279.ErrorReason.SESSION_CLOSED);
        });
    };
    return StreamRegistryImpl;
}());
_$streamRegistry_417.StreamRegistryImpl = StreamRegistryImpl;

var _$topicCacheEntry_419 = {};
"use strict";
Object.defineProperty(_$topicCacheEntry_419, "__esModule", { value: true });
_$topicCacheEntry_419.TopicCacheEntry = void 0;
;
;
;
var __log_419 = _$logger_752.create('TopicCacheEntry');
var TopicCacheEntry =  (function () {
    function TopicCacheEntry(streams, path, specification) {
        this.streams = streams;
        this.path = path;
        this.specification = specification;
    }
    TopicCacheEntry.prototype.proxies = function (specification, registry) {
        return (this.streams.length === 0)
            ? registry.getFallbacks(specification).map(function (stream) {
                return stream.adapter ? stream.adapter(specification) : stream;
            })
            : this.streams;
    };
    TopicCacheEntry.prototype.getTopicPath = function () {
        return this.path;
    };
    TopicCacheEntry.prototype.getTopicSpecification = function () {
        return this.specification;
    };
    TopicCacheEntry.prototype.notifyInitialSubscription = function (registry) {
        var _this = this;
        this.proxies(this.specification, registry).forEach(function (proxy) {
            proxy.onSubscription(_this.path, _this.specification);
        });
    };
    TopicCacheEntry.prototype.notifySubscription = function (stream) {
        stream.onSubscription(this.path, this.specification);
        this.notifyValueToNewStream(this.path, this.specification, stream);
    };
    TopicCacheEntry.prototype.notifyUnsubscription = function (reason, registry) {
        var _this = this;
        this.proxies(this.specification, registry).forEach(function (proxy) {
            proxy.onUnsubscription(_this.path, _this.specification, reason);
        });
    };
    TopicCacheEntry.prototype.notifyValue = function (oldContent, content, oldValue, newValue, registry) {
        var _this = this;
        this.proxies(this.specification, registry).forEach(function (proxy) {
            try {
                proxy.onValue(_this.path, _this.specification, oldContent, content, oldValue, newValue);
            }
            catch (err) {
                __log_419.error('Invalid data', err);
            }
        });
    };
    TopicCacheEntry.prototype.notifyDelta = function (oldContent, content, delta, oldValue, newValue, registry) {
        var _this = this;
        this.proxies(this.specification, registry).forEach(function (proxy) {
            proxy.onDelta(_this.path, _this.specification, oldContent, content, delta, oldValue, newValue);
        });
    };
    TopicCacheEntry.prototype.addStream = function (stream, registry) {
        var _this = this;
        if (this.streams.length === 0) {
            registry.getFallbacks(this.specification).forEach(function (fallback) {
                fallback.onUnsubscription(_this.path, _this.specification, _$topics_785.UnsubscribeReasonEnum.STREAM_CHANGE);
            });
        }
        if (this.streams.indexOf(stream) < 0) {
            this.streams.push(stream);
            this.notifySubscription(stream);
        }
    };
    TopicCacheEntry.prototype.removeStream = function (stream, registry) {
        var _this = this;
        _$array_746.remove(this.streams, stream);
        if (this.streams.length === 0) {
            registry.getFallbacks(this.specification).forEach(function (fallback) {
                try {
                    _this.notifySubscription(fallback);
                }
                catch (err) {
                    __log_419.error('Invalid data', err);
                }
            });
        }
    };
    TopicCacheEntry.prototype.removeAllStreams = function () {
        this.streams.length = 0;
    };
    return TopicCacheEntry;
}());
_$topicCacheEntry_419.TopicCacheEntry = TopicCacheEntry;

var _$topicCacheDatatypeEntry_418 = {};
"use strict";
var ____extends_418 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$topicCacheDatatypeEntry_418, "__esModule", { value: true });
_$topicCacheDatatypeEntry_418.DatatypeCacheEntry = void 0;
;
;
var DatatypeCacheEntry =  (function (_super) {
    ____extends_418(DatatypeCacheEntry, _super);
    function DatatypeCacheEntry(streams, path, specification, datatype) {
        var _this = _super.call(this, streams, path, specification) || this;
        _this.datatype = datatype;
        if (specification.properties) {
            if (specification.properties.DONT_RETAIN_VALUE) {
                _this.dontRetainValue = JSON.parse(specification.properties.DONT_RETAIN_VALUE);
            }
        }
        return _this;
    }
    DatatypeCacheEntry.prototype.handleValue = function (received, registry, errorHandler) {
        var oldValue = this.value;
        var oldContent = this.buffer || null;
        try {
            var newValue = this.datatype.readValue(received);
            this.notifyValue(oldContent, received, oldValue, newValue, registry);
            if (!this.dontRetainValue) {
                this.value = newValue;
                this.buffer = received;
            }
        }
        catch (e) {
            errorHandler(e);
        }
    };
    DatatypeCacheEntry.prototype.handleDelta = function (received, registry, errorHandler) {
        var oldValue = this.value;
        var oldContent = this.buffer || null;
        try {
            var deltaType = this.datatype.deltaType('binary');
            var delta = deltaType.readDelta(received);
            var _a = deltaType.applyImpl(oldValue, delta, this.buffer ? new _$bufferSlice_322.BufferSlice(this.buffer) : undefined), value = _a.value, cbor = _a.cbor;
            this.value = value;
            this.buffer = cbor.$buffer;
            this.notifyDelta(oldContent, cbor.$buffer, delta, oldValue, this.value, registry);
        }
        catch (e) {
            errorHandler(e);
        }
    };
    DatatypeCacheEntry.prototype.notifyValueToNewStream = function (path, specification, stream) {
        if (this.buffer) {
            stream.onValue(path, specification, null, this.buffer, null, this.value);
        }
    };
    return DatatypeCacheEntry;
}(_$topicCacheEntry_419.TopicCacheEntry));
_$topicCacheDatatypeEntry_418.DatatypeCacheEntry = DatatypeCacheEntry;

var _$topicCacheNoValueEntry_420 = {};
"use strict";
var ____extends_420 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$topicCacheNoValueEntry_420, "__esModule", { value: true });
_$topicCacheNoValueEntry_420.NoValueEntry = void 0;
;
var NoValueEntry =  (function (_super) {
    ____extends_420(NoValueEntry, _super);
    function NoValueEntry(streams, path, specification) {
        return _super.call(this, streams, path, specification) || this;
    }
    NoValueEntry.prototype.handleValue = function (received, registry) {
        this.notifyValue(null, received, null, received, registry);
    };
    NoValueEntry.prototype.handleDelta = function (received, registry) {
        this.notifyDelta(null, received, null, null, received, registry);
    };
    NoValueEntry.prototype.notifyValueToNewStream = function () {
    };
    return NoValueEntry;
}(_$topicCacheEntry_419.TopicCacheEntry));
_$topicCacheNoValueEntry_420.NoValueEntry = NoValueEntry;

var _$topicCacheTimeSeriesEntry_421 = {};
"use strict";
var ____extends_421 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$topicCacheTimeSeriesEntry_421, "__esModule", { value: true });
_$topicCacheTimeSeriesEntry_421.TimeSeriesCacheEntry = void 0;
;
var __time_series_event_datatype_1_421 = _$timeSeriesEventDatatype_713({});
var TimeSeriesCacheEntry =  (function (_super) {
    ____extends_421(TimeSeriesCacheEntry, _super);
    function TimeSeriesCacheEntry(streams, path, specification, datatype) {
        return _super.call(this, streams, path, specification, __time_series_event_datatype_1_421.TimeSeriesEventDataType.create(datatype)) || this;
    }
    return TimeSeriesCacheEntry;
}(_$topicCacheDatatypeEntry_418.DatatypeCacheEntry));
_$topicCacheTimeSeriesEntry_421.TimeSeriesCacheEntry = TimeSeriesCacheEntry;

var _$topicCache_422 = {};
"use strict";
var ____values_422 = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var ____read_422 = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(_$topicCache_422, "__esModule", { value: true });
_$topicCache_422.TopicCache = void 0;
;
;
;
;
;
;
var TopicCache =  (function () {
    function TopicCache(datatypes) {
        this.byPath = {};
        this.byId = {};
        this.datatypes = datatypes;
    }
    TopicCache.prototype.handleSubscription = function (info, registry) {
        var path = info.path;
        var streams = registry.streamsFor(path, info.specification);
        var entry;
        switch (info.specification.type) {
            case _$topicType_784.TopicType.JSON:
            case _$topicType_784.TopicType.BINARY:
            case _$topicType_784.TopicType.STRING:
            case _$topicType_784.TopicType.DOUBLE:
            case _$topicType_784.TopicType.INT64:
            case _$topicType_784.TopicType.RECORD_V2:
                var datatype = this.datatypes.get(info.specification.type);
                if (datatype === null) {
                    throw new _$errors_280.InternalError('Invalid topic type');
                }
                entry = new _$topicCacheDatatypeEntry_418.DatatypeCacheEntry(streams, path, info.specification, datatype);
                break;
            case _$topicType_784.TopicType.TIME_SERIES:
                var eventType = this.datatypes.get(info.specification.properties.TIME_SERIES_EVENT_VALUE_TYPE);
                if (eventType === null) {
                    throw new _$errors_280.InternalError('Invalid timeseries event type');
                }
                entry = new _$topicCacheTimeSeriesEntry_421.TimeSeriesCacheEntry(streams, path, info.specification, eventType);
                break;
            default:
                entry = new _$topicCacheNoValueEntry_420.NoValueEntry(streams, path, info.specification);
        }
        var oldByPath = this.byPath[path];
        this.byPath[path] = entry;
        if (oldByPath) {
            throw new _$errors_280.InternalError("Existing cache entry for " + path);
        }
        var oldById = this.byId[info.id];
        this.byId[info.id] = entry;
        if (oldById) {
            throw new _$errors_280.InternalError("Existing cache entry for " + info.id);
        }
        entry.notifyInitialSubscription(registry);
    };
    TopicCache.prototype.notifyUnsubscriptionOfAllTopics = function (registry) {
        for (var id in this.byId) {
            this.byId[id].notifyUnsubscription(_$topics_785.UnsubscribeReasonEnum.SUBSCRIPTION_REFRESH, registry);
        }
        this.byPath = {};
        this.byId = {};
    };
    TopicCache.prototype.handleValue = function (id, content, registry, handler) {
        var errorHandler = handler.getErrorHandler();
        var entry = this.byId[id];
        if (entry) {
            entry.handleValue(content, registry, errorHandler);
        }
        else {
            errorHandler(new _$errors_280.SessionError("Data loss on topic with ID: " + id + " - possibly due to reconnection"));
        }
    };
    TopicCache.prototype.handleDelta = function (id, delta, registry, handler) {
        var errorHandler = handler.getErrorHandler();
        var entry = this.byId[id];
        if (entry) {
            entry.handleDelta(delta, registry, errorHandler);
        }
        else {
            errorHandler(new _$errors_280.SessionError("Data loss on topic with ID: " + id + " - possibly due to reconnection"));
        }
    };
    TopicCache.prototype.handleUnsubscription = function (id, reason, registry) {
        var entry = this.byId[id];
        delete this.byId[id];
        if (entry) {
            var path = entry.getTopicPath();
            delete this.byPath[path];
            entry.notifyUnsubscription(reason, registry);
        }
    };
    TopicCache.prototype.newStream = function (selector, stream, registry) {
        var e_1, _a;
        try {
            for (var _b = ____values_422(Object.entries(this.byPath)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var _d = ____read_422(_c.value, 2), path = _d[0], entry = _d[1];
                var specification = entry.getTopicSpecification();
                if (selector.selects(path) && stream.selects(specification)) {
                    entry.addStream(stream.adapter ? stream.adapter(specification) : stream, registry);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    TopicCache.prototype.removeStream = function (stream, registry) {
        var e_2, _a;
        try {
            for (var _b = ____values_422(Object.values(this.byPath)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var entry = _c.value;
                entry.removeStream(stream, registry);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
    };
    TopicCache.prototype.removeAllStreams = function () {
        var e_3, _a;
        try {
            for (var _b = ____values_422(Object.getOwnPropertyNames(this.byPath)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var path = _c.value;
                this.byPath[path].removeAllStreams();
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_3) throw e_3.error; }
        }
    };
    TopicCache.prototype.clear = function () {
        this.byPath = {};
        this.byId = {};
    };
    return TopicCache;
}());
_$topicCache_422.TopicCache = TopicCache;

var _$headersTunnel_768 = {};
"use strict";
Object.defineProperty(_$headersTunnel_768, "__esModule", { value: true });
_$headersTunnel_768.cidFromHeaders = void 0;
;
;
function cidFromHeaders(headers) {
    if (!headers || headers.length === 0) {
        throw new _$errors_280.IOError('Empty headers, expected at least 1');
    }
    return _$conversationId_314.ConversationId.fromString(headers[headers.length - 1]);
}
_$headersTunnel_768.cidFromHeaders = cidFromHeaders;

var _$topicRouting_423 = {};
"use strict";
Object.defineProperty(_$topicRouting_423, "__esModule", { value: true });
_$topicRouting_423.TopicRouting = void 0;
;
;
;
var __log_423 = _$logger_752.create('V4 Client Routing');
var TopicRouting =  (function () {
    function TopicRouting(errorHandler, serviceAdapter, conversationSet, cache, registry) {
        this.errorHandler = errorHandler;
        this.serviceAdapter = serviceAdapter;
        this.conversationSet = conversationSet;
        this.cache = cache;
        this.registry = registry;
    }
    TopicRouting.prototype.route = function (message) {
        switch (message.type) {
            case _$message_769.types.FETCH_REPLY:
                var cid = _$headersTunnel_768.cidFromHeaders(message.headers);
                this.conversationSet.respondIfPresent(cid, message);
                break;
            case _$message_769.types.SERVICE_REQUEST:
            case _$message_769.types.SERVICE_RESPONSE:
            case _$message_769.types.SERVICE_ERROR:
                this.serviceAdapter.onMessage(message.type, message.getInputStream());
                break;
            case _$message_769.types.TOPIC_VALUE:
                this.cache.handleValue(message.id, message.data, this.registry, this.errorHandler);
                break;
            case _$message_769.types.TOPIC_DELTA:
                this.cache.handleDelta(message.id, message.data, this.registry, this.errorHandler);
                break;
            default:
                __log_423.debug('Unhandled V4 message: ' + message.type, message);
        }
    };
    TopicRouting.prototype.subscribe = function (info) {
        this.cache.handleSubscription(info, this.registry);
    };
    TopicRouting.prototype.unsubscribe = function (id, reason) {
        this.cache.handleUnsubscription(id, reason, this.registry);
    };
    return TopicRouting;
}());
_$topicRouting_423.TopicRouting = TopicRouting;

var _$sessionId_709 = {};
"use strict";
Object.defineProperty(_$sessionId_709, "__esModule", { value: true });
_$sessionId_709.SessionId = void 0;
;
;
var PADDING = '0000000000000000';
var SessionId =  (function () {
    function SessionId(server, value) {
        this.server = server;
        this.value = value;
    }
    SessionId.fromString = function (str) {
        var parts = str.split('-');
        var sessionId;
        if (parts.length !== 2) {
            throw new _$errors_280.IllegalArgumentError('SessionId must consist of two hexadecimal parts, joined with a \'-\'');
        }
        try {
            var server = _$Long_274.fromString(parts[0], false, 16);
            var value = _$Long_274.fromString(parts[1], false, 16);
            sessionId = new SessionId(server, value);
        }
        catch (e) {
            throw new _$errors_280.IllegalArgumentError('SessionId must consist of two hexadecimal parts, joined with a \'-\'');
        }
        return sessionId;
    };
    SessionId.validate = function (str) {
        if (_$Long_274.isLong(str.server)
            && _$Long_274.isLong(str.value)
            && str.toString !== undefined) {
            return str;
        }
        if (typeof str !== 'string' || str.length === 0 || str.indexOf('-') < 0 || str.indexOf(' ') >= 0) {
            return false;
        }
        try {
            return SessionId.fromString(str);
        }
        catch (e) {
            return false;
        }
    };
    SessionId.prototype.toString = function () {
        var server = PADDING + this.server.toUnsigned().toString(16);
        var client = PADDING + this.value.toUnsigned().toString(16);
        return (server.substr(server.length - 16) + '-' + client.substr(client.length - 16)).toLowerCase();
    };
    return SessionId;
}());
_$sessionId_709.SessionId = SessionId;

var _$sessionToken_712 = {};
"use strict";
Object.defineProperty(_$sessionToken_712, "__esModule", { value: true });
_$sessionToken_712.SessionToken = _$sessionToken_712.TOKEN_LENGTH = void 0;
;
_$sessionToken_712.TOKEN_LENGTH = 24;
var SessionToken =  (function () {
    function SessionToken(external) {
        this.external = external;
    }
    SessionToken.prototype.toString = function () {
        return _$uint8array_762.uint8ToAscii(this.external);
    };
    return SessionToken;
}());
_$sessionToken_712.SessionToken = SessionToken;

var _$sessionTokenDeserialiser_711 = {};
"use strict";
Object.defineProperty(_$sessionTokenDeserialiser_711, "__esModule", { value: true });
_$sessionTokenDeserialiser_711.readSessionToken = void 0;
;
function readSessionToken(input) {
    return new _$sessionToken_712.SessionToken(input.readMany(_$sessionToken_712.TOKEN_LENGTH));
}
_$sessionTokenDeserialiser_711.readSessionToken = readSessionToken;

var _$connectionResponseDeserialiser_414 = {};
"use strict";
var ____extends_414 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$connectionResponseDeserialiser_414, "__esModule", { value: true });
_$connectionResponseDeserialiser_414.deserialise =  _$connectionResponseDeserialiser_414.DeserialisationErrorReason = void 0;
;
;
;
;
;
;
;
var __log_414 = _$logger_752.create('Cascading');
var DeserialisationErrorReason;
(function (DeserialisationErrorReason) {
    DeserialisationErrorReason[DeserialisationErrorReason["UNRECOGNISED_PROTOCOL_BYTE"] = 0] = "UNRECOGNISED_PROTOCOL_BYTE";
    DeserialisationErrorReason[DeserialisationErrorReason["PROTOCOL_VERSION_MISMATCH"] = 1] = "PROTOCOL_VERSION_MISMATCH";
})(DeserialisationErrorReason = _$connectionResponseDeserialiser_414.DeserialisationErrorReason || (_$connectionResponseDeserialiser_414.DeserialisationErrorReason = {}));
var DeserialisationError =  (function (_super) {
    ____extends_414(DeserialisationError, _super);
    function DeserialisationError(message, reason) {
        var _this = _super.call(this, message) || this;
        _this.reason = reason;
        return _this;
    }
    return DeserialisationError;
}(Error));
 void DeserialisationError;
function deserialise(buffer) {
    var input = new _$bufferInputStream_409.BufferInputStream(buffer);
    var protocol = input.read();
    if (protocol !== _$consts_415.PROTOCOL.PROTOCOL_BYTE) {
        throw new DeserialisationError('Unrecognised protocol byte: ' + protocol, DeserialisationErrorReason.UNRECOGNISED_PROTOCOL_BYTE);
    }
    var version = input.read();
    if (version !== _$consts_415.PROTOCOL.CURRENT_VERSION) {
        __log_414.debug("Server responded with protocol version " + version + ". Client version is " + _$consts_415.PROTOCOL.CURRENT_VERSION + ".");
        if (version < _$consts_415.PROTOCOL.CURRENT_VERSION) {
            throw new DeserialisationError('Unrecognised protocol version: ' + version, DeserialisationErrorReason.PROTOCOL_VERSION_MISMATCH);
        }
        else {
            throw new DeserialisationError('Unsupported protocol version: ' + version, DeserialisationErrorReason.PROTOCOL_VERSION_MISMATCH);
        }
    }
    var responseCode = _$byteEncodedEnumSerialiser_426.read(input, _$responseCode_416.responseCodes);
    if (_$responseCode_416.isSuccess(responseCode)) {
        var sessionID = new _$sessionId_709.SessionId(input.readInt64(), input.readInt64());
        var sessionToken = _$sessionTokenDeserialiser_711.readSessionToken(input);
        var systemPingPeriod = input.readInt64();
        var recoverySequence = 0;
        var maximumMessageSize = -1;
        if (responseCode === _$responseCode_416.responseCodes.RECONNECTED) {
            recoverySequence = input.readInt32();
        }
        else {
            maximumMessageSize = input.readInt32();
        }
        return {
            response: responseCode,
            identity: sessionID,
            token: sessionToken,
            systemPingPeriod: systemPingPeriod,
            version: version,
            success: true,
            sequence: recoverySequence,
            maximumMessageSize: maximumMessageSize
        };
    }
    else {
        return {
            response: responseCode,
            version: version,
            identity: null,
            token: null,
            systemPingPeriod: null,
            success: false,
            sequence: 0,
            maximumMessageSize: -1
        };
    }
}
_$connectionResponseDeserialiser_414.deserialise = deserialise;

var _$parsing_741 = {};
"use strict";
Object.defineProperty(_$parsing_741, "__esModule", { value: true });
_$parsing_741.connectionResponse = void 0;
;
;
var __log_741 = _$logger_752.create('Parsing');
function connectionResponse(onHandshakeSuccess, onHandshakeError, message) {
    __log_741.trace('Received connection handshake response');
    try {
        return onHandshakeSuccess(_$connectionResponseDeserialiser_414.deserialise(message));
    }
    catch (e) {
        onHandshakeError(e);
        return null;
    }
}
_$parsing_741.connectionResponse = connectionResponse;

var _$_empty_2 = {};

var _$subtransports_742 = {};
"use strict";
Object.defineProperty(_$subtransports_742, "__esModule", { value: true });
_$subtransports_742.Subtransports = void 0;
;
;
var __log_742 = _$logger_752.create('Transports');
function websocketSubTransportFactoryProvider() {
    if (typeof WebSocket === 'function') {
        __log_742.debug('Using native websocket');
        return {
            factory: WebSocket,
            enabled: true,
            allowsOptions: false
        };
    }
    else  if (typeof _$_empty_2 === 'function') {
        __log_742.debug('Using Node WS library');
        return {
            factory: _$_empty_2,
            enabled: true,
            allowsOptions: true
        };
    }
    else {
        __log_742.debug('Websocket transport not available');
        return {
            enabled: false,
            allowsOptions: false
        };
    }
}
function xhrSubTransportFactoryProvider() {
    if (typeof XMLHttpRequest === 'function') {
        __log_742.debug('Using native XHR');
        return {
            factory: XMLHttpRequest,
            enabled: true,
            allowsOptions: false
        };
    }
    else {
        __log_742.debug('XHR transport not available');
        return {
            enabled: false,
            allowsOptions: false
        };
    }
}
_$subtransports_742.Subtransports = Object.freeze({
    WS: websocketSubTransportFactoryProvider(),
    XHR: xhrSubTransportFactoryProvider(),
    WEBSOCKET: websocketSubTransportFactoryProvider(),
    HTTP_POLLING: xhrSubTransportFactoryProvider()
});

var _$credentialsSerialiser_434 = {};
"use strict";
Object.defineProperty(_$credentialsSerialiser_434, "__esModule", { value: true });
_$credentialsSerialiser_434.write = _$credentialsSerialiser_434.read = void 0;
;
;
var __Type_434;
(function (Type) {
    Type[Type["NONE"] = 0] = "NONE";
    Type[Type["PLAIN"] = 1] = "PLAIN";
    Type[Type["CUSTOM"] = 2] = "CUSTOM";
})(__Type_434 || (__Type_434 = {}));
function __read_434(input) {
    var type = _$byteEncodedEnumSerialiser_426.read(input, __Type_434);
    switch (type) {
        case __Type_434.PLAIN:
            return _$codec_411.readString(input) || null;
        case __Type_434.CUSTOM:
            return _$codec_411.readBytes(input);
        case __Type_434.NONE:
        default:
            _$codec_411.readBytes(input);
            return null;
    }
}
_$credentialsSerialiser_434.read = __read_434;
function __write_434(output, credentials) {
    if (credentials !== null && credentials !== undefined) {
        if (typeof credentials === 'string') {
            _$byteEncodedEnumSerialiser_426.write(output, __Type_434.PLAIN);
            _$codec_411.writeString(output, credentials);
        }
        else {
            _$byteEncodedEnumSerialiser_426.write(output, __Type_434.CUSTOM);
            _$codec_411.writeBytes(output, credentials);
        }
    }
    else {
        _$byteEncodedEnumSerialiser_426.write(output, __Type_434.NONE);
        _$codec_411.writeInt32(output, 0);
    }
}
_$credentialsSerialiser_434.write = __write_434;

var _$credentialTunnel_767 = {};
"use strict";
Object.defineProperty(_$credentialTunnel_767, "__esModule", { value: true });
 _$credentialTunnel_767.encodeAsString = void 0;
;
;
;
;
function encodeAsString(password) {
    var bos = new _$bufferOutputStream_410.BufferOutputStream();
    _$credentialsSerialiser_434.write(bos, password);
    return bos.getBase64();
}
_$credentialTunnel_767.encodeAsString = encodeAsString;
function decodeAsString(s) {
    if (s) {
        var bis = new _$bufferInputStream_409.BufferInputStream(_$uint8array_762.uint8FromBase64(s));
        return _$credentialsSerialiser_434.read(bis);
    }
    else {
        return null;
    }
}
 void decodeAsString;

var _$ws_744 = {};
"use strict";
var ____extends_744 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ____assign_744 = (this && this.__assign) || function () {
    ____assign_744 = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return ____assign_744.apply(this, arguments);
};
Object.defineProperty(_$ws_744, "__esModule", { value: true });
_$ws_744.WSTransport = void 0;
;
;
;
;
;
var __log_744 = _$logger_752.create('Websocket transport');
function constructURI(req, opts) {
    var scheme = opts.secure ? 'wss' : 'ws';
    var uri = scheme + "://" + opts.host + ":" + opts.port + opts.path;
    uri += '?ty=' + req.type;
    uri += '&v=' + req.version;
    uri += '&ca=' + req.capabilities;
    uri += '&r=' + opts.reconnect.timeout;
    if (req.token) {
        uri += '&c=' + encodeURIComponent(req.token);
        uri += '&cs=' + req.availableClientSequence;
        uri += '&ss=' + req.lastServerSequence;
    }
    if (opts.properties) {
        uri += '&sp=' + encodeURIComponent(JSON.stringify(opts.properties));
    }
    if (opts.principal !== undefined) {
        uri += '&username=' + encodeURIComponent(opts.principal);
        uri += '&password=' + encodeURIComponent(_$credentialTunnel_767.encodeAsString(opts.credentials));
    }
    return uri;
}
var WSTransport =  (function (_super) {
    ____extends_744(WSTransport, _super);
    function WSTransport(opts, ws, allowsOptions) {
        var _this = this;
        var factory = _$emitter_353.Emitter.create();
        _this = _super.call(this, factory) || this;
        _this.emitter = factory.emitter(_this);
        _this.opts = opts;
        _this.ws = ws;
        _this.allowsOptions = allowsOptions;
        return _this;
    }
    WSTransport.prototype.handler = function (message) {
        if (message.data.length > this.opts.maxMessageSize) {
            this.emitter.error(new Error("Received message of size: " + message.data.length + ", "
                + ("exceeding max message size: " + this.opts.maxMessageSize)));
        }
        else {
            this.emitter.immediate('data', new Uint8Array(message.data));
        }
    };
    WSTransport.prototype.connect = function (req, handshake) {
        var _this = this;
        var extraOptions = {};
        if (this.opts.httpProxyAgent !== undefined) {
            if (!this.allowsOptions) {
                throw new _$errors_280.IllegalArgumentError('httpProxyAgent option is not allowed');
            }
            extraOptions.agent = this.opts.httpProxyAgent;
        }
        if (this.opts.tlsOptions !== undefined) {
            if (!this.allowsOptions) {
                throw new _$errors_280.IllegalArgumentError('tlsOptions option are not allowed');
            }
            extraOptions = ____assign_744(____assign_744({}, extraOptions), this.opts.tlsOptions);
        }
        try {
            var uri = constructURI(req, this.opts);
            this.socket = (Object.keys(extraOptions).length === 0)
                ? new this.ws(uri)
                : new this.ws(uri, extraOptions);
            __log_744.debug('Created websocket', uri);
        }
        catch (error) {
            throw new _$errors_280.RuntimeError("Unable to construct WebSocket " + error);
        }
        this.socket.binaryType = 'arraybuffer';
        this.socket.onmessage = function (msg) {
            _this.socket.onmessage = _this.handler.bind(_this);
            _this.socket.onerror = function (err) {
                _this.emitter.error(err);
            };
            handshake(new Uint8Array(msg.data));
        };
        this.socket.onclose = function (reason) {
            _this.emitter.close(reason);
        };
        this.socket.onerror = function (err) {
            _this.emitter.close(err);
        };
    };
    WSTransport.prototype.dispatch = function (message) {
        __log_744.debug('Sending websocket message', message);
        try {
            this.socket.send(message);
            return true;
        }
        catch (err) {
            __log_744.error('Websocket send error', err);
            return false;
        }
    };
    WSTransport.prototype.close = function () {
        var _this = this;
        __log_744.debug('Closing websocket');
        if (this.socket !== undefined) {
            try {
                this.socket.onerror = function (err) {
                    _this.emitter.close(err);
                };
                this.socket.close(1000);
            }
            catch (err) {
            }
        }
        return this;
    };
    return WSTransport;
}(_$stream_354.StreamImpl));
_$ws_744.WSTransport = WSTransport;

var _$queue_757 = {};
"use strict";
Object.defineProperty(_$queue_757, "__esModule", { value: true });
_$queue_757.Queue = void 0;
var Queue =  (function () {
    function Queue() {
        this.messages = [];
    }
    Queue.prototype.length = function () {
        return this.messages.length;
    };
    Queue.prototype.add = function (message) {
        this.messages.push(message);
    };
    Queue.prototype.drain = function () {
        return this.messages.splice(0, this.messages.length);
    };
    Queue.prototype.isEmpty = function () {
        return this.messages.length === 0;
    };
    return Queue;
}());
_$queue_757.Queue = Queue;

var _$xhr_745 = {};
"use strict";
var ____extends_745 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ____values_745 = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(_$xhr_745, "__esModule", { value: true });
_$xhr_745.XHRTransport = void 0;
;
;
;
;
;
;
;
;
;
;
var __log_745 = _$logger_752.create('XHR transport');
function __constructURI_745(req, opts) {
    var scheme = opts.secure ? 'https' : 'http';
    var uri = scheme + "://" + opts.host + ":" + opts.port + opts.path;
    var headers = {
        m: '0',
        ty: 'B',
        ca: req.capabilities,
        r: opts.reconnect.timeout,
        v: req.version
    };
    if (req.token !== undefined) {
        headers.c = req.token;
        headers.cs = req.availableClientSequence;
        headers.ss = req.lastServerSequence;
    }
    if (opts.properties) {
        headers.sp = encodeURIComponent(JSON.stringify(opts.properties));
    }
    if (opts.principal !== undefined) {
        headers.username = encodeURIComponent(opts.principal);
        headers.password = _$credentialTunnel_767.encodeAsString(opts.credentials);
    }
    return { uri: uri, headers: headers };
}
var XHRTransport =  (function (_super) {
    ____extends_745(XHRTransport, _super);
    function XHRTransport(opts, xhr) {
        var _this = this;
        var factory = _$emitter_353.Emitter.create();
        _this = _super.call(this, factory) || this;
        _this.emitter = factory.emitter(_this);
        _this.opts = opts;
        _this.protocolVersion = null;
        _this.pollSequence = 0;
        _this.pingSequence = 0;
        _this.pollRequest = null;
        _this.aborted = false;
        _this.isSending = false;
        _this.queue = new _$queue_757.Queue();
        _this.xhr = xhr;
        return _this;
    }
    XHRTransport.prototype.connect = function (req, handshake) {
        var _this = this;
        try {
            var url = __constructURI_745(req, this.opts);
            this.protocolVersion = url.headers.v;
            this.URI = url.uri;
            var request_1 = this.createRequest(url.headers, url.uri);
            __log_745.debug('Created XHR', url.uri);
            request_1.onreadystatechange = function () {
                if (request_1.readyState === 4) {
                    if (request_1.status === 200) {
                        var handShakeData = request_1.responseText;
                        var serverResponse = handshake(_$uint8array_762.uint8FromBinary(handShakeData));
                        if (!serverResponse) {
                            return;
                        }
                        _this.token = serverResponse.token;
                        var responseCode = serverResponse.response;
                        var isSuccesss = _$responseCode_416.isSuccess(responseCode);
                        if (isSuccesss) {
                            _this.poll();
                        }
                        else {
                            __log_745.debug(responseCode.id + ' - ' + responseCode.message);
                            _this.emitter.close();
                        }
                    }
                    else {
                        _this.emitter.close();
                    }
                }
            };
            request_1.send(null);
        }
        catch (error) {
            throw new _$errors_280.RuntimeError("Unable to create polling transport " + error);
        }
    };
    XHRTransport.prototype.close = function () {
        __log_745.trace('Closing XHR transport');
        if (this.pollRequest) {
            this.aborted = true;
            this.pollRequest.abort();
        }
        this.queue = new _$queue_757.Queue();
        this.emitter.close();
        return this;
    };
    XHRTransport.prototype.createRequest = function (headers, uri) {
        var e_1, _a;
        var request = new this.xhr();
        request.open('POST', uri, true);
        request.overrideMimeType('text/plain; charset=x-user-defined');
        try {
            for (var _b = ____values_745(Object.getOwnPropertyNames(headers)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var header = _c.value;
                try {
                    request.setRequestHeader(header, headers[header]);
                }
                catch (e) {
                    __log_745.warn("Can't set header " + header);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return request;
    };
    XHRTransport.prototype.poll = function () {
        var _this = this;
        var request = this.createRequest({
            m: '1',
            c: this.token,
            s: this.pollSequence++,
            v: this.protocolVersion
        }, this.URI);
        request.onreadystatechange = function () {
            if (request.readyState === 4) {
                if (request.getResponseHeader('diffusion-connection') === 'reconnect') {
                    _this.emitter.close();
                }
                else if (request.status === 200) {
                    if (!_this.aborted) {
                        _this.poll();
                    }
                    var data = request.responseText;
                    var bis = new _$bufferInputStream_409.BufferInputStream(_$uint8array_762.uint8FromBase64(data));
                    while (bis.pos !== bis.count) {
                        var length_1 = bis.readInt32();
                        if (length_1 > _this.opts.maxMessageSize) {
                            _this.emitter.error(new Error("Received message of size: " + length_1 + ", "
                                + ("exceeding max message size: " + _this.opts.maxMessageSize)));
                            return;
                        }
                        var typeAndEncoding = bis.read();
                        var body = bis.readMany(length_1);
                        var payload = new Uint8Array(body.length + 1); 
                        payload[0] = typeAndEncoding;
                        payload.set(body, 1);
                        _this.emitter.emit('data', payload);
                    }
                }
                else {
                    _this.emitter.close();
                }
            }
        };
        this.pollRequest = request;
        request.send(null);
    };
    XHRTransport.prototype.dispatch = function (message) {
        if (this.aborted) {
            return false;
        }
        this.queue.add(message);
        if (this.isSending) {
            return true;
        }
        this.flush();
        return undefined;
    };
    XHRTransport.prototype.flush = function () {
        var _this = this;
        if (this.queue.isEmpty()) {
            return;
        }
        var buffer = drainToBuffer(this.queue.drain());
        var request = this.createRequest({
            m: '2',
            c: this.token,
            s: this.pingSequence++,
            v: this.protocolVersion
        }, this.URI);
        request.onreadystatechange = function () {
            if (request.readyState === 4) {
                if (request.getResponseHeader('diffusion-connection') === 'reconnect') {
                    _this.emitter.close();
                }
                else if (request.status === 200) {
                    _this.isSending = false;
                    _this.flush();
                }
                else {
                    _this.emitter.close();
                }
            }
        };
        this.isSending = true;
        request.send(_$uint8array_762.uint8ToBase64(buffer));
    };
    return XHRTransport;
}(_$stream_354.StreamImpl));
_$xhr_745.XHRTransport = XHRTransport;
function drainToBuffer(messages) {
    var e_2, _a;
    var messagesBOS = new _$bufferOutputStream_410.BufferOutputStream();
    try {
        for (var messages_1 = ____values_745(messages), messages_1_1 = messages_1.next(); !messages_1_1.done; messages_1_1 = messages_1.next()) {
            var msg = messages_1_1.value;
            messagesBOS.writeInt32(msg.length - 1); 
            messagesBOS.writeMany(msg, 0, msg.length);
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (messages_1_1 && !messages_1_1.done && (_a = messages_1.return)) _a.call(messages_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return messagesBOS.getBuffer();
}

var _$transports_743 = {};
"use strict";
var ____extends_743 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ____assign_743 = (this && this.__assign) || function () {
    ____assign_743 = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return ____assign_743.apply(this, arguments);
};
var ____read_743 = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(_$transports_743, "__esModule", { value: true });
_$transports_743.Transports =  void 0;
;
;
;
;
;
;
;
;
;
var __log_743 = _$logger_752.create('Cascading');
var knownTransports = Object.freeze({
    WS: _$ws_744.WSTransport,
    XHR: _$xhr_745.XHRTransport,
    WEBSOCKET: _$ws_744.WSTransport,
    HTTP_POLLING: _$xhr_745.XHRTransport
});
function filterTransports(requestedTransports, subtransports) {
    return requestedTransports.filter(function (name) {
        return name && knownTransports.hasOwnProperty(name) && subtransports[name].enabled;
    });
}
function createTransport(subtransports, options, name) {
    var transport = knownTransports[name];
    var subtransport = subtransports[name];
    if (transport && subtransport && subtransport.enabled) {
        return new transport(options, subtransport.factory, subtransport.allowsOptions);
    }
    else {
        throw new _$errors_280.InternalError('Unknown transport name: ' + name);
    }
}
var CascadeDriver =  (function (_super) {
    ____extends_743(CascadeDriver, _super);
    function CascadeDriver(subtransports, opts, transports, cascadeNotifications) {
        var _this = this;
        var factory = _$emitter_353.Emitter.create();
        _this = _super.call(this, factory) || this;
        _this.emitter = factory.emitter(_this);
        _this.transports = transports;
        _this.remainingTransports = __spreadArray([], ____read_743(transports));
        _this.cascadeNotifications = cascadeNotifications;
        _this.name = null;
        _this.req = null;
        _this.responseReceived = false;
        _this.transportFactory = createTransport.bind(null, subtransports, opts);
        _this.transport = _this.selectTransport();
        _this.onData = _this.onData.bind(_this);
        _this.onClose = _this.onClose.bind(_this);
        _this.onError = _this.onError.bind(_this);
        _this.onConnectionResponse = _this.onConnectionResponse.bind(_this);
        _this.onParsingError = _this.onParsingError.bind(_this);
        _this.retryStrategy = ____assign_743({}, opts.retry);
        return _this;
    }
    CascadeDriver.prototype.onData = function (data) {
        this.emitter.immediate('data', data);
    };
    CascadeDriver.prototype.onClose = function (reason) {
        if (!this.responseReceived && this.cascade(true)) {
            return;
        }
        this.emitter.emit('close', reason);
    };
    CascadeDriver.prototype.onError = function (error) {
        this.emitter.emit('error', error);
    };
    CascadeDriver.prototype.onConnectionResponse = function (response) {
        this.responseReceived = true;
        return this.onHandshakeSuccess(response);
    };
    CascadeDriver.prototype.onParsingError = function (error) {
        this.responseReceived = true;
        if (!this.cascade()) {
            this.onHandshakeError(error);
        }
    };
    CascadeDriver.prototype.closeQuietly = function () {
        if (this.transport) {
            this.transport.off('data', this.onData);
            this.transport.off('close', this.onClose);
            this.transport.off('error', this.onError);
            this.transport.close();
            this.transport = null;
        }
    };
    CascadeDriver.prototype.selectTransport = function (suppressClose) {
        if (suppressClose === void 0) { suppressClose = false; }
        if (this.remainingTransports.length === 0) {
            this.name = null;
            this.transport = null;
            __log_743.debug('Transports exhausted');
            if (this.retryStrategy.attempts <= 0) {
                this.cascadeNotifications.emit('transports-exhausted');
                if (!suppressClose) {
                    this.emitter.emit('close');
                }
            }
            return null;
        }
        this.name = this.remainingTransports.shift();
        this.transport = this.transportFactory(this.name);
        __log_743.debug('Selecting transport', this.name);
        this.cascadeNotifications.emit('transport-selected', this.name);
        return this.transport;
    };
    CascadeDriver.prototype.internalConnect = function () {
        if (this.transport === null) {
            throw new _$errors_280.InternalError('Unable to connect when no transport is set');
        }
        this.responseReceived = false;
        __log_743.debug('Attempting to connect');
        this.cascadeNotifications.emit('cascading-connect');
        this.transport.on('data', this.onData);
        this.transport.on('close', this.onClose);
        this.transport.on('error', this.onError);
        try {
            this.transport.connect(this.req, _$parsing_741.connectionResponse.bind(null, this.onConnectionResponse, this.onParsingError));
        }
        catch (e) {
            if (!this.cascade()) {
                throw e;
            }
        }
        return true;
    };
    CascadeDriver.prototype.cascade = function (suppressClose) {
        var _this = this;
        this.closeQuietly();
        if (!this.selectTransport(suppressClose)) {
            if (this.retryStrategy.attempts !== _$math_753.MAX_SAFE_INTEGER &&
                --this.retryStrategy.attempts < 0) {
                return false;
            }
            this.remainingTransports = __spreadArray([], ____read_743(this.transports));
            if (this.selectTransport(suppressClose)) {
                setTimeout(function () {
                    _this.cascadeNotifications.emit('cascade');
                    _this.internalConnect();
                }, this.retryStrategy.interval);
                return true;
            }
            else {
                return false;
            }
        }
        this.cascadeNotifications.emit('cascade');
        return this.internalConnect();
    };
    CascadeDriver.prototype.connect = function (request, handshake, handshakeError) {
        this.req = request;
        this.onHandshakeSuccess = handshake;
        this.onHandshakeError = handshakeError;
        this.internalConnect();
    };
    CascadeDriver.prototype.dispatch = function (message) {
        if (this.transport === null) {
            throw new _$errors_280.InternalError('Unable to send message when no transport is set');
        }
        this.transport.dispatch(message);
    };
    CascadeDriver.prototype.close = function () {
        if (this.transport !== null) {
            this.responseReceived = true; 
            this.transport.close();
            this.transport = null;
        }
        return this;
    };
    return CascadeDriver;
}(_$stream_354.StreamImpl));
 void CascadeDriver;
var Transports =  (function (_super) {
    ____extends_743(Transports, _super);
    function Transports(subtransports) {
        var _this = this;
        var factory = _$emitter_353.Emitter.create();
        _this = _super.call(this, factory) || this;
        _this.emitter = factory.emitter(_this);
        _this.subtransports = subtransports;
        return _this;
    }
    Transports.create = function (subtransports) {
        if (subtransports) {
            return new Transports(subtransports);
        }
        else {
            return new Transports(_$subtransports_742.Subtransports);
        }
    };
    Transports.prototype.get = function (options) {
        var validTransports = filterTransports(options.transports, this.subtransports);
        if (validTransports.length === 0) {
            __log_743.warn('No valid transports found');
            return null;
        }
        return new CascadeDriver(this.subtransports, options, validTransports, this.emitter);
    };
    return Transports;
}(_$stream_354.StreamImpl));
_$transports_743.Transports = Transports;

var _$fsm_749 = {};
"use strict";
var ____extends_749 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$fsm_749, "__esModule", { value: true });
_$fsm_749.FSM = void 0;
;
;
var FSM =  (function (_super) {
    ____extends_749(FSM, _super);
    function FSM(initial, states) {
        var _this = this;
        var factory = _$emitter_353.Emitter.create();
        _this = _super.call(this, factory) || this;
        _this.emitter = factory.emitter(_this);
        _this.states = states;
        _this.current = states[initial];
        _this.state = initial;
        return _this;
    }
    FSM.prototype.change = function (state) {
        if (this.state === state) {
            return true;
        }
        if (this.states[state] && (this.current === '*' || this.current.indexOf(state) > -1)) {
            this.emitter.emit('change', this.state, state);
            this.current = this.states[state];
            this.state = state;
            return true;
        }
        return false;
    };
    return FSM;
}(_$stream_354.StreamImpl));
_$fsm_749.FSM = FSM;

var _$version_770 = {};
"use strict";
Object.defineProperty(_$version_770, "__esModule", { value: true });
_$version_770.version = void 0;
_$version_770.version = '6.12.0';

var _$closeReason_277 = {};
"use strict";
Object.defineProperty(_$closeReason_277, "__esModule", { value: true });
_$closeReason_277.ClientCloseReason = _$closeReason_277.CloseReasonEnum = void 0;
;
;
_$closeReason_277.CloseReasonEnum = {
    CLOSED_BY_CLIENT: new _$closeReason_296.CloseReasonImpl(0, 'The session was closed by the client', false),
    CLOSED_BY_SERVER: new _$closeReason_296.CloseReasonImpl(1, 'The session was closed by the server', false),
    RECONNECT_ABORTED: new _$closeReason_296.CloseReasonImpl(2, 'Client aborted a reconnect attempt', false),
    CONNECTION_TIMEOUT: new _$closeReason_296.CloseReasonImpl(3, 'The connection attempt timed out', false),
    HANDSHAKE_REJECTED: new _$closeReason_296.CloseReasonImpl(4, 'The connection handshake was rejected by the server', false),
    HANDSHAKE_ERROR: new _$closeReason_296.CloseReasonImpl(5, 'There was an error parsing the handshake response', false),
    TRANSPORT_ERROR: new _$closeReason_296.CloseReasonImpl(6, 'There was an unexpected error with the connection', true),
    CONNECTION_ERROR: new _$closeReason_296.CloseReasonImpl(7, 'The client could not establish a connection to the server', true),
    IDLE_CONNECTION: new _$closeReason_296.CloseReasonImpl(8, 'The activity monitor detected the connection was idle', true),
    LOST_MESSAGES: new _$closeReason_296.CloseReasonImpl(16, 'Loss of messages has been detected', false),
    PROTOCOL_VERSION_MISMATCH: new _$closeReason_296.CloseReasonImpl(17, 'Client version rejected : Client should be downgraded to use server compatible version ' +
        'or server upgraded to client version in use', false),
    LICENSE_EXCEEDED: new _$closeReason_296.CloseReasonImpl(18, 'The license limit was exceeded', false),
    ACCESS_DENIED: new _$closeReason_296.CloseReasonImpl(99, 'The connection attempt was rejected by the server because authentication failed', false)
};
_$enumerize_747.enumerize(_$closeReason_277.CloseReasonEnum);
var ClientCloseReason;
(function (ClientCloseReason) {
    ClientCloseReason[ClientCloseReason["CONNECTION_LOST"] = 0] = "CONNECTION_LOST";
    ClientCloseReason[ClientCloseReason["IO_EXCEPTION"] = 1] = "IO_EXCEPTION";
    ClientCloseReason[ClientCloseReason["CLIENT_UNRESPONSIVE"] = 2] = "CLIENT_UNRESPONSIVE";
    ClientCloseReason[ClientCloseReason["MESSAGE_QUEUE_LIMIT_REACHED"] = 3] = "MESSAGE_QUEUE_LIMIT_REACHED";
    ClientCloseReason[ClientCloseReason["CLOSED_BY_CLIENT"] = 4] = "CLOSED_BY_CLIENT";
    ClientCloseReason[ClientCloseReason["MESSAGE_TOO_LARGE"] = 5] = "MESSAGE_TOO_LARGE";
    ClientCloseReason[ClientCloseReason["INTERNAL_ERROR"] = 6] = "INTERNAL_ERROR";
    ClientCloseReason[ClientCloseReason["INVALID_INBOUND_MESSAGE"] = 7] = "INVALID_INBOUND_MESSAGE";
    ClientCloseReason[ClientCloseReason["ABORTED"] = 8] = "ABORTED";
    ClientCloseReason[ClientCloseReason["LOST_MESSAGES"] = 9] = "LOST_MESSAGES";
    ClientCloseReason[ClientCloseReason["CLOSED_BY_CONTROLLER"] = 11] = "CLOSED_BY_CONTROLLER";
    ClientCloseReason[ClientCloseReason["FAILED_OVER"] = 12] = "FAILED_OVER";
    ClientCloseReason[ClientCloseReason["EXPIRED"] = 13] = "EXPIRED";
    ClientCloseReason[ClientCloseReason["REVOKED"] = 14] = "REVOKED";
    ClientCloseReason[ClientCloseReason["SESSION_TAKEN_OVER"] = 15] = "SESSION_TAKEN_OVER";
})(ClientCloseReason = _$closeReason_277.ClientCloseReason || (_$closeReason_277.ClientCloseReason = {}));

var _$internalSessionImpl_300 = {};
"use strict";
var ____extends_300 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$internalSessionImpl_300, "__esModule", { value: true });
_$internalSessionImpl_300.InternalSessionImpl = void 0;
;
;
;
;
;
;
var __datatypes_1_300 = _$datatypes_324({});
;
;
;
;
;
;
;
;
;
;
;
;
;
;
var INITIALISING = _$internalSession_301.InternalSessionState.INITIALISING, CONNECTING = _$internalSession_301.InternalSessionState.CONNECTING, CONNECTED = _$internalSession_301.InternalSessionState.CONNECTED, DISCONNECTED = _$internalSession_301.InternalSessionState.DISCONNECTED, RECONNECTING = _$internalSession_301.InternalSessionState.RECONNECTING, CLOSING = _$internalSession_301.InternalSessionState.CLOSING, CLOSED = _$internalSession_301.InternalSessionState.CLOSED;
var __log_300 = _$logger_752.create('Internal Session');
var InternalSessionImpl =  (function (_super) {
    ____extends_300(InternalSessionImpl, _super);
    function InternalSessionImpl(conversationSetFactory, serviceRegistry, connectionFactory, opts, sessnActivityMonitorFactory) {
        var _a;
        if (sessnActivityMonitorFactory === void 0) { sessnActivityMonitorFactory = _$sessionActivityMonitor_290.sessionActivityMonitorFactory; }
        var _this = this;
        var factory = _$emitter_353.Emitter.create();
        _this = _super.call(this, factory) || this;
        _this.emitter = factory.emitter(_this);
        _this.version = _$version_770.version;
        _this.principal = '';
        _this.conversationSetFactory = conversationSetFactory;
        _this.conversationSet = conversationSetFactory();
        _this.serviceRegistry = serviceRegistry;
        _this.opts = opts;
        _this.sessionActivityMonitorFactory = sessnActivityMonitorFactory;
        _this.fsm = new _$fsm_749.FSM(INITIALISING, (_a = {},
            _a[INITIALISING] = [CONNECTING],
            _a[CONNECTING] = [CONNECTED, CLOSING],
            _a[CONNECTED] = [
                DISCONNECTED,
                CLOSING,
                CLOSED
            ],
            _a[DISCONNECTED] = [RECONNECTING, CLOSING],
            _a[RECONNECTING] = [CONNECTED, CLOSING],
            _a[CLOSING] = [CLOSED],
            _a[CLOSED] = [],
            _a));
        _this.fsm.on('change', function (previous, current) {
            __log_300.debug('State changed: ' + previous + ' -> ' + current);
        });
        _this.transports = _$transports_743.Transports.create();
        _this.transports.on({
            'transport-selected': function (name) {
                _this.emitter.emit('transport-selected', name);
            },
            'cascade': function () {
                _this.emitter.emit('cascade');
            }
        });
        _this.connection = connectionFactory(_this.transports, _this.opts.reconnect.timeout, 256);
        _this.serviceAdapter = new _$serviceAdapter_302.ServiceAdapter(_this, function (msg) { _this.connection.send(msg); });
        _this.serviceLocator = new _$serviceLocator_303.ServiceLocatorImpl(_this, _this.serviceAdapter);
        _this.topicCache = new _$topicCache_422.TopicCache(__datatypes_1_300.DataTypes);
        _this.topicStreamRegistry = new _$streamRegistry_417.StreamRegistryImpl(_this.topicCache);
        _this.topicRouting = new _$topicRouting_423.TopicRouting(_this, _this.serviceAdapter, _this.conversationSet, _this.topicCache, _this.topicStreamRegistry);
        _this.serviceRegistry.addListener(_this.serviceAdapter.addService.bind(_this.serviceAdapter));
        if (_$sessionLock_388.InternalSessionLocks !== undefined) {
            _this.sessionLocksFeature = new _$sessionLock_388.InternalSessionLocks(_this, _this.fsm);
        }
        _this.attempts = 0;
        return _this;
    }
    Object.defineProperty(InternalSessionImpl.prototype, "sessionLocks", {
        get: function () {
            if (this.sessionLocksFeature === undefined) {
                if (_$sessionLock_388.InternalSessionLocks !== undefined) {
                    this.sessionLocksFeature = new _$sessionLock_388.InternalSessionLocks(this, this.fsm);
                }
                else {
                    throw new _$errors_280.RuntimeError('Session Locks feature has not been loaded');
                }
            }
            return this.sessionLocksFeature;
        },
        enumerable: false,
        configurable: true
    });
    InternalSessionImpl.prototype.getOptions = function () {
        return this.opts;
    };
    InternalSessionImpl.prototype.getState = function () {
        return this.fsm.state;
    };
    InternalSessionImpl.prototype.onStateChange = function (callback) {
        this.fsm.on('change', callback);
    };
    InternalSessionImpl.prototype.getConversationSet = function () {
        return this.conversationSet;
    };
    InternalSessionImpl.prototype.isConnected = function () {
        return this.fsm.state === CONNECTED;
    };
    InternalSessionImpl.prototype.getServiceRegistry = function () {
        return this.serviceRegistry;
    };
    InternalSessionImpl.prototype.getSessionId = function () {
        return this.sessionID;
    };
    InternalSessionImpl.prototype.getServerMaximumMessageSize = function () {
        return this.serverMaximumMessageSize;
    };
    InternalSessionImpl.prototype.checkConnected = function (reject) {
        if (this.isConnected()) {
            return true;
        }
        else {
            reject(new Error('The session is not connected. Operations are not possible at this time.'));
            return false;
        }
    };
    InternalSessionImpl.prototype.internalClose = function (reason) {
        if (this.fsm.change(CLOSED)) {
            this.topicStreamRegistry.close();
            this.conversationSet.discardAll(reason);
            this.emitter.close(reason);
        }
        else {
            __log_300.debug('Unable to handle session close, session state: ', this.fsm.state);
        }
    };
    InternalSessionImpl.prototype.reconnect = function (opts, token) {
        if (this.fsm.change(RECONNECTING)) {
            __log_300.info('Reconnect attempt (' + (++this.attempts) + ')');
            var request = _$connectionRequest_413.reconnect(token, this.connection.getAvailableSequence(), this.connection.lastReceivedSequence);
            this.connection.connect(request, opts, opts.reconnect.timeout);
        }
        else {
            __log_300.debug('Unable to attempt reconnect, session state: ', this.fsm.state);
        }
    };
    InternalSessionImpl.prototype.abort = function (reason) {
        if (reason === void 0) { reason = _$closeReason_277.CloseReasonEnum.RECONNECT_ABORTED; }
        if (this.fsm.change(CLOSING)) {
            __log_300.debug('Aborting reconnect');
            this.internalClose(reason);
        }
        else {
            __log_300.debug('Unable to abort reconnect, session state: ', this.fsm.state);
        }
    };
    InternalSessionImpl.prototype.replaceConversationSet = function (err) {
        var oldConversationSet = this.conversationSet;
        this.conversationSet = this.conversationSetFactory();
        oldConversationSet.discardAll(err);
        __log_300.debug('Replaced conversation set', err);
    };
    InternalSessionImpl.prototype.connect = function () {
        var _this = this;
        if (this.fsm.change(CONNECTING)) {
            var reconnectTimeout_1;
            var request = _$connectionRequest_413.connect();
            this.connection.on('data', this.topicRouting.route.bind(this.topicRouting));
            this.connection.on('close', this.internalClose.bind(this));
            this.sessionActivityMonitor = this.opts.activityMonitor
                ? this.sessionActivityMonitorFactory.create(_$connectionActivityMonitorFactory_288.connectionActivityMonitorFactory)
                : this.sessionActivityMonitorFactory.NOOP;
            this.connection.on('disconnect', function (reason) {
                __log_300.debug('Connection disconnected, reason: ', reason);
                if (_this.fsm.change(DISCONNECTED) ||
                    _this.fsm.state === RECONNECTING) {
                    _this.sessionActivityMonitor.onConnectionClosed();
                    if (_this.opts.reconnect.timeout > 0 && reason.canReconnect) {
                        if (_this.fsm.state === DISCONNECTED) {
                            _this.emitter.emit('disconnect', reason);
                            reconnectTimeout_1 = setTimeout(function () {
                                if (_this.fsm.state !== CONNECTED) {
                                    _this.abort(_$closeReason_277.CloseReasonEnum.CONNECTION_TIMEOUT);
                                }
                            }, _this.opts.reconnect.timeout);
                        }
                        _this.opts.reconnect.strategy(_this.reconnect.bind(_this, _this.opts, _this.token), _this.abort.bind(_this), reason);
                    }
                    else {
                        _this.abort(reason);
                    }
                }
                else if (_this.fsm.change(CLOSING)) {
                    _this.internalClose(reason);
                }
                else {
                    _this.sessionActivityMonitor.onConnectionClosed();
                    __log_300.debug('Unable to handle session disconnect, session state: ', _this.fsm.state);
                }
            });
            this.connection.on('connect', function (response) {
                if (_this.fsm.change(CONNECTED)) {
                    _this.token = response.token;
                    if (response.response === _$responseCode_416.responseCodes.OK) {
                        _this.sessionID = response.identity;
                        _this.serverMaximumMessageSize = response.maximumMessageSize;
                        _this.sessionActivityMonitor.onNewConnection(_this.connection, response);
                        _this.emitter.emit('connect', response.identity);
                    }
                    else if (response.response === _$responseCode_416.responseCodes.RECONNECTED ||
                        response.response === _$responseCode_416.responseCodes.RECONNECTED_WITH_MESSAGE_LOSS) {
                        _this.attempts = 0;
                        clearTimeout(reconnectTimeout_1);
                        if (response.response === _$responseCode_416.responseCodes.RECONNECTED_WITH_MESSAGE_LOSS) {
                            _this.connection.resetSequences();
                            _this.replaceConversationSet(new Error('Peer is disconnected'));
                            _this.topicCache.notifyUnsubscriptionOfAllTopics(_this.topicStreamRegistry);
                            __log_300.info('Reconnected session, but messages may have been lost');
                        }
                        else {
                            __log_300.info('Reconnected session');
                        }
                        _this.sessionActivityMonitor.onNewConnection(_this.connection, response);
                        _this.emitter.emit('reconnect');
                    }
                    else {
                        __log_300.trace('Unknown connection response: ', response);
                    }
                }
            });
            __log_300.debug('Connecting with options:', this.opts);
            __log_300.trace('Connecting with request:', request);
            try {
                this.connection.connect(request, this.opts, this.opts.connectionTimeout);
            }
            catch (e) {
                __log_300.warn('Connection error', e);
                this.emitter.emit('error', e);
                if (this.fsm.change(CLOSING)) {
                    this.internalClose(_$closeReason_277.CloseReasonEnum.CONNECTION_ERROR);
                }
            }
            if (this.opts.principal) {
                this.principal = this.opts.principal;
            }
        }
        else {
            __log_300.warn('Unable to connect, session state: ', this.fsm.state);
            this.emitter.emit('error', new _$errors_280.IllegalStateError('Unable to connect, session state: ' + this.fsm.state));
        }
    };
    InternalSessionImpl.prototype.close = function () {
        if (this.fsm.change(CLOSING)) {
            this.sessionActivityMonitor.onConnectionClosed();
            this.connection.close(_$closeReason_277.CloseReasonEnum.CLOSED_BY_CLIENT);
        }
        else {
            __log_300.debug('Unable to close, session state: ', this.fsm.state);
        }
        return this;
    };
    InternalSessionImpl.prototype.getErrorHandler = function () {
        return function (error) {
            __log_300.error('Session error:', error.message);
        };
    };
    InternalSessionImpl.prototype.getServiceLocator = function () {
        return this.serviceLocator;
    };
    InternalSessionImpl.prototype.getServiceAdapter = function () {
        return this.serviceAdapter;
    };
    InternalSessionImpl.prototype.getPrincipal = function () {
        return this.principal;
    };
    InternalSessionImpl.prototype.setPrincipal = function (newPrincipal) {
        this.principal = newPrincipal;
    };
    InternalSessionImpl.prototype.getStreamRegistry = function () {
        return this.topicStreamRegistry;
    };
    InternalSessionImpl.prototype.getRouting = function () {
        return this.topicRouting;
    };
    InternalSessionImpl.prototype.onSystemPing = function () {
        this.sessionActivityMonitor.onSystemPing();
    };
    InternalSessionImpl.prototype.lock = function (lockName, scope, handler) {
        return this.sessionLocks.lock(lockName, scope, handler);
    };
    InternalSessionImpl.prototype.unlock = function (acquisition) {
        return this.sessionLocks.unlock(acquisition);
    };
    InternalSessionImpl.prototype.isShared = function () {
        return false;
    };
    InternalSessionImpl.prototype.getContext = function () {
        return _$sessionContextImpl_309.sessionContext;
    };
    InternalSessionImpl.prototype.updateFeatures = function () {
        if (this.sessionLocksFeature === undefined &&  _$sessionLock_388.InternalSessionLocks !== undefined) {
            this.sessionLocksFeature = new _$sessionLock_388.InternalSessionLocks(this, this.fsm);
        }
    };
    return InternalSessionImpl;
}(_$stream_354.StreamImpl));
_$internalSessionImpl_300.InternalSessionImpl = InternalSessionImpl;

var _$serviceRegistry_304 = {};
"use strict";
Object.defineProperty(_$serviceRegistry_304, "__esModule", { value: true });
_$serviceRegistry_304.ServiceRegistryImpl = void 0;
;
var ServiceRegistryImpl =  (function () {
    function ServiceRegistryImpl() {
        this.services = new Map();
        this.listeners = [];
    }
    ServiceRegistryImpl.prototype.add = function (definition, service) {
        if (this.services.has(definition)) {
            throw new _$errors_280.RuntimeError("Service already exists for " + definition);
        }
        this.services.set(definition, service);
        this.listeners.forEach(function (listener) {
            listener(definition, service);
        });
    };
    ServiceRegistryImpl.prototype.addListener = function (listener) {
        this.listeners.push(listener);
        this.services.forEach(function (service, definition) {
            listener(definition, service);
        });
    };
    return ServiceRegistryImpl;
}());
_$serviceRegistry_304.ServiceRegistryImpl = ServiceRegistryImpl;

var _$monitoredPingService_305 = {};
"use strict";
Object.defineProperty(_$monitoredPingService_305, "__esModule", { value: true });
_$monitoredPingService_305.monitoredPingService = void 0;
_$monitoredPingService_305.monitoredPingService = {
    onRequest: function (internal, request, callback) {
        callback.respond();
        internal.onSystemPing();
    }
};

var _$notifySubscriptionService_306 = {};
"use strict";
Object.defineProperty(_$notifySubscriptionService_306, "__esModule", { value: true });
_$notifySubscriptionService_306.notifySubscriptionService = void 0;
_$notifySubscriptionService_306.notifySubscriptionService = {
    onRequest: function (internal, request, callback) {
        callback.respond();
        internal.getRouting().subscribe(request);
    }
};

var _$notifyUnsubscriptionService_307 = {};
"use strict";
Object.defineProperty(_$notifyUnsubscriptionService_307, "__esModule", { value: true });
_$notifyUnsubscriptionService_307.notifyUnsubscriptionService = void 0;
_$notifyUnsubscriptionService_307.notifyUnsubscriptionService = {
    onRequest: function (internal, notification, callback) {
        callback.respond();
        internal.getRouting().unsubscribe(notification.id, notification.reason);
    }
};

var _$pingService_308 = {};
"use strict";
Object.defineProperty(_$pingService_308, "__esModule", { value: true });
_$pingService_308.pingService = void 0;
_$pingService_308.pingService = {
    onRequest: function (internal, ping, callback) {
        callback.respond();
    }
};

var _$conversationSet_315 = {};
"use strict";
var ____extends_315 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ____awaiter_315 = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var ____generator_315 = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var ____values_315 = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(_$conversationSet_315, "__esModule", { value: true });
_$conversationSet_315.create = _$conversationSet_315.ConversationSet =  _$conversationSet_315.Result =  void 0;
;
;
;
var NEXT_CID = (function () {
    var id = new _$Long_274(0);
    return function () { return ____awaiter_315(void 0, void 0, void 0, function () {
        return ____generator_315(this, function (_a) {
            id = id.add(1);
            return [2 , new _$conversationId_314.ConversationId(id)];
        });
    }); };
})();
 void NEXT_CID;
var __Result_315;
(function (Result) {
    Result[Result["ALREADY_FINISHED"] = 0] = "ALREADY_FINISHED";
    Result[Result["HANDLED_AND_ACTIVE"] = 1] = "HANDLED_AND_ACTIVE";
    Result[Result["HANDLED_AND_FINISHED"] = 2] = "HANDLED_AND_FINISHED";
})(__Result_315 = _$conversationSet_315.Result || (_$conversationSet_315.Result = {}));
var LOG = _$logger_752.create('Conversation Set');
var NoSuchConversationError =  (function (_super) {
    ____extends_315(NoSuchConversationError, _super);
    function NoSuchConversationError(message) {
        var _this = _super.call(this, message) || this;
        _this.name = 'NoSuchConversationError';
        return _this;
    }
    return NoSuchConversationError;
}(Error));
 void NoSuchConversationError;
var Conversation =  (function () {
    function Conversation(handler, completedExceptionally) {
        this.reserved = false;
        this.closed = false;
        this.handler = handler;
        this.completedExceptionally = completedExceptionally;
    }
    Conversation.prototype.open = function (cid) {
        this.handler.onOpen(cid);
    };
    Conversation.prototype.respond = function (cid, response) {
        if (this.closed) {
            return __Result_315.ALREADY_FINISHED;
        }
        var previous = this.reserved;
        this.reserved = true;
        var close;
        try {
            close = this.handler.onResponse(cid, response);
        }
        catch (e) {
            this.completedExceptionally(cid, this, e);
            throw e;
        }
        if (this.closed) {
            LOG.debug('Conversation already closed', cid);
            return __Result_315.HANDLED_AND_FINISHED;
        }
        else if (close) {
            LOG.debug('Response handler closed conversation', cid);
            this.closed = true;
            return __Result_315.HANDLED_AND_FINISHED;
        }
        else if (this.pendingDiscard) {
            LOG.debug('Conversation closed with pending reason', cid);
            this.notifyDiscard(cid, this.pendingDiscard);
            return __Result_315.HANDLED_AND_FINISHED;
        }
        else {
            this.reserved = previous;
            return __Result_315.HANDLED_AND_ACTIVE;
        }
    };
    Conversation.prototype.discard = function (cid, reason) {
        if (this.reserved) {
            this.pendingDiscard = reason;
        }
        else {
            this.notifyDiscard(cid, reason);
        }
    };
    Conversation.prototype.close = function () {
        this.closed = true;
    };
    Conversation.prototype.notifyDiscard = function (cid, reason) {
        if (!this.closed) {
            this.closed = true;
            try {
                this.handler.onDiscard(cid, reason);
            }
            catch (e) {
                LOG.error('Application handler threw exception [cid=' + cid + ']', e.stack);
                throw e;
            }
        }
    };
    return Conversation;
}());
var ConversationSet =  (function () {
    function ConversationSet(idGenerator) {
        this.nextCID = idGenerator;
        this.conversations = {};
    }
    ConversationSet.prototype.completedExceptionally = function (cid, conversation, e) {
        LOG.debug('Application handler threw exception [cid=' + cid + ']', e.stack);
        conversation.close();
        delete this.conversations[cid.toString()];
    };
    ConversationSet.prototype.newConversation = function (responseHandler) {
        return ____awaiter_315(this, void 0, void 0, function () {
            var conversation, cid;
            return ____generator_315(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        conversation = new Conversation(responseHandler, this.completedExceptionally.bind(this));
                        return [4 , this.nextCID()];
                    case 1:
                        cid = _a.sent();
                        this.conversations[cid.toString()] = conversation;
                        try {
                            conversation.open(cid);
                        }
                        catch (e) {
                            this.completedExceptionally(cid, conversation, e);
                            throw e;
                        }
                        if (this.discardReason !== undefined) {
                            this.discard(cid, this.discardReason);
                        }
                        return [2 , cid];
                }
            });
        });
    };
    ConversationSet.prototype.respond = function (cid, response) {
        var conversation = this.conversations[cid.toString()];
        if (conversation === undefined) {
            LOG.debug("No conversation for cid: " + cid + ", response: ", response);
            throw new NoSuchConversationError('No such conversation');
        }
        var result = conversation.respond(cid, response);
        switch (result) {
            case __Result_315.ALREADY_FINISHED:
                throw new NoSuchConversationError('No such conversation');
            case __Result_315.HANDLED_AND_ACTIVE:
                break;
            default:
                delete this.conversations[cid.toString()];
        }
    };
    ConversationSet.prototype.respondIfPresent = function (cid, response) {
        try {
            this.respond(cid, response);
        }
        catch (e) {
            if (e.name !== 'NoSuchConversationError') {
                throw e;
            }
        }
    };
    ConversationSet.prototype.discard = function (cid, reason) {
        var conversation = this.conversations[cid.toString()];
        delete this.conversations[cid.toString()];
        if (conversation) {
            conversation.discard(cid, reason);
        }
    };
    ConversationSet.prototype.discardAll = function (reason) {
        var e_1, _a;
        if (this.discardReason !== undefined) {
            return;
        }
        this.discardReason = reason;
        try {
            for (var _b = ____values_315(Object.keys(this.conversations)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var cid = _c.value;
                this.discard(_$conversationId_314.ConversationId.fromString(cid), reason);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    ConversationSet.prototype.size = function () {
        return Object.keys(this.conversations).length;
    };
    return ConversationSet;
}());
_$conversationSet_315.ConversationSet = ConversationSet;
function __create_315() {
    return new ConversationSet(NEXT_CID);
}
_$conversationSet_315.create = __create_315;

var _$serviceDefinition_623 = {};
"use strict";
Object.defineProperty(_$serviceDefinition_623, "__esModule", { value: true });
_$serviceDefinition_623.NullSerialiser = void 0;
_$serviceDefinition_623.NullSerialiser = {
    read: function () { return null; },
    write: function () { }
};

var _$pingServices_589 = {};
"use strict";
Object.defineProperty(_$pingServices_589, "__esModule", { value: true });
_$pingServices_589.USER_PING = _$pingServices_589.SYSTEM_PING = void 0;
;
_$pingServices_589.SYSTEM_PING = {
    id: 55,
    request: _$serviceDefinition_623.NullSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
_$pingServices_589.USER_PING = {
    id: 56,
    request: _$serviceDefinition_623.NullSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};

var _$controlGroup_311 = {};
"use strict";
Object.defineProperty(_$controlGroup_311, "__esModule", { value: true });
_$controlGroup_311.DEFAULT = _$controlGroup_311.ControlGroup = void 0;
var ControlGroup =  (function () {
    function ControlGroup(name) {
        this.name = name;
    }
    return ControlGroup;
}());
_$controlGroup_311.ControlGroup = ControlGroup;
_$controlGroup_311.DEFAULT = Object.freeze(new ControlGroup('default'));

var _$controlGroupSerialiser_310 = {};
"use strict";
var ____extends_310 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$controlGroupSerialiser_310, "__esModule", { value: true });
_$controlGroupSerialiser_310.ControlGroupSerialiser =  void 0;
;
;
;
var ControlGroupSerialiserClass =  (function (_super) {
    ____extends_310(ControlGroupSerialiserClass, _super);
    function ControlGroupSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ControlGroupSerialiserClass.prototype.read = function (bis) {
        var name = _$codec_411.readString(bis);
        return new _$controlGroup_311.ControlGroup(name);
    };
    ControlGroupSerialiserClass.prototype.write = function (bos, value) {
        _$codec_411.writeString(bos, value.name);
    };
    return ControlGroupSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void ControlGroupSerialiserClass;
_$controlGroupSerialiser_310.ControlGroupSerialiser = new ControlGroupSerialiserClass();

var _$messageReceiverControlRegistrationParamsSerialiser_471 = {};
"use strict";
var ____extends_471 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$messageReceiverControlRegistrationParamsSerialiser_471, "__esModule", { value: true });
_$messageReceiverControlRegistrationParamsSerialiser_471.MessageReceiverControlRegistrationParamsSerialiser =  void 0;
;
;
;
var MessageReceiverControlRegistrationParamsSerialiserClass =  (function (_super) {
    ____extends_471(MessageReceiverControlRegistrationParamsSerialiserClass, _super);
    function MessageReceiverControlRegistrationParamsSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MessageReceiverControlRegistrationParamsSerialiserClass.prototype.write = function (bos, value) {
        _$codec_411.writeInt32(bos, value.definition.id);
        _$controlGroupSerialiser_310.ControlGroupSerialiser.write(bos, value.group);
        _$codec_411.writeString(bos, value.path);
        _$codec_411.writeCollection(bos, value.keys, _$codec_411.writeString);
    };
    return MessageReceiverControlRegistrationParamsSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void MessageReceiverControlRegistrationParamsSerialiserClass;
_$messageReceiverControlRegistrationParamsSerialiser_471.MessageReceiverControlRegistrationParamsSerialiser = new MessageReceiverControlRegistrationParamsSerialiserClass();

var _$messageReceiverControlRegistrationRequestSerialiser_472 = {};
"use strict";
var ____extends_472 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$messageReceiverControlRegistrationRequestSerialiser_472, "__esModule", { value: true });
_$messageReceiverControlRegistrationRequestSerialiser_472.MessageReceiverControlRegistrationRequestSerialiser =  void 0;
;
;
;
var MessageReceiverControlRegistrationRequestSerialiserClass =  (function (_super) {
    ____extends_472(MessageReceiverControlRegistrationRequestSerialiserClass, _super);
    function MessageReceiverControlRegistrationRequestSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MessageReceiverControlRegistrationRequestSerialiserClass.prototype.write = function (bos, value) {
        _$messageReceiverControlRegistrationParamsSerialiser_471.MessageReceiverControlRegistrationParamsSerialiser.write(bos, value.params);
        _$conversationIdSerialiser_313.CIDSerialiser.write(bos, value.cid);
    };
    return MessageReceiverControlRegistrationRequestSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void MessageReceiverControlRegistrationRequestSerialiserClass;
_$messageReceiverControlRegistrationRequestSerialiser_472.MessageReceiverControlRegistrationRequestSerialiser = new MessageReceiverControlRegistrationRequestSerialiserClass();

var _$topicControlRegistrationParamsSerialiser_501 = {};
"use strict";
var ____extends_501 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$topicControlRegistrationParamsSerialiser_501, "__esModule", { value: true });
_$topicControlRegistrationParamsSerialiser_501.TopicControlRegistrationParamsSerialiser =  void 0;
;
;
;
var TopicControlRegistrationParamsSerialiserClass =  (function (_super) {
    ____extends_501(TopicControlRegistrationParamsSerialiserClass, _super);
    function TopicControlRegistrationParamsSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TopicControlRegistrationParamsSerialiserClass.prototype.write = function (bos, value) {
        _$codec_411.writeInt32(bos, value.definition.id);
        _$controlGroupSerialiser_310.ControlGroupSerialiser.write(bos, value.group);
        _$codec_411.writeString(bos, value.path);
    };
    return TopicControlRegistrationParamsSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void TopicControlRegistrationParamsSerialiserClass;
_$topicControlRegistrationParamsSerialiser_501.TopicControlRegistrationParamsSerialiser = new TopicControlRegistrationParamsSerialiserClass();

var _$topicControlRegistrationRequestSerialiser_502 = {};
"use strict";
var ____extends_502 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$topicControlRegistrationRequestSerialiser_502, "__esModule", { value: true });
_$topicControlRegistrationRequestSerialiser_502.TopicControlRegistrationRequestSerialiser =  void 0;
;
;
;
var TopicControlRegistrationRequestSerialiserClass =  (function (_super) {
    ____extends_502(TopicControlRegistrationRequestSerialiserClass, _super);
    function TopicControlRegistrationRequestSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TopicControlRegistrationRequestSerialiserClass.prototype.write = function (bos, value) {
        _$topicControlRegistrationParamsSerialiser_501.TopicControlRegistrationParamsSerialiser.write(bos, value.params);
        _$conversationIdSerialiser_313.CIDSerialiser.write(bos, value.cid);
    };
    return TopicControlRegistrationRequestSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void TopicControlRegistrationRequestSerialiserClass;
_$topicControlRegistrationRequestSerialiser_502.TopicControlRegistrationRequestSerialiser = new TopicControlRegistrationRequestSerialiserClass();

var _$topicIdSerialiser_731 = {};
"use strict";
Object.defineProperty(_$topicIdSerialiser_731, "__esModule", { value: true });
_$topicIdSerialiser_731.write = _$topicIdSerialiser_731.read = void 0;
;
function __read_731(bis) {
    return _$codec_411.readInt32(bis);
}
_$topicIdSerialiser_731.read = __read_731;
function __write_731(bos, value) {
    _$codec_411.writeInt32(bos, value);
}
_$topicIdSerialiser_731.write = __write_731;

var _$unsubscriptionNotification_706 = {};
"use strict";
Object.defineProperty(_$unsubscriptionNotification_706, "__esModule", { value: true });
_$unsubscriptionNotification_706.UnsubscriptionNotification = void 0;
var UnsubscriptionNotification =  (function () {
    function UnsubscriptionNotification(id, reason) {
        this.id = id;
        this.reason = reason;
    }
    return UnsubscriptionNotification;
}());
_$unsubscriptionNotification_706.UnsubscriptionNotification = UnsubscriptionNotification;

var _$unsubscriptionNotificationSerialiser_705 = {};
"use strict";
var ____extends_705 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$unsubscriptionNotificationSerialiser_705, "__esModule", { value: true });
_$unsubscriptionNotificationSerialiser_705.UnsubscriptionNotificationSerialiser =  void 0;
;
;
;
;
;
;
var UnsubscriptionNotificationSerialiserClass =  (function (_super) {
    ____extends_705(UnsubscriptionNotificationSerialiserClass, _super);
    function UnsubscriptionNotificationSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UnsubscriptionNotificationSerialiserClass.prototype.read = function (bis) {
        var id = _$topicIdSerialiser_731.read(bis);
        var reason = _$byteEncodedEnumSerialiser_426.read(bis, _$topics_785.UnsubscribeReasonEnum);
        return new _$unsubscriptionNotification_706.UnsubscriptionNotification(id, reason);
    };
    UnsubscriptionNotificationSerialiserClass.prototype.write = function (bos, value) {
        _$topicIdSerialiser_731.write(bos, value.id);
        if (value.reason.id === undefined) {
            throw new _$errors_280.IOError('Cannot serialise UnsubscribeReason ${value.reason.reason}');
        }
        _$byteEncodedEnumSerialiser_426.write(bos, value.reason);
    };
    return UnsubscriptionNotificationSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void UnsubscriptionNotificationSerialiserClass;
_$unsubscriptionNotificationSerialiser_705.UnsubscriptionNotificationSerialiser = new UnsubscriptionNotificationSerialiserClass();

var _$topicSpecificationInfo_733 = {};
"use strict";
Object.defineProperty(_$topicSpecificationInfo_733, "__esModule", { value: true });
_$topicSpecificationInfo_733.TopicSpecificationInfo = void 0;
var TopicSpecificationInfo =  (function () {
    function TopicSpecificationInfo(id, path, specification) {
        this.id = id;
        this.path = path;
        this.specification = specification;
    }
    return TopicSpecificationInfo;
}());
_$topicSpecificationInfo_733.TopicSpecificationInfo = TopicSpecificationInfo;

var _$topicSpecificationSerialiser_734 = {};
"use strict";
Object.defineProperty(_$topicSpecificationSerialiser_734, "__esModule", { value: true });
_$topicSpecificationSerialiser_734.write = _$topicSpecificationSerialiser_734.read = void 0;
;
;
;
;
;
var cachedTopicSpecification;
var cachedHash;
var cacheBytesRead;
function __read_734(bis) {
    if (cachedHash) {
        var newHash = bis.buffer.subarray(bis.pos, bis.pos + cacheBytesRead);
        if (_$uint8array_762.isEqualUint8Arrays(newHash, cachedHash)) {
            bis.readMany(cacheBytesRead);
            return cachedTopicSpecification;
        }
    }
    var offset = bis.pos;
    var type = _$byteEncodedEnumSerialiser_426.read(bis, _$topicType_784.TopicType);
    var properties = _$codec_411.readDictionary(bis, _$codec_411.readString);
    var topicSpecification = new _$topicSpecification_783.TopicSpecification(type, properties);
    cacheBytesRead = bis.pos - offset;
    cachedHash = Uint8Array.from(bis.buffer.subarray(offset, bis.pos));
    cachedTopicSpecification = Object.freeze(topicSpecification);
    return topicSpecification;
}
_$topicSpecificationSerialiser_734.read = __read_734;
function __write_734(bos, value) {
    _$byteEncodedEnumSerialiser_426.write(bos, value.type);
    _$codec_411.writeDictionary(bos, value.properties, _$codec_411.writeString);
}
_$topicSpecificationSerialiser_734.write = __write_734;

var _$topicSpecificationInfoSerialiser_732 = {};
"use strict";
var ____extends_732 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$topicSpecificationInfoSerialiser_732, "__esModule", { value: true });
_$topicSpecificationInfoSerialiser_732.TopicSpecificationInfoSerialiser =  void 0;
;
;
;
;
var TopicSpecificationInfoSerialiserClass =  (function (_super) {
    ____extends_732(TopicSpecificationInfoSerialiserClass, _super);
    function TopicSpecificationInfoSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TopicSpecificationInfoSerialiserClass.prototype.read = function (bis) {
        var topicId = _$codec_411.readInt32(bis);
        var path = _$codec_411.readString(bis);
        var spec = _$topicSpecificationSerialiser_734.read(bis);
        return new _$topicSpecificationInfo_733.TopicSpecificationInfo(topicId, path, spec);
    };
    TopicSpecificationInfoSerialiserClass.prototype.write = function (bos, value) {
        _$codec_411.writeInt32(bos, value.id);
        _$codec_411.writeString(bos, value.path);
        _$topicSpecificationSerialiser_734.write(bos, value.specification);
    };
    return TopicSpecificationInfoSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void TopicSpecificationInfoSerialiserClass;
_$topicSpecificationInfoSerialiser_732.TopicSpecificationInfoSerialiser = new TopicSpecificationInfoSerialiserClass();

var _$services_624 = {};
"use strict";
Object.defineProperty(_$services_624, "__esModule", { value: true });
_$services_624.MESSAGING_RECEIVER_CONTROL_DEREGISTRATION = _$services_624.MESSAGING_RECEIVER_CONTROL_REGISTRATION = _$services_624.NOTIFY_SUBSCRIPTION =   _$services_624.UNSUBSCRIPTION_NOTIFICATION = _$services_624.TOPIC_CONTROL_DEREGISTRATION = _$services_624.TOPIC_CONTROL_REGISTRATION = void 0;
;
;
;
;
;
;
;
_$services_624.TOPIC_CONTROL_REGISTRATION = {
    id: 20,
    request: _$topicControlRegistrationRequestSerialiser_502.TopicControlRegistrationRequestSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
_$services_624.TOPIC_CONTROL_DEREGISTRATION = {
    id: 21,
    request: _$topicControlRegistrationParamsSerialiser_501.TopicControlRegistrationParamsSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
_$services_624.UNSUBSCRIPTION_NOTIFICATION = {
    id: 42,
    request: _$unsubscriptionNotificationSerialiser_705.UnsubscriptionNotificationSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
 void {
    id: 63,
    request: _$messageReceiverControlRegistrationRequestSerialiser_472.MessageReceiverControlRegistrationRequestSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
 void {
    id: 64,
    request: _$messageReceiverControlRegistrationParamsSerialiser_471.MessageReceiverControlRegistrationParamsSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
_$services_624.NOTIFY_SUBSCRIPTION = {
    id: 87,
    request: _$topicSpecificationInfoSerialiser_732.TopicSpecificationInfoSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
_$services_624.MESSAGING_RECEIVER_CONTROL_REGISTRATION = {
    id: 97,
    request: _$messageReceiverControlRegistrationRequestSerialiser_472.MessageReceiverControlRegistrationRequestSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
_$services_624.MESSAGING_RECEIVER_CONTROL_DEREGISTRATION = {
    id: 98,
    request: _$messageReceiverControlRegistrationParamsSerialiser_471.MessageReceiverControlRegistrationParamsSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};

var _$recoveryBuffer_412 = {};
"use strict";
Object.defineProperty(_$recoveryBuffer_412, "__esModule", { value: true });
_$recoveryBuffer_412.RecoveryBuffer = void 0;
;
;
;
var TIMESTAMP_ROUNDING = 10;
function roundTimeStamp(timestamp) {
    return timestamp >> TIMESTAMP_ROUNDING;
}
function mask(p, capacity) {
    return p & capacity - 1;
}
var RecoveryBuffer =  (function () {
    function RecoveryBuffer(minimumMessages, minimumTimeIndex) {
        this.messagesLength = _$math_753.findNextPowerOfTwo(minimumMessages);
        this.indexCapacity = _$math_753.findNextPowerOfTwo(minimumTimeIndex);
        this.messagesMask = _$function_750.curryR(mask, this.messagesLength);
        this.indexMask = _$function_750.curryR(mask, this.indexCapacity);
        this.messages = _$array_746.ofSize(this.messagesLength);
        this.indices = _$array_746.ofSize(this.indexCapacity, -1);
        this.times = _$array_746.ofSize(this.indexCapacity);
        this.timesHead = 0;
        this.timesTail = 0;
        this.messagesTail = this.messagesMask(0);
        this.messagesSize = 0;
    }
    RecoveryBuffer.prototype.size = function () {
        return this.messagesSize;
    };
    RecoveryBuffer.prototype.put = function (message) {
        this.messages[this.messagesTail] = message;
        this.messagesTail = this.messagesMask(this.messagesTail + 1);
        if (this.messagesSize < this.messagesLength) {
            this.messagesSize = this.messagesSize + 1;
        }
        else {
            while (this.indices[this.timesHead] === this.messagesTail) {
                this.indices[this.timesHead] = -1;
                this.timesHead = this.indexMask(this.timesHead + 1);
            }
        }
    };
    RecoveryBuffer.prototype.recover = function (n, consumer) {
        if (n < 0 || n > this.messagesSize) {
            return false;
        }
        for (var i = n; i >= 1; --i) {
            consumer(this.messages[this.messagesMask(this.messagesTail - i)]);
        }
        return true;
    };
    RecoveryBuffer.prototype.clear = function () {
        _$array_746.fill(this.messages, null);
        _$array_746.fill(this.indices, -1);
        this.timesHead = 0;
        this.timesTail = 0;
        this.messagesSize = 0;
    };
    RecoveryBuffer.prototype.removeElements = function (newElementsHead) {
        var messagesHead = this.messagesMask(this.messagesTail - this.messagesSize);
        var newSize;
        if (messagesHead < newElementsHead) {
            _$array_746.fill(this.messages, null, messagesHead, newElementsHead);
            newSize = this.messagesSize - newElementsHead + messagesHead;
        }
        else if (messagesHead > newElementsHead) {
            _$array_746.fill(this.messages, null, messagesHead, this.messagesLength);
            _$array_746.fill(this.messages, null, 0, newElementsHead);
            newSize = this.messagesSize - messagesHead + newElementsHead;
        }
        else {
            _$array_746.fill(this.messages, null);
            newSize = 0;
        }
        this.messagesSize = newSize;
    };
    RecoveryBuffer.prototype.markTime = function (timestamp) {
        if (this.messagesSize > 0) {
            var h = this.timesHead;
            var t = this.timesTail;
            var firstIndex = this.indices[h];
            var roundedTimestamp = roundTimeStamp(timestamp);
            if (firstIndex >= 0) {
                var indexLast = this.indexMask(t - 1);
                if (this.indices[indexLast] === this.messagesTail) {
                    return;
                }
                if (this.times[indexLast] === roundedTimestamp) {
                    this.indices[indexLast] = this.messagesTail;
                    return;
                }
            }
            this.timesTail = this.indexMask(t + 1);
            this.times[t] = roundedTimestamp;
            this.indices[t] = this.messagesTail;
            if (h === t && firstIndex >= 0) {
                this.removeElements(firstIndex);
                this.timesHead = this.timesTail;
            }
        }
    };
    RecoveryBuffer.prototype.flush = function (timestamp) {
        if (this.messagesSize === 0 || this.indices[this.timesHead] < 0) {
            return;
        }
        var i = this.timesTail;
        var roundedTimestamp = roundTimeStamp(timestamp);
        do {
            var previousI = i;
            i = this.indexMask(i - 1);
            if (this.times[i] <= roundedTimestamp) {
                this.removeElements(this.indices[i]);
                if (this.timesHead <= previousI) {
                    _$array_746.fill(this.indices, -1, this.timesHead, previousI);
                }
                else {
                    _$array_746.fill(this.indices, -1, this.timesHead, this.indexCapacity);
                    _$array_746.fill(this.indices, -1, 0, previousI);
                }
                this.timesHead = previousI;
                return;
            }
        } while (i !== this.timesHead);
    };
    return RecoveryBuffer;
}());
_$recoveryBuffer_412.RecoveryBuffer = RecoveryBuffer;

var _$connection_766 = {};
(function (global){(function (){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$connection_766, "__esModule", { value: true });
_$connection_766.Connection = void 0;
;
;
;
;
;
;
;
;
;
;
;
var logger = _$logger_752.create('Connection');
var CLOSE_TIMEOUT = global.DIFFUSION_CLOSE_TIMEOUT || 1000;
var RECOVERY_BUFFER_INDEX_SIZE = global.DIFFUSION_RECOVERY_BUFFER_INDEX_SIZE || 8;
var Connection =  (function (_super) {
    __extends(Connection, _super);
    function Connection(transports, reconnectTimeout, recoveryBufferSize) {
        var _this = this;
        var factory = _$emitter_353.Emitter.create();
        _this = _super.call(this, factory) || this;
        _this.emitter = factory.emitter(_this);
        _this.fsm = new _$fsm_749.FSM('disconnected', {
            connecting: ['connected', 'disconnected', 'closed'],
            connected: ['disconnecting', 'disconnected', 'closed'],
            disconnecting: ['disconnected'],
            disconnected: ['connecting', 'closed'],
            closed: []
        });
        _this.transports = transports;
        _this.reconnectTimeout = reconnectTimeout;
        _this.lastSentSequence = 0;
        _this.lastReceivedSequence = 0;
        _this.recoveryBuffer = new _$recoveryBuffer_412.RecoveryBuffer(recoveryBufferSize, RECOVERY_BUFFER_INDEX_SIZE);
        _this.fsm.on('change', function (previous, current) {
            logger.debug("State changed: " + previous + " -> " + current);
        });
        return _this;
    }
    Connection.prototype.onData = function (data) {
        var _this = this;
        logger.debug('Received message from transport', data);
        _$message_769.parse(data, function (err, message) {
            if (!err && message) {
                if (message.type === _$message_769.types.ABORT_NOTIFICATION) {
                    if (_this.fsm.state !== 'disconnecting') {
                        _this.closeReason = _$closeReason_277.CloseReasonEnum.CLOSED_BY_SERVER;
                    }
                    _this.transport.close();
                    return;
                }
                _this.lastReceivedSequence++;
                _this.emitter.emit('data', message);
            }
            else {
                logger.warn('Unable to parse message', err);
                if (_this.fsm.change('closed')) {
                    _this.closeReason = _$closeReason_277.CloseReasonEnum.CONNECTION_ERROR;
                    _this.transport.close();
                }
            }
        });
    };
    Connection.prototype.onClose = function () {
        if (this.fsm.change('disconnected') || this.fsm.change('closed')) {
            clearInterval(this.scheduledRecoveryBufferTrim);
            clearTimeout(this.scheduledClose);
            logger.trace('Transport closed: ', this.closeReason);
            if (this.fsm.state === 'disconnected') {
                this.emitter.emit('disconnect', this.closeReason);
            }
            else {
                this.emitter.close(this.closeReason);
            }
        }
        else {
            logger.debug('Unable to disconnect, current state: ', this.fsm.state);
        }
    };
    Connection.prototype.onError = function (err) {
        logger.error('Error from transport', err);
        if (this.fsm.change('closed')) {
            this.closeReason = _$closeReason_277.CloseReasonEnum.TRANSPORT_ERROR;
            this.transport.close();
        }
    };
    Connection.prototype.onHandshakeSuccess = function (response) {
        if (response.response === _$responseCode_416.responseCodes.RECONNECTED) {
            var messageDelta = this.lastSentSequence - response.sequence + 1;
            if (this.recoveryBuffer.recover(messageDelta, this.dispatch.bind(this))) {
                this.recoveryBuffer.clear();
                this.lastSentSequence = response.sequence - 1;
            }
            else {
                var outboundLoss = this.lastSentSequence - this.recoveryBuffer.size() - response.sequence + 1;
                logger.warn("Unable to reconnect due to lost messages (" + outboundLoss + ")");
                if (this.fsm.change('disconnected')) {
                    this.closeReason = _$closeReason_277.CloseReasonEnum.LOST_MESSAGES;
                    this.transport.close();
                }
                return response;
            }
        }
        if (response.success && this.fsm.change('connected')) {
            logger.trace('Connection response: ', response.response);
            this.closeReason = _$closeReason_277.CloseReasonEnum.TRANSPORT_ERROR;
            this.emitter.emit('connect', response);
        }
        else {
            logger.error('Connection failed: ', response.response);
            switch (response.response) {
                case _$responseCode_416.responseCodes.AUTHENTICATION_FAILED:
                    this.closeReason = _$closeReason_277.CloseReasonEnum.ACCESS_DENIED;
                    break;
                case _$responseCode_416.responseCodes.LICENSE_EXCEEDED:
                    this.closeReason = _$closeReason_277.CloseReasonEnum.LICENSE_EXCEEDED;
                    break;
                case _$responseCode_416.responseCodes.DOWNGRADE:
                    this.closeReason = _$closeReason_277.CloseReasonEnum.PROTOCOL_VERSION_MISMATCH;
                    break;
                default:
                    this.closeReason = _$closeReason_277.CloseReasonEnum.HANDSHAKE_REJECTED;
                    break;
            }
            this.transport.close();
        }
        clearTimeout(this.scheduledClose);
        return response;
    };
    Connection.prototype.onHandshakeError = function (error) {
        if (error.reason === _$connectionResponseDeserialiser_414.DeserialisationErrorReason.PROTOCOL_VERSION_MISMATCH) {
            this.closeReason = _$closeReason_277.CloseReasonEnum.PROTOCOL_VERSION_MISMATCH;
        }
        else {
            this.closeReason = _$closeReason_277.CloseReasonEnum.HANDSHAKE_ERROR;
        }
        clearTimeout(this.scheduledClose);
        logger.trace('Unable to deserialise handshake response', error);
        return;
    };
    Connection.prototype.connect = function (request, opts, timeout) {
        var _this = this;
        if (this.fsm.state !== 'disconnected') {
            logger.warn('Cannot connect, current state: ', this.fsm.state);
            return;
        }
        if (this.fsm.change('connecting')) {
            this.closeReason = _$closeReason_277.CloseReasonEnum.CONNECTION_ERROR;
            this.transport = this.transports.get(opts);
            if (this.transport === null) {
                throw new _$errors_280.IllegalArgumentError('No valid transports requested');
            }
            this.transport.on('data', this.onData.bind(this));
            this.transport.on('close', this.onClose.bind(this));
            this.transport.on('error', this.onError.bind(this));
            this.transport.connect(request, this.onHandshakeSuccess.bind(this), this.onHandshakeError.bind(this));
            this.scheduledClose = setTimeout(function () {
                logger.debug("Timed out connection attempt after " + timeout);
                _this.closeReason = _$closeReason_277.CloseReasonEnum.CONNECTION_TIMEOUT;
                _this.transport.close();
            }, timeout);
            this.scheduledRecoveryBufferTrim = setInterval(function () {
                if (_this.fsm.state === 'connected') {
                    _this.recoveryBuffer.flush(Date.now() - _this.reconnectTimeout);
                }
            }, this.reconnectTimeout);
        }
    };
    Connection.prototype.resetSequences = function () {
        this.recoveryBuffer.clear();
        this.lastSentSequence = 0;
        this.lastReceivedSequence = 0;
    };
    Connection.prototype.getAvailableSequence = function () {
        return this.lastSentSequence + 1 - this.recoveryBuffer.size();
    };
    Connection.prototype.dispatch = function (message) {
        var bos = new _$bufferOutputStream_410.BufferOutputStream();
        _$message_769.writeToBuffer(message, bos);
        this.lastSentSequence += 1;
        this.recoveryBuffer.put(message);
        this.recoveryBuffer.markTime(Date.now());
        this.transport.dispatch(bos.getBuffer());
    };
    Connection.prototype.send = function (message) {
        if (this.fsm.state === 'connected') {
            this.dispatch(message);
            return true;
        }
        return false;
    };
    Connection.prototype.close = function (reason) {
        this.closeReason = reason;
        if (this.fsm.state === 'disconnected') {
            this.onClose();
        }
        else if (this.fsm.change('disconnecting')) {
            this.dispatch(_$message_769.create(_$message_769.types.CLOSE_REQUEST));
            this.scheduledClose = setTimeout(this.transport.close.bind(this.transport), CLOSE_TIMEOUT);
        }
        return this;
    };
    Connection.prototype.closeIdleConnection = function () {
        if (this.fsm.change('disconnecting')) {
            logger.debug('Connection detected as idle');
            this.closeReason = _$closeReason_277.CloseReasonEnum.IDLE_CONNECTION;
            this.transport.close();
        }
    };
    Connection.prototype.getState = function () {
        return this.fsm.state;
    };
    return Connection;
}(_$stream_354.StreamImpl));
_$connection_766.Connection = Connection;

}).call(this)}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
var _$connectionFactory_765 = {};
"use strict";
Object.defineProperty(_$connectionFactory_765, "__esModule", { value: true });
_$connectionFactory_765.create = void 0;
;
function __create_765(transports, reconnectTimeout, recoveryBufferSize) {
    return new _$connection_766.Connection(transports, reconnectTimeout, recoveryBufferSize);
}
_$connectionFactory_765.create = __create_765;

var _$bufferSerialiser_425 = {};
"use strict";
Object.defineProperty(_$bufferSerialiser_425, "__esModule", { value: true });
_$bufferSerialiser_425.BufferSerialiser =  void 0;
var BufferSerialiserClass =  (function () {
    function BufferSerialiserClass() {
    }
    BufferSerialiserClass.prototype.read = function (bis) {
        return bis.readMany(bis.count - bis.pos);
    };
    BufferSerialiserClass.prototype.write = function (bos, val) {
        bos.writeMany(val);
    };
    return BufferSerialiserClass;
}());
 void BufferSerialiserClass;
_$bufferSerialiser_425.BufferSerialiser = new BufferSerialiserClass();

var _$optionsImpl_707 = {};
(function (global){(function (){
'use strict';
var __assign = this && this.__assign || function () {
    __assign = Object.assign || function (t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s)
                if (Object.prototype.hasOwnProperty.call(s, p))
                    t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __values = this && this.__values || function (o) {
    var s = typeof Symbol === 'function' && Symbol.iterator, m = s && o[s], i = 0;
    if (m)
        return m.call(o);
    if (o && typeof o.length === 'number')
        return {
            next: function () {
                if (o && i >= o.length)
                    o = void 0;
                return {
                    value: o && o[i++],
                    done: !o
                };
            }
        };
    throw new TypeError(s ? 'Object is not iterable.' : 'Symbol.iterator is not defined.');
};
var _a;
Object.defineProperty(_$optionsImpl_707, '__esModule', { value: true });
_$optionsImpl_707.OptionsImpl = _$optionsImpl_707.MIN_MAX_MESSAGE_SIZE = _$optionsImpl_707.DEFAULT_RETRY_STRATEGY = void 0;
;
;
;
var DEFAULT_HOST = typeof window !== 'undefined' && window.location.hostname ? window.location.hostname : 'localhost';
var DEFAULT_PORT = typeof window !== 'undefined' && window.location.protocol === 'http:' && window.location.port ? parseInt(window.location.port, 10) : 80;
var DEFAULT_SECURE_PORT = typeof window !== 'undefined' && window.location.protocol === 'https:' && window.location.port ? parseInt(window.location.port, 10) : 443;
var DEFAULT_SECURE = typeof window === 'undefined' || window.location.protocol !== 'http:';
var DEFAULT_PATH = '/diffusion';
var DEFAULT_CONNECT_TIMEOUT = (_a = global.DIFFUSION_CONNECT_TIMEOUT) !== null && _a !== void 0 ? _a : 10000;
_$optionsImpl_707.DEFAULT_RETRY_STRATEGY = {
    attempts: 0,
    interval: 0
};
var DEFAULT_RECONNECT_TIMEOUT = 60000;
var DEFAULT_RECONNECT_STRATEGY = function (start) {
    setTimeout(start, 5000);
};
var DEFAULT_ABORT_STRATEGY = function (start, abort) {
    abort();
};
var DEFAULT_PRINCIPAL = '';
var DEFAULT_PASSWORD = '';
var DEFAULT_ACTIVITY_MONITOR = true;
var DEFAULT_TRANSPORTS = typeof window === 'undefined' ? ['WEBSOCKET'] : [
    'WEBSOCKET',
    'XHR'
];
var DEFAULT_MAX_MESSAGE_SIZE = 2147483647;
_$optionsImpl_707.MIN_MAX_MESSAGE_SIZE = 1024;
var OptionsImpl = function () {
    function OptionsImpl(options) {
        if (options === void 0) {
            options = {};
        }
        var _a;
        if (options.host === undefined) {
            options.host = DEFAULT_HOST;
        } else if ((options.host.match(/:/g) || []).length === 1 || options.host.match(/^\[[^\]]*\]:\d+$/)) {
            var portSep = options.host.lastIndexOf(':');
            if (options.port === undefined) {
                options.port = parseInt(options.host.substr(portSep + 1), 10);
            }
            options.host = options.host.substr(0, portSep);
        }
        if (options.host.indexOf(':') > -1 && !options.host.match(/^\[/)) {
            options.host = '[' + options.host + ']';
        }
        if (options.path === undefined) {
            options.path = DEFAULT_PATH;
        } else {
            if (options.path[0] !== '/') {
                options.path = '/' + options.path;
            }
            if (options.path.substring(options.path.length - DEFAULT_PATH.length) !== DEFAULT_PATH) {
                if (options.path[options.path.length - 1] === '/') {
                    options.path = options.path.substring(0, options.path.length - 1);
                }
                options.path = options.path + DEFAULT_PATH;
            }
        }
        if (options.port !== undefined) {
            if (typeof options.port === 'string') {
                if (isNaN(parseInt(options.port, 10))) {
                    options.port = undefined;
                } else {
                    options.port = parseInt(options.port, 10);
                }
            }
        }
        if (options.secure === undefined) {
            if (options.port === undefined) {
                options.secure = DEFAULT_SECURE;
            } else {
                options.secure = options.port === DEFAULT_SECURE_PORT ? true : false;
            }
        }
        if (options.port === undefined) {
            options.port = options.secure ? DEFAULT_SECURE_PORT : DEFAULT_PORT;
        }
        this.host = options.host;
        this.port = options.port;
        this.path = options.path;
        this.secure = options.secure;
        this.connectionTimeout = (_a = options.connectionTimeout) !== null && _a !== void 0 ? _a : DEFAULT_CONNECT_TIMEOUT;
        if (options.retry) {
            if (options.retry.attempts === null || options.retry.attempts === undefined) {
                if (options.retry.interval === null || options.retry.interval === undefined) {
                    this.retry = __assign({}, _$optionsImpl_707.DEFAULT_RETRY_STRATEGY);
                } else {
                    this.retry = {
                        attempts: _$math_753.MAX_SAFE_INTEGER,
                        interval: options.retry.interval
                    };
                }
            } else {
                _$requireNonNull_759.requireNonNull(options.retry.interval, 'options.retry.interval');
                this.retry = options.retry;
            }
        } else {
            this.retry = __assign({}, _$optionsImpl_707.DEFAULT_RETRY_STRATEGY);
        }
        if (options.reconnect === undefined || typeof options.reconnect === 'boolean' && options.reconnect) {
            this.reconnect = {
                timeout: DEFAULT_RECONNECT_TIMEOUT,
                strategy: DEFAULT_RECONNECT_STRATEGY
            };
        } else if (typeof options.reconnect === 'number') {
            this.reconnect = {
                timeout: options.reconnect,
                strategy: DEFAULT_RECONNECT_STRATEGY
            };
        } else if (typeof options.reconnect === 'function') {
            this.reconnect = {
                timeout: DEFAULT_RECONNECT_TIMEOUT,
                strategy: options.reconnect
            };
        } else if (typeof options.reconnect === 'object') {
            this.reconnect = {
                timeout: options.reconnect.timeout === undefined ? DEFAULT_RECONNECT_TIMEOUT : options.reconnect.timeout,
                strategy: options.reconnect.strategy || DEFAULT_RECONNECT_STRATEGY
            };
        } else {
            this.reconnect = {
                timeout: 0,
                strategy: DEFAULT_ABORT_STRATEGY
            };
        }
        if (options.principal !== undefined) {
            this.principal = options.principal || DEFAULT_PRINCIPAL;
            if (typeof options.credentials === 'string') {
                this.credentials = options.credentials;
            } else if (isTypedArray(options.credentials)) {
                this.credentials = new Uint8Array(options.credentials.buffer, options.credentials.byteOffset, options.credentials.byteLength);
            } else if (Array.isArray(options.credentials)) {
                ensureOctetArray(options.credentials);
                this.credentials = Uint8Array.from(options.credentials);
            } else {
                this.credentials = DEFAULT_PASSWORD;
            }
        }
        if (typeof options.transports === 'string') {
            this.transports = [options.transports];
        } else if (typeof options.transports === 'object' && options.transports instanceof Array && options.transports.length > 0) {
            this.transports = options.transports.slice();
        } else {
            this.transports = DEFAULT_TRANSPORTS.slice();
        }
        this.transports = this.transports.slice().map(function (t) {
            return t.toUpperCase();
        });
        var mms = options.maxMessageSize && options.maxMessageSize > _$optionsImpl_707.MIN_MAX_MESSAGE_SIZE ? options.maxMessageSize : DEFAULT_MAX_MESSAGE_SIZE;
        this.maxMessageSize = mms;
        this.activityMonitor = options.activityMonitor !== undefined ? options.activityMonitor : DEFAULT_ACTIVITY_MONITOR;
        if (options.properties !== undefined) {
            var properties_1 = {};
            Object.getOwnPropertyNames(options.properties).forEach(function (key) {
                properties_1[key] = options.properties[key].toString();
            });
            this.properties = properties_1;
        }
        this.httpProxyAgent = options.httpProxyAgent;
        if (options.tlsOptions !== undefined) {
            var tlsOptions_1 = options.tlsOptions;
            this.tlsOptions = [
                'ca',
                'cert',
                'ciphers',
                'clientCertEngine',
                'crl',
                'dhparam',
                'ecdhCurve',
                'honorCipherOrder',
                'key',
                'passphrase',
                'pfx',
                'secureOptions',
                'secureProtocol',
                'sessionIdContext',
                'rejectUnauthorized'
            ].filter(function (key) {
                return key in tlsOptions_1;
            }).reduce(function (obj, key) {
                obj[key] = tlsOptions_1[key];
                return obj;
            }, {});
        }
    }
    OptionsImpl.prototype.with = function (options) {
        var e_1, _a, e_2, _b;
        var o = {};
        var k;
        try {
            for (var _c = __values(Object.getOwnPropertyNames(this)), _d = _c.next(); !_d.done; _d = _c.next()) {
                k = _d.value;
                o[k] = this[k];
            }
        } catch (e_1_1) {
            e_1 = { error: e_1_1 };
        } finally {
            try {
                if (_d && !_d.done && (_a = _c.return))
                    _a.call(_c);
            } finally {
                if (e_1)
                    throw e_1.error;
            }
        }
        try {
            for (var _e = __values(Object.getOwnPropertyNames(options)), _f = _e.next(); !_f.done; _f = _e.next()) {
                k = _f.value;
                o[k] = options[k];
            }
        } catch (e_2_1) {
            e_2 = { error: e_2_1 };
        } finally {
            try {
                if (_f && !_f.done && (_b = _e.return))
                    _b.call(_e);
            } finally {
                if (e_2)
                    throw e_2.error;
            }
        }
        return new OptionsImpl(o);
    };
    return OptionsImpl;
}();
_$optionsImpl_707.OptionsImpl = OptionsImpl;
function ensureOctetArray(value) {
    value.forEach(function (element) {
        if (typeof element !== 'number' || element > 127 || element < -128) {
            throw new _$errors_280.IllegalArgumentError('Custom credentials invalid. Element must be octet.');
        }
    });
}
function isTypedArray(obj) {
    return obj instanceof Int8Array || obj instanceof Int16Array || obj instanceof Int32Array || obj instanceof Uint8Array || obj instanceof Uint8ClampedArray || obj instanceof Uint16Array || obj instanceof Uint32Array || obj instanceof Float32Array || obj instanceof Float64Array;
}
}).call(this)}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
var _$workerCommand_776 = {};
"use strict";
Object.defineProperty(_$workerCommand_776, "__esModule", { value: true });
_$workerCommand_776.WorkerStreamCommand = _$workerCommand_776.WorkerSessionLockCommand = _$workerCommand_776.WorkerCommand = void 0;
var WorkerCommand;
(function (WorkerCommand) {
    WorkerCommand["CONNECT"] = "connect";
    WorkerCommand["CONNECT_EXISTING"] = "connect-existing";
    WorkerCommand["CLOSE"] = "close";
    WorkerCommand["MESSAGE"] = "message";
    WorkerCommand["STREAM"] = "stream";
    WorkerCommand["SERVICE"] = "service";
    WorkerCommand["LOCK"] = "lock";
    WorkerCommand["CID"] = "cid";
})(WorkerCommand = _$workerCommand_776.WorkerCommand || (_$workerCommand_776.WorkerCommand = {}));
var WorkerSessionLockCommand;
(function (WorkerSessionLockCommand) {
    WorkerSessionLockCommand["ACQUIRED"] = "acquired";
    WorkerSessionLockCommand["ACQUIRE_ERROR"] = "acquire_error";
    WorkerSessionLockCommand["OWNED"] = "owned";
    WorkerSessionLockCommand["REMOVED"] = "removed";
    WorkerSessionLockCommand["RELEASED"] = "released";
    WorkerSessionLockCommand["RELEASE_ERROR"] = "release_error";
})(WorkerSessionLockCommand = _$workerCommand_776.WorkerSessionLockCommand || (_$workerCommand_776.WorkerSessionLockCommand = {}));
var WorkerStreamCommand;
(function (WorkerStreamCommand) {
    WorkerStreamCommand["OPEN"] = "open";
    WorkerStreamCommand["VALUE"] = "value";
    WorkerStreamCommand["SUBSCRIPTION"] = "subscription";
    WorkerStreamCommand["UNSUBSCRIPTION"] = "unsubscription";
    WorkerStreamCommand["SUBSCRIPTION_ERROR"] = "subscription_error";
})(WorkerStreamCommand = _$workerCommand_776.WorkerStreamCommand || (_$workerCommand_776.WorkerStreamCommand = {}));

var _$internalSessionLocksProxy_771 = {};
"use strict";
var ____read_771 = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(_$internalSessionLocksProxy_771, "__esModule", { value: true });
_$internalSessionLocksProxy_771.InternalSessionLocksProxy =  void 0;
;
;
;
var __log_771 = _$logger_752.create('InternalSessionLocksProxy');
var SessionLockProxy =  (function () {
    function SessionLockProxy(name, sequence, scope, ownedSetter, releaseLock) {
        var _this = this;
        this.owned = true;
        this.name = name;
        this.sequence = sequence;
        this.scope = scope;
        this.releaseLock = releaseLock;
        ownedSetter.setOwned = function (newOwned) {
            _this.owned = newOwned;
        };
    }
    SessionLockProxy.prototype.getName = function () {
        return this.name;
    };
    SessionLockProxy.prototype.getSequence = function () {
        return this.sequence;
    };
    SessionLockProxy.prototype.isOwned = function () {
        return this.owned;
    };
    SessionLockProxy.prototype.getScope = function () {
        return this.scope;
    };
    SessionLockProxy.prototype.unlock = function () {
        if (this.owned) {
            this.owned = false;
            return this.releaseLock(this);
        }
        else {
            return Promise.resolve(false);
        }
    };
    return SessionLockProxy;
}());
 void SessionLockProxy;
var InternalSessionLocksProxy =  (function () {
    function InternalSessionLocksProxy(connector) {
        var _this = this;
        this.activeRequests = {};
        this.releaseRequests = {};
        this.locks = {};
        this.nextRequestId = 0;
        this.connector = connector;
        this.connector.on('lock_event', function (eventArgs) {
            var _a = ____read_771(eventArgs, 3), lockName = _a[0], action = _a[1], data = _a[2];
            switch (action) {
                case _$workerCommand_776.WorkerSessionLockCommand.ACQUIRED:
                    _this.onLockAcquired(lockName, data);
                    break;
                case _$workerCommand_776.WorkerSessionLockCommand.ACQUIRE_ERROR:
                    _this.onLockAcquireError(lockName, data);
                    break;
                case _$workerCommand_776.WorkerSessionLockCommand.OWNED:
                    _this.onLockOwned(lockName, data);
                    break;
                case _$workerCommand_776.WorkerSessionLockCommand.REMOVED:
                    _this.onLockRemoved(lockName);
                    break;
                case _$workerCommand_776.WorkerSessionLockCommand.RELEASED:
                    _this.onLockReleased(data);
                    break;
                case _$workerCommand_776.WorkerSessionLockCommand.RELEASE_ERROR:
                    _this.onLockReleaseError(data);
                    break;
                default:
                    __log_771.error("Unrecognised lock_event " + action);
            }
        });
    }
    InternalSessionLocksProxy.prototype.onLockAcquired = function (lockName, data) {
        var _a = ____read_771(data, 3), requestId = _a[0], sequence = _a[1], scope = _a[2];
        if (this.activeRequests[requestId] !== undefined) {
            this.activeRequests[requestId](undefined, lockName, _$Long_274.fromString(sequence, 10), scope);
            delete this.activeRequests[requestId];
        }
    };
    InternalSessionLocksProxy.prototype.onLockAcquireError = function (lockName, data) {
        var _a = ____read_771(data, 2), requestId = _a[0], error = _a[1];
        if (this.activeRequests[requestId] !== undefined) {
            this.activeRequests[requestId](error, lockName);
            delete this.activeRequests[requestId];
        }
    };
    InternalSessionLocksProxy.prototype.onLockOwned = function (lockName, newOwned) {
        if (this.locks[lockName] !== undefined) {
            this.locks[lockName].ownedSetter.setOwned(newOwned);
        }
    };
    InternalSessionLocksProxy.prototype.onLockRemoved = function (lockName) {
        delete this.locks[lockName];
    };
    InternalSessionLocksProxy.prototype.onLockReleased = function (data) {
        var _a = ____read_771(data, 2), requestId = _a[0], success = _a[1];
        this.releaseRequests[requestId](undefined, success);
    };
    InternalSessionLocksProxy.prototype.onLockReleaseError = function (data) {
        var _a = ____read_771(data, 2), requestId = _a[0], error = _a[1];
        this.releaseRequests[requestId](error);
    };
    InternalSessionLocksProxy.prototype.handleAcquisition = function (lockName, sequence, scope) {
        var oldLock = this.locks[lockName];
        if (oldLock !== undefined && oldLock.lock.getSequence().equals(sequence)) {
            return oldLock.lock;
        }
        var sessionLockOwnedSetter = {
            setOwned:  function () {
                throw Error('Session lock ownedSetter must be implemented');
            }
        };
        var sessionLock = new SessionLockProxy(lockName, sequence, scope, sessionLockOwnedSetter, this.releaseLock.bind(this));
        this.locks[lockName] = { lock: sessionLock, ownedSetter: sessionLockOwnedSetter };
        return sessionLock;
    };
    InternalSessionLocksProxy.prototype.releaseLock = function (sessionLock) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            var requestId = _this.nextRequestId++;
            _this.releaseRequests[requestId] = function (err, success) {
                delete _this.releaseRequests[requestId];
                if (err) {
                    __log_771.debug('Release shared-session lock failed');
                    reject(err);
                }
                else {
                    resolve(success);
                }
            };
            _this.connector.send(_$workerCommand_776.WorkerCommand.LOCK, JSON.stringify({
                action: 'release',
                requestId: requestId,
                name: sessionLock.getName(),
                sequence: sessionLock.getSequence().toString(10),
                scope: sessionLock.getScope()
            }));
        });
    };
    InternalSessionLocksProxy.prototype.lock = function (lockName, scope) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            if (_this.locks[lockName] !== undefined && _this.locks[lockName].lock.isOwned()) {
                resolve(_this.locks[lockName].lock);
            }
            else {
                var requestId_1 = _this.nextRequestId++;
                _this.activeRequests[requestId_1] = function (err, name, sequence, responseScope) {
                    delete _this.activeRequests[requestId_1];
                    if (err) {
                        __log_771.debug('Acquire shared-session lock failed');
                        reject(err);
                    }
                    else {
                        resolve(_this.handleAcquisition(name, sequence, responseScope));
                    }
                };
                _this.connector.send(_$workerCommand_776.WorkerCommand.LOCK, JSON.stringify({
                    action: 'acquire',
                    requestId: requestId_1,
                    name: lockName,
                    scope: scope
                }));
            }
        });
    };
    return InternalSessionLocksProxy;
}());
_$internalSessionLocksProxy_771.InternalSessionLocksProxy = InternalSessionLocksProxy;

var _$valueStreamWorkerReceiver_775 = {};
"use strict";
Object.defineProperty(_$valueStreamWorkerReceiver_775, "__esModule", { value: true });
_$valueStreamWorkerReceiver_775.ValueStreamWorkerReceiver = void 0;
var __datatypes_1_775 = _$datatypes_324({});
;
;
;
;
;
;
;
var __log_775 = _$logger_752.create('ValueStreamWorkerReceiver');
function deserialiseTopicSpecification(specification) {
    var bis = new _$bufferInputStream_409.BufferInputStream(_$uint8array_762.uint8FromBase64(specification));
    return _$topicSpecificationSerialiser_734.read(bis);
}
function deserialiseValue(value, streamDatatype, specification) {
    if (!value) {
        return null;
    }
    if (streamDatatype.name() === 'any') {
        var datatype = (specification.type === _$topicType_784.TopicType.TIME_SERIES)
            ? __datatypes_1_775.DataTypes.timeseries(__datatypes_1_775.DataTypes.get(specification.properties.TIME_SERIES_EVENT_VALUE_TYPE))
            : __datatypes_1_775.DataTypes.get(specification.type);
        return datatype.readValue(value);
    }
    return streamDatatype.readValue(value);
}
var ValueStreamWorkerReceiver =  (function () {
    function ValueStreamWorkerReceiver(stream, datatype) {
        this.stream = stream;
        this.datatype = datatype;
    }
    ValueStreamWorkerReceiver.prototype.onOpen = function () {
        this.stream.onOpen();
    };
    ValueStreamWorkerReceiver.prototype.onValue = function (data) {
        try {
            var response = JSON.parse(data);
            var specification = deserialiseTopicSpecification(response.specification);
            var oldContent = response.oldValue ? _$uint8array_762.uint8FromBase64(response.oldValue) : null;
            var newContent = _$uint8array_762.uint8FromBase64(response.newValue);
            this.stream.onValue(response.path, specification, oldContent, newContent, deserialiseValue(oldContent, this.datatype, specification), deserialiseValue(newContent, this.datatype, specification));
        }
        catch (err) {
            __log_775.error('Invalid data', err);
        }
    };
    ValueStreamWorkerReceiver.prototype.onSubscription = function (data) {
        var response = JSON.parse(data);
        this.stream.onSubscription(response.path, deserialiseTopicSpecification(response.specification));
    };
    ValueStreamWorkerReceiver.prototype.onUnsubscription = function (data) {
        var response = JSON.parse(data);
        var reason = response.reason !== undefined
            ? _$topics_785.UnsubscribeReasonEnum[_$topics_785.UnsubscribeReasonEnum[response.reason]]
            : _$topics_785.UnsubscribeReasonEnum.UNKNOWN_UNSUBSCRIBE_REASON;
        this.stream.onUnsubscription(response.path, deserialiseTopicSpecification(response.specification), reason);
    };
    ValueStreamWorkerReceiver.prototype.onSubscriptionError = function (error) {
        this.stream.onSubscriptionError(_$errorReason_279.ErrorReason[_$errorReason_279.ErrorReason[parseInt(error, 10)]]);
    };
    return ValueStreamWorkerReceiver;
}());
_$valueStreamWorkerReceiver_775.ValueStreamWorkerReceiver = ValueStreamWorkerReceiver;

var _$streamRegistryWebWorkerProxy_774 = {};
"use strict";
var ____read_774 = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var ____values_774 = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(_$streamRegistryWebWorkerProxy_774, "__esModule", { value: true });
_$streamRegistryWebWorkerProxy_774.StreamRegistryWebworkerProxy = void 0;
;
;
;
;
var NEXT_ADAPTER_ID = (function () {
    var id = new _$Long_274(0);
    return function () {
        id = id.add(1);
        return new _$conversationId_314.ConversationId(id);
    };
})();
var StreamRegistryWebworkerProxy =  (function () {
    function StreamRegistryWebworkerProxy(connector) {
        var _this = this;
        this.connector = connector;
        this.adapters = {};
        this.connector.on({
            stream_event: function (eventArgs) {
                var _a = ____read_774(eventArgs, 4), adapterId = _a[0], event = _a[1], error = _a[2], response = _a[3];
                var adapter = _this.adapters[adapterId];
                if (adapter) {
                    switch (event) {
                        case _$workerCommand_776.WorkerStreamCommand.OPEN:
                            adapter.onOpen();
                            break;
                        case _$workerCommand_776.WorkerStreamCommand.VALUE:
                            adapter.onValue(response);
                            break;
                        case _$workerCommand_776.WorkerStreamCommand.SUBSCRIPTION:
                            adapter.onSubscription(response);
                            break;
                        case _$workerCommand_776.WorkerStreamCommand.UNSUBSCRIPTION:
                            adapter.onUnsubscription(response);
                            break;
                        case _$workerCommand_776.WorkerStreamCommand.SUBSCRIPTION_ERROR:
                            adapter.onSubscriptionError(error);
                            break;
                    }
                }
            }
        });
    }
    StreamRegistryWebworkerProxy.prototype.add = function (selector, stream, datatype) {
        var adapterId = NEXT_ADAPTER_ID();
        this.adapters[adapterId.toString()] = new _$valueStreamWorkerReceiver_775.ValueStreamWorkerReceiver(stream, datatype);
        var streamData = {
            action: 'add',
            adapterId: adapterId.toString(),
            topic: selector.expression,
            datatype: datatype.name()
        };
        this.connector.send(_$workerCommand_776.WorkerCommand.STREAM, JSON.stringify(streamData));
    };
    StreamRegistryWebworkerProxy.prototype.addFallback = function (stream, datatype) {
        var adapterId = NEXT_ADAPTER_ID();
        this.adapters[adapterId.toString()] = new _$valueStreamWorkerReceiver_775.ValueStreamWorkerReceiver(stream, datatype);
        var streamData = {
            action: 'add_fallback',
            adapterId: adapterId.toString(),
            datatype: datatype.name()
        };
        this.connector.send(_$workerCommand_776.WorkerCommand.STREAM, JSON.stringify(streamData));
    };
    StreamRegistryWebworkerProxy.prototype.remove = function (stream) {
        var e_1, _a;
        try {
            for (var _b = ____values_774(Object.getOwnPropertyNames(this.adapters)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var adapterId = _c.value;
                if (this.adapters[adapterId].stream === stream) {
                    var streamData = {
                        action: 'remove',
                        adapterId: adapterId.toString()
                    };
                    this.connector.send(_$workerCommand_776.WorkerCommand.STREAM, JSON.stringify(streamData));
                    delete this.adapters[adapterId];
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    StreamRegistryWebworkerProxy.prototype.close = function () {
        var streamData = {
            action: 'close_registry'
        };
        this.connector.send(_$workerCommand_776.WorkerCommand.STREAM, JSON.stringify(streamData));
    };
    return StreamRegistryWebworkerProxy;
}());
_$streamRegistryWebWorkerProxy_774.StreamRegistryWebworkerProxy = StreamRegistryWebworkerProxy;

var _$internalSessionWebworkerProxy_772 = {};
"use strict";
var ____extends_772 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var ____read_772 = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(_$internalSessionWebworkerProxy_772, "__esModule", { value: true });
_$internalSessionWebworkerProxy_772.InternalSessionWebworkerProxy = void 0;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
var __log_772 = _$logger_752.create('InternalSessionWebworkerProxy');
var SHARED_WORKER_CONNECT_TIMEOUT = 1000;
var InternalSessionWebworkerProxy =  (function (_super) {
    ____extends_772(InternalSessionWebworkerProxy, _super);
    function InternalSessionWebworkerProxy(conversationSetFactory, serviceRegistry, connector, opts) {
        var _this = this;
        var factory = _$emitter_353.Emitter.create();
        _this = _super.call(this, factory) || this;
        _this.emitter = factory.emitter(_this);
        _this.connector = connector;
        _this.opts = opts;
        _this.connected = false;
        _this.state = _$internalSession_301.InternalSessionState.INITIALISING;
        _this.connector.on({
            connect_event: function (connectArgs) {
                var _a = ____read_772(connectArgs, 3), sessionID = _a[0], options = _a[1], serverMaximumMessageSize = _a[2];
                try {
                    _this.serverMaximumMessageSize = parseInt(serverMaximumMessageSize, 10);
                    _this.opts = JSON.parse(options);
                    _this.sessionID = _$sessionId_709.SessionId.fromString(sessionID);
                    _this.connected = true;
                    _this.emitter.emit('connect', _this.sessionID, new _$optionsImpl_707.OptionsImpl(_this.opts));
                }
                catch (err) {
                    __log_772.error('Unable to parse options from shared session', err);
                    _this.emitter.emit('error', new Error('Unable to parse options from shared session'));
                }
            },
            connect_error: function (error) {
                _this.connector.disconnect();
                _this.emitter.emit('error', _$closeReason_277.CloseReasonEnum[error] || new Error(error));
            },
            reconnect_event: function () {
                _this.connected = true;
                _this.emitter.emit('reconnect');
            },
            disconnect_event: function (reason) {
                _this.connected = false;
                var reasonKey = _$closeReason_277.CloseReasonEnum[reason];
                _this.emitter.emit('disconnect', _$closeReason_277.CloseReasonEnum[reasonKey]);
            },
            close_event: function (reason) {
                _this.connector.disconnect();
                _this.connected = false;
                var reasonKey = _$closeReason_277.CloseReasonEnum[reason];
                _this.emitter.close(_$closeReason_277.CloseReasonEnum[reasonKey]);
            },
            error_event: function (err) {
                _this.connector.disconnect();
                _this.connected = false;
                _this.emitter.emit('error', new Error(err));
            },
            command_response: function (responseArgs) {
                var _a = ____read_772(responseArgs, 2), cidStr = _a[0], inputStr = _a[1];
                var cid = _$conversationId_314.ConversationId.fromString(cidStr);
                var input = new _$bufferInputStream_409.BufferInputStream(_$uint8array_762.uint8FromBase64(inputStr));
                _this.conversationSet.respondIfPresent(cid, input);
            },
            command_error: function (responseArgs) {
                var _a = ____read_772(responseArgs, 2), cidStr = _a[0], errorStr = _a[1];
                var cid = _$conversationId_314.ConversationId.fromString(cidStr);
                var error;
                try {
                    error = JSON.parse(errorStr);
                }
                catch (err) {
                    error = new Error('Could not parse error response');
                }
                _this.conversationSet.discard(cid, error);
            },
            service_request: function (requestArgs) {
                var _a = ____read_772(requestArgs, 3), serviceIdStr = _a[0], ridStr = _a[1], inputStr = _a[2];
                var rid = _$conversationId_314.ConversationId.fromString(ridStr);
                var bos = new _$bufferOutputStream_410.BufferOutputStream();
                _$commandHeaderSerialiser_442.CommandHeaderSerialiser.write(bos, new _$commandHeader_443.CommandHeader(parseInt(serviceIdStr, 10), rid));
                _$bufferSerialiser_425.BufferSerialiser.write(bos, _$uint8array_762.uint8FromBase64(inputStr));
                var input = new _$bufferInputStream_409.BufferInputStream(bos.getBuffer());
                _this.serviceAdapter.onMessage(_$message_769.types.SERVICE_REQUEST, input);
            },
            state_change: function (newState) {
                _this.state = newState;
            }
        });
        _this.serviceAdapter = new _$serviceAdapter_302.ServiceAdapter(_this, function (msg) { _this.connector.sendMessage(msg); });
        _this.serviceLocator = new _$serviceLocator_303.ServiceLocatorImpl(_this, _this.serviceAdapter);
        _this.serviceRegistry = serviceRegistry;
        _this.serviceRegistry.addListener(_this.serviceAdapter.addService.bind(_this.serviceAdapter));
        _this.serviceRegistry.addListener(function (definition) {
            _this.connector.send(_$workerCommand_776.WorkerCommand.SERVICE, JSON.stringify({
                action: 'add',
                serviceId: definition.id
            }));
        });
        _this.topicStreamRegistry = new _$streamRegistryWebWorkerProxy_774.StreamRegistryWebworkerProxy(_this.connector);
        _this.conversationSet = conversationSetFactory();
        _this.sessionLocks = new _$internalSessionLocksProxy_771.InternalSessionLocksProxy(_this.connector);
        return _this;
    }
    InternalSessionWebworkerProxy.prototype.connect = function () {
        var _this = this;
        if (this.opts) {
            var _a = this.opts, credentials = _a.credentials, reconnect = _a.reconnect, opts = __rest(_a, ["credentials", "reconnect"]);
            var isCredentialsBuffer = credentials instanceof Uint8Array;
            var credentialsStr = isCredentialsBuffer ? _$uint8array_762.uint8ToBase64(credentials) : credentials;
            opts.reconnect = reconnect.timeout;
            this.connector.send(_$workerCommand_776.WorkerCommand.CONNECT, JSON.stringify([opts, isCredentialsBuffer, credentialsStr]));
        }
        else {
            this.connector.send(_$workerCommand_776.WorkerCommand.CONNECT_EXISTING);
        }
        var connectAckReceived = false;
        this.connector.on('connect_ack', function () {
            connectAckReceived = true;
        });
        setTimeout(function () {
            if (!connectAckReceived) {
                _this.emitter.emit('error', new Error('Unable to connect to shared worker'));
                _this.connector.close();
            }
        }, SHARED_WORKER_CONNECT_TIMEOUT);
    };
    InternalSessionWebworkerProxy.prototype.close = function () {
        if (this.state !== _$internalSession_301.InternalSessionState.CLOSED) {
            this.connector.send(_$workerCommand_776.WorkerCommand.CLOSE);
        }
        return this;
    };
    InternalSessionWebworkerProxy.prototype.isConnected = function () {
        return this.connected;
    };
    InternalSessionWebworkerProxy.prototype.checkConnected = function (reject) {
        if (this.isConnected()) {
            return true;
        }
        else {
            reject(new Error('The session is not connected. Operations are not possible at this time.'));
            return false;
        }
    };
    InternalSessionWebworkerProxy.prototype.getSessionId = function () {
        return this.sessionID;
    };
    InternalSessionWebworkerProxy.prototype.getPrincipal = function () {
        if (this.opts === undefined) {
            throw new _$errors_280.IllegalStateError('Shared session is not connected');
        }
        return this.opts.principal || '';
    };
    InternalSessionWebworkerProxy.prototype.setPrincipal = function (newPrincipal) {
        if (this.opts === undefined) {
            throw new _$errors_280.IllegalStateError('Shared session is not connected');
        }
        this.opts.principal = newPrincipal;
    };
    InternalSessionWebworkerProxy.prototype.getOptions = function () {
        if (this.opts === undefined) {
            throw new _$errors_280.IllegalStateError('Shared session is not connected');
        }
        return this.opts;
    };
    InternalSessionWebworkerProxy.prototype.getState = function () {
        return this.state;
    };
    InternalSessionWebworkerProxy.prototype.getServerMaximumMessageSize = function () {
        return this.serverMaximumMessageSize;
    };
    InternalSessionWebworkerProxy.prototype.lock = function (lockName, scope) {
        return this.sessionLocks.lock(lockName, scope);
    };
    InternalSessionWebworkerProxy.prototype.onSystemPing = function () {
        throw new _$errors_280.InternalError('Method not implemented.');
    };
    InternalSessionWebworkerProxy.prototype.getStreamRegistry = function () {
        return this.topicStreamRegistry;
    };
    InternalSessionWebworkerProxy.prototype.getServiceRegistry = function () {
        return this.serviceRegistry;
    };
    InternalSessionWebworkerProxy.prototype.getRouting = function () {
        throw new _$errors_280.InternalError('Method not implemented.');
    };
    InternalSessionWebworkerProxy.prototype.getServiceLocator = function () {
        return this.serviceLocator;
    };
    InternalSessionWebworkerProxy.prototype.getConversationSet = function () {
        return this.conversationSet;
    };
    InternalSessionWebworkerProxy.prototype.isShared = function () {
        return true;
    };
    InternalSessionWebworkerProxy.prototype.getContext = function () {
        return _$sessionContextImpl_309.sessionContext;
    };
    InternalSessionWebworkerProxy.prototype.updateFeatures = function () {
    };
    return InternalSessionWebworkerProxy;
}(_$stream_354.StreamImpl));
_$internalSessionWebworkerProxy_772.InternalSessionWebworkerProxy = InternalSessionWebworkerProxy;

var _$sharedWorkers_773 = {};
"use strict";
var ____extends_773 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ____values_773 = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var ____read_773 = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var ____spreadArray_773 = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(_$sharedWorkers_773, "__esModule", { value: true });
_$sharedWorkers_773.getSharedConversationSetFactory = _$sharedWorkers_773.SharedSessionConnector =   void 0;
;
;
;
;
;
;
;
;
var SharedWorkerMessageRouter =  (function () {
    function SharedWorkerMessageRouter(workerJs) {
        var _this = this;
        this.listeners = {};
        this.worker = new SharedWorker(workerJs);
        this.worker.port.onmessage = function (message) {
            var e_1, _a;
            var sessionName = message.data[0];
            if (_this.listeners[sessionName] !== undefined) {
                try {
                    for (var _b = ____values_773(_this.listeners[sessionName]), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var listener = _c.value;
                        listener.apply(void 0, ____spreadArray_773([message.data[1]], ____read_773(message.data.slice(2))));
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
            }
        };
    }
    SharedWorkerMessageRouter.prototype.getWorker = function () {
        return this.worker;
    };
    SharedWorkerMessageRouter.prototype.addListener = function (sessionName, listener) {
        if (this.listeners[sessionName] === undefined) {
            this.listeners[sessionName] = [listener];
        }
        else {
            this.listeners[sessionName].push(listener);
        }
    };
    SharedWorkerMessageRouter.prototype.removeListener = function (sessionName, listener) {
        if (this.listeners[sessionName] !== undefined) {
            this.listeners[sessionName] = this.listeners[sessionName].filter(function (l) { return l !== listener; });
        }
    };
    return SharedWorkerMessageRouter;
}());
 void SharedWorkerMessageRouter;
var sharedWorkers = {};
function getSharedWorker(workerJs) {
    if (!window || !window.SharedWorker) {
        throw new _$errors_280.RuntimeError('SharedWorker could not be found!');
    }
    if (sharedWorkers[workerJs] === undefined) {
        sharedWorkers[workerJs] = new SharedWorkerMessageRouter(workerJs);
    }
    return sharedWorkers[workerJs];
}
 void getSharedWorker;
var SharedSessionConnector =  (function (_super) {
    ____extends_773(SharedSessionConnector, _super);
    function SharedSessionConnector(sessionName, workerJs) {
        var _this = this;
        var factory = _$emitter_353.Emitter.create();
        _this = _super.call(this, factory) || this;
        _this.emitter = factory.emitter(_this);
        _this.sessionName = sessionName;
        _this.router = getSharedWorker(workerJs);
        _this.worker = _this.router.getWorker();
        _this.listener = function (command) {
            var messages = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                messages[_i - 1] = arguments[_i];
            }
            if (messages.length < 2) {
                _this.emitter.emit(command, messages[0]);
            }
            else {
                _this.emitter.emit(command, messages);
            }
        };
        _this.router.addListener(sessionName, _this.listener);
        return _this;
    }
    SharedSessionConnector.prototype.send = function (command, message) {
        this.worker.port.postMessage([this.sessionName, command, message]);
    };
    SharedSessionConnector.prototype.sendMessage = function (msg) {
        var msgData = {
            type: msg.type,
            encoding: msg.encoding,
            data: _$uint8array_762.uint8ToBase64(msg.data),
            stream: _$uint8array_762.uint8ToBase64(msg.getBuffer()),
            headers: msg.headers,
            id: msg.id,
            topic: msg.topic
        };
        this.send(_$workerCommand_776.WorkerCommand.MESSAGE, JSON.stringify(msgData));
    };
    SharedSessionConnector.prototype.disconnect = function () {
        this.router.removeListener(this.sessionName, this.listener);
    };
    return SharedSessionConnector;
}(_$stream_354.StreamImpl));
_$sharedWorkers_773.SharedSessionConnector = SharedSessionConnector;
function getSharedConversationSetFactory(connector) {
    var pendingCidRequests = [];
    function nextCid() {
        return new Promise(function (resolve) {
            pendingCidRequests.push(resolve);
            connector.send(_$workerCommand_776.WorkerCommand.CID);
        });
    }
    connector.on('cid_event', function (cidStr) {
        if (pendingCidRequests.length > 0) {
            var resolve = pendingCidRequests.shift();
            resolve(new _$conversationId_314.ConversationId(_$Long_274.fromString(cidStr)));
        }
    });
    return function () {
        return new _$conversationSet_315.ConversationSet(nextCid);
    };
}
_$sharedWorkers_773.getSharedConversationSetFactory = getSharedConversationSetFactory;

var _$internalSessionFactory_299 = {};
"use strict";
Object.defineProperty(_$internalSessionFactory_299, "__esModule", { value: true });
_$internalSessionFactory_299.create = _$internalSessionFactory_299.createShared =  void 0;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
function createInternal(options) {
    options = _$requireNonNull_759.requireNonNull(options, 'options');
    var serviceRegistry = new _$serviceRegistry_304.ServiceRegistryImpl();
    serviceRegistry.add(_$pingServices_589.USER_PING, _$pingService_308.pingService);
    serviceRegistry.add(_$pingServices_589.SYSTEM_PING, _$monitoredPingService_305.monitoredPingService);
    serviceRegistry.add(_$services_624.NOTIFY_SUBSCRIPTION, _$notifySubscriptionService_306.notifySubscriptionService);
    serviceRegistry.add(_$services_624.UNSUBSCRIPTION_NOTIFICATION, _$notifyUnsubscriptionService_307.notifyUnsubscriptionService);
    return new _$internalSessionImpl_300.InternalSessionImpl(_$conversationSet_315.create, serviceRegistry, _$connectionFactory_765.create, options);
}
 void createInternal;
function createShared(name, workerJs) {
    var serviceRegistry = new _$serviceRegistry_304.ServiceRegistryImpl();
    var connector = new _$sharedWorkers_773.SharedSessionConnector(name, workerJs);
    var conversationSetFactory = _$sharedWorkers_773.getSharedConversationSetFactory(connector);
    return function (options) {
        return new _$internalSessionWebworkerProxy_772.InternalSessionWebworkerProxy(conversationSetFactory, serviceRegistry, connector, options);
    };
}
_$internalSessionFactory_299.createShared = createShared;
function __create_299(name, workerJs) {
    if (name === undefined && workerJs === undefined) {
        return createInternal;
    }
    else if (name !== undefined && workerJs !== undefined) {
        return createShared(name, workerJs);
    }
    else {
        throw new _$errors_280.NullValueError('Missing parameter "name" or "workerJs" when creating a shared session');
    }
}
_$internalSessionFactory_299.create = __create_299;

var _$remoteServers_284 = {};
"use strict";
Object.defineProperty(_$remoteServers_284, "__esModule", { value: true });
_$remoteServers_284.RemoteServerType = _$remoteServers_284.ConnectionState = _$remoteServers_284.ConnectionOption = void 0;
var ConnectionOption;
(function (ConnectionOption) {
    ConnectionOption[ConnectionOption["CONNECTION_TIMEOUT"] = 1] = "CONNECTION_TIMEOUT";
    ConnectionOption[ConnectionOption["INPUT_BUFFER_SIZE"] = 2] = "INPUT_BUFFER_SIZE";
    ConnectionOption[ConnectionOption["MAXIMUM_QUEUE_SIZE"] = 3] = "MAXIMUM_QUEUE_SIZE";
    ConnectionOption[ConnectionOption["OUTPUT_BUFFER_SIZE"] = 4] = "OUTPUT_BUFFER_SIZE";
    ConnectionOption[ConnectionOption["RECONNECTION_TIMEOUT"] = 5] = "RECONNECTION_TIMEOUT";
    ConnectionOption[ConnectionOption["RECOVERY_BUFFER_SIZE"] = 6] = "RECOVERY_BUFFER_SIZE";
    ConnectionOption[ConnectionOption["RETRY_DELAY"] = 7] = "RETRY_DELAY";
    ConnectionOption[ConnectionOption["WRITE_TIMEOUT"] = 8] = "WRITE_TIMEOUT";
})(ConnectionOption = _$remoteServers_284.ConnectionOption || (_$remoteServers_284.ConnectionOption = {}));
var ConnectionState;
(function (ConnectionState) {
    ConnectionState[ConnectionState["INACTIVE"] = 1] = "INACTIVE";
    ConnectionState[ConnectionState["CONNECTED"] = 2] = "CONNECTED";
    ConnectionState[ConnectionState["RETRYING"] = 3] = "RETRYING";
    ConnectionState[ConnectionState["FAILED"] = 4] = "FAILED";
    ConnectionState[ConnectionState["MISSING"] = 5] = "MISSING";
})(ConnectionState = _$remoteServers_284.ConnectionState || (_$remoteServers_284.ConnectionState = {}));
var RemoteServerType;
(function (RemoteServerType) {
    RemoteServerType[RemoteServerType["SECONDARY_INITIATOR"] = 1] = "SECONDARY_INITIATOR";
    RemoteServerType[RemoteServerType["PRIMARY_INITIATOR"] = 2] = "PRIMARY_INITIATOR";
    RemoteServerType[RemoteServerType["SECONDARY_ACCEPTOR"] = 3] = "SECONDARY_ACCEPTOR";
})(RemoteServerType = _$remoteServers_284.RemoteServerType || (_$remoteServers_284.RemoteServerType = {}));

var _$sessionEventParametersBuilder_356 = {};
"use strict";
var ____assign_356 = (this && this.__assign) || function () {
    ____assign_356 = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return ____assign_356.apply(this, arguments);
};
Object.defineProperty(_$sessionEventParametersBuilder_356, "__esModule", { value: true });
_$sessionEventParametersBuilder_356.SessionEventParametersBuilderImpl = void 0;
var SessionEventParametersBuilderImpl =  (function () {
    function SessionEventParametersBuilderImpl() {
        this.sessionEventParameters = {};
    }
    SessionEventParametersBuilderImpl.prototype.filter = function (filter) {
        this.sessionEventParameters = ____assign_356(____assign_356({}, this.sessionEventParameters), { filter: filter });
        return this;
    };
    SessionEventParametersBuilderImpl.prototype.properties = function (properties) {
        var propertyArgs = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            propertyArgs[_i - 1] = arguments[_i];
        }
        if (typeof properties === 'string') {
            properties = [properties].concat(propertyArgs);
        }
        this.sessionEventParameters = ____assign_356(____assign_356({}, this.sessionEventParameters), { properties: new Set(properties) });
        return this;
    };
    SessionEventParametersBuilderImpl.prototype.after = function (time) {
        this.sessionEventParameters = ____assign_356(____assign_356({}, this.sessionEventParameters), { after: time instanceof Date ? time.getTime() : time });
        return this;
    };
    SessionEventParametersBuilderImpl.prototype.build = function () {
        return {
            filter: this.sessionEventParameters.filter,
            properties: this.sessionEventParameters.properties,
            after: this.sessionEventParameters.after
        };
    };
    return SessionEventParametersBuilderImpl;
}());
_$sessionEventParametersBuilder_356.SessionEventParametersBuilderImpl = SessionEventParametersBuilderImpl;

var _$abstractMetricCollector_566 = {};
"use strict";
Object.defineProperty(_$abstractMetricCollector_566, "__esModule", { value: true });
_$abstractMetricCollector_566.AbstractMetricCollector = void 0;
;
var AbstractMetricCollector =  (function () {
    function AbstractMetricCollector(name, exportToPrometheus, maximumGroups) {
        if (name.length === 0) {
            throw new _$errors_280.IllegalArgumentError('name cannot be empty');
        }
        if (maximumGroups < 1) {
            throw new _$errors_280.IllegalArgumentError("maximumGroups must be positive: " + maximumGroups);
        }
        this.name = name;
        this.maximumGroups = maximumGroups;
        this.exportToPrometheus = exportToPrometheus;
    }
    return AbstractMetricCollector;
}());
_$abstractMetricCollector_566.AbstractMetricCollector = AbstractMetricCollector;

var _$sessionMetricCollector_573 = {};
"use strict";
var ____extends_573 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$sessionMetricCollector_573, "__esModule", { value: true });
_$sessionMetricCollector_573.SessionMetricCollectorImpl = void 0;
;
var SessionMetricCollectorImpl =  (function (_super) {
    ____extends_573(SessionMetricCollectorImpl, _super);
    function SessionMetricCollectorImpl(name, exportToPrometheus, maximumGroups, removeMetricsWithNoMatches, sessionFilter, groupByProperties) {
        var _this = _super.call(this, name, exportToPrometheus, maximumGroups) || this;
        _this.sessionFilter = sessionFilter;
        _this.groupByProperties = groupByProperties;
        _this.removeMetricsWithNoMatches = removeMetricsWithNoMatches;
        return _this;
    }
    return SessionMetricCollectorImpl;
}(_$abstractMetricCollector_566.AbstractMetricCollector));
_$sessionMetricCollector_573.SessionMetricCollectorImpl = SessionMetricCollectorImpl;

var _$sessionMetricCollectorBuilder_365 = {};
"use strict";
Object.defineProperty(_$sessionMetricCollectorBuilder_365, "__esModule", { value: true });
_$sessionMetricCollectorBuilder_365.SessionMetricCollectorBuilderImpl = void 0;
;
;
;
var SessionMetricCollectorBuilderImpl =  (function () {
    function SessionMetricCollectorBuilderImpl() {
        this.reset();
    }
    SessionMetricCollectorBuilderImpl.prototype.reset = function () {
        this.exportToPrometheusProp = false;
        this.maximumGroupsProp = _$math_753.MAX_INT32;
        this.groupByPropertiesProp = [];
        this.removesMetricsWithNoMatchesProp = false;
        return this;
    };
    SessionMetricCollectorBuilderImpl.prototype.exportToPrometheus = function (exportMetrics) {
        this.exportToPrometheusProp = exportMetrics;
        return this;
    };
    SessionMetricCollectorBuilderImpl.prototype.maximumGroups = function (limit) {
        this.maximumGroupsProp = limit;
        return this;
    };
    SessionMetricCollectorBuilderImpl.prototype.groupByProperty = function (propertyName) {
        this.groupByPropertiesProp.push(_$requireNonNull_759.requireNonNull(propertyName, 'propertyName'));
        return this;
    };
    SessionMetricCollectorBuilderImpl.prototype.groupByProperties = function (propertyNames) {
        this.groupByPropertiesProp = _$requireNonNull_759.requireNonNull(propertyNames, 'propertyNames');
        return this;
    };
    SessionMetricCollectorBuilderImpl.prototype.removeMetricsWithNoMatches = function (remove) {
        this.removesMetricsWithNoMatchesProp = remove;
        return this;
    };
    SessionMetricCollectorBuilderImpl.prototype.create = function (name, sessionFilter) {
        return new _$sessionMetricCollector_573.SessionMetricCollectorImpl(_$requireNonNull_759.requireNonNull(name, 'name'), this.exportToPrometheusProp, this.maximumGroupsProp, this.removesMetricsWithNoMatchesProp, _$requireNonNull_759.requireNonNull(sessionFilter, 'sessionFilter'), this.groupByPropertiesProp);
    };
    return SessionMetricCollectorBuilderImpl;
}());
_$sessionMetricCollectorBuilder_365.SessionMetricCollectorBuilderImpl = SessionMetricCollectorBuilderImpl;

var _$topicMetricCollector_577 = {};
"use strict";
var ____extends_577 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$topicMetricCollector_577, "__esModule", { value: true });
_$topicMetricCollector_577.TopicMetricCollectorImpl = void 0;
;
;
var TopicMetricCollectorImpl =  (function (_super) {
    ____extends_577(TopicMetricCollectorImpl, _super);
    function TopicMetricCollectorImpl(name, exportToPrometheus, maximumGroups, topicSelector, groupByTopicType, groupByTopicView, groupByPathPrefixParts) {
        var _this = _super.call(this, name, exportToPrometheus, maximumGroups) || this;
        _this.topicSelector = topicSelector;
        _this.groupByTopicType = groupByTopicType;
        _this.groupByTopicView = groupByTopicView;
        _this.groupByPathPrefixParts = _$requireNonNull_759.requireNonNegative(groupByPathPrefixParts, 'groupByPathPrefixParts');
        return _this;
    }
    return TopicMetricCollectorImpl;
}(_$abstractMetricCollector_566.AbstractMetricCollector));
_$topicMetricCollector_577.TopicMetricCollectorImpl = TopicMetricCollectorImpl;

var _$topicMetricCollectorBuilder_366 = {};
"use strict";
Object.defineProperty(_$topicMetricCollectorBuilder_366, "__esModule", { value: true });
_$topicMetricCollectorBuilder_366.TopicMetricCollectorBuilderImpl = void 0;
;
;
;
var TopicMetricCollectorBuilderImpl =  (function () {
    function TopicMetricCollectorBuilderImpl() {
        this.exportToPrometheusProp = false;
        this.groupByTopicTypeProp = false;
        this.groupByTopicViewProp = false;
        this.groupByPathPrefixPartsProp = 0;
        this.reset();
    }
    TopicMetricCollectorBuilderImpl.prototype.reset = function () {
        this.exportToPrometheusProp = false;
        this.maximumGroupsProp = _$math_753.MAX_INT32;
        this.groupByTopicTypeProp = false;
        this.groupByTopicViewProp = false;
        this.groupByPathPrefixPartsProp = 0;
        return this;
    };
    TopicMetricCollectorBuilderImpl.prototype.exportToPrometheus = function (exportMetrics) {
        this.exportToPrometheusProp = exportMetrics;
        return this;
    };
    TopicMetricCollectorBuilderImpl.prototype.maximumGroups = function (limit) {
        this.maximumGroupsProp = limit;
        return this;
    };
    TopicMetricCollectorBuilderImpl.prototype.groupByTopicType = function (group) {
        this.groupByTopicTypeProp = group;
        return this;
    };
    TopicMetricCollectorBuilderImpl.prototype.groupByTopicView = function (group) {
        this.groupByTopicViewProp = group;
        return this;
    };
    TopicMetricCollectorBuilderImpl.prototype.groupByPathPrefixParts = function (parts) {
        this.groupByPathPrefixPartsProp = parts;
        return this;
    };
    TopicMetricCollectorBuilderImpl.prototype.create = function (name, topicSelector) {
        _$requireNonNull_759.requireNonNull(topicSelector, 'topicSelector');
        return new _$topicMetricCollector_577.TopicMetricCollectorImpl(_$requireNonNull_759.requireNonNull(name, 'name'), this.exportToPrometheusProp, this.maximumGroupsProp, typeof topicSelector === 'string' ? topicSelector : topicSelector.expression, this.groupByTopicTypeProp, this.groupByTopicViewProp, this.groupByPathPrefixPartsProp);
    };
    return TopicMetricCollectorBuilderImpl;
}());
_$topicMetricCollectorBuilder_366.TopicMetricCollectorBuilderImpl = TopicMetricCollectorBuilderImpl;

var _$remoteServerDefinition_600 = {};
"use strict";
Object.defineProperty(_$remoteServerDefinition_600, "__esModule", { value: true });
_$remoteServerDefinition_600.RemoteServerDefinitionImpl = void 0;
;
var RemoteServerDefinitionImpl =  (function () {
    function RemoteServerDefinitionImpl(type, name, urls, principal, connectionOptions, credentials, connector, missingTopicNotificationFilter) {
        var _a;
        this.type = type;
        this.name = name;
        this.url = urls[0];
        this.urls = urls;
        this.principal = principal;
        this.credentials = credentials;
        this.connectionOptions = connectionOptions;
        this.connector = connector;
        this.missingTopicNotificationFilter = missingTopicNotificationFilter;
        this.primaryHostName = urls[0];
        this.retryDelay = parseInt((_a = connectionOptions[_$remoteServers_284.ConnectionOption.RETRY_DELAY]) !== null && _a !== void 0 ? _a : '1000', 10);
    }
    RemoteServerDefinitionImpl.createPrimaryDefinition = function (name, urls, retryDelay, connector) {
        var _a;
        return new RemoteServerDefinitionImpl(_$remoteServers_284.RemoteServerType.PRIMARY_INITIATOR, name, urls, '', (_a = {}, _a[_$remoteServers_284.ConnectionOption.RETRY_DELAY] = "" + retryDelay, _a), null, connector);
    };
    RemoteServerDefinitionImpl.createSecondaryDefinition = function (type, name, url, principal, connectionOptions, missingTopicNotificationFilter, credentials) {
        return new RemoteServerDefinitionImpl(type, name, [url], principal, connectionOptions, credentials, undefined, missingTopicNotificationFilter);
    };
    return RemoteServerDefinitionImpl;
}());
_$remoteServerDefinition_600.RemoteServerDefinitionImpl = RemoteServerDefinitionImpl;

var _$remoteServerBuilderBase_370 = {};
"use strict";
Object.defineProperty(_$remoteServerBuilderBase_370, "__esModule", { value: true });
_$remoteServerBuilderBase_370.RemoteServerBuilderBaseImpl = void 0;
;
;
;
var RemoteServerBuilderBaseImpl =  (function () {
    function RemoteServerBuilderBaseImpl(type) {
        this.type = type;
    }
    RemoteServerBuilderBaseImpl.validateName = function (name) {
        _$requireNonNull_759.requireNonNull(name, 'name');
        var trimmedName = name.trim();
        if (trimmedName.length === 0) {
            throw new _$errors_280.IllegalArgumentError('Non whitespace name must be supplied');
        }
        return trimmedName;
    };
    RemoteServerBuilderBaseImpl.prototype.validateUrl = function (url) {
        _$requireNonNull_759.requireNonNull(url, 'url');
        var trimmedUrl = url.trim();
        var uri;
        try {
            uri = new URL(trimmedUrl);
        }
        catch (e) {
            throw new _$errors_280.IllegalArgumentError('Invalid URL');
        }
        if (uri.protocol !== 'ws:' && uri.protocol !== 'wss:') {
            throw new _$errors_280.IllegalArgumentError("Transport for url " + url + " must be ws");
        }
        if (this.type === _$remoteServers_284.RemoteServerType.PRIMARY_INITIATOR && uri.protocol === 'wss:') {
            throw new _$errors_280.IllegalArgumentError("Invalid url " + url + " - secure connection not supported for primary initiator connections");
        }
        else if (this.type === _$remoteServers_284.RemoteServerType.SECONDARY_ACCEPTOR && uri.protocol !== 'wss:') {
            throw new _$errors_280.IllegalArgumentError("Invalid url " + url + " - connection must be secure for secondary acceptor connections");
        }
        return trimmedUrl;
    };
    return RemoteServerBuilderBaseImpl;
}());
_$remoteServerBuilderBase_370.RemoteServerBuilderBaseImpl = RemoteServerBuilderBaseImpl;

var _$primaryInitiatorBuilder_369 = {};
"use strict";
var ____extends_369 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$primaryInitiatorBuilder_369, "__esModule", { value: true });
_$primaryInitiatorBuilder_369.PrimaryInitiatorBuilderImpl = void 0;
;
;
;
;
;
var PrimaryInitiatorBuilderImpl =  (function (_super) {
    ____extends_369(PrimaryInitiatorBuilderImpl, _super);
    function PrimaryInitiatorBuilderImpl() {
        var _this = _super.call(this, _$remoteServers_284.RemoteServerType.PRIMARY_INITIATOR) || this;
        _this.theRetryDelay = 1000;
        return _this;
    }
    PrimaryInitiatorBuilderImpl.validateConnector = function (connector) {
        _$requireNonNull_759.requireNonNull(connector, 'connector');
        var trimmedName = connector.trim();
        if (trimmedName.length === 0) {
            throw new _$errors_280.IllegalArgumentError('Non whitespace connector must be supplied');
        }
        return trimmedName;
    };
    PrimaryInitiatorBuilderImpl.prototype.validateUrls = function (urls) {
        var _this = this;
        if (urls.length === 0) {
            throw new _$errors_280.IllegalArgumentError('urls is empty');
        }
        return urls.map(function (url) { return _this.validateUrl(url); });
    };
    PrimaryInitiatorBuilderImpl.prototype.retryDelay = function (delay) {
        _$requireNonNull_759.requireNonNull(delay, 'delay');
        if (delay < 0) {
            throw new _$errors_280.IllegalArgumentError('delay is invalid');
        }
        this.theRetryDelay = delay;
        return this;
    };
    PrimaryInitiatorBuilderImpl.prototype.reset = function () {
        this.theRetryDelay = 1000;
        return this;
    };
    PrimaryInitiatorBuilderImpl.prototype.build = function (name, urls, connector) {
        return _$remoteServerDefinition_600.RemoteServerDefinitionImpl.createPrimaryDefinition(PrimaryInitiatorBuilderImpl.validateName(name), this.validateUrls(_$requireNonNull_759.requireNonNull(urls, 'urls')), this.theRetryDelay, PrimaryInitiatorBuilderImpl.validateConnector(connector));
    };
    return PrimaryInitiatorBuilderImpl;
}(_$remoteServerBuilderBase_370.RemoteServerBuilderBaseImpl));
_$primaryInitiatorBuilder_369.PrimaryInitiatorBuilderImpl = PrimaryInitiatorBuilderImpl;

var _$remoteServerBuilder_371 = {};
"use strict";
var ____assign_371 = (this && this.__assign) || function () {
    ____assign_371 = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return ____assign_371.apply(this, arguments);
};
Object.defineProperty(_$remoteServerBuilder_371, "__esModule", { value: true });
_$remoteServerBuilder_371.RemoteServerBuilderImpl = void 0;
;
;
;
;
var RemoteServerBuilderImpl =  (function () {
    function RemoteServerBuilderImpl(topicSelectors) {
        this.thePrincipal = '';
        this.theCredentials = undefined;
        this.theConnectionOptions = {};
        this.theMissingTopicNotificationFilter = undefined;
        this.theTopicSelectors = topicSelectors;
    }
    RemoteServerBuilderImpl.prototype.principal = function (principal) {
        this.thePrincipal = _$requireNonNull_759.requireNonNull(principal, 'principal');
        return this;
    };
    RemoteServerBuilderImpl.prototype.credentials = function (credentials) {
        this.theCredentials = credentials;
        return this;
    };
    RemoteServerBuilderImpl.prototype.connectionOptions = function (connectionOptions) {
        _$requireNonNull_759.requireNonNull(connectionOptions, 'connectionOptions');
        this.theConnectionOptions = ____assign_371({}, connectionOptions);
        return this;
    };
    RemoteServerBuilderImpl.prototype.connectionOption = function (connectionOption, value) {
        if (value === null || value === undefined) {
            delete this.theConnectionOptions[_$requireNonNull_759.requireNonNull(connectionOption, 'connectionOption')];
        }
        else {
            this.theConnectionOptions[_$requireNonNull_759.requireNonNull(connectionOption, 'connectionOption')] = value;
        }
        return this;
    };
    RemoteServerBuilderImpl.prototype.missingTopicNotificationFilter = function (filter) {
        if (filter !== null) {
            try {
                this.theTopicSelectors.parse(filter);
            }
            catch (err) {
                throw new _$errors_280.IllegalArgumentError("filter is invalid: " + err);
            }
        }
        this.theMissingTopicNotificationFilter = filter === null ? undefined : filter;
        return this;
    };
    RemoteServerBuilderImpl.prototype.reset = function () {
        this.thePrincipal = '';
        this.theCredentials = undefined;
        this.theConnectionOptions = {};
        this.theMissingTopicNotificationFilter = undefined;
        return this;
    };
    RemoteServerBuilderImpl.prototype.create = function (name, url) {
        var trimmedName = _$requireNonNull_759.requireNonNull(name, 'name').trim();
        if (trimmedName.length === 0) {
            throw new _$errors_280.IllegalArgumentError('Non whitespace name must be supplied');
        }
        var trimmedUrl = _$requireNonNull_759.requireNonNull(url, 'url').trim();
        if (trimmedUrl.length === 0) {
            throw new _$errors_280.IllegalArgumentError('Non whitespace url must be supplied');
        }
        return new _$remoteServerDefinition_600.RemoteServerDefinitionImpl(_$remoteServers_284.RemoteServerType.SECONDARY_INITIATOR, trimmedName, [trimmedUrl], this.thePrincipal, this.theConnectionOptions, this.theCredentials, undefined, this.theMissingTopicNotificationFilter);
    };
    return RemoteServerBuilderImpl;
}());
_$remoteServerBuilder_371.RemoteServerBuilderImpl = RemoteServerBuilderImpl;

var _$limitTimeouts_751 = {};
"use strict";
Object.defineProperty(_$limitTimeouts_751, "__esModule", { value: true });
_$limitTimeouts_751.limitTimeout = void 0;
;
var __log_751 = _$logger_752.create('Internal Session');
var MAXIMUM_TIMEOUT = 60 * 60 * 1000;
function limitTimeout(description, supplied) {
    if (supplied > MAXIMUM_TIMEOUT) {
        __log_751.warn('CONFIG_EXCESSIVE_TIMEOUT', supplied, description, MAXIMUM_TIMEOUT);
        return MAXIMUM_TIMEOUT;
    }
    return supplied;
}
_$limitTimeouts_751.limitTimeout = limitTimeout;

var _$secondaryBuilder_374 = {};
"use strict";
var ____extends_374 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ____values_374 = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var ____read_374 = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(_$secondaryBuilder_374, "__esModule", { value: true });
_$secondaryBuilder_374.SecondaryBuilderImpl = void 0;
;
;
;
;
;
;
function parseIntOptionValue(value) {
    var intValue = Number.parseInt(value.trim(), 10);
    if (Number.isNaN(intValue)) {
        throw new _$errors_280.IllegalArgumentError(value + " is not a number");
    }
    return intValue;
}
var SecondaryBuilderImpl =  (function (_super) {
    ____extends_374(SecondaryBuilderImpl, _super);
    function SecondaryBuilderImpl(type, topicSelectors) {
        var _this = _super.call(this, type) || this;
        _this.thePrincipal = '';
        _this.theCredentials = undefined;
        _this.theConnectionOptions = {};
        _this.theMissingTopicNotificationFilter = undefined;
        _this.topicSelectors = topicSelectors;
        return _this;
    }
    SecondaryBuilderImpl.minimumValueOption = function (option, value, minimum) {
        var size;
        try {
            size = parseIntOptionValue(value);
        }
        catch (err) {
            throw new _$errors_280.IllegalArgumentError("Connection Option '" + _$remoteServers_284.ConnectionOption[option] + "' value '" + value + "' is invalid");
        }
        if (size < minimum) {
            throw new _$errors_280.IllegalArgumentError("Connection Option '" + _$remoteServers_284.ConnectionOption[option] + "' value '" + value + "' cannot be less than " + minimum);
        }
        return size.toString();
    };
    SecondaryBuilderImpl.timeoutOption = function (option, value) {
        try {
            return _$limitTimeouts_751.limitTimeout(option.toString(), parseIntOptionValue(value)).toString();
        }
        catch (err) {
            throw new _$errors_280.IllegalArgumentError("Connection Option '" + _$remoteServers_284.ConnectionOption[option] + "' value '" + value + "' is invalid");
        }
    };
    SecondaryBuilderImpl.prototype.validateConnectionOption = function (option, value) {
        this.validateOption(option, value);
        switch (option) {
            case _$remoteServers_284.ConnectionOption.CONNECTION_TIMEOUT:
            case _$remoteServers_284.ConnectionOption.WRITE_TIMEOUT:
            case _$remoteServers_284.ConnectionOption.RECONNECTION_TIMEOUT:
                return SecondaryBuilderImpl.timeoutOption(option, value);
            case _$remoteServers_284.ConnectionOption.INPUT_BUFFER_SIZE:
            case _$remoteServers_284.ConnectionOption.OUTPUT_BUFFER_SIZE:
                return SecondaryBuilderImpl.minimumValueOption(option, value, _$optionsImpl_707.MIN_MAX_MESSAGE_SIZE);
            case _$remoteServers_284.ConnectionOption.MAXIMUM_QUEUE_SIZE:
                return SecondaryBuilderImpl.minimumValueOption(option, value, 1);
            case _$remoteServers_284.ConnectionOption.RECOVERY_BUFFER_SIZE:
                return SecondaryBuilderImpl.minimumValueOption(option, value, 0);
            case _$remoteServers_284.ConnectionOption.RETRY_DELAY:
                return SecondaryBuilderImpl.minimumValueOption(option, value, 0);
            default:
                throw new _$errors_280.IllegalArgumentError("Unknown option " + option);
        }
    };
    SecondaryBuilderImpl.prototype.validateOption = function (option, value) {
        if (value === null || value === undefined) {
            throw new _$errors_280.IllegalArgumentError("Connection Option '" + _$remoteServers_284.ConnectionOption[option] + "' value is null");
        }
        if (this.type === _$remoteServers_284.RemoteServerType.SECONDARY_ACCEPTOR
            && SecondaryBuilderImpl.INVALID_ACCEPTOR_OPTIONS.includes(option)) {
            throw new _$errors_280.IllegalArgumentError("Connection Option '" + _$remoteServers_284.ConnectionOption[option] + "' cannot be specified "
                + "for SECONDARY_ACCEPTOR servers");
        }
    };
    SecondaryBuilderImpl.prototype.getPrincipal = function () {
        return this.thePrincipal;
    };
    SecondaryBuilderImpl.prototype.getCredentials = function () {
        return this.theCredentials;
    };
    SecondaryBuilderImpl.prototype.getConnectionOptions = function () {
        return this.theConnectionOptions;
    };
    SecondaryBuilderImpl.prototype.getMissingTopicNotificationFilter = function () {
        return this.theMissingTopicNotificationFilter;
    };
    SecondaryBuilderImpl.prototype.principal = function (principal) {
        this.thePrincipal = principal !== null && principal !== void 0 ? principal : '';
        return this;
    };
    SecondaryBuilderImpl.prototype.credentials = function (credentials) {
        this.theCredentials = credentials || undefined;
        return this;
    };
    SecondaryBuilderImpl.prototype.connectionOptions = function (connectionOptions) {
        var e_1, _a;
        var newOptions = {};
        try {
            for (var _b = ____values_374(Object.entries(connectionOptions)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var _d = ____read_374(_c.value, 2), optionStr = _d[0], entry = _d[1];
                var option = parseInt(optionStr, 10);
                newOptions[option] = this.validateConnectionOption(option, entry);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        this.theConnectionOptions = newOptions;
        return this;
    };
    SecondaryBuilderImpl.prototype.connectionOption = function (connectionOption, value) {
        _$requireNonNull_759.requireNonNull(connectionOption, 'connectionOption');
        if (value === null || value === undefined) {
            delete this.theConnectionOptions[connectionOption];
        }
        else {
            this.theConnectionOptions[connectionOption] = this.validateConnectionOption(connectionOption, value);
        }
        return this;
    };
    SecondaryBuilderImpl.prototype.missingTopicNotificationFilter = function (filter) {
        if (filter !== null && filter !== undefined) {
            try {
                this.topicSelectors.parse(filter);
            }
            catch (err) {
                throw new _$errors_280.IllegalArgumentError("filter is invalid: " + err);
            }
        }
        this.theMissingTopicNotificationFilter = filter || undefined;
        return this;
    };
    SecondaryBuilderImpl.prototype.reset = function () {
        this.thePrincipal = '';
        this.theCredentials = undefined;
        this.theConnectionOptions = {};
        this.theMissingTopicNotificationFilter = undefined;
        return this;
    };
    SecondaryBuilderImpl.INVALID_ACCEPTOR_OPTIONS = [
        _$remoteServers_284.ConnectionOption.RECONNECTION_TIMEOUT,
        _$remoteServers_284.ConnectionOption.RETRY_DELAY,
        _$remoteServers_284.ConnectionOption.RECOVERY_BUFFER_SIZE
    ];
    return SecondaryBuilderImpl;
}(_$remoteServerBuilderBase_370.RemoteServerBuilderBaseImpl));
_$secondaryBuilder_374.SecondaryBuilderImpl = SecondaryBuilderImpl;

var _$secondaryAcceptorBuilder_373 = {};
"use strict";
var ____extends_373 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$secondaryAcceptorBuilder_373, "__esModule", { value: true });
_$secondaryAcceptorBuilder_373.SecondaryAcceptorBuilderImpl = void 0;
;
;
;
;
var SecondaryAcceptorBuilderImpl =  (function (_super) {
    ____extends_373(SecondaryAcceptorBuilderImpl, _super);
    function SecondaryAcceptorBuilderImpl(topicSelectors) {
        return _super.call(this, _$remoteServers_284.RemoteServerType.SECONDARY_ACCEPTOR, topicSelectors) || this;
    }
    SecondaryAcceptorBuilderImpl.prototype.build = function (name, primaryHostName) {
        return _$remoteServerDefinition_600.RemoteServerDefinitionImpl.createSecondaryDefinition(_$remoteServers_284.RemoteServerType.SECONDARY_ACCEPTOR, SecondaryAcceptorBuilderImpl.validateName(name), _$requireNonNull_759.requireNonNull(primaryHostName, 'primaryHostName'), this.getPrincipal(), this.getConnectionOptions(), this.getMissingTopicNotificationFilter(), this.getCredentials());
    };
    return SecondaryAcceptorBuilderImpl;
}(_$secondaryBuilder_374.SecondaryBuilderImpl));
_$secondaryAcceptorBuilder_373.SecondaryAcceptorBuilderImpl = SecondaryAcceptorBuilderImpl;

var _$secondaryInitiatorBuilder_375 = {};
"use strict";
var ____extends_375 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$secondaryInitiatorBuilder_375, "__esModule", { value: true });
_$secondaryInitiatorBuilder_375.SecondaryInitiatorBuilderImpl = void 0;
;
;
;
var SecondaryInitiatorBuilderImpl =  (function (_super) {
    ____extends_375(SecondaryInitiatorBuilderImpl, _super);
    function SecondaryInitiatorBuilderImpl(topicSelectors) {
        return _super.call(this, _$remoteServers_284.RemoteServerType.SECONDARY_INITIATOR, topicSelectors) || this;
    }
    SecondaryInitiatorBuilderImpl.prototype.build = function (name, url) {
        return _$remoteServerDefinition_600.RemoteServerDefinitionImpl.createSecondaryDefinition(_$remoteServers_284.RemoteServerType.SECONDARY_INITIATOR, SecondaryInitiatorBuilderImpl.validateName(name), this.validateUrl(url), this.getPrincipal(), this.getConnectionOptions(), this.getMissingTopicNotificationFilter(), this.getCredentials());
    };
    return SecondaryInitiatorBuilderImpl;
}(_$secondaryBuilder_374.SecondaryBuilderImpl));
_$secondaryInitiatorBuilder_375.SecondaryInitiatorBuilderImpl = SecondaryInitiatorBuilderImpl;

var _$branchMappingTable_391 = {};
"use strict";
Object.defineProperty(_$branchMappingTable_391, "__esModule", { value: true });
_$branchMappingTable_391.BranchMappingTableImpl = void 0;
var BranchMappingTableImpl =  (function () {
    function BranchMappingTableImpl(sessionTreeBranch, branchMappings) {
        this.sessionTreeBranch = sessionTreeBranch;
        this.branchMappings = branchMappings;
    }
    BranchMappingTableImpl.prototype.getSessionTreeBranch = function () {
        return this.sessionTreeBranch;
    };
    BranchMappingTableImpl.prototype.getBranchMappings = function () {
        return this.branchMappings;
    };
    return BranchMappingTableImpl;
}());
_$branchMappingTable_391.BranchMappingTableImpl = BranchMappingTableImpl;

var _$branchMappingTableBuilder_390 = {};
"use strict";
var ____read_390 = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var ____spreadArray_390 = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(_$branchMappingTableBuilder_390, "__esModule", { value: true });
_$branchMappingTableBuilder_390.BranchMappingTableBuilderImpl = void 0;
;
var BranchMappingTableBuilderImpl =  (function () {
    function BranchMappingTableBuilderImpl() {
        this.mappings = [];
    }
    BranchMappingTableBuilderImpl.prototype.reset = function () {
        this.mappings = [];
        return this;
    };
    BranchMappingTableBuilderImpl.prototype.addBranchMapping = function (sessionFilter, topicTreeBranch) {
        this.mappings.push({
            sessionFilter: sessionFilter,
            topicTreeBranch: topicTreeBranch
        });
        return this;
    };
    BranchMappingTableBuilderImpl.prototype.create = function (sessionTreeBranch) {
        return new _$branchMappingTable_391.BranchMappingTableImpl(sessionTreeBranch, ____spreadArray_390([], ____read_390(this.mappings)));
    };
    return BranchMappingTableBuilderImpl;
}());
_$branchMappingTableBuilder_390.BranchMappingTableBuilderImpl = BranchMappingTableBuilderImpl;

var _$diffusionGlobals_352 = {};
"use strict";
Object.defineProperty(_$diffusionGlobals_352, "__esModule", { value: true });
_$diffusionGlobals_352.newSessionEventParametersBuilder = _$diffusionGlobals_352.newRemoteServerBuilder = _$diffusionGlobals_352.newTopicMetricCollectorBuilder = _$diffusionGlobals_352.newSessionMetricCollectorBuilder = _$diffusionGlobals_352.newBranchMappingTableBuilder = _$diffusionGlobals_352.rolesToString = _$diffusionGlobals_352.stringToRoles = _$diffusionGlobals_352.escape = void 0;
;
;
;
;
;
;
;
;
;
;
;
;
function __escape_352(s) {
    return _$string_761.escape(_$requireNonNull_759.requireNonNull(s, 'string'));
}
_$diffusionGlobals_352.escape = __escape_352;
function stringToRoles(s) {
    return _$string_761.stringToSet(_$requireNonNull_759.requireNonNull(s, 'string'));
}
_$diffusionGlobals_352.stringToRoles = stringToRoles;
function rolesToString(roles) {
    return _$string_761.collectionToString(_$requireNonNull_759.requireNonNull(roles, 'roles'));
}
_$diffusionGlobals_352.rolesToString = rolesToString;
function newBranchMappingTableBuilder() {
    return new _$branchMappingTableBuilder_390.BranchMappingTableBuilderImpl();
}
_$diffusionGlobals_352.newBranchMappingTableBuilder = newBranchMappingTableBuilder;
function newSessionMetricCollectorBuilder() {
    return new _$sessionMetricCollectorBuilder_365.SessionMetricCollectorBuilderImpl();
}
_$diffusionGlobals_352.newSessionMetricCollectorBuilder = newSessionMetricCollectorBuilder;
function newTopicMetricCollectorBuilder() {
    return new _$topicMetricCollectorBuilder_366.TopicMetricCollectorBuilderImpl();
}
_$diffusionGlobals_352.newTopicMetricCollectorBuilder = newTopicMetricCollectorBuilder;
function newRemoteServerBuilder(selectors, type 
) {
    switch (type) {
        case undefined:
            return new _$remoteServerBuilder_371.RemoteServerBuilderImpl(selectors);
        case _$remoteServers_284.RemoteServerType.PRIMARY_INITIATOR:
            return new _$primaryInitiatorBuilder_369.PrimaryInitiatorBuilderImpl();
        case _$remoteServers_284.RemoteServerType.SECONDARY_ACCEPTOR:
            return new _$secondaryAcceptorBuilder_373.SecondaryAcceptorBuilderImpl(selectors);
        case _$remoteServers_284.RemoteServerType.SECONDARY_INITIATOR:
            return new _$secondaryInitiatorBuilder_375.SecondaryInitiatorBuilderImpl(selectors);
        default:
            throw new _$errors_280.IllegalArgumentError('Unknown remote server type');
    }
}
_$diffusionGlobals_352.newRemoteServerBuilder = newRemoteServerBuilder;
function newSessionEventParametersBuilder() {
    return new _$sessionEventParametersBuilder_356.SessionEventParametersBuilderImpl();
}
_$diffusionGlobals_352.newSessionEventParametersBuilder = newSessionEventParametersBuilder;

var _$registration_312 = {};
"use strict";
var ____extends_312 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ____awaiter_312 = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var ____generator_312 = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var ____read_312 = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var ____spreadArray_312 = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(_$registration_312, "__esModule", { value: true });
_$registration_312.registerTopicHandler = _$registration_312.registerRequestHandler = _$registration_312.registerHandler = _$registration_312.registrationCallback = _$registration_312.responseHandler = _$registration_312.ResponseHandlerState = void 0;
;
;
var __logger_312 = _$logger_752.create('Registration');
var ResponseHandlerState;
(function (ResponseHandlerState) {
    ResponseHandlerState[ResponseHandlerState["REGISTERING"] = 0] = "REGISTERING";
    ResponseHandlerState[ResponseHandlerState["ACTIVE"] = 1] = "ACTIVE";
    ResponseHandlerState[ResponseHandlerState["CLOSED"] = 2] = "CLOSED";
})(ResponseHandlerState = _$registration_312.ResponseHandlerState || (_$registration_312.ResponseHandlerState = {}));
var RegisteredHandlerException =  (function (_super) {
    ____extends_312(RegisteredHandlerException, _super);
    function RegisteredHandlerException(cause) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        var _this = _super.apply(this, ____spreadArray_312([], ____read_312(args))) || this;
        _this.cause = cause;
        return _this;
    }
    return RegisteredHandlerException;
}(Error));
function responseHandler(internal, adapter, deregistration) {
    var state = ResponseHandlerState.REGISTERING;
    var close;
    return {
        onDiscard: function (cid, err) {
            try {
                if (err instanceof internal.getContext().CloseReason) {
                    adapter.close();
                }
                else {
                    adapter.close(err);
                }
            }
            catch (err) {
                __logger_312.error('REGISTERED_HANDLER_EXCEPTION', err);
            }
            state = ResponseHandlerState.CLOSED;
        },
        onOpen: function (cid) {
            close = function () {
                return new Promise(function (resolve, reject) {
                    if (state !== ResponseHandlerState.CLOSED) {
                        deregistration(cid, function (err) {
                            if (err) {
                                internal.getConversationSet().discard(cid, err);
                                reject(err);
                            }
                            else {
                                internal.getConversationSet().respondIfPresent(cid, ResponseHandlerState.CLOSED);
                                resolve();
                            }
                        });
                    }
                    else {
                        reject(new Error('Handler already closed'));
                    }
                });
            };
        },
        onResponse: function (cid, response) {
            if (response === ResponseHandlerState.CLOSED) {
                try {
                    adapter.close();
                }
                catch (err) {
                    __logger_312.error('REGISTERED_HANDLER_EXCEPTION', err);
                }
                state = response;
                return true;
            }
            try {
                if (response === ResponseHandlerState.ACTIVE) {
                    adapter.active(close, cid);
                    state = response;
                    return false;
                }
                else {
                    return adapter.respond(response);
                }
            }
            catch (err) {
                __logger_312.error('REGISTERED_HANDLER_EXCEPTION', err);
                internal.getConversationSet().discard(cid, new RegisteredHandlerException(err, 'An error was thrown by the handler'));
                close().catch(function (closeErr) {
                    __logger_312.debug('Failed to deregister with the server', closeErr);
                });
            }
            return true;
        }
    };
}
_$registration_312.responseHandler = responseHandler;
function registrationCallback(conversationSet, cid, resolve, reject) {
    return function (err) {
        if (err) {
            conversationSet.discard(cid, err);
            reject(err);
        }
        else {
            conversationSet.respondIfPresent(cid, ResponseHandlerState.ACTIVE);
            resolve();
        }
    };
}
_$registration_312.registrationCallback = registrationCallback;
function registerHandler(internal, params, adapter, reg, dereg) {
    return ____awaiter_312(this, void 0, void 0, function () {
        var conversationSet, serviceLocator, registration, deregistration, cid;
        return ____generator_312(this, function (_a) {
            switch (_a.label) {
                case 0:
                    conversationSet = internal.getConversationSet();
                    serviceLocator = internal.getServiceLocator();
                    registration = serviceLocator.obtain(reg);
                    deregistration = serviceLocator.obtain(dereg);
                    return [4 , conversationSet.newConversation(responseHandler(internal, adapter, function (conversationId, callback) {
                            deregistration.send(params, callback);
                        }))];
                case 1:
                    cid = _a.sent();
                    return [2 , new Promise(function (resolve, reject) {
                            registration.send({ params: params, cid: cid }, registrationCallback(conversationSet, cid, resolve, reject));
                        })];
            }
        });
    });
}
_$registration_312.registerHandler = registerHandler;
function registerRequestHandler(internal, params, adapter) {
    return registerHandler(internal, params, adapter, _$services_624.MESSAGING_RECEIVER_CONTROL_REGISTRATION, _$services_624.MESSAGING_RECEIVER_CONTROL_DEREGISTRATION);
}
_$registration_312.registerRequestHandler = registerRequestHandler;
function registerTopicHandler(internal, params, adapter) {
    return registerHandler(internal, params, adapter, _$services_624.TOPIC_CONTROL_REGISTRATION, _$services_624.TOPIC_CONTROL_DEREGISTRATION);
}
_$registration_312.registerTopicHandler = registerTopicHandler;

var _$sessionFetchResult_358 = {};
"use strict";
Object.defineProperty(_$sessionFetchResult_358, "__esModule", { value: true });
_$sessionFetchResult_358.SessionFetchResultImpl = void 0;
var SessionFetchResultImpl =  (function () {
    function SessionFetchResultImpl(results, totalSelected) {
        this.resultList = results;
        this.totalSelectedCount = totalSelected;
        this.hasMoreFlag = results.length < totalSelected;
    }
    SessionFetchResultImpl.prototype.results = function () {
        return this.resultList;
    };
    SessionFetchResultImpl.prototype.hasMore = function () {
        return this.hasMoreFlag;
    };
    SessionFetchResultImpl.prototype.size = function () {
        return this.resultList.length;
    };
    SessionFetchResultImpl.prototype.totalSelected = function () {
        return this.totalSelectedCount;
    };
    SessionFetchResultImpl.prototype.isEmpty = function () {
        return this.resultList.length === 0;
    };
    return SessionFetchResultImpl;
}());
_$sessionFetchResult_358.SessionFetchResultImpl = SessionFetchResultImpl;

var _$stringSerialiser_431 = {};
"use strict";
Object.defineProperty(_$stringSerialiser_431, "__esModule", { value: true });
_$stringSerialiser_431.StringSerialiser =  void 0;
;
var StringSerialiserClass =  (function () {
    function StringSerialiserClass() {
    }
    StringSerialiserClass.prototype.read = function (bis) {
        return _$codec_411.readString(bis);
    };
    StringSerialiserClass.prototype.write = function (bos, val) {
        _$codec_411.writeString(bos, val);
    };
    return StringSerialiserClass;
}());
 void StringSerialiserClass;
_$stringSerialiser_431.StringSerialiser = new StringSerialiserClass();

var _$clientFilterSubscribeRequestSerialiser_453 = {};
"use strict";
var ____extends_453 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$clientFilterSubscribeRequestSerialiser_453, "__esModule", { value: true });
_$clientFilterSubscribeRequestSerialiser_453.ClientFilterSubscribeRequestSerialiser =  void 0;
;
;
;
var ClientFilterSubscribeRequestSerialiserClass =  (function (_super) {
    ____extends_453(ClientFilterSubscribeRequestSerialiserClass, _super);
    function ClientFilterSubscribeRequestSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ClientFilterSubscribeRequestSerialiserClass.prototype.read = function (bis) {
        var filter = _$codec_411.readString(bis);
        var selector = _$topicSelectorParser_740.parseSelector(_$codec_411.readString(bis));
        var scope = _$codec_411.readString(bis);
        return {
            filter: filter,
            selector: selector,
            scope: scope
        };
    };
    ClientFilterSubscribeRequestSerialiserClass.prototype.write = function (bos, value) {
        _$codec_411.writeString(bos, value.filter);
        _$codec_411.writeString(bos, value.selector.expression);
        _$codec_411.writeString(bos, value.scope);
    };
    return ClientFilterSubscribeRequestSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void ClientFilterSubscribeRequestSerialiserClass;
_$clientFilterSubscribeRequestSerialiser_453.ClientFilterSubscribeRequestSerialiser = new ClientFilterSubscribeRequestSerialiserClass();

var _$errorReport_509 = {};
"use strict";
Object.defineProperty(_$errorReport_509, "__esModule", { value: true });
_$errorReport_509.ErrorReportImpl = void 0;
;
var ErrorReportImpl =  (function () {
    function ErrorReportImpl(message, line, column) {
        this.message = _$requireNonNull_759.requireNonNull(message, 'message');
        this.line = line || 0;
        this.column = column || 0;
    }
    ErrorReportImpl.prototype.toString = function () {
        return "ErrorReport [" + this.message + " at [" + this.line + ":" + this.column + "]]";
    };
    return ErrorReportImpl;
}());
_$errorReport_509.ErrorReportImpl = ErrorReportImpl;

var _$errorReportSerialiser_508 = {};
"use strict";
var ____extends_508 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$errorReportSerialiser_508, "__esModule", { value: true });
_$errorReportSerialiser_508.ErrorReportSerialiser =  void 0;
;
;
;
var ErrorReportSerialiserClass =  (function (_super) {
    ____extends_508(ErrorReportSerialiserClass, _super);
    function ErrorReportSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ErrorReportSerialiserClass.prototype.read = function (input) {
        var message = _$codec_411.readString(input);
        var line = _$codec_411.readInt32(input);
        var column = _$codec_411.readInt32(input);
        return new _$errorReport_509.ErrorReportImpl(message, line, column);
    };
    ErrorReportSerialiserClass.prototype.write = function (output, value) {
        _$codec_411.writeString(output, value.message);
        _$codec_411.writeInt32(output, value.line);
        _$codec_411.writeInt32(output, value.column);
    };
    return ErrorReportSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void ErrorReportSerialiserClass;
_$errorReportSerialiser_508.ErrorReportSerialiser = new ErrorReportSerialiserClass();

var _$clientFilterSubscribeResponse_455 = {};
"use strict";
Object.defineProperty(_$clientFilterSubscribeResponse_455, "__esModule", { value: true });
_$clientFilterSubscribeResponse_455.ClientFilterSubscribeResponse = void 0;
var ClientFilterSubscribeResponse =  (function () {
    function ClientFilterSubscribeResponse(selected, errors) {
        this.selected = selected;
        this.errors = errors;
    }
    ClientFilterSubscribeResponse.prototype.isSuccess = function () {
        return this.errors.length === 0;
    };
    return ClientFilterSubscribeResponse;
}());
_$clientFilterSubscribeResponse_455.ClientFilterSubscribeResponse = ClientFilterSubscribeResponse;

var _$clientFilterSubscribeResponseSerialiser_454 = {};
"use strict";
var ____extends_454 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$clientFilterSubscribeResponseSerialiser_454, "__esModule", { value: true });
_$clientFilterSubscribeResponseSerialiser_454.ClientFilterSubscribeResponseSerialiser =  void 0;
;
;
;
;
var ClientFilterSubscribeResponseSerialiserClass =  (function (_super) {
    ____extends_454(ClientFilterSubscribeResponseSerialiserClass, _super);
    function ClientFilterSubscribeResponseSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ClientFilterSubscribeResponseSerialiserClass.prototype.read = function (bis) {
        var error = _$codec_411.readByte(bis);
        if (error) {
            var errors = _$codec_411.readCollection(bis, _$errorReportSerialiser_508.ErrorReportSerialiser.read);
            return new _$clientFilterSubscribeResponse_455.ClientFilterSubscribeResponse(0, errors);
        }
        else {
            var numSelected = _$codec_411.readInt32(bis);
            return new _$clientFilterSubscribeResponse_455.ClientFilterSubscribeResponse(numSelected, []);
        }
    };
    ClientFilterSubscribeResponseSerialiserClass.prototype.write = function (bos, value) {
        if (value.isSuccess()) {
            _$codec_411.writeByte(bos, 0);
            _$codec_411.writeInt32(bos, value.selected);
        }
        else {
            _$codec_411.writeByte(bos, 1);
            _$codec_411.writeCollection(bos, value.errors, _$errorReportSerialiser_508.ErrorReportSerialiser.write);
        }
    };
    return ClientFilterSubscribeResponseSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void ClientFilterSubscribeResponseSerialiserClass;
_$clientFilterSubscribeResponseSerialiser_454.ClientFilterSubscribeResponseSerialiser = new ClientFilterSubscribeResponseSerialiserClass();

var _$sessionIdSerialiser_708 = {};
"use strict";
Object.defineProperty(_$sessionIdSerialiser_708, "__esModule", { value: true });
_$sessionIdSerialiser_708.SessionIdSerialiser =  void 0;
;
;
var SessionIdSerialiserClass =  (function () {
    function SessionIdSerialiserClass() {
    }
    SessionIdSerialiserClass.prototype.read = function (input) {
        var server = _$codec_411.readInt64(input);
        var value = _$codec_411.readInt64(input);
        return new _$sessionId_709.SessionId(server, value);
    };
    SessionIdSerialiserClass.prototype.write = function (output, sessionId) {
        _$codec_411.writeInt64(output, sessionId.server);
        _$codec_411.writeInt64(output, sessionId.value);
    };
    return SessionIdSerialiserClass;
}());
 void SessionIdSerialiserClass;
_$sessionIdSerialiser_708.SessionIdSerialiser = new SessionIdSerialiserClass();

var _$clientSubscribeRequestSerialiser_456 = {};
"use strict";
var ____extends_456 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$clientSubscribeRequestSerialiser_456, "__esModule", { value: true });
_$clientSubscribeRequestSerialiser_456.ClientSubscribeRequestSerialiser =  void 0;
;
;
;
;
var ClientSubscribeRequestSerialiserClass =  (function (_super) {
    ____extends_456(ClientSubscribeRequestSerialiserClass, _super);
    function ClientSubscribeRequestSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ClientSubscribeRequestSerialiserClass.prototype.read = function (bis) {
        var sessionID = _$sessionIdSerialiser_708.SessionIdSerialiser.read(bis);
        var selector = _$topicSelectorParser_740.parseSelector(_$codec_411.readString(bis));
        var scope = _$codec_411.readString(bis);
        return {
            sessionID: sessionID,
            selector: selector,
            scope: scope
        };
    };
    ClientSubscribeRequestSerialiserClass.prototype.write = function (bos, value) {
        _$sessionIdSerialiser_708.SessionIdSerialiser.write(bos, value.sessionID);
        _$codec_411.writeString(bos, value.selector.expression);
        _$codec_411.writeString(bos, value.scope);
    };
    return ClientSubscribeRequestSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void ClientSubscribeRequestSerialiserClass;
_$clientSubscribeRequestSerialiser_456.ClientSubscribeRequestSerialiser = new ClientSubscribeRequestSerialiserClass();

var _$topicSelection_782 = {};
"use strict";
Object.defineProperty(_$topicSelection_782, "__esModule", { value: true });
_$topicSelection_782.TopicSelectionType = void 0;
var TopicSelectionType;
(function (TopicSelectionType) {
    TopicSelectionType[TopicSelectionType["SELECT"] = 0] = "SELECT";
    TopicSelectionType[TopicSelectionType["DESELECT"] = 1] = "DESELECT";
})(TopicSelectionType = _$topicSelection_782.TopicSelectionType || (_$topicSelection_782.TopicSelectionType = {}));

var _$getSelectorsResultSerialiser_457 = {};
"use strict";
var ____extends_457 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$getSelectorsResultSerialiser_457, "__esModule", { value: true });
_$getSelectorsResultSerialiser_457.GetSelectorsResultSerialiser =  void 0;
;
;
;
;
function readStringTopicSelection(bis) {
    var selectorExpression = _$codec_411.readString(bis);
    var selectorType = _$byteEncodedEnumSerialiser_426.read(bis, _$topicSelection_782.TopicSelectionType);
    return {
        selectorExpression: selectorExpression,
        selectionType: selectorType
    };
}
var GetSelectorsResultSerialiserClass =  (function (_super) {
    ____extends_457(GetSelectorsResultSerialiserClass, _super);
    function GetSelectorsResultSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    GetSelectorsResultSerialiserClass.prototype.read = function (bis) {
        return {
            scopeMap: _$codec_411.readDictionary(bis, function (bis) { return _$codec_411.readCollection(bis, readStringTopicSelection); })
        };
    };
    return GetSelectorsResultSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void GetSelectorsResultSerialiserClass;
_$getSelectorsResultSerialiser_457.GetSelectorsResultSerialiser = new GetSelectorsResultSerialiserClass();

var _$unsubscribeAllByFilterRequestSerialiser_458 = {};
"use strict";
var ____extends_458 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$unsubscribeAllByFilterRequestSerialiser_458, "__esModule", { value: true });
_$unsubscribeAllByFilterRequestSerialiser_458.UnsubscribeAllByFilterRequestSerialiser =  void 0;
;
;
var UnsubscribeAllByFilterRequestSerialiserClass =  (function (_super) {
    ____extends_458(UnsubscribeAllByFilterRequestSerialiserClass, _super);
    function UnsubscribeAllByFilterRequestSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UnsubscribeAllByFilterRequestSerialiserClass.prototype.write = function (bos, value) {
        _$codec_411.writeString(bos, value.selectorExpression);
        _$codec_411.writeString(bos, value.sessionFilter);
    };
    return UnsubscribeAllByFilterRequestSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void UnsubscribeAllByFilterRequestSerialiserClass;
_$unsubscribeAllByFilterRequestSerialiser_458.UnsubscribeAllByFilterRequestSerialiser = new UnsubscribeAllByFilterRequestSerialiserClass();

var _$unsubscribeAllControlRequestSerialiser_459 = {};
"use strict";
var ____extends_459 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$unsubscribeAllControlRequestSerialiser_459, "__esModule", { value: true });
_$unsubscribeAllControlRequestSerialiser_459.UnsubscribeAllControlRequestSerialiser =  void 0;
;
;
;
var UnsubscribeAllControlRequestSerialiserClass =  (function (_super) {
    ____extends_459(UnsubscribeAllControlRequestSerialiserClass, _super);
    function UnsubscribeAllControlRequestSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UnsubscribeAllControlRequestSerialiserClass.prototype.write = function (bos, value) {
        _$codec_411.writeString(bos, value.selectorExpression);
        _$sessionIdSerialiser_708.SessionIdSerialiser.write(bos, value.sessionId);
    };
    return UnsubscribeAllControlRequestSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void UnsubscribeAllControlRequestSerialiserClass;
_$unsubscribeAllControlRequestSerialiser_459.UnsubscribeAllControlRequestSerialiser = new UnsubscribeAllControlRequestSerialiserClass();

var _$changeAuthorisationRolesFilterRequestSerialiser_460 = {};
"use strict";
var ____extends_460 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$changeAuthorisationRolesFilterRequestSerialiser_460, "__esModule", { value: true });
_$changeAuthorisationRolesFilterRequestSerialiser_460.ChangeAuthorisationRolesFilterRequestSerialiser =  void 0;
;
;
var ChangeAuthorisationRolesFilterRequestSerialiserClass =  (function (_super) {
    ____extends_460(ChangeAuthorisationRolesFilterRequestSerialiserClass, _super);
    function ChangeAuthorisationRolesFilterRequestSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeAuthorisationRolesFilterRequestSerialiserClass.prototype.write = function (bos, value) {
        _$codec_411.writeString(bos, value.filter);
        _$codec_411.writeCollection(bos, value.rolesToRemove, _$codec_411.writeString);
        _$codec_411.writeCollection(bos, value.rolesToAdd, _$codec_411.writeString);
    };
    return ChangeAuthorisationRolesFilterRequestSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void ChangeAuthorisationRolesFilterRequestSerialiserClass;
_$changeAuthorisationRolesFilterRequestSerialiser_460.ChangeAuthorisationRolesFilterRequestSerialiser = new ChangeAuthorisationRolesFilterRequestSerialiserClass();

var _$changeAuthorisationRolesRequestSerialiser_462 = {};
"use strict";
var ____extends_462 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$changeAuthorisationRolesRequestSerialiser_462, "__esModule", { value: true });
_$changeAuthorisationRolesRequestSerialiser_462.ChangeAuthorisationRolesRequestSerialiser =  void 0;
;
;
;
;
var ChangeAuthorisationRolesRequestSerialiserClass =  (function (_super) {
    ____extends_462(ChangeAuthorisationRolesRequestSerialiserClass, _super);
    function ChangeAuthorisationRolesRequestSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeAuthorisationRolesRequestSerialiserClass.prototype.write = function (bos, value) {
        if (value.sessionID === undefined || value.sessionID === null) {
            throw new _$errors_280.NullValueError('Session ID is null or undefined');
        }
        _$sessionIdSerialiser_708.SessionIdSerialiser.write(bos, value.sessionID);
        _$codec_411.writeCollection(bos, value.rolesToRemove, _$codec_411.writeString);
        _$codec_411.writeCollection(bos, value.rolesToAdd, _$codec_411.writeString);
    };
    return ChangeAuthorisationRolesRequestSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void ChangeAuthorisationRolesRequestSerialiserClass;
_$changeAuthorisationRolesRequestSerialiser_462.ChangeAuthorisationRolesRequestSerialiser = new ChangeAuthorisationRolesRequestSerialiserClass();

var _$closeClientRequest_465 = {};
"use strict";
Object.defineProperty(_$closeClientRequest_465, "__esModule", { value: true });
_$closeClientRequest_465.CloseClientRequest = void 0;
var CloseClientRequest =  (function () {
    function CloseClientRequest(sessionID) {
        this.sessionID = sessionID;
    }
    return CloseClientRequest;
}());
_$closeClientRequest_465.CloseClientRequest = CloseClientRequest;

var _$closeClientRequestSerialiser_464 = {};
"use strict";
var ____extends_464 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$closeClientRequestSerialiser_464, "__esModule", { value: true });
_$closeClientRequestSerialiser_464.CloseClientRequestSerialiser =  void 0;
;
;
;
var CloseClientRequestSerialiserClass =  (function (_super) {
    ____extends_464(CloseClientRequestSerialiserClass, _super);
    function CloseClientRequestSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CloseClientRequestSerialiserClass.prototype.read = function (bis) {
        var sessionID = _$sessionIdSerialiser_708.SessionIdSerialiser.read(bis);
        return new _$closeClientRequest_465.CloseClientRequest(sessionID);
    };
    CloseClientRequestSerialiserClass.prototype.write = function (bos, value) {
        _$sessionIdSerialiser_708.SessionIdSerialiser.write(bos, value.sessionID);
    };
    return CloseClientRequestSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void CloseClientRequestSerialiserClass;
_$closeClientRequestSerialiser_464.CloseClientRequestSerialiser = new CloseClientRequestSerialiserClass();

var _$getSessionPropertiesRequestSerialiser_468 = {};
"use strict";
var ____extends_468 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$getSessionPropertiesRequestSerialiser_468, "__esModule", { value: true });
_$getSessionPropertiesRequestSerialiser_468.GetSessionPropertiesRequestSerialiser =  void 0;
;
;
;
;
var GetSessionPropertiesRequestSerialiserClass =  (function (_super) {
    ____extends_468(GetSessionPropertiesRequestSerialiserClass, _super);
    function GetSessionPropertiesRequestSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    GetSessionPropertiesRequestSerialiserClass.prototype.write = function (bos, value) {
        if (value.sessionID === undefined || value.sessionID === null) {
            throw new _$errors_280.NullValueError('session ID is null or undefined');
        }
        _$sessionIdSerialiser_708.SessionIdSerialiser.write(bos, value.sessionID);
        if (value.propertyKeys !== undefined && value.propertyKeys !== null) {
            _$codec_411.writeCollection(bos, value.propertyKeys, _$codec_411.writeString);
        }
        else {
            _$codec_411.writeCollection(bos, [], _$codec_411.writeString);
        }
    };
    return GetSessionPropertiesRequestSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void GetSessionPropertiesRequestSerialiserClass;
_$getSessionPropertiesRequestSerialiser_468.GetSessionPropertiesRequestSerialiser = new GetSessionPropertiesRequestSerialiserClass();

var _$getSessionPropertiesResponse_470 = {};
"use strict";
Object.defineProperty(_$getSessionPropertiesResponse_470, "__esModule", { value: true });
_$getSessionPropertiesResponse_470.GetSessionPropertiesResponse = void 0;
var GetSessionPropertiesResponse =  (function () {
    function GetSessionPropertiesResponse(properties) {
        this.properties = properties;
    }
    return GetSessionPropertiesResponse;
}());
_$getSessionPropertiesResponse_470.GetSessionPropertiesResponse = GetSessionPropertiesResponse;

var _$getSessionPropertiesResponseSerialiser_469 = {};
"use strict";
var ____extends_469 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$getSessionPropertiesResponseSerialiser_469, "__esModule", { value: true });
_$getSessionPropertiesResponseSerialiser_469.GetSessionPropertiesResponseSerialiser =  void 0;
;
;
;
var GetSessionPropertiesResponseSerialiserClass =  (function (_super) {
    ____extends_469(GetSessionPropertiesResponseSerialiserClass, _super);
    function GetSessionPropertiesResponseSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    GetSessionPropertiesResponseSerialiserClass.prototype.read = function (bis) {
        if (_$codec_411.readBoolean(bis)) {
            return new _$getSessionPropertiesResponse_470.GetSessionPropertiesResponse(_$codec_411.readDictionary(bis, _$codec_411.readString));
        }
        else {
            return null;
        }
    };
    return GetSessionPropertiesResponseSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void GetSessionPropertiesResponseSerialiserClass;
_$getSessionPropertiesResponseSerialiser_469.GetSessionPropertiesResponseSerialiser = new GetSessionPropertiesResponseSerialiserClass();

var _$sessionPropertiesEventType_490 = {};
"use strict";
Object.defineProperty(_$sessionPropertiesEventType_490, "__esModule", { value: true });
_$sessionPropertiesEventType_490.SessionPropertiesEventType = void 0;
var SessionPropertiesEventType;
(function (SessionPropertiesEventType) {
    SessionPropertiesEventType[SessionPropertiesEventType["OPEN"] = 0] = "OPEN";
    SessionPropertiesEventType[SessionPropertiesEventType["UPDATE"] = 1] = "UPDATE";
    SessionPropertiesEventType[SessionPropertiesEventType["CLOSE"] = 2] = "CLOSE";
})(SessionPropertiesEventType = _$sessionPropertiesEventType_490.SessionPropertiesEventType || (_$sessionPropertiesEventType_490.SessionPropertiesEventType = {}));

var _$sessionPropertiesEventSerialiser_489 = {};
"use strict";
var ____extends_489 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$sessionPropertiesEventSerialiser_489, "__esModule", { value: true });
_$sessionPropertiesEventSerialiser_489.SessionPropertiesEventSerialiser =  void 0;
;
;
;
;
;
;
;
var UpdateEntryType;
(function (UpdateEntryType) {
    UpdateEntryType[UpdateEntryType["NEW"] = 1] = "NEW";
    UpdateEntryType[UpdateEntryType["CHANGE"] = 2] = "CHANGE";
    UpdateEntryType[UpdateEntryType["REMOVE"] = 3] = "REMOVE";
    UpdateEntryType[UpdateEntryType["SAME"] = 4] = "SAME";
})(UpdateEntryType || (UpdateEntryType = {}));
function completeReadUpdateEvent(bis, sessionId) {
    var updateType = _$codec_411.readByte(bis);
    var oldProperties = {};
    var newProperties = {};
    var size = _$codec_411.readInt32(bis);
    for (var i = 0; i < size; ++i) {
        var key = _$codec_411.readString(bis);
        var type = _$byteEncodedEnumSerialiser_426.read(bis, UpdateEntryType);
        switch (type) {
            case UpdateEntryType.NEW:
                oldProperties[key] = null;
                newProperties[key] = _$codec_411.readString(bis);
                break;
            case UpdateEntryType.CHANGE:
                oldProperties[key] = _$codec_411.readString(bis);
                newProperties[key] = _$codec_411.readString(bis);
                break;
            case UpdateEntryType.REMOVE:
                oldProperties[key] = _$codec_411.readString(bis);
                break;
            case UpdateEntryType.SAME:
                newProperties[key] = _$codec_411.readString(bis);
                break;
            default:
                throw new _$errors_280.IOError("Invalid update entry type: type");
        }
    }
    return {
        sessionId: sessionId,
        type: _$sessionPropertiesEventType_490.SessionPropertiesEventType.UPDATE,
        updateType: updateType,
        oldProperties: oldProperties,
        newProperties: newProperties
    };
}
var SessionPropertiesEventSerialiserClass =  (function (_super) {
    ____extends_489(SessionPropertiesEventSerialiserClass, _super);
    function SessionPropertiesEventSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SessionPropertiesEventSerialiserClass.prototype.read = function (bis) {
        var sessionId = _$sessionIdSerialiser_708.SessionIdSerialiser.read(bis);
        var type = _$byteEncodedEnumSerialiser_426.read(bis, _$sessionPropertiesEventType_490.SessionPropertiesEventType);
        switch (type) {
            case _$sessionPropertiesEventType_490.SessionPropertiesEventType.OPEN:
                var oldPropertiesOpen = _$codec_411.readDictionary(bis, _$codec_411.readString);
                return {
                    sessionId: sessionId,
                    type: _$sessionPropertiesEventType_490.SessionPropertiesEventType.OPEN,
                    oldProperties: oldPropertiesOpen
                };
            case _$sessionPropertiesEventType_490.SessionPropertiesEventType.UPDATE:
                return completeReadUpdateEvent(bis, sessionId);
            case _$sessionPropertiesEventType_490.SessionPropertiesEventType.CLOSE:
                var closeReason = _$byteEncodedEnumSerialiser_426.read(bis, _$closeReason_277.ClientCloseReason);
                var oldPropertiesClose = _$codec_411.readDictionary(bis, _$codec_411.readString);
                return {
                    sessionId: sessionId,
                    type: _$sessionPropertiesEventType_490.SessionPropertiesEventType.CLOSE,
                    oldProperties: oldPropertiesClose,
                    closeReason: closeReason
                };
            default:
                throw new _$errors_280.IOError('Unknown session properties event type: ' + type);
        }
    };
    return SessionPropertiesEventSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void SessionPropertiesEventSerialiserClass;
_$sessionPropertiesEventSerialiser_489.SessionPropertiesEventSerialiser = new SessionPropertiesEventSerialiserClass();

var _$sessionPropertiesEventBatch_488 = {};
"use strict";
Object.defineProperty(_$sessionPropertiesEventBatch_488, "__esModule", { value: true });
_$sessionPropertiesEventBatch_488.SessionPropertiesEventBatch = void 0;
var SessionPropertiesEventBatch =  (function () {
    function SessionPropertiesEventBatch(cid, events) {
        this.cid = cid;
        this.events = events;
    }
    return SessionPropertiesEventBatch;
}());
_$sessionPropertiesEventBatch_488.SessionPropertiesEventBatch = SessionPropertiesEventBatch;

var _$sessionPropertiesEventBatchSerialiser_487 = {};
"use strict";
var ____extends_487 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$sessionPropertiesEventBatchSerialiser_487, "__esModule", { value: true });
_$sessionPropertiesEventBatchSerialiser_487.SessionPropertiesEventBatchSerialiser =  void 0;
;
;
;
;
;
var SessionPropertiesEventBatchSerialiserClass =  (function (_super) {
    ____extends_487(SessionPropertiesEventBatchSerialiserClass, _super);
    function SessionPropertiesEventBatchSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SessionPropertiesEventBatchSerialiserClass.prototype.read = function (bis) {
        var cid = _$conversationIdSerialiser_313.CIDSerialiser.read(bis);
        var events = _$codec_411.readCollection(bis, _$sessionPropertiesEventSerialiser_489.SessionPropertiesEventSerialiser.read);
        return new _$sessionPropertiesEventBatch_488.SessionPropertiesEventBatch(cid, events);
    };
    return SessionPropertiesEventBatchSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void SessionPropertiesEventBatchSerialiserClass;
_$sessionPropertiesEventBatchSerialiser_487.SessionPropertiesEventBatchSerialiser = new SessionPropertiesEventBatchSerialiserClass();

var _$setClientConflationFilterRequestSerialiser_491 = {};
"use strict";
var ____extends_491 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$setClientConflationFilterRequestSerialiser_491, "__esModule", { value: true });
_$setClientConflationFilterRequestSerialiser_491.SetClientConflationFilterRequestSerialiser =  void 0;
;
;
var SetClientConflationFilterRequestSerialiserClass =  (function (_super) {
    ____extends_491(SetClientConflationFilterRequestSerialiserClass, _super);
    function SetClientConflationFilterRequestSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SetClientConflationFilterRequestSerialiserClass.prototype.write = function (bos, value) {
        _$codec_411.writeString(bos, value.filter);
        _$codec_411.writeBoolean(bos, value.conflate);
    };
    return SetClientConflationFilterRequestSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void SetClientConflationFilterRequestSerialiserClass;
_$setClientConflationFilterRequestSerialiser_491.SetClientConflationFilterRequestSerialiser = new SetClientConflationFilterRequestSerialiserClass();

var _$setClientConflationRequestSerialiser_493 = {};
"use strict";
var ____extends_493 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$setClientConflationRequestSerialiser_493, "__esModule", { value: true });
_$setClientConflationRequestSerialiser_493.SetClientConflationRequestSerialiser =  void 0;
;
;
;
var SetClientConflationRequestSerialiserClass =  (function (_super) {
    ____extends_493(SetClientConflationRequestSerialiserClass, _super);
    function SetClientConflationRequestSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SetClientConflationRequestSerialiserClass.prototype.write = function (bos, value) {
        _$sessionIdSerialiser_708.SessionIdSerialiser.write(bos, value.sessionID);
        _$codec_411.writeBoolean(bos, value.conflate);
    };
    return SetClientConflationRequestSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void SetClientConflationRequestSerialiserClass;
_$setClientConflationRequestSerialiser_493.SetClientConflationRequestSerialiser = new SetClientConflationRequestSerialiserClass();

var _$setSessionPropertiesFilterRequestSerialiser_495 = {};
"use strict";
var ____extends_495 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$setSessionPropertiesFilterRequestSerialiser_495, "__esModule", { value: true });
_$setSessionPropertiesFilterRequestSerialiser_495.SetSessionPropertiesFilterRequestSerialiser =  void 0;
;
;
var SetSessionPropertiesFilterRequestSerialiserClass =  (function (_super) {
    ____extends_495(SetSessionPropertiesFilterRequestSerialiserClass, _super);
    function SetSessionPropertiesFilterRequestSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SetSessionPropertiesFilterRequestSerialiserClass.prototype.write = function (bos, value) {
        _$codec_411.writeString(bos, value.filter);
        _$codec_411.writeOptional(bos, value.overwriteProperties, function (ostream, props) { return _$codec_411.writeDictionary(ostream, props, _$codec_411.writeString); }, function (props) { return Object.keys(props).length !== 0; });
        _$codec_411.writeOptional(bos, value.removeProperties, function (ostream, props) { return _$codec_411.writeCollection(ostream, props, _$codec_411.writeString); }, function (props) { return Object.keys(props).length !== 0; });
    };
    return SetSessionPropertiesFilterRequestSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void SetSessionPropertiesFilterRequestSerialiserClass;
_$setSessionPropertiesFilterRequestSerialiser_495.SetSessionPropertiesFilterRequestSerialiser = new SetSessionPropertiesFilterRequestSerialiserClass();

var _$setSessionPropertiesListenerSerialiser_497 = {};
"use strict";
var ____extends_497 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$setSessionPropertiesListenerSerialiser_497, "__esModule", { value: true });
_$setSessionPropertiesListenerSerialiser_497.SetSessionPropertiesListenerSerialiser =  void 0;
;
;
;
var SetSessionPropertiesListenerSerialiserClass =  (function (_super) {
    ____extends_497(SetSessionPropertiesListenerSerialiserClass, _super);
    function SetSessionPropertiesListenerSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SetSessionPropertiesListenerSerialiserClass.prototype.write = function (bos, value) {
        if (value.properties) {
            _$codec_411.writeInt32(bos, 0);
            _$codec_411.writeCollection(bos, value.properties, _$codec_411.writeString);
        }
        else {
            _$codec_411.writeInt32(bos, 1);
        }
        _$conversationIdSerialiser_313.CIDSerialiser.write(bos, value.cid);
    };
    return SetSessionPropertiesListenerSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void SetSessionPropertiesListenerSerialiserClass;
_$setSessionPropertiesListenerSerialiser_497.SetSessionPropertiesListenerSerialiser = new SetSessionPropertiesListenerSerialiserClass();

var _$setSessionPropertiesRequestSerialiser_498 = {};
"use strict";
var ____extends_498 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$setSessionPropertiesRequestSerialiser_498, "__esModule", { value: true });
_$setSessionPropertiesRequestSerialiser_498.SetSessionPropertiesRequestSerialiser =  void 0;
;
;
;
;
var SetSessionPropertiesRequestSerialiserClass =  (function (_super) {
    ____extends_498(SetSessionPropertiesRequestSerialiserClass, _super);
    function SetSessionPropertiesRequestSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SetSessionPropertiesRequestSerialiserClass.prototype.write = function (bos, value) {
        if (value.sessionID === undefined || value.sessionID === null) {
            throw new _$errors_280.NullValueError('Session ID is null or undefined');
        }
        _$sessionIdSerialiser_708.SessionIdSerialiser.write(bos, value.sessionID);
        _$codec_411.writeOptional(bos, value.overwriteProperties, function (ostream, props) { return _$codec_411.writeDictionary(ostream, props, _$codec_411.writeString); }, function (props) { return Object.keys(props).length !== 0; });
        _$codec_411.writeOptional(bos, value.removeProperties, function (ostream, props) { return _$codec_411.writeCollection(ostream, props, _$codec_411.writeString); }, function (props) { return Object.keys(props).length !== 0; });
    };
    return SetSessionPropertiesRequestSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void SetSessionPropertiesRequestSerialiserClass;
_$setSessionPropertiesRequestSerialiser_498.SetSessionPropertiesRequestSerialiser = new SetSessionPropertiesRequestSerialiserClass();

var _$setSessionPropertiesResult_500 = {};
"use strict";
var ____values_500 = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(_$setSessionPropertiesResult_500, "__esModule", { value: true });
_$setSessionPropertiesResult_500.SetSessionPropertiesResult = void 0;
var SetSessionPropertiesResult =  (function () {
    function SetSessionPropertiesResult(changedProperties, newProperties) {
        var e_1, _a, e_2, _b;
        this.properties = {};
        try {
            for (var _c = ____values_500(Object.getOwnPropertyNames(changedProperties)), _d = _c.next(); !_d.done; _d = _c.next()) {
                var k = _d.value;
                this.properties[k] = changedProperties[k];
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_1) throw e_1.error; }
        }
        try {
            for (var newProperties_1 = ____values_500(newProperties), newProperties_1_1 = newProperties_1.next(); !newProperties_1_1.done; newProperties_1_1 = newProperties_1.next()) {
                var p = newProperties_1_1.value;
                this.properties[p] = null;
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (newProperties_1_1 && !newProperties_1_1.done && (_b = newProperties_1.return)) _b.call(newProperties_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
    }
    return SetSessionPropertiesResult;
}());
_$setSessionPropertiesResult_500.SetSessionPropertiesResult = SetSessionPropertiesResult;

var _$setSessionPropertiesResultSerialiser_499 = {};
"use strict";
var ____extends_499 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$setSessionPropertiesResultSerialiser_499, "__esModule", { value: true });
_$setSessionPropertiesResultSerialiser_499.SetSessionPropertiesResultSerialiser =  void 0;
;
;
;
var SetSessionPropertiesResultSerialiserClass =  (function (_super) {
    ____extends_499(SetSessionPropertiesResultSerialiserClass, _super);
    function SetSessionPropertiesResultSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SetSessionPropertiesResultSerialiserClass.prototype.read = function (bis) {
        var changedProperties = _$codec_411.readOptional(bis, function (istream) { return _$codec_411.readDictionary(istream, _$codec_411.readString); }, {});
        var newProperties = _$codec_411.readOptional(bis, function (istream) { return _$codec_411.readCollection(istream, _$codec_411.readString); }, []);
        return new _$setSessionPropertiesResult_500.SetSessionPropertiesResult(changedProperties, newProperties);
    };
    return SetSessionPropertiesResultSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void SetSessionPropertiesResultSerialiserClass;
_$setSessionPropertiesResultSerialiser_499.SetSessionPropertiesResultSerialiser = new SetSessionPropertiesResultSerialiserClass();

var _$countOrParserErrors_504 = {};
"use strict";
Object.defineProperty(_$countOrParserErrors_504, "__esModule", { value: true });
_$countOrParserErrors_504.CountOrParserErrors = void 0;
;
var CountOrParserErrors =  (function () {
    function CountOrParserErrors(count, errors) {
        this.count = _$requireNonNull_759.requireNonNull(count, 'count');
        this.errors = _$requireNonNull_759.requireNonNull(errors, 'errors');
    }
    return CountOrParserErrors;
}());
_$countOrParserErrors_504.CountOrParserErrors = CountOrParserErrors;

var _$countOrParserErrorsSerialiser_503 = {};
"use strict";
var ____extends_503 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$countOrParserErrorsSerialiser_503, "__esModule", { value: true });
_$countOrParserErrorsSerialiser_503.CountOrParserErrorsSerialiser =  void 0;
;
;
;
;
var CountOrParserErrorsSerialiserClass =  (function (_super) {
    ____extends_503(CountOrParserErrorsSerialiserClass, _super);
    function CountOrParserErrorsSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CountOrParserErrorsSerialiserClass.prototype.read = function (bis) {
        var count = _$codec_411.readInt32(bis);
        var errors = _$codec_411.readCollection(bis, _$errorReportSerialiser_508.ErrorReportSerialiser.read);
        return new _$countOrParserErrors_504.CountOrParserErrors(count, errors);
    };
    CountOrParserErrorsSerialiserClass.prototype.write = function (bos, value) {
        _$codec_411.writeInt32(bos, value.count);
        _$codec_411.writeCollection(bos, value.errors, _$errorReportSerialiser_508.ErrorReportSerialiser.write);
    };
    return CountOrParserErrorsSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void CountOrParserErrorsSerialiserClass;
_$countOrParserErrorsSerialiser_503.CountOrParserErrorsSerialiser = new CountOrParserErrorsSerialiserClass();

var _$errorReportList_507 = {};
"use strict";
Object.defineProperty(_$errorReportList_507, "__esModule", { value: true });
_$errorReportList_507.ErrorReportList = void 0;
;
var ErrorReportList =  (function () {
    function ErrorReportList(errors) {
        this.errors = _$requireNonNull_759.requireNonNull(errors, 'errors');
    }
    ErrorReportList.prototype.toString = function () {
        return this.errors.map(function (err) { return err.line + ":" + err.column + " " + err.message; }).join('\n');
    };
    return ErrorReportList;
}());
_$errorReportList_507.ErrorReportList = ErrorReportList;

var _$errorReportListSerialiser_506 = {};
"use strict";
var ____extends_506 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$errorReportListSerialiser_506, "__esModule", { value: true });
_$errorReportListSerialiser_506.ErrorReportListSerialiser =  void 0;
;
;
;
;
var ErrorReportListSerialiserClass =  (function (_super) {
    ____extends_506(ErrorReportListSerialiserClass, _super);
    function ErrorReportListSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ErrorReportListSerialiserClass.prototype.read = function (input) {
        var errors = _$codec_411.readCollection(input, _$errorReportSerialiser_508.ErrorReportSerialiser.read);
        return new _$errorReportList_507.ErrorReportList(errors);
    };
    ErrorReportListSerialiserClass.prototype.write = function (output, value) {
        _$codec_411.writeCollection(output, value.errors, _$errorReportSerialiser_508.ErrorReportSerialiser.write);
    };
    return ErrorReportListSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void ErrorReportListSerialiserClass;
_$errorReportListSerialiser_506.ErrorReportListSerialiser = new ErrorReportListSerialiserClass();

var _$sessionFetchQueryResult_626 = {};
"use strict";
Object.defineProperty(_$sessionFetchQueryResult_626, "__esModule", { value: true });
_$sessionFetchQueryResult_626.SessionFetchQueryResult = void 0;
var SessionFetchQueryResult =  (function () {
    function SessionFetchQueryResult(results, totalCount, errors) {
        this.results = results;
        this.totalCount = totalCount;
        this.errors = errors;
    }
    return SessionFetchQueryResult;
}());
_$sessionFetchQueryResult_626.SessionFetchQueryResult = SessionFetchQueryResult;

var _$sessionFetchQueryResultSerialiser_625 = {};
"use strict";
var ____extends_625 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$sessionFetchQueryResultSerialiser_625, "__esModule", { value: true });
_$sessionFetchQueryResultSerialiser_625.SessionFetchQueryResultSerialiser =  void 0;
;
;
;
;
function readSession(bis) {
    var startTime = _$codec_411.readOptional(bis, _$codec_411.readInt64);
    var properties = _$codec_411.readDictionary(bis, _$codec_411.readString);
    if (startTime) {
        properties.$StartTime = startTime.toString();
    }
    return properties;
}
var SessionFetchQueryResultSerialiserClass =  (function (_super) {
    ____extends_625(SessionFetchQueryResultSerialiserClass, _super);
    function SessionFetchQueryResultSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SessionFetchQueryResultSerialiserClass.prototype.read = function (bis) {
        if (_$codec_411.readByte(bis) === 0) {
            var sessions = _$codec_411.readCollection(bis, readSession);
            var totalSelected = _$codec_411.readInt32(bis);
            return new _$sessionFetchQueryResult_626.SessionFetchQueryResult(sessions, totalSelected);
        }
        else {
            var errors = _$errorReportListSerialiser_506.ErrorReportListSerialiser.read(bis);
            return new _$sessionFetchQueryResult_626.SessionFetchQueryResult(undefined, undefined, errors);
        }
    };
    return SessionFetchQueryResultSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void SessionFetchQueryResultSerialiserClass;
_$sessionFetchQueryResultSerialiser_625.SessionFetchQueryResultSerialiser = new SessionFetchQueryResultSerialiserClass();

var _$sessionFetchQuerySerialiser_627 = {};
"use strict";
var ____extends_627 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ____read_627 = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var ____spreadArray_627 = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(_$sessionFetchQuerySerialiser_627, "__esModule", { value: true });
_$sessionFetchQuerySerialiser_627.SessionFetchQuerySerialiser =  void 0;
;
;
;
var SessionFetchQuerySerialiserClass =  (function (_super) {
    ____extends_627(SessionFetchQuerySerialiserClass, _super);
    function SessionFetchQuerySerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SessionFetchQuerySerialiserClass.prototype.write = function (bos, value) {
        _$codec_411.writeString(bos, value.filter);
        _$codec_411.writeOptional(bos, value.withProperties, function (ostream, props) {
            _$codec_411.writeCollection(ostream, ____spreadArray_627([], ____read_627(props)), _$codec_411.writeString);
        });
        _$codec_411.writeOptional(bos, value.range.from, _$codec_411.writeInt64);
        _$codec_411.writeOptional(bos, value.range.to, _$codec_411.writeInt64);
        _$codec_411.writeOptional(bos, value.limit, _$codec_411.writeInt32, function (limit) { return limit !== _$math_753.MAX_INT32; });
        _$codec_411.writeInt32(bos, value.maximumResultSize);
        _$codec_411.writeBoolean(bos, value.requiresStartTime);
    };
    return SessionFetchQuerySerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void SessionFetchQuerySerialiserClass;
_$sessionFetchQuerySerialiser_627.SessionFetchQuerySerialiser = new SessionFetchQuerySerialiserClass();

var _$getSessionLockResult_631 = {};
"use strict";
Object.defineProperty(_$getSessionLockResult_631, "__esModule", { value: true });
_$getSessionLockResult_631.GetSessionLockResult = void 0;
var GetSessionLockResult =  (function () {
    function GetSessionLockResult(sessionLockDetails) {
        this.sessionLockDetails = sessionLockDetails;
    }
    return GetSessionLockResult;
}());
_$getSessionLockResult_631.GetSessionLockResult = GetSessionLockResult;

var _$sessionLockDetailsSerialiser_636 = {};
"use strict";
var ____extends_636 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$sessionLockDetailsSerialiser_636, "__esModule", { value: true });
_$sessionLockDetailsSerialiser_636.SessionLockDetailsSerialiser =  void 0;
;
;
;
var SessionLockDetailsSerialiserClass =  (function (_super) {
    ____extends_636(SessionLockDetailsSerialiserClass, _super);
    function SessionLockDetailsSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SessionLockDetailsSerialiserClass.prototype.read = function (bis) {
        var serverName = _$codec_411.readString(bis);
        var sessionId = _$sessionIdSerialiser_708.SessionIdSerialiser.read(bis);
        var sequence = _$codec_411.readInt64(bis);
        return {
            serverName: serverName,
            sessionId: sessionId,
            sequence: sequence
        };
    };
    return SessionLockDetailsSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void SessionLockDetailsSerialiserClass;
_$sessionLockDetailsSerialiser_636.SessionLockDetailsSerialiser = new SessionLockDetailsSerialiserClass();

var _$getSessionLockResultSerialiser_630 = {};
"use strict";
var ____extends_630 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$getSessionLockResultSerialiser_630, "__esModule", { value: true });
_$getSessionLockResultSerialiser_630.GetSessionLockResultSerialiser =  void 0;
;
;
;
;
var GetSessionLockResultSerialiserClass =  (function (_super) {
    ____extends_630(GetSessionLockResultSerialiserClass, _super);
    function GetSessionLockResultSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    GetSessionLockResultSerialiserClass.prototype.read = function (bis) {
        var details = _$codec_411.readOptional(bis, _$sessionLockDetailsSerialiser_636.SessionLockDetailsSerialiser.read);
        return new _$getSessionLockResult_631.GetSessionLockResult(details);
    };
    return GetSessionLockResultSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void GetSessionLockResultSerialiserClass;
_$getSessionLockResultSerialiser_630.GetSessionLockResultSerialiser = new GetSessionLockResultSerialiserClass();

var _$getSessionLocksResult_633 = {};
"use strict";
Object.defineProperty(_$getSessionLocksResult_633, "__esModule", { value: true });
_$getSessionLocksResult_633.GetSessionLocksResult = void 0;
var GetSessionLocksResult =  (function () {
    function GetSessionLocksResult(sessionLocksDetails) {
        this.sessionLocksDetails = sessionLocksDetails;
    }
    return GetSessionLocksResult;
}());
_$getSessionLocksResult_633.GetSessionLocksResult = GetSessionLocksResult;

var _$getSessionLocksResultSerialiser_632 = {};
"use strict";
var ____extends_632 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$getSessionLocksResultSerialiser_632, "__esModule", { value: true });
_$getSessionLocksResultSerialiser_632.GetSessionLocksResultSerialiser =  void 0;
;
;
;
;
var GetSessionLocksResultSerialiserClass =  (function (_super) {
    ____extends_632(GetSessionLocksResultSerialiserClass, _super);
    function GetSessionLocksResultSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    GetSessionLocksResultSerialiserClass.prototype.read = function (bis) {
        var details = _$codec_411.readDictionary(bis, _$sessionLockDetailsSerialiser_636.SessionLockDetailsSerialiser.read);
        return new _$getSessionLocksResult_633.GetSessionLocksResult(details);
    };
    return GetSessionLocksResultSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void GetSessionLocksResultSerialiserClass;
_$getSessionLocksResultSerialiser_632.GetSessionLocksResultSerialiser = new GetSessionLocksResultSerialiserClass();

var _$sessionEventListenerRegistrationRequestSerialiser_485 = {};
"use strict";
var ____extends_485 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ____read_485 = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var ____spreadArray_485 = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(_$sessionEventListenerRegistrationRequestSerialiser_485, "__esModule", { value: true });
_$sessionEventListenerRegistrationRequestSerialiser_485.SessionEventListenerRegistrationRequestSerialiser =  void 0;
;
;
;
;
var SessionEventListenerRegistrationRequestSerialiserClass =  (function (_super) {
    ____extends_485(SessionEventListenerRegistrationRequestSerialiserClass, _super);
    function SessionEventListenerRegistrationRequestSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SessionEventListenerRegistrationRequestSerialiserClass.prototype.write = function (bos, value) {
        _$codec_411.writeBoolean(bos, value.isClusterAware);
        _$codec_411.writeOptional(bos, value.sessionFilter, _$codec_411.writeString);
        _$codec_411.writeOptional(bos, value.requestedProperties, function (bos, requestedProperties) {
            _$codec_411.writeCollection(bos, ____spreadArray_485([], ____read_485(requestedProperties.values())), _$codec_411.writeString);
        }, function (requestedProperties) {
            return (requestedProperties !== null &&
                requestedProperties !== undefined &&
                requestedProperties.size > 0);
        });
        _$codec_411.writeOptional(bos, value.sessionStartTime, _$codec_411.writeInt64, function (sessionStartTime) {
            return (sessionStartTime !== null &&
                sessionStartTime !== undefined &&
                _$Long_274.fromValue(sessionStartTime) !== _$Long_274.ZERO);
        });
        _$conversationIdSerialiser_313.CIDSerialiser.write(bos, value.conversationId);
    };
    return SessionEventListenerRegistrationRequestSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void SessionEventListenerRegistrationRequestSerialiserClass;
_$sessionEventListenerRegistrationRequestSerialiser_485.SessionEventListenerRegistrationRequestSerialiser = new SessionEventListenerRegistrationRequestSerialiserClass();

var _$clientControlServices_441 = {};
"use strict";
Object.defineProperty(_$clientControlServices_441, "__esModule", { value: true });
_$clientControlServices_441.UNSUBSCRIBE_ALL_CONTROL = _$clientControlServices_441.UNSUBSCRIBE_ALL_BY_FILTER = _$clientControlServices_441.GET_SELECTORS = _$clientControlServices_441.GET_SESSION_LOCKS = _$clientControlServices_441.GET_SESSION_LOCK = _$clientControlServices_441.SESSION_EVENT_DEREGISTRATION = _$clientControlServices_441.SESSION_EVENT_REGISTRATION = _$clientControlServices_441.SESSION_FETCH = _$clientControlServices_441.SET_CLIENT_CONFLATION_FILTER = _$clientControlServices_441.CLOSE_CLIENT_FILTER = _$clientControlServices_441.CHANGE_AUTHORISATION_ROLES_FILTER = _$clientControlServices_441.CHANGE_AUTHORISATION_ROLES = _$clientControlServices_441.SET_SESSION_PROPERTIES_FILTER = _$clientControlServices_441.SET_SESSION_PROPERTIES = _$clientControlServices_441.SESSION_PROPERTIES_EVENT_2 = _$clientControlServices_441.SESSION_PROPERTIES_REGISTRATION_2 = _$clientControlServices_441.GET_SESSION_PROPERTIES = _$clientControlServices_441.FILTER_UNSUBSCRIBE = _$clientControlServices_441.FILTER_SUBSCRIBE = _$clientControlServices_441.SET_CLIENT_CONFLATION = _$clientControlServices_441.CLOSE_CLIENT = _$clientControlServices_441.UNSUBSCRIBE_CLIENT = _$clientControlServices_441.SUBSCRIBE_CLIENT = void 0;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
_$clientControlServices_441.SUBSCRIBE_CLIENT = {
    id: 10,
    request: _$clientSubscribeRequestSerialiser_456.ClientSubscribeRequestSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
_$clientControlServices_441.UNSUBSCRIBE_CLIENT = {
    id: 11,
    request: _$clientSubscribeRequestSerialiser_456.ClientSubscribeRequestSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
_$clientControlServices_441.CLOSE_CLIENT = {
    id: 14,
    request: _$closeClientRequestSerialiser_464.CloseClientRequestSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
_$clientControlServices_441.SET_CLIENT_CONFLATION = {
    id: 15,
    request: _$setClientConflationRequestSerialiser_493.SetClientConflationRequestSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
_$clientControlServices_441.FILTER_SUBSCRIBE = {
    id: 65,
    request: _$clientFilterSubscribeRequestSerialiser_453.ClientFilterSubscribeRequestSerialiser,
    response: _$clientFilterSubscribeResponseSerialiser_454.ClientFilterSubscribeResponseSerialiser
};
_$clientControlServices_441.FILTER_UNSUBSCRIBE = {
    id: 66,
    request: _$clientFilterSubscribeRequestSerialiser_453.ClientFilterSubscribeRequestSerialiser,
    response: _$clientFilterSubscribeResponseSerialiser_454.ClientFilterSubscribeResponseSerialiser
};
_$clientControlServices_441.GET_SESSION_PROPERTIES = {
    id: 67,
    request: _$getSessionPropertiesRequestSerialiser_468.GetSessionPropertiesRequestSerialiser,
    response: _$getSessionPropertiesResponseSerialiser_469.GetSessionPropertiesResponseSerialiser
};
_$clientControlServices_441.SESSION_PROPERTIES_REGISTRATION_2 = {
    id: 81,
    request: _$setSessionPropertiesListenerSerialiser_497.SetSessionPropertiesListenerSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
_$clientControlServices_441.SESSION_PROPERTIES_EVENT_2 = {
    id: 82,
    request: _$sessionPropertiesEventBatchSerialiser_487.SessionPropertiesEventBatchSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
_$clientControlServices_441.SET_SESSION_PROPERTIES = {
    id: 105,
    request: _$setSessionPropertiesRequestSerialiser_498.SetSessionPropertiesRequestSerialiser,
    response: _$setSessionPropertiesResultSerialiser_499.SetSessionPropertiesResultSerialiser
};
_$clientControlServices_441.SET_SESSION_PROPERTIES_FILTER = {
    id: 106,
    request: _$setSessionPropertiesFilterRequestSerialiser_495.SetSessionPropertiesFilterRequestSerialiser,
    response: _$countOrParserErrorsSerialiser_503.CountOrParserErrorsSerialiser
};
_$clientControlServices_441.CHANGE_AUTHORISATION_ROLES = {
    id: 123,
    request: _$changeAuthorisationRolesRequestSerialiser_462.ChangeAuthorisationRolesRequestSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
_$clientControlServices_441.CHANGE_AUTHORISATION_ROLES_FILTER = {
    id: 124,
    request: _$changeAuthorisationRolesFilterRequestSerialiser_460.ChangeAuthorisationRolesFilterRequestSerialiser,
    response: _$countOrParserErrorsSerialiser_503.CountOrParserErrorsSerialiser
};
_$clientControlServices_441.CLOSE_CLIENT_FILTER = {
    id: 162,
    request: _$stringSerialiser_431.StringSerialiser,
    response: _$countOrParserErrorsSerialiser_503.CountOrParserErrorsSerialiser
};
_$clientControlServices_441.SET_CLIENT_CONFLATION_FILTER = {
    id: 163,
    request: _$setClientConflationFilterRequestSerialiser_491.SetClientConflationFilterRequestSerialiser,
    response: _$countOrParserErrorsSerialiser_503.CountOrParserErrorsSerialiser
};
_$clientControlServices_441.SESSION_FETCH = {
    id: 168,
    request: _$sessionFetchQuerySerialiser_627.SessionFetchQuerySerialiser,
    response: _$sessionFetchQueryResultSerialiser_625.SessionFetchQueryResultSerialiser
};
_$clientControlServices_441.SESSION_EVENT_REGISTRATION = {
    id: 189,
    request: _$sessionEventListenerRegistrationRequestSerialiser_485.SessionEventListenerRegistrationRequestSerialiser,
    response: _$errorReportListSerialiser_506.ErrorReportListSerialiser
};
_$clientControlServices_441.SESSION_EVENT_DEREGISTRATION = {
    id: 190,
    request: _$conversationIdSerialiser_313.CIDSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
_$clientControlServices_441.GET_SESSION_LOCK = {
    id: 196,
    request: _$stringSerialiser_431.StringSerialiser,
    response: _$getSessionLockResultSerialiser_630.GetSessionLockResultSerialiser
};
_$clientControlServices_441.GET_SESSION_LOCKS = {
    id: 197,
    request: _$serviceDefinition_623.NullSerialiser,
    response: _$getSessionLocksResultSerialiser_632.GetSessionLocksResultSerialiser
};
_$clientControlServices_441.GET_SELECTORS = {
    id: 198,
    request: _$sessionIdSerialiser_708.SessionIdSerialiser,
    response: _$getSelectorsResultSerialiser_457.GetSelectorsResultSerialiser
};
_$clientControlServices_441.UNSUBSCRIBE_ALL_BY_FILTER = {
    id: 200,
    request: _$unsubscribeAllByFilterRequestSerialiser_458.UnsubscribeAllByFilterRequestSerialiser,
    response: _$clientFilterSubscribeResponseSerialiser_454.ClientFilterSubscribeResponseSerialiser
};
_$clientControlServices_441.UNSUBSCRIBE_ALL_CONTROL = {
    id: 201,
    request: _$unsubscribeAllControlRequestSerialiser_459.UnsubscribeAllControlRequestSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};

var _$sessionFetchQuery_628 = {};
"use strict";
Object.defineProperty(_$sessionFetchQuery_628, "__esModule", { value: true });
_$sessionFetchQuery_628.SessionFetchQuery = void 0;
var SessionFetchQuery =  (function () {
    function SessionFetchQuery(filter, range, withProperties, limit, maximumResultSize, requiresStartTime) {
        this.filter = filter;
        this.range = range;
        this.withProperties = withProperties;
        this.limit = limit;
        this.maximumResultSize = maximumResultSize;
        this.requiresStartTime = requiresStartTime;
    }
    return SessionFetchQuery;
}());
_$sessionFetchQuery_628.SessionFetchQuery = SessionFetchQuery;

var _$clientControl_282 = {};
"use strict";
Object.defineProperty(_$clientControl_282, "__esModule", { value: true });
_$clientControl_282.SessionState = _$clientControl_282.SessionEventStreamEventType = _$clientControl_282.SessionEventType = void 0;
var SessionEventType;
(function (SessionEventType) {
    SessionEventType[SessionEventType["UPDATED"] = 0] = "UPDATED";
    SessionEventType[SessionEventType["RECONNECTED"] = 1] = "RECONNECTED";
    SessionEventType[SessionEventType["FAILED_OVER"] = 2] = "FAILED_OVER";
    SessionEventType[SessionEventType["DISCONNECTED"] = 3] = "DISCONNECTED";
})(SessionEventType = _$clientControl_282.SessionEventType || (_$clientControl_282.SessionEventType = {}));
var SessionEventStreamEventType;
(function (SessionEventStreamEventType) {
    SessionEventStreamEventType[SessionEventStreamEventType["STATE"] = 0] = "STATE";
    SessionEventStreamEventType[SessionEventStreamEventType["PROPERTIES"] = 1] = "PROPERTIES";
})(SessionEventStreamEventType = _$clientControl_282.SessionEventStreamEventType || (_$clientControl_282.SessionEventStreamEventType = {}));
var SessionState;
(function (SessionState) {
    SessionState[SessionState["ACTIVE"] = 0] = "ACTIVE";
    SessionState[SessionState["DISCONNECTED"] = 1] = "DISCONNECTED";
    SessionState[SessionState["RECONNECTED"] = 2] = "RECONNECTED";
    SessionState[SessionState["FAILED_OVER"] = 3] = "FAILED_OVER";
    SessionState[SessionState["CLOSED"] = 4] = "CLOSED";
})(SessionState = _$clientControl_282.SessionState || (_$clientControl_282.SessionState = {}));

var _$clientControlOptions_281 = {};
"use strict";
Object.defineProperty(_$clientControlOptions_281, "__esModule", { value: true });
_$clientControlOptions_281.ClientControlOptions = void 0;
;
;
_$clientControlOptions_281.ClientControlOptions = {
    PropertyKeys: Object.freeze({
        ALL_FIXED_PROPERTIES: ['*F'],
        ALL_USER_PROPERTIES: ['*U'],
        ALL_PROPERTIES: ['*F', '*U'],
        SESSION_ID: '$SessionId',
        PRINCIPAL: '$Principal',
        CONNECTOR: '$Connector',
        TRANSPORT: '$Transport',
        CLIENT_TYPE: '$ClientType',
        COUNTRY: '$Country',
        LANGUAGE: '$Language',
        SERVER_NAME: '$ServerName',
        CLIENT_IP: '$ClientIP',
        LATITUDE: '$Latitude',
        LONGITUDE: '$Longitude',
        START_TIME: '$StartTime',
        EXPIRY_TIME: '$ExpiryTime',
        ROLES: '$Roles',
        MQTT_CLIENT_ID: '$MQTTClientId',
        GATEWAY_TYPE: '$GatewayType',
        GATEWAY_ID: '$GatewayId',
        ENVIRONMENT: '$Environment'
    }),
    ANONYMOUS: '',
    CloseReason: _$closeReason_277.CloseReasonEnum,
    SessionEventStreamEventType: _$clientControl_282.SessionEventStreamEventType,
    SessionState: _$clientControl_282.SessionState
};

var _$sessionFetchRequest_357 = {};
"use strict";
Object.defineProperty(_$sessionFetchRequest_357, "__esModule", { value: true });
_$sessionFetchRequest_357.SessionFetchRequestImpl =  void 0;
;
;
;
;
;
;
;
;
;
;
var __log_357 = _$logger_752.create('Session Fetch Request');
var SessionFetchRange =  (function () {
    function SessionFetchRange(from, to) {
        this.from = from;
        this.to = to;
    }
    return SessionFetchRange;
}());
 void SessionFetchRange;
function requireNonNegativeLong(n, parameter) {
    if (n instanceof _$Long_274 && n.gte(0)) {
        return n;
    }
    else if (typeof n === 'number' && Number.isInteger(n) && n >= 0) {
        return _$Long_274.fromNumber(n);
    }
    throw new _$errors_280.IllegalArgumentError("Invalid argument '" + parameter + "': " + n);
}
var SessionFetchRequestImpl =  (function () {
    function SessionFetchRequestImpl(internal, opts) {
        var defaultOptions = {
            range: new SessionFetchRange(),
            filter: 'all',
            withProperties: null,
            limit: _$math_753.MAX_INT32,
            maximumResultSize: internal.getOptions().maxMessageSize
        };
        this.internal = internal;
        this.options = Object.assign(defaultOptions, opts);
    }
    SessionFetchRequestImpl.prototype.copyOptions = function () {
        return {
            range: new SessionFetchRange(this.options.range.from, this.options.range.to),
            filter: this.options.filter,
            withProperties: this.options.withProperties,
            limit: this.options.limit,
            maximumResultSize: this.options.maximumResultSize
        };
    };
    SessionFetchRequestImpl.prototype.from = function (time) {
        var limit = requireNonNegativeLong(time, 'time');
        return new SessionFetchRequestImpl(this.internal, Object.assign(this.copyOptions(), { range: new SessionFetchRange(limit, this.options.range.to) }));
    };
    SessionFetchRequestImpl.prototype.to = function (time) {
        var limit = requireNonNegativeLong(time, 'time');
        return new SessionFetchRequestImpl(this.internal, Object.assign(this.copyOptions(), { range: new SessionFetchRange(this.options.range.from, limit) }));
    };
    SessionFetchRequestImpl.prototype.withProperties = function (properties) {
        return new SessionFetchRequestImpl(this.internal, Object.assign(this.copyOptions(), { withProperties: properties }));
    };
    SessionFetchRequestImpl.prototype.first = function (count) {
        return new SessionFetchRequestImpl(this.internal, Object.assign(this.copyOptions(), { limit: _$requireNonNull_759.requireNonNegativeInt(count, 'count') }));
    };
    SessionFetchRequestImpl.prototype.last = function (count) {
        return new SessionFetchRequestImpl(this.internal, Object.assign(this.copyOptions(), { limit: 0 - _$requireNonNull_759.requireNonNegativeInt(count, 'count') }));
    };
    SessionFetchRequestImpl.prototype.maximumResultSize = function (maximumSize) {
        return new SessionFetchRequestImpl(this.internal, Object.assign(this.copyOptions(), {
            maximumResultSize: Math.min(_$requireNonNull_759.requireNonNegativeInt(maximumSize, 'maximumSize'), this.internal.getOptions().maxMessageSize)
        }));
    };
    SessionFetchRequestImpl.prototype.filter = function (filter) {
        return new SessionFetchRequestImpl(this.internal, Object.assign(this.copyOptions(), {
            filter: filter
        }));
    };
    SessionFetchRequestImpl.prototype.fetch = function () {
        var serviceLocator = this.internal.getServiceLocator();
        var SESSION_FETCH = serviceLocator.obtain(_$clientControlServices_441.SESSION_FETCH);
        var propertySet = this.options.withProperties && new Set(this.options.withProperties);
        var requiresStartTime = !propertySet
            || propertySet.has(_$clientControlOptions_281.ClientControlOptions.PropertyKeys.START_TIME)
            || propertySet.has(_$clientControlOptions_281.ClientControlOptions.PropertyKeys.ALL_FIXED_PROPERTIES[0]);
        var query = new _$sessionFetchQuery_628.SessionFetchQuery(this.options.filter, this.options.range, propertySet, this.options.limit, this.options.maximumResultSize, requiresStartTime);
        return new Promise(function (resolve, reject) {
            SESSION_FETCH.send(query, function (err, fetchQueryResult) {
                if (!_$responseSuccess_760.responseSuccess(err, fetchQueryResult)) {
                    __log_357.debug('Session fetch query failed');
                    reject(err);
                }
                else if (fetchQueryResult.errors) {
                    __log_357.debug('Session fetch query failed');
                    reject(fetchQueryResult.errors.errors);
                }
                else {
                    resolve(new _$sessionFetchResult_358.SessionFetchResultImpl(fetchQueryResult.results || [], fetchQueryResult.totalCount || 0));
                }
            });
        });
    };
    return SessionFetchRequestImpl;
}());
_$sessionFetchRequest_357.SessionFetchRequestImpl = SessionFetchRequestImpl;

var _$changeAuthorisationRolesFilterRequest_461 = {};
"use strict";
Object.defineProperty(_$changeAuthorisationRolesFilterRequest_461, "__esModule", { value: true });
_$changeAuthorisationRolesFilterRequest_461.ChangeAuthorisationRolesFilterRequest = void 0;
var ChangeAuthorisationRolesFilterRequest =  (function () {
    function ChangeAuthorisationRolesFilterRequest(filter, rolesToRemove, rolesToAdd) {
        this.filter = filter;
        this.rolesToRemove = rolesToRemove;
        this.rolesToAdd = rolesToAdd;
    }
    return ChangeAuthorisationRolesFilterRequest;
}());
_$changeAuthorisationRolesFilterRequest_461.ChangeAuthorisationRolesFilterRequest = ChangeAuthorisationRolesFilterRequest;

var _$changeAuthorisationRolesRequest_463 = {};
"use strict";
Object.defineProperty(_$changeAuthorisationRolesRequest_463, "__esModule", { value: true });
_$changeAuthorisationRolesRequest_463.ChangeAuthorisationRolesRequest = void 0;
var ChangeAuthorisationRolesRequest =  (function () {
    function ChangeAuthorisationRolesRequest(sessionID, rolesToRemove, rolesToAdd) {
        this.sessionID = sessionID;
        this.rolesToRemove = rolesToRemove;
        this.rolesToAdd = rolesToAdd;
    }
    return ChangeAuthorisationRolesRequest;
}());
_$changeAuthorisationRolesRequest_463.ChangeAuthorisationRolesRequest = ChangeAuthorisationRolesRequest;

var _$setClientConflationFilterRequest_492 = {};
"use strict";
Object.defineProperty(_$setClientConflationFilterRequest_492, "__esModule", { value: true });
_$setClientConflationFilterRequest_492.SetClientConflationFilterRequest = void 0;
var SetClientConflationFilterRequest =  (function () {
    function SetClientConflationFilterRequest(filter, conflate) {
        this.filter = filter;
        this.conflate = conflate;
    }
    return SetClientConflationFilterRequest;
}());
_$setClientConflationFilterRequest_492.SetClientConflationFilterRequest = SetClientConflationFilterRequest;

var _$setClientConflationRequest_494 = {};
"use strict";
Object.defineProperty(_$setClientConflationRequest_494, "__esModule", { value: true });
_$setClientConflationRequest_494.SetClientConflationRequest = void 0;
var SetClientConflationRequest =  (function () {
    function SetClientConflationRequest(sessionID, conflate) {
        this.sessionID = sessionID;
        this.conflate = conflate;
    }
    return SetClientConflationRequest;
}());
_$setClientConflationRequest_494.SetClientConflationRequest = SetClientConflationRequest;

var _$setSessionPropertiesFilterRequest_496 = {};
"use strict";
Object.defineProperty(_$setSessionPropertiesFilterRequest_496, "__esModule", { value: true });
_$setSessionPropertiesFilterRequest_496.SetSessionPropertiesFilterRequest = void 0;
var SetSessionPropertiesFilterRequest =  (function () {
    function SetSessionPropertiesFilterRequest(filter, overwriteProperties, removeProperties) {
        this.filter = filter;
        this.overwriteProperties = overwriteProperties;
        this.removeProperties = removeProperties;
    }
    return SetSessionPropertiesFilterRequest;
}());
_$setSessionPropertiesFilterRequest_496.SetSessionPropertiesFilterRequest = SetSessionPropertiesFilterRequest;

var _$sessionEventListenerRegistrationRequest_486 = {};
"use strict";
Object.defineProperty(_$sessionEventListenerRegistrationRequest_486, "__esModule", { value: true });
_$sessionEventListenerRegistrationRequest_486.SessionEventListenerRegistrationRequest = void 0;
var SessionEventListenerRegistrationRequest =  (function () {
    function SessionEventListenerRegistrationRequest(isClusterAware, sessionFilter, requestedProperties, sessionStartTime, conversationId) {
        this.isClusterAware = isClusterAware;
        this.sessionFilter = sessionFilter;
        this.requestedProperties = requestedProperties;
        this.sessionStartTime = sessionStartTime;
        this.conversationId = conversationId;
    }
    return SessionEventListenerRegistrationRequest;
}());
_$sessionEventListenerRegistrationRequest_486.SessionEventListenerRegistrationRequest = SessionEventListenerRegistrationRequest;

var _$validateSelectionScope_763 = {};
"use strict";
Object.defineProperty(_$validateSelectionScope_763, "__esModule", { value: true });
_$validateSelectionScope_763.validateSelectionScope = void 0;
;
;
function validateSelectionScope(scope) {
    _$requireNonNull_759.requireNonNull(scope, 'scope');
    if (scope.startsWith('$')) {
        throw new _$errors_280.IllegalArgumentError("Scope '" + scope + "' must not start with the character $");
    }
}
_$validateSelectionScope_763.validateSelectionScope = validateSelectionScope;

var _$topicResult_405 = {};
"use strict";
Object.defineProperty(_$topicResult_405, "__esModule", { value: true });
_$topicResult_405.TopicResultImpl = void 0;
;
var TopicResultImpl =  (function () {
    function TopicResultImpl(path, type, value, properties, sizeInfo) {
        this.mPath = path;
        this.mType = type;
        this.mValue = value;
        this.mProperties = properties;
        this.sizeInfo = sizeInfo;
    }
    TopicResultImpl.prototype.path = function () {
        return this.mPath;
    };
    TopicResultImpl.prototype.type = function () {
        return this.mType;
    };
    TopicResultImpl.prototype.value = function () {
        return this.mValue;
    };
    TopicResultImpl.prototype.specification = function () {
        return new _$topicSpecification_783.TopicSpecification(this.mType, this.mProperties);
    };
    TopicResultImpl.prototype.valueSize = function () {
        return this.sizeInfo.valueSize;
    };
    TopicResultImpl.prototype.valueCount = function () {
        return this.sizeInfo.valueCount;
    };
    TopicResultImpl.prototype.valueTotalSize = function () {
        return this.sizeInfo.valueTotalSize;
    };
    return TopicResultImpl;
}());
_$topicResult_405.TopicResultImpl = TopicResultImpl;

var _$fetchResult_404 = {};
"use strict";
Object.defineProperty(_$fetchResult_404, "__esModule", { value: true });
_$fetchResult_404.FetchResultImpl = _$fetchResult_404.TIME_SERIES_DATA_TYPE = void 0;
;
;
var __time_series_event_datatype_1_404 = _$timeSeriesEventDatatype_713({});
_$fetchResult_404.TIME_SERIES_DATA_TYPE = __time_series_event_datatype_1_404.TimeSeriesEventDataType.create({
    name: function () { return 'event data type'; },
    readValue: function (buffer) { return buffer; },
    toBytes: function (val) { return val; }
});
var FetchResultImpl =  (function () {
    function FetchResultImpl(dataType, result, context) {
        this.resultList = result.results.map(function (topicResult) {
            var value;
            if (topicResult.value !== undefined) {
                if (topicResult.type === context.TopicType.TIME_SERIES) {
                    var event_1 = _$fetchResult_404.TIME_SERIES_DATA_TYPE.readAs(_$fetchResult_404.TIME_SERIES_DATA_TYPE.valueClass, topicResult.value);
                    if (dataType instanceof context.TimeSeriesEventDataType || dataType instanceof _$anyDatatype_317.AnyDataTypeImpl) {
                        value = event_1;
                    }
                    else {
                        value = dataType.readAs(dataType.valueClass, event_1.value);
                    }
                }
                else {
                    var topicDataType = context.DataTypes.get(topicResult.type);
                    value = topicDataType.readAs(dataType.valueClass, topicResult.value);
                }
            }
            return new _$topicResult_405.TopicResultImpl(topicResult.path, topicResult.type, value, result.properties.length === 0 ? {} :
                result.properties[topicResult.propertiesIndex], topicResult.topicSizeInfo);
        });
        this.hasMoreFlag = result.hasMore;
    }
    FetchResultImpl.prototype.results = function () {
        return this.resultList;
    };
    FetchResultImpl.prototype.hasMore = function () {
        return this.hasMoreFlag;
    };
    FetchResultImpl.prototype.size = function () {
        return this.resultList.length;
    };
    FetchResultImpl.prototype.isEmpty = function () {
        return this.resultList.length === 0;
    };
    return FetchResultImpl;
}());
_$fetchResult_404.FetchResultImpl = FetchResultImpl;

var _$fetchQuery_517 = {};
"use strict";
Object.defineProperty(_$fetchQuery_517, "__esModule", { value: true });
_$fetchQuery_517.FetchQuery = void 0;
;
var FetchQuery =  (function () {
    function FetchQuery(selector, range, topicTypes, withValues, withProperties, limit, maximumResultSize, deepBranchDepth, deepBranchLimit, withUnpublishedDelayedTopics, withSizes) {
        this.selector = _$requireNonNull_759.requireNonNull(selector, 'FetchQuery.selector');
        this.range = range;
        this.topicTypes = _$requireNonNull_759.requireNonNull(topicTypes, 'FetchQuery.topicTypes');
        this.withValues = withValues;
        this.withProperties = withProperties;
        this.limit = limit;
        this.maximumResultSize = maximumResultSize;
        this.deepBranchDepth = deepBranchDepth;
        this.deepBranchLimit = deepBranchLimit;
        this.withUnpublishedDelayedTopics = withUnpublishedDelayedTopics;
        this.withSizes = withSizes;
    }
    return FetchQuery;
}());
_$fetchQuery_517.FetchQuery = FetchQuery;

var _$fetchTopicResult_518 = {};
"use strict";
Object.defineProperty(_$fetchTopicResult_518, "__esModule", { value: true });
_$fetchTopicResult_518.FetchTopicResult = void 0;
var FetchTopicResult =  (function () {
    function FetchTopicResult(path, type, propertiesIndex, topicSizeInfo, value) {
        this.path = path;
        this.type = type;
        this.value = value;
        this.propertiesIndex = propertiesIndex;
        this.topicSizeInfo = topicSizeInfo;
    }
    return FetchTopicResult;
}());
_$fetchTopicResult_518.FetchTopicResult = FetchTopicResult;

var _$fetchQueryResult_515 = {};
"use strict";
Object.defineProperty(_$fetchQueryResult_515, "__esModule", { value: true });
_$fetchQueryResult_515.FetchQueryResult = void 0;
var FetchQueryResult =  (function () {
    function FetchQueryResult(properties, results, hasMore) {
        this.properties = properties;
        this.results = results;
        this.hasMore = hasMore;
    }
    return FetchQueryResult;
}());
_$fetchQueryResult_515.FetchQueryResult = FetchQueryResult;

var _$fetchTopicSizeInfo_519 = {};
"use strict";
Object.defineProperty(_$fetchTopicSizeInfo_519, "__esModule", { value: true });
_$fetchTopicSizeInfo_519.NO_TOPIC_SIZE_INFO = _$fetchTopicSizeInfo_519.FetchTopicSizeType = void 0;
;
var FetchTopicSizeType;
(function (FetchTopicSizeType) {
    FetchTopicSizeType[FetchTopicSizeType["NO_SIZE_INFO"] = 0] = "NO_SIZE_INFO";
    FetchTopicSizeType[FetchTopicSizeType["SIMPLE_SIZE_INFO"] = 1] = "SIMPLE_SIZE_INFO";
    FetchTopicSizeType[FetchTopicSizeType["TIME_SERIES_SIZE_INFO"] = 2] = "TIME_SERIES_SIZE_INFO";
})(FetchTopicSizeType = _$fetchTopicSizeInfo_519.FetchTopicSizeType || (_$fetchTopicSizeInfo_519.FetchTopicSizeType = {}));
_$fetchTopicSizeInfo_519.NO_TOPIC_SIZE_INFO = {
    infoType: FetchTopicSizeType.NO_SIZE_INFO,
    valueSize: 0,
    valueCount: 0,
    valueTotalSize: new _$Long_274(0)
};

var _$fetchQueryResultSerialiser_514 = {};
"use strict";
var ____extends_514 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$fetchQueryResultSerialiser_514, "__esModule", { value: true });
_$fetchQueryResultSerialiser_514.FetchQueryResultSerialiser =  void 0;
;
;
;
;
;
;
;
;
function readProperties(bis) {
    return _$codec_411.readDictionary(bis, _$codec_411.readString);
}
function readSizeInfo(bis) {
    var infoType = _$byteEncodedEnumSerialiser_426.read(bis, _$fetchTopicSizeInfo_519.FetchTopicSizeType);
    if (infoType === _$fetchTopicSizeInfo_519.FetchTopicSizeType.SIMPLE_SIZE_INFO) {
        var size = _$codec_411.readInt32(bis);
        return {
            infoType: infoType,
            valueSize: size,
            valueCount: 1,
            valueTotalSize: new _$Long_274(size)
        };
    }
    else if (infoType === _$fetchTopicSizeInfo_519.FetchTopicSizeType.TIME_SERIES_SIZE_INFO) {
        return {
            infoType: infoType,
            valueSize: _$codec_411.readInt32(bis),
            valueCount: _$codec_411.readInt32(bis),
            valueTotalSize: _$codec_411.readInt64(bis)
        };
    }
    return _$fetchTopicSizeInfo_519.NO_TOPIC_SIZE_INFO;
}
function readFetchTopicResult(bis) {
    var path = _$codec_411.readString(bis);
    var type = _$byteEncodedEnumSerialiser_426.read(bis, _$topicType_784.TopicType);
    var value = _$codec_411.readOptional(bis, _$codec_411.readBytes);
    var propertiesIndex = _$codec_411.readInt32(bis);
    var sizeInfo = readSizeInfo(bis);
    return new _$fetchTopicResult_518.FetchTopicResult(path, type, propertiesIndex, sizeInfo, value);
}
var FetchQueryResultSerialiserClass =  (function (_super) {
    ____extends_514(FetchQueryResultSerialiserClass, _super);
    function FetchQueryResultSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    FetchQueryResultSerialiserClass.prototype.read = function (bis) {
        var properties = _$codec_411.readCollection(bis, readProperties);
        var results = _$codec_411.readCollection(bis, readFetchTopicResult);
        var hasMore = _$codec_411.readBoolean(bis);
        return new _$fetchQueryResult_515.FetchQueryResult(properties, results, hasMore);
    };
    return FetchQueryResultSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void FetchQueryResultSerialiserClass;
_$fetchQueryResultSerialiser_514.FetchQueryResultSerialiser = new FetchQueryResultSerialiserClass();

var _$longEncodedEnumSetSerialiser_429 = {};
"use strict";
Object.defineProperty(_$longEncodedEnumSetSerialiser_429, "__esModule", { value: true });
_$longEncodedEnumSetSerialiser_429.write =  void 0;
;
;
;
;
function __read_429(bis, enumType) {
    var enums = new Set();
    var bitmap = _$codec_411.readInt64(bis);
    var shift = 0;
    var enumReader = {
        read: function () {
            return shift;
        }
    };
    while (!bitmap.isZero()) {
        if (!bitmap.and(1).isZero()) {
            enums.add(_$byteEncodedEnumSerialiser_426.read(enumReader, enumType));
        }
        bitmap = bitmap.shiftRight(1);
        shift++;
    }
    return enums;
}
 void __read_429;
function __write_429(bos, enumSet) {
    var bitmap = _$Long_274.UZERO;
    var enumWriter = {
        write: function (val) {
            if (val >= 64) {
                throw new _$errors_280.IOError("Cannot encode enum in long, " + val + " >= 64'");
            }
            bitmap = bitmap.or(_$Long_274.ONE.shiftLeft(val));
        }
    };
    enumSet.forEach(function (e) {
        _$byteEncodedEnumSerialiser_426.write(enumWriter, e);
    });
    _$codec_411.writeInt64(bos, bitmap);
}
_$longEncodedEnumSetSerialiser_429.write = __write_429;

var _$fetchQuerySerialiser_516 = {};
"use strict";
var ____extends_516 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$fetchQuerySerialiser_516, "__esModule", { value: true });
_$fetchQuerySerialiser_516.FetchQuerySerialiser =  void 0;
;
;
;
function writeLimit(bos, limit) {
    _$codec_411.writeOptional(bos, limit, function (ostream, lim) {
        _$codec_411.writeString(ostream, lim.path);
        _$codec_411.writeBoolean(ostream, lim.includesPath);
    });
}
function writeRange(bos, range) {
    writeLimit(bos, range.from);
    writeLimit(bos, range.to);
}
var FetchQuerySerialiserClass =  (function (_super) {
    ____extends_516(FetchQuerySerialiserClass, _super);
    function FetchQuerySerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    FetchQuerySerialiserClass.prototype.write = function (bos, value) {
        _$codec_411.writeString(bos, value.selector.expression);
        writeRange(bos, value.range);
        _$longEncodedEnumSetSerialiser_429.write(bos, value.topicTypes);
        _$codec_411.writeBoolean(bos, value.withValues);
        _$codec_411.writeBoolean(bos, value.withProperties);
        _$codec_411.writeInt32(bos, value.limit);
        _$codec_411.writeInt32(bos, value.maximumResultSize);
        _$codec_411.writeInt32(bos, value.deepBranchDepth);
        _$codec_411.writeInt32(bos, value.deepBranchLimit);
        _$codec_411.writeBoolean(bos, value.withUnpublishedDelayedTopics);
        _$codec_411.writeBoolean(bos, value.withSizes);
    };
    return FetchQuerySerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void FetchQuerySerialiserClass;
_$fetchQuerySerialiser_516.FetchQuerySerialiser = new FetchQuerySerialiserClass();

var _$topicSelectionRequestSerialiser_703 = {};
"use strict";
var ____extends_703 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$topicSelectionRequestSerialiser_703, "__esModule", { value: true });
_$topicSelectionRequestSerialiser_703.TopicSelectionRequestSerialiser =  void 0;
;
;
;
var TopicSelectionRequestSerialiserClass =  (function (_super) {
    ____extends_703(TopicSelectionRequestSerialiserClass, _super);
    function TopicSelectionRequestSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TopicSelectionRequestSerialiserClass.prototype.read = function (bis) {
        return {
            selector: _$topicSelectorParser_740.parseSelector(_$codec_411.readString(bis)),
            scope: _$codec_411.readString(bis)
        };
    };
    TopicSelectionRequestSerialiserClass.prototype.write = function (bos, value) {
        _$codec_411.writeString(bos, value.selector.expression);
        _$codec_411.writeString(bos, value.scope);
    };
    return TopicSelectionRequestSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void TopicSelectionRequestSerialiserClass;
_$topicSelectionRequestSerialiser_703.TopicSelectionRequestSerialiser = new TopicSelectionRequestSerialiserClass();

var _$topicSelectorSerialiser_704 = {};
"use strict";
var ____extends_704 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$topicSelectorSerialiser_704, "__esModule", { value: true });
_$topicSelectorSerialiser_704.TopicSelectorSerialiser =  void 0;
;
;
;
var TopicSelectorSerialiserClass =  (function (_super) {
    ____extends_704(TopicSelectorSerialiserClass, _super);
    function TopicSelectorSerialiserClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TopicSelectorSerialiserClass.prototype.read = function (bis) {
        return _$topicSelectorParser_740.parseSelector(_$codec_411.readString(bis));
    };
    TopicSelectorSerialiserClass.prototype.write = function (bos, value) {
        _$codec_411.writeString(bos, value.expression);
    };
    return TopicSelectorSerialiserClass;
}(_$serialiser_430.AbstractSerialiser));
 void TopicSelectorSerialiserClass;
_$topicSelectorSerialiser_704.TopicSelectorSerialiser = new TopicSelectorSerialiserClass();

var _$topicsServices_702 = {};
"use strict";
Object.defineProperty(_$topicsServices_702, "__esModule", { value: true });
_$topicsServices_702.FETCH_QUERY = _$topicsServices_702.UNSUBSCRIBE_ALL = _$topicsServices_702.UNSUBSCRIBE = _$topicsServices_702.SUBSCRIBE = void 0;
;
;
;
;
;
_$topicsServices_702.SUBSCRIBE = {
    id: 3,
    request: _$topicSelectionRequestSerialiser_703.TopicSelectionRequestSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
_$topicsServices_702.UNSUBSCRIBE = {
    id: 4,
    request: _$topicSelectionRequestSerialiser_703.TopicSelectionRequestSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
_$topicsServices_702.UNSUBSCRIBE_ALL = {
    id: 199,
    request: _$topicSelectorSerialiser_704.TopicSelectorSerialiser,
    response: _$serviceDefinition_623.NullSerialiser
};
_$topicsServices_702.FETCH_QUERY = {
    id: 117,
    request: _$fetchQuerySerialiser_516.FetchQuerySerialiser,
    response: _$fetchQueryResultSerialiser_514.FetchQueryResultSerialiser
};

var _$fetchRequest_403 = {};
"use strict";
var ____extends_403 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$fetchRequest_403, "__esModule", { value: true });
_$fetchRequest_403.FetchRequestImpl =   void 0;
;
;
;
;
;
;
;
;
;
;
;
var __log_403 = _$logger_752.create('Fetch Request');
var Limit =  (function () {
    function Limit(path, includesPath) {
        this.path = path;
        this.includesPath = includesPath;
    }
    return Limit;
}());
 void Limit;
var FetchRange =  (function () {
    function FetchRange(from, to) {
        this.from = from;
        this.to = to;
    }
    FetchRange.prototype.isUnbounded = function () {
        return this.from === undefined && this.to === undefined;
    };
    return FetchRange;
}());
 void FetchRange;
function canReadAs(dataTypes, topicType, dataType) {
    if (topicType === _$topicType_784.TopicType.TIME_SERIES) {
        return _$fetchResult_404.TIME_SERIES_DATA_TYPE.canReadAs(dataType);
    }
    else {
        var topicDataType = dataTypes.getByValue(topicType);
        return topicDataType !== null && dataType.valueClass !== undefined
            && topicDataType.canReadAs(dataType.valueClass);
    }
}
var FetchRequestImpl =  (function (_super) {
    ____extends_403(FetchRequestImpl, _super);
    function FetchRequestImpl(internal, opts) {
        var _this = _super.call(this) || this;
        var defaultOptions = {
            range: new FetchRange(),
            topicTypes: _$fetchRequest_781.FetchRequest.getAllTypes(),
            dataType: undefined,
            withProperties: false,
            limit: _$math_753.MAX_INT32,
            maximumResultSize: internal.getOptions().maxMessageSize,
            deepBranchDepth: _$math_753.MAX_INT32,
            deepBranchLimit: _$math_753.MAX_INT32,
            withUnpublishedDelayedTopics: false,
            withSizes: false
        };
        _this.internal = internal;
        _this.options = Object.assign(defaultOptions, opts);
        return _this;
    }
    FetchRequestImpl.prototype.copyOptions = function () {
        return {
            range: new FetchRange(this.options.range.from, this.options.range.to),
            topicTypes: new Set(this.options.topicTypes),
            dataType: this.options.dataType,
            withProperties: this.options.withProperties,
            limit: this.options.limit,
            maximumResultSize: this.options.maximumResultSize,
            deepBranchDepth: this.options.deepBranchDepth,
            deepBranchLimit: this.options.deepBranchLimit,
            withUnpublishedDelayedTopics: this.options.withUnpublishedDelayedTopics,
            withSizes: this.options.withSizes
        };
    };
    FetchRequestImpl.prototype.from = function (topicPath) {
        var limit = new Limit(topicPath, true);
        return new FetchRequestImpl(this.internal, Object.assign(this.copyOptions(), { range: new FetchRange(limit, this.options.range.to) }));
    };
    FetchRequestImpl.prototype.after = function (topicPath) {
        var limit = new Limit(topicPath, false);
        return new FetchRequestImpl(this.internal, Object.assign(this.copyOptions(), { range: new FetchRange(limit, this.options.range.to) }));
    };
    FetchRequestImpl.prototype.to = function (topicPath) {
        var limit = new Limit(topicPath, true);
        return new FetchRequestImpl(this.internal, Object.assign(this.copyOptions(), { range: new FetchRange(this.options.range.from, limit) }));
    };
    FetchRequestImpl.prototype.before = function (topicPath) {
        var limit = new Limit(topicPath, false);
        return new FetchRequestImpl(this.internal, Object.assign(this.copyOptions(), { range: new FetchRange(this.options.range.from, limit) }));
    };
    FetchRequestImpl.prototype.topicTypes = function (topicTypes) {
        var _this = this;
        if (Array.isArray(topicTypes)) {
            topicTypes = new Set(topicTypes);
        }
        if (topicTypes.size === 0) {
            throw new _$errors_280.IllegalArgumentError('No types specified');
        }
        var allTypes = _$fetchRequest_781.FetchRequest.getAllTypes();
        var context = this.internal.getContext();
        topicTypes.forEach(function (topicType) {
            if (!allTypes.has(topicType)) {
                throw new _$errors_280.IllegalArgumentError("Invalid topic type " + topicType);
            }
            if (_this.options.dataType !== undefined
                && !canReadAs(context.DataTypes, topicType, _this.options.dataType)
                && topicType !== context.TopicType.TIME_SERIES) {
                throw new _$errors_280.IllegalArgumentError("Topic type " + topicType + " cannot be read as " + _this.options.dataType);
            }
        });
        return new FetchRequestImpl(this.internal, Object.assign(this.copyOptions(), { topicTypes: topicTypes }));
    };
    FetchRequestImpl.prototype.withValues = function (dataType) {
        var _this = this;
        var selectedTopicTypes;
        if (dataType !== undefined && !(dataType instanceof _$anyDatatype_317.AnyDataTypeImpl)) {
            selectedTopicTypes = new Set(this.options.topicTypes);
            this.options.topicTypes.forEach(function (topicType) {
                if (!canReadAs(_this.internal.getContext().DataTypes, topicType, dataType)) {
                    selectedTopicTypes.delete(topicType);
                }
            });
            if (selectedTopicTypes.size === 0) {
                throw new _$errors_280.IllegalArgumentError("No selected topic types can be read as " + dataType);
            }
        }
        else {
            selectedTopicTypes = this.options.topicTypes;
        }
        return new FetchRequestImpl(this.internal, Object.assign(this.copyOptions(), { topicTypes: selectedTopicTypes, dataType: dataType }));
    };
    FetchRequestImpl.prototype.withSizes = function () {
        return new FetchRequestImpl(this.internal, Object.assign(this.copyOptions(), { withSizes: true }));
    };
    FetchRequestImpl.prototype.withProperties = function () {
        return new FetchRequestImpl(this.internal, Object.assign(this.copyOptions(), { withProperties: true }));
    };
    FetchRequestImpl.prototype.first = function (count) {
        return new FetchRequestImpl(this.internal, Object.assign(this.copyOptions(), { limit: _$requireNonNull_759.requireNonNegativeInt(count, 'count') }));
    };
    FetchRequestImpl.prototype.last = function (count) {
        return new FetchRequestImpl(this.internal, Object.assign(this.copyOptions(), { limit: 0 - _$requireNonNull_759.requireNonNegativeInt(count, 'count') }));
    };
    FetchRequestImpl.prototype.maximumResultSize = function (maximumSize) {
        return new FetchRequestImpl(this.internal, Object.assign(this.copyOptions(), {
            maximumResultSize: Math.min(_$requireNonNull_759.requireNonNegativeInt(maximumSize, 'maximumSize'), this.internal.getOptions().maxMessageSize)
        }));
    };
    FetchRequestImpl.prototype.limitDeepBranches = function (deepBranchDepth, deepBranchLimit) {
        return new FetchRequestImpl(this.internal, Object.assign(this.copyOptions(), {
            deepBranchDepth: _$requireNonNull_759.requireNonNegativeInt(deepBranchDepth, 'deepBranchDepth'),
            deepBranchLimit: _$requireNonNull_759.requireNonNegativeInt(deepBranchLimit, 'deepBranchLimit')
        }));
    };
    FetchRequestImpl.prototype.withUnpublishedDelayedTopics = function () {
        return new FetchRequestImpl(this.internal, Object.assign(this.copyOptions(), { withUnpublishedDelayedTopics: true }));
    };
    FetchRequestImpl.prototype.fetch = function (topics) {
        var _this = this;
        var extraTopics = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            extraTopics[_i - 1] = arguments[_i];
        }
        var parseSelector = this.internal.getContext().parseSelector;
        var serviceLocator = this.internal.getServiceLocator();
        var FETCH_QUERY = serviceLocator.obtain(_$topicsServices_702.FETCH_QUERY);
        var selector = (arguments.length > 1)
            ? parseSelector(Array.prototype.slice.call(arguments))
            : parseSelector(topics);
        var query = new _$fetchQuery_517.FetchQuery(selector, this.options.range, this.options.topicTypes, this.options.dataType !== undefined, this.options.withProperties, this.options.limit, this.options.maximumResultSize, this.options.deepBranchDepth, this.options.deepBranchLimit, this.options.withUnpublishedDelayedTopics, this.options.withSizes);
        return new Promise(function (resolve, reject) {
            FETCH_QUERY.send(query, function (err, fetchQueryResult) {
                if (!_$responseSuccess_760.responseSuccess(err, fetchQueryResult)) {
                    __log_403.debug('Fetch query failed');
                    reject(err);
                }
                else {
                    try {
                        var fetchResult = new _$fetchResult_404.FetchResultImpl(_this.options.dataType, fetchQueryResult, _this.internal.getContext());
                        resolve(fetchResult);
                    }
                    catch (err) {
                        reject(err);
                    }
                }
            });
        });
    };
    return FetchRequestImpl;
}(_$fetchRequest_781.FetchRequest));
_$fetchRequest_403.FetchRequestImpl = FetchRequestImpl;

var _$valueStream_408 = {};
"use strict";
var ____extends_408 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$valueStream_408, "__esModule", { value: true });
_$valueStream_408.ValueStreamImpl = void 0;
;
var ValueStreamImpl =  (function (_super) {
    ____extends_408(ValueStreamImpl, _super);
    function ValueStreamImpl(emitterFactory, selector) {
        var _this = _super.call(this, emitterFactory) || this;
        _this.selector = selector;
        return _this;
    }
    return ValueStreamImpl;
}(_$stream_354.StreamImpl));
_$valueStream_408.ValueStreamImpl = ValueStreamImpl;

var _$valueStreamAdapter_406 = {};
"use strict";
var ____extends_406 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(_$valueStreamAdapter_406, "__esModule", { value: true });
_$valueStreamAdapter_406.ValueStreamTimeseriesToPrimitiveAdapter = _$valueStreamAdapter_406.ValueStreamTimeseriesAdapter = _$valueStreamAdapter_406.ValueStreamAdapter =  void 0;
;
var __datatypes_1_406 = _$datatypes_324({});
;
var ValueStreamAdapterBase =  (function () {
    function ValueStreamAdapterBase(stream, datatype, topicSpec) {
        this.stream = stream;
        this.datatype = datatype;
        this.sourceDatatype = this.getSourceDataType(topicSpec);
    }
    ValueStreamAdapterBase.prototype.selects = function (specification) {
        return this.stream.selects(specification);
    };
    ValueStreamAdapterBase.prototype.onOpen = function () {
        return this.stream.onOpen();
    };
    ValueStreamAdapterBase.prototype.onDelta = function (path, specification, oldContent, content, delta, oldValue, newValue) {
        return this.stream.onDelta(path, specification, oldContent, content, delta, (oldContent !== null) ? this.readAsDataType(oldContent, oldValue) : null, this.readAsDataType(content, newValue));
    };
    ValueStreamAdapterBase.prototype.onValue = function (path, specification, oldContent, content, oldValue, newValue) {
        return this.stream.onValue(path, specification, oldContent, content, (oldContent !== null) ? this.readAsDataType(oldContent, oldValue) : null, this.readAsDataType(content, newValue));
    };
    ValueStreamAdapterBase.prototype.onSubscription = function (path, specification) {
        return this.stream.onSubscription(path, specification);
    };
    ValueStreamAdapterBase.prototype.onUnsubscription = function (path, specification, reason) {
        return this.stream.onUnsubscription(path, specification, reason);
    };
    ValueStreamAdapterBase.prototype.onSubscriptionError = function (error) {
        return this.stream.onSubscriptionError(error);
    };
    return ValueStreamAdapterBase;
}());
 void ValueStreamAdapterBase;
var ValueStreamAdapter =  (function (_super) {
    ____extends_406(ValueStreamAdapter, _super);
    function ValueStreamAdapter(stream, datatype, topicSpec) {
        return _super.call(this, stream, datatype, topicSpec) || this;
    }
    ValueStreamAdapter.prototype.getSourceDataType = function (topicSpec) {
        return __datatypes_1_406.DataTypes.getByValue(topicSpec.type);
    };
    ValueStreamAdapter.prototype.readAsDataType = function (buffer) {
        return this.sourceDatatype.readAs(this.datatype.valueClass, buffer);
    };
    return ValueStreamAdapter;
}(ValueStreamAdapterBase));
_$valueStreamAdapter_406.ValueStreamAdapter = ValueStreamAdapter;
var ValueStreamTimeseriesAdapter =  (function (_super) {
    ____extends_406(ValueStreamTimeseriesAdapter, _super);
    function ValueStreamTimeseriesAdapter(stream, datatype, topicSpec) {
        var _this = _super.call(this, stream, datatype, topicSpec) || this;
        _this.sourceValuetype = __datatypes_1_406.DataTypes.getByName(_this.sourceDatatype.valueTypeName);
        _this.destValuetype = __datatypes_1_406.DataTypes.getByName(_this.datatype.valueTypeName);
        return _this;
    }
    ValueStreamTimeseriesAdapter.prototype.getSourceDataType = function (topicSpec) {
        return __datatypes_1_406.DataTypes.timeseries(__datatypes_1_406.DataTypes.getByName(topicSpec.properties.TIME_SERIES_EVENT_VALUE_TYPE));
    };
    ValueStreamTimeseriesAdapter.prototype.readAsDataType = function (buffer, sourceEvent) {
        var sourceBuffer;
        try {
            sourceBuffer = this.sourceValuetype.writeValueToArray(sourceEvent.value);
        }
        catch (e) {
            throw new _$errors_280.InvalidDataError(e.message);
        }
        var destValue = this.sourceValuetype.readAs(this.destValuetype.valueClass, sourceBuffer);
        return new _$timeSeriesEvent_654.EventImpl(sourceEvent.metadata, sourceEvent.originalEvent, destValue);
    };
    return ValueStreamTimeseriesAdapter;
}(ValueStreamAdapterBase));
_$valueStreamAdapter_406.ValueStreamTimeseriesAdapter = ValueStreamTimeseriesAdapter;
var ValueStreamTimeseriesToPrimitiveAdapter =  (function (_super) {
    ____extends_406(ValueStreamTimeseriesToPrimitiveAdapter, _super);
    function ValueStreamTimeseriesToPrimitiveAdapter(stream, datatype, topicSpec) {
        var _this = _super.call(this, stream, datatype, topicSpec) || this;
        _this.sourceValuetype = __datatypes_1_406.DataTypes.getByName(_this.sourceDatatype.valueTypeName);
        return _this;
    }
    ValueStreamTimeseriesToPrimitiveAdapter.prototype.getSourceDataType = function (topicSpec) {
        return __datatypes_1_406.DataTypes.timeseries(__datatypes_1_406.DataTypes.getByName(topicSpec.properties.TIME_SERIES_EVENT_VALUE_TYPE));
    };
    ValueStreamTimeseriesToPrimitiveAdapter.prototype.readAsDataType = function (buffer, sourceEvent) {
        var sourceBuffer;
        try {
            sourceBuffer = this.sourceValuetype.writeValueToArray(sourceEvent.value);
        }
        catch (e) {
            throw new _$errors_280.InvalidDataError(e.message);
        }
        return this.sourceValuetype.readAs(this.datatype.valueClass, sourceBuffer);
    };
    return ValueStreamTimeseriesToPrimitiveAdapter;
}(ValueStreamAdapterBase));
_$valueStreamAdapter_406.ValueStreamTimeseriesToPrimitiveAdapter = ValueStreamTimeseriesToPrimitiveAdapter;

var _$valueStreamProxy_407 = {};
"use strict";
Object.defineProperty(_$valueStreamProxy_407, "__esModule", { value: true });
_$valueStreamProxy_407.create =  void 0;
var __datatypes_1_407 = _$datatypes_324({});
;
;
;
var __time_series_event_datatype_1_407 = _$timeSeriesEventDatatype_713({});
;
;
;
var ValueStreamProxy =  (function () {
    function ValueStreamProxy(registry, selector, datatype, fallback, subscriptionFactory, adapterFactory) {
        var _this = this;
        this.pending = true;
        var factory = _$emitter_353.Emitter.create();
        this.subscription = subscriptionFactory(factory, selector);
        this.emitter = factory.emitter(this.subscription);
        this.subscription.on('close', function () {
            registry.remove(_this);
        });
        this.adapterFactory = adapterFactory;
        this.datatype = datatype;
        this.registry = registry;
        var onEvent = this.subscription.on.bind(this.subscription);
        this.subscription.on = function (event, fn) {
            var stream = onEvent(event, fn);
            if (_this.pending) {
                try {
                    if (fallback) {
                        registry.addFallback(_this, datatype);
                    }
                    else {
                        registry.add(selector, _this, datatype);
                    }
                }
                catch (err) {
                    _this.emitter.error(_$errorReason_279.ErrorReason.INVALID_DATA);
                }
                _this.pending = false;
            }
            return stream;
        };
    }
    ValueStreamProxy.prototype.selects = function (specification) {
        if (specification) {
            if (specification.type === _$topicType_784.TopicType.TIME_SERIES) {
                var eventType = __datatypes_1_407.DataTypes.get(specification.properties.TIME_SERIES_EVENT_VALUE_TYPE);
                var dataType = this.datatype instanceof __time_series_event_datatype_1_407.TimeSeriesEventDataType
                    ? __datatypes_1_407.DataTypes.get(this.datatype.valueTypeName)
                    : this.datatype;
                return !!eventType && eventType.canReadAs(dataType.valueClass);
            }
            else {
                return __datatypes_1_407.DataTypes.getByValue(specification.type)
                    .canReadAs(this.datatype.valueClass);
            }
        }
        return false;
    };
    ValueStreamProxy.prototype.adapter = function (specification) {
        if ((specification.type === _$topicType_784.TopicType.TIME_SERIES
            && this.datatype.valueTypeName === specification.properties.TIME_SERIES_EVENT_VALUE_TYPE)
            || specification.type === _$topicType_784.TopicType[this.datatype.name().toUpperCase()]
            || this.datatype.name() === 'any') {
            return this;
        }
        else {
            return this.adapterFactory(this, this.datatype, specification);
        }
    };
    ValueStreamProxy.prototype.onOpen = function () {
        this.emitter.emit('open', this.subscription);
    };
    ValueStreamProxy.prototype.onDelta = function (path, specification, oldContent, content, delta, oldValue, newValue) {
        this.emitter.emit('value', path, specification, newValue, oldValue);
    };
    ValueStreamProxy.prototype.onValue = function (path, specification, oldContent, content, oldValue, newValue) {
        this.emitter.emit('value', path, specification, newValue, oldValue);
    };
    ValueStreamProxy.prototype.onSubscription = function (path, specification) {
        this.emitter.emit('subscribe', path, specification);
    };
    ValueStreamProxy.prototype.onUnsubscription = function (path, specification, reason) {
        this.emitter.emit('unsubscribe', path, specification, reason);
    };
    ValueStreamProxy.prototype.onSubscriptionError = function (error) {
        this.emitter.error(error);
        this.registry.remove(this);
    };
    return ValueStreamProxy;
}());
 void ValueStreamProxy;
var FALLBACK_SELECTOR = new _$selectorSet_737.SelectorSet([]);
function __create_407(registry, datatype, fallback, selector) {
    if (selector === void 0) { selector = FALLBACK_SELECTOR; }
    var proxy = new ValueStreamProxy(registry, selector, datatype, fallback, function (factory, topicSelector) {
        return new _$valueStream_408.ValueStreamImpl(factory, topicSelector);
    }, function (stream, streamDatatype, topicSpec) { return (datatype instanceof __time_series_event_datatype_1_407.TimeSeriesEventDataType
        ? new _$valueStreamAdapter_406.ValueStreamTimeseriesAdapter(stream, streamDatatype, topicSpec)
        : topicSpec.type === _$topicType_784.TopicType.TIME_SERIES
            ? new _$valueStreamAdapter_406.ValueStreamTimeseriesToPrimitiveAdapter(stream, streamDatatype, topicSpec)
            : new _$valueStreamAdapter_406.ValueStreamAdapter(stream, streamDatatype, topicSpec)); });
    return proxy.subscription;
}
_$valueStreamProxy_407.create = __create_407;

var _$topics_402 = {};
"use strict";
var ____extends_402 = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ____read_402 = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var ____spreadArray_402 = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(_$topics_402, "__esModule", { value: true });
_$topics_402.TopicsImpl = _$topics_402.DEFAULT_TOPIC_SELECTION_SCOPE = void 0;
;
var __datatypes_1_402 = _$datatypes_324({});
;
;
;
;
;
;
;
var __log_402 = _$logger_752.create('Session');
_$topics_402.DEFAULT_TOPIC_SELECTION_SCOPE = '';
var TopicsImpl =  (function (_super) {
    ____extends_402(TopicsImpl, _super);
    function TopicsImpl(internal, helper) {
        var _this = _super.call(this, helper) || this;
        _this.DEFAULT_SELECTION_SCOPE = _$topics_402.DEFAULT_TOPIC_SELECTION_SCOPE;
        _this.internal = internal;
        _this.UNSUBSCRIBE = internal.getServiceLocator().obtain(_$topicsServices_702.UNSUBSCRIBE);
        _this.UNSUBSCRIBE_ALL = internal.getServiceLocator().obtain(_$topicsServices_702.UNSUBSCRIBE_ALL);
        _this.SUBSCRIBE = internal.getServiceLocator().obtain(_$topicsServices_702.SUBSCRIBE);
        _this.streamRegistry = internal.getStreamRegistry();
        return _this;
    }
    TopicsImpl.prototype.unsubscribe = function (topic) {
        var selectors = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            selectors[_i - 1] = arguments[_i];
        }
        var args = arguments;
        var selectorArray = (args.length > 1)
            ? ____spreadArray_402([], ____read_402(args)) : topic;
        return this.unsubscribeWithScope(selectorArray, this.DEFAULT_SELECTION_SCOPE);
    };
    TopicsImpl.prototype.unsubscribeWithScope = function (selector, scope) {
        var _this = this;
        if (scope === void 0) { scope = this.DEFAULT_SELECTION_SCOPE; }
        var parseSelector = this.internal.getContext().parseSelector;
        return new Promise(function (resolve, reject) {
            _$requireNonNull_759.requireNonNull(selector, 'selector');
            _$validateSelectionScope_763.validateSelectionScope(scope);
            try {
                var topicSelector = parseSelector(selector);
                if (_this.internal.checkConnected(reject)) {
                    var unsubscribeCallback = function (err) {
                        if (err) {
                            __log_402.debug('Unsubscribe failed', selector);
                            reject(err);
                        }
                        else {
                            __log_402.debug('Unsubscribe complete', selector);
                            resolve();
                        }
                    };
                    __log_402.debug('Unsubscribing', selector);
                    _this.UNSUBSCRIBE.send({
                        selector: topicSelector,
                        scope: scope
                    }, unsubscribeCallback);
                }
            }
            catch (err) {
                reject(err);
            }
        });
    };
    TopicsImpl.prototype.unsubscribeAllScopes = function (selector) {
        var _this = this;
        _$requireNonNull_759.requireNonNull(selector, 'selector');
        var parseSelector = this.internal.getContext().parseSelector;
        return new Promise(function (resolve, reject) {
            try {
                var topicSelector = parseSelector(selector);
                if (_this.internal.checkConnected(reject)) {
                    __log_402.debug('Unsubscribing from all scopes', selector);
                    _this.UNSUBSCRIBE_ALL.send(topicSelector, function (err) {
                        if (err) {
                            __log_402.debug('Unsubscribe failed', selector);
                            reject(err);
                        }
                        else {
                            __log_402.debug('Unsubscribe complete', selector);
                            resolve();
                        }
                    });
                }
            }
            catch (err) {
                reject(err);
            }
        });
    };
    TopicsImpl.prototype.fetchRequest = function () {
        return new _$fetchRequest_403.FetchRequestImpl(this.internal);
    };
    TopicsImpl.prototype.select = function (topic) {
        var selectors = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            selectors[_i - 1] = arguments[_i];
        }
        var args = arguments;
        var selectorArray = (args.length > 1)
            ? ____spreadArray_402([], ____read_402(args)) : topic;
        return this.selectWithScope(selectorArray, this.DEFAULT_SELECTION_SCOPE);
    };
    TopicsImpl.prototype.selectWithScope = function (selector, scope) {
        var _this = this;
        if (scope === void 0) { scope = this.DEFAULT_SELECTION_SCOPE; }
        var parseSelector = this.internal.getContext().parseSelector;
        return new Promise(function (resolve, reject) {
            _$requireNonNull_759.requireNonNull(selector, 'selector');
            _$validateSelectionScope_763.validateSelectionScope(scope);
            __log_402.debug('Subscribing', selector);
            try {
                var topicSelector = parseSelector(selector);
                if (_this.internal.checkConnected(reject)) {
                    _this.SUBSCRIBE.send({
                        selector: topicSelector,
                        scope: scope
                    }, function (err) {
                        if (!err) {
                            resolve();
                        }
                        else {
                            reject(err);
                        }
                    });
                }
            }
            catch (err) {
                reject(err);
            }
        });
    };
    TopicsImpl.prototype.addStream = function (topic, datatype) {
        if (arguments.length !== 2) {
            throw new _$errors_280.IllegalArgumentError('Both topic selector and value type are needed');
        }
        if (!datatype || __datatypes_1_402.DataTypes.get(datatype)) {
            throw new _$errors_280.IllegalArgumentError('Data type required');
        }
        var selector = this.internal.getContext().parseSelector(topic);
        return _$valueStreamProxy_407.create(this.streamRegistry, datatype, false, selector);
    };
    TopicsImpl.prototype.addFallbackStream = function (datatype) {
        if (!datatype || __datatypes_1_402.DataTypes.get(datatype)) {
            throw new _$errors_280.IllegalArgumentError('Data type required');
        }
        return _$valueStreamProxy_407.create(this.streamRegistry, datatype, true);
    };
    return TopicsImpl;
}(_$stream_354.StreamImpl));
_$topics_402.TopicsImpl = TopicsImpl;

var _$clientControl_355 = {};
"use strict";
var ____awaiter_355 = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var ____generator_355 = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var ____values_355 = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var ____read_355 = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var ____spreadArray_355 = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(_$clientControl_355, "__esModule", { value: true });
_$clientControl_355.ClientControlImpl = void 0;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
var __log_355 = _$logger_752.create('Session.Clients');
function sessionStateFromSessionPropertiesEvent(event) {
    switch (event.type) {
        case _$sessionPropertiesEventType_490.SessionPropertiesEventType.CLOSE:
            return _$clientControl_282.SessionState.CLOSED;
        case _$sessionPropertiesEventType_490.SessionPropertiesEventType.OPEN:
            return _$clientControl_282.SessionState.ACTIVE;
        case _$sessionPropertiesEventType_490.SessionPropertiesEventType.UPDATE:
        default:
            switch (event.updateType) {
                case _$clientControl_282.SessionEventType.DISCONNECTED:
                    return _$clientControl_282.SessionState.DISCONNECTED;
                case _$clientControl_282.SessionEventType.FAILED_OVER:
                    return _$clientControl_282.SessionState.FAILED_OVER;
                case _$clientControl_282.SessionEventType.RECONNECTED:
                    return _$clientControl_282.SessionState.RECONNECTED;
                case _$clientControl_282.SessionEventType.UPDATED:
                default:
                    return _$clientControl_282.SessionState.ACTIVE;
            }
    }
}
function sessionEventFromSessionPropertiesEvent(event) {
    return {
        sessionId: event.sessionId,
        type: event.type === _$sessionPropertiesEventType_490.SessionPropertiesEventType.UPDATE ?
            _$clientControl_282.SessionEventStreamEventType.PROPERTIES :
            _$clientControl_282.SessionEventStreamEventType.STATE,
        properties: event.type !== _$sessionPropertiesEventType_490.SessionPropertiesEventType.UPDATE ?
            event.oldProperties :
            event.newProperties,
        state: sessionStateFromSessionPropertiesEvent(event),
        changedProperties: event.type === _$sessionPropertiesEventType_490.SessionPropertiesEventType.UPDATE ?
            event.oldProperties :
            {},
        closeReason: event.type === _$sessionPropertiesEventType_490.SessionPropertiesEventType.CLOSE ? event.closeReason : undefined,
        isOpenEvent: function () {
            return this.type === _$clientControl_282.SessionEventStreamEventType.STATE && this.state === _$clientControl_282.SessionState.ACTIVE;
        }
    };
}
var ClientControlImpl =  (function () {
    function ClientControlImpl(internal) {
        this.SessionEventType = _$clientControl_282.SessionEventType;
        this.internal = internal;
        this.serviceLocator = internal.getServiceLocator();
        this.SET_CLIENT_CONFLATION = this.serviceLocator.obtain(_$clientControlServices_441.SET_CLIENT_CONFLATION);
        this.SET_CLIENT_CONFLATION_FILTER = this.serviceLocator.obtain(_$clientControlServices_441.SET_CLIENT_CONFLATION_FILTER);
        this.GET_SESSION_PROPERTIES = this.serviceLocator.obtain(_$clientControlServices_441.GET_SESSION_PROPERTIES);
        this.SESSION_PROPERTIES_REGISTRATION = this.serviceLocator.obtain(_$clientControlServices_441.SESSION_PROPERTIES_REGISTRATION_2);
        this.CHANGE_AUTHORISATION_ROLES = this.serviceLocator.obtain(_$clientControlServices_441.CHANGE_AUTHORISATION_ROLES);
        this.CHANGE_AUTHORISATION_ROLES_FILTER = this.serviceLocator.obtain(_$clientControlServices_441.CHANGE_AUTHORISATION_ROLES_FILTER);
        this.SET_SESSION_PROPERTIES_FILTER = this.serviceLocator.obtain(_$clientControlServices_441.SET_SESSION_PROPERTIES_FILTER);
        this.SESSION_EVENT_REGISTRATION = this.serviceLocator.obtain(_$clientControlServices_441.SESSION_EVENT_REGISTRATION);
        this.SESSION_EVENT_DEREGISTRATION = this.serviceLocator.obtain(_$clientControlServices_441.SESSION_EVENT_DEREGISTRATION);
        this.GET_SESSION_LOCK = this.serviceLocator.obtain(_$clientControlServices_441.GET_SESSION_LOCK);
        this.GET_SESSION_LOCKS = this.serviceLocator.obtain(_$clientControlServices_441.GET_SESSION_LOCKS);
        this.internal.getServiceRegistry().add(_$clientControlServices_441.SESSION_PROPERTIES_EVENT_2, {
            onRequest: function (internalSession, message, callback) {
                internalSession.getConversationSet().respondIfPresent(message.cid, message);
                callback.respond();
            }
        });
    }
    ClientControlImpl.prototype.close = function (sessions) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            try {
                _$requireNonNull_759.requireNonNull(sessions, 'sessions');
            }
            catch (e) {
                reject(e);
                return;
            }
            if (_this.internal.checkConnected(reject)) {
                var sessionID = _$sessionId_709.SessionId.validate(sessions);
                if (sessionID) {
                    _this.serviceLocator.obtain(_$clientControlServices_441.CLOSE_CLIENT).send({
                        sessionID: sessionID
                    }, function (err, response) {
                        if (err) {
                            reject(err);
                        }
                        else {
                            resolve(1);
                        }
                    });
                }
                else if (typeof sessions === 'string') {
                    _this.serviceLocator.obtain(_$clientControlServices_441.CLOSE_CLIENT_FILTER).send(sessions, function (err, response) {
                        if (!_$responseSuccess_760.responseSuccess(err, response)) {
                            reject(err);
                        }
                        else if (response.errors.length > 0) {
                            reject(response.errors);
                        }
                        else {
                            resolve(response.count);
                        }
                    });
                }
                else {
                    reject(new Error("Invalid SessionID: " + sessions));
                }
            }
        });
    };
    ClientControlImpl.prototype.subscribe = function (session, path, scope) {
        var _this = this;
        if (scope === void 0) { scope = _$topics_402.DEFAULT_TOPIC_SELECTION_SCOPE; }
        return new Promise(function (resolve, reject) {
            try {
                _$requireNonNull_759.requireNonNull(session, 'SessionID or Session Filter');
                _$requireNonNull_759.requireNonNull(path, 'Topic Selector');
                _$validateSelectionScope_763.validateSelectionScope(scope);
            }
            catch (e) {
                reject(e);
                return;
            }
            if (_this.internal.checkConnected(reject)) {
                var selector = void 0;
                try {
                    selector = _this.internal.getContext().parseSelector(path);
                }
                catch (e) {
                    reject(e);
                    return;
                }
                var sessionID = _$sessionId_709.SessionId.validate(session);
                if (sessionID) {
                    _this.serviceLocator.obtain(_$clientControlServices_441.SUBSCRIBE_CLIENT).send({
                        sessionID: sessionID,
                        selector: selector,
                        scope: scope
                    }, function (err) {
                        if (err) {
                            reject(err);
                        }
                        else {
                            resolve();
                        }
                    });
                }
                else {
                    _this.serviceLocator.obtain(_$clientControlServices_441.FILTER_SUBSCRIBE).send({
                        filter: session,
                        selector: selector,
                        scope: scope
                    }, function (err, response) {
                        if (!_$responseSuccess_760.responseSuccess(err, response)) {
                            reject(err);
                        }
                        else if (response.isSuccess()) {
                            resolve(response.selected);
                        }
                        else {
                            reject(response.errors);
                        }
                    });
                }
            }
        });
    };
    ClientControlImpl.prototype.unsubscribe = function (session, path, scope) {
        var _this = this;
        if (scope === void 0) { scope = _$topics_402.DEFAULT_TOPIC_SELECTION_SCOPE; }
        return new Promise(function (resolve, reject) {
            try {
                _$requireNonNull_759.requireNonNull(session, 'SessionID or Session Filter');
                _$requireNonNull_759.requireNonNull(path, 'Topic Selector');
                _$validateSelectionScope_763.validateSelectionScope(scope);
            }
            catch (e) {
                reject(e);
                return;
            }
            if (_this.internal.checkConnected(reject)) {
                var selector = void 0;
                try {
                    selector = _this.internal.getCon